/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.web;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.security.oauth2.client.web.AuthorizationRequestRepository;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;
import org.springframework.util.Assert;

public final class HttpSessionOAuth2AuthorizationRequestRepository
implements AuthorizationRequestRepository<OAuth2AuthorizationRequest> {
    private static final String DEFAULT_AUTHORIZATION_REQUEST_ATTR_NAME = HttpSessionOAuth2AuthorizationRequestRepository.class.getName() + ".AUTHORIZATION_REQUEST";
    private final String sessionAttributeName = DEFAULT_AUTHORIZATION_REQUEST_ATTR_NAME;

    @Override
    public OAuth2AuthorizationRequest loadAuthorizationRequest(HttpServletRequest request) {
        Assert.notNull((Object)request, (String)"request cannot be null");
        String stateParameter = this.getStateParameter(request);
        if (stateParameter == null) {
            return null;
        }
        Map<String, OAuth2AuthorizationRequest> authorizationRequests = this.getAuthorizationRequests(request);
        return authorizationRequests.get(stateParameter);
    }

    @Override
    public void saveAuthorizationRequest(OAuth2AuthorizationRequest authorizationRequest, HttpServletRequest request, HttpServletResponse response) {
        Assert.notNull((Object)request, (String)"request cannot be null");
        Assert.notNull((Object)response, (String)"response cannot be null");
        if (authorizationRequest == null) {
            this.removeAuthorizationRequest(request, response);
            return;
        }
        String state = authorizationRequest.getState();
        Assert.hasText((String)state, (String)"authorizationRequest.state cannot be empty");
        Map<String, OAuth2AuthorizationRequest> authorizationRequests = this.getAuthorizationRequests(request);
        authorizationRequests.put(state, authorizationRequest);
        request.getSession().setAttribute(this.sessionAttributeName, authorizationRequests);
    }

    @Override
    public OAuth2AuthorizationRequest removeAuthorizationRequest(HttpServletRequest request) {
        Assert.notNull((Object)request, (String)"request cannot be null");
        String stateParameter = this.getStateParameter(request);
        if (stateParameter == null) {
            return null;
        }
        Map<String, OAuth2AuthorizationRequest> authorizationRequests = this.getAuthorizationRequests(request);
        OAuth2AuthorizationRequest originalRequest = authorizationRequests.remove(stateParameter);
        if (!authorizationRequests.isEmpty()) {
            request.getSession().setAttribute(this.sessionAttributeName, authorizationRequests);
        } else {
            request.getSession().removeAttribute(this.sessionAttributeName);
        }
        return originalRequest;
    }

    @Override
    public OAuth2AuthorizationRequest removeAuthorizationRequest(HttpServletRequest request, HttpServletResponse response) {
        Assert.notNull((Object)response, (String)"response cannot be null");
        return this.removeAuthorizationRequest(request);
    }

    private String getStateParameter(HttpServletRequest request) {
        return request.getParameter("state");
    }

    private Map<String, OAuth2AuthorizationRequest> getAuthorizationRequests(HttpServletRequest request) {
        Map authorizationRequests;
        HttpSession session = request.getSession(false);
        Map map = authorizationRequests = session != null ? (Map)session.getAttribute(this.sessionAttributeName) : null;
        if (authorizationRequests == null) {
            return new HashMap<String, OAuth2AuthorizationRequest>();
        }
        return authorizationRequests;
    }
}

