/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.cluster;

import EDU.oswego.cs.dl.util.concurrent.Latch;
import EDU.oswego.cs.dl.util.concurrent.Mutex;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.cluster.ChangeLogRecord;
import org.apache.jackrabbit.core.cluster.ClusterContext;
import org.apache.jackrabbit.core.cluster.ClusterException;
import org.apache.jackrabbit.core.cluster.ClusterOperation;
import org.apache.jackrabbit.core.cluster.ClusterRecord;
import org.apache.jackrabbit.core.cluster.ClusterRecordDeserializer;
import org.apache.jackrabbit.core.cluster.ClusterRecordProcessor;
import org.apache.jackrabbit.core.cluster.DefaultClusterOperation;
import org.apache.jackrabbit.core.cluster.LockEventChannel;
import org.apache.jackrabbit.core.cluster.LockEventListener;
import org.apache.jackrabbit.core.cluster.LockRecord;
import org.apache.jackrabbit.core.cluster.NamespaceEventChannel;
import org.apache.jackrabbit.core.cluster.NamespaceEventListener;
import org.apache.jackrabbit.core.cluster.NamespaceRecord;
import org.apache.jackrabbit.core.cluster.NodeTypeEventChannel;
import org.apache.jackrabbit.core.cluster.NodeTypeEventListener;
import org.apache.jackrabbit.core.cluster.NodeTypeRecord;
import org.apache.jackrabbit.core.cluster.Update;
import org.apache.jackrabbit.core.cluster.UpdateEventChannel;
import org.apache.jackrabbit.core.cluster.UpdateEventListener;
import org.apache.jackrabbit.core.cluster.WorkspaceEventChannel;
import org.apache.jackrabbit.core.cluster.WorkspaceListener;
import org.apache.jackrabbit.core.cluster.WorkspaceRecord;
import org.apache.jackrabbit.core.config.ClusterConfig;
import org.apache.jackrabbit.core.config.ConfigurationException;
import org.apache.jackrabbit.core.config.JournalConfig;
import org.apache.jackrabbit.core.journal.AbstractJournal;
import org.apache.jackrabbit.core.journal.InstanceRevision;
import org.apache.jackrabbit.core.journal.Journal;
import org.apache.jackrabbit.core.journal.JournalException;
import org.apache.jackrabbit.core.journal.Record;
import org.apache.jackrabbit.core.journal.RecordConsumer;
import org.apache.jackrabbit.core.journal.RecordProducer;
import org.apache.jackrabbit.core.nodetype.InvalidNodeTypeDefException;
import org.apache.jackrabbit.core.nodetype.NodeTypeDef;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.apache.jackrabbit.core.xml.ClonedInputSource;
import org.apache.jackrabbit.uuid.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterNode
implements Runnable,
NamespaceEventChannel,
NodeTypeEventChannel,
RecordConsumer,
ClusterRecordProcessor,
WorkspaceEventChannel {
    public static final String SYSTEM_PROPERTY_NODE_ID = "org.apache.jackrabbit.core.cluster.node_id";
    private static final String CLUSTER_NODE_ID_FILE = "cluster_node.id";
    private static final String PRODUCER_ID = "JR";
    private static final int NONE = 0;
    private static final int STARTED = 1;
    private static final int STOPPED = 2;
    private static Logger log = LoggerFactory.getLogger((Class)ClusterNode.class);
    private ClusterContext clusterContext;
    private String clusterNodeId;
    private long syncDelay;
    private long stopDelay;
    private Journal journal;
    private Thread syncThread;
    private final Mutex syncLock = new Mutex();
    private final Latch stopLatch = new Latch();
    private int status;
    private final Map wspLockListeners = new HashMap();
    private final Map wspUpdateListeners = new HashMap();
    private UpdateEventListener versionUpdateListener;
    private NamespaceEventListener namespaceListener;
    private WorkspaceListener createWorkspaceListener;
    private NodeTypeEventListener nodeTypeListener;
    private InstanceRevision instanceRevision;
    private RecordProducer producer;
    private ClusterRecordDeserializer deserializer = new ClusterRecordDeserializer();

    public void init(ClusterContext clusterContext) throws ClusterException {
        this.clusterContext = clusterContext;
        this.init();
    }

    protected void init() throws ClusterException {
        ClusterConfig cc = this.clusterContext.getClusterConfig();
        this.clusterNodeId = this.getClusterNodeId(cc.getId());
        this.syncDelay = cc.getSyncDelay();
        try {
            JournalConfig jc = cc.getJournalConfig();
            this.journal = (Journal)jc.newInstance();
            this.setRepositoryHome(this.journal, this.clusterContext.getRepositoryHome());
            this.journal.init(this.clusterNodeId, this.clusterContext.getNamespaceResolver());
            this.instanceRevision = this.journal.getInstanceRevision();
            this.journal.register(this);
            this.producer = this.journal.getProducer(PRODUCER_ID);
        }
        catch (ConfigurationException e) {
            throw new ClusterException(e.getMessage(), e.getCause());
        }
        catch (JournalException e) {
            throw new ClusterException(e.getMessage(), e.getCause());
        }
    }

    private void setRepositoryHome(Journal journal, File repHome) {
        if (journal instanceof AbstractJournal) {
            AbstractJournal aj = (AbstractJournal)journal;
            aj.setRepositoryHome(repHome);
        }
    }

    public void setStopDelay(long stopDelay) {
        this.stopDelay = stopDelay;
    }

    public long getStopDelay() {
        return this.stopDelay;
    }

    public synchronized void start() throws ClusterException {
        if (this.status == 0) {
            this.sync();
            Thread t = new Thread((Runnable)this, "ClusterNode-" + this.clusterNodeId);
            t.setDaemon(true);
            t.start();
            this.syncThread = t;
            this.status = 1;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        while (true) {
            String msg;
            try {
                if (this.stopLatch.attempt(this.syncDelay)) {
                    return;
                }
            }
            catch (InterruptedException e) {
                msg = "Interrupted while waiting for stop latch.";
                log.warn(msg);
            }
            try {
                this.sync();
                continue;
            }
            catch (ClusterException e) {
                msg = "Periodic sync of journal failed: " + e.getMessage();
                log.error(msg, (Throwable)e);
                continue;
            }
            catch (Exception e) {
                msg = "Unexpected error while syncing of journal: " + e.getMessage();
                log.error(msg, (Throwable)e);
                continue;
            }
            catch (Error e) {
                msg = "Unexpected error while syncing of journal: " + e.getMessage();
                log.error(msg, (Throwable)e);
                throw e;
            }
            break;
        }
    }

    public void sync() throws ClusterException {
        try {
            this.syncLock.acquire();
        }
        catch (InterruptedException e) {
            String msg = "Interrupted while waiting for mutex.";
            throw new ClusterException(msg);
        }
        try {
            this.journal.sync();
        }
        catch (JournalException e) {
            throw new ClusterException(e.getMessage(), e.getCause());
        }
        finally {
            this.syncLock.release();
        }
    }

    public synchronized void stop() {
        if (this.status != 2) {
            this.status = 2;
            this.stopLatch.release();
            if (this.syncThread != null) {
                try {
                    this.syncThread.join(this.stopDelay);
                }
                catch (InterruptedException e) {
                    String msg = "Interrupted while joining synchronization thread.";
                    log.warn(msg);
                }
            }
            if (this.journal != null) {
                this.journal.close();
            }
            if (this.instanceRevision != null) {
                this.instanceRevision.close();
            }
        }
    }

    public UpdateEventChannel createUpdateChannel(String workspace) {
        return new WorkspaceUpdateChannel(workspace);
    }

    public LockEventChannel createLockChannel(String workspace) {
        return new WorkspaceLockChannel(workspace);
    }

    public Journal getJournal() {
        return this.journal;
    }

    private String getClusterNodeId(String id) throws ClusterException {
        if (id == null && (id = System.getProperty(SYSTEM_PROPERTY_NODE_ID)) == null) {
            try {
                id = this.getClusterNodeIdFromFile();
            }
            catch (IOException e) {
                throw new ClusterException(e.getMessage(), e.getCause());
            }
        }
        return id;
    }

    protected String getClusterNodeIdFromFile() throws IOException {
        String filename = this.clusterContext.getRepositoryHome() + File.separator + CLUSTER_NODE_ID_FILE;
        File f = new File(filename);
        if (f.exists() && f.canRead()) {
            return FileUtils.readFileToString((File)f);
        }
        String id = UUID.randomUUID().toString();
        FileUtils.writeStringToFile((File)f, (String)id);
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remapped(String oldPrefix, String newPrefix, String uri) {
        if (this.status != 1) {
            log.info("not started: namespace operation ignored.");
            return;
        }
        ClusterRecord record = null;
        boolean succeeded = false;
        try {
            record = new NamespaceRecord(oldPrefix, newPrefix, uri, this.producer.append());
            record.write();
            record.update();
            this.setRevision(record.getRevision());
            succeeded = true;
        }
        catch (JournalException e) {
            String msg = "Unable to create log entry: " + e.getMessage();
            log.error(msg);
        }
        catch (Throwable e) {
            String msg = "Unexpected error while creating log entry.";
            log.error(msg, e);
        }
        finally {
            if (!succeeded && record != null) {
                record.cancelUpdate();
            }
        }
    }

    public void setListener(NamespaceEventListener listener) {
        this.namespaceListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registered(Collection ntDefs) {
        if (this.status != 1) {
            log.info("not started: nodetype operation ignored.");
            return;
        }
        ClusterRecord record = null;
        boolean succeeded = false;
        try {
            record = new NodeTypeRecord(ntDefs, true, this.producer.append());
            record.write();
            record.update();
            this.setRevision(record.getRevision());
            succeeded = true;
        }
        catch (JournalException e) {
            String msg = "Unable to create log entry: " + e.getMessage();
            log.error(msg);
        }
        catch (Throwable e) {
            String msg = "Unexpected error while creating log entry.";
            log.error(msg, e);
        }
        finally {
            if (!succeeded && record != null) {
                record.cancelUpdate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reregistered(NodeTypeDef ntDef) {
        if (this.status != 1) {
            log.info("not started: nodetype operation ignored.");
            return;
        }
        NodeTypeRecord record = null;
        boolean succeeded = false;
        try {
            record = new NodeTypeRecord(ntDef, this.producer.append());
            record.write();
            record.update();
            this.setRevision(record.getRevision());
            succeeded = true;
        }
        catch (JournalException e) {
            String msg = "Unable to create log entry: " + e.getMessage();
            log.error(msg);
        }
        catch (Throwable e) {
            String msg = "Unexpected error while creating log entry.";
            log.error(msg, e);
        }
        finally {
            if (!succeeded && record != null) {
                record.cancelUpdate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregistered(Collection qnames) {
        if (this.status != 1) {
            log.info("not started: nodetype operation ignored.");
            return;
        }
        ClusterRecord record = null;
        boolean succeeded = false;
        try {
            record = new NodeTypeRecord(qnames, false, this.producer.append());
            record.write();
            record.update();
            this.setRevision(record.getRevision());
            succeeded = true;
        }
        catch (JournalException e) {
            String msg = "Unable to create log entry: " + e.getMessage();
            log.error(msg);
        }
        catch (Throwable e) {
            String msg = "Unexpected error while creating log entry.";
            log.error(msg, e);
        }
        finally {
            if (!succeeded && record != null) {
                record.cancelUpdate();
            }
        }
    }

    public void setListener(NodeTypeEventListener listener) {
        this.nodeTypeListener = listener;
    }

    public String getId() {
        return PRODUCER_ID;
    }

    public long getRevision() {
        try {
            return this.instanceRevision.get();
        }
        catch (JournalException e) {
            log.warn("Unable to return current revision.", (Throwable)e);
            return Long.MAX_VALUE;
        }
    }

    public void consume(Record record) {
        log.info("Processing revision: " + record.getRevision());
        try {
            this.deserializer.deserialize(record).process(this);
        }
        catch (JournalException e) {
            String msg = "Unable to read revision '" + record.getRevision() + "'.";
            log.error(msg, (Throwable)e);
        }
    }

    public void setRevision(long revision) {
        try {
            this.instanceRevision.set(revision);
        }
        catch (JournalException e) {
            log.warn("Unable to set current revision to " + revision + ".", (Throwable)e);
        }
    }

    public void process(ChangeLogRecord record) {
        String msg;
        String workspace = record.getWorkspace();
        UpdateEventListener listener = null;
        if (workspace != null) {
            listener = (UpdateEventListener)this.wspUpdateListeners.get(workspace);
            if (listener == null) {
                try {
                    this.clusterContext.updateEventsReady(workspace);
                }
                catch (RepositoryException e) {
                    msg = "Error making update listener for workspace " + workspace + " online: " + e.getMessage();
                    log.warn(msg);
                }
                listener = (UpdateEventListener)this.wspUpdateListeners.get(workspace);
                if (listener == null) {
                    String msg2 = "Update listener unavailable for workspace: " + workspace;
                    log.error(msg2);
                    return;
                }
            }
        } else if (this.versionUpdateListener != null) {
            listener = this.versionUpdateListener;
        } else {
            String msg3 = "Version update listener unavailable.";
            log.error(msg3);
            return;
        }
        try {
            listener.externalUpdate(record.getChanges(), record.getEvents());
        }
        catch (RepositoryException e) {
            msg = "Unable to deliver update events: " + e.getMessage();
            log.error(msg);
        }
    }

    public void process(LockRecord record) {
        String msg;
        String workspace = record.getWorkspace();
        LockEventListener listener = (LockEventListener)this.wspLockListeners.get(workspace);
        if (listener == null) {
            try {
                this.clusterContext.lockEventsReady(workspace);
            }
            catch (RepositoryException e) {
                msg = "Unable to make lock listener for workspace " + workspace + " online: " + e.getMessage();
                log.warn(msg);
            }
            listener = (LockEventListener)this.wspLockListeners.get(workspace);
            if (listener == null) {
                String msg2 = "Lock channel unavailable for workspace: " + workspace;
                log.error(msg2);
                return;
            }
        }
        try {
            if (record.isLock()) {
                listener.externalLock(record.getNodeId(), record.isDeep(), record.getUserId());
            } else {
                listener.externalUnlock(record.getNodeId());
            }
        }
        catch (RepositoryException e) {
            msg = "Unable to deliver lock event: " + e.getMessage();
            log.error(msg);
        }
    }

    public void process(NamespaceRecord record) {
        if (this.namespaceListener == null) {
            String msg = "Namespace listener unavailable.";
            log.error(msg);
            return;
        }
        try {
            this.namespaceListener.externalRemap(record.getOldPrefix(), record.getNewPrefix(), record.getUri());
        }
        catch (RepositoryException e) {
            String msg = "Unable to deliver namespace operation: " + e.getMessage();
            log.error(msg);
        }
    }

    public void process(NodeTypeRecord record) {
        if (this.nodeTypeListener == null) {
            String msg = "NodeType listener unavailable.";
            log.error(msg);
            return;
        }
        Collection coll = record.getCollection();
        try {
            switch (record.getOperation()) {
                case 1: {
                    this.nodeTypeListener.externalRegistered(coll);
                    break;
                }
                case 3: {
                    this.nodeTypeListener.externalUnregistered(coll);
                    break;
                }
                case 2: {
                    NodeTypeDef ntd = (NodeTypeDef)coll.iterator().next();
                    this.nodeTypeListener.externalReregistered(ntd);
                }
            }
        }
        catch (InvalidNodeTypeDefException e) {
            String msg = "Unable to deliver node type operation: " + e.getMessage();
            log.error(msg);
        }
        catch (RepositoryException e) {
            String msg = "Unable to deliver node type operation: " + e.getMessage();
            log.error(msg);
        }
    }

    public void process(WorkspaceRecord record) {
        if (this.createWorkspaceListener == null) {
            String msg = "Create Workspace listener unavailable.";
            log.error(msg);
            return;
        }
        try {
            if (record.getActionType() == 1) {
                WorkspaceRecord.CreateWorkspaceAction action = record.getCreateWorkspaceAction();
                this.createWorkspaceListener.externalWorkspaceCreated(record.getWorkspace(), action.getInputSource());
            }
        }
        catch (RepositoryException e) {
            String msg = "Unable to create workspace: " + e.getMessage();
            log.error(msg);
        }
    }

    public void setListener(WorkspaceListener listener) {
        this.createWorkspaceListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void workspaceCreated(String workspaceName, ClonedInputSource inputSource) {
        if (this.status != 1) {
            log.info("not started: namespace operation ignored.");
            return;
        }
        ClusterRecord record = null;
        boolean succeeded = false;
        try {
            record = new WorkspaceRecord(workspaceName, inputSource, this.producer.append());
            record.write();
            record.update();
            this.setRevision(record.getRevision());
            succeeded = true;
        }
        catch (JournalException e) {
            String msg = "Unable to create log entry: " + e.getMessage();
            log.error(msg);
        }
        catch (Throwable e) {
            String msg = "Unexpected error while creating log entry.";
            log.error(msg, e);
        }
        finally {
            if (!succeeded && record != null) {
                record.cancelUpdate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ended(DefaultClusterOperation operation, boolean successful) {
        ClusterRecord record = operation.getRecord();
        boolean succeeded = false;
        try {
            if (successful) {
                record.write();
                record.update();
                this.setRevision(record.getRevision());
                succeeded = true;
            }
        }
        catch (JournalException e) {
            String msg = "Unable to create log entry: " + e.getMessage();
            log.error(msg);
        }
        catch (Throwable e) {
            String msg = "Unexpected error while creating log entry.";
            log.error(msg, e);
        }
        finally {
            if (!succeeded) {
                record.cancelUpdate();
            }
        }
    }

    class WorkspaceLockChannel
    implements LockEventChannel {
        private final String workspace;

        public WorkspaceLockChannel(String workspace) {
            this.workspace = workspace;
        }

        public ClusterOperation create(NodeId nodeId, boolean deep, String owner) {
            if (ClusterNode.this.status != 1) {
                log.info("not started: lock operation ignored.");
                return null;
            }
            try {
                LockRecord record = new LockRecord(nodeId, deep, owner, ClusterNode.this.producer.append(), this.workspace);
                return new DefaultClusterOperation(ClusterNode.this, record);
            }
            catch (JournalException e) {
                String msg = "Unable to create log entry: " + e.getMessage();
                log.error(msg);
                return null;
            }
            catch (Throwable e) {
                String msg = "Unexpected error while creating log entry.";
                log.error(msg, e);
                return null;
            }
        }

        public ClusterOperation create(NodeId nodeId) {
            if (ClusterNode.this.status != 1) {
                log.info("not started: unlock operation ignored.");
                return null;
            }
            try {
                LockRecord record = new LockRecord(nodeId, ClusterNode.this.producer.append(), this.workspace);
                return new DefaultClusterOperation(ClusterNode.this, record);
            }
            catch (JournalException e) {
                String msg = "Unable to create log entry: " + e.getMessage();
                log.error(msg);
                return null;
            }
            catch (Throwable e) {
                String msg = "Unexpected error while creating log entry.";
                log.error(msg, e);
                return null;
            }
        }

        public void setListener(LockEventListener listener) {
            ClusterNode.this.wspLockListeners.remove(this.workspace);
            if (listener != null) {
                ClusterNode.this.wspLockListeners.put(this.workspace, listener);
            }
        }
    }

    class WorkspaceUpdateChannel
    implements UpdateEventChannel {
        private static final String ATTRIBUTE_RECORD = "record";
        private final String workspace;

        public WorkspaceUpdateChannel(String workspace) {
            this.workspace = workspace;
        }

        public void updateCreated(Update update) {
            if (ClusterNode.this.status != 1) {
                log.info("not started: update create ignored.");
                return;
            }
            try {
                Record record = ClusterNode.this.producer.append();
                update.setAttribute(ATTRIBUTE_RECORD, record);
            }
            catch (JournalException e) {
                String msg = "Unable to create log entry.";
                log.error(msg, (Throwable)e);
            }
            catch (Throwable e) {
                String msg = "Unexpected error while creating log entry.";
                log.error(msg, e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updatePrepared(Update update) {
            if (ClusterNode.this.status != 1) {
                log.info("not started: update prepare ignored.");
                return;
            }
            Record record = (Record)update.getAttribute(ATTRIBUTE_RECORD);
            if (record == null) {
                String msg = "No record created.";
                log.warn(msg);
                return;
            }
            List events = update.getEvents();
            ChangeLog changes = update.getChanges();
            boolean succeeded = false;
            try {
                ChangeLogRecord clr = new ChangeLogRecord(changes, events, record, this.workspace);
                clr.write();
                succeeded = true;
            }
            catch (JournalException e) {
                String msg = "Unable to create log entry: " + e.getMessage();
                log.error(msg);
            }
            catch (Throwable e) {
                String msg = "Unexpected error while preparing log entry.";
                log.error(msg, e);
            }
            finally {
                if (!succeeded && record != null) {
                    record.cancelUpdate();
                    update.setAttribute(ATTRIBUTE_RECORD, null);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateCommitted(Update update) {
            if (ClusterNode.this.status != 1) {
                log.info("not started: update commit ignored.");
                return;
            }
            Record record = (Record)update.getAttribute(ATTRIBUTE_RECORD);
            if (record == null) {
                String msg = "No record prepared.";
                log.warn(msg);
                return;
            }
            try {
                record.update();
                ClusterNode.this.setRevision(record.getRevision());
                log.debug("Appended revision: {}", (Object)new Long(record.getRevision()));
            }
            catch (JournalException e) {
                String msg = "Unable to commit log entry.";
                log.error(msg, (Throwable)e);
            }
            catch (Throwable e) {
                String msg = "Unexpected error while committing log entry.";
                log.error(msg, e);
            }
            finally {
                update.setAttribute(ATTRIBUTE_RECORD, null);
            }
        }

        public void updateCancelled(Update update) {
            if (ClusterNode.this.status != 1) {
                log.info("not started: update cancel ignored.");
                return;
            }
            Record record = (Record)update.getAttribute(ATTRIBUTE_RECORD);
            if (record != null) {
                record.cancelUpdate();
                update.setAttribute(ATTRIBUTE_RECORD, null);
            }
        }

        public void setListener(UpdateEventListener listener) {
            if (this.workspace == null) {
                ClusterNode.this.versionUpdateListener = listener;
            } else {
                ClusterNode.this.wspUpdateListeners.remove(this.workspace);
                if (listener != null) {
                    ClusterNode.this.wspUpdateListeners.put(this.workspace, listener);
                }
            }
        }
    }
}

