import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {formatDateTime} from '../../utils';
import moment from 'moment';

export class DisplayDateComponent extends Component {
    static propTypes = {
        color: PropTypes.string,
        date: PropTypes.number.isRequired,
        dateFormat: PropTypes.string,
        isLink: PropTypes.bool,
        timeFormat: PropTypes.string
    };

    static defaultProps = {
        dateFormat: 'YYYY-MM-DD',
        timeFormat: 'h:mm A'
    };

    constructor(props) {
        super(props);
    }

    render() {
        const {date, dateFormat, isLink, color, timeFormat} = this.props;
        const format = formatDateTime(date, dateFormat, timeFormat);

        const style = {
            color: color || '#414C58'
        };

        if (isLink) {
            return <a href={`#/calendar?has_filter&date=${moment(date).format('YYYY-MM-DD')}`}
                      style={style}>{format}</a>;
        }
        return <span style={style}>{format}</span>;
    }
}
