/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.security;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.security.permission.PermissionHandler;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class XLReleasePermissions
extends PlatformPermissions {
    public static final Permission CREATE_TEMPLATE = Permission.definePermission((String)"template#create", (PermissionHandler.Level)PermissionHandler.Level.GLOBAL);
    public static final Permission CREATE_RELEASE = Permission.definePermission((String)"release#create", (PermissionHandler.Level)PermissionHandler.Level.GLOBAL);
    public static final Permission VIEW_REPORTS = Permission.definePermission((String)"reports#view", (PermissionHandler.Level)PermissionHandler.Level.GLOBAL);
    public static final Permission AUDIT_ALL = Permission.definePermission((String)"all#audit", (PermissionHandler.Level)PermissionHandler.Level.GLOBAL);
    public static final Permission CREATE_DASHBOARD = Permission.definePermission((String)"dashboard#create", (PermissionHandler.Level)PermissionHandler.Level.GLOBAL);
    public static final Permission EDIT_GLOBAL_VARIABLES = Permission.definePermission((String)"global_variables#edit", (PermissionHandler.Level)PermissionHandler.Level.GLOBAL);
    public static final Permission CREATE_TOP_LEVEL_FOLDER = Permission.definePermission((String)"folder#create_top_level", (PermissionHandler.Level)PermissionHandler.Level.GLOBAL);
    public static final Permission EDIT_GLOBAL_BLACKOUT = Permission.definePermission((String)"global_calendar#edit_blackout", (PermissionHandler.Level)PermissionHandler.Level.GLOBAL);
    public static final Permission EDIT_RISK_PROFILE = Permission.definePermission((String)"risk_profile#edit", (PermissionHandler.Level)PermissionHandler.Level.GLOBAL);
    public static final Permission EDIT_ENVIRONMENT = Permission.definePermission((String)"environment#edit", (PermissionHandler.Level)PermissionHandler.Level.GLOBAL);
    public static final Permission VIEW_ENVIRONMENT = Permission.definePermission((String)"environment#view", (PermissionHandler.Level)PermissionHandler.Level.GLOBAL);
    public static final Permission EDIT_APPLICATION = Permission.definePermission((String)"application#edit", (PermissionHandler.Level)PermissionHandler.Level.GLOBAL);
    public static final Permission VIEW_APPLICATION = Permission.definePermission((String)"application#view", (PermissionHandler.Level)PermissionHandler.Level.GLOBAL);
    public static final Permission EDIT_RESERVATION = Permission.definePermission((String)"reservation#edit", (PermissionHandler.Level)PermissionHandler.Level.GLOBAL);
    public static final Permission CREATE_RELEASE_FROM_TEMPLATE = Permission.definePermission((String)"template#create_release", (PermissionHandler.Level)PermissionHandler.Level.CI, (Metadata.ConfigurationItemRoot)Metadata.ConfigurationItemRoot.APPLICATIONS, (boolean)true);
    public static final Permission VIEW_TEMPLATE = Permission.definePermission((String)"template#view", (PermissionHandler.Level)PermissionHandler.Level.CI, (Metadata.ConfigurationItemRoot)Metadata.ConfigurationItemRoot.APPLICATIONS, (boolean)true);
    public static final Permission EDIT_TEMPLATE = Permission.definePermission((String)"template#edit", (PermissionHandler.Level)PermissionHandler.Level.CI, (Metadata.ConfigurationItemRoot)Metadata.ConfigurationItemRoot.APPLICATIONS, (boolean)true);
    public static final Permission EDIT_TEMPLATE_SECURITY = Permission.definePermission((String)"template#edit_security", (PermissionHandler.Level)PermissionHandler.Level.CI, (Metadata.ConfigurationItemRoot)Metadata.ConfigurationItemRoot.APPLICATIONS, (boolean)true);
    @Deprecated
    public static final Permission EDIT_TEMPLATE_TRIGGERS = Permission.definePermission((String)"template#edit_triggers", (PermissionHandler.Level)PermissionHandler.Level.CI, (Metadata.ConfigurationItemRoot)Metadata.ConfigurationItemRoot.APPLICATIONS, (boolean)true);
    public static final Permission VIEW_RELEASE = Permission.definePermission((String)"release#view", (PermissionHandler.Level)PermissionHandler.Level.CI, (Metadata.ConfigurationItemRoot)Metadata.ConfigurationItemRoot.APPLICATIONS, (boolean)true);
    public static final Permission EDIT_RELEASE = Permission.definePermission((String)"release#edit", (PermissionHandler.Level)PermissionHandler.Level.CI, (Metadata.ConfigurationItemRoot)Metadata.ConfigurationItemRoot.APPLICATIONS, (boolean)true);
    public static final Permission EDIT_RELEASE_SECURITY = Permission.definePermission((String)"release#edit_security", (PermissionHandler.Level)PermissionHandler.Level.CI, (Metadata.ConfigurationItemRoot)Metadata.ConfigurationItemRoot.APPLICATIONS, (boolean)true);
    public static final Permission START_RELEASE = Permission.definePermission((String)"release#start", (PermissionHandler.Level)PermissionHandler.Level.CI, (Metadata.ConfigurationItemRoot)Metadata.ConfigurationItemRoot.APPLICATIONS, (boolean)true);
    public static final Permission ABORT_RELEASE = Permission.definePermission((String)"release#abort", (PermissionHandler.Level)PermissionHandler.Level.CI, (Metadata.ConfigurationItemRoot)Metadata.ConfigurationItemRoot.APPLICATIONS, (boolean)true);
    public static final Permission EDIT_RELEASE_TASK = Permission.definePermission((String)"release#edit_task", (PermissionHandler.Level)PermissionHandler.Level.CI, (Metadata.ConfigurationItemRoot)Metadata.ConfigurationItemRoot.APPLICATIONS, (boolean)true);
    public static final Permission EDIT_RELEASE_TASK_SCRIPT = Permission.definePermission((String)"release#edit_task_script", (PermissionHandler.Level)PermissionHandler.Level.CI, (Metadata.ConfigurationItemRoot)Metadata.ConfigurationItemRoot.APPLICATIONS, (boolean)true);
    public static final Permission EDIT_RELEASE_TASK_CONFIGURATION = Permission.definePermission((String)"release#edit_task_input_output_properties", (PermissionHandler.Level)PermissionHandler.Level.CI, (Metadata.ConfigurationItemRoot)Metadata.ConfigurationItemRoot.APPLICATIONS, (boolean)true);
    public static final Permission EDIT_RELEASE_TASK_CONFIGURATION_FACET = Permission.definePermission((String)"release#edit_task_configuration_facet", (PermissionHandler.Level)PermissionHandler.Level.CI, (Metadata.ConfigurationItemRoot)Metadata.ConfigurationItemRoot.APPLICATIONS, (boolean)true);
    public static final Permission REASSIGN_RELEASE_TASK = Permission.definePermission((String)"release#reassign_task", (PermissionHandler.Level)PermissionHandler.Level.CI, (Metadata.ConfigurationItemRoot)Metadata.ConfigurationItemRoot.APPLICATIONS, (boolean)true);
    public static final Permission EDIT_BLACKOUT = Permission.definePermission((String)"release#edit_blackout", (PermissionHandler.Level)PermissionHandler.Level.CI, (Metadata.ConfigurationItemRoot)Metadata.ConfigurationItemRoot.APPLICATIONS, (boolean)true);
    public static final Permission TASK_TRANSITION = Permission.definePermission((String)"release#task_transition", (PermissionHandler.Level)PermissionHandler.Level.CI, (Metadata.ConfigurationItemRoot)Metadata.ConfigurationItemRoot.APPLICATIONS, (boolean)true);
    public static final Permission EDIT_TASK_TAGS = Permission.definePermission((String)"release#edit_task_tags", (PermissionHandler.Level)PermissionHandler.Level.CI, (Metadata.ConfigurationItemRoot)Metadata.ConfigurationItemRoot.APPLICATIONS, (boolean)true);
    public static final Permission EDIT_RELEASE_TASK_ATTACHMENT = Permission.definePermission((String)"release#edit_task_attachments", (PermissionHandler.Level)PermissionHandler.Level.CI, (Metadata.ConfigurationItemRoot)Metadata.ConfigurationItemRoot.APPLICATIONS, (boolean)true);
    public static final Permission EDIT_TASK_DESCRIPTION = Permission.definePermission((String)"release#edit_task_description", (PermissionHandler.Level)PermissionHandler.Level.CI, (Metadata.ConfigurationItemRoot)Metadata.ConfigurationItemRoot.APPLICATIONS, (boolean)true);
    public static final Permission EDIT_TASK_DATES = Permission.definePermission((String)"release#edit_task_dates", (PermissionHandler.Level)PermissionHandler.Level.CI, (Metadata.ConfigurationItemRoot)Metadata.ConfigurationItemRoot.APPLICATIONS, (boolean)true);
    public static final Permission EDIT_TASK_FLAG = Permission.definePermission((String)"release#edit_task_flag", (PermissionHandler.Level)PermissionHandler.Level.CI, (Metadata.ConfigurationItemRoot)Metadata.ConfigurationItemRoot.APPLICATIONS, (boolean)true);
    public static final Permission VIEW_FOLDER = Permission.definePermission((String)"folder#view", (PermissionHandler.Level)PermissionHandler.Level.CI, (Metadata.ConfigurationItemRoot)Metadata.ConfigurationItemRoot.APPLICATIONS, (boolean)true);
    public static final Permission EDIT_FOLDER = Permission.definePermission((String)"folder#edit", (PermissionHandler.Level)PermissionHandler.Level.CI, (Metadata.ConfigurationItemRoot)Metadata.ConfigurationItemRoot.APPLICATIONS, (boolean)true);
    public static final Permission EDIT_FOLDER_SECURITY = Permission.definePermission((String)"folder#edit_security", (PermissionHandler.Level)PermissionHandler.Level.CI, (Metadata.ConfigurationItemRoot)Metadata.ConfigurationItemRoot.APPLICATIONS, (boolean)true);
    public static final Permission EDIT_FOLDER_TEAMS = Permission.definePermission((String)"folder#edit_teams", (PermissionHandler.Level)PermissionHandler.Level.CI, (Metadata.ConfigurationItemRoot)Metadata.ConfigurationItemRoot.APPLICATIONS, (boolean)true);
    public static final Permission EDIT_FOLDER_NOTIFICATIONS = Permission.definePermission((String)"folder#edit_notifications", (PermissionHandler.Level)PermissionHandler.Level.CI, (Metadata.ConfigurationItemRoot)Metadata.ConfigurationItemRoot.APPLICATIONS, (boolean)true);
    public static final Permission EDIT_FOLDER_CONFIGURATION = Permission.definePermission((String)"folder#edit_configuration", (PermissionHandler.Level)PermissionHandler.Level.CI, (Metadata.ConfigurationItemRoot)Metadata.ConfigurationItemRoot.APPLICATIONS, (boolean)true);
    public static final Permission EDIT_FOLDER_VARIABLES = Permission.definePermission((String)"folder#edit_variables", (PermissionHandler.Level)PermissionHandler.Level.CI, (Metadata.ConfigurationItemRoot)Metadata.ConfigurationItemRoot.APPLICATIONS, (boolean)true);
    public static final Permission VIEW_FOLDER_VERSIONS = Permission.definePermission((String)"folder#view_versions", (PermissionHandler.Level)PermissionHandler.Level.CI, (Metadata.ConfigurationItemRoot)Metadata.ConfigurationItemRoot.APPLICATIONS, (boolean)true);
    public static final Permission EDIT_FOLDER_VERSIONS = Permission.definePermission((String)"folder#edit_versions", (PermissionHandler.Level)PermissionHandler.Level.CI, (Metadata.ConfigurationItemRoot)Metadata.ConfigurationItemRoot.APPLICATIONS, (boolean)true);
    public static final Permission VIEW_RELEASE_DELIVERY = Permission.definePermission((String)"delivery#view", (PermissionHandler.Level)PermissionHandler.Level.CI, (Metadata.ConfigurationItemRoot)Metadata.ConfigurationItemRoot.APPLICATIONS, (boolean)true);
    public static final Permission EDIT_RELEASE_DELIVERY = Permission.definePermission((String)"delivery#edit", (PermissionHandler.Level)PermissionHandler.Level.CI, (Metadata.ConfigurationItemRoot)Metadata.ConfigurationItemRoot.APPLICATIONS, (boolean)true);
    public static final Permission EDIT_DELIVERY_TRACKED_ITEM = Permission.definePermission((String)"delivery#edit_tracked_item", (PermissionHandler.Level)PermissionHandler.Level.CI, (Metadata.ConfigurationItemRoot)Metadata.ConfigurationItemRoot.APPLICATIONS, (boolean)true);
    public static final Permission VIEW_DELIVERY_PATTERN = Permission.definePermission((String)"delivery_pattern#view", (PermissionHandler.Level)PermissionHandler.Level.CI, (Metadata.ConfigurationItemRoot)Metadata.ConfigurationItemRoot.APPLICATIONS, (boolean)true);
    public static final Permission EDIT_DELIVERY_PATTERN = Permission.definePermission((String)"delivery_pattern#edit", (PermissionHandler.Level)PermissionHandler.Level.CI, (Metadata.ConfigurationItemRoot)Metadata.ConfigurationItemRoot.APPLICATIONS, (boolean)true);
    public static final Permission VIEW_RELEASE_GROUP = Permission.definePermission((String)"group#view", (PermissionHandler.Level)PermissionHandler.Level.CI, (Metadata.ConfigurationItemRoot)Metadata.ConfigurationItemRoot.APPLICATIONS, (boolean)true);
    public static final Permission EDIT_RELEASE_GROUP = Permission.definePermission((String)"group#edit", (PermissionHandler.Level)PermissionHandler.Level.CI, (Metadata.ConfigurationItemRoot)Metadata.ConfigurationItemRoot.APPLICATIONS, (boolean)true);
    public static final Permission LOCK_RELEASE_TASK = Permission.definePermission((String)"release#lock_task", (PermissionHandler.Level)PermissionHandler.Level.CI, (Metadata.ConfigurationItemRoot)Metadata.ConfigurationItemRoot.APPLICATIONS, (boolean)true);
    public static final Permission LOCK_TEMPLATE_TASK = Permission.definePermission((String)"template#lock_task", (PermissionHandler.Level)PermissionHandler.Level.CI, (Metadata.ConfigurationItemRoot)Metadata.ConfigurationItemRoot.APPLICATIONS, (boolean)true);
    public static final Permission VIEW_DASHBOARD = Permission.definePermission((String)"dashboard#view", (PermissionHandler.Level)PermissionHandler.Level.CI, (Metadata.ConfigurationItemRoot)Metadata.ConfigurationItemRoot.APPLICATIONS, (boolean)true);
    public static final Permission EDIT_DASHBOARD = Permission.definePermission((String)"dashboard#edit", (PermissionHandler.Level)PermissionHandler.Level.CI, (Metadata.ConfigurationItemRoot)Metadata.ConfigurationItemRoot.APPLICATIONS, (boolean)true);
    public static final Permission VIEW_TRIGGER = Permission.definePermission((String)"trigger#view_trigger", (PermissionHandler.Level)PermissionHandler.Level.CI, (Metadata.ConfigurationItemRoot)Metadata.ConfigurationItemRoot.APPLICATIONS, (boolean)true);
    public static final Permission EDIT_TRIGGER = Permission.definePermission((String)"trigger#edit_trigger", (PermissionHandler.Level)PermissionHandler.Level.CI, (Metadata.ConfigurationItemRoot)Metadata.ConfigurationItemRoot.APPLICATIONS, (boolean)true);
    public static final Permission EDIT_RELEASE_FAILURE_HANDLER = Permission.definePermission((String)"release#edit_failure_handler", (PermissionHandler.Level)PermissionHandler.Level.CI, (Metadata.ConfigurationItemRoot)Metadata.ConfigurationItemRoot.APPLICATIONS, (boolean)true);
    public static final Permission EDIT_TEMPLATE_FAILURE_HANDLER = Permission.definePermission((String)"template#edit_failure_handler", (PermissionHandler.Level)PermissionHandler.Level.CI, (Metadata.ConfigurationItemRoot)Metadata.ConfigurationItemRoot.APPLICATIONS, (boolean)true);
    public static final Permission EDIT_RELEASE_PRECONDITION = Permission.definePermission((String)"release#edit_precondition", (PermissionHandler.Level)PermissionHandler.Level.CI, (Metadata.ConfigurationItemRoot)Metadata.ConfigurationItemRoot.APPLICATIONS, (boolean)true);
    public static final Permission EDIT_TEMPLATE_PRECONDITION = Permission.definePermission((String)"template#edit_precondition", (PermissionHandler.Level)PermissionHandler.Level.CI, (Metadata.ConfigurationItemRoot)Metadata.ConfigurationItemRoot.APPLICATIONS, (boolean)true);
    public static final Permission DUMMY = Permission.definePermission((String)"dummy", (PermissionHandler.Level)PermissionHandler.Level.CI);
    public static final String ADMIN_USERNAME = "admin";
    public static final Map<Permission, Integer> GLOBAL_PERMISSION_PRESENTATION_ORDER = XLReleasePermissions.makeGlobalPermissionPresentationOrder();
    public static final Map<Permission, Integer> FOLDER_PERMISSION_PRESENTATION_ORDER = XLReleasePermissions.makeFolderPermissionPresentationOrder();

    public static void init() {
    }

    public static void removePermission(Permission permission) {
        Permission.unregisterPermission((Permission)permission);
    }

    public static List<String> getGlobalPermissions() {
        ArrayList permissions = Lists.newArrayList();
        for (Permission permission : Permission.getAll()) {
            if (permission.getLevel() != PermissionHandler.Level.BOTH && permission.getLevel() != PermissionHandler.Level.GLOBAL || permission.equals((Object)PlatformPermissions.LOGIN)) continue;
            permissions.add(permission.getPermissionName());
        }
        return permissions;
    }

    public static List<String> getTemplatePermissions() {
        return XLReleasePermissions.getLocalPermissions("template", "release");
    }

    public static List<String> getReleasePermissions() {
        return XLReleasePermissions.getLocalPermissions("release");
    }

    public static List<String> getTriggerPermissions() {
        return XLReleasePermissions.getLocalPermissions("trigger");
    }

    public static List<String> getTemplateOnlyPermissions() {
        return XLReleasePermissions.getLocalPermissions("template");
    }

    public static List<String> getFolderPermissions() {
        return XLReleasePermissions.getLocalPermissions("folder");
    }

    public static List<String> getReleaseGroupPermissions() {
        return XLReleasePermissions.getLocalPermissions("group");
    }

    public static List<String> getDeliveryPermissions() {
        return XLReleasePermissions.getLocalPermissions("delivery");
    }

    public static List<String> getDashboardPermissions() {
        return XLReleasePermissions.getLocalPermissions("dashboard");
    }

    public static boolean isAdmin(String username) {
        return ADMIN_USERNAME.equalsIgnoreCase(username);
    }

    private static List<String> getLocalPermissions(String ... prefixes) {
        return Permission.getAll().stream().filter(permission -> permission.getLevel() == PermissionHandler.Level.CI && permission.getRoot() == Metadata.ConfigurationItemRoot.APPLICATIONS).filter(permission -> Arrays.stream(prefixes).anyMatch(prefix -> permission.getPermissionName().startsWith((String)prefix))).map(Permission::getPermissionName).collect(Collectors.toList());
    }

    private static boolean isTemplatePermission(Permission permission) {
        return permission.getPermissionName().startsWith("template");
    }

    private static Map<Permission, Integer> makeGlobalPermissionPresentationOrder() {
        HashMap<Permission, Integer> result = new HashMap<Permission, Integer>();
        result.put(PlatformPermissions.ADMIN, result.size());
        result.put(PlatformPermissions.EDIT_SECURITY, result.size());
        result.put(CREATE_TEMPLATE, result.size());
        result.put(CREATE_RELEASE, result.size());
        result.put(PlatformPermissions.REPORT_VIEW, result.size());
        result.put(VIEW_REPORTS, result.size());
        result.put(AUDIT_ALL, result.size());
        result.put(CREATE_DASHBOARD, result.size());
        result.put(EDIT_GLOBAL_VARIABLES, result.size());
        result.put(CREATE_TOP_LEVEL_FOLDER, result.size());
        result.put(EDIT_GLOBAL_BLACKOUT, result.size());
        result.put(EDIT_RISK_PROFILE, result.size());
        result.put(VIEW_ENVIRONMENT, result.size());
        result.put(EDIT_ENVIRONMENT, result.size());
        result.put(VIEW_APPLICATION, result.size());
        result.put(EDIT_APPLICATION, result.size());
        result.put(EDIT_RESERVATION, result.size());
        return Collections.unmodifiableMap(result);
    }

    private static Map<Permission, Integer> makeFolderPermissionPresentationOrder() {
        HashMap<Permission, Integer> result = new HashMap<Permission, Integer>();
        result.put(VIEW_FOLDER, result.size());
        result.put(EDIT_FOLDER, result.size());
        result.put(EDIT_FOLDER_VARIABLES, result.size());
        result.put(EDIT_FOLDER_SECURITY, result.size());
        result.put(EDIT_FOLDER_TEAMS, result.size());
        result.put(EDIT_FOLDER_NOTIFICATIONS, result.size());
        result.put(VIEW_TEMPLATE, result.size());
        result.put(EDIT_TEMPLATE, result.size());
        result.put(LOCK_TEMPLATE_TASK, result.size());
        result.put(EDIT_TEMPLATE_PRECONDITION, result.size());
        result.put(EDIT_TEMPLATE_FAILURE_HANDLER, result.size());
        result.put(VIEW_RELEASE, result.size());
        result.put(EDIT_RELEASE, result.size());
        result.put(CREATE_RELEASE_FROM_TEMPLATE, result.size());
        result.put(START_RELEASE, result.size());
        result.put(ABORT_RELEASE, result.size());
        result.put(LOCK_RELEASE_TASK, result.size());
        result.put(EDIT_RELEASE_TASK, result.size());
        result.put(TASK_TRANSITION, result.size());
        result.put(REASSIGN_RELEASE_TASK, result.size());
        result.put(EDIT_TASK_DESCRIPTION, result.size());
        result.put(EDIT_RELEASE_TASK_CONFIGURATION, result.size());
        result.put(EDIT_RELEASE_TASK_SCRIPT, result.size());
        result.put(EDIT_TASK_FLAG, result.size());
        result.put(EDIT_TASK_TAGS, result.size());
        result.put(EDIT_TASK_DATES, result.size());
        result.put(EDIT_BLACKOUT, result.size());
        result.put(EDIT_RELEASE_PRECONDITION, result.size());
        result.put(EDIT_RELEASE_FAILURE_HANDLER, result.size());
        result.put(EDIT_RELEASE_TASK_CONFIGURATION_FACET, result.size());
        result.put(EDIT_RELEASE_TASK_ATTACHMENT, result.size());
        result.put(VIEW_DELIVERY_PATTERN, result.size());
        result.put(EDIT_DELIVERY_PATTERN, result.size());
        result.put(VIEW_RELEASE_DELIVERY, result.size());
        result.put(EDIT_RELEASE_DELIVERY, result.size());
        result.put(EDIT_DELIVERY_TRACKED_ITEM, result.size());
        result.put(VIEW_DASHBOARD, result.size());
        result.put(EDIT_DASHBOARD, result.size());
        result.put(VIEW_RELEASE_GROUP, result.size());
        result.put(EDIT_RELEASE_GROUP, result.size());
        result.put(EDIT_FOLDER_VERSIONS, result.size());
        result.put(VIEW_FOLDER_VERSIONS, result.size());
        result.put(EDIT_FOLDER_CONFIGURATION, result.size());
        result.put(VIEW_TRIGGER, result.size());
        result.put(EDIT_TRIGGER, result.size());
        return Collections.unmodifiableMap(result);
    }
}

