/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.io;

import com.caucho.hessian4.io.FlushableOutput;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class OutputStreamBuffer
extends OutputStream
implements FlushableOutput {
    private volatile ChannelHandlerContext _ctx;
    private volatile boolean _closed = false;
    private Lock _lock = new ReentrantLock();
    int _watermark = 0x100000;
    int _initialBuffSize = 1024;
    private volatile ByteBuf _buf = null;
    ExecutorService _executor = Executors.newSingleThreadExecutor();
    private boolean _immediateFlush = true;

    OutputStreamBuffer(ChannelHandlerContext ctx) {
        this._ctx = ctx;
    }

    @Override
    public void write(int b) throws IOException {
        if (this._closed) {
            throw new IOException("stream closed");
        }
        this._lock.lock();
        try {
            this.checkBuf();
            this._buf.writeByte((int)((byte)b));
            if (this._buf.writerIndex() >= this._watermark) {
                this.sendDownstream(null);
            }
        }
        finally {
            this._lock.unlock();
        }
    }

    private void checkBuf() {
        if (this._buf == null) {
            this._buf = this._ctx.alloc().buffer(1024);
            this._buf.retain();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this._closed) {
            throw new IOException("stream closed");
        }
        this._lock.lock();
        try {
            this.checkBuf();
            this._buf.writeBytes(b, off, len);
            if (this._buf.writerIndex() >= this._watermark) {
                this.sendDownstream(null);
            }
        }
        finally {
            this._lock.unlock();
        }
    }

    @Override
    public void flush() throws IOException {
        this.flush(null);
    }

    public void flush(ChannelPromise future) throws IOException {
        this._lock.lock();
        try {
            super.flush();
            if (this._buf == null || this._buf.readableBytes() == 0) {
                if (future != null) {
                    future.setSuccess();
                }
            } else {
                this.sendDownstream(future);
            }
            if (this._immediateFlush) {
                this._ctx.flush();
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            this._lock.unlock();
        }
    }

    private void sendDownstream(ChannelPromise future) throws IOException {
        this.sendDownstream(future, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendDownstream(ChannelPromise future, boolean wait) throws IOException {
        if (future != null && future.isDone()) {
            return;
        }
        if (!this._ctx.channel().isActive()) {
            throw new IOException("channel disconnected");
        }
        this._lock.lock();
        ChannelFuture result = null;
        try {
            ByteBuf toSend = this._buf;
            this._buf = null;
            if (toSend.refCnt() > 1) {
                toSend.release(toSend.refCnt() - 1);
            }
            if (future == null || future.isDone()) {
                result = this._ctx.write((Object)toSend);
            } else {
                this._ctx.write((Object)toSend, future);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            this._lock.unlock();
        }
    }

    @Override
    public void close() throws IOException {
        this._lock.lock();
        this._closed = true;
        this._executor.shutdownNow();
        this._lock.unlock();
    }

    public void setContext(ChannelHandlerContext ctx) {
        this._ctx = ctx;
        this.reset();
    }

    public ChannelHandlerContext getContext() {
        return this._ctx;
    }

    public void reset() {
        this._lock.lock();
        this._buf = Unpooled.buffer((int)1024);
        this._closed = false;
        this._lock.unlock();
    }
}

