/*
 * Decompiled with CFR 0.152.
 */
package liquibase.command.core;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import liquibase.Scope;
import liquibase.changelog.ChangelogRewriter;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.command.AbstractSelfConfiguratingCommand;
import liquibase.command.CommandResult;
import liquibase.command.CommandValidationErrors;
import liquibase.exception.LiquibaseException;
import liquibase.hub.HubService;
import liquibase.hub.HubServiceFactory;
import liquibase.hub.model.HubChangeLog;

public class DeactivateChangeLogCommand
extends AbstractSelfConfiguratingCommand<CommandResult> {
    private PrintStream outputStream = System.out;
    private HubChangeLog hubChangeLog;
    private String changeLogFile;
    private Map<String, Object> argsMap = new HashMap<String, Object>();

    public HubChangeLog getHubChangeLog() {
        return this.hubChangeLog;
    }

    @Override
    public void configure(Map<String, Object> argsMap) throws LiquibaseException {
        this.argsMap = argsMap;
    }

    public void setChangeLogFile(String changeLogFile) {
        this.changeLogFile = changeLogFile;
    }

    @Override
    public String getName() {
        return "deactivateChangeLog";
    }

    @Override
    public CommandValidationErrors validate() {
        return null;
    }

    public PrintStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(PrintStream outputStream) {
        this.outputStream = outputStream;
    }

    @Override
    protected CommandResult run() throws Exception {
        String changeLogId;
        HubServiceFactory hubServiceFactory = Scope.getCurrentScope().getSingleton(HubServiceFactory.class);
        if (!hubServiceFactory.isOnline()) {
            return new CommandResult("The command deactivateChangeLog requires access to Liquibase Hub: " + hubServiceFactory.getOfflineReason() + ".  Learn more at https://hub.liquibase.com", false);
        }
        HubService service = Scope.getCurrentScope().getSingleton(HubServiceFactory.class).getService();
        DatabaseChangeLog databaseChangeLog = (DatabaseChangeLog)this.argsMap.get("changeLog");
        String string = changeLogId = databaseChangeLog != null ? databaseChangeLog.getChangeLogId() : null;
        if (changeLogId == null) {
            return new CommandResult("Changelog '" + this.changeLogFile + "' does not have a changelog ID and is not registered with Hub.\nFor more information visit https://docs.liquibase.com.", false);
        }
        this.hubChangeLog = service.getHubChangeLog(UUID.fromString(changeLogId));
        if (this.hubChangeLog == null) {
            String message = "WARNING: Changelog '" + this.changeLogFile + "' has a changelog ID but was not found in Hub.\nThe changelog ID will be removed from the file, but Hub will not be updated.";
            Scope.getCurrentScope().getUI().sendMessage(message);
            Scope.getCurrentScope().getLog(DeactivateChangeLogCommand.class).warning(message);
        } else {
            this.hubChangeLog.setStatus("INACTIVE");
            this.hubChangeLog = service.deactivateChangeLog(this.hubChangeLog);
        }
        ChangelogRewriter.ChangeLogRewriterResult rewriterResult = ChangelogRewriter.removeChangeLogId(this.changeLogFile, changeLogId, databaseChangeLog);
        String message = null;
        if (rewriterResult.success) {
            message = "The changelog '" + this.changeLogFile + "' was deactivated.\nNote: If this is a shared changelog, please check it into Source Control.\nOperation data sent to the now inactive changelogID will still be accepted at Hub.\nFor more information visit https://docs.liquibase.com.\n";
            Scope.getCurrentScope().getLog(DeactivateChangeLogCommand.class).info(message);
            return new CommandResult(message, true);
        }
        return new CommandResult(rewriterResult.message, false);
    }
}

