/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.environments.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.xlrelease.api.v1.filter.ApplicationFilters;
import com.xebialabs.xlrelease.domain.environments.Application;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.environments.events.ApplicationCreatedEvent;
import com.xebialabs.xlrelease.environments.events.ApplicationDeletedEvent;
import com.xebialabs.xlrelease.environments.events.ApplicationUpdatedEvent;
import com.xebialabs.xlrelease.environments.repository.ApplicationRepository;
import com.xebialabs.xlrelease.environments.service.ApplicationSecurity;
import com.xebialabs.xlrelease.environments.service.package$;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005\u0005c\u0001B\u0007\u000f\u0001eA\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006I!\t\u0005\tO\u0001\u0011\t\u0011)A\u0005Q!AA\u0006\u0001BC\u0002\u0013\u0005Q\u0006\u0003\u00055\u0001\t\u0005\t\u0015!\u0003/\u0011\u0015)\u0004\u0001\"\u00017\u0011\u0015Q\u0005\u0001\"\u0001L\u0011\u0015\t\b\u0001\"\u0001s\u0011\u001d\t\u0019\u0001\u0001C\u0001\u0003\u000bAq!!\u0004\u0001\t\u0003\ty\u0001C\u0004\u0002\u0016\u0001!\t!a\u0006\t\u000f\u0005\r\u0002\u0001\"\u0001\u0002&!9\u0011Q\u0006\u0001\u0005\n\u0005=\"AE!qa2L7-\u0019;j_:\u001cVM\u001d<jG\u0016T!a\u0004\t\u0002\u000fM,'O^5dK*\u0011\u0011CE\u0001\rK:4\u0018N]8o[\u0016tGo\u001d\u0006\u0003'Q\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005U1\u0012!\u0003=fE&\fG.\u00192t\u0015\u00059\u0012aA2p[\u000e\u00011C\u0001\u0001\u001b!\tYb$D\u0001\u001d\u0015\u0005i\u0012!B:dC2\f\u0017BA\u0010\u001d\u0005\u0019\te.\u001f*fM\u0006)\u0012\r\u001d9mS\u000e\fG/[8o%\u0016\u0004xn]5u_JL\bC\u0001\u0012&\u001b\u0005\u0019#B\u0001\u0013\u0011\u0003)\u0011X\r]8tSR|'/_\u0005\u0003M\r\u0012Q#\u00119qY&\u001c\u0017\r^5p]J+\u0007o\\:ji>\u0014\u00180A\nbaBd\u0017nY1uS>t7+Z2ve&$\u0018\u0010\u0005\u0002*U5\ta\"\u0003\u0002,\u001d\t\u0019\u0012\t\u001d9mS\u000e\fG/[8o'\u0016\u001cWO]5us\u0006AQM^3oi\n+8/F\u0001/!\ty#'D\u00011\u0015\t\t$#\u0001\u0004fm\u0016tGo]\u0005\u0003gA\u0012\u0011\u0003\u0017'SK2,\u0017m]3Fm\u0016tGOQ;t\u0003%)g/\u001a8u\u0005V\u001c\b%\u0001\u0004=S:LGO\u0010\u000b\u0005oaJ$\b\u0005\u0002*\u0001!)\u0001%\u0002a\u0001C!)q%\u0002a\u0001Q!)A&\u0002a\u0001]!\u0012Q\u0001\u0010\t\u0003{!k\u0011A\u0010\u0006\u0003\u007f\u0001\u000b!\"\u00198o_R\fG/[8o\u0015\t\t%)A\u0004gC\u000e$xN]=\u000b\u0005\r#\u0015!\u00022fC:\u001c(BA#G\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"A$\u0002\u0007=\u0014x-\u0003\u0002J}\tI\u0011)\u001e;po&\u0014X\rZ\u0001\u0013g\u0016\f'o\u00195BaBd\u0017nY1uS>t7\u000f\u0006\u0002M7B\u0019QJ\u0015+\u000e\u00039S!a\u0014)\u0002\tU$\u0018\u000e\u001c\u0006\u0002#\u0006!!.\u0019<b\u0013\t\u0019fJ\u0001\u0003MSN$\bCA+Z\u001b\u00051&BA\tX\u0015\tA&#\u0001\u0004e_6\f\u0017N\\\u0005\u00035Z\u00131\"\u00119qY&\u001c\u0017\r^5p]\")AL\u0002a\u0001;\u0006\u0011\u0012\r\u001d9mS\u000e\fG/[8o\r&dG/\u001a:t!\tqV-D\u0001`\u0015\t\u0001\u0017-\u0001\u0004gS2$XM\u001d\u0006\u0003E\u000e\f!A^\u0019\u000b\u0005\u0011\u0014\u0012aA1qS&\u0011am\u0018\u0002\u0013\u0003B\u0004H.[2bi&|gNR5mi\u0016\u00148\u000f\u000b\u0002\u0007QB\u0011\u0011n\\\u0007\u0002U*\u0011qh\u001b\u0006\u0003Y6\fq!\\3ue&\u001c7O\u0003\u0002o-\u0005A1m\u001c3bQ\u0006dW-\u0003\u0002qU\n)A+[7fI\u0006\u0019b-\u001b8e\u0003B\u0004H.[2bi&|gNQ=JIR\u0011Ak\u001d\u0005\u0006i\u001e\u0001\r!^\u0001\u000eCB\u0004H.[2bi&|g.\u00133\u0011\u0005YlhBA<|!\tAH$D\u0001z\u0015\tQ\b$\u0001\u0004=e>|GOP\u0005\u0003yr\ta\u0001\u0015:fI\u00164\u0017B\u0001@\u0000\u0005\u0019\u0019FO]5oO*\u0011A\u0010\b\u0015\u0003\u000f!\f\u0011c\u0019:fCR,\u0017\t\u001d9mS\u000e\fG/[8o)\r!\u0016q\u0001\u0005\u0007\u0003\u0013A\u0001\u0019\u0001+\u0002\u0017\u0005\u0004\b\u000f\\5dCRLwN\u001c\u0015\u0003\u0011!\f\u0011#\u001e9eCR,\u0017\t\u001d9mS\u000e\fG/[8o)\r!\u0016\u0011\u0003\u0005\u0007\u0003\u0013I\u0001\u0019\u0001+)\u0005%A\u0017!\u00053fY\u0016$X-\u00119qY&\u001c\u0017\r^5p]R!\u0011\u0011DA\u0010!\rY\u00121D\u0005\u0004\u0003;a\"\u0001B+oSRDQ\u0001\u001e\u0006A\u0002UD#A\u00035\u0002M\u001d,G/\u00119qY&\u001c\u0017\r^5p]N$U\r\u001d7ps\u0006\u0014G.Z(o\u000b:4\u0018N]8o[\u0016tG\u000fF\u0002M\u0003OAa!!\u000b\f\u0001\u0004)\u0018!D3om&\u0014xN\\7f]RLE\r\u000b\u0002\fQ\u0006ia/\u00197jI\u0006$X\rV5uY\u0016$B!!\u0007\u00022!1\u0011\u0011\u0002\u0007A\u0002QC3\u0001AA\u001b!\u0011\t9$!\u0010\u000e\u0005\u0005e\"bAA\u001e\t\u0006Q1\u000f^3sK>$\u0018\u0010]3\n\t\u0005}\u0012\u0011\b\u0002\b'\u0016\u0014h/[2f\u0001")
public class ApplicationService {
    private final ApplicationRepository applicationRepository;
    private final ApplicationSecurity applicationSecurity;
    private final XLReleaseEventBus eventBus;

    public XLReleaseEventBus eventBus() {
        return this.eventBus;
    }

    @Timed
    public List<Application> searchApplications(ApplicationFilters applicationFilters) {
        this.applicationSecurity.checkView();
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.applicationRepository.searchApplications(applicationFilters, package$.MODULE$.defaultPage())).asJava();
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Application findApplicationById(String applicationId) {
        void var2_2;
        this.applicationSecurity.checkView();
        Application application = this.applicationRepository.findApplicationById(applicationId);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Application createApplication(Application application) {
        void var2_2;
        this.applicationSecurity.checkCreate();
        this.validateTitle(application);
        Application createdApplication = this.applicationRepository.createApplication(application);
        this.eventBus().publish((XLReleaseEvent)new ApplicationCreatedEvent(createdApplication));
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Application updateApplication(Application application) {
        void var2_2;
        this.applicationSecurity.checkEdit();
        Checks.checkArgument((boolean)StringUtils.hasText((String)application.getId()), (String)"ID is required", (Object[])new Object[0]);
        this.validateTitle(application);
        Application updatedApplication = this.applicationRepository.updateApplication(application);
        this.eventBus().publish((XLReleaseEvent)new ApplicationUpdatedEvent(updatedApplication));
        return var2_2;
    }

    @Timed
    public void deleteApplication(String applicationId) {
        this.applicationSecurity.checkEdit();
        Application application = this.applicationRepository.findApplicationById(applicationId);
        this.applicationRepository.deleteApplication(applicationId);
        this.eventBus().publish((XLReleaseEvent)new ApplicationDeletedEvent(application));
    }

    @Timed
    public List<Application> getApplicationsDeployableOnEnvironment(String environmentId) {
        this.applicationSecurity.checkView();
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.applicationRepository.getApplicationsDeployableOnEnvironment(environmentId)).asJava();
    }

    private void validateTitle(Application application) {
        Checks.checkArgument((boolean)StringUtils.hasText((String)application.getTitle()), (String)"Title cannot be blank", (Object[])new Object[0]);
    }

    @Autowired
    public ApplicationService(ApplicationRepository applicationRepository, ApplicationSecurity applicationSecurity, XLReleaseEventBus eventBus) {
        this.applicationRepository = applicationRepository;
        this.applicationSecurity = applicationSecurity;
        this.eventBus = eventBus;
    }
}

