(window["webpackJsonp"] = window["webpackJsonp"] || []).push([[3],{

/***/ 0:
/***/ (function(module, exports) {

module.exports = React;

/***/ }),

/***/ 107:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return ReleaseStatusFactory; });
function ReleaseStatusFactory() {
  return {
    isReleaseCompleted: function isReleaseCompleted(release) {
      return release && (release.status === 'COMPLETED' || release.status === 'ABORTED');
    },
    isReleaseAborted: function isReleaseAborted(release) {
      return release && release.status === 'ABORTED';
    },
    isReleasePlanned: function isReleasePlanned(release) {
      return release && release.status === 'PLANNED';
    },
    isReleaseInProgress: function isReleaseInProgress(release) {
      return release && release.status === 'IN_PROGRESS';
    },
    isReleaseFailed: function isReleaseFailed(release) {
      return release && release.status === 'FAILED';
    },
    isReleaseFailing: function isReleaseFailing(release) {
      return release && release.status === 'FAILING';
    },
    isReleasePaused: function isReleasePaused(release) {
      return release && release.status === 'PAUSED';
    },
    hasCompletedStatus: function hasCompletedStatus(release) {
      return release && release.status === 'COMPLETED';
    },
    isTemplate: function isTemplate(release) {
      return release && release.status === 'TEMPLATE';
    },
    isReleaseArchived: function isReleaseArchived(release) {
      return release && release.archived;
    },
    isReleaseActive: function isReleaseActive(release) {
      return release && (release.status === 'IN_PROGRESS' || release.status === "FAILED" || release.status === "FAILING" || release.status === "PAUSED");
    }
  };
}

/***/ }),

/***/ 109:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return fetchDeliveries; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "d", function() { return getDelivery; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return deleteDelivery; });
/* unused harmony export createDelivery */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return createDeliveryFromPattern; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "g", function() { return updateDelivery; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "f", function() { return isDeliveryUpdatable; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "e", function() { return getTrackedItemApprovals; });
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(131);


function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }



var RELEASE_DELIVERY_API = 'api/v1/deliveries';
var RELEASE_DELIVERY_PATTERN_API = 'api/v1/delivery-patterns';
var RELEASE_DELIVERY_ACTIVITY_LOGS_INTERNAL_API = 'activity';

function reduceFilters(filters) {
  var keys = _.keys(filters);

  return _.reduce(keys, function (reduced, key) {
    if (_.has(_constants__WEBPACK_IMPORTED_MODULE_2__[/* RELEASE_STATUS_FILTER_KEY_TO_STATUS */ "c"], key)) {
      filters[key] && reduced.statuses.push(_constants__WEBPACK_IMPORTED_MODULE_2__[/* RELEASE_STATUS_FILTER_KEY_TO_STATUS */ "c"][key]);
    } else {
      reduced[key] = filters[key];
    }

    return reduced;
  }, {
    statuses: []
  });
}

function fetchDeliveries(data, pageNumber) {
  var itemsPerPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : _constants__WEBPACK_IMPORTED_MODULE_2__[/* ITEMS_PER_PAGE */ "b"];
  var params = {
    resultsPerPage: itemsPerPage,
    page: pageNumber,
    orderBy: (data.orderBy || _constants__WEBPACK_IMPORTED_MODULE_2__[/* DEFAULT_ORDER_BY */ "a"]).toUpperCase()
  };
  var url = "".concat(RELEASE_DELIVERY_API, "/search?") + $.param(params);
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_1__[/* httpPOST */ "e"])(url, _objectSpread({}, reduceFilters(data)));
}
var getDelivery = function getDelivery(deliveryId) {
  var hideAlert = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_1__[/* httpGET */ "c"])("".concat(RELEASE_DELIVERY_API, "/").concat(deliveryId), hideAlert);
};
var deleteDelivery = function deleteDelivery(deliveryId) {
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_1__[/* httpDELETE */ "b"])("".concat(RELEASE_DELIVERY_API, "/").concat(deliveryId));
};
var createDelivery = function createDelivery(delivery) {
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_1__[/* httpPOST */ "e"])(RELEASE_DELIVERY_API, delivery);
};
var createDeliveryFromPattern = function createDeliveryFromPattern(patternId, delivery) {
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_1__[/* httpPOST */ "e"])("".concat(RELEASE_DELIVERY_PATTERN_API, "/").concat(patternId, "/create"), delivery);
};
var updateDelivery = function updateDelivery(delivery) {
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_1__[/* httpPUT */ "g"])("".concat(RELEASE_DELIVERY_API, "/").concat(delivery.id), delivery);
};
var isDeliveryUpdatable = function isDeliveryUpdatable(delivery) {
  return delivery && delivery.status !== 'COMPLETED';
};
var getTrackedItemApprovals = function getTrackedItemApprovals(deliveryId) {
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_1__[/* httpGET */ "c"])("".concat(RELEASE_DELIVERY_ACTIVITY_LOGS_INTERNAL_API, "/").concat(deliveryId, "/approvals"));
};

/***/ }),

/***/ 117:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "e", function() { return fetchReleases; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "f", function() { return fetchRisks; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "g", function() { return startReleases; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return abortReleases; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "d", function() { return fetchReleaseTags; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return fetchArchivedReleaseTags; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return fetchCount; });
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _common_services_http__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(81);


function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }



var fetchReleases = function fetchReleases(filters, pageNumber) {
  var url = "releases/search?depth=3&numberbypage=".concat(_constants__WEBPACK_IMPORTED_MODULE_2__[/* ITEMS_PER_PAGE */ "c"], "&page=").concat(pageNumber, "&filter=").concat(filters.filter) + '&properties=riskScore&extensions=progress';
  return Object(_common_services_http__WEBPACK_IMPORTED_MODULE_1__[/* httpRequest */ "h"])('POST', url, {
    data: filters
  });
};
var fetchRisks = function fetchRisks(releaseId) {
  return Object(_common_services_http__WEBPACK_IMPORTED_MODULE_1__[/* httpRequest */ "h"])('GET', "api/v1/risks/".concat(releaseId, "/Risk"));
};
var startReleases = function startReleases(releasesIds) {
  return Object(_common_services_http__WEBPACK_IMPORTED_MODULE_1__[/* httpRequest */ "h"])('POST', "releases/start", {
    data: releasesIds
  });
};
var abortReleases = function abortReleases(releasesIds, abortComment) {
  return Object(_common_services_http__WEBPACK_IMPORTED_MODULE_1__[/* httpRequest */ "h"])('POST', "releases/abort", {
    data: {
      releasesIds: releasesIds,
      abortComment: abortComment
    }
  });
};
var fetchReleaseTags = function fetchReleaseTags() {
  return Object(_common_services_http__WEBPACK_IMPORTED_MODULE_1__[/* httpGET */ "c"])('releases/tags');
};
var fetchArchivedReleaseTags = function fetchArchivedReleaseTags() {
  return Object(_common_services_http__WEBPACK_IMPORTED_MODULE_1__[/* httpGET */ "c"])('releases/tags/archived');
};
var fetchCount = function fetchCount(filters) {
  if (filters.onlyArchived) {
    filters.planned = false;
    filters.inProgress = false;
    filters.failing = false;
    filters.failed = false;
    filters.paused = false;
  }

  return Object(_common_services_http__WEBPACK_IMPORTED_MODULE_1__[/* httpPOST */ "e"])('releases/count', _objectSpread(_objectSpread({}, filters), {}, {
    onlyArchived: false
  }));
};

/***/ }),

/***/ 123:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export parseDateTimeFormat */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return formatDateTime; });
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(129);
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(22);
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(moment__WEBPACK_IMPORTED_MODULE_1__);


function parseDateTimeFormat(date, dateFormat, timeFormat) {
  var format = "".concat(dateFormat, " ").concat(timeFormat);

  if (_constants__WEBPACK_IMPORTED_MODULE_0__[/* angularJsDateFormatToMomentFormat */ "a"][dateFormat]) {
    format = "".concat(_constants__WEBPACK_IMPORTED_MODULE_0__[/* angularJsDateFormatToMomentFormat */ "a"][dateFormat]);

    if (_constants__WEBPACK_IMPORTED_MODULE_0__[/* angularJsTimeFormatToMomentFormat */ "b"][timeFormat]) {
      format = "".concat(format, " ").concat(_constants__WEBPACK_IMPORTED_MODULE_0__[/* angularJsTimeFormatToMomentFormat */ "b"][timeFormat]);
    } else {
      format = "".concat(format, " ").concat(timeFormat);
    }
  } else {
    // can't find an appropriate format, use default
    format = "YYYY-MM-DD h:mm A";
  }

  return format;
}
function formatDateTime(date, dateFormat, timeFormat) {
  return moment__WEBPACK_IMPORTED_MODULE_1___default()(date).format(parseDateTimeFormat(date, dateFormat, timeFormat));
}

/***/ }),

/***/ 127:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, "a", function() { return /* reexport */ widget_datetime_WidgetDateTime; });

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/classCallCheck.js
var classCallCheck = __webpack_require__(4);
var classCallCheck_default = /*#__PURE__*/__webpack_require__.n(classCallCheck);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/createClass.js
var createClass = __webpack_require__(5);
var createClass_default = /*#__PURE__*/__webpack_require__.n(createClass);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/assertThisInitialized.js
var assertThisInitialized = __webpack_require__(6);
var assertThisInitialized_default = /*#__PURE__*/__webpack_require__.n(assertThisInitialized);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/inherits.js
var inherits = __webpack_require__(11);
var inherits_default = /*#__PURE__*/__webpack_require__.n(inherits);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/possibleConstructorReturn.js
var possibleConstructorReturn = __webpack_require__(10);
var possibleConstructorReturn_default = /*#__PURE__*/__webpack_require__.n(possibleConstructorReturn);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/getPrototypeOf.js
var getPrototypeOf = __webpack_require__(8);
var getPrototypeOf_default = /*#__PURE__*/__webpack_require__.n(getPrototypeOf);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/defineProperty.js
var defineProperty = __webpack_require__(1);
var defineProperty_default = /*#__PURE__*/__webpack_require__.n(defineProperty);

// EXTERNAL MODULE: external "React"
var external_React_ = __webpack_require__(0);
var external_React_default = /*#__PURE__*/__webpack_require__.n(external_React_);

// EXTERNAL MODULE: ./node_modules/prop-types/index.js
var prop_types = __webpack_require__(2);

// EXTERNAL MODULE: ./node_modules/lodash/clone.js
var clone = __webpack_require__(135);
var clone_default = /*#__PURE__*/__webpack_require__.n(clone);

// EXTERNAL MODULE: ./node_modules/xl-react-components/dist/index.js
var dist = __webpack_require__(14);

// EXTERNAL MODULE: ./node_modules/moment/moment.js-exposed
var moment_js_exposed = __webpack_require__(22);
var moment_js_exposed_default = /*#__PURE__*/__webpack_require__.n(moment_js_exposed);

// EXTERNAL MODULE: ./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js
var injectStylesIntoStyleTag = __webpack_require__(9);
var injectStylesIntoStyleTag_default = /*#__PURE__*/__webpack_require__.n(injectStylesIntoStyleTag);

// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./core/xlr-ui/app/react/widgets/datetime/widget-datetime.less
var widget_datetime = __webpack_require__(300);
var widget_datetime_default = /*#__PURE__*/__webpack_require__.n(widget_datetime);

// CONCATENATED MODULE: ./core/xlr-ui/app/react/widgets/datetime/widget-datetime.less

            

var options = {};

options.insert = "head";
options.singleton = false;

var update = injectStylesIntoStyleTag_default()(widget_datetime_default.a, options);



/* harmony default export */ var datetime_widget_datetime = (widget_datetime_default.a.locals || {});
// CONCATENATED MODULE: ./core/xlr-ui/app/react/widgets/datetime/widget-datetime.js








function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }







var widget_datetime_WidgetDateTime = /*#__PURE__*/function (_Component) {
  inherits_default()(WidgetDateTime, _Component);

  var _super = _createSuper(WidgetDateTime);

  function WidgetDateTime(props) {
    var _this;

    classCallCheck_default()(this, WidgetDateTime);

    _this = _super.call(this, props);

    defineProperty_default()(assertThisInitialized_default()(_this), "onStartDateChange", function (selectedDate) {
      var _this$props = _this.props,
          model = _this$props.model,
          onModelChange = _this$props.onModelChange;
      var startDate = clone_default()(model);
      startDate.setFullYear(selectedDate.getFullYear(), selectedDate.getMonth(), selectedDate.getDate());

      if (!moment_js_exposed_default()(startDate).isSame(moment_js_exposed_default()(model))) {
        onModelChange(startDate);
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onStartTimeChange", function (selectedDate) {
      var _this$props2 = _this.props,
          model = _this$props2.model,
          onModelChange = _this$props2.onModelChange;
      var startDate = clone_default()(model);
      startDate.setHours(selectedDate.getHours(), selectedDate.getMinutes());

      if (!moment_js_exposed_default()(startDate).isSame(moment_js_exposed_default()(model))) {
        onModelChange(startDate);
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onDatePristine", function (pristine) {
      var onDatePristinityChange = _this.props.onDatePristinityChange;

      _this.setState({
        datePristine: pristine
      });

      onDatePristinityChange(pristine);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onTimePristine", function (pristine) {
      var onTimePristinityChange = _this.props.onTimePristinityChange;

      _this.setState({
        timePristine: pristine
      });

      onTimePristinityChange(pristine);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onTimeValidityChange", function (valid) {
      var onValidityChange = _this.props.onValidityChange;
      _this.isTimeValid = valid;
      onValidityChange(_this.isFormValid);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onDateValidityChange", function (valid) {
      var onValidityChange = _this.props.onValidityChange;
      _this.isDateValid = valid;
      onValidityChange(_this.isFormValid);
    });

    _this.state = {
      datePristine: true,
      timePristine: true
    };
    _this.isDateValid = false;
    _this.isTimeValid = false;
    return _this;
  }

  createClass_default()(WidgetDateTime, [{
    key: "isFormValid",
    get: function get() {
      return this.isDateValid && this.isTimeValid;
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props3 = this.props,
          disabled = _this$props3.disabled,
          metadata = _this$props3.metadata,
          minDate = _this$props3.minDate,
          model = _this$props3.model;
      return /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "xl-react-components widget-datetime"
      }, metadata.label && /*#__PURE__*/external_React_default.a.createElement(dist["XlReactWidgetLabel"], {
        metadata: metadata
      }), /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "date-time-wrapper"
      }, /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "date-time-input"
      }, /*#__PURE__*/external_React_default.a.createElement(dist["XlReactWidgetDate"], {
        dateFormat: metadata.dateFormat,
        disabled: disabled,
        minDate: minDate,
        model: model,
        onModelChange: this.onStartDateChange,
        onPristinityChange: this.onDatePristine,
        onValidityChange: this.onDateValidityChange
      }), /*#__PURE__*/external_React_default.a.createElement(dist["XlReactWidgetTime"], {
        disabled: disabled,
        model: model,
        onModelChange: this.onStartTimeChange,
        onPristinityChange: this.onTimePristine,
        onValidityChange: this.onTimeValidityChange
      })), /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "xl-react-components-description"
      }, /*#__PURE__*/external_React_default.a.createElement("div", null, metadata.description))));
    }
  }]);

  return WidgetDateTime;
}(external_React_["Component"]);
// CONCATENATED MODULE: ./core/xlr-ui/app/react/widgets/index.js


/***/ }),

/***/ 129:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return angularJsDateFormatToMomentFormat; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return angularJsTimeFormatToMomentFormat; });
var angularJsDateFormatToMomentFormat = {
  'd/M/yy': 'D/M/YY',
  'M/d/yy': 'M/D/YY',
  'dd/MM/yy': 'DD/MM/YY',
  'yy/MM/dd': 'YY/MM/DD',
  'MMM d, y': 'MMM DD, YYYY',
  'dd MMM y': 'DD MMM YYYY',
  'y MMM dd': 'YYYY MMM DD',
  'y MMMM dd EEEE': 'YYYY MMMM DD dddd',
  'EEEE dd MMMM y': 'dddd DD MMMM YYYY',
  'EEEE, MMMM d, y': 'dddd, MMMM, D, YYYY'
};
var angularJsTimeFormatToMomentFormat = {
  'HH:mm': 'HH:mm',
  'h:mm a': 'h:mm A'
};

/***/ }),

/***/ 1302:
/***/ (function(module, exports, __webpack_require__) {

__webpack_require__(3012);
module.exports = __webpack_require__(2161);


/***/ }),

/***/ 1307:
/***/ (function(module, exports) {

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

var EDIT_TASK_PERMISSION = 'release#edit_task';
angular.module('xlrelease').factory('Authenticator', ['$timeout', 'Backend', '$rootScope', '$location', 'Events', 'ForbiddenAccessService', 'ClientSettings', 'UserProfile', '$q', 'RedirectOnLoginService', 'PageUrls', 'UsersService', 'ViewStorage', '$state', 'AuthenticationRegistry', 'WindowLocation', 'EventBus', '$ngRedux', 'FeatureSettingsService', function ($timeout, Backend, $rootScope, $location, Events, ForbiddenAccessService, ClientSettings, UserProfile, $q, RedirectOnLoginService, PageUrls, UsersService, ViewStorage, $state, AuthenticationRegistry, WindowLocation, EventBus, $ngRedux, FeatureSettingsService) {
  var ADMINISTRATOR = 'admin';
  var RELEASE_ADMIN_TEAM = 'Release Admin';

  function clearUserData() {
    ClientSettings.removeIdentityProvider();
    ClientSettings.removeAuthenticationData();
    ClientSettings.removePermissions();
    ClientSettings.removeTimelineFilters();
    UserProfile.clear();
    ViewStorage.clear();
    EventBus.emitEvent(Events.folders.cleanCache);
    $ngRedux.dispatch({
      type: 'XLR_CLEAN_STATE'
    });
    FeatureSettingsService.unloadFeatures();
  }

  function setCredentials(username) {
    var authenticationData = {
      username: username
    };
    ClientSettings.setAuthenticationData(authenticationData);
    $ngRedux.dispatch({
      type: 'AUTH/SET_AUTHENTICATION_DATA',
      payload: {
        authenticationData: authenticationData
      }
    });
  }

  function setSecurity(security) {
    var permissions = security.global;

    if (!permissions) {
      permissions = [];
    }

    ClientSettings.setPermissions(permissions);
    $ngRedux.dispatch({
      type: 'AUTH/SET_PERMISSIONS',
      payload: {
        permissions: permissions
      }
    });
  }

  $rootScope.$on(Events.permission.unauthorized, function () {
    var _iterator = _createForOfIteratorHelper(AuthenticationRegistry.getAutoProviders()),
        _step;

    try {
      for (_iterator.s(); !(_step = _iterator.n()).done;) {
        var provider = _step.value;

        if (provider.login(true)) {
          break;
        }
      }
    } catch (err) {
      _iterator.e(err);
    } finally {
      _iterator.f();
    }
  });
  $rootScope.$on(Events.permission.forbidden, function (event, errorMessage) {
    var fallback = $location.search().fallback;

    if (fallback) {
      // wrapped in $timeout because if the request gets rejected in a resolve block think UI router blocks all transitions
      // should be able to trigger transition to fallback in a $stateChangeError event handler maybe?
      $timeout(function () {
        return $location.url(fallback);
      });
    } else {
      ForbiddenAccessService.errorMessage = errorMessage;
      $timeout(function () {
        return $location.url(PageUrls.FORBIDDEN_CONTENT_PAGE);
      });
    }
  });
  $rootScope.$on(Events.permission.refresh, function () {
    Backend.get('security').then(function (resp) {
      return setSecurity(resp.data);
    });
  });

  function isAdmin(permissions) {
    return UsersService.isUserNameAdmin(authenticationService.getUsername()) || _.includes(permissions, ADMINISTRATOR);
  }

  function hasAppropriatePermission(release, templatePermission, releasePermission) {
    if (release && release.status === 'TEMPLATE') {
      return authenticationService.hasPermission(templatePermission, release);
    }

    return release && authenticationService.hasPermission(releasePermission, release);
  }

  function hasPermission(permission, release) {
    var globalPermissions = ClientSettings.getPermissions();

    if (globalPermissions === null) {
      return false;
    }

    if (isAdmin(globalPermissions)) {
      return true;
    }

    var permissions = angular.isUndefined(release) ? globalPermissions : release.security.permissions;
    return _.includes(permissions, permission);
  }

  function hasAnyOfPermissions(permissions, ci) {
    var globalPermissions = ClientSettings.getPermissions();

    if (globalPermissions === null) {
      return false;
    }

    if (isAdmin(globalPermissions)) {
      return true;
    }

    var allPermissions = angular.isUndefined(ci) ? globalPermissions : ci.security.permissions;
    return _.some(permissions, function (permission) {
      return _.includes(allPermissions, permission);
    });
  }

  function loadUserDetails(username) {
    return Backend.get('security', {
      dontRedirectWhenForbidden: true,
      hideAlert: true
    }).then(function (response) {
      setSecurity(response.data);
      return UserProfile.load().then(function (profile) {
        return setCredentials(profile.username);
      }).catch(function (err) {
        // UserProfile is not mandatory on the server-side. Could potentially response with invalid JSON
        // Sets credentials by using user input or third-party plugin, like SPNEGO
        setCredentials(username);
        return err;
      });
    });
  }

  var authenticationService = {
    init: function init() {
      this.security = {
        isAuthenticated: authenticationService.isAuthenticated,
        getUsername: authenticationService.getUsername,
        hasPermission: authenticationService.hasPermission,
        hasAnyOfPermissions: authenticationService.hasAnyOfPermissions,
        hasViewPermission: authenticationService.hasViewPermission,
        hasEditPermission: authenticationService.hasEditPermission,
        hasEditTaskPermission: authenticationService.hasEditTaskPermission,
        hasReassignTaskPermission: authenticationService.hasReassignTaskPermission,
        hasEditSecurityPermission: authenticationService.hasEditSecurityPermission,
        hasReleaseGroupEditPermission: authenticationService.hasReleaseGroupEditPermission,
        hasEditTaskDatesPermission: authenticationService.hasEditTaskDatesPermission,
        hasEditTaskOrEditBlackoutPermission: authenticationService.hasEditTaskOrEditBlackoutPermission,
        hasEditTaskOrEditDatesPermission: authenticationService.hasEditTaskOrEditDatesPermission,
        isAdminOr: authenticationService.isAdminOr
      };
      $rootScope.security = this.security;
    },
    getUsername: function getUsername() {
      var authenticationData = ClientSettings.getAuthenticationData();
      return authenticationData !== null ? authenticationData.username : null;
    },
    isAuthenticated: function isAuthenticated() {
      return ClientSettings.getAuthenticationData() !== null;
    },
    hasPermission: hasPermission,
    hasAnyOfPermissions: hasAnyOfPermissions,
    hasEditGlobalVariablesPermission: function hasEditGlobalVariablesPermission() {
      return hasPermission('global_variables#edit');
    },
    hasViewPermission: function hasViewPermission(release) {
      return hasAppropriatePermission(release, 'template#view', 'release#view');
    },
    hasEditPermission: function hasEditPermission(release) {
      return hasAppropriatePermission(release, 'template#edit', 'release#edit');
    },
    hasEditTaskPermission: function hasEditTaskPermission(release) {
      return hasAppropriatePermission(release, 'template#edit', EDIT_TASK_PERMISSION);
    },
    hasEditTaskConfigurationPropertiesPermission: function hasEditTaskConfigurationPropertiesPermission(release) {
      return hasAppropriatePermission(release, 'template#edit', 'release#edit_task_input_output_properties');
    },
    hasEditTaskAttachmentPermission: function hasEditTaskAttachmentPermission(release) {
      return hasAppropriatePermission(release, 'template#edit', 'release#edit_task_attachments');
    },
    hasEditTaskConfigurationFacetPermission: function hasEditTaskConfigurationFacetPermission(release) {
      return hasAppropriatePermission(release, 'template#edit', 'release#edit_task_configuration_facet');
    },
    hasEditTaskScriptPermission: function hasEditTaskScriptPermission(release) {
      return hasAppropriatePermission(release, 'template#edit', 'release#edit_task_script');
    },
    hasReassignTaskPermission: function hasReassignTaskPermission(release) {
      return hasAppropriatePermission(release, 'template#edit', 'release#reassign_task');
    },
    hasEditBlackoutPermission: function hasEditBlackoutPermission(release) {
      return hasAppropriatePermission(release, 'template#edit', 'release#edit_blackout');
    },
    hasEditFailureHandlerPermission: function hasEditFailureHandlerPermission(release) {
      return hasAppropriatePermission(release, 'template#edit_failure_handler', 'release#edit_failure_handler');
    },
    hasEditPreconditionPermission: function hasEditPreconditionPermission(release) {
      return hasAppropriatePermission(release, 'template#edit_precondition', 'release#edit_precondition');
    },
    hasLockTaskPermission: function hasLockTaskPermission(release) {
      return hasAppropriatePermission(release, 'template#lock_task', 'release#lock_task');
    },
    hasTaskTransitionPermission: function hasTaskTransitionPermission(release) {
      if (release.archived) {
        return false;
      }

      return hasAppropriatePermission(release, 'template#edit', 'release#task_transition');
    },
    hasEditTaskTagsPermission: function hasEditTaskTagsPermission(release) {
      if (release.archived) {
        return false;
      }

      return hasAppropriatePermission(release, 'template#edit', 'release#edit_task_tags');
    },
    hasEditTaskDescription: function hasEditTaskDescription(release) {
      if (release.archived) {
        return false;
      }

      return hasAppropriatePermission(release, 'template#edit', 'release#edit_task_description');
    },
    hasEditTaskDatesPermission: function hasEditTaskDatesPermission(release) {
      if (release.archived) {
        return false;
      }

      return hasAppropriatePermission(release, 'template#edit', 'release#edit_task_dates');
    },
    hasEditTaskFlagPermission: function hasEditTaskFlagPermission(release) {
      if (release.archived) {
        return false;
      }

      return hasAppropriatePermission(release, 'template#edit', 'release#edit_task_flag');
    },
    hasEditSecurityPermission: function hasEditSecurityPermission(release) {
      return this.hasPermission('security#edit') || hasAppropriatePermission(release, 'template#edit_security', 'release#edit_security');
    },
    hasPermissionToWorkOnTask: function hasPermissionToWorkOnTask(release, task) {
      if (release.archived) {
        return false;
      }

      return this.hasEditTaskPermission(release) || this.isAdminOr(task.owner) || this.isMemberOf(release, task.team);
    },
    //todo: refactor the permissions checker so template, release, and folders can use one method
    hasFolderPermission: function hasFolderPermission(permission, teams) {
      if (!this.isAdminOr(this.getUsername())) {
        var _iterator2 = _createForOfIteratorHelper(teams),
            _step2;

        try {
          for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
            var team = _step2.value;

            if (team.members.includes(this.getUsername()) && team.permissions.includes(permission)) {
              return true;
            }
          }
        } catch (err) {
          _iterator2.e(err);
        } finally {
          _iterator2.f();
        }

        return false;
      }

      return true;
    },
    hasReleaseGroupEditPermission: function hasReleaseGroupEditPermission(releaseGroup) {
      return this.hasPermission("group#edit", releaseGroup.$metadata);
    },
    hasDeliveryEditPermission: function hasDeliveryEditPermission(releaseGroup) {
      // TODO bdevic: MOVE THIS TO MODULE
      return this.hasPermission("delivery#edit", releaseGroup.$metadata);
    },
    hasEditTaskOrEditBlackoutPermission: function hasEditTaskOrEditBlackoutPermission(release) {
      return hasAppropriatePermission(release, EDIT_TASK_PERMISSION, 'release#edit_blackout');
    },
    hasEditTaskOrEditDatesPermission: function hasEditTaskOrEditDatesPermission(release) {
      return hasAppropriatePermission(release, EDIT_TASK_PERMISSION, 'release#edit_task_dates');
    },
    isAdmin: isAdmin,
    isAdminOr: function isAdminOr(user) {
      var userUsername = user ? user.username : null;
      var username = userUsername ? userUsername.toLowerCase() : null;
      var thisUsername = this.getUsername() ? this.getUsername().toLowerCase() : null;
      var permissions = ClientSettings.getPermissions();
      return permissions !== null && (isAdmin(permissions) || thisUsername !== null && thisUsername === username);
    },
    isMemberOf: function isMemberOf(release, team) {
      var permissions = ClientSettings.getPermissions();

      if (permissions !== null && isAdmin(permissions)) {
        return true;
      }

      var releaseTeams = release.security.teams;
      return releaseTeams !== null && (_.includes(releaseTeams, RELEASE_ADMIN_TEAM) || _.includes(releaseTeams, team));
    },
    login: function login(username, password, rememberMe) {
      var deferred = $q.defer();
      var loginPromise = deferred.promise;
      clearUserData();
      Backend.post("login".concat(rememberMe ? '?rememberMe=yes' : ''), {
        username: username,
        password: password
      }, null).then(function () {
        return loadUserDetails(username);
      }).then(function () {
        RedirectOnLoginService.redirect();
        $rootScope.$emit(Events.permission.loggedIn);
      }).catch(function (response) {
        return deferred.reject(response);
      });
      return loginPromise;
    },
    tryLoginByIdentityProvider: function tryLoginByIdentityProvider() {
      clearUserData();
      return this.loadUserDetailsByAuth().then(function () {
        RedirectOnLoginService.redirect();
      }).catch(function (err) {
        return err;
      });
    },
    // The method required by spnego plugin, see REL-5380 for details.
    loadUserDetailsByUsername: function loadUserDetailsByUsername(username) {
      clearUserData();
      return loadUserDetails(username).then(function () {
        RedirectOnLoginService.redirect();
        $rootScope.$emit(Events.permission.loggedIn);
      });
    },
    loadUserDetailsByAuth: function loadUserDetailsByAuth() {
      return Backend.get('auth', {
        dontRedirectWhenUnauthorized: true,
        hideAlert: true
      }).then(function (resp) {
        var identityProvider = resp.data.identityProvider;

        if (identityProvider) {
          ClientSettings.setIdentityProvider(identityProvider);
          return loadUserDetails(resp.data.userName).then(function () {
            return $rootScope.$emit(Events.permission.loggedIn);
          });
        }

        if (!authenticationService.isAuthenticated()) {
          return loadUserDetails(resp.data.userName).then(function () {
            return $rootScope.$emit(Events.ui.ensureMainMenuLoaded);
          });
        }

        return $q.resolve();
      });
    },
    logout: function logout() {
      return $q(function (resolve) {
        // Logout from IdP if needed.
        if (ClientSettings.getIdentityProvider()) {
          var logoutUrl = ClientSettings.getIdentityProvider().logoutUrl + '#' + (window.location.hash || '').replace(/^#+/, '');
          clearUserData(); // Redirect to the IdP logoutUrl. This promise will never resolved.

          WindowLocation.changeLocation(logoutUrl);
        } else {
          clearUserData();
          return Backend.get('logout').finally(resolve);
        }
      });
    }
  };
  return authenticationService;
}]);

/***/ }),

/***/ 1308:
/***/ (function(module, exports) {

angular.module('xlrelease').factory('Base64', function () {
  var keyStr = 'ABCDEFGHIJKLMNOP' + 'QRSTUVWXYZabcdef' + 'ghijklmnopqrstuv' + 'wxyz0123456789+/' + '=';
  return {
    getBasicAuthorization: function getBasicAuthorization(username, password) {
      return 'Basic ' + this.encode(username + ':' + password);
    },
    encode: function encode(input) {
      var output = "";
      var chr1,
          chr2,
          chr3 = "";
      var enc1,
          enc2,
          enc3,
          enc4 = "";
      var i = 0;

      do {
        chr1 = input.charCodeAt(i++);
        chr2 = input.charCodeAt(i++);
        chr3 = input.charCodeAt(i++);
        enc1 = chr1 >> 2;
        enc2 = (chr1 & 3) << 4 | chr2 >> 4;
        enc3 = (chr2 & 15) << 2 | chr3 >> 6;
        enc4 = chr3 & 63;

        if (isNaN(chr2)) {
          enc3 = enc4 = 64;
        } else if (isNaN(chr3)) {
          enc4 = 64;
        }

        output = output + keyStr.charAt(enc1) + keyStr.charAt(enc2) + keyStr.charAt(enc3) + keyStr.charAt(enc4);
        chr1 = chr2 = chr3 = "";
        enc1 = enc2 = enc3 = enc4 = "";
      } while (i < input.length);

      return output;
    }
  };
});

/***/ }),

/***/ 1309:
/***/ (function(module, exports) {

angular.module('xlrelease').factory('RedirectOnLoginService', ['$location', 'PageUrls', '$state', function ($location, PageUrls, $state) {
  var redirectOnLoginURL;

  function hasRedirectOnLoginUrl() {
    return redirectOnLoginURL;
  }

  function isWorthRedirectingTo(pageUrl) {
    return pageUrl !== PageUrls.LOGIN_PAGE;
  }

  return {
    redirect: function redirect() {
      if (hasRedirectOnLoginUrl()) {
        $location.url(redirectOnLoginURL);
        redirectOnLoginURL = undefined;
      } else {
        $state.go('releaseOverview');
      }
    },
    registerRequestedURL: function registerRequestedURL() {
      if (!hasRedirectOnLoginUrl() && isWorthRedirectingTo($location.path())) {
        redirectOnLoginURL = $location.url();
      }
    },
    clean: function clean() {
      redirectOnLoginURL = undefined;
    }
  };
}]);

/***/ }),

/***/ 131:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return ITEMS_PER_PAGE; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return DEFAULT_ORDER_BY; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return RELEASE_STATUS_FILTER_KEY_TO_STATUS; });
/* unused harmony export ENTITY_ID_PLACEHOLDER */
var ITEMS_PER_PAGE = 15;
var DEFAULT_ORDER_BY = 'start_date';
var RELEASE_STATUS_FILTER_KEY_TO_STATUS = {
  inProgress: 'IN_PROGRESS',
  completed: 'COMPLETED'
};
var ENTITY_ID_PLACEHOLDER = -1;

/***/ }),

/***/ 1310:
/***/ (function(module, exports) {

angular.module('xlrelease').factory('ConfigurationInstances', ['Backend', 'MetadataService', function (Backend, MetadataService) {
  var configurationInstances,
      configurationDescriptors,
      instancesByType = {},
      _loaded = false,
      loadingPromise = null;
  var resolvedInstancesByType = {};

  function getAllSubtypesOfType(type, descriptors) {
    return _(descriptors).filter(function (descriptor) {
      return _.includes(descriptor.superTypes, type);
    }).map('type').value();
  }

  function resolveInstancesByType(type, instancesByType, descriptors) {
    var typeInstances = instancesByType[type] || [];

    var subtypeInstances = _(instancesByType).pick(getAllSubtypesOfType(type, descriptors)).values().flatten().value();

    return _.union(typeInstances, subtypeInstances);
  }

  return {
    load: function load(folderId) {
      var useShortId = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;

      if (loadingPromise) {
        return loadingPromise;
      }

      loadingPromise = MetadataService.getConfigurationDescriptors().then(function (descriptors) {
        configurationDescriptors = descriptors;
        return Backend.get('api/v1/config/byTypeAndTitle', {
          params: {
            configurationType: 'xlrelease.Configuration',
            folderOnly: false,
            folderId: folderId
          }
        }).then(function (resp) {
          var instances = resp.data;
          configurationInstances = instances;
          instancesByType = _.groupBy(_.sortBy(instances, [function (ci) {
            return !!ci.title ? ci.title.toLowerCase() : ci.title;
          }]), 'type');
          _loaded = true;

          if (useShortId) {
            configurationInstances.forEach(function (x) {
              x.id = x.id.split('/').pop();
            });
          }

          return configurationInstances;
        });
      });
      return loadingPromise;
    },
    getTitle: function getTitle(id) {
      var instance = _.find(configurationInstances, {
        id: id
      });

      return instance ? instance.title : undefined;
    },
    getFolderId: function getFolderId(id) {
      var instance = _.find(configurationInstances, {
        id: id
      });

      return instance && instance.folderId ? instance.folderId : undefined;
    },
    getInstancesByType: function getInstancesByType(type) {
      if (_.isUndefined(resolvedInstancesByType[type])) {
        resolvedInstancesByType[type] = resolveInstancesByType(type, instancesByType, configurationDescriptors);
      }

      return resolvedInstancesByType[type];
    },
    reset: function reset() {
      configurationInstances = null;
      configurationDescriptors = null;
      resolvedInstancesByType = {};
      instancesByType = {};
      _loaded = false;
      loadingPromise = undefined;
    },
    loaded: function loaded() {
      return _loaded;
    }
  };
}]);

/***/ }),

/***/ 1311:
/***/ (function(module, exports) {

angular.module('xlrelease').directive('attachmentsList', ['Download', function (Download) {
  return {
    templateUrl: "partials/directives/attachments-list.html",
    restrict: 'A',
    scope: {
      attachments: '=',
      readonly: '&',
      canDeleteAttachments: '&',
      dismiss: '&',
      deleteAttachment: '&',
      uploadUrl: '='
    },
    link: function link(scope) {
      scope.attachmentAdded = function (result) {
        scope.attachments.push(result[0]);
      };

      scope.downloadAttachment = function (attachment) {
        Download.launch('export/attachments/' + attachment.id);
      };
    }
  };
}]);

/***/ }),

/***/ 1313:
/***/ (function(module, exports) {

angular.module('xlrelease').directive('displayMember', ['memberFormatterFilter', 'tooltipService', function (memberFormatterFilter, tooltipService) {
  return function (scope, element, attrs) {
    scope.$watch(attrs.displayMember, function (member) {
      var text = memberFormatterFilter(member);
      var memberName = member ? member.name : '';
      element.text(text); // Only display tooltip if it's different from the text

      if (text !== memberName) {
        tooltipService.setup(element, memberName, 'bottom');
      }
    }, true);
  };
}]);

/***/ }),

/***/ 1314:
/***/ (function(module, exports) {

angular.module('xlrelease').directive('displayUser', ['VariablesInterpolator', 'userFormatterFilter', 'tooltipService', function (VariablesInterpolator, userFormatterFilter, tooltipService) {
  function render(element, user, users, variables, tooltipPosition) {
    var isVariable = false;
    var username = user ? user.username : '';

    if (variables) {
      var maybeInterpolatedVariable = VariablesInterpolator.interpolateInText(variables, username);
      isVariable = maybeInterpolatedVariable !== username;
      username = maybeInterpolatedVariable;
    }

    var hasFullName = isVariable ? false : (user && user.fullName || '').trim().length > 0;

    var fullNameOrUsername = _.escape(hasFullName ? userFormatterFilter(user) : userFormatterFilter(isVariable ? users && users[username] || {
      username: username
    } : user));

    var userElement = isVariable ? angular.element("<span class=\"variable\">".concat(fullNameOrUsername, "</span>")) : angular.element("<span>".concat(fullNameOrUsername, "</span>"));
    element.html(userElement);

    if (fullNameOrUsername !== username) {
      tooltipService.setup(userElement, _.escape(username), tooltipPosition ? tooltipPosition : 'bottom', undefined, 'word-break-all');
    }
  }

  return function (scope, element, attrs) {
    if (attrs.variables) {
      scope.$watch('[' + attrs.displayUser + ',' + attrs.users + ', ' + attrs.variables + ']', function (watchedValues) {
        render(element, watchedValues[0], watchedValues[1], watchedValues[2], attrs.tooltipPosition);
      }, true);
    } else {
      scope.$watch("[".concat(attrs.displayUser, " , ").concat(attrs.users, "]"), function (watchedValues) {
        render(element, watchedValues[0], watchedValues[1], undefined, attrs.tooltipPosition);
      }, true);
    }
  };
}]);

/***/ }),

/***/ 1315:
/***/ (function(module, exports) {

angular.module('xlrelease').directive('durationEditor', ['$timeout', '$compile', 'DurationEditorService', function ($timeout, $compile, DurationEditorService) {
  var ACCEPTED_KEYS = [8
  /* Backspace */
  , 9
  /* Tab */
  , 46
  /* Delete */
  , 37, 38, 39, 40
  /* Up/Down/Left/Right*/
  ];
  var ENTER_KEYCODE = 13;
  var ESCAPE_KEYCODE = 27;

  function Picker(scope, element, commitAction) {
    this.scope = scope;
    this.element = element;
    var parentForm = element.inheritedData('$formController');

    this.commitAction = function () {
      if (parentForm) {
        parentForm.$setDirty();
      }

      commitAction.apply();
    };

    this.scope.adjustPosition = _.bind(this.adjustPosition, this);

    this.unregisterEvents = function () {
      angular.element(window).off('resize', this.resizeHandler);
      angular.element(document).off('mousedown touchstart', this.mouseHandler);
    };

    scope.$on('$destroy', _.bind(function () {
      this.$picker && this.$picker.remove();
    }, this));

    this.removePicker = function (e) {
      if (!(this.element.is(e.target) || this.element.find(e.target).length || this.$picker.is(e.target) || this.$picker.find(e.target).length)) {
        scope.$apply(_.bind(function () {
          this.closePicker(true);
        }, this));
      }
    };
  }

  Picker.prototype.show = function () {
    if (!this.$picker) {
      // building DOM element
      this.$picker = angular.element('<div class="datepicker datepicker-dropdown dropdown-menu datepicker-orient-left duration-picker"></div>').show();
      $compile(this.$picker.html('<div ng-include="\'partials/directives/duration-editor-fields.html\'" onload="adjustPosition()"></div>'))(this.scope);
      angular.element('body').append(this.$picker);
    }
  };

  Picker.prototype.adjustPosition = function () {
    this.resizeHandler = _.bind(this.adjustPosition, this);
    this.mouseHandler = _.bind(this.removePicker, this);
    this.unregisterEvents(); // Very inspired from bootstrap-datepicker.js

    var pickerWidth = this.$picker.outerWidth();
    var pickerHeight = this.$picker.outerHeight();
    var visualPadding = 10;
    var windowWidth = angular.element(window).width();
    var windowHeight = angular.element(window).height();
    var scrollTop = angular.element(window).scrollTop();
    var offset = this.element.offset();
    var height = this.element.outerHeight(false);
    var yOrient = 'auto';
    var topOverflow = -scrollTop + offset.top - pickerHeight;
    var bottomOverflow = scrollTop + windowHeight - (offset.top + height + pickerHeight);

    if (Math.max(topOverflow, bottomOverflow) === bottomOverflow) {
      yOrient = 'top';
    } else {
      yOrient = 'bottom';
    }

    var top = offset.top;

    if (yOrient === 'top') {
      top += height;
    } else {
      top -= pickerHeight + parseInt(this.$picker.css('padding-top'));
    }

    var left = offset.left;
    if (offset.left < 0) left -= offset.left - visualPadding;else if (offset.left + pickerWidth > windowWidth) left = windowWidth - pickerWidth - visualPadding;
    var zIndex = parseInt(this.element.parents().filter(function () {
      return angular.element(this).css('z-index') !== 'auto';
    }).first().css('z-index')) + 10;
    this.$picker.removeClass('datepicker-orient-top datepicker-orient-bottom ' + 'datepicker-orient-right datepicker-orient-left');
    this.$picker.addClass('datepicker-orient-left ' + 'datepicker-orient-' + yOrient);
    this.$picker.css({
      top: top,
      left: left,
      zIndex: zIndex,
      display: "block"
    });
    angular.element(window).on('resize', this.resizeHandler);
    angular.element(document).on('mousedown touchstart', this.mouseHandler);
    angular.element('.datepicker .days').focus();
  }; // Events


  Picker.prototype.closePicker = function (commit) {
    this.unregisterEvents();

    if (this.$picker) {
      this.$picker.remove();
      this.$picker = undefined;
    }

    if (commit) {
      this.commitAction();
    }
  };

  return {
    templateUrl: "partials/directives/duration-editor.html",
    restrict: 'A',
    scope: {
      duration: '=',
      inferredDuration: '&',
      onChange: '&',
      editable: '&',
      done: '&'
    },
    link: function link(scope, element) {
      var picker = new Picker(scope, element, function () {
        if (scope.duration !== scope.durationDraft) {
          scope.duration = scope.durationDraft;
          $timeout(function () {
            scope.onChange();
          });
        }
      });

      scope.showDurationPicker = function () {
        if (scope.editable()) {
          picker.show();
          var duration = DurationEditorService.hasDuration(scope.duration) ? scope.duration : scope.inferredDuration();
          scope.durationData = DurationEditorService.getDurationData(duration);
        }
      };

      scope.$watch('durationData', function (durationData) {
        scope.durationDraft = DurationEditorService.getDuration(durationData || {});
      }, true);

      scope.keyPress = function (event) {
        if (_.includes(ACCEPTED_KEYS, event.keyCode)) {
          return;
        }

        var input = String.fromCharCode(event.charCode || event.which);

        if (!/[0-9+]/.test(input)) {
          event.stopImmediatePropagation();
          event.preventDefault();
        }
      };

      scope.keyDown = function (event) {
        if (event.keyCode === ENTER_KEYCODE) {
          picker.closePicker(true);
        }

        if (event.keyCode === ESCAPE_KEYCODE) {
          picker.closePicker(false);
        }
      };

      scope.removeDuration = function () {
        scope.durationDraft = null;
        picker.closePicker(true);
      };

      scope.hasDuration = DurationEditorService.hasDuration;
    }
  };
}]);
angular.module('xlrelease').constant('Durations', function () {
  var ONE_SECOND = 1000;
  var ONE_MINUTE = 60 * ONE_SECOND;
  var ONE_HOUR = 60 * ONE_MINUTE;
  var ONE_DAY = 24 * ONE_HOUR;
  return {
    ONE_SECOND: ONE_SECOND,
    ONE_MINUTE: ONE_MINUTE,
    ONE_HOUR: ONE_HOUR,
    ONE_DAY: ONE_DAY
  };
}());
angular.module('xlrelease').factory('DurationEditorService', ['Durations', function (Durations) {
  return {
    hasDuration: function hasDuration(duration) {
      return duration !== null;
    },
    getDurationData: function getDurationData(durationInMs) {
      var durationInSec = durationInMs / 1000;
      var durationInMin = Math.round(durationInSec / 60);
      var durationInHour = durationInMin / 60;
      var durationInDay = durationInHour / 24;
      return {
        days: Math.floor(durationInDay),
        hours: Math.floor(durationInHour % 24),
        minutes: Math.floor(durationInMin % 60)
      };
    },
    getDuration: function getDuration(durationData) {
      function toUInt(value) {
        var result = parseFloat(value) || 0;
        return result >= 0 ? result : 0;
      }

      var days = toUInt(durationData.days);
      var hours = toUInt(durationData.hours);
      var minutes = toUInt(durationData.minutes);
      return Durations.ONE_DAY * days + Durations.ONE_HOUR * hours + Durations.ONE_MINUTE * minutes;
    }
  };
}]);
angular.module('xlrelease').filter('prettyDuration', ['DurationEditorService', function (DurationEditorService) {
  function formatTime(number, letter) {
    return ("" + number).slice(-2) + letter;
  }

  return function (input) {
    if (!DurationEditorService.hasDuration(input)) {
      return "";
    }

    var durationData = DurationEditorService.getDurationData(input);

    if (_.isMatch(durationData, {
      days: 0,
      hours: 0,
      minutes: 0
    })) {
      return "0d 0h 0m";
    }

    var result = durationData.days ? durationData.days + 'd' : '0d';
    result += ' ' + formatTime(durationData.hours, "h") + ' ' + formatTime(durationData.minutes, "m");
    return result.replace(/^\s+|\s+$/g, '');
  };
}]);
/*
 Filter for converting duration to a "human" format.
 The output is converted to the two most significant units.
 So 2 days, 5 hours and 12 minutes will be converted to 2 days and 5 hours.
 If the second unit is 0 then it will be left off, so 2 days and 0 hours will be 2 days.
*/

angular.module('xlrelease').filter('humanizedDuration', function () {
  return function (duration) {
    if (!duration) {
      return "";
    }

    var formatYear = function formatYear() {
      return duration.years() + (duration.years() === 1 ? " year" : " years");
    };

    var formatMonth = function formatMonth() {
      return duration.months() + (duration.months() === 1 ? " month" : " months");
    };

    var formatDay = function formatDay() {
      return duration.days() + (duration.days() === 1 ? " day" : " days");
    };

    var formatHour = function formatHour() {
      return duration.hours() + (duration.hours() === 1 ? " hour" : " hours");
    };

    var formatMinute = function formatMinute() {
      return duration.minutes() + (duration.minutes() === 1 ? " minute" : " minutes");
    };

    var result = "";

    if (duration.years() > 0) {
      result = duration.months() > 0 ? formatYear() + ' and ' + formatMonth() : formatYear();
    } else if (duration.months() > 0) {
      result = duration.days() > 0 ? formatMonth() + ' and ' + formatDay() : formatMonth();
    } else if (duration.days() > 0) {
      result = duration.hours() > 0 ? formatDay() + ' and ' + formatHour() : formatDay();
    } else if (duration.hours() > 0) {
      result = duration.minutes() > 0 ? formatHour() + ' and ' + formatMinute() : formatHour();
    } else if (duration.minutes() > 0) {
      result = formatMinute();
    }

    return result;
  };
});
angular.module('xlrelease').directive('ganttDurationEditor', ['GanttElementsEditor', function (GanttElementsEditor) {
  function getParameterValue(param, parent) {
    var value = parent.data(param);
    return value !== 'null' ? value : null;
  }

  function getParameterBooleanValue(param, parent) {
    var value = parent.data(param);
    return value === true;
  }

  return {
    template: "<div duration-editor duration='duration' on-change='setDuration(duration)' editable='editable' inferred-duration='displayDuration' done='done'></div>",
    restrict: 'A',
    scope: true,
    link: function link(scope, element) {
      var parent = element.parent();
      if (!parent.length) return;
      scope.duration = getParameterValue('duration', parent);
      scope.displayDuration = getParameterValue('display-duration', parent);
      scope.editable = getParameterBooleanValue('editable', parent);
      scope.done = getParameterBooleanValue('done', parent);
      var id = parent.data('id');

      scope.setDuration = function (duration) {
        var ganttElement = gantt.getTask(id);
        GanttElementsEditor.setDuration(ganttElement, duration);
      };
    }
  };
}]);

/***/ }),

/***/ 1316:
/***/ (function(module, exports) {

angular.module('xlrelease').directive('expander', ['$timeout', function ($timeout) {
  return {
    scope: {
      expanderState: '='
    },
    link: function link(scope, element, attrs) {
      scope.expanderState = scope.expanderState || {};

      function set() {
        if (scope.expanderState[attrs.expander]) {
          angular.element("#".concat(attrs.expander)).addClass("hide");
          element.find(".expander.arrow-down-icon").addClass("hide");
          element.find(".expander.arrow-right-icon").removeClass("hide");
        } else {
          angular.element("#".concat(attrs.expander)).removeClass("hide");
          element.find(".expander.arrow-down-icon").removeClass("hide");
          element.find(".expander.arrow-right-icon").addClass("hide");
        }
      }

      $timeout(set);
      element.find(".expander").on('click', function () {
        scope.expanderState[attrs.expander] = !scope.expanderState[attrs.expander];
        set();
      });
    }
  };
}]);

/***/ }),

/***/ 1317:
/***/ (function(module, exports) {

angular.module('xlrelease').directive('focusOnClick', function () {
  return {
    restrict: 'A',
    link: function link(scope, el) {
      el.css('cursor', 'text');
      el.on('click', function () {
        el.find('input').focus();
      });
    }
  };
});

/***/ }),

/***/ 1318:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').directive('notInList', function () {
  return {
    restrict: 'A',
    require: 'ngModel',
    scope: {
      values: '=notInList'
    },
    link: function link($scope, elm, attrs, ctrl) {
      ctrl.$validators.notInList = function (modelValue, viewValue) {
        if (angular.isUndefined($scope.values)) {
          return true;
        }

        if (!angular.isArray($scope.values)) {
          throw new Error("List of values for 'not-in-list' directive must be an array: " + $scope.values);
        }

        if (ctrl.$isEmpty(modelValue)) {
          return true;
        }

        if (angular.isUndefined(viewValue)) {
          return true;
        }

        if (angular.isDefined(attrs.caseInsensitive)) {
          return !$scope.values.some(function (value) {
            return value.toLowerCase() === viewValue.toLowerCase();
          });
        } else {
          return !$scope.values.includes(viewValue);
        }
      };
    }
  };
});

/***/ }),

/***/ 1319:
/***/ (function(module, exports) {

angular.module('xlrelease').directive('pagination', [function () {
  return {
    templateUrl: 'partials/directives/pagination.html',
    scope: {
      ciLoader: '='
    }
  };
}]);

/***/ }),

/***/ 1320:
/***/ (function(module, exports) {

angular.module('xlrelease').factory('onClickOutsideService', [function () {
  return {
    setup: function setup(element, acceptTarget, action) {
      var clickHandler = function clickHandler(event) {
        if (acceptTarget(angular.element(event.target))) {
          action();
        }
      };

      angular.element(document).on('click', clickHandler);
      angular.element(document).on('mousedown', clickHandler);
      element.on('$destroy', function () {
        angular.element(document).off('click', clickHandler);
        angular.element(document).off('mousedown', clickHandler);
      });
    }
  };
}]);
angular.module('xlrelease').directive('onClickOutside', ['onClickOutsideService', '$parse', function (onClickOutsideService, $parse) {
  return function (scope, element, attrs) {
    var acceptTarget = function acceptTarget(target) {
      return !target.is(element) && !target.parents().is(element);
    };

    var action = function action() {
      scope.$apply(function () {
        $parse(attrs.onClickOutside)(scope);
      });
    };

    onClickOutsideService.setup(element, acceptTarget, action);
  };
}]);
angular.module('xlrelease').directive('hidePopoverOnClick', function () {
  return function (scope, element) {
    element.on('click', function () {
      if (element.attr('disabled')) {
        return;
      }

      element.parents().find('.popover').each(function () {
        var popoverScope = angular.element(this).scope();
        popoverScope.$apply(function () {
          popoverScope.$hide();
        });
      });
    });
  };
});

/***/ }),

/***/ 1321:
/***/ (function(module, exports) {

angular.module('xlrelease').directive('stopClickPropagation', function () {
  return function (scope, element) {
    element.on('click', function (event) {
      event.stopPropagation();
    });
  };
});
angular.module('xlrelease').directive('stopSubmitPropagation', function () {
  return function (scope, element) {
    element.on('keyup keypress', function (event) {
      var code = event.keyCode || event.which;

      if (code === 13) {
        event.stopPropagation();
        return false;
      }
    });
  };
});

/***/ }),

/***/ 1322:
/***/ (function(module, exports) {

angular.module('xlrelease').directive('scrollToItem', function () {
  return {
    restrict: 'A',
    scope: {
      container: "@",
      scrollTo: "@"
    },
    link: function link(scope, $elm, attr) {
      $elm.on("click", function () {
        var $container = angular.element(scope.container);
        var scrollOffset = angular.element(scope.scrollTo).offset().top - $container.offset().top;
        $container.animate({
          scrollTop: scrollOffset
        }, "slow");
      });
    }
  };
});

/***/ }),

/***/ 1323:
/***/ (function(module, exports) {

/**
 * Detects fully visible items in the parent container.
 *
 * Example:
 * <div class="card-content">
 *      <div class="report-content">
 *          <div show-fully-visible-only parent-selector=".card-content">
 *              <div class="row" ng-repeat="activity in $ctrl.deploymentsActivity"></div>
 *          </div>
 *      </div>
 * </div>
 */
angular.module('xlrelease').directive('detectFullyVisibleItems', ['$timeout', function ($timeout) {
  return {
    restrict: 'A',
    link: function link(scope, element, $attrs) {
      $timeout(function () {
        var outerHeight = ($attrs.parentSelector ? element.parents($attrs.parentSelector) : element).outerHeight();
        var totalHeight = 0;
        var lastVisibleItem;
        element.children().each(function () {
          var currentElement = angular.element(this);
          totalHeight += currentElement.outerHeight();

          if (totalHeight > outerHeight) {
            currentElement.addClass('not-fully-visible-item');
            currentElement.nextAll().addClass('not-visible-item');
            return false;
          }

          lastVisibleItem = currentElement.addClass('fully-visible-item');
        });

        if (lastVisibleItem) {
          lastVisibleItem.addClass('last-visible-item');
        }
      });
    }
  };
}]);

/***/ }),

/***/ 1324:
/***/ (function(module, exports) {

/**
 * @ngdoc directive
 * @module xlrelease
 * @name contextMenu
 *
 * @element ANY
 * @description renders menu items using task-context-menu.html template. Menu items can be passed into the directive
 * using `items` attribute. `items` attribute will be evaluated and it should return array of menu items in the
 * expected format (see example or a template for the expected format of menu items).
 *
 * @param {expression} expression to evaluate that will return menu items
 *
 * @example
 * This example shows how to create context menu with a help of a popover.
 * To create a popover:
 *
 ```
 <div ng-if="!isTaskReadOnly(task) || isTaskDoneInAdvance(task)" class="context-menu-button dropdown-button pull-right"
 bs-popover data-content-template="partials/tasks/context-menu.html" data-placement="bottom" auto-close="true" >
 ```
 *
 * and a context-menu.html (uses this directive):
 ```
 <context-menu id="context-menu-container" items="taskContextMenuItems(task, release, container, groupedTaskDefinitions) ctrl='ctrl' task='task' container='task.parent'"></context-menu>
 ```
 *
 * where :
 * ctrl is the controller that offers the necessary functions to the opened modals. The ctrl must have a 'ctrlScope' property. This is used as the parent scope
 *      the resulting model.
 * task is the task that this context menu controls.
 * container is the container for the current task
 * taskContextMenuItems is a controller method that returns menu items with the following structure:
 ```
 var items = [
 {
     type: 'modal,
     text: 'Menu item',
     disabled: 'true|false',
     modal: 'partials/modal/to/show.html',
     cssClass: 'remove-task-button'
 },
 {
     type: 'click',
     text: 'Menu item',
     disabled: 'true|false',
     click: function () {
         // click Action, optional
     },
     cssClass: 'something'
 },
 {
     type: 'noaction',
     text: 'Menu item',
     disabled: 'true',
     cssClass: 'some-class'
 },
 {
     type: 'divider'
 },
 {
     type: 'template',
     disabled: 'true',
     templateUrl: '',
     isSameType: '',
     taskDefinition: {}
 },
 {
     type: 'submenu',
     items: [
     ]
 }
 ];
 ```
 */
angular.module('xlrelease').directive('contextMenuPopover', ['$popover', function ($popover) {
  return {
    restrict: 'A',
    replace: true,
    template: '<div class="context-menu-button dropdown-button pull-right"><i class="xl-icon options-icon"></i></div>',
    link: function link(scope, element, attrs) {
      scope.items = scope.$eval(attrs.items);

      if (attrs.task) {
        scope.task = scope.$eval(attrs.task);
      }

      if (attrs.container) {
        scope.container = scope.$eval(attrs.container);
      }

      scope.scrollableChangeTaskType = scope.$eval(attrs.scrollableChangeTaskType);

      var handleScrollPhase = function handleScrollPhase(event) {
        var popover = event.data.popover;
        popover.hide();
      };

      $popover(element, {
        scope: scope,
        templateUrl: attrs.templateUrl ? attrs.templateUrl : 'partials/tasks/context-menu.html',
        placement: 'auto bottom',
        viewport: {
          selector: attrs.selector ? attrs.selector : '#release-content'
        },
        autoClose: true,
        target: element,
        onBeforeShow: function onBeforeShow(attr) {
          if (attrs.selector) {
            angular.element("".concat(attrs.selector, " .popover")).hide();
          }
        },
        onShow: function onShow(attr) {
          if (!attrs.selector) {
            var popover = attr.$element;
            var phaseContent = popover.closest('.phase-content');
            phaseContent.on('scroll', {
              popover: popover
            }, handleScrollPhase);
          }
        },
        onBeforeHide: function onBeforeHide(attr) {
          if (!attrs.selector) {
            var popover = attr.$element;
            var phaseContent = popover.closest('.phase-content');
            phaseContent.off('scroll', handleScrollPhase);
          }
        }
      });
    }
  };
}]);
angular.module('xlrelease').directive('contextMenu', ['$window', 'ModalService', function ($window, ModalService) {
  return {
    templateUrl: 'partials/tasks/task-context-menu.html',
    restrict: 'EA',
    link: function link(scope, element, attr) {
      scope.items = scope.$eval(attr.items);
      scope.task = scope.$eval(attr.task);

      if (attr.ctrl) {
        scope.ctrl = scope.$eval(attr.ctrl);
      }

      if (attr.container) {
        scope.container = scope.$eval(attr.container);
      }

      scope.contentContainer = element;
      scope.getContentPath = getContentPath;

      scope.openModal = function (modalUrl, item) {
        if (item.disabled) {
          return;
        }

        var childScope = scope.ctrl.ctrlScope.$new();
        childScope.task = scope.task;
        childScope.ctrl = scope.ctrl;
        childScope.container = scope.container;
        childScope.item = item;
        ModalService.open(childScope, "'".concat(modalUrl, "'"), null, null, false, false);
        childScope.showModal();
      };

      scope.handleClick = function (item) {
        if (item.disabled) {
          return;
        }

        var promise = item.click();

        var processHandler = function processHandler() {
          if (scope.ctrl.contextMenuClickProcessed) {
            scope.ctrl.contextMenuClickProcessed(true);
          }
        };

        if (promise && promise.then) {
          promise.then(processHandler);
        } else {
          processHandler();
        }
      };

      scope.mouseEnter = function (event, item) {
        if (item.disabled) {
          return;
        }

        var $li = angular.element(event.currentTarget);
        var $ul = $li.parent();
        var level = $ul.data('level') || 0;
        resetActiveElements(scope.contentContainer, level);
        var contentId = $li.data('content-id');

        if (contentId) {
          var $content = scope.contentContainer.find("ul[data-id=\"".concat(contentId, "\"]"));

          if ($content.length) {
            $li.addClass('active');
            $content.addClass('active');

            var _getContentCoords = getContentCoords($li, $ul, $content, $window),
                top = _getContentCoords.top,
                left = _getContentCoords.left;

            $content.css({
              top: "".concat(top, "px"),
              left: "".concat(left, "px")
            });
          }
        }
      };

      element.addClass('dropdown');
    }
  };
}]);

function getContentCoords($li, $ul, $content, $window) {
  var ulPaddingTop = parseInt($ul.css('padding-top'), 10);
  var ulBorderTop = parseInt($ul.css('border-top-width'), 10);
  var ulBorderLeft = parseInt($ul.css('border-left-width'), 10);
  var top = $ul.position().top + $li.position().top - ulPaddingTop + ulBorderTop - 1;
  var left = $ul.position().left + $li.position().left + $li.width() + ulBorderLeft;

  if ($li.offset().top + $content.height() > $window.innerHeight) {
    top = top - $content.height() + $li.height();
  }

  return {
    top: top,
    left: left
  };
}

function resetActiveElements(contentContainer, level) {
  var lis = level ? contentContainer.find("ul.dropdown-menu[data-level=\"".concat(level, "\"] li")) : contentContainer.find("ul.dropdown-menu li");
  lis.removeClass('active');
  contentContainer.find("ul.dropdown-menu[data-level=\"".concat(level + 1, "\"]")).removeClass('active');
  contentContainer.find("ul.dropdown-menu[data-level=\"".concat(level + 2, "\"]")).removeClass('active');
}

function getContentPath(parentPath, item) {
  return parentPath ? "".concat(parentPath, "/").concat(item.text) : item.text;
}

angular.module('xlrelease').directive('portal', [function () {
  return {
    restrict: 'EA',
    link: function link(scope, element) {
      // [div.portal] < [li.dropdown-submenu] < [ul.dropdown-menu] < [div#context-menu-container]
      var container = element.parent().parent().parent();
      scope.path = getContentPath(scope.path, scope.item);

      if (container.length) {
        var content = element.children();
        content.attr('data-level', scope.level);
        content.attr('data-id', scope.path);
        container.append(content);
      }

      element.remove();
    }
  };
}]);

/***/ }),

/***/ 1325:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').directive('timeZoneTooltip', ['tooltipService', 'CurrentTimeZone', function (tooltipService, CurrentTimeZone) {
  return {
    restrict: 'A',
    link: function link(scope, element) {
      var text = CurrentTimeZone.timeZone;
      tooltipService.setup(element, text, 'right');
    }
  };
}]);
angular.module('xlrelease').factory('CurrentTimeZone', [function () {
  var timeZone = jstz.determine().name(); // "America/New_York" becomes "New York"

  timeZone = timeZone.replace(/^.*\//, '').replace(/_/g, ' ');
  return {
    timeZone: timeZone
  };
}]);

/***/ }),

/***/ 1326:
/***/ (function(module, exports) {

angular.module('xlrelease').factory('tooltipService', ['$tooltip', '$window', function ($tooltip, $window) {
  return {
    setup: function setup(element, tooltipTitle, position, threshold, additionalClass) {
      var clazz = additionalClass ? additionalClass : '';

      if (!position) {
        position = 'top';
      }

      var tt;

      var initTooltip = function initTooltip() {
        if (additionalClass) {
          return $tooltip(element, {
            title: tooltipTitle,
            placement: position,
            html: true,
            isTemplatePath: false,
            template: "<div class=\"tooltip in\" role=\"tooltip\">\n                                        <div class=\"tooltip-arrow\"></div>\n                                        <div class=\"tooltip-inner ".concat(additionalClass, "\" ng-bind=\"title\"></div>\n                                    </div>"),
            container: 'body'
          });
        }

        return $tooltip(element, {
          title: tooltipTitle,
          placement: position,
          html: true,
          container: 'body'
        });
      };

      var onResize = function onResize() {
        if ($window.innerWidth <= threshold && !tt) {
          tt = initTooltip();
        } else if ($window.innerWidth > threshold && tt) {
          tt.destroy();
          tt = undefined;
        }
      };

      if (threshold) {
        if ($window.innerWidth <= threshold) {
          tt = initTooltip();
        }

        angular.element($window).on('resize', onResize);
      } else {
        tt = initTooltip();
      }

      element.on("$destroy", function () {
        angular.element($window).off('resize', onResize);

        if (tt) {
          tt.destroy();
        }
      });
    }
  };
}]);
/**
 * Wraps bootstrap tooltip (see http://getbootstrap.com/2.3.2/javascript.html#tooltips)
 *
 * Usage:
 *      Static text :
 *          <span tooltip="'tooltip content'" tooltip-position="top | bottom | left | right"></span>
 *      Dynamic property (here object.property) :
 *          <span tooltip="object.property" tooltip-position="top | bottom | left | right"></span>
 *
 * The tooltip-position attribute is optional, default value is "top".
 * HTML gets escaped.
 */

angular.module('xlrelease').directive('tooltip', ['tooltipService', function (tooltipService) {
  return {
    restrict: 'A',
    link: function link(scope, element, attrs) {
      scope.$watch(attrs.tooltip, function (value) {
        tooltipService.setup(element, _.escape(value), attrs.tooltipPosition, attrs.tooltipThreshold, attrs.additionalClass);
      });
    }
  };
}]);

/***/ }),

/***/ 1327:
/***/ (function(module, exports) {

angular.module('xlrelease').factory('UserCompletion', ['usernameFormatterFilter', function (usernameFormatterFilter) {
  return {
    completionMatcher: function completionMatcher(users) {
      // Ensure username will be set in the input when choosing a candidate.
      _.forEach(users, function (user) {
        return user.value = user.username;
      });

      return function (request, response) {
        var search = request.term.toLowerCase();

        var matches = function matches(name, s) {
          return name ? name.toLowerCase().includes(s) : false;
        };

        var filteredUsers = _.filter(users, function (user) {
          return matches(user.username, search) || matches(user.fullName, search);
        });

        return response(filteredUsers);
      };
    },
    getUserFromItem: function getUserFromItem(item) {
      return {
        username: item.username,
        fullName: item.fullName
      };
    },
    renderItem: function renderItem(ul, user) {
      var div = angular.element('<div>');
      var a = angular.element('<a class="principal"><span class="xl-icon tag-icon">');
      var label = angular.element('<span class="tag-label">');
      label.append(document.createTextNode(usernameFormatterFilter(user)));
      label.appendTo(a);
      a.appendTo(div);
      return angular.element('<li>').attr('data-ui-autocomplete-item', angular.toJson(user)).append(div).appendTo(ul);
    }
  };
}]);

/***/ }),

/***/ 1328:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


(function () {
  var XlrDipOfInlineWithVariablesDirective = function XlrDipOfInlineWithVariablesDirective() {
    return {
      scope: {
        propertyDefinitions: '=',
        propertyValues: '=',
        ci: '<',
        variables: '=',
        readOnly: '=',
        enforceMode: '=',
        showRequiredSign: '=?',
        // for task input properties of type text we don't use variable selector, for output properties we do
        showVariableSelectorForText: '=',
        onChange: '&',
        onNewVariable: '&',
        ignoreScriptVariableInterpolation: '=',
        reloadTaskVariablesCallback: '&'
      },
      restrict: 'AE',
      templateUrl: 'partials/directives/xlr-dip-of-inline-with-variables.html',
      controller: 'xlrDipOfInlineWithVariablesController',
      controllerAs: 'xlrDipCtrl',
      bindToController: true
    };
  };

  var injectParams = ['$scope', 'ConfigurationInstances', 'newlinesFilter', '$stateParams', 'Ids'];

  var XlrDipOfInlineWithVariablesController = function XlrDipOfInlineWithVariablesController($scope, ConfigurationInstances, newlinesFilter, $stateParams, Ids) {
    var vm = this;
    vm.newlinesFilter = newlinesFilter;
    vm.IGNORE_SCRIPT_VARIABLE_INTERPOLATION = 'scriptIgnoreVariableInterpolation';
    vm.showRequiredSign = _.isUndefined(vm.showRequiredSign) ? true : vm.showRequiredSign;
    vm.ConfigurationInstances = ConfigurationInstances;

    vm.onNewVariablePF = function (name, variableType, createdCallback) {
      vm.onNewVariable({
        name: name,
        variableType: variableType,
        createdCallback: createdCallback
      });
    };

    var selectOptions = {};

    vm.selectOptions = function (p) {
      if (_.isUndefined(selectOptions[p.name])) {
        selectOptions[p.name] = (p.required ? [] : [{
          title: "(None)",
          id: null
        }]).concat(ConfigurationInstances.getInstancesByType(p.referencedType));
      }

      return selectOptions[p.name];
    }; ///


    vm.updateIgnoreVariableInterpolation = function () {
      vm.onChange().then(function () {
        vm.reloadTaskVariablesCallback();
      });
    };

    vm.ignoreVariableInterpolation = function (name) {
      return vm.hasIgnoreScriptProperty(name) && vm.propertyValues[vm.IGNORE_SCRIPT_VARIABLE_INTERPOLATION].value;
    };

    vm.hasIgnoreScriptProperty = function (propertyName) {
      return propertyName === 'script' && angular.isDefined(vm.propertyValues[vm.IGNORE_SCRIPT_VARIABLE_INTERPOLATION]);
    };

    if (!ConfigurationInstances.loaded()) {
      var folderId = $stateParams.folderId ? $stateParams.folderId : Ids.releaseIdToFolderId($stateParams.releaseId);
      ConfigurationInstances.load(folderId);
    }

    vm.hasInputHintWithMethodRef = function (p) {
      return _.has(p, ['inputHint', 'method-ref']);
    };

    vm.hasInputHintWithDynamicLookup = function (p) {
      return _.has(p, ['inputHint', 'dynamic-lookup']);
    };

    vm.isDynamicLookup = function (p) {
      return vm.hasInputHintWithDynamicLookup(p) && _.get(p, ['inputHint', 'dynamic-lookup']);
    };

    $scope.$on('$destroy', function () {
      ConfigurationInstances.reset();
    });
  };

  XlrDipOfInlineWithVariablesController.$inject = injectParams;
  angular.module('xlrelease').controller('xlrDipOfInlineWithVariablesController', XlrDipOfInlineWithVariablesController);
  angular.module('xlrelease').directive('xlrDipOfInlineWithVariables', XlrDipOfInlineWithVariablesDirective);
})();

/***/ }),

/***/ 1329:
/***/ (function(module, exports) {

angular.module('xlrelease').directive('xlrInlineTextWithVariables', xlrInputWithVariablesDirective({
  variableTypeId: 'StringVariable',
  templateUrl: 'partials/directives/variable-selector/xlr-inline-text-with-variables.html'
}));
angular.module('xlrelease').directive('xlrInlineTextareaWithVariables', xlrInputWithVariablesDirective({
  variableTypeId: 'StringVariable',
  templateUrl: 'partials/directives/variable-selector/xlr-inline-textarea-with-variables.html',
  getAllTypes: true,
  transclude: true
}));
angular.module('xlrelease').directive('xlrInlinePasswordWithVariables', xlrInputWithVariablesDirective({
  variableTypeId: 'PasswordStringVariable',
  templateUrl: 'partials/directives/variable-selector/xlr-inline-password-with-variables.html'
}));
angular.module('xlrelease').directive('xlrListOfStringsWithVariables', xlrInputWithVariablesDirective({
  variableTypeId: 'ListStringVariable',
  templateUrl: 'partials/directives/variable-selector/xlr-list-of-strings-with-variables.html'
}));
angular.module('xlrelease').directive('xlrSetOfStringsWithVariables', xlrInputWithVariablesDirective({
  variableTypeId: 'SetStringVariable',
  templateUrl: 'partials/directives/variable-selector/xlr-set-of-strings-with-variables.html'
}));
angular.module('xlrelease').directive('xlrMapStringStringWithVariables', xlrInputWithVariablesDirective({
  variableTypeId: 'MapStringStringVariable',
  templateUrl: 'partials/directives/variable-selector/xlr-map-string-string-with-variables.html'
}));
angular.module('xlrelease').directive('xlrBooleanWithVariables', xlrInputWithVariablesDirective({
  variableTypeId: 'BooleanVariable',
  templateUrl: 'partials/directives/variable-selector/xlr-boolean-with-variables.html'
}));
angular.module('xlrelease').directive('xlrIntegerWithVariables', xlrInputWithVariablesDirective({
  variableTypeId: 'IntegerVariable',
  templateUrl: 'partials/directives/variable-selector/xlr-integer-with-variables.html'
}));
angular.module('xlrelease').directive('xlrDependencyWithVariables', xlrInputWithVariablesDirective({
  variableTypeId: 'StringVariable',
  templateUrl: 'partials/directives/variable-selector/xlr-dependency-with-variables.html'
}));
angular.module('xlrelease').directive('xlrDateWithVariables', xlrInputWithVariablesDirective({
  variableTypeId: 'DateVariable',
  templateUrl: 'partials/directives/variable-selector/xlr-date-with-variables.html'
}));
angular.module('xlrelease').directive('xlrDropdownWithVariables', xlrInputWithVariablesDirective({
  variableTypeId: 'StringVariable',
  templateUrl: 'partials/directives/variable-selector/xlr-dropdown-with-variables.html'
}));
angular.module('xlrelease').directive('xlrTemplateFromValueOrVariableSelector', xlrInputWithVariablesDirective({
  variableTypeId: 'StringVariable',
  templateUrl: 'partials/directives/xlr-template-from-value-or-variable-selector.html'
}));
angular.module('xlrelease').directive('xlrFolderFromValueOrVariableSelector', xlrInputWithVariablesDirective({
  variableTypeId: 'StringVariable',
  templateUrl: 'partials/directives/xlr-folder-from-value-or-variable-selector.html'
}));

function xlrInputWithVariablesDirective(viewParameters) {
  var directive = {
    scope: {
      name: '=',
      model: '=',
      onNew: '&',
      supportsNew: '=?',
      onChange: '&',
      resetValueOnToggle: '<',
      variables: '=',
      options: '=',
      readOnly: '=',
      isReady: '=?',
      enforceMode: '=',
      position: '=?',
      release: '=?',
      dateFormat: '@',
      resetCounter: '=',
      extension: '=?',
      multiline: '<?'
    },
    transclude: !!viewParameters.transclude,
    restrict: 'A',
    controller: InputWithVariablesController,
    controllerAs: 'vm',
    bindToController: true,
    templateUrl: viewParameters.templateUrl
  };
  InputWithVariablesController.$inject = ['$q', '$scope', 'VariablesService'];

  function InputWithVariablesController($q, $scope, VariablesService) {
    var vm = this;
    vm.$scope = $scope;
    var draftIsInitialized = false;
    var resetCounter = 0;
    vm.handlers = {
      onSelect: viewParameters.getAllTypes ? variableTextAreaSelectedHandler : variableSelectedHandler,
      addCandidates: viewParameters.getAllTypes ? variableTextInputAutocompleteHandler : variableAutocompleteHandler,
      onFormat: function onFormat(value) {
        var formattedValue = VariablesService.hasVariableSyntax(value) ? value : VariablesService.withVariableSyntax(value); // if formattedValue matches fully an existing variable name, take the full displayName to remove the 'New item' option

        var existingVariable = _.find(vm.variables, {
          variableName: formattedValue
        });

        if (existingVariable) {
          formattedValue = existingVariable.displayName;
        }

        return formattedValue;
      }
    };

    this.$onInit = function () {
      var supportsNew = angular.isDefined(vm.supportsNew) ? vm.supportsNew : true;

      if (supportsNew) {
        vm.handlers.onNewItem = createNewVariableHandler;
        vm.handlers.onNewItemInTextArea = createNewVariableInTextAreaHandler;
      }
    };

    vm.toggleMode = toggleMode;
    vm.onChangeInternal = onChangeInternal;
    vm.onValueChange = onValueChange;
    vm.updateDraftFromModel = updateDraftFromModel;
    vm.updateModelFromDraft = updateModelFromDraft;
    vm.onNewVariable = onNewVariable;
    var variableType = VariablesService.getVariableTypeById(viewParameters.variableTypeId);
    vm.variableType = variableType.key;
    vm.showToggle = false;
    vm.variableTypeName = variableType.label;
    vm.commit = commit;
    calculateMode(); /////

    function onNewVariable(variable) {
      VariablesService.createReleaseVariable(vm.release.id, variable).then(function (resp) {
        if (variable.createdCallback) {
          variable.createdCallback(resp.data);
        }
      });
    }

    function updateDraftFromModel(model) {
      vm.draft = {
        variable: _.find(vm.variables, {
          variableName: model.variable
        }),
        value: model.value
      };
    }

    function updateModelFromDraft(draft, variableMode) {
      var value = draft.value;
      if (!variableMode && value === vm.model.value && vm.variableTypeName === 'Date') return false;
      var variableName = draft.variable ? draft.variable.variableName : null;

      if (vm.enforceMode === 'variable') {
        _.assignIn(vm.model, {
          value: value,
          variable: variableName
        });
      } else {
        _.assignIn(vm.model, {
          value: !variableMode ? value : null,
          variable: variableMode ? variableName : null
        });
      }

      return true;
    } /////


    $scope.$watch(function () {
      return {
        model: vm.model,
        variables: vm.variables
      };
    }, function (val) {
      var isValidModelValue = !(_.isNull(val.model) || _.isUndefined(val.model));
      var newResetCounter = vm.resetCounter && val.model && val.model.key && val.model.inherited ? vm.resetCounter[val.model.key] || 0 : 0;

      if ((!draftIsInitialized || resetCounter < newResetCounter) && isValidModelValue && val.variables) {
        vm.updateDraftFromModel(val.model);
        calculateMode();
        draftIsInitialized = true;
        resetCounter = newResetCounter;
      }
    }, true);
    $scope.$watch('vm.draft.variable', function (newVariable, oldVariable) {
      if (oldVariable && !newVariable) {
        variableDeselectedHandler();
      }
    });

    function commit() {
      var isModelUpdated = vm.updateModelFromDraft(vm.draft, vm.variableMode);

      if (isModelUpdated) {
        vm.onChange();
      }
    }

    function toggleMode() {
      vm.variableMode = !vm.variableMode;

      if (angular.isDefined(vm.resetValueOnToggle) && vm.resetValueOnToggle) {
        vm.draft = {
          value: undefined,
          variable: undefined
        };
        commit();
      } else {
        if (!vm.variableMode || vm.variableMode && vm.draft.variable) {
          commit();
        }
      }
    }

    function createNewVariableHandler(variable) {
      var deferred = $q.defer();
      vm.updateModelFromDraft(vm.draft, vm.variableMode);
      vm.onNew({
        name: variable.displayName,
        variableType: vm.variableType,
        createdCallback: function createdCallback(createdVariable) {
          createdVariable.displayName = createdVariable.variableName = VariablesService.withVariableSyntax(createdVariable.key);
          vm.variables.push(createdVariable);

          _.assignIn(vm.model, {
            value: null,
            variable: VariablesService.getKey(createdVariable)
          });

          vm.onChange();
          deferred.resolve(createdVariable.displayName);
        }
      });
      return deferred.promise;
    }

    function createNewVariableInTextAreaHandler(variable) {
      var deferred = $q.defer();

      if (!vm.model) {
        vm.model = "";
        vm.updateDraftFromModel(vm.model);
      }

      vm.updateModelFromDraft(vm.draft, vm.variableMode);
      vm.onNewVariable({
        key: variable.displayName,
        variableType: vm.variableType,
        createdCallback: function createdCallback(createdVariable) {
          createdVariable.displayName = createdVariable.variableName = VariablesService.withVariableSyntax(createdVariable.key);
          vm.variables.push(createdVariable);
          deferred.resolve(createdVariable.displayName);
        }
      });
      return deferred.promise;
    }

    function variableSelectedHandler() {
      commit();
    }

    function variableTextAreaSelectedHandler(newVal) {
      vm.model = newVal.value;
      vm.draft = newVal;
    }

    function variableDeselectedHandler() {
      commit();
    }

    function onChangeInternal() {
      commit();
    }

    function onValueChange(value) {
      vm.draft.value = value;
      commit();
    }

    function variableAutocompleteHandler(metadata, options) {
      var deferred = $q.defer();

      var candidates = _.filter(vm.variables, function (variable) {
        return vm.variableType === variable.type && variable.displayName.includes(options.term);
      });

      deferred.resolve(candidates);
      return deferred.promise;
    }

    function variableTextInputAutocompleteHandler(metadata, options) {
      var deferred = $q.defer();

      var candidates = _.filter(vm.variables, function (variable) {
        return variable.displayName.includes(options.term);
      });

      deferred.resolve(candidates);
      return deferred.promise;
    }

    function calculateMode() {
      if (vm.enforceMode) {
        vm.showToggle = false;
        vm.variableMode = vm.enforceMode === 'variable';
      } else {
        vm.showToggle = true;
        vm.variableMode = vm.draft && !!vm.draft.variable;
      }
    }
  }

  return function () {
    return directive;
  };
}

/***/ }),

/***/ 1331:
/***/ (function(module, exports) {

angular.module('xlrelease').directive('shortenContent', [function () {
  return {
    restrict: 'A',
    link: function link(scope, element) {
      var watch = function watch() {
        var cancel = scope.$watch(function () {
          return element.prop('scrollHeight');
        }, function () {
          var isCanceled = false;

          if (element.height() + 1 < element.prop('scrollHeight')) {
            isCanceled = true;
            cancel();
          }

          var words = element.text().split(' ').filter(function (word) {
            return word !== '';
          });

          while (element.height() + 1 < element.prop('scrollHeight')) {
            words.pop();
            element.text(words.join(' ') + '...');
          }

          if (isCanceled) {
            watch();
          }
        });
      };

      watch();
    }
  };
}]);

/***/ }),

/***/ 1332:
/***/ (function(module, exports) {

angular.module('xlrelease').directive('handleFirstTab', function () {
  return function (scope, element, attrs) {
    element.bind("keydown keypress", function (event) {
      if (attrs.handleFirstTab === "true" && event.which === 9) {
        document.body.classList.add('user-is-tabbing');
        element.unbind("keydown keypress");
      }
    });
  };
});

/***/ }),

/***/ 1333:
/***/ (function(module, exports) {

angular.module('xlrelease').directive('nonNegative', function () {
  return {
    require: '?ngModel',
    link: function link(scope, el, attrs) {
      el.on('keydown', function (event) {
        var keys = ['ArrowUp', 'ArrowDown', 'ArrowRight', 'ArrowLeft', 'Backspace', 'Delete', 'Tab', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0'];

        if (!keys.includes(event.key)) {
          event.preventDefault();
        }
      });
      var min = angular.isDefined(attrs.min) ? attrs.min : 0;
      el.on('input', function (event) {
        if (event.target.value && event.target.value < min) {
          event.target.value = min;
        }
      });
    }
  };
});

/***/ }),

/***/ 1334:
/***/ (function(module, exports) {

angular.module('xlrelease').directive('docIcon', ['Doc', function (Doc) {
  return {
    template: '<a title="Open documentation page related to this page in a new browser tab" class="xl-icon qmark-icon doc-icon" ng-href="{{ docURL }}" target="_blank" rel="noopener"></a>',
    restrict: 'A',
    scope: {
      section: '@docIcon'
    },
    link: function link(scope) {
      scope.docURL = Doc.getURL() + scope.section;
    }
  };
}]);
angular.module('xlrelease').directive('docLink', ['Doc', function (Doc) {
  return {
    template: '<a class="doc-link" ng-href="{{ docURL }}" target="_blank" ng-transclude rel="noopener"></a>',
    restrict: 'A',
    transclude: true,
    scope: {
      section: '@docLink'
    },
    link: function link(scope) {
      scope.docURL = Doc.getURL() + scope.section;
    }
  };
}]);

/***/ }),

/***/ 1335:
/***/ (function(module, exports) {

angular.module('xlrelease').factory('Doc', [function () {
  return {
    getURL: _.constant('https://docs.xebialabs.com/xl-release/help/'),
    getMarkdownSyntaxURL: function getMarkdownSyntaxURL() {
      return this.getURL() + 'markdownsyntax.html';
    }
  };
}]);

/***/ }),

/***/ 1336:
/***/ (function(module, exports) {

angular.module('xlrelease').directive('delayedLine', [function () {
  return {
    templateUrl: 'partials/flags/delayed-line-directive.html',
    restrict: 'A',
    transclude: true,
    scope: {
      task: '='
    }
  };
}]);

/***/ }),

/***/ 1337:
/***/ (function(module, exports) {

angular.module('xlrelease').directive('flagLine', ['FlagService', function (FlagService) {
  return {
    templateUrl: 'partials/flags/flag-line-directive.html',
    restrict: 'A',
    scope: {
      item: '='
    },
    transclude: true,
    link: function link(scope) {
      scope.isItemFlagged = FlagService.isItemFlagged;
      scope.isFlaggedAttentionNeeded = FlagService.isFlaggedAttentionNeeded;
      scope.isFlaggedAtRisk = FlagService.isFlaggedAtRisk;
    }
  };
}]);

/***/ }),

/***/ 1338:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').factory('FlagService', [function () {
  var NOT_FLAGGED_STATUS = 'OK';
  var ATTENTION_NEEDED_STATUS = 'ATTENTION_NEEDED';
  var AT_RISK_STATUS = 'AT_RISK';

  function isItemFlagged(item) {
    return item && item.flag && item.flag.status !== NOT_FLAGGED_STATUS;
  }

  function isFlaggedAttentionNeeded(item) {
    return isItemFlagged(item) && item.flag.status === ATTENTION_NEEDED_STATUS;
  }

  function isFlaggedAtRisk(item) {
    return isItemFlagged(item) && item.flag.status === AT_RISK_STATUS;
  }

  function isReleaseFlagged(release) {
    return release && release.releaseFlag && release.releaseFlag.status !== NOT_FLAGGED_STATUS;
  }

  return {
    NOT_FLAGGED_STATUS: NOT_FLAGGED_STATUS,
    isReleaseOrSubtaskFlagged: isItemFlagged,
    isReleaseFlagged: isReleaseFlagged,
    isTaskFlagged: isItemFlagged,
    isItemFlagged: isItemFlagged,
    isFlaggedAttentionNeeded: isFlaggedAttentionNeeded,
    isFlaggedAtRisk: isFlaggedAtRisk
  };
}]);

/***/ }),

/***/ 1339:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').controller('FiltersController', ['$scope', '$location', 'Filters', 'Events', 'FiltersQueryParams', function ($scope, $location, Filters, Events, FiltersQueryParams) {
  // Watch is necessary for toggling filters since they are accessed using scope.filters
  $scope.$watch('filters', function (newFilters, oldFilters) {
    var filtersChanged = !angular.equals(oldFilters, newFilters);
    var titleFilterChanged = newFilters.filter !== oldFilters.filter;

    if (filtersChanged && !titleFilterChanged) {
      // title filter is handled by a separate delayed watch
      setTimeFilters();
      FiltersQueryParams.update($scope.filters);
    }
  }, true); // Reload list of releases once user has changed filter value

  $scope.delayedWatch(500, 'filters.filter', function () {
    FiltersQueryParams.update($scope.filters);
  });

  function setTimeFilters() {
    if ($scope.filters.timeFrame) {
      // ALL_TIME could still be used from previous URLs : ensuring it gets converted to RANGE.
      var usingRange = $scope.filters.timeFrame === 'ALL_TIME' || $scope.filters.timeFrame === 'RANGE';

      if (usingRange) {
        $scope.filters.timeFrame = 'RANGE';
      } else {
        $scope.filters.from = undefined;
        $scope.filters.to = undefined;
      }
    }
  } // date pickers need a delay to close correctly before reloading page


  $scope.delayedWatch(100, 'filters.from', function (from) {
    $location.search('from', Filters.dateForFilter(from));
  });
  $scope.delayedWatch(100, 'filters.to', function (to) {
    $location.search('to', Filters.dateForFilter(to));
  });
}]);

/***/ }),

/***/ 1351:
/***/ (function(module, exports) {

angular.module('xlrelease').config(['$httpProvider', 'Events', function ($httpProvider, Events) {
  var UNAUTHORIZED = 401;
  var PAYMENT_REQUIRED = 402;
  var FORBIDDEN = 403;
  var VERSION_CHANGED = 410;
  var SERVER_DOWN_CODE = -1;
  var DELAY_BEFORE_AJAX_SPINNER = 1000;
  var ajaxSpinnerTimers = [];
  $httpProvider.interceptors.push(['$rootScope', '$q', '$location', '$window', 'Alerts', 'VersionEnforcer', 'WindowLocation', function ($rootScope, $q, $location, $window, Alerts, VersionEnforcer, WindowLocation) {
    return {
      request: function request(_request) {
        ajaxSpinnerTimers.push(setTimeout(function () {
          angular.element('#loading').show();
        }, DELAY_BEFORE_AJAX_SPINNER));
        VersionEnforcer.addPrefix(_request); //to avoid popup from browser when returning 'WWW-Authenticate: Basic'. See Http401AuthenticationEntryPoint

        _request.headers['X-HTTP-Auth-Override'] = 'true';
        return _request;
      },
      response: function response(_response) {
        hideSpinner();
        return _response;
      },
      responseError: function responseError(response) {
        hideSpinner();
        var status = response.status;

        if (status === PAYMENT_REQUIRED) {
          WindowLocation.changeLocation('./productregistration');
          return $q.reject(response);
        }

        if (status === UNAUTHORIZED && !response.config.dontRedirectWhenUnauthorized) {
          $rootScope.$emit(Events.permission.unauthorized);
          return $q.reject(response);
        }

        if (status === FORBIDDEN && !response.config.dontRedirectWhenForbidden) {
          var contentType = response.headers('Content-Type'); // If content-type is HTML, response.data is html, so no readable message.

          var errorMessage = contentType && contentType.match(/^text\/plain/) ? response.data : '';
          $rootScope.$emit(Events.permission.forbidden, errorMessage);
          return $q.reject(response);
        }

        if (status === VERSION_CHANGED) {
          $rootScope.xlreleaseVersionChanged = true;
          $rootScope.versionChangedMessage = response.data;
        }

        if (status === SERVER_DOWN_CODE) {
          Alerts.serverDownError();
          return $q.reject(response);
        }

        if (!response.config.hideAlert && status !== response.config.hideAlertOnCode && (!response.config.hideAlertOnCodes || !response.config.hideAlertOnCodes.includes(status))) {
          Alerts.error(response);
        }

        return $q.reject(response);
      }
    };
  }]);

  function hideSpinner() {
    clearTimeout(ajaxSpinnerTimers.pop());

    if (ajaxSpinnerTimers.length === 0) {
      angular.element('#loading').hide();
    }
  }
}]);
angular.module('xlrelease').factory('WindowLocation', ['$window', function ($window) {
  return {
    changeLocation: function changeLocation(url) {
      $window.location.href = url;
    }
  };
}]);

/***/ }),

/***/ 1352:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').controller('defaultRouteController', ['Authenticator', '$state', function (Authenticator, $state) {
  $state.go(Authenticator.isAuthenticated() ? 'releaseOverview' : 'login');
}]);

/***/ }),

/***/ 1353:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


(function () {
  var injectParams = ['$location', 'UiExtensionsService', 'Page'];

  var MainMenuExtensionController = function MainMenuExtensionController($location, UiExtensionsService, Page) {
    var vm = this;
    UiExtensionsService.findMenuItemForPath($location.path()).then(function (menuExtension) {
      vm.menuExtension = menuExtension;

      if (!vm.menuExtension) {
        $location.path('/default');
        return;
      }

      Page.addToTitle(vm.menuExtension.label);
    });
  };

  MainMenuExtensionController.$inject = injectParams;
  angular.module('xlrelease').controller('mainMenuExtensionController', MainMenuExtensionController);
})();

/***/ }),

/***/ 1360:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').controller('LoginController', ['$scope', 'Authenticator', 'AuthenticationRegistry', 'configuration', 'Page', function ($scope, Authenticator, AuthenticationRegistry, configuration, Page) {
  var CLIENT_SESSION_REMEMBER_ENABLED = 'client.session.remember.enabled';
  $scope.clientSessionRememberEnabled = configuration[CLIENT_SESSION_REMEMBER_ENABLED];
  $scope.loginInfo = {
    login: "",
    password: "",
    failed: false,
    errorMessage: ""
  };
  $scope.providers = AuthenticationRegistry.getFormProviders();
  $scope.loginMessage = Page.theme.loginMessage;

  $scope.login = function () {
    Authenticator.login($scope.loginInfo.login, $scope.loginInfo.password, $scope.loginInfo.rememberMe).then(function success() {
      $scope.loginInfo.failed = false;
      $scope.loginInfo.errorMessage = "";
    }, function error(response) {
      $scope.loginInfo.failed = true;
      $scope.loginInfo.failedStatus = response.status;
      $scope.loginInfo.password = "";
      $scope.loginInfo.errorMessage = response.status === 401 && response.data.message && response.data.message.includes("Maximum sessions") ? response.data.message : "The username and/or password you have entered is incorrect.";
    });
  };
}]);

/***/ }),

/***/ 1361:
/***/ (function(module, exports, __webpack_require__) {

"use strict";
 // Hook for acceptance tests: disable collapsing globally

angular.module('xlrelease').value('Collapse', {
  enabled: true
});
angular.module('xlrelease').factory('ReleaseEditorCollapse', ['Collapse', 'ClientSettings', 'ReleasesService', 'PhasesService', 'TasksService', function (Collapse, ClientSettings, ReleasesService, PhasesService, TasksService) {
  function isCollapsed(item, collapsedByDefault) {
    if (!Collapse.enabled) return false;
    var savedState = ClientSettings.getReleaseEditorCollapseState(item.id);

    if (TasksService.isValidCollapsedState(savedState)) {
      return savedState;
    } else {
      return collapsedByDefault;
    }
  }

  function toggleClientSettingsState(state) {
    if (!_.isBoolean(state)) {
      return false;
    }

    return !state;
  }

  return {
    isPreConditionCollapsed: function isPreConditionCollapsed(task) {
      if (!Collapse.enabled) {
        return false;
      }

      if (!_.isBoolean(ClientSettings.getPreConditionCollapseState(task.id))) {
        return _.isEmpty(task.precondition);
      }

      return ClientSettings.getPreConditionCollapseState(task.id);
    },
    togglePreConditionState: function togglePreConditionState(task) {
      ClientSettings.setPreConditionCollapseState(task.id, toggleClientSettingsState(ClientSettings.getPreConditionCollapseState(task.id)));
    },
    isFailureHandlerCollapsed: function isFailureHandlerCollapsed(task) {
      if (!Collapse.enabled) {
        return false;
      }

      if (!_.isBoolean(ClientSettings.getFailureHandlerCollapseState(task.id))) {
        return _.isEmpty(task.failureHandler);
      }

      return ClientSettings.getFailureHandlerCollapseState(task.id);
    },
    toggleFailureHandlerState: function toggleFailureHandlerState(task) {
      ClientSettings.setFailureHandlerCollapseState(task.id, toggleClientSettingsState(ClientSettings.getFailureHandlerCollapseState(task.id)));
    },
    areFacetsCollapsed: function areFacetsCollapsed(task) {
      if (!Collapse.enabled) {
        return false;
      }

      var state = ClientSettings.getFacetsCollapseState(task.id);
      return _.isBoolean(state) ? state : true;
    },
    toggleFacetsState: function toggleFacetsState(task) {
      ClientSettings.setFacetsCollapseState(task.id, toggleClientSettingsState(ClientSettings.getFacetsCollapseState(task.id)));
    },
    isCommentsCollapsed: function isCommentsCollapsed(task) {
      if (!_.isBoolean(ClientSettings.getCommentsState(task.id))) {
        return task.numberOfComments === 0;
      }

      return ClientSettings.getCommentsState(task.id);
    },
    toggleCommentsState: function toggleCommentsState(task) {
      ClientSettings.setCommentsState(task.id, toggleClientSettingsState(ClientSettings.getCommentsState(task.id)));
    },
    isAttachmentsCollapsed: function isAttachmentsCollapsed(task) {
      if (!_.isBoolean(ClientSettings.getAttachmentsState(task.id))) {
        return _.isEmpty(task.attachments);
      }

      return ClientSettings.getAttachmentsState(task.id);
    },
    toggleAttachmentsState: function toggleAttachmentsState(task) {
      ClientSettings.setAttachmentsState(task.id, toggleClientSettingsState(ClientSettings.getAttachmentsState(task.id)));
    },
    isTaskGroupCollapsed: function isTaskGroupCollapsed(group) {
      if (group.wasJustAdded || TasksService.isTaskGroupInProgress(group) && !group.wasToggledSincePageLoad) {
        return false;
      }

      return isCollapsed(group, true);
    },
    toggleTaskGroupCollapseState: function toggleTaskGroupCollapseState(group) {
      ClientSettings.setReleaseEditorCollapseState(group.id, !this.isTaskGroupCollapsed(group));
      group.wasToggledSincePageLoad = true;
      delete group.wasJustAdded;
    },
    transferTaskGroupCollapseState: function transferTaskGroupCollapseState(targetGroupId, fromGroupId) {
      ClientSettings.setReleaseEditorCollapseState(targetGroupId, this.isTaskGroupCollapsed({
        id: fromGroupId
      }));
    },
    isPlannedPhaseCollapsed: function isPlannedPhaseCollapsed(phase) {
      return isCollapsed(phase, false);
    },
    togglePlannedPhaseCollapseState: function togglePlannedPhaseCollapseState(phase) {
      ClientSettings.setReleaseEditorCollapseState(phase.id, !this.isPlannedPhaseCollapsed(phase));
    },
    areDonePhasesCollapsed: function areDonePhasesCollapsed(release) {
      if (!release) return false;

      if (ReleasesService.isReleaseCompleted(release)) {
        return false;
      }

      return ReleasesService.countPhasesDone(release) > 0 && isCollapsed(release, true);
    },
    toggleDonePhasesCollapseState: function toggleDonePhasesCollapseState(release) {
      ClientSettings.setReleaseEditorCollapseState(release.id, !this.areDonePhasesCollapsed(release));
    },
    collapseFilter: function collapseFilter(release) {
      var self = this;
      return function (phase) {
        return !(self.areDonePhasesCollapsed(release) && PhasesService.isPhaseReadOnly(phase));
      };
    }
  };
}]);

/***/ }),

/***/ 1362:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').controller('releaseEditorController', ['$scope', '$location', '$stateParams', 'Backend', 'Ids', 'TaskPolling', 'TasksService', 'PhaseColors', 'ReleasesService', 'Modal', 'FlagService', 'Authenticator', 'Events', 'PhasesService', 'TaskDetailsUpdates', 'PhaseDetailsUpdates', 'DateService', 'Page', 'ReleaseEditorCollapse', 'DragAndDrop', 'ValueStreamMapping', 'ConfigurationItemService', 'ReleaseEditorTaskFilterService', 'TaskDefinitionsService', 'ViewStorage', 'release', 'CalendarService', 'UsersService', function ($scope, $location, $stateParams, Backend, Ids, TaskPolling, TasksService, PhaseColors, ReleasesService, Modal, FlagService, Authenticator, Events, PhasesService, TaskDetailsUpdates, PhaseDetailsUpdates, DateService, Page, ReleaseEditorCollapse, DragAndDrop, ValueStreamMapping, ConfigurationItemService, ReleaseEditorTaskFilterService, TaskDefinitionsService, ViewStorage, release, CalendarService, UsersService) {
  $scope.init = {
    hasScrolledToCurrentTask: false
  };
  $scope.collapsedPhases = {};

  function emitRefreshEvent() {
    $scope.$emit(Events.permission.refresh);
  }

  function setupScope(release) {
    $scope.release = release;
    Page.setReleaseOpened($scope.release);
    $scope.allTasks = ReleasesService.getAllTasks($scope.release);
    $scope.hasAutomatedTaskInProgress = _.some($scope.allTasks, function (task) {
      return TasksService.isTaskInProgress(task) && TasksService.isAutomated(task);
    });

    if (release.phases) {
      release.phases.forEach(function (p) {
        if (PhasesService.isPhasePlanned(p)) {
          $scope.collapsedPhases[p.id] = ReleaseEditorCollapse.isPlannedPhaseCollapsed(p);
        }
      });
    }

    startPolling();
    return release;
  }

  $scope.loadRelease = function () {
    emitRefreshEvent();
    return Backend.get("releases/".concat($stateParams.releaseId)).then(function (resp) {
      return setupScope(resp.data);
    });
  };

  function init() {
    emitRefreshEvent();
    setupScope(release);
    CalendarService.withinBlackout().then(function (response) {
      $scope.withinBlackout = response.data;
    });
    UsersService.getAllUsersAsObject().then(function (users) {
      $scope.users = users;
    });
    TaskDefinitionsService.getTaskDefinitions().then(function (resp) {
      var definitions = resp.data;
      $scope.taskDefinitions = definitions;
      $scope.groupedTaskDefinitions = definitions ? TaskDefinitionsService.groupTaskDefinitions(definitions).groups : undefined;
    });
    expandIfTaskDetailsModalRequestedForCollapsedPhaseOrTask(release);
    ViewStorage.setView($stateParams.releaseId, $location.path());
  }

  init();

  $scope.loadReleaseAfterTaskUpdate = function () {
    if (TaskDetailsUpdates.planningDataChanged) {
      $scope.loadRelease();
      TaskDetailsUpdates.reset();
    }
  };

  $scope.loadReleaseAfterPhaseUpdate = function () {
    if (PhaseDetailsUpdates.planningDataChanged) {
      $scope.loadRelease();
      PhaseDetailsUpdates.reset();
    }
  };

  function startPolling() {
    TaskPolling.startTaskPolling($scope.allTasks, $scope).then($scope.loadRelease);
    Modal.withScope($scope).onNextOpen(stopPolling).onNextClose(startPolling);
  }

  function stopPolling() {
    $scope.$broadcast(Events.polling.stop);
  }

  function expandIfTaskDetailsModalRequestedForCollapsedPhaseOrTask(release) {
    var requestedPhaseTaskId = $location.search().openTaskDetailsModal;
    var requestedPhaseId = $location.search().scrollToPhase;

    if (requestedPhaseTaskId || requestedPhaseId) {
      var phase = requestedPhaseTaskId ? release.phases.find(function (currentPhase) {
        return Ids.phaseIdFrom(currentPhase.id) === Ids.phaseIdFrom(requestedPhaseTaskId);
      }) : release.phases.find(function (currentPhase) {
        return Ids.phaseIdFrom(currentPhase.id) === Ids.phaseIdFrom(requestedPhaseId);
      });

      if (phase) {
        // expand phases
        if (PhasesService.isPhaseReadOnly(phase) && ReleaseEditorCollapse.areDonePhasesCollapsed(release)) {
          ReleaseEditorCollapse.toggleDonePhasesCollapseState(release);
        } else if (!PhasesService.isPhaseReadOnly(phase) && $scope.collapsedPhases[phase.id]) {
          $scope.collapsedPhases[phase.id] = !$scope.collapsedPhases[phase.id];
          ReleaseEditorCollapse.togglePlannedPhaseCollapseState(phase);
        } // expand parallel and sequential groups


        if (requestedPhaseTaskId) {
          expandParallelAndSequentialGroups(requestedPhaseTaskId, phase.tasks);
        }
      }
    }
  }

  function expandParallelAndSequentialGroups(requestedPhaseTaskId, taskList) {
    var requestedTaskId = Ids.taskIdFrom(requestedPhaseTaskId);
    var taskDepth = requestedTaskId.split('-').length;
    var taskIdList = [];

    if (taskDepth > 1) {
      for (var i = 0; i < taskDepth; i++) {
        taskIdList.unshift(requestedTaskId);
        requestedTaskId = requestedTaskId.substring(0, requestedTaskId.lastIndexOf('-'));
      }
    }

    taskIdList.forEach(function (taskId) {
      var group = taskList.find(function (currentTask) {
        return Ids.taskIdFrom(currentTask.id) === taskId;
      });

      if (ReleaseEditorCollapse.isTaskGroupCollapsed(group)) {
        ReleaseEditorCollapse.toggleTaskGroupCollapseState(group);
      }

      taskList = group.tasks || [];
    });
  }

  $scope.isPhaseInProgress = PhasesService.isPhaseInProgress;
  $scope.isPhaseReadOnly = PhasesService.isPhaseReadOnly;
  $scope.isPhasePlanned = PhasesService.isPhasePlanned;
  $scope.updatePhase = PhasesService.updatePhase;

  $scope.updatePhaseColor = function (phase, color) {
    phase.color = color;
    PhasesService.updatePhase(phase);
  };

  $scope.isRequestedOrPhaseInProgress = function (phase) {
    var requestedTaskId = $location.search().openTaskDetailsModal;
    var requestedPhaseId = $location.search().scrollToPhase;

    if (requestedTaskId) {
      return Ids.phaseIdFrom(phase.id) === Ids.phaseIdFrom(requestedTaskId);
    } else if (requestedPhaseId) {
      return Ids.phaseIdFrom(phase.id) === Ids.phaseIdFrom(requestedPhaseId);
    } else {
      return PhasesService.isPhaseInProgress(phase);
    }
  };

  $scope.startRelease = function (release) {
    ReleasesService.startRelease(release).then($scope.loadRelease);
  };

  $scope.abortRelease = function (release, abortComment) {
    ReleasesService.abortRelease(release, abortComment).then($scope.loadRelease);
  };

  $scope.showNavigator = false;

  $scope.movePhase = function (fromIndex, toIndex) {
    var moveInfo = {
      originIndex: fromIndex,
      targetIndex: toIndex
    };

    if ($scope.areDonePhasesCollapsed($scope.release)) {
      var offset = $scope.release.phases.length - $scope.displayedIds.length;
      moveInfo.originIndex += offset;
      moveInfo.targetIndex += offset;
    }

    Backend.post("releases/".concat($scope.release.id, "/phases/move"), moveInfo).then(function () {
      var phase = $scope.release.phases.splice(moveInfo.originIndex, 1)[0];
      $scope.release.phases.splice(moveInfo.targetIndex, 0, phase);
    });
  };

  function taskHasBeenMoved(moveInfo) {
    return moveInfo.originContainerId !== moveInfo.targetContainerId || moveInfo.originIndex !== moveInfo.targetIndex;
  }

  $scope.isActiveTask = TasksService.isActive;

  $scope.moveTask = function (taskId, fromTaskOrPhase, fromIndex, toTaskOrPhase, toIndex) {
    var moveInfo = {
      originContainerId: fromTaskOrPhase.id,
      originIndex: fromIndex,
      targetContainerId: toTaskOrPhase.id,
      targetIndex: toIndex
    };

    if (!taskHasBeenMoved(moveInfo)) {
      return;
    }

    DragAndDrop.enabled = false;
    Backend.post("releases/".concat($scope.release.id, "/tasks/move"), moveInfo).then(function (resp) {
      var movedTask = resp.data;

      if (TasksService.isTaskGroup(movedTask) && taskId !== movedTask.id) {
        ReleaseEditorCollapse.transferTaskGroupCollapseState(movedTask.id, taskId);
      }

      $scope.loadRelease();
      DragAndDrop.enabled = true;
    }, function (error) {
      $scope.loadRelease();
      DragAndDrop.enabled = true;
    });
  };

  $scope.addPhase = function () {
    Backend.post("releases/".concat($scope.release.id, "/phases/add")).then(function (resp) {
      $scope.release.phases.push(resp.data);
    });
  };

  $scope.deletePhase = function (phaseToDelete) {
    Backend.del("phases/".concat(phaseToDelete.id)).then(function () {
      var deleted = $scope.release.phases.find(function (p) {
        return p.id === phaseToDelete.id;
      });
      $scope.release.phases = $scope.release.phases.filter(function (p) {
        return p.id !== phaseToDelete.id;
      });
      var progress = $scope.release.extensions.progress;

      if (progress) {
        var tasksCount = deleted.tasks.length;
        $scope.release.extensions.progress = {
          totalTasks: progress.totalTasks - tasksCount,
          totalRemainingTasks: progress.totalRemainingTasks - tasksCount
        };
      }
    });
  };

  $scope.duplicatePhase = function (phase) {
    Backend.put("releases/".concat($scope.release.id, "/phases/duplicate/").concat(phase.id)).then(function (resp) {
      var duplicatedPhase = resp.data;
      $scope.release.phases.forEach(function (aPhase, index) {
        if (aPhase.id === phase.id) {
          $scope.release.phases.splice(index + 1, 0, duplicatedPhase);
        }
      });
      var progress = $scope.release.extensions.progress;

      if (progress) {
        var tasksCount = duplicatedPhase.tasks.length;
        $scope.release.extensions.progress = {
          totalTasks: progress.totalTasks + tasksCount,
          totalRemainingTasks: progress.totalRemainingTasks + tasksCount
        };
      }
    });
  };

  $scope.addTask = function (container, taskForm) {
    return TasksService.addTask(container, taskForm).then($scope.loadRelease);
  };

  $scope.deleteTask = function (container, taskToDelete) {
    TasksService.deleteTask(container, taskToDelete).then($scope.loadRelease);
  };

  $scope.changeType = function (container, taskToConvert, convertToType) {
    TasksService.changeTaskType(container, taskToConvert, convertToType);
  };

  $scope.duplicateTask = function (release, container, task) {
    TasksService.duplicateTask(release, task, container).then($scope.loadRelease);
  };

  $scope.completeTask = function (task, commentText) {
    TasksService.completeTask(task.id, commentText).then($scope.loadRelease);
  };

  $scope.skipTask = function (task, commentText) {
    TasksService.skipTask(task.id, commentText).then($scope.loadRelease);
  };

  $scope.failTask = function (task, commentText) {
    TasksService.failTask(task.id, commentText).then($scope.loadRelease);
  };

  $scope.abortTask = function (task, commentText) {
    TasksService.abortTask(task.id, commentText).then($scope.loadRelease);
  };

  $scope.retryTask = function (task, commentText) {
    TasksService.retryTask(task.id, commentText).then($scope.loadRelease);
  };

  $scope.cancelTask = function (task, commentText) {
    TasksService.cancelTask(task.id, commentText).then($scope.loadRelease);
  };

  $scope.startNow = function (task, commentText) {
    TasksService.startNow(task.id, commentText).then($scope.loadRelease);
  };

  $scope.startTaskWithInput = function (task, variables) {
    TasksService.startTaskWithInput(task.id, variables).then($scope.loadRelease);
  };

  $scope.updateReleaseVariable = function (variable) {
    TasksService.updateReleaseVariable(variable).then(function (resp) {
      var updatedVariable = resp.data;

      var taskVariable = _.find($scope.task.variables, {
        id: updatedVariable.id
      });

      if (taskVariable) {
        _.assignIn(taskVariable, updatedVariable);
      }
    });
  };

  $scope.reopenTask = function (task, commentText) {
    TasksService.reopenTask(task.id, commentText).then($scope.loadRelease);
  };

  $scope.canRestartPhases = function (release) {
    return release && release.status !== 'TEMPLATE' && Authenticator.hasPermission('release#edit', release) && (ReleasesService.isReleaseInProgress(release) || ReleasesService.isReleaseFailed(release) || ReleasesService.isReleaseFailing(release)) && !$scope.hasAutomatedTaskInProgress;
  };

  $scope.canResume = function (release) {
    return release && release.status !== 'TEMPLATE' && Authenticator.hasPermission('release#edit', release) && ReleasesService.isReleasePaused(release);
  };

  $scope.resumeRelease = function (release) {
    Backend.post("releases/".concat(release.id, "/resume")).then($scope.loadRelease);
  };

  $scope.filters = ReleaseEditorTaskFilterService.getFilters($stateParams.releaseId);
  $scope.setFilters = ReleaseEditorTaskFilterService.setFilters;
  $scope.taskFilter = ReleaseEditorTaskFilterService.getTaskFilter;
  $scope.isReleaseCompleted = ReleasesService.isReleaseCompleted;
  $scope.isReleasePlanned = ReleasesService.isReleasePlanned;
  $scope.countPhasesDone = ReleasesService.countPhasesDone;
  $scope.hasAttachments = ReleasesService.hasAttachments;
  $scope.downloadExcel = ReleasesService.downloadExcel;
  $scope.exportZip = ReleasesService.exportZip;
  $scope.exportDsl = ReleasesService.exportDsl;
  $scope.isPhaseReadOnly = PhasesService.isPhaseReadOnly;
  $scope.getLeafTasks = PhasesService.getLeafTasks;
  $scope.isCritical = ValueStreamMapping.isCritical;
  $scope.getWarningThreshold = ValueStreamMapping.getWarningThreshold;
  $scope.getErrorThreshold = ValueStreamMapping.getErrorThreshold;
  $scope.isTaskPlanned = TasksService.isTaskPlanned;
  $scope.isTaskPending = TasksService.isTaskPending;
  $scope.isTaskInProgress = TasksService.isTaskInProgress;
  $scope.isTaskQueued = TasksService.isTaskQueued;
  $scope.isTaskPreconditionInProgress = TasksService.isTaskPreconditionInProgress;
  $scope.isTaskFacetInProgress = TasksService.isTaskFacetInProgress;
  $scope.isTaskOrPreconditionInProgress = TasksService.isTaskOrPreconditionInProgress;
  $scope.isTaskReadOnly = TasksService.isTaskReadOnly;
  $scope.isTaskSkipped = TasksService.isTaskSkipped;
  $scope.isTaskFailed = TasksService.isTaskFailed;
  $scope.isTaskFailing = TasksService.isTaskFailing;
  $scope.isUserInputTask = TasksService.isUserInputTask;
  $scope.isGateTask = TasksService.isGateTask;
  $scope.isTaskFlagged = FlagService.isTaskFlagged;
  $scope.isManualTask = TasksService.isManualTask;
  $scope.isNotificationTask = TasksService.isNotificationTask;
  $scope.isTaskGroup = TasksService.isTaskGroup;
  $scope.isParallelGroup = TasksService.isParallelGroup;
  $scope.isSequentialGroup = TasksService.isSequentialGroup;
  $scope.isTaskCompleted = TasksService.isTaskCompleted;
  $scope.isTaskCompletedInAdvance = TasksService.isTaskCompletedInAdvance;
  $scope.isTaskSkippedInAdvance = TasksService.isTaskSkippedInAdvance;
  $scope.isTaskDoneInAdvance = TasksService.isTaskDoneInAdvance;
  $scope.isTaskDraggable = TasksService.isTaskDraggable;
  $scope.isTaskGroupDroppable = TasksService.isTaskGroupDroppable;
  $scope.isAutomated = TasksService.isAutomated;
  $scope.isTaskDelayedDuringBlackout = TasksService.isTaskDelayedDuringBlackout;
  $scope.getSubTasks = TasksService.getSubTasks;
  $scope.canAddTask = TasksService.canAddTask;
  $scope.getConfigurationUri = TasksService.getConfigurationUri;
  $scope.hasConfigurationUri = TasksService.hasConfigurationUri;
  $scope.isOverdue = DateService.isOverdue;
  $scope.isTaskWaitingForInput = TasksService.isTaskWaitingForInput;

  $scope.togglePlannedPhaseCollapseState = function (phase) {
    $scope.collapsedPhases[phase.id] = !$scope.collapsedPhases[phase.id];
    ReleaseEditorCollapse.togglePlannedPhaseCollapseState(phase);
  };

  $scope.areDonePhasesCollapsed = ReleaseEditorCollapse.areDonePhasesCollapsed;
  $scope.toggleDonePhasesCollapseState = ReleaseEditorCollapse.toggleDonePhasesCollapseState;
  $scope.collapseFilter = ReleaseEditorCollapse.collapseFilter;
  $scope.DragAndDrop = DragAndDrop;
  $scope.PhaseColors = PhaseColors;
  $scope.getCIDuration = ConfigurationItemService.getCIDuration;
  $scope.displayedIds = [];
  $scope.$watchCollection('release.phases | filter:collapseFilter(release)', function (phases) {
    $scope.displayedIds = _.map(phases, 'id');
  });
  $scope.isRemoveEnabled = TasksService.isRemoveEnabled;
  $scope.isDuplicateEnabled = TasksService.isDuplicateEnabled;
  $scope.isChangeTypeEnabled = TasksService.isChangeTypeEnabled;
  $scope.isOfType = TasksService.isOfType;

  $scope.getInternalId = function (releaseId) {
    return TasksService.toInternalId(releaseId);
  };

  $scope.preventBubblingEvent = function (e) {
    e.stopPropagation();
  };
}]); // Expose the container of a task, regardless if it's a phase or a group.

angular.module('xlrelease').controller('ContainerController', ['$scope', function ($scope) {
  $scope.$watch('release', function () {
    $scope.container = $scope.task || $scope.phase;
  });
}]);

/***/ }),

/***/ 1363:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').factory('ReleaseEditorTaskFilterService', ['ReleasesService', 'TasksService', 'ClientSettings', function (ReleasesService, TasksService, ClientSettings) {
  return {
    getFilters: function getFilters(releaseId) {
      var filters = ClientSettings.getReleaseEditorTaskFilters(releaseId);
      return filters || defaultFilters();
    },
    setFilters: function setFilters(releaseId, filters) {
      ClientSettings.setReleaseEditorTaskFilters(releaseId, filters);
    },
    getTaskFilter: function getTaskFilter(release, filters) {
      return function filterTask(task) {
        if (!ReleasesService.isReleaseCompleted(release)) {
          return true;
        }

        if (TasksService.isTaskGroup(task)) {
          var subTasks = _.flattenDeep(TasksService.getSubTasks(task));

          if (!_.isEmpty(subTasks)) {
            return _.some(subTasks, filterTask);
          }
        }

        if (filters.flagged && task.flagsCount > 0) {
          return true;
        }

        if (filters.failed && task.failuresCount > 0) {
          return true;
        }

        if (filters.delayed && task.delaysCount > 0) {
          return true;
        }

        if (filters.clean && task.flagsCount === 0 && task.failuresCount === 0 && task.delaysCount === 0) {
          return true;
        }

        return false;
      };
    }
  };

  function defaultFilters() {
    return {
      flagged: true,
      failed: true,
      delayed: true,
      clean: true
    };
  }
}]);

/***/ }),

/***/ 1364:
/***/ (function(module, exports) {

angular.module('xlrelease').value('DragAndDrop', {
  enabled: true
});
angular.module('xlrelease').directive('phaseSortable', function () {
  return {
    template: '<ul ui-sortable="phaseSortableConfig" ng-model="displayedIds" ng-transclude></ul>',
    replace: true,
    transclude: true,
    link: function link(scope) {
      scope.phaseSortableConfig = {
        "items": '.phase:not(.drag-disabled)',
        "handle": '.phase-sort-handle',
        "cursor": "move",
        "axis": "x",
        "tolerance": "pointer",
        "forcePlaceholderSize": true,
        "opacity": 0.7,
        "placeholder": 'phase-drop-placeholder',
        cancel: '.drag-disabled',
        start: function start(event, ui) {
          ui.item.fromIndex = scope.displayedIds.indexOf(ui.item.scope().phase.id);
        },
        update: function update(event, ui) {
          // after list updated
          scope.$evalAsync(function () {
            ui.item.toIndex = scope.displayedIds.indexOf(ui.item.scope().phase.id);
            scope.movePhase(ui.item.fromIndex, ui.item.toIndex);
          });
        }
      };
    }
  };
});
angular.module('xlrelease').directive('taskSortable', ['DragAndDrop', 'Ids', function (DragAndDrop, Ids) {
  function moveTask(event, ui, scope) {
    // after list updated
    scope.$evalAsync(function () {
      var fromTaskOrPhase = ui.item.fromTaskOrPhase;
      var fromIndex = ui.item.fromIndex;
      var toTaskOrPhase = angular.element(event.target).scope().container;

      var toIndex = _.findIndex(toTaskOrPhase.tasks, {
        id: ui.item.id
      });

      if (angular.isUndefined(ui.item.sortable.dropindex)) {
        // sometimes drop event triggers even though task was not droppable, bug in JQuery
        return;
      }

      var taskId = ui.item.id;
      scope.moveTask(taskId, fromTaskOrPhase, ui.item.sortable.index, toTaskOrPhase, ui.item.sortable.dropindex);
    });
  }

  function isMovedBetweenContainers(ui) {
    return ui.item.sortable.received;
  }

  return {
    template: '<ul ui-sortable="taskSortableConfig" ng-transclude></ul>',
    replace: true,
    transclude: true,
    link: function link(scope, element) {
      scope.$watch('DragAndDrop.enabled', function (isDragAndDropEnabled) {
        if (isDragAndDropEnabled) {
          element.sortable('enable');
        } else {
          element.sortable('disable');
        }
      });
      var cursorStyle = undefined;
      var body = angular.element('body');
      var moveCursorStyle = '<style>.cursor-pointer{ cursor: move !important; }</style>';
      var notAllowedCursorStyle = '<style>.cursor-pointer{ cursor: not-allowed !important; }</style>';
      scope.taskSortableConfig = {
        "items": '.item-sortable:not(.drag-disabled)',
        "cancel": ".item-sortable.drag-disabled,:input",
        "connectWith": '.phase .task-sortable:not(.drop-disabled)',
        "handle": '.task-sort-handle',
        "cursor": 'auto',
        "tolerance": 'intersect',
        "placeholder": 'task-drop-placeholder',
        "forcePlaceholderSize": true,
        "helper": 'clone',
        // 'clone' is required in Firefox see REL-2373 & REL-883
        "start": function start(event, ui) {
          ui.item.fromTaskOrPhase = angular.element(event.target).scope().container;
          ui.item.fromIndex = ui.item.index();
          ui.item.id = ui.item.scope().task.id;

          if (!!ui.item.sortable.model.locked) {
            var currentContainerId = Ids.getParentIdGeneral(ui.item.sortable.model.id, '-');
            angular.element('#release-content .phase .task-sortable').each(function () {
              if (angular.element(this).data('container-id') !== currentContainerId) {
                angular.element(this).addClass('disable-drop');
              }
            });
          }
        },
        "sort": function sort(event, ui) {
          // only for cursor style change
          if (ui.placeholder.css('display') === 'none') {
            if (angular.isUndefined(cursorStyle)) {
              cursorStyle = angular.element(notAllowedCursorStyle).appendTo(body);
            } else if (cursorStyle.html() !== notAllowedCursorStyle) {
              cursorStyle.html(notAllowedCursorStyle);
            }
          } else {
            if (angular.isUndefined(cursorStyle)) {
              cursorStyle = angular.element(moveCursorStyle).appendTo(body);
            } else if (cursorStyle.html() !== moveCursorStyle) {
              cursorStyle.html(moveCursorStyle);
            }
          }
        },
        "update": function update(event, ui) {
          if (!!ui.item.sortable.model.locked && ui.item.sortable.droptarget.data('container-id') !== ui.item.sortable.source.data('container-id')) {
            ui.item.sortable.cancel();
          }

          if (isMovedBetweenContainers(ui)) {
            moveTask(event, ui, scope);
          }
        },
        "stop": function stop(event, ui) {
          if (!isMovedBetweenContainers(ui)) {
            moveTask(event, ui, scope);
          }

          if (!!ui.item.sortable.model.locked) {
            angular.element('#release-content .phase .task-sortable').each(function () {
              angular.element(this).removeClass('disable-drop');
            });
          }

          if (angular.isDefined(cursorStyle)) {
            cursorStyle.remove();
            cursorStyle = undefined;
          }
        }
      };
    }
  };
}]);

/***/ }),

/***/ 1365:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').directive('worksheetScrolling', ['worksheetService', 'Scroll', 'Window', function (worksheetService, Scroll, Window) {
  var INCLUDE_MARGIN = true;
  var releaseHeaderHeight, navigatorTogglerWidth, wrapper, worksheetWidth, phaseMarginLeft, phaseMarginRight, phaseWidth, allPhasesWidth, scope;

  function updateOverflowFlag() {
    var contentWidth = wrapper.parents(".view").width();
    var wrapperWidth = wrapper.width();
    scope.hasOverflow = contentWidth < wrapperWidth;

    if (!scope.hasOverflow) {
      scope.showNavigator = false;
    }
  }

  function highlightCurrentPhasesLinks() {
    var phaseLinksConfig = worksheetService.computeWhichPhasesAreHighlighted({
      phaseWidth: phaseWidth,
      scrollLeft: wrapper.parents(".view").scrollLeft(),
      worksheetWidth: worksheetWidth,
      phaseMarginLeft: phaseMarginLeft,
      phaseMarginRight: phaseMarginRight
    });
    highlightPhasesLinks(phaseLinksConfig.firstPhaseVisibleIndex, phaseLinksConfig.numberOfDisplayedPhase);
  }

  function highlightPhasesLinks(firstPhaseVisibleIndex, numberOfDisplayedPhase) {
    var navigator = wrapper.siblings("#navigator");
    navigator.find(".phase-link-container").removeClass('highlight');

    for (var i = firstPhaseVisibleIndex; i < firstPhaseVisibleIndex + numberOfDisplayedPhase; i++) {
      navigator.find(".phase-link-container:nth-child(" + (i + 1) + ")").addClass("highlight");
    }
  }

  function computeDomElementsDimensions() {
    var phases = wrapper.find(".phase");
    phaseMarginLeft = _.parseInt(phases.css("margin-left"));
    phaseMarginRight = _.parseInt(phases.css("margin-right"));
    phaseWidth = phases.outerWidth(INCLUDE_MARGIN);
    allPhasesWidth = phases.length * phaseWidth;
    navigatorTogglerWidth = _.parseInt(wrapper.siblings("#navigator-toggler").width());
    releaseHeaderHeight = _.parseInt(wrapper.find("#release-header").outerHeight());
  }

  function computeWorksheetWidth() {
    worksheetWidth = wrapper.parents(".view").width() - navigatorTogglerWidth;
    if (scope.showNavigator) worksheetWidth -= wrapper.siblings("#navigator").width();
    var viewWithOnePhaseWidth = wrapper.parents(".view").width() - navigatorTogglerWidth - phaseWidth;
    var wrapperWidth = allPhasesWidth + viewWithOnePhaseWidth;
    wrapper.css({
      'min-width': wrapperWidth + 'px'
    });
  }

  function scrollingCtrl() {
    var ctrl = this;

    ctrl.setupScrollToPhase = function () {
      wrapper.siblings("#navigator").find(".phase-link").each(function (phaseIndex, item) {
        angular.element(item).unbind('click');
        angular.element(item).on('click', function () {
          var phaseLink = angular.element(this);
          ctrl.scrollTo(wrapper.find(".phase").eq(phaseIndex), null, function () {
            phaseLink.addClass("scrolled");
          });
        });
      });
    };

    ctrl.scrollTo = function (phase, task, callback) {
      var contentMarginLeft = _.parseInt(wrapper.find("#release-content").css("margin-left"));

      contentMarginLeft = isNaN(contentMarginLeft) ? 0 : contentMarginLeft;

      if (task !== null) {
        var phaseContent = phase.find('.phase-content');
        var li = task.parents('li');

        if (li.offset()) {
          var scrollableContainerTop = phaseContent.offset().top;
          var scrollableContainerBottom = scrollableContainerTop + phaseContent.height();
          var currentTaskOffsetTop = li.offset().top;
          var currentTaskOffsetBottom = currentTaskOffsetTop + li.height();
          var isTaskVisible = currentTaskOffsetBottom <= scrollableContainerBottom && currentTaskOffsetTop >= scrollableContainerTop;

          if (!isTaskVisible) {
            phaseContent.scrollTop(currentTaskOffsetTop - scrollableContainerTop);
          }
        }
      }

      var scrollParams = {
        scrollLeft: phase.prop('offsetLeft') - (navigatorTogglerWidth + contentMarginLeft + phaseMarginLeft),
        scrollTop: 0
      };
      Scroll.animate(wrapper.parents(".view"), scrollParams, callback);
    };

    ctrl.scrollUntilLastPhase = function () {
      var currentScrollLeft = Scroll.getLeftPosition(wrapper.parents(".view"));
      var phaseOutsideWorksheetWidth = allPhasesWidth - (currentScrollLeft + worksheetWidth);

      if (phaseOutsideWorksheetWidth > 0) {
        Scroll.animate(wrapper.parents(".view"), {
          scrollLeft: currentScrollLeft + phaseOutsideWorksheetWidth
        });
      }
    };
  }

  return {
    controller: scrollingCtrl,
    link: function link(currentScope, element, attr, ctrl) {
      wrapper = element;
      scope = currentScope;
      Window.onResize(function () {
        scope.$apply(function () {
          computeWorksheetWidth();
          updateOverflowFlag();
          highlightCurrentPhasesLinks();
        });
      }, scope);
      scope.$watch('release.phases | filter:collapseFilter(release)', function (newPhases, oldPhases) {
        scope.$evalAsync(function () {
          if (angular.isDefined(newPhases)) {
            computeDomElementsDimensions();
            computeWorksheetWidth();
            updateOverflowFlag();
            highlightCurrentPhasesLinks();
            ctrl.setupScrollToPhase();
            wrapper.parents(".view").unbind('scroll', highlightCurrentPhasesLinks);
            wrapper.parents(".view").scroll(highlightCurrentPhasesLinks);

            if (angular.isDefined(oldPhases)) {
              if (worksheetService.isAddedPhaseLast(newPhases, oldPhases)) {
                ctrl.scrollUntilLastPhase();
              }
            }
          }
        });
      }, true);
      scope.$watch('showNavigator', function (isNavigatorOpen, wasNavigatorOpen) {
        if (isNavigatorOpen === wasNavigatorOpen) {
          return;
        }

        computeWorksheetWidth();
        highlightCurrentPhasesLinks();
      });
    }
  };
}]);
angular.module('xlrelease').directive('scrollToMe', function () {
  return {
    require: '^worksheetScrolling',
    link: function link(scope, task, attr, scrollingCtrl) {
      if (!scope.init.hasScrolledToCurrentTask) {
        // DOM must be computed before scrolling
        scope.$watch('', function () {
          scope.$evalAsync(function () {
            scope.init.hasScrolledToCurrentTask = true;
            scrollingCtrl.scrollTo(task.parents(".phase"), task);
          });
        });
      }
    }
  };
});

/***/ }),

/***/ 1366:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').factory('worksheetService', [function () {
  return {
    computeWhichPhasesAreHighlighted: function computeWhichPhasesAreHighlighted(worksheetConfig) {
      var hiddenPartOfLeftTruncatedPhase = worksheetConfig.scrollLeft % worksheetConfig.phaseWidth;
      var phaseWidthWithoutMargin = worksheetConfig.phaseWidth - worksheetConfig.phaseMarginLeft - worksheetConfig.phaseMarginRight;
      var firstPhaseStartVisibleOffset;

      if (hiddenPartOfLeftTruncatedPhase <= worksheetConfig.phaseMarginLeft) {
        firstPhaseStartVisibleOffset = worksheetConfig.phaseMarginLeft - hiddenPartOfLeftTruncatedPhase;
      } else {
        firstPhaseStartVisibleOffset = worksheetConfig.phaseWidth - hiddenPartOfLeftTruncatedPhase + worksheetConfig.phaseMarginLeft;
      }

      var worksheetWithEntirePhasesWidth = worksheetConfig.worksheetWidth - firstPhaseStartVisibleOffset;
      var numberOfDisplayedPhase = 0;

      if (worksheetWithEntirePhasesWidth >= phaseWidthWithoutMargin) {
        numberOfDisplayedPhase = 1 + Math.floor((worksheetWithEntirePhasesWidth - phaseWidthWithoutMargin) / worksheetConfig.phaseWidth);
      }

      var firstPhaseVisibleIndex = Math.floor(worksheetConfig.scrollLeft / worksheetConfig.phaseWidth);

      if (hiddenPartOfLeftTruncatedPhase > worksheetConfig.phaseMarginLeft) {
        firstPhaseVisibleIndex++;
      }

      return {
        firstPhaseVisibleIndex: firstPhaseVisibleIndex,
        numberOfDisplayedPhase: numberOfDisplayedPhase
      };
    },
    isAddedPhaseLast: function isAddedPhaseLast(newPhases, oldPhases) {
      if (newPhases.length === oldPhases.length + 1) {
        var lastNew = newPhases[newPhases.length - 1];
        var lastOld = oldPhases[oldPhases.length - 1];
        return oldPhases.length === 0 || lastNew.id !== lastOld.id;
      }

      return false;
    }
  };
}]);
angular.module('xlrelease').factory('Scroll', [function () {
  var ANIMATION_DURATION = 300;
  return {
    animate: function animate(element, params, callback) {
      element.animate(params, ANIMATION_DURATION, callback);
    },
    getLeftPosition: function getLeftPosition(jqueryElement) {
      return jqueryElement.scrollLeft();
    }
  };
}]);

/***/ }),

/***/ 1367:
/***/ (function(module, exports) {

angular.module('xlrelease').value('GanttCssClasses', {
  DEFAULT: 'gantt-cell',
  RELEASE: 'gantt-cell-release',
  PHASE: 'gantt-cell-phase',
  PHASE_PREFIX: 'gantt-cell-phase-',
  TASK: 'gantt-cell-task',
  TASK_STATUS_PREFIX: 'gantt-cell-task-status-'
});
angular.module('xlrelease').factory('XlrGantt', ['$rootScope', 'GanttElementsEditor', 'ClientSettings', 'GanttZoomSettings', 'Events', '$locale', 'dateFilter', 'GanttZoom', 'Ids', function ($rootScope, GanttElementsEditor, ClientSettings, GanttZoomSettings, Events, $locale, dateFilter, GanttZoom, Ids) {
  var removeLinkEventId, addLinkEventId, scrollState, onAfterLinkDeleteEventId;
  var eventsToDetach = [];
  var datesColumnsWidth = 115;
  var durationColumnsWidth = 100;
  var titleColumnWidth = 250;
  var RELEASE_TYPE = 'xlrelease.Release';
  var UpdateMode = {
    move: 'move',
    updateStartDate: 'updateStartDate',
    updateEndDate: 'updateEndDate'
  };

  function initStyling() {
    gantt.templates.task_class = taskClass;
    gantt.templates.grid_open = gridOpenHtml;
    gantt.templates.grid_row_class = defaultRowClass;
    gantt.templates.task_row_class = defaultRowClass;
    gantt.templates.grid_file = noIconHtml;
    gantt.templates.grid_folder = noIconHtml;
    gantt.templates.link_class = linkClass;

    function taskClass(start, end, task) {
      var classes = [task.cssClass];

      if (!GanttElementsEditor.canUpdateStartDate(task)) {
        classes.push('gantt-no-left-handle');
      }

      if (!GanttElementsEditor.canUpdateEndDate(task)) {
        classes.push('gantt-no-right-handle');
      }

      var parentTask = task.parent ? gantt.getTask(task.parent) : null;

      if (!GanttElementsEditor.canCreateLinks(parentTask)) {
        classes.push('gantt-no-custom-links');
      }

      return classes.join(' ');
    }

    function linkClass(link) {
      return link.readOnly ? 'readonly-link' : '';
    }

    function defaultRowClass() {
      return 'gantt-row';
    }

    function noIconHtml() {
      return '<span class="no-icon"></span>';
    }

    function gridOpenHtml(item) {
      var classes = ['gantt_tree_icon xl-icon', 'gantt-folder'];

      if (item.$open) {
        classes.push('gantt_close arrow-down-icon', 'gantt-folder-close');
      } else {
        classes.push('gantt_open arrow-right-icon', 'gantt-folder-open');
      }

      return "<div class='" + classes.join(' ') + "'>​</div>​";
    }
  }

  function initLocale() {
    gantt.locale.date = {
      month_full: $locale.DATETIME_FORMATS.MONTH,
      month_short: $locale.DATETIME_FORMATS.SHORTMONTH,
      day_full: $locale.DATETIME_FORMATS.DAY,
      day_short: $locale.DATETIME_FORMATS.SHORTDAY
    };
  }

  function initEvents() {
    eventsToDetach.forEach(function (eventId) {
      gantt.detachEvent(eventId);
    });
    eventsToDetach = [];

    var attachEventToGantt = function attachEventToGantt(event, handler) {
      var eventId = gantt.attachEvent(event, handler);
      eventsToDetach.push(eventId);
      return eventId;
    };

    attachEventToGantt("onBeforeTaskDrag", function (id, mode) {
      scrollState = gantt.getScrollState();
      var element = gantt.getTask(id);
      element.previousScheduledStartDate = element.start_date;
      element.previousDueDate = element.end_date;

      switch (getUpdateMode(mode)) {
        case UpdateMode.move:
          return GanttElementsEditor.canMove(element);

        case UpdateMode.updateStartDate:
          return GanttElementsEditor.canUpdateStartDate(element);

        case UpdateMode.updateEndDate:
          return GanttElementsEditor.canUpdateEndDate(element);

        default:
          _.noop();

      }
    });
    attachEventToGantt("onAfterTaskDrag", function (id, mode) {
      var element = gantt.getTask(id);

      switch (getUpdateMode(mode)) {
        case UpdateMode.move:
          GanttElementsEditor.move(element, element.start_date, element.end_date);
          break;

        case UpdateMode.updateStartDate:
          GanttElementsEditor.dragLeft(element, element.start_date);
          break;

        case UpdateMode.updateEndDate:
          GanttElementsEditor.dragRight(element, element.end_date);
          break;

        default:
          _.noop();

      }

      gantt.scrollTo(scrollState.x, scrollState.y);
    });

    function canAddLink(linkId, link) {
      var source = gantt.getTask(link.source);
      var target = gantt.getTask(link.target);
      return GanttElementsEditor.canLink(source, target, link.type);
    }

    function saveCollapseState(id, isOpen) {
      var states = ClientSettings.getGanttElementsCollapseState();
      if (!states) states = {};
      states[id] = isOpen;
      ClientSettings.setGanttElementsCollapseState(states);
    } // Almost the same listener here, expect that it doesn't take a linkId


    var canAddLinkWithoutLinkId = _.partial(canAddLink, undefined);

    attachEventToGantt("onLinkValidation", canAddLinkWithoutLinkId);
    attachEventToGantt("onBeforeLinkAdd", canAddLink);
    attachEventToGantt("onTaskClosed", function (id) {
      saveCollapseState(id, false);
    });
    attachEventToGantt("onTaskOpened", function (id) {
      saveCollapseState(id, true);
    });
    addLinkEventId = attachEventToGantt("onAfterLinkAdd", function (linkId, link) {
      var source = gantt.getTask(link.source);
      var target = gantt.getTask(link.target);
      var container = gantt.getTask(source.parent);
      GanttElementsEditor.addLink(link, container, source, target);
    });
    onAfterLinkDeleteEventId = attachEventToGantt("onAfterLinkDelete", function (linkId, link) {
      var source = gantt.getTask(link.source);
      var container = gantt.getTask(source.parent);
      GanttElementsEditor.removeLink(link, container);
    });
    attachEventToGantt("onTaskDblClick", function (elementId) {
      var element = gantt.getTask(elementId);

      if (element.type === "xlrelease.Release") {// To be implemented
      } else if (element.type === "xlrelease.Phase") {
        $rootScope.$apply(function () {
          $rootScope.$broadcast(Events.gantt.openPhaseDetails, elementId);
        });
      } else {
        $rootScope.$apply(function () {
          $rootScope.$broadcast(Events.gantt.openTaskDetails, elementId);
        });
      }

      return false;
    });
    attachEventToGantt("isDateReadOnly", function (id) {
      var element = gantt.getTask(id);
      return isDateReadOnly(element);
    });
    attachEventToGantt('onTaskClick', _.constant(false));
  }

  function initRemoveLinkEvent(isReadOnly) {
    removeLinkEventId = gantt.attachEvent("onLinkDblClick", function (linkId) {
      var link = gantt.getLink(linkId);
      var source = gantt.getTask(link.source);
      var parent = gantt.getTask(source.parent);
      return !link.readOnly && !isReadOnly && !parent.locked;
    });
  }

  function formatDateAndTime(date) {
    return "<span class='readonly-date'>" + dateFilter(date, 'shortDate') + "</span><span class='readonly-time'>" + dateFilter(date, 'shortTime') + "</span>";
  }

  function isDateDeletable(element, dateType) {
    if (element.status === "TEMPLATE" && dateType === "end") {
      return true;
    }

    return element.type !== RELEASE_TYPE;
  }

  function dateEditorTemplate(date, dateType, hasOwnDate, element) {
    var elementId = element.id;
    var dateCanBeDeleted = isDateDeletable(element, dateType);
    return "<div class='gantt-date-editor-container' " + "data-date=" + date.getTime() + " " + "data-type='" + dateType + "' " + "data-id='" + elementId + "' " + "data-deletable='" + dateCanBeDeleted + "' " + "data-has-own-date='" + hasOwnDate + "'" + "></div>";
  }

  function durationEditorTemplate(plannedDuration, displayedDuration, elementId, done, editable) {
    function toBoolean(value) {
      return value ? 'true' : 'false';
    }

    return "<div class='gantt-duration-editor-container' " + "data-duration='" + plannedDuration + "' " + "data-display-duration='" + displayedDuration + "' d" + "ata-id='" + elementId + "' " + "data-done='" + toBoolean(done) + "' " + "data-editable='" + toBoolean(editable) + "' " + "></div>";
  }

  function getGridWidth(isDatesColumnsShown) {
    var width = 20;
    width += titleColumnWidth;

    if (isDatesColumnsShown) {
      width += 2 * datesColumnsWidth + durationColumnsWidth;
    }

    return width;
  }

  function isDateReadOnly(element) {
    return Ids.isReleaseId(element.id) || Ids.isPhaseId(element.id) ? gantt.config.isReleaseOrPhaseDateReadOnly : gantt.config.readonly;
  }

  function getColumns(isDatesColumnsShown) {
    var columns = [{
      name: "text",
      tree: true,
      width: titleColumnWidth + "px"
    }];

    if (isDatesColumnsShown) {
      columns.push({
        name: "start_date",
        align: "left",
        width: datesColumnsWidth + "px",
        template: function template(element) {
          if (element.hasBeenStarted || isDateReadOnly(element)) {
            return formatDateAndTime(element.start_date);
          } else {
            return dateEditorTemplate(element.start_date, "start", element.hasOwnStartDate, element);
          }
        }
      });
      columns.push({
        name: "end_date",
        align: "left",
        width: datesColumnsWidth + "px",
        template: function template(element) {
          if (!element.isUpdatable || isDateReadOnly(element)) {
            return formatDateAndTime(element.end_date);
          } else {
            return dateEditorTemplate(element.end_date, "end", element.hasOwnEndDate, element);
          }
        }
      });
      columns.push({
        name: "duration",
        align: "middle",
        width: durationColumnsWidth + "px",
        template: function template(element) {
          var editable = element.isUpdatable && !isDateReadOnly(element);
          return durationEditorTemplate(element.planItem.plannedDuration, element.displayDuration, element.id, element.planItem.done, editable);
        }
      });
    }

    return columns;
  }

  return {
    config: function config(isDatesColumnsShown) {
      gantt.config.round_dnd_dates = false;
      gantt.config.fit_tasks = true;
      GanttZoom.getCurrent().apply(); // set columns

      gantt.locale.labels.column_text = 'Name';

      if (isDatesColumnsShown) {
        gantt.locale.labels.column_start_date = 'Start date';
        gantt.locale.labels.column_end_date = 'End date';
        gantt.locale.labels.column_duration = 'Duration';
      }

      gantt.config.columns = getColumns(isDatesColumnsShown);
      gantt.config.grid_width = getGridWidth(isDatesColumnsShown); //read only settings

      gantt.config.show_progress = false;
      gantt.config.drag_links = true;
      gantt.config.min_duration = 60 * 1000;
      initStyling();
      initLocale();
      initEvents();
    },
    initReadOnly: function initReadOnly(isReadOnly, isReleaseOrPhaseDateReadOnly) {
      gantt.config.readonly = isReadOnly;
      gantt.config.isReleaseOrPhaseDateReadOnly = isReleaseOrPhaseDateReadOnly;
      gantt.config.drag_resize = !isReleaseOrPhaseDateReadOnly;
      initRemoveLinkEvent(isReadOnly);
    },
    destroy: function destroy() {
      gantt.unselectTask();
      gantt.clearAll();
      if (removeLinkEventId) gantt.detachEvent(removeLinkEventId);
      if (addLinkEventId) gantt.detachEvent(addLinkEventId);
      if (onAfterLinkDeleteEventId) gantt.detachEvent(onAfterLinkDeleteEventId);
    }
  };

  function getUpdateMode(mode) {
    if (mode === gantt.config.drag_mode.move) {
      return UpdateMode.move;
    } else if (mode === gantt.config.drag_mode.resize) {
      if (gantt.getState().drag_from_start) {
        return UpdateMode.updateStartDate;
      } else {
        return UpdateMode.updateEndDate;
      }
    }
  }
}]);

/***/ }),

/***/ 1368:
/***/ (function(module, exports) {

angular.module('xlrelease').controller('GanttController', ['$scope', '$location', 'GanttZoom', 'releasePromise', 'Events', 'ReleasesService', 'GanttElementsEditor', 'Backend', 'TaskDetailsUpdates', 'PhaseDetailsUpdates', 'Page', 'ClientSettings', 'Planner', 'DependenciesService', 'ViewStorage', function ($scope, $location, GanttZoom, releasePromise, Events, ReleasesService, GanttElementsEditor, Backend, TaskDetailsUpdates, PhaseDetailsUpdates, Page, ClientSettings, Planner, DependenciesService, ViewStorage) {
  $scope.release = releasePromise.data;
  Planner.setRelease($scope.release);
  DependenciesService.getReleaseTree($scope.release).then(function (releaseTree) {
    Planner.setReleaseTree(releaseTree);
    GanttElementsEditor.updateGanttElements();
  });
  ViewStorage.setView($scope.release.id, $location.path());
  Page.setReleaseOpened($scope.release);
  $scope.inGantt = true;
  $scope.ganttZoom = GanttZoom;
  $scope.ganttConfig = {
    isReadOnly: !($scope.security.hasEditTaskPermission($scope.release) || $scope.security.hasEditTaskDatesPermission($scope.release)),
    isReleaseOrPhaseDateReadOnly: !$scope.security.hasEditPermission($scope.release),
    isDatesColumnsShown: ClientSettings.getGanttDatesColumnsCollapseState()
  };

  function loadGanttAfterUpdate() {
    ReleasesService.getRelease($scope.release.id).then(function (resp) {
      $scope.release = resp.data;
      Planner.setRelease($scope.release);
      GanttElementsEditor.updateGanttElements();
    });
  }

  $scope.endEditTask = function () {
    $scope.editTask = false;

    if (TaskDetailsUpdates.planningDataChanged) {
      loadGanttAfterUpdate();
      TaskDetailsUpdates.reset();
    } else {
      GanttElementsEditor.updateGanttElements();
    }
  };

  $scope.$on(Events.gantt.openTaskDetails, function (event, taskId) {
    var tasks = ReleasesService.getAllTasks($scope.release);
    $scope.task = _.find(tasks, {
      id: taskId
    });
    $scope.editTask = true;
  });

  $scope.endEditPhase = function () {
    $scope.editPhase = false;

    if (PhaseDetailsUpdates.planningDataChanged) {
      loadGanttAfterUpdate();
      PhaseDetailsUpdates.reset();
    } else {
      GanttElementsEditor.updateGanttElements();
    }
  };

  $scope.$on(Events.gantt.openPhaseDetails, function (event, phaseId) {
    $scope.phase = _.find($scope.release.phases, {
      id: phaseId
    });
    $scope.editPhase = true;
  });
  $scope.$watch('ganttConfig.isDatesColumnsShown', function (newValue, oldValue) {
    if (newValue !== oldValue) {
      ClientSettings.setGanttDatesColumnsCollapseState($scope.ganttConfig.isDatesColumnsShown);
    }
  });
}]);

/***/ }),

/***/ 1369:
/***/ (function(module, exports) {

/* eslint-disable angular/module-getter */
function GanttDirective(Planner, XlrGantt, $parse, Window, $compile, Timeout, Events, GanttWrapper, Layout) {
  function adjustGanttHeight(ganttElement) {
    // 2 extra pixels needed for some unknown reason
    var extra = 2;
    ganttElement.height(Window.height() - ganttElement.offset().top - Layout.mainPageBorder - extra);
  } // link need to be undefined for IE...


  var dateEditorLink = undefined;
  var durationEditorLink = undefined;

  function postProcessGanttDom(scope) {
    if (!dateEditorLink) {
      dateEditorLink = $compile("<div gantt-date-editor></div>");
    }

    if (!durationEditorLink) {
      durationEditorLink = $compile("<div gantt-duration-editor></div>");
    }

    Timeout(function () {
      angular.element('.gantt-date-editor-container, .gantt-duration-editor-container').each(function (index, item) {
        var editor = angular.element(item).hasClass('gantt-date-editor-container') ? dateEditorLink : durationEditorLink;
        angular.element(item).empty();
        editor(scope, function (clonedElement) {
          angular.element(item).append(clonedElement);
        });
      });
    }, 0);
  }

  return function link(scope, element, attrs) {
    XlrGantt.config(scope.ganttConfig.isDatesColumnsShown);
    scope.$on(Events.gantt.hasBeenRefreshed, function () {
      postProcessGanttDom(scope);
    });
    XlrGantt.initReadOnly($parse(attrs.readonly)(scope), $parse(attrs.isreleaseorphasedatereadonly)(scope));
    adjustGanttHeight(element);
    element.dhx_gantt({
      data: {
        data: Planner.makePlan().elements,
        links: Planner.getLinks()
      }
    });
    Window.onResize(function () {
      adjustGanttHeight(element);
    }, scope);
    element.on('$destroy', function () {
      XlrGantt.destroy();
    });
    scope.$watch('ganttConfig.isDatesColumnsShown', function (newValue, oldValue) {
      if (newValue !== oldValue) {
        XlrGantt.config(newValue);
        GanttWrapper.render();
      }
    });
  };
}

GanttDirective.$inject = ['Planner', 'XlrGantt', '$parse', 'Window', '$compile', 'Timeout', 'Events', 'GanttWrapper', 'Layout'];
angular.module('xlrelease').directive('xlrGantt', GanttDirective);

/***/ }),

/***/ 1370:
/***/ (function(module, exports) {

angular.module('xlrelease').factory('GanttElementsEditor', ['GanttCssClasses', 'PhaseColors', 'TasksService', 'taskTypeCssClassFilter', 'Backend', 'VariablesInterpolator', 'GanttWrapper', 'Planner', 'TopologicalSort', 'PlanningDataEditor', function (GanttCssClasses, PhaseColors, TasksService, taskTypeCssClassFilter, Backend, VariablesInterpolator, GanttWrapper, Planner, TopologicalSort, PlanningDataEditor) {
  var FROM_END_TO_START = '0';

  function createsCycle(existingEdges, newSource, newTarget) {
    var adjacencyList = [];
    var vertices = {};

    _.forEach(existingEdges, function (edge) {
      var sourceId = edge.source,
          targetId = edge.target;
      adjacencyList.push({
        sourceId: sourceId,
        targetId: targetId
      });
      vertices[sourceId] = vertices[targetId] = true;
    });

    var sourceId = newSource.id,
        targetId = newTarget.id;
    adjacencyList.push({
      sourceId: sourceId,
      targetId: targetId
    });
    vertices[sourceId] = vertices[targetId] = true;
    var graph = {
      adjacencyList: adjacencyList,
      vertices: _.keys(vertices)
    };
    return TopologicalSort.sort(graph) === null;
  }

  function saveAndRefresh(element) {
    updateGanttElements();
    Backend.put('planning/' + element.id, {
      scheduledStartDate: element.planItem.scheduledStartDate,
      dueDate: element.planItem.dueDate,
      plannedDuration: element.planItem.plannedDuration
    });
  }

  function updateGanttElements() {
    var elements = Planner.makePlan().elements;

    _.forEach(elements, function (updatedElement) {
      var element = GanttWrapper.getTask(updatedElement.id);
      angular.extend(element, updatedElement);
    });

    GanttWrapper.refreshData();
  }

  return {
    dragLeft: function dragLeft(element, date) {
      PlanningDataEditor.dragLeft(element, date);
      saveAndRefresh(element);
    },
    dragRight: function dragRight(element, date) {
      PlanningDataEditor.dragRight(element, date);
      saveAndRefresh(element);
    },
    move: function move(element, startDate, endDate) {
      PlanningDataEditor.move(element, startDate, endDate);
      saveAndRefresh(element);
    },
    setStartDate: function setStartDate(element, date) {
      PlanningDataEditor.setStartDate(element, date);
      saveAndRefresh(element);
    },
    setEndDate: function setEndDate(element, date) {
      PlanningDataEditor.setEndDate(element, date);
      saveAndRefresh(element);
    },
    setDuration: function setDuration(element, duration) {
      PlanningDataEditor.setDuration(element, duration);
      saveAndRefresh(element);
    },
    canMove: function canMove(element) {
      return this.canUpdateStartDate(element) && this.canUpdateEndDate(element) && !element.locked;
    },
    canUpdateStartDate: function canUpdateStartDate(element) {
      return element.hasBeenStarted === false && !element.locked;
    },
    canUpdateEndDate: function canUpdateEndDate(element) {
      return element.isUpdatable && !element.locked;
    },
    canCreateLinks: function canCreateLinks(container) {
      return container && TasksService.isParallelGroup(container) && !container.hasBeenStarted && !container.locked;
    },
    canLink: function canLink(source, target, linkType) {
      return linkType === FROM_END_TO_START && source.parent === target.parent && !GanttWrapper.isLinkExists(Planner.makeLinkId(source.id, target.id)) && !createsCycle(GanttWrapper._get_links_data(), source, target);
    },
    addLink: function addLink(link, container, source, target) {
      var linkForm = {
        sourceId: source.id,
        targetId: target.id
      };
      container.planItem.links.push(linkForm);
      updateGanttElements();
      Backend.post("planning/links/".concat(container.id), linkForm).then(function (resp) {
        linkForm.id = link.linkId = resp.data.id;
        GanttWrapper.changeLinkId(link.id, Planner.makeLinkId(source.id, target.id));
      });
    },
    removeLink: function removeLink(link, container) {
      container.planItem.links = _.reject(container.planItem.links, {
        id: link.linkId
      });
      updateGanttElements();
      Backend.del("planning/links/".concat(link.linkId));
    },
    updateGanttElements: updateGanttElements
  };
}]);

/***/ }),

/***/ 1371:
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Wrap the gantt global variable for test purposes
 */

angular.module('xlrelease').factory('GanttWrapper', ['$rootScope', 'Events', function ($rootScope, Events) {
  var oldRender = gantt.render;
  var oldRefreshData = gantt.refreshData;

  gantt.render = function () {
    $rootScope.$broadcast(Events.gantt.hasBeenRefreshed);
    oldRender.call(gantt);
  };

  gantt.refreshData = function () {
    $rootScope.$broadcast(Events.gantt.hasBeenRefreshed);
    oldRefreshData.call(gantt);
  };

  return gantt;
}]);

/***/ }),

/***/ 1372:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').factory('GanttZoom', ['GanttZoomSettings', 'ClientSettings', function (GanttZoomSettings, ClientSettings) {
  var registeredZoomLevel = ClientSettings.getGanttZoomLevel();
  var current;

  if (registeredZoomLevel) {
    current = GanttZoomSettings.findByLabel(registeredZoomLevel);
  } else {
    current = GanttZoomSettings.defaultZoom;
  }

  var zooms = GanttZoomSettings.zooms;

  function currentIndex() {
    return _.indexOf(zooms, current);
  }

  return {
    zooms: zooms,
    getCurrent: function getCurrent() {
      return current;
    },
    isCurrent: function isCurrent(zoom) {
      return current === zoom;
    },
    next: function next() {
      return this.zooms[currentIndex() + 1];
    },
    previous: function previous() {
      return this.zooms[currentIndex() - 1];
    },
    hasNext: function hasNext() {
      return currentIndex() < this.zooms.length - 1;
    },
    hasPrevious: function hasPrevious() {
      return currentIndex() > 0;
    },
    select: function select(zoom) {
      current = zoom;
      ClientSettings.setGanttZoomLevel(current.label);
      current.render();
    }
  };
}]);
angular.module('xlrelease').factory('GanttZoomSettings', ['DateFormatDetector', function (DateFormatDetector) {
  var Zoom = function Zoom(label, applyFn) {
    this.label = label;
    this.apply = applyFn;
  };

  Zoom.prototype.render = function () {
    this.apply();
    gantt.render();
  };

  var hourFormat = DateFormatDetector.isAmPmVisible() ? "%g%a" : "%Hh";
  var hourFormatWithMinutes = DateFormatDetector.isAmPmVisible() ? "%g:%i%a" : "%Hh%i";
  var isMonthDisplayedBeforeDay = DateFormatDetector.isMonthDisplayedBeforeDay();
  var shortDayFormat = isMonthDisplayedBeforeDay ? "%M %d" : "%d %M";
  var longDayFormat = isMonthDisplayedBeforeDay ? "%F %d" : "%d %F";
  var zooms = [new Zoom('Month', function () {
    gantt.config.scale_unit = "month";
    gantt.config.date_scale = "%M";
    gantt.config.subscales = [];
    gantt.config.time_step = 60 * 24; // minutes
  }), new Zoom('Week', function () {
    gantt.config.scale_unit = "week";
    gantt.config.date_scale = "Week %W";
    gantt.config.subscales = [];
    gantt.config.time_step = 60 * 24; // minutes
  }), new Zoom('Day', function () {
    gantt.config.scale_unit = "day";
    gantt.config.date_scale = shortDayFormat;
    gantt.config.subscales = [];
    gantt.config.time_step = 60; // minutes
  }), new Zoom('8h', function () {
    gantt.config.scale_unit = "day";
    gantt.config.date_scale = longDayFormat;
    gantt.config.subscales = [{
      unit: "hour",
      step: 8,
      date: hourFormat
    }];
    gantt.config.time_step = 10; // minutes
  }), new Zoom('4h', function () {
    gantt.config.scale_unit = "day";
    gantt.config.date_scale = longDayFormat;
    gantt.config.subscales = [{
      unit: "hour",
      step: 4,
      date: hourFormat
    }];
    gantt.config.time_step = 10; // minutes
  }), new Zoom('2h', function () {
    gantt.config.scale_unit = "day";
    gantt.config.date_scale = longDayFormat;
    gantt.config.subscales = [{
      unit: "hour",
      step: 2,
      date: hourFormat
    }];
    gantt.config.time_step = 10; // minutes
  }), new Zoom('1h', function () {
    gantt.config.scale_unit = "day";
    gantt.config.date_scale = longDayFormat;
    gantt.config.subscales = [{
      unit: "hour",
      step: 1,
      date: hourFormat
    }];
    gantt.config.time_step = 10; // minutes
  }), new Zoom('30min', function () {
    gantt.config.scale_unit = "day";
    gantt.config.date_scale = longDayFormat;
    gantt.config.subscales = [{
      unit: "minute",
      step: 30,
      date: hourFormatWithMinutes
    }];
    gantt.config.time_step = 10; // minutes
  }), new Zoom('15min', function () {
    gantt.config.scale_unit = "day";
    gantt.config.date_scale = longDayFormat;
    gantt.config.subscales = [{
      unit: "minute",
      step: 15,
      date: hourFormatWithMinutes
    }];
    gantt.config.time_step = 5; // minutes
  }), new Zoom('5min', function () {
    gantt.config.scale_unit = "day";
    gantt.config.date_scale = longDayFormat;
    gantt.config.subscales = [{
      unit: "minute",
      step: 5,
      date: hourFormatWithMinutes
    }];
    gantt.config.time_step = 5; // minutes
  })];
  return {
    zooms: zooms,
    defaultZoom: zooms[2],
    findByLabel: function findByLabel(searchedLabel) {
      return _.find(zooms, {
        label: searchedLabel
      }) || this.defaultZoom;
    }
  };
}]);

/***/ }),

/***/ 1373:
/***/ (function(module, exports) {

angular.module('xlrelease').factory('PlanningDataEditor', ['TasksService', function (TasksService) {
  function isContainer(item) {
    return !TasksService.isTask(item) || TasksService.isTaskGroup(item);
  }

  function hasValue(duration) {
    return duration !== null && angular.isDefined(duration);
  }

  function hasPlannedDuration(planItem) {
    return hasValue(planItem.plannedDuration);
  }

  function positiveOrNull(plannedDuration) {
    return plannedDuration >= 0 ? plannedDuration : null;
  }

  return {
    /**
     * Dragging left edge affects start date and duration
     */
    dragLeft: function dragLeft(element, date) {
      if (hasPlannedDuration(element.planItem)) {
        if (element.planItem.dueDate) {
          element.planItem.plannedDuration = moment(element.planItem.dueDate).diff(date, 'milliseconds');
        } else if (element.displayStartDate) {
          element.planItem.plannedDuration += moment(element.displayStartDate).diff(date, 'milliseconds');
        }
      } else {
        if (!element.planItem.dueDate) {
          element.planItem.plannedDuration = moment(element.displayEndDate).diff(date, 'milliseconds');
        }
      }

      element.planItem.scheduledStartDate = date;
    },

    /**
     * Dragging right edge affects duration (and due date as a consequence if it was set)
     */
    dragRight: function dragRight(element, date) {
      if (!isContainer(element.planItem)) {
        var plannedDuration = moment(date).diff(element.displayStartDate, 'milliseconds');

        if (element.planItem.dueDate) {
          var previousDuration = moment(element.planItem.dueDate).diff(element.displayStartDate, 'milliseconds');
          element.planItem.dueDate = moment(element.planItem.dueDate).subtract(previousDuration - plannedDuration, 'milliseconds').valueOf();
        }

        element.planItem.plannedDuration = plannedDuration;
      } else {
        if (hasPlannedDuration(element.planItem)) {
          if (element.displayStartDate) {
            element.planItem.plannedDuration = moment(date).diff(element.displayStartDate, 'milliseconds');
          } else if (element.planItem.dueDate) {
            element.planItem.plannedDuration += moment(date).diff(element.planItem.dueDate, 'milliseconds');
          }
        }

        element.planItem.dueDate = date;
      }
    },

    /**
     * Dragging entire thing affects only scheduled start date, and update due if it was set
     */
    move: function move(element, startDate, endDate) {
      element.planItem.scheduledStartDate = startDate;

      if (element.planItem.dueDate) {
        element.planItem.dueDate = endDate;
      }
    },
    setStartDate: function setStartDate(element, date) {
      if (date && element.planItem.dueDate && hasPlannedDuration(element.planItem)) {
        var plannedDuration = moment(element.planItem.dueDate).diff(date, 'milliseconds');
        element.planItem.plannedDuration = positiveOrNull(plannedDuration);
      }

      element.planItem.scheduledStartDate = date;
    },
    setEndDate: function setEndDate(element, date) {
      var itemStartDate = element.planItem.startDate || element.planItem.scheduledStartDate;

      if (date && itemStartDate && hasPlannedDuration(element.planItem)) {
        var plannedDuration = moment(date).diff(itemStartDate, 'milliseconds');
        element.planItem.plannedDuration = positiveOrNull(plannedDuration);
      }

      element.planItem.dueDate = date;
    },
    setDuration: function setDuration(element, duration) {
      if (hasValue(duration) && element.planItem.dueDate) {
        var itemStartDate = element.planItem.startDate || element.planItem.scheduledStartDate || element.displayStartDate;
        element.planItem.dueDate = moment(itemStartDate).add(duration, 'milliseconds');
      }

      element.planItem.plannedDuration = duration;
    }
  };
}]);

/***/ }),

/***/ 1374:
/***/ (function(module, exports) {

/**
 * This service is used by all controllers that needs to change planning data (scheduled start date, due date and duration)
 *
 * It should be used as a mixin, to enhance the $scope
 * usage :
 *      angular.extend($scope, PlanningDataEditorMixin.withSaveCallback(yourCallback));
 *
 *      - then all functions defined in this service are available in the $scope. eg. $scope.planning.updateDuration.
 *      - $scope.planning.initPlanningData MUST be called before calling other methods.
 *      - item can be either a task, a phase or a release.
 *      - the callback is called whenever planning rules have been applied.
 */
angular.module('xlrelease').factory('PlanningDataEditorMixin', ['PlanningDataEditor', 'Planner', 'DependenciesService', 'ReleasesService', function (PlanningDataEditor, Planner, DependenciesService, ReleasesService) {
  return {
    withSaveCallback: function withSaveCallback(saveCallback) {
      return new function () {
        var planning = {};
        this.planning = planning;

        function refreshPlanElement(id) {
          planning.planElement = _.find(Planner.makePlan().elements, {
            id: id
          });
        }

        planning.initPlanningData = function (item, release) {
          if (release) {
            Planner.setRelease(release);
            Planner.setReleaseTree(null);
            refreshPlanElement(item.id);
          }
        };

        planning.updateDuration = function (item) {
          PlanningDataEditor.setDuration(planning.planElement, item.plannedDuration);
          planning.savePlanningData(item);
        };

        planning.updateDueDate = function (item) {
          PlanningDataEditor.setEndDate(planning.planElement, item.dueDate);
          planning.savePlanningData(item);
        };

        planning.updateScheduledStartDate = function (item) {
          PlanningDataEditor.setStartDate(planning.planElement, item.scheduledStartDate);
          planning.savePlanningData(item);
        };

        planning.savePlanningData = function (item) {
          item.plannedDuration = planning.planElement.planItem.plannedDuration;
          item.scheduledStartDate = planning.planElement.planItem.scheduledStartDate;
          item.dueDate = planning.planElement.planItem.dueDate;
          refreshPlanElement(item.id);
          saveCallback(item);
        };
      }();
    }
  };
}]);

/***/ }),

/***/ 1377:
/***/ (function(module, exports) {

angular.module('xlrelease').factory('PhaseDetailsUpdates', [function () {
  return {
    planningDataChanged: false,
    reset: function reset() {
      this.planningDataChanged = false;
    }
  };
}]);

/***/ }),

/***/ 1378:
/***/ (function(module, exports) {

angular.module('xlrelease').directive('releaseFlowHeader', function () {
  return {
    templateUrl: 'partials/releases/release-flow-header.html',
    replace: true,
    transclude: true
  };
});

/***/ }),

/***/ 1379:
/***/ (function(module, exports) {

angular.module('xlrelease').directive('releaseHeader', function () {
  return {
    templateUrl: 'partials/releases/release-header.html',
    replace: true,
    transclude: true,
    controller: 'releaseHeaderController'
  };
});

/***/ }),

/***/ 1380:
/***/ (function(module, exports) {

var injectParams = ['$location', '$stateParams', 'UiExtensionsService', 'Backend', 'Page', 'releasePromise'];

var ReleasePageExtensionController = function ReleasePageExtensionController($location, $stateParams, UiExtensionsService, Backend, Page, releasePromise) {
  var vm = this;
  vm.release = releasePromise.data;
  loadPageExtension(); ///

  function redirectToDefaultPage() {
    // If the current URL is /releases/Release1, we redirect the user to 'releases'
    var defaultPage = $location.path().substring(1);
    defaultPage = defaultPage.substring(0, defaultPage.indexOf('/'));
    $location.url(defaultPage);
  }

  function loadPageExtension() {
    UiExtensionsService.getReleaseMenuExtensions(vm.release).then(function (extensions) {
      vm.pageExtension = _.find(extensions, {
        pathSuffix: $stateParams.extensionPath,
        permitted: true
      });

      if (vm.pageExtension) {
        if (vm.pageExtension.properties && vm.pageExtension.properties.showOnlyOnTemplate && vm.release.status !== 'TEMPLATE') {
          redirectToDefaultPage();
        }

        Page.setReleaseOpened(vm.release);
      } else {
        redirectToDefaultPage();
      }
    });
  }
};

ReleasePageExtensionController.$inject = injectParams;
angular.module('xlrelease').controller('releasePageExtensionController', ReleasePageExtensionController);

/***/ }),

/***/ 1381:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').controller('releaseVariablesController', ['$scope', 'Page', 'releasePromise', 'VariablesService', 'ReleasesService', 'Authenticator', 'Ids', function ($scope, Page, releasePromise, VariablesService, ReleasesService, Authenticator, Ids) {
  $scope.release = releasePromise.data;
  $scope.readonly = isReadonly($scope.release);
  $scope.pageType = $scope.release.status === 'TEMPLATE' ? 'TEMPLATE' : 'RELEASE';
  $scope.filters = {
    filter: ''
  };
  $scope.releaseVariable = true;
  $scope.updateReleaseVariable = updateReleaseVariable;
  $scope.createReleaseVariable = createReleaseVariable;
  $scope.deleteReleaseVariable = deleteReleaseVariable;
  $scope.reorderReleaseVariables = reorderReleaseVariables;
  $scope.newVariable = newVariable;
  $scope.showReleaseVariable = showReleaseVariable;
  $scope.isInFolder = Ids.isInFolder($scope.release.id);
  $scope.folderId = $scope.isInFolder ? Ids.releaseIdToFolderId($scope.release.id) : undefined;
  load();

  function load() {
    Page.setReleaseOpened($scope.release);
    loadAllVariables();
  }

  function isReadonly(release) {
    return ReleasesService.isReleaseCompleted(release) || !Authenticator.hasEditPermission(release);
  }

  function loadAllVariables() {
    VariablesService.getAllVariables($scope.release.id).then(function (allVariables) {
      $scope.allVariables = allVariables;
      $scope.folderVariables = _.sortBy(allVariables.filter(function (variable) {
        return VariablesService.isFolderVariable(variable.key);
      }), ['key']);
      var variables = [];
      angular.copy(allVariables, variables);
      $scope.variables = _.map(_.reject(variables, function (v) {
        return VariablesService.isFolderOrGlobalVariable(v.key);
      }), function (v) {
        delete v.displayName;
        delete v.variableName;
        return v;
      });
    });
  }

  function updateReleaseVariable(variable, onSuccess) {
    VariablesService.updateReleaseVariable(variable).then(function (result) {
      var updated = result.data;

      _.assign(_.find($scope.variables, {
        key: updated.key
      }), updated);

      _.assign(_.find($scope.allVariables, {
        key: updated.key
      }), updated);

      onSuccess();
    });
  }

  function createReleaseVariable(variable, onSuccess) {
    VariablesService.createReleaseVariable($scope.release.id, variable).then(function (result) {
      var variable = result.data;
      $scope.variables.push(variable);
      $scope.allVariables.push(VariablesService.decorateVariable(variable));
      onSuccess(variable);
    });
  }

  function newVariable() {
    return {
      type: 'xlrelease.StringVariable',
      requiresValue: true,
      showOnReleaseStart: true
    };
  }

  function deleteReleaseVariable(variable, onSuccess) {
    VariablesService.replaceReleaseVariable(variable, {
      value: variable.value,
      variable: variable.variable
    }).then(function () {
      return VariablesService.deleteReleaseVariable(variable);
    }).then(function () {
      loadAllVariables();
      onSuccess();
    });
  }

  function reorderReleaseVariables(variables) {
    VariablesService.updateReleaseVariables($scope.release.id, variables).then(function (result) {
      return $scope.variables = result.data;
    });
  }

  function showReleaseVariable(isReleaseVariable) {
    $scope.releaseVariable = isReleaseVariable;
  }
}]);

/***/ }),

/***/ 1383:
/***/ (function(module, exports) {

angular.module('xlrelease').filter('duration', function () {
  function truncate(durationInDays) {
    if (durationInDays >= 10) {
      durationInDays = Math.ceil(durationInDays);
    }

    return durationInDays;
  }

  return function (durationInMs) {
    var durationInSec = Math.floor(durationInMs / 1000);

    if (durationInSec < 60) {
      return durationInSec + ' sec';
    }

    var durationInMin = Math.floor(durationInSec / 60);

    if (durationInMin < 60) {
      return durationInMin + ' min';
    }

    var durationInHours = truncate(Math.ceil(durationInMin / 6) / 10);

    if (durationInHours < 24) {
      return durationInHours + ' hours';
    }

    return truncate(Math.ceil(durationInHours / 2.4) / 10) + ' days';
  };
});

/***/ }),

/***/ 1384:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').factory('MostRecentReleaseCharts', ['reportConfigurationService', function (reportConfigurationService) {
  return {
    stackedBarCharts: function stackedBarCharts(options) {
      return function link(scope, element) {
        scope.$watch('reports.mostRecentReleases.data', function (data) {
          if (element.highcharts()) {
            element.highcharts().destroy();
          }

          if (data && data.length) {
            var releasesTitle = _.map(data, 'title');

            var series = options.series(data);
            var chartDef = {
              colors: ['#a52a2a', '#68b749'],
              xAxis: {
                categories: releasesTitle,
                labels: {
                  rotation: -90,
                  align: 'right',
                  formatter: function formatter() {
                    var maxLength = 25;
                    var halfSlice = (maxLength - 3) / 2;
                    var s = this.value;
                    return s.length <= maxLength ? s : s.substr(0, halfSlice) + '...' + s.substr(-halfSlice);
                  }
                }
              },
              yAxis: options.yAxis,
              series: [{
                name: 'Manual tasks',
                type: 'column',
                data: series.manualTasksSerie
              }, {
                name: 'Automated tasks',
                type: 'column',
                data: series.automatedTasksSerie
              }]
            };

            if (options.tooltip) {
              chartDef.tooltip = options.tooltip;
            }

            element.highcharts(reportConfigurationService.getHighchartsOptions(chartDef));
          }
        });
      };
    }
  };
}]);

/***/ }),

/***/ 1385:
/***/ (function(module, exports) {

angular.module('xlrelease').directive('phaseDuration', ['reportConfigurationService', function (reportConfigurationService) {
  return function (scope, element) {
    var phase = scope.phase;
    var release = scope.release;
    var getDurationPercentage = scope.getDurationPercentage;
    var duration = getDurationPercentage(release, phase);
    var FOREGROUND_COLOR = '#aaa';
    var BACKGROUND_COLOR = '#fff';
    element.highcharts(reportConfigurationService.getHighchartsOptions({
      exporting: {
        enabled: false
      },
      colors: [FOREGROUND_COLOR, BACKGROUND_COLOR],
      chart: {
        spacing: [0, 0, 0, 0],
        plotBackgroundColor: null,
        plotBorderWidth: null,
        plotShadow: null,
        backgroundColor: null,
        borderWidth: 0,
        type: 'area',
        margin: [2, 0, 2, 0],
        width: 18,
        height: 18,
        style: {
          overflow: 'visible'
        },
        skipClone: true
      },
      legend: {
        enabled: false
      },
      tooltip: {
        enabled: false
      },
      plotOptions: {
        pie: {
          borderColor: FOREGROUND_COLOR,
          allowPointSelect: false,
          cursor: 'default',
          dataLabels: {
            enabled: false
          },
          size: '13.5'
        }
      },
      series: [{
        type: 'pie',
        name: '',
        data: [['Selected', duration], ['Unselected', 100 - duration]]
      }]
    }));
  };
}]);

/***/ }),

/***/ 1386:
/***/ (function(module, exports) {

angular.module('xlrelease').factory('ReleaseEfficiency', ['reportConfigurationService', function (reportConfigurationService) {
  return {
    pieChart: function pieChart(options) {
      return function link(scope, element) {
        scope.$watch('reports.releaseEfficiency.data', function (releaseEfficiency) {
          if (element.highcharts()) {
            element.highcharts().destroy();
          }

          if (releaseEfficiency) {
            element.highcharts(reportConfigurationService.getHighchartsOptions({
              colors: ['#68b749', '#a52a2a'],
              tooltip: {
                hideDelay: 0,
                formatter: options.tooltipFormatter
              },
              chart: {
                height: 225
              },
              plotOptions: {
                pie: {
                  size: 100,
                  showInLegend: true
                }
              },
              series: [{
                type: 'pie',
                data: options.data(releaseEfficiency),
                dataLabels: {
                  format: '{point.percentage:.1f} %',
                  distance: -25,
                  color: 'white'
                }
              }]
            }));
          }
        });
      };
    }
  };
}]);
angular.module('xlrelease').directive('releaseEfficiencyAutomation', ['ReleaseEfficiency', function (ReleaseEfficiency) {
  return ReleaseEfficiency.pieChart({
    data: function data(releaseEfficiency) {
      return [['Automated', releaseEfficiency.totalAutomatedTasks], ['Manual', releaseEfficiency.totalManualTasks]];
    },
    tooltipFormatter: function tooltipFormatter() {
      var tooltipContent = '<b>' + this.point.name + '</b><br>';
      tooltipContent += this.y + ' tasks';
      return tooltipContent;
    }
  });
}]);
angular.module('xlrelease').directive('releaseEfficiencyTimeSpent', ['ReleaseEfficiency', 'durationFilter', function (ReleaseEfficiency, durationFilter) {
  return ReleaseEfficiency.pieChart({
    data: function data(releaseEfficiency) {
      return [['Automated', releaseEfficiency.totalAutomatedTimeSpent], ['Manual', releaseEfficiency.totalManualTimeSpent]];
    },
    tooltipFormatter: function tooltipFormatter() {
      var tooltipContent = '<b>' + this.point.name + '</b><br>';
      tooltipContent += durationFilter(this.y);
      return tooltipContent;
    }
  });
}]);

/***/ }),

/***/ 1387:
/***/ (function(module, exports) {

angular.module('xlrelease').factory('reportConfigurationService', function () {
  var ONE_MONTH = 30 * 24 * 3600 * 1000;
  var defaultOptions = {
    title: {
      text: ''
    },
    credits: {
      enabled: false
    },
    xAxis: {
      type: 'datetime',
      labels: {
        formatter: function formatter() {
          return moment(this.value).format("D MMMM YYYY");
        }
      },
      minTickInterval: ONE_MONTH
    },
    legend: {
      borderWidth: 0,
      symbolRadius: 0
    },
    plotOptions: {
      scatter: {
        marker: {
          radius: 5,
          states: {
            hover: {
              enabled: true,
              lineColor: 'rgb(100,100,100)'
            }
          }
        },
        states: {
          hover: {
            marker: {
              enabled: false
            }
          }
        }
      },
      spline: {
        marker: {
          enabled: false
        },
        enableMouseTracking: false,
        lineWidth: 1
      },
      areaspline: {
        fillOpacity: 0.3,
        marker: {
          enabled: false
        }
      },
      column: {
        stacking: 'normal'
      }
    }
  };
  return {
    getHighchartsOptions: function getHighchartsOptions(options) {
      return angular.extend(angular.copy(defaultOptions), options);
    }
  };
});

/***/ }),

/***/ 1388:
/***/ (function(module, exports) {

angular.module('xlrelease').directive('reportContainer', [function () {
  return {
    templateUrl: 'partials/reports/report-container.html',
    transclude: true,
    scope: {
      report: '='
    }
  };
}]);

/***/ }),

/***/ 1389:
/***/ (function(module, exports) {

angular.module('xlrelease').factory('ReportsDefinition', ['ReportLoader', 'Report', 'EchartsReportsService', function (ReportLoader, Report, EchartsReportsService) {
  return {
    'release-automation': function releaseAutomation() {
      var MOST_RECENT_RELEASES_NUMBER = 20;
      this.loaders = {
        releasesDuration: new ReportLoader('reports/releases/duration'),
        releasesAutomation: new ReportLoader('reports/releases/automation'),
        mostRecentReleases: new ReportLoader('reports/releases/most-recent/' + MOST_RECENT_RELEASES_NUMBER)
      };
      this.reports = {
        releasesDuration: new Report().add('data', this.loaders.releasesDuration, function (data) {
          return data.average;
        }),
        releasesAutomation: new Report().add('data', this.loaders.releasesAutomation, function (data) {
          return data.averageAutomationPercentage;
        }),
        mostRecentReleases: new Report().add('data', this.loaders.mostRecentReleases, function (data) {
          return data.reverse();
        })
      };
    },
    'reports': function reports() {
      var TOP_REPORT_SIZE = 10;

      function sliceReport(data) {
        if (data) {
          data = data.slice(0, TOP_REPORT_SIZE);
        }

        return data;
      }

      function emptyArrayIfAllKeysAreZero(data) {
        if (_.sum(_.map(data)) !== 0) {
          return data;
        }

        return [];
      }

      this.loaders = {
        longestTaskTypes: new ReportLoader('reports/longest-task-types'),
        longestTasks: new ReportLoader('reports/longest-tasks'),
        averageAndLongestTaskDuration: new ReportLoader('reports/average-and-longest-task-duration'),
        longestPhases: new ReportLoader('reports/longest-phases'),
        numberOfReleasesPerMonth: new ReportLoader('reports/releases/number-by-month'),
        mostInvolvedPeople: new ReportLoader('reports/most-involved-people'),
        releasesDuration: new ReportLoader('reports/releases/duration'),
        releasesAutomation: new ReportLoader('reports/releases/automation'),
        completedRelease: new ReportLoader('reports/release/completed'),
        averageAndLongestReleaseDuration: new ReportLoader('reports/release/average-and-longest-release-duration')
      };
      var averageDurationAndAutomation = new Report().add('releasesDuration', this.loaders.releasesDuration, function (data) {
        return data.average;
      }).add('releasesAutomation', this.loaders.releasesAutomation, function (data) {
        return data.averageAutomationPercentage;
      });
      var releaseEfficiency = new Report().add('releasesDuration', this.loaders.releasesDuration, function (data) {
        return data.average;
      }).add('releasesAutomation', this.loaders.releasesAutomation, function (data) {
        return data.averageAutomationPercentage;
      }).add('numberOfReleasesPerMonth', this.loaders.numberOfReleasesPerMonth);
      this.reports = {
        /** Echarts Reports **/
        echartsTaskTimeSpent: new Report().add('data', this.loaders.releasesAutomation, function (data) {
          if (!!data.releaseEfficiency.totalTasks) {
            return EchartsReportsService.taskTimeSpent(data.releaseEfficiency);
          }
        }),
        echartsTaskEfficiency: new Report().add('data', this.loaders.releasesAutomation, function (data) {
          if (!!data.releaseEfficiency.totalTasks) {
            return EchartsReportsService.taskEfficiency(data.releaseEfficiency);
          }
        }),
        echartsLongestReleases: new Report().add('data', this.loaders.releasesDuration, function (data) {
          if (!!data.longestReleases.length) {
            return EchartsReportsService.longestReleases(sliceReport(data.longestReleases));
          }
        }),
        echartsLongestTasks: new Report().add('data', this.loaders.longestTasks, function (data) {
          if (!!data.length) {
            return EchartsReportsService.longestTasks(sliceReport(data));
          }
        }),
        echartsLongestPhases: new Report().add('data', this.loaders.longestPhases, function (data) {
          if (!!data.length) {
            return EchartsReportsService.longestPhases(sliceReport(data));
          }
        }),
        echartsReleaseDuration: new Report().addByReport('data', averageDurationAndAutomation, function (data) {
          if (!!(data.releasesAutomation.length && data.releasesDuration.length)) {
            return EchartsReportsService.releaseDuration(data);
          }
        }),
        echartsNumberOfReleasesPerMonth: new Report().addByReport('data', releaseEfficiency, function (data) {
          if (!!(data.releasesAutomation.length && data.releasesDuration.length)) {
            return EchartsReportsService.numberOfReleasesPerMonth(data);
          }
        }),
        echartsReleaseEfficiency: new Report().addByReport('data', averageDurationAndAutomation, function (data) {
          if (!!(data.releasesAutomation.length && data.releasesDuration.length)) {
            return EchartsReportsService.releaseEfficiency(data);
          }
        }),

        /** Common reports **/
        releaseEfficiency: new Report().add('data', this.loaders.releasesAutomation, function (data) {
          return data.releaseEfficiency;
        }),
        numberOfReleasesPerMonth: new Report().add('data', this.loaders.numberOfReleasesPerMonth),
        longestReleases: new Report().add('data', this.loaders.releasesDuration, function (data) {
          return sliceReport(data.longestReleases);
        }),
        averageDurationAndAutomation: averageDurationAndAutomation,

        /** Others **/
        longestPhases: new Report().add('data', this.loaders.longestPhases, sliceReport),
        longestTasks: new Report().add('data', this.loaders.longestTasks, sliceReport),
        longestTaskTypes: new Report().add('data', this.loaders.longestTaskTypes, sliceReport),
        mostInvolvedPeople: new Report().add('data', this.loaders.mostInvolvedPeople, sliceReport),
        averageAndLongestTaskDuration: new Report().add('data', this.loaders.averageAndLongestTaskDuration, emptyArrayIfAllKeysAreZero),
        completedRelease: new Report().add('data', this.loaders.completedRelease, emptyArrayIfAllKeysAreZero),
        averageAndLongestReleaseDuration: new Report().add('data', this.loaders.averageAndLongestReleaseDuration, emptyArrayIfAllKeysAreZero)
      };
    }
  };
}]);
angular.module('xlrelease').factory('ReportsService', ['Backend', 'Download', 'ReportsDefinition', function (Backend, Download, ReportsDefinition) {
  var filterSettings = null;
  var reports = null;
  return {
    loadReports: function loadReports(reportType) {
      var NewReport = ReportsDefinition[reportType];

      if (!NewReport) {
        /* eslint-disable no-console, angular/log */
        console.warn("Cannot construct report of '".concat(reportType, "' type"));
        return;
      }

      var reportsPage = new NewReport();
      var params = getReportsParams(filterSettings);

      _.forEach(reportsPage.loaders, function (loader) {
        loader.startLoading();
        Backend.post(loader.url, params).then(function (resp) {
          return loader.loaded(resp.data);
        }).then(loader.endLoading, loader.endLoading);
      });

      reports = reportsPage.reports;
    },
    exportReport: function exportReport(type) {
      var params = getReportsParams(filterSettings);
      params.report = type;
      params = _.pickBy(params, _.identity); // Remove empty properties

      Download.launch('export/report/?' + $.param(params));
    },
    setFilterSettings: function setFilterSettings(settings) {
      filterSettings = settings;
    },
    getFilterSettings: function getFilterSettings() {
      return filterSettings;
    },
    getReports: function getReports() {
      return reports;
    }
  };

  function getReportsParams(filterSettings) {
    var params = angular.copy(filterSettings);
    params.tags = _.isEmpty(params.tags) ? undefined : _.join(params.tags);
    return params;
  }
}]);
angular.module('xlrelease').factory('ReportLoader', function () {
  return function (url) {
    var self = this;
    var callbacks = [];
    this.loading = false;
    this.loadCallbacksCalled = false;
    this.failed = false;
    this.url = url;

    this.startLoading = function () {
      self.loading = true;
    };

    this.endLoading = function () {
      self.loading = false;
    };

    this.failLoading = function (reason) {
      self.loading = false;
      self.failed = true;
      self.reason = reason;
    };

    this.loaded = function (data) {
      this.loadCallbacksCalled = true;

      _.forEach(callbacks, function (callback) {
        callback(data);
      });
    };

    this.whenLoaded = function (callback) {
      callbacks.push(callback);
    };
  };
});
angular.module('xlrelease').factory('Report', function () {
  return function () {
    var _this = this;

    var self = this;
    var dataProperties = [];
    this.loaders = [];

    this.add = function (dataProperty, loader, transform) {
      _this[dataProperty] = [];
      dataProperties.push(dataProperty);

      _this.loaders.push(loader);

      loader.whenLoaded(function (data) {
        self[dataProperty] = transform ? transform(data) : data;
      });
      return _this;
    };

    this.addByReport = function (dataProperty, report, transform) {
      _this[dataProperty] = [];
      dataProperties.push(dataProperty);
      report.loaders.forEach(function (loader) {
        _this.loaders.push(loader);

        loader.whenLoaded(function () {
          if (!_.find(report.loaders, function (anotherLoader) {
            return anotherLoader !== loader && !anotherLoader.loadCallbacksCalled;
          })) {
            self[dataProperty] = transform ? transform(report) : data;
          }
        });
      });
      return _this;
    };

    this.loading = function () {
      var loading = false;

      _.forEach(this.loaders, function (loader) {
        loading = loading || loader.loading;
      });

      return loading;
    };

    this.isEmpty = function () {
      return !!_.find(dataProperties, function (dataProperty) {
        return !self[dataProperty] || self[dataProperty].length === 0;
      });
    };

    this.isConfigured = function () {
      return dataProperties.length > 0;
    };

    this.hasError = function () {
      return !!this.loaders.find(function (loader) {
        return loader.failed;
      });
    };

    this.errorMessage = function () {
      return this.loaders.find(function (loader) {
        return loader.failed;
      }).reason.data;
    };
  };
});

/***/ }),

/***/ 1390:
/***/ (function(module, exports) {

angular.module('xlrelease').directive('tileContainer', [function () {
  return {
    restrict: 'AE',
    templateUrl: 'partials/reports/tile-container.html',
    transclude: {
      'title': 'tileTitle',
      'content': '?tileContent',
      'footer': '?tileFooter'
    },
    scope: {
      report: '='
    }
  };
}]);

/***/ }),

/***/ 1391:
/***/ (function(module, exports) {

angular.module('xlrelease').filter('displayPermission', ['PermissionLabels', function (PermissionLabels) {
  return function (permission) {
    return PermissionLabels[permission];
  };
}]);

/***/ }),

/***/ 1392:
/***/ (function(module, exports) {

angular.module('xlrelease').controller('forbiddenAccessController', ['$scope', 'ForbiddenAccessService', function ($scope, ForbiddenAccessService) {
  $scope.errorMessage = ForbiddenAccessService.errorMessage;
}]);

/***/ }),

/***/ 1393:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').factory('ForbiddenAccessService', [function () {
  return {
    errorMessage: ''
  };
}]);

/***/ }),

/***/ 1394:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').factory('LimitedUsers', ['Backend', function (Backend) {
  var maxNumberOfUsers = null;
  var users = null;
  return {
    isEnabled: function isEnabled() {
      return maxNumberOfUsers !== null && users !== null;
    },
    maximumReached: function maximumReached() {
      return this.isEnabled() && this.countLeft() <= 0;
    },
    countLeft: function countLeft() {
      var numberOfUsersAllowed = _.filter(users, 'loginAllowed').length;

      return maxNumberOfUsers - numberOfUsersAllowed;
    },
    setUsers: function setUsers(input) {
      users = input;
    },
    loadLicense: function loadLicense() {
      Backend.get('server/license').then(function (resp) {
        return maxNumberOfUsers = resp.data.maxNumberOfUsers || null;
      });
    }
  };
}]);

/***/ }),

/***/ 1395:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').factory('RolesService', ['Backend', 'MemberType', function (Backend, MemberType) {
  var _this = this;

  this.mapRolesToObject = function (rolesList) {
    return rolesList.map(function (o) {
      return {
        name: o,
        type: MemberType.ROLE
      };
    });
  };

  return {
    getRolePrincipalsList: function getRolePrincipalsList() {
      return Backend.get('roles/principals');
    },
    getRoleNames: function getRoleNames() {
      return Backend.get('roles/names');
    },
    getRoles: function getRoles() {
      return Backend.get('roles/names').then(function (values) {
        return values.data;
      }).then(_this.mapRolesToObject);
    }
  };
}]);

/***/ }),

/***/ 1396:
/***/ (function(module, exports) {

angular.module('xlrelease').controller('UsersController', ['$scope', 'Backend', 'Alerts', 'UsersService', 'LimitedUsers', 'Authenticator', function ($scope, Backend, Alerts, UsersService, LimitedUsers, Authenticator) {
  var self = this;

  function loadUsers() {
    Backend.get('users').then(function (resp) {
      self.all = resp.data;
      sanitizeUsersWithNullValues(self.all);
      LimitedUsers.setUsers(self.all);
    });
  }

  loadUsers();
  LimitedUsers.loadLicense();

  self.editNewUser = function () {
    self.newUser = true;
    self.editedUser = {
      username: '',
      email: '',
      fullName: '',
      external: false,
      previousPassword: '',
      password: '',
      passwordConfirmation: ''
    };
    self.passwordStatus = {};
  };

  self.editUser = function (user) {
    self.newUser = false;
    self.editedUser = {
      username: user.username,
      email: user.email,
      fullName: user.fullName,
      external: user.external,
      previousPassword: '',
      password: '',
      passwordConfirmation: '',
      loginAllowed: user.loginAllowed
    };
    self.passwordStatus = {};
  };

  self.saveUser = function (dismiss) {
    self.newUser ? createUser(dismiss) : updateUser(dismiss);
  };

  self.isUsernameValid = function () {
    return !self.newUser || self.editedUser && self.editedUser.username && /^(?![\.\-_])(?!.*[\.\-_]{2})[\w\.\-_]*[^\W_]$/.test(self.editedUser.username) //user can not enter UNICODE characters :-/ (JS simply doesn't support it)
    ;
  };

  self.isPasswordConfirmationRequired = function () {
    return Authenticator.getUsername() === self.editedUser.username && !self.newUser;
  };

  self.isFormValid = function () {
    var isPreviousPasswordValid = self.isPasswordConfirmationRequired() && self.editedUser.password !== '' ? self.editedUser.previousPassword !== '' : true;
    return self.editedUser.password === self.editedUser.passwordConfirmation && isPreviousPasswordValid && self.isUsernameValid() && self.passwordStatus && self.passwordStatus.status !== 'invalid';
  };

  function createUser(dismiss) {
    self.conflict = false;
    var userForm = {
      username: self.editedUser.username,
      email: self.editedUser.email,
      fullName: self.editedUser.fullName,
      password: self.editedUser.password,
      loginAllowed: true
    };
    Backend.post('users', userForm, {
      hideAlert: true
    }).then(function () {
      loadUsers();
      dismiss();
    }, function (response) {
      var data = response.data,
          status = response.status,
          headers = response.headers,
          config = response.config;

      if (status === 409) {
        self.conflict = true;
      } else {
        Alerts.error({
          data: data,
          status: status,
          headers: headers,
          config: config
        });
      }
    });
  }

  function updateUser(dismiss) {
    var userForm = {
      username: self.editedUser.username,
      email: self.editedUser.email,
      fullName: self.editedUser.fullName,
      loginAllowed: self.editedUser.loginAllowed
    };

    if (self.editedUser.password) {
      userForm.previousPassword = self.editedUser.previousPassword;
      userForm.password = self.editedUser.password;
    }

    Backend.put('users', userForm).then(function () {
      loadUsers();
      dismiss();
      delete self.editedUser.previousPassword;
      delete self.editedUser.password;
    });
  }

  function sanitizeUsersWithNullValues(users) {
    users.map(function (user) {
      if (!user.lastActive) user.lastActive = 0;
      if (!user.fullName) user.fullName = '';
      if (!user.email) user.email = '';
      return user;
    });
  }

  $scope.isInternalUser = UsersService.isInternalUser;
  $scope.isUserNameAdmin = UsersService.isUserNameAdmin;
  $scope.sortColumn = null;
  $scope.sortDirection = null;
  $scope.customValidations = {
    password: []
  };

  $scope.toggleSortStyle = function () {
    return {
      'xl-icon sort-asc-icon icon-s': !$scope.sortDirection,
      'xl-icon sort-desc-icon icon-s': $scope.sortDirection
    };
  };

  $scope.sortBy = function (column) {
    $scope.sortDirection = $scope.sortColumn === column ? !$scope.sortDirection : true;
    $scope.sortColumn = column;
  };

  $scope.deleteUser = function (user) {
    Backend.del('users', {
      data: {
        username: user.username
      }
    }).then(loadUsers);
  };

  $scope.LimitedUsers = LimitedUsers;

  self.toggleLoginPermission = function (user) {
    Backend.put('users', user);
  };
}]);

/***/ }),

/***/ 1397:
/***/ (function(module, exports) {

angular.module('xlrelease').directive('assignee', ['UserProfile', function (UserProfile) {
  return {
    templateUrl: "partials/tasks/assignee.html",
    scope: {
      owner: '=',
      team: '=',
      variables: '=',
      users: '<'
    },
    link: function link(scope) {
      scope.loggedUser = UserProfile.getCurrentUser();
    }
  };
}]);

/***/ }),

/***/ 1415:
/***/ (function(module, exports) {

angular.module('xlrelease').directive('displayWithSeparators', function () {
  var DEFAULT_SEPARATOR = ' | ';
  var SEPARATOR_CLASS = 'separator';
  var separatorElement;

  function removeSeparators(element) {
    element.find('.' + SEPARATOR_CLASS).each(function (index, element) {
      angular.element(element).remove();
    });
  }

  function addSeparatorToVisibles(displayables) {
    var visibles = getVisibles(displayables);

    for (var i = 0; i < visibles.length - 1; i++) {
      addSeparator(angular.element(visibles[i].element));
    }
  }

  function getVisibles(displayables) {
    return _.filter(displayables, function (displayable) {
      return !!displayable.visible;
    });
  }

  function addSeparator(element) {
    element.after(separatorElement);
  }

  return {
    link: function link(scope, element, attrs) {
      separatorElement = '<span class="' + SEPARATOR_CLASS + '">' + (attrs.displayWithSeparators || DEFAULT_SEPARATOR) + '</span>';
    },
    controller: ['$scope', '$element', function (scope, element) {
      var displayables = [];

      this.register = function (displayable) {
        displayables.push(displayable);
      };

      this.refresh = function () {
        removeSeparators(element);
        addSeparatorToVisibles(displayables);
      };
    }]
  };
});
angular.module('xlrelease').directive('displayWhen', function () {
  return {
    require: '^displayWithSeparators',
    link: function link(scope, element, attrs, displayWithSeparator) {
      var displayable = {
        element: element,
        visible: true
      };
      displayWithSeparator.register(displayable);
      scope.$watch(attrs.displayWhen, function (isVisible) {
        isVisible ? element.show() : element.hide();
        displayable.visible = isVisible;
        displayWithSeparator.refresh();
      });
    }
  };
});

/***/ }),

/***/ 1416:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


GateDetailsController.$inject = ['$scope', '$state', '$q', 'Backend', 'Ids', 'GateService', 'TasksService', 'DependenciesService', 'Planner', 'ViewStorage'];

function GateDetailsController($scope, $state, $q, Backend, Ids, GateService, TasksService, DependenciesService, Planner, ViewStorage) {
  var CONDITIONS_URL = 'gates/conditions/';

  var getEmptyDependency = function getEmptyDependency() {
    return {
      variableOrTarget: {
        value: {}
      }
    };
  };

  GateService.clearDependencyTargetCache();
  load();
  var gateDependenciesTargetStatuses = {};
  $scope.isLoaded = false;
  $scope.dependencyWasChanged = false;
  $scope.$on("$destroy", function () {
    $scope.cancelDependencyEditing();
    GateService.clearDependencyTargetCache();
  });

  $scope.onDependencyChange = function () {
    $scope.dependencyWasChanged = true;
  };

  $scope.addCondition = function () {
    Backend.post('gates/' + $scope.task.id + '/conditions').then(function (resp) {
      return $scope.task.conditions.push(resp.data);
    });
  };

  $scope.updateCondition = function (condition) {
    Backend.put(CONDITIONS_URL + condition.id, condition).then(function () {
      if (!TasksService.isGateClosed($scope.task)) {
        $scope.completeTaskMode = true;
      }
    });
  };

  $scope.removeCondition = function (removedCondition) {
    Backend.del(CONDITIONS_URL + removedCondition.id).then(function () {
      $scope.task.conditions = _.reject($scope.task.conditions, function (condition) {
        return removedCondition === condition;
      });
    });
  };

  $scope.addDependency = function () {
    var emptyDependency = getEmptyDependency();
    $scope.task.dependencies.push(emptyDependency);
    $scope.editDependency(emptyDependency);
  };

  function shouldLoadDependencyStatuses() {
    return (TasksService.isTaskInProgress($scope.task) || TasksService.isTaskFailed($scope.task)) && $scope.task.dependencies.length > 0;
  }

  $scope.hasDependencyStatuses = function () {
    return shouldLoadDependencyStatuses() && $scope.isLoaded;
  };

  function load() {
    $scope.isLoaded = false;
    $q.all([loadDependenciesIfNecessary(), loadDependenciesTargetStatuses()]).then(function () {
      $scope.isLoaded = true;
    });
  }

  function loadDependenciesIfNecessary() {
    var deferred = $q.defer(); // hope this goes away as we try to always load dependencies only on demand

    if ($scope.isPartialLoad) {
      GateService.getDependencies($scope.task.id).then(function (dependencies) {
        $scope.task.dependencies = dependencies;
        deferred.resolve(true);
      });
    } else {
      deferred.resolve(true);
    }

    return deferred.promise;
  }

  function loadDependenciesTargetStatuses() {
    var deferred = $q.defer();

    if (shouldLoadDependencyStatuses()) {
      GateService.getDependenciesTargetStatuses($scope.task.id).then(function (data) {
        gateDependenciesTargetStatuses = data.reduce(function (acc, val) {
          acc[Ids.toInternalId(val.id)] = val.status;
          return acc;
        }, {});
      }).finally(function () {
        return deferred.resolve(true);
      });
    } else {
      deferred.resolve(true);
    }

    return deferred.promise;
  }

  $scope.saveDependency = function () {
    var hasVariableOrTarget = $scope.draftDependency.variableOrTarget.variable || _.get($scope.draftDependency.variableOrTarget, ['value', 'releaseId']);

    if (!$scope.editedDependency || !hasVariableOrTarget) {
      return;
    }

    function updateDependencyInList(updatedDependency) {
      var index = _.indexOf($scope.task.dependencies, $scope.editedDependency);

      if (index >= 0) {
        $scope.task.dependencies[index] = updatedDependency;
      }

      delete $scope.editedDependency;
      delete $scope.draftDependency;
      DependenciesService.clearCache();
      DependenciesService.getReleaseTree($scope.release).then(function (releaseTree) {
        Planner.setReleaseTree(releaseTree);
        $scope.planning.savePlanningData($scope.task);
      });
    }

    var promise;

    if ($scope.draftDependency.variableOrTarget.variable) {
      delete $scope.draftDependency.variableOrTarget.value;
    }

    if ($scope.editedDependency.id) {
      promise = Backend.put('dependencies/' + $scope.editedDependency.id, $scope.draftDependency);
    } else {
      promise = Backend.post('gates/' + $scope.task.id + '/dependencies', $scope.draftDependency);
    }

    promise.then(function (resp) {
      updateDependencyInList(resp.data);
      loadDependenciesTargetStatuses();
    });
  };

  $scope.editDependency = function (dependency) {
    $scope.editedDependency = dependency;
    $scope.draftDependency = _.defaultsDeep(getEmptyDependency(), dependency);
    $scope.dependencyWasChanged = false;
  };

  $scope.isEditingDependency = function (dependency) {
    return $scope.editedDependency === dependency;
  };

  $scope.cancelDependencyEditing = function () {
    if (!$scope.editedDependency || !$scope.editedDependency.id) {
      $scope.task.dependencies = _.without($scope.task.dependencies, $scope.editedDependency);
    }

    delete $scope.editedDependency;
    delete $scope.draftDependency;
    $scope.dependencyWasChanged = false;
  };

  $scope.getDependencyStatus = function (dependency) {
    var statuses = [];
    var targetId = Ids.toInternalId(dependency.variableOrTarget.variable || dependency.variableOrTarget.value && dependency.variableOrTarget.value.id);
    if (targetId in gateDependenciesTargetStatuses) statuses.push(gateDependenciesTargetStatuses[targetId]);

    if (dependency.archived) {
      statuses.push('archived');
    }

    return _.isEmpty(statuses) ? ['not_found'] : statuses;
  };

  function dependencyIsEditable(dependency) {
    return !dependency.resolved && (dependency.archived || dependency.variableOrTarget.variable || dependency.variableOrTarget.value);
  }

  $scope.canEditDependency = function (dependency) {
    return $scope.canEditGateTaskConfigurationPropertiesAndIsUnlocked() && dependencyIsEditable(dependency);
  };

  $scope.canDeleteDependency = function (dependency) {
    return $scope.canEditAndIsUnlocked() && (dependencyIsEditable(dependency) || TasksService.isTaskPlanned($scope.task));
  };

  $scope.isEmptyDependency = function (dependency) {
    return !dependency.variableOrTarget.variable && !dependency.variableOrTarget.value;
  };

  $scope.removeDependency = function (removedDependency) {
    Backend.del('dependencies/' + removedDependency.id).then(function () {
      $scope.task.dependencies = _.reject($scope.task.dependencies, function (dependency) {
        return removedDependency === dependency;
      });
      $scope.planning.savePlanningData($scope.task);
    });
  };

  $scope.showConditions = function () {
    return $scope.task.conditions.length > 0;
  };

  $scope.showAddCondition = function () {
    return $scope.canEditTaskConfigurationPropertiesAndIsUnlocked();
  };

  $scope.showDependencies = function () {
    return $scope.task.dependencies.length > 0;
  };

  $scope.showAddDependency = function () {
    return $scope.canEditGateTaskConfigurationPropertiesAndIsUnlocked() && !$scope.isDependencyEditInProgress();
  };

  $scope.isDependencyEditInProgress = function () {
    return _.find($scope.task.dependencies, function (d) {
      return $scope.isEditingDependency(d);
    });
  };

  $scope.isTaskInProgress = TasksService.isTaskInProgress;
  $scope.isTaskQueued = TasksService.isTaskQueued;

  var getReleaseUrl = function getReleaseUrl(releaseId) {
    var internalId = Ids.toInternalId(releaseId);
    return "#".concat(ViewStorage.getView(internalId, "/releases/".concat(internalId)));
  };

  var getPhaseUrl = function getPhaseUrl(releaseId, phaseId) {
    var internalId = Ids.toInternalId(phaseId);
    return "".concat(getReleaseUrl(releaseId), "?scrollToPhase=").concat(internalId);
  };

  var getTaskUrl = function getTaskUrl(releaseId, phaseTaskId) {
    var internalId = Ids.toInternalId(phaseTaskId);
    return "".concat(getReleaseUrl(releaseId), "?openTaskDetailsModal=").concat(internalId);
  };

  $scope.goToRelease = function (dependency) {
    if (!$scope.isEditingDependency(dependency)) {
      var releaseId = Ids.releaseIdFrom(dependency.variableOrTarget.value.id);
      var taskId = Ids.taskIdFrom(dependency.variableOrTarget.value.id);
      var phaseId = Ids.phaseIdFrom(dependency.variableOrTarget.value.id);
      var phaseTaskId = Ids.phaseTaskIdFrom(dependency.variableOrTarget.value.id);

      if (taskId !== null) {
        return getTaskUrl(releaseId, phaseTaskId);
      } else if (phaseId !== null) {
        return getPhaseUrl(releaseId, phaseId);
      } else {
        return getReleaseUrl(releaseId);
      }
    }
  };

  $scope.getDependencyTitle = function (dependencyValue) {
    var title = dependencyValue.releaseTitle;

    if (dependencyValue.phaseId) {
      title += " / ".concat(dependencyValue.phaseTitle);
    }

    if (dependencyValue.taskId) {
      title += " / ".concat(dependencyValue.taskTitle);
    }

    return title;
  };
}

angular.module('xlrelease').controller('gateDetailsController', GateDetailsController);

/***/ }),

/***/ 1417:
/***/ (function(module, exports) {

angular.module('xlrelease').directive('scheduledStartDateTooltip', ['tooltipService', 'dateFilter', function (tooltipService, dateFilter) {
  return {
    restrict: 'A',
    link: function link(scope, element, attrs) {
      scope.$watch(attrs.scheduledStartDateTooltip, function (date) {
        var text = date ? "Task will start on ".concat(dateFilter(date, 'mediumDate'), " ").concat(dateFilter(date, 'shortTime')) : 'Task will start shortly';
        tooltipService.setup(element, text, 'top');
      }, true);
    }
  };
}]);

/***/ }),

/***/ 1418:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').controller('TaskController', ['$scope', 'Backend', 'Events', '$stateParams', function ($scope, Backend, Events, $stateParams) {
  var ctrl = $scope;
  var taskId = $stateParams.taskId;

  if ($stateParams.showDetails === "true") {
    $scope.showTaskDetailsModal = true;
  }

  function loadTask() {
    $scope.$emit(Events.permission.refresh);
    Backend.get('tasks/' + taskId).then(function (resp) {
      var taskFullView = resp.data;
      Backend.get('tasks/' + taskId + '/release').then(function (result) {
        $scope.task = taskFullView;
        $scope.tasks = [taskFullView];
        $scope.release = result.data;
      });
    });
  }

  loadTask();

  $scope.onTaskChange = function () {
    loadTask();
  };

  $scope.onTaskDetailsClosed = function () {
    $scope.showTaskDetailsModal = false;
  };
}]);

/***/ }),

/***/ 1419:
/***/ (function(module, exports) {

angular.module('xlrelease').factory('TaskDefinitionsService', ['Backend', function (Backend) {
  'use strict';

  return {
    getTaskDefinitions: function getTaskDefinitions() {
      return Backend.get('tasks/task-definitions');
    },
    groupTaskDefinitions: function groupTaskDefinitions(taskDefinitions) {
      if (!taskDefinitions) return;
      return {
        groups: _.groupBy(taskDefinitions, 'displayGroup'),
        defaultValue: _.find(taskDefinitions, {
          isAllowed: true
        })
      };
    }
  };
}]);

/***/ }),

/***/ 1420:
/***/ (function(module, exports) {

angular.module('xlrelease').factory('TaskDetailsUpdates', [function () {
  return {
    assigneeChanged: false,
    planningDataChanged: false,
    tagsChanged: false,
    reset: function reset() {
      this.assigneeChanged = false;
      this.planningDataChanged = false;
      this.tagsChanged = false;
    }
  };
}]);

/***/ }),

/***/ 1421:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').controller('taskListController', ['$scope', 'TasksService', 'ReleasesService', 'FlagService', 'DateService', 'Authenticator', 'CalendarService', function ($scope, TasksService, ReleasesService, FlagService, DateService, Authenticator, CalendarService) {
  $scope.ctrl = $scope;
  $scope.security = Authenticator;
  $scope.isTaskPending = TasksService.isTaskPending;
  $scope.isTaskInProgress = TasksService.isTaskInProgress;
  $scope.isTaskQueued = TasksService.isTaskQueued;
  $scope.isTaskFacetInProgress = TasksService.isTaskFacetInProgress;
  $scope.isTaskPreconditionInProgress = TasksService.isTaskPreconditionInProgress;
  $scope.isTaskOrPreconditionInProgress = TasksService.isTaskOrPreconditionInProgress;
  $scope.isTaskPlanned = TasksService.isTaskPlanned;
  $scope.isTaskSkipped = TasksService.isTaskSkipped;
  $scope.isTaskFailed = TasksService.isTaskFailed;
  $scope.isTaskFailing = TasksService.isTaskFailing;
  $scope.isTaskCompleted = TasksService.isTaskCompleted;
  $scope.isTaskCompletedInAdvance = TasksService.isTaskCompletedInAdvance;
  $scope.isTaskSkippedInAdvance = TasksService.isTaskSkippedInAdvance;
  $scope.isUserInputTask = TasksService.isUserInputTask;
  $scope.isGateTask = TasksService.isGateTask;
  $scope.isNotificationTask = TasksService.isNotificationTask;
  $scope.isManualTask = TasksService.isManualTask;
  $scope.isScriptTask = TasksService.isScriptTask;
  $scope.isCustomScriptTask = TasksService.isCustomScriptTask;
  $scope.isStatusUpdatable = TasksService.isStatusUpdatable;
  $scope.isTaskDelayedDuringBlackout = TasksService.isTaskDelayedDuringBlackout;
  $scope.hasOwner = TasksService.hasOwner;
  $scope.isTaskFlagged = FlagService.isTaskFlagged;
  $scope.isOverdue = DateService.isOverdue;
  $scope.isTaskWaitingForInput = TasksService.isTaskWaitingForInput;
  $scope.isLocked = TasksService.isLocked;
  CalendarService.withinBlackout().then(function (resp) {
    $scope.withinBlackout = resp.data;
  });

  $scope.completeTask = function (task, commentText) {
    TasksService.completeTask(task.id, commentText).then($scope.onTaskChange);
  };

  $scope.skipTask = function (task, commentText) {
    TasksService.skipTask(task.id, commentText).then($scope.onTaskChange);
  };

  $scope.failTask = function (task, commentText) {
    TasksService.failTask(task.id, commentText).then($scope.onTaskChange);
  };

  $scope.abortTask = function (task, commentText) {
    TasksService.abortTask(task.id, commentText).then($scope.onTaskChange);
  };

  $scope.cancelTask = function (task, commentText) {
    TasksService.cancelTask(task.id, commentText).then($scope.onTaskChange);
  };

  $scope.retryTask = function (task, commentText) {
    TasksService.retryTask(task.id, commentText).then($scope.onTaskChange);
  };

  $scope.startNow = function (task, commentText) {
    TasksService.startNow(task.id, commentText).then($scope.onTaskChange);
  };

  $scope.startTaskWithInput = function (task, variables) {
    TasksService.startTaskWithInput(task.id, variables).then($scope.onTaskChange);
  };

  $scope.showCompleteTaskLink = function (task, release) {
    return TasksService.canCompleteTask(release, task);
  };

  $scope.canSkipTask = function (task, release) {
    return TasksService.canSkipTask(release, task);
  };
}]);

/***/ }),

/***/ 1422:
/***/ (function(module, exports) {

angular.module('xlrelease').factory('TaskPolling', ['Timeout', '$q', 'Backend', 'TasksService', 'Events', 'Alerts', 'PollingSettings', 'ReleasesService', function (Timeout, $q, Backend, TasksService, Events, Alerts, PollingSettings, ReleasesService) {
  var UNAUTHORIZED = 401;
  var currentRequest = null;
  PollingSettings.refresh();
  return {
    startTaskPolling: startTaskPolling,
    waitForPollRequest: waitForPollRequest
  };

  function startTaskPolling(tasks, scope) {
    scope.$broadcast(Events.polling.stop);
    var pollingContext = {
      taskUpdateDeferred: $q.defer(),
      timeoutPromise: null,
      cancelled: false
    };

    if (!scope.$$destroyed) {
      var pollableTasks = getPollableTasks(tasks);
      registerTimeoutCancellation(scope, pollingContext);
      poll(pollableTasks, pollingContext, scope);
    }

    return pollingContext.taskUpdateDeferred.promise;
  }

  function getPollableTasks(tasks) {
    return _.filter(tasks, function (task) {
      return isTaskPollable(task);
    });
  }

  function isTaskPollable(task) {
    return TasksService.isTaskInProgress(task) || TasksService.isTaskQueued(task) || TasksService.isTaskFailed(task) || TasksService.isTaskWaitingForInput(task) || TasksService.isTaskPending(task) || TasksService.isTaskPreconditionInProgress(task) || TasksService.isTaskFailureHandlerInProgress(task) || TasksService.isTaskAbortScriptInProgress(task) || TasksService.isTaskFacetInProgress(task);
  }

  function registerTimeoutCancellation(scope, pollingContext) {
    var cancelHandler = function cancelHandler() {
      return cancel(pollingContext);
    };

    scope.$on('$destroy', cancelHandler);
    scope.$on(Events.polling.stop, cancelHandler);
  }

  function cancel(pollingContext) {
    Timeout.cancel(pollingContext.timeoutPromise);
    pollingContext.cancelled = true;
  }

  function poll(tasks, pollingContext, scope) {
    if (pollingContext.cancelled) {
      return;
    }

    var onSuccess = function onSuccess(response) {
      if (pollingContext.cancelled) {
        return;
      }

      var serverTasks = response.data;
      updateTaskInfosFromServer(tasks, serverTasks);

      if (isAnyServerTaskUpdated(tasks, serverTasks)) {
        pollingContext.taskUpdateDeferred.resolve(serverTasks);
      } else {
        poll(tasks, pollingContext, scope);
      }
    };

    var onError = function onError(response) {
      if (response.status !== UNAUTHORIZED) {
        Alerts.error(response);
      }
    };

    if (tasks.length !== 0) {
      pollingContext.timeoutPromise = Timeout(function pollTaskStatus() {
        currentRequest = Backend.post('tasks/poll', {
          ids: _.map(tasks, 'id')
        }, {
          hideAlertOnCodes: [403, 404],
          dontRedirectWhenForbidden: true
        }).then(onSuccess).catch(onError).finally(function () {
          return currentRequest = null;
        });
      }, PollingSettings.getStatusInterval());
    } else {
      // if release is paused then check release status again
      if (ReleasesService.isReleasePaused(scope.release)) {
        var onSuccessRelease = function onSuccessRelease(response) {
          if (pollingContext.cancelled) {
            return;
          }

          registerTimeoutCancellation(scope, pollingContext); // load release only if release is not paused from backend

          if (!ReleasesService.isReleasePaused(response.data)) {
            scope.loadRelease();
          } else {
            //keep polling
            var pollableTasks = getPollableTasks(ReleasesService.getAllTasks(response.data));
            poll(pollableTasks, pollingContext, scope);
          }
        };

        pollingContext.timeoutPromise = Timeout(function getRelease() {
          currentRequest = Backend.get('releases/' + scope.release.id).then(onSuccessRelease).catch(onError).finally(function () {
            return currentRequest = null;
          });
        }, PollingSettings.getStatusInterval());
      }
    }
  }

  function updateTaskInfosFromServer(tasks, serverTasks) {
    _.forEach(tasks, function (task) {
      if (TasksService.isCustomScriptTask(task)) {
        var serverTask = getAssociatedTask(task, serverTasks);
        task.statusLine = serverTask.statusLine;
      }
    });
  }

  function getAssociatedTask(task, serverTasks) {
    return _.find(serverTasks, {
      id: task.id
    });
  }

  function isAnyServerTaskUpdated(tasks, serverTasks) {
    return _.some(tasks, function (task) {
      var serverTask = getAssociatedTask(task, serverTasks);
      return task.status !== serverTask.status;
    });
  }

  function waitForPollRequest() {
    var deferred = $q.defer();

    if (currentRequest !== null) {
      currentRequest.finally(deferred.resolve);
    } else {
      deferred.resolve();
    }

    return deferred.promise;
  }
}]);
angular.module('xlrelease').factory('PollingSettings', ['Backend', function (Backend) {
  var statusInterval = 1000;
  var listInterval = 30000;
  return {
    getStatusInterval: function getStatusInterval() {
      return statusInterval;
    },
    getListInterval: function getListInterval() {
      return listInterval;
    },
    refresh: function refresh() {
      return Backend.get('settings/polling-interval').then(function (resp) {
        statusInterval = resp.data.taskStatusInterval * 1000;
        listInterval = resp.data.taskListInterval * 1000;
      });
    }
  };
}]);

/***/ }),

/***/ 1423:
/***/ (function(module, exports) {

angular.module('xlrelease').filter('taskStatusCssClass', ['lowercaseFilter', function (lowercaseFilter) {
  return function (taskStatus) {
    return 'task-status-' + lowercaseFilter(taskStatus);
  };
}]);

/***/ }),

/***/ 1424:
/***/ (function(module, exports) {

angular.module('xlrelease').filter('taskTypeCssClass', ['lowercaseFilter', function (lowercaseFilter) {
  return function (taskType) {
    // Remove default prefix if any
    taskType = taskType.replace(/^xlrelease\./, ''); // Replace any '.' with '-'

    taskType = taskType.replace(/\./g, '-'); // Make everything lowercase

    taskType = lowercaseFilter(taskType);
    return 'task-type-' + taskType;
  };
}]);

/***/ }),

/***/ 1425:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').controller('userInputDetailsController', ['$scope', '$q', 'Authenticator', 'VariablesService', 'TasksService', function ($scope, $q, Authenticator, VariablesService, TasksService) {
  $scope.editVariableList = editVariableList;
  $scope.saveVariableList = saveVariableList;
  $scope.variableListHandler = {
    addCandidates: variablesAutocomplete
  };
  $scope.canEditVariableList = canEditTaskConfigurationProperties;
  $scope.canEditTaskConfigurationProperties = canEditTaskConfigurationProperties;
  $scope.canEditVariables = canEditVariables();
  $scope.updateReleaseVariable = updateReleaseVariable;
  $scope.variableList = [];
  $scope.task.updatingVariablesCount = 0;
  load(); ///

  function load() {
    loadAvailableVariables($scope.release);
    $scope.$watch('userInputForm.$valid', function (validity) {
      $scope.$emit('formValidityChanged', validity);
    });
  }

  function loadAvailableVariables(release) {
    if (canEditTaskConfigurationProperties()) {
      VariablesService.getReleaseVariables(release.id).then(function (resp) {
        var variables = resp.data;
        $scope.availableVariables = fillDisplayNames(variables);

        if ($scope.task.variables) {
          updateTaskVariables(variables);
        }
      });
    }
  }

  function updateTaskVariables(variables) {
    $scope.task.variables = VariablesService.sortVariables(variables, task.variables);
  }

  function canEditTaskConfigurationProperties() {
    return !TasksService.isTaskInProgress($scope.task) && !TasksService.isTaskReadOnly($scope.task) && TasksService.canEditTaskConfigurationProperties($scope.release, $scope.task) && !TasksService.isTaskWaitingForInput($scope.task) && !TasksService.isLocked($scope.task);
  }

  function canEditVariables() {
    return (TasksService.canWorkOnTask($scope.release, $scope.task) || TasksService.canEditTaskConfigurationProperties($scope.release, $scope.task)) && !TasksService.isTaskWaitingForInput($scope.task);
  }

  function editVariableList() {
    loadAvailableVariables($scope.release); // update $scope.variableList without changing its reference: due to behavior of xl-dip-collection-of-ci

    $scope.variableList.length = 0;
    Array.prototype.push.apply($scope.variableList, fillDisplayNames($scope.task.variables));
  }

  function saveVariableList() {
    $scope.task.variables = _.clone($scope.variableList);
    $scope.saveTask($scope.task);
  }

  function variablesAutocomplete(metadata, options) {
    var deferred = $q.defer();

    var candidates = _($scope.availableVariables).reject(function (releaseVar) {
      if (VariablesService.isExternalPasswordVariable(releaseVar)) {
        return releaseVar;
      }
    }).reject(function (releaseVar) {
      return _.find($scope.variableList, {
        key: releaseVar.key
      });
    }).filter(function (variable) {
      return variable.displayName.includes(options.term);
    }).value();

    deferred.resolve(candidates);
    return deferred.promise;
  }

  function updateReleaseVariable(variable) {
    $scope.task.updatingVariablesCount++;
    VariablesService.updateReleaseVariable(variable).then(function (resp) {
      var updatedVariable = resp.data;

      var taskVariable = _.find($scope.task.variables, {
        id: updatedVariable.id
      });

      if (taskVariable) {
        _.assignIn(taskVariable, updatedVariable);
      }
    }).finally(function () {
      return $scope.task.updatingVariablesCount--;
    });
  }

  function fillDisplayNames(variables) {
    return _.map(variables, function (variable) {
      variable.displayName = VariablesService.getLongDisplayName(variable);
      return variable;
    });
  }
}]);

/***/ }),

/***/ 1426:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').controller('TemplatesController', ['$scope', 'Events', 'Backend', '$location', 'filters', 'ClientSettings', 'CisLoader', 'ViewStorage', 'TemplatesService', 'TagsService', function ($scope, Events, Backend, $location, filters, ClientSettings, CisLoader, ViewStorage, TemplatesService, TagsService) {
  $scope.filters = filters;
  $scope.allTags = [];

  $scope.filtersChanged = function (filters) {
    $scope.loadTemplates();
    ClientSettings.setTemplatesListFilters(filters);
  };

  function loadTemplates() {
    $scope.templates = null;
    $scope.templatesLoader = new CisLoader({
      filters: $scope.filters,
      searchCis: function searchCis(filters, config) {
        return TemplatesService.search(filters, config);
      },
      updateView: function updateView(templates) {
        $scope.templates = templates;
      }
    });
    $scope.templatesLoader.loadNextCis();
  }

  loadTemplates();
  $scope.loadTemplates = loadTemplates;

  $scope.initTemplateForm = function (template) {
    $scope.templateForm = {
      templateId: template.id,
      title: template.title,
      description: template.description,
      scheduledStartDate: template.scheduledStartDate
    };
  };

  TagsService.getReleaseTags().then(function (tags) {
    $scope.allTags = tags;
  });
  $scope.$on(Events.upload.success, loadTemplates);
  window.addEventListener("resize", function () {
    loadTemplates();
  }, false);
}]);

/***/ }),

/***/ 1427:
/***/ (function(module, exports) {

angular.module('xlrelease').controller('UploadController', ['$scope', 'UploadService', function ($scope, UploadService) {
  UploadService.reset();
  $scope.UploadService = UploadService;

  $scope.setFolderId = function (folderId) {
    $scope.folderId = folderId;
  };
}]);

/***/ }),

/***/ 1428:
/***/ (function(module, exports) {

/**
 * @description
 * Directive to handle file uploads.
 * Must be used on a parent container of a file-input field.

 * Provides an upload() method in the scope to trigger the upload.
 *
 * @example
 * <div upload upload-type="templates">
 *     <input type="file/>
 *     <a ng-click="upload()">
 * </div>
 */
angular.module('xlrelease').directive('upload', ['UploadService', 'Events', '$parse', function (UploadService, Events, $parse) {
  return {
    link: function link(scope, element, attrs) {
      var dataSubmitter = null;
      var uploadUrl;
      scope.$watch(attrs.uploadUrl, function (newValue) {
        uploadUrl = newValue;
      });
      var clientCallback = attrs.onSuccess;
      var auto = ('auto' in attrs);
      angular.element(element).fileupload({
        // file input should not be replaced in UI when auto-mode is not set.
        replaceFileInput: auto,
        add: function add(e, data) {
          dataSubmitter = data;

          if (auto) {
            upload();
          }
        },
        progressall: function progressall() {
          scope.$apply(UploadService.uploadProgressed);
        },
        fail: onFailure,
        done: onSuccess
      });

      var upload = function upload() {
        // Setting the upload url
        angular.element(element).fileupload('option', 'url', uploadUrl);
        dataSubmitter.submit();
      };

      if (!auto) {
        scope.upload = upload;
      }

      function onFailure(e, data) {
        scope.$apply(function () {
          scope.$emit(Events.upload.failure);
          UploadService.uploadFailed(data.jqXHR.responseText);
        });
      }

      function onSuccess(e, data) {
        // On IE9 since it's based on an iframe, fail() is not called, we have to check if data.result is defined.
        if (_.isUndefined(data.result)) {
          onFailure(e, data);
          return;
        }

        var result;

        try {
          // On IE9 since it's based on an iframe, the result is an html node.
          var resultText;

          if (_.includes(data.dataType, 'iframe')) {
            resultText = angular.element(data.result).text();
          } else {
            resultText = data.result;
          }

          result = angular.fromJson(resultText);
        } catch (parseError) {
          // On IE9 since it's based on an iframe, in case of a server side error
          // the result can't be parsed.
          onFailure(e, data);
          return;
        }

        scope.$apply(function () {
          scope.$emit(Events.upload.success, result);
          UploadService.uploadSuccess(result);
          $parse(clientCallback)(scope, {
            uploadResult: result
          });
        });
      }
    }
  };
}]);
/**
 * @description
 * Directive to handle form validation on input type=file, must be used with a ng-model.
 *
 * @example
 * <input type="file" file-input ng-model="file"/>
 */

angular.module('xlrelease').directive('fileInput', [function () {
  return {
    require: 'ngModel',
    link: function link(scope, element, attr, ngModel) {
      element.bind('change', function () {
        scope.$apply(function () {
          var fileList = element[0].files;
          var file = '';

          if (fileList.length > 0) {
            file = fileList[fileList.length - 1].name;
          }

          ngModel.$setValidity(attr.ngModel, true);
          ngModel.$setViewValue(file);
        });
      });
    }
  };
}]);

/***/ }),

/***/ 1429:
/***/ (function(module, exports) {

angular.module('xlrelease').factory('UploadService', [function () {
  var data = {};
  return {
    data: data,
    uploadProgressed: function uploadProgressed() {
      data.loading = true;
    },
    uploadFailed: function uploadFailed(errorMessage) {
      data.loading = false;
      data.error = true;
      data.errorMessage = errorMessage;
    },
    uploadSuccess: function uploadSuccess(result) {
      data.loading = false;
      data.result = result;
      data.error = false;
    },
    reset: function reset() {
      delete data.loading;
      delete data.result;
      delete data.error;
      delete data.errorMessage;
    }
  };
}]);

/***/ }),

/***/ 1430:
/***/ (function(module, exports) {

/**
 * This service is used by all controllers that needs to handle single CI such as SMTP CI or ReportsSettings CI.
 * Usage:
 *  var manager = new CIManager({
 *      type: type,
 *      directory: directory,
 *      loadCallback: loadCallback,
 *      saveCallback: saveCallback,
 *  });
 */
angular.module('xlrelease').factory('CIManager', ['Backend', function (Backend) {
  return function (settings) {
    var manager = {
      ci: {},
      type: null,
      lastSavedDate: null,
      ciLoaded: false,
      editableProperties: null,
      save: save,
      deleteCi: deleteCi
    };
    var ciExists = false;
    var URL = Object.is(settings.customURL, undefined) ? "settings/ci/".concat(settings.directory, "/").concat(settings.type) : settings.customURL;
    Backend.get('metadata/type/xlrelease.' + settings.type).then(function (resp) {
      manager.type = resp.data;
      manager.editableProperties = resp.data.properties.filter(function (obj) {
        return obj.name !== 'folderId';
      });
    });
    Backend.get(URL, {
      hideAlert: true
    }).then(function (resp) {
      manager.ci = resp.data;
      manager.ciLoaded = true;
      ciExists = true;
    }, function (err) {
      manager.ciLoaded = true;
      ciExists = false;
    }).finally(function () {
      if (settings.loadCallback) {
        settings.loadCallback(manager.ci);
      }
    });

    function save() {
      if (ciExists) {
        return Backend.put(URL, manager.ci).then(function (resp) {
          return ciSaved(resp.data);
        });
      } else {
        manager.ci.type = 'xlrelease.' + settings.type;
        manager.ci.id = settings.directory + '/' + settings.type;
        return Backend.post(URL, manager.ci).then(function (resp) {
          return ciSaved(resp.data);
        });
      }
    }

    function ciSaved(ci) {
      ciExists = true;
      manager.lastSavedDate = moment().toDate();
      manager.ci = ci;

      if (settings.saveCallback) {
        settings.saveCallback();
      }
    }

    function deleteCi() {
      return Backend.del(URL).then(function (resp) {
        return ciDeleted();
      });
    }

    function ciDeleted() {
      ciExists = false;
      manager.lastSavedDate = moment().toDate();
      manager.ci = {};

      if (settings.deleteCallback) {
        settings.deleteCallback();
      }
    }

    return manager;
  };
}]);

/***/ }),

/***/ 1431:
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * Load CIs by page.
 *
 * Usage:
 *   var cisLoader = new CisLoader(settings)
 *   cisLoader.loadNextCis()
 *
 * settings:
 *  - filters: cis filters
 *  - updateView: call with cis when they are loaded
 *      ex:
 *      function updateView(releases) {
 *          $scope.releases = releases;
 *      }
 *
 * Available methods to monitor cis loader state:
 *  - isLoading
 *  - hasMoreCis
 *  - hasError
 */

angular.module('xlrelease').factory('CisLoader', ['$q', 'CiLoaderSettings', function ($q, CiLoaderSettings) {
  return function (settings) {
    var serverPage = 0;
    var cis = [];
    var endReached = false;
    var loading = false;
    var errorOccurred = false;

    this.loadNextCis = function (onMoreLoadedCallback) {
      searchNext().then(function (nextCis) {
        if (!_.isEmpty(nextCis)) {
          cis = cis.concat(nextCis);
          settings.updateView(cis);
          if (onMoreLoadedCallback) onMoreLoadedCallback();
        }
      });
    };

    function searchNext() {
      var deferred = $q.defer();
      loading = true;
      settings.searchCis(settings.filters, {
        params: {
          page: serverPage,
          numberbypage: CiLoaderSettings.itemsByPage
        }
      }).then(function (resp) {
        var result = resp.data;

        if (result.cis.length < CiLoaderSettings.itemsByPage) {
          endReached = true;
        }

        if (result.cis.length !== 0) {
          serverPage = result.page;
        }

        deferred.resolve(result.cis);
      }, function () {
        errorOccurred = true;
        endReached = true;
        deferred.resolve([]);
      }).finally(function () {
        loading = false;
      });
      return deferred.promise;
    }

    this.isLoading = function () {
      return loading;
    };

    this.hasMoreCis = function () {
      return !endReached;
    };

    this.hasError = function () {
      return errorOccurred;
    };
  };
}]);
angular.module('xlrelease').constant('CiLoaderSettings', {
  itemsByPage: 30,
  itemsMaxDepth: 10
});

/***/ }),

/***/ 1432:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').factory('ColorService', ['ReleasesService', 'PhaseColors', function (ReleasesService, PhaseColors) {
  var pastBackgroundColor = '#f1f1f1';

  function desaturate(color) {
    return chroma.interpolate(color, pastBackgroundColor, 0.5).hex();
  }

  return {
    computeDayColor: function computeDayColor(day) {
      if (!day.color) return null;
      return day.dateStatus === 'past' ? desaturate(day.color) : day.color;
    },
    computePhaseColor: function computePhaseColor(release, phase) {
      var color = phase.color || PhaseColors[0].value;
      return ReleasesService.isReleaseCompleted(release) ? desaturate(color) : color;
    }
  };
}]);

/***/ }),

/***/ 1433:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').factory('ConfigurationItemService', [function () {
  return {
    getCIDuration: function getCIDuration(configurationItem) {
      if (!configurationItem.startDate || !configurationItem.endDate) {
        return 0;
      }

      return configurationItem.endDate - configurationItem.startDate;
    }
  };
}]);

/***/ }),

/***/ 1434:
/***/ (function(module, exports) {

angular.module('xlrelease').run(['$rootScope', 'Timeout', function ($rootScope, Timeout) {
  $rootScope.delayedWatch = function (delay, watchExp, listener, objectEquality) {
    var timeout;
    this.$watch(watchExp, function (newValue, oldValue) {
      if (newValue === oldValue) return;

      if (timeout) {
        Timeout.cancel(timeout);
      }

      timeout = Timeout(_.partial(listener, newValue, oldValue), delay);
    }, objectEquality);
  };
}]);

/***/ }),

/***/ 1435:
/***/ (function(module, exports) {

angular.module('xlrelease').constant('Events', {
  permission: {
    unauthorized: 'UNAUTHORIZED',
    forbidden: 'FORBIDDEN',
    refresh: 'REFRESH-PERMISSIONS',
    loggedIn: 'LOGGED-IN'
  },
  polling: {
    stop: 'STOP-TASK-POLLING'
  },
  timeline: {
    resize: 'RESIZE-TIMELINE',
    hasBeenResized: 'TIMELINE-RESIZED'
  },
  gantt: {
    openTaskDetails: 'OPEN-TASK-DETAILS',
    openPhaseDetails: 'OPEN-PHASE-DETAILS',
    hasBeenRefreshed: 'GANTT-REFRESHED'
  },
  filters: {
    filterChanged: 'FILTERS-FILTER-CHANGED'
  },
  grid: {
    refresh: 'REFRESH-RELEASE-GRID',
    edit: 'EDIT-RELEASE-GRID-ITEM'
  },
  tile: {
    resized: 'TILE-RESIZED'
  },
  upload: {
    success: 'UPLOAD-SUCCEEDED',
    failure: 'UPLOAD-FAILED'
  },
  folders: {
    filterChanged: 'FOLDERS-FILTER-CHANGED',
    refresh: 'FOLDERS-REFRESH-GRID',
    loaded: 'FOLDERS-LOADED',
    createNew: 'FOLDERS-CREATE-NEW',
    rename: 'FOLDERS-RENAME',
    postRename: 'FOLDERS-RENAME-POST',
    delete: 'FOLDERS-DELETE',
    add: 'FOLDERS-ADD',
    cleanCache: 'FOLDERS-CLEAN-CACHE'
  },
  uiLayout: {
    collapse: 'COLLAPSE',
    expand: 'EXPAND',
    resize: 'RESIZE'
  },
  breadcrumbs: {
    update: 'BREADCRUMBS-UPDATE'
  },
  calendar: {
    setLabel: 'CALENDAR-SET-LABEL',
    setBlackout: 'CALENDAR-SET-BLACKOUT'
  },
  ui: {
    themeRefresh: 'UI-THEME-REFRESH',
    subMenuRefresh: 'SUB-MENU-REFRESH',
    customLogoRefresh: 'UI-CUSTOM-LOGO-REFRESH',
    ensureMainMenuLoaded: 'ENSURE-MAIN-MENU-LOADED'
  },
  settings: {
    systemMessageUpdated: 'SETTINGS-SYSTEM-MESSAGE-UPDATE'
  }
});

/***/ }),

/***/ 1436:
/***/ (function(module, exports) {

$.fn.hasVerticalScrollBar = function () {
  return this.get(0) ? this.get(0).scrollHeight > this.innerHeight() : false;
};

/***/ }),

/***/ 1437:
/***/ (function(module, exports) {

/**
 * Keep in sync with variables.less
 */
angular.module('xlrelease').constant('Layout', {
  mainPageBorder: 10
});

/***/ }),

/***/ 1438:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').factory('LocalStorageWrapper', ['$window', function ($window) {
  return $window.localStorage;
}]);

/***/ }),

/***/ 1439:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').factory('MetadataService', ['$q', 'Backend', function ($q, Backend) {
  var configurationDescriptors = null;
  var descriptors = undefined;
  var descriptorMap = new Map();

  function getDescriptor(instanceType) {
    var hideAlert = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
    var deferred = $q.defer();

    if (!!descriptorMap.get(instanceType)) {
      deferred.resolve(descriptorMap.get(instanceType));
    } else {
      Backend.get('metadata/type/' + instanceType, {
        hideAlert: hideAlert
      }).then(function (result) {
        var descriptor = result.data;
        descriptor.propertiesByCategory = _.groupBy(descriptor.properties, 'category');
        descriptorMap.set(descriptor.type, descriptor);
        deferred.resolve(descriptor);
      }).catch(function (reason) {
        return deferred.reject(reason);
      });
    }

    return deferred.promise;
  }

  function getDescriptors() {
    var deferred = $q.defer();

    if (!descriptors) {
      Backend.get('metadata/type').then(function (result) {
        descriptors = result.data;
        deferred.resolve(descriptors);
      });
    } else {
      deferred.resolve(descriptors);
    }

    return deferred.promise;
  }

  function getSubDescriptors(ciTypeDescriptor) {
    return getAllSubDescriptors(ciTypeDescriptor).then(function (descriptorList) {
      return descriptorList.filter(function (descriptor) {
        return descriptor.virtual === false;
      });
    });
  }

  function getAllSubDescriptors(ciTypeDescriptor) {
    return getDescriptors().then(function (descriptorList) {
      return descriptorList.filter(function (descriptor) {
        return !_.isUndefined(descriptor.superTypes) && _.includes(descriptor.superTypes, getCiType(ciTypeDescriptor));
      });
    });
  }

  function getCiType(ciTypeDescriptor) {
    if (_.isUndefined(ciTypeDescriptor.type)) {
      return ciTypeDescriptor.referencedType;
    }

    return ciTypeDescriptor.type;
  }

  function isTypePresent(descriptorType) {
    return getDescriptors().then(function (descriptors) {
      return angular.isDefined(descriptors.find(function (descriptor) {
        return descriptor.type === descriptorType;
      }));
    });
  }

  function getConfigurationDescriptors() {
    if (!configurationDescriptors) {
      return Backend.get('configurations/descriptors').then(function (result) {
        configurationDescriptors = result.data;
        return configurationDescriptors;
      });
    }

    var deferred = $q.defer();
    deferred.resolve(configurationDescriptors);
    return deferred.promise;
  }

  return {
    getDescriptor: getDescriptor,
    getConfigurationDescriptors: getConfigurationDescriptors,
    getSubDescriptors: getSubDescriptors,
    getAllSubDescriptors: getAllSubDescriptors,
    getCiType: getCiType,
    isTypePresent: isTypePresent,
    getDescriptors: getDescriptors
  };
}]);

/***/ }),

/***/ 1440:
/***/ (function(module, exports) {

angular.module('xlrelease').factory('ModalService', ['$timeout', '$compile', '$parse', 'Modal', function ($timeout, $compile, $parse, Modal) {
  function initModal(scope, modalElement, templateUrl, initFunction, hideFunction, draggable, resizable, loadOnElement) {
    Modal.open();
    $parse(initFunction)(scope);
    var isDismissed = false;

    var dismissAction = function dismissAction() {
      $parse(hideFunction)(scope);
      Modal.close();
      modalElement.modal('hide');

      if (scope.unregisterLocationListener) {
        scope.unregisterLocationListener();
      }

      $timeout(function () {
        return scope.$destroy();
      });
    };

    scope.dismiss = function () {
      isDismissed = true;
      dismissAction();
    };

    var afterShowModalWindow = function afterShowModalWindow() {
      modalElement.on('mousedown', function (e) {
        if (e.target.className && _.includes(e.target.className.split(' '), 'modal')) {
          scope.$apply(scope.dismiss);
        }
      });
      angular.element('.modal-backdrop').on('mousedown', function () {
        scope.$apply(scope.dismiss);
      });

      if (draggable) {
        modalElement.draggable({
          handle: ".modal-header",
          cursor: "move"
        });
      }

      if (resizable) {
        modalElement.find('.modal-content').resizable({
          alsoResize: modalElement.find('.modal-body'),
          handles: "se",
          minHeight: 520,
          minWidth: 750
        });
      }
    };

    scope.showModal = function () {
      modalElement.modal('show');
      modalElement.off('click.dismiss.bs.modal');
      $timeout(afterShowModalWindow, 100);
    };

    var template = '<div class="modal-dialog" ng-include="' + templateUrl + '"></div>';

    if (loadOnElement) {
      template = '<div class="modal-dialog" ng-include="' + templateUrl + '" onload="showModal()"></div>';
    }

    $compile(modalElement.html(template))(scope);
    modalElement.on('shown.bs.modal', function () {
      $timeout(function () {
        modalElement.off('shown.bs.modal');
        modalElement.find('[autofocus]:first').trigger('focus');
      });
    });
    modalElement.on('hidden.bs.modal', function () {
      $timeout(function () {
        modalElement.off('hidden.bs.modal');
        scope.$apply(scope.dismiss);
      });
    });
    scope.$on("$destroy", function () {
      if (!isDismissed) dismissAction();

      if (modalElement.data('ui-draggable')) {
        modalElement.draggable('destroy');
      }

      if (modalElement.find('.modal-content').data('ui-resizable')) {
        modalElement.find('.modal-content').resizable('destroy');
      }

      modalElement.removeData();
      modalElement.off();
      modalElement.empty();
      angular.element('.modal-backdrop').off();
    });
    scope.unregisterLocationListener = scope.$on('$locationChangeSuccess', scope.dismiss);
  }

  return {
    open: function open(scope, templateUrl, initFunction, hideFunction, draggable, resizable, loadOnElement) {
      var modalElement = angular.element('#modal');

      if (resizable) {
        modalElement = angular.element('#resizable-modal');
      }

      initModal(scope, modalElement, templateUrl, initFunction, hideFunction, draggable, resizable, loadOnElement);
    }
  };
}]);

var modalLinkFunction = function modalLinkFunction(ModalService, templateAttr, scope, element, attrs) {
  var watcher = scope.$watch(attrs.openOn, function (triggerCondition) {
    if (angular.isDefined(triggerCondition) && triggerCondition) {
      ModalService.open(scope.$new(), attrs[templateAttr], attrs.init, attrs.onModalHide, attrs.draggable, attrs.resizable, true);
    }
  });
  element.on('click', function (event) {
    if (!attrs.disabled) {
      event.stopPropagation();
      scope.$apply(function () {
        ModalService.open(scope.$new(), attrs[templateAttr], attrs.init, attrs.onModalHide, attrs.draggable, attrs.resizable, true);
      });
    }
  });
  scope.$on("$destroy", function () {
    watcher();
    element.off();
  });
};

angular.module('xlrelease').directive('modal', ['$compile', '$parse', 'Modal', 'ModalService', function ($compile, $parse, Modal, ModalService) {
  return {
    scope: true,
    link: modalLinkFunction.bind(null, ModalService, 'modal')
  };
}]);
angular.module('xlrelease').directive('scopeLessModal', ['$compile', '$parse', 'Modal', 'ModalService', function ($compile, $parse, Modal, ModalService) {
  return {
    scope: {
      ctrl: '='
    },
    link: modalLinkFunction.bind(null, ModalService, 'scopeLessModal')
  };
}]);
angular.module('xlrelease').factory('Modal', ['$q', function ($q) {
  var _open = $q.defer();

  var _close = $q.defer();

  function initPromise(parentPromise, scope) {
    var defer = $q.defer();
    parentPromise.then(defer.resolve);
    scope.$on('$destroy', defer.reject);
    return defer.promise;
  }

  return {
    open: function open() {
      _open.resolve('open');

      _open = $q.defer();
    },
    close: function close() {
      _close.resolve('close');

      _close = $q.defer();
    },
    withScope: function withScope(scope) {
      var nextOpen = initPromise(_open.promise, scope);
      var nextClose = initPromise(_close.promise, scope);
      return {
        onNextOpen: function onNextOpen(callback) {
          nextOpen.then(callback);
          return this;
        },
        onNextClose: function onNextClose(callback) {
          nextClose.then(callback);
          return this;
        }
      };
    }
  };
}]);

/***/ }),

/***/ 1441:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').factory('PhasesService', ['TasksService', 'Backend', function (TasksService, Backend) {
  return {
    isPhaseInProgress: function isPhaseInProgress(phase) {
      return 'IN_PROGRESS' === phase.status;
    },
    isPhaseReadOnly: function isPhaseReadOnly(phase) {
      return 'COMPLETED' === phase.status || 'ABORTED' === phase.status || 'SKIPPED' === phase.status;
    },
    isPhasePlanned: function isPhasePlanned(phase) {
      return 'PLANNED' === phase.status;
    },
    isPlannedOrNotMostRecentCopy: function isPlannedOrNotMostRecentCopy(phase) {
      if ('PLANNED' === phase.status) {
        return true;
      }

      return !phase.mostRecentCopy;
    },
    isPlannedOrNotOriginal: function isPlannedOrNotOriginal(phase) {
      if ('PLANNED' === phase.status) {
        return true;
      }

      return !phase.origin;
    },
    isPhaseActive: function isPhaseActive(phase) {
      return 'IN_PROGRESS' === phase.status || 'FAILED' === phase.status || 'FAILING' === phase.status;
    },
    isPhase: function isPhase(planItem) {
      return planItem.type === 'xlrelease.Phase';
    },
    getLeafTasks: function getLeafTasks(phase) {
      return _.flattenDeep(_.map(phase.tasks, TasksService.getSubTasks));
    },
    updatePhase: function updatePhase(phase) {
      var phaseForm = {
        title: phase.title,
        description: phase.description,
        scheduledStartDate: phase.scheduledStartDate,
        dueDate: phase.dueDate,
        color: phase.color,
        plannedDuration: phase.plannedDuration
      };
      Backend.put("phases/".concat(phase.id), phaseForm);
    }
  };
}]);

/***/ }),

/***/ 1442:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').factory('StringService', [function () {
  return {
    isUpperCase: function isUpperCase(c) {
      return c.toUpperCase() === c;
    },
    deCamelize: function deCamelize(input) {
      var output = '';

      for (var i = 0; i < input.length; i++) {
        var c = input.charAt(i);

        if (i === 0) {
          c = c.toUpperCase();
        } else if (this.isUpperCase(c)) {
          output += ' ';
        }

        output += c;
      }

      return output;
    },
    capitalizeFirstLetter: function capitalizeFirstLetter(input) {
      return input.substring(0, 1).toUpperCase() + input.substring(1);
    }
  };
}]);

/***/ }),

/***/ 1443:
/***/ (function(module, exports) {

angular.module('xlrelease').factory('Timeout', ['$rootScope', '$q', '$exceptionHandler', function ($rootScope, $q, $exceptionHandler) {
  var deferreds = {};

  function timeout(fn, delay) {
    var deferred = timeout._getDeferred();

    var timeoutId = timeout._registerTimeout(deferred, fn, delay);

    return buildPromise(deferred, timeoutId);
  }

  timeout.cancel = function (promise) {
    if (promise && promise.$$timeoutId in deferreds) {
      deferreds[promise.$$timeoutId].reject('canceled');
      clearTimeout(promise.$$timeoutId);
      return true;
    }

    return false;
  }; // visible for testing


  timeout._getDeferred = function () {
    return $q.defer();
  }; // visible for testing


  timeout._registerTimeout = function (deferred, fn, delay) {
    var timeoutId = setTimeout(function () {
      try {
        deferred.resolve(fn());
      } catch (e) {
        deferred.reject(e);
        $exceptionHandler(e);
      }

      $rootScope.$apply();
    }, delay);
    deferreds[timeoutId] = deferred;
    return timeoutId;
  }; // visible for testing


  timeout._cleanup = function (promise) {
    function cleanup() {
      delete deferreds[promise.$$timeoutId];
    }

    promise.then(cleanup, cleanup);
  };

  function buildPromise(deferred, timeoutId) {
    var promise = deferred.promise;
    promise.$$timeoutId = timeoutId;

    timeout._cleanup(promise);

    return promise;
  }

  return timeout;
}]);

/***/ }),

/***/ 1444:
/***/ (function(module, exports) {

angular.module('xlrelease').factory('TopologicalSort', [function () {
  return {
    /**
     *  graph = {
     *      adjacencyList: [
     *          {sourceId: '1', targetId: '2'},
     *          {sourceId: '3', targetId: '2'}
     *      ],
     *      vertices: ['1', '2', '3']
     *  }
     *
     *  Returns ['3', '1', '2'], or null if the graph has a cycle
     */
    sort: function sort(graph) {
      var marked = {};
      var ordered = [];
      var onStack = {};
      var hasCycle = false;

      function adjacentsOf(vertex) {
        return _(graph.adjacencyList).filter({
          sourceId: vertex
        }).map('targetId').value();
      }

      function depthFirstSearch(vertex) {
        onStack[vertex] = true;
        marked[vertex] = true;

        _.forEach(adjacentsOf(vertex), function (adjacent) {
          if (!marked[adjacent]) {
            depthFirstSearch(adjacent);
          } else if (onStack[adjacent]) {
            hasCycle = true;
            return false;
          }
        });

        ordered.unshift(vertex);
        onStack[vertex] = false;
        return true;
      }

      _.forEach(graph.vertices, function (vertex) {
        if (!marked[vertex]) {
          depthFirstSearch(vertex);
        }

        if (hasCycle) {
          return false;
        }
      });

      return hasCycle ? null : ordered;
    }
  };
}]);

/***/ }),

/***/ 1445:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').factory('ViewStorage', ['$window', function ($window) {
  var VIEWS_MAP = "xlreleaseViewStorage";

  var setView = function setView(key, view) {
    var views = getViews();
    views[key] = view;
    storeViews(views);
  };

  var getView = function getView(key, defaultView) {
    var views = getViews();
    return _.get(views, key, defaultView);
  };

  var removeView = function removeView(key) {
    var views = getViews();
    delete views[key];
    storeViews(views);
  };

  var clear = function clear() {
    storeViews({});
  };

  function getViews() {
    return _.assign({}, angular.fromJson($window.sessionStorage.getItem(VIEWS_MAP)));
  }

  function storeViews(views) {
    $window.sessionStorage.setItem(VIEWS_MAP, angular.toJson(views));
  }

  return {
    setView: setView,
    getView: getView,
    removeView: removeView,
    clear: clear
  };
}]);

/***/ }),

/***/ 1446:
/***/ (function(module, exports) {

angular.module('xlrelease').factory('Window', [function () {
  var windowWrapper = angular.element(window);
  return {
    height: function height() {
      return windowWrapper.height();
    },
    onResize: function onResize(callback, scope) {
      windowWrapper.resize(callback);
      scope.$on('$destroy', function () {
        windowWrapper.off("resize", callback);
      });
    }
  };
}]);

/***/ }),

/***/ 1447:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').controller('releaseValueStreamController', ['$scope', 'TagsService', '$location', 'PhasesService', 'filterSettings', 'ValueStreamMapping', 'ConfigurationItemService', 'ReleasesService', 'Events', 'ClientSettings', 'CisLoader', function ($scope, TagsService, $location, PhasesService, filterSettings, ValueStreamMapping, ConfigurationItemService, ReleasesService, Events, ClientSettings, CisLoader) {
  $scope.filters = filterSettings;
  $scope.filters.completed = true;
  $scope.allTags = [];
  $scope.$on(Events.filters.filterChanged, function (e, filters) {
    loadReleases();
    ClientSettings.setReleaseValueStreamFilters(filters);
  });

  function loadTags() {
    TagsService.getArchivedReleaseTags().then(function (tags) {
      $scope.allTags = tags;
    });
  }

  function loadReleases() {
    $scope.releases = null;
    $scope.releasesLoader = new CisLoader({
      searchCis: ReleasesService.searchArchived,
      filters: $scope.filters,
      updateView: function updateView(releases) {
        return $scope.releases = _.sortBy(releases, function (release) {
          return release.endDate;
        }).reverse();
      }
    });
    $scope.releasesLoader.loadNextCis();
  }

  loadTags();
  loadReleases();

  $scope.getDurationPercentage = function (release, phase) {
    var ciDuration = ConfigurationItemService.getCIDuration(release);

    if (ciDuration === 0) {
      return 0;
    }

    return Math.round(ConfigurationItemService.getCIDuration(phase) * 100 / ciDuration);
  };

  $scope.getLeafTasks = PhasesService.getLeafTasks;
  $scope.isCritical = ValueStreamMapping.isCritical;
  $scope.getWarningThreshold = ValueStreamMapping.getWarningThreshold;
  $scope.getErrorThreshold = ValueStreamMapping.getErrorThreshold;
  $scope.getCriticalPhasesCount = ValueStreamMapping.getCriticalPhasesCount;
  $scope.getCIDuration = ConfigurationItemService.getCIDuration;
}]);

/***/ }),

/***/ 1448:
/***/ (function(module, exports) {

angular.module('xlrelease').factory('ValueStreamMapping', ['Backend', function (Backend) {
  var settings = {
    warningThreshold: undefined,
    errorThreshold: undefined,
    criticalPhaseThreshold: undefined
  };

  function refreshReportsSettings() {
    Backend.get('settings/reports').then(function (resp) {
      var reportsSettings = resp.data;
      settings.warningThreshold = reportsSettings.warningThreshold;
      settings.errorThreshold = reportsSettings.errorThreshold;
      settings.criticalPhaseThreshold = reportsSettings.criticalPhaseThreshold;
    });
  }

  refreshReportsSettings();
  return {
    getWarningThreshold: function getWarningThreshold() {
      return settings.warningThreshold;
    },
    getErrorThreshold: function getErrorThreshold() {
      return settings.errorThreshold;
    },
    isCritical: function isCritical(phase) {
      return phase.taskFlaggedCount + phase.taskFailureCount + phase.taskDelayCount > settings.criticalPhaseThreshold;
    },
    getCriticalPhasesCount: function getCriticalPhasesCount(release) {
      return _(release.phases).map(this.isCritical).compact().size();
    },
    refreshReportsSettings: refreshReportsSettings
  };
}]);

/***/ }),

/***/ 1449:
/***/ (function(module, exports) {

angular.module('xlrelease').directive('displayVariables', ['displayVariablesFilter', 'VariablesService', 'VariablesInterpolator', function (displayVariablesFilter, VariablesService, VariablesInterpolator) {
  return function (scope, element, attrs) {
    scope.$watchCollection("[".concat(attrs.displayVariables, ", ").concat(attrs.variables, ", ").concat(attrs.limitTo, "]"), function (watchedValues) {
      var content = watchedValues[0];
      var variables = watchedValues[1];
      var limitTo = angular.element(attrs.$$element).data('limit-to');

      if (_.has(attrs, 'ignoreBlankValues')) {
        variables = _.pickBy(variables, _.negate(_.isEmpty));
      }

      if (content && _.has(attrs, 'enableTooltip')) {
        var variablesMap = VariablesService.convertToMap(variables);
        var text = VariablesInterpolator.interpolate(content, variablesMap, _.identity);
        element.attr('title', text);
      }

      var html = displayVariablesFilter(content, variables, angular.isDefined(attrs.markdown), angular.isDefined(attrs.keepNewLines), limitTo, angular.isDefined(attrs.slim));
      element.html(html);
    });
  };
}]).filter('displayVariables', ['newlinesFilter', 'markdownFilter', 'VariablesInterpolator', 'VariablesService', 'limitToFilter', function (newlinesFilter, markdownFilter, VariablesInterpolator, VariablesService, limitToFilter) {
  return function (content, variables, isMarkdown, keepNewLines, limitTo, isSlim) {
    var variablesMap = VariablesService.convertToMap(variables);
    var text = content || '';

    if (isMarkdown) {
      text = markdownFilter(text);
      text = text.replace(/%7B/g, '{').replace(/%7D/g, '}');

      if (isSlim) {
        var anchorElement = text.match(/<a[\s]+([^>]+)>((?:.(?!\<\/a\>))*.)<\/a>/g);

        if (anchorElement && anchorElement.length === 1) {
          var href = anchorElement[0].match(/href="(.*)"/)[1];

          if (!href.startsWith("#/")) {
            text = anchorElement[0].replace('<a', '<a target="_blank" rel="noopener"');
          }
        }
      }
    } else {
      text = _.escape(text);
    }

    if (keepNewLines) {
      text = newlinesFilter(text);
    }

    var html = isMarkdown ? VariablesInterpolator.interpolateInText(variablesMap, text) : VariablesInterpolator.interpolateInHtml(variablesMap, text);

    if (limitTo) {
      var extractedHTML = html.replace(/<[^>]+>/g, '');
      var limitedHTML = limitToFilter(extractedHTML, limitTo);

      if (limitedHTML.length < extractedHTML.length) {
        return limitedHTML + "...";
      }
    }

    return html;
  };
}]);

/***/ }),

/***/ 1450:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').controller('globalVariablesController', ['$scope', 'VariablesService', 'Authenticator', function ($scope, VariablesService, Authenticator) {
  $scope.isReadonly = !Authenticator.hasEditGlobalVariablesPermission();
  $scope.filters = {
    filter: ''
  };
  $scope.updateGlobalVariable = updateGlobalVariable;
  $scope.createGlobalVariable = createGlobalVariable;
  $scope.deleteGlobalVariable = deleteGlobalVariable;
  $scope.newVariable = newVariable;
  loadVariables();

  function loadVariables() {
    VariablesService.getGlobalVariables().then(function (resp) {
      var variables = resp.data;
      $scope.variables = variables;
      $scope.decoratedVariables = _.map(variables, VariablesService.decorateVariable);
    });
  }

  function deleteGlobalVariable(variable, onSuccess) {
    VariablesService.deleteGlobalVariable(variable).then(function () {
      _.remove($scope.variables, {
        id: variable.id
      });

      _.remove($scope.decoratedVariables, {
        id: variable.id
      });

      onSuccess();
    });
  }

  function updateGlobalVariable(variable, onSuccess) {
    VariablesService.updateGlobalVariable(variable).then(function (resp) {
      var updated = resp.data;

      _.assign(_.find($scope.variables, {
        key: updated.key
      }), updated);

      _.assign(_.find($scope.decoratedVariables, {
        key: updated.key
      }), updated);

      onSuccess();
    });
  }

  function createGlobalVariable(variable, onSuccess) {
    variable.requiresValue = false;
    variable.showOnReleaseStart = false;
    VariablesService.createGlobalVariable(variable).then(function (resp) {
      var variable = resp.data;
      $scope.variables.push(variable);
      $scope.decoratedVariables.push(VariablesService.decorateVariable(variable)); // Using sort in place so that array references propagated to variables-list and edit-variable
      // directives are updated automatically

      sortInplaceByKey($scope.variables);
      sortInplaceByKey($scope.decoratedVariables);
      onSuccess(variable);
    });
  }

  function sortInplaceByKey(array) {
    array.sort(function (a, b) {
      if (a.key < b.key) return -1;
      if (a.key === b.key) return 0;
      if (a.key > b.key) return 1;
    });
  }

  function newVariable() {
    return {
      key: "global.",
      type: 'xlrelease.StringVariable',
      requiresValue: false,
      showOnReleaseStart: false
    };
  }
}]);

/***/ }),

/***/ 1451:
/***/ (function(module, exports) {

angular.module('xlrelease').factory('VariablesInterpolator', [function () {
  // Matches and captures ${...}, where "..." contains anything except '}'
  var VARIABLE_MATCHER = /(\$\{[^}]+\})/g; // Matches and captures all special chars in regexps in order to escape them.

  var ESCAPE_REGEXP_MATCHER = /([.*+?^=!:${}()|\[\]\/\\])/g;

  function escapeRegExp(variableName) {
    return variableName.replace(ESCAPE_REGEXP_MATCHER, '\\$1');
  }

  function interpolate(text, variableValues, quoteReplacement) {
    if (text) {
      var variables = _.uniq(text.match(VARIABLE_MATCHER));

      _.forEach(variables, function (variable) {
        var replacement = variable;
        var replaced = false;
        var parsedVariable = /^\$\{\s*([^ ](.*[^ ])?)\s*\}$/.exec(variable);
        var cleanedVariable;

        if (parsedVariable) {
          cleanedVariable = "${".concat(parsedVariable[1], "}");
        } else {
          cleanedVariable = variable;
        }

        if (variableValues && !_.isUndefined(variableValues[cleanedVariable]) && !_.isNull(variableValues[cleanedVariable])) {
          replacement = variableValues[cleanedVariable];
          replaced = true;
        }

        var regExp = new RegExp(escapeRegExp(variable), 'g');
        text = text.replace(regExp, quoteReplacement(replacement, replaced));
      });
    }

    return text;
  }

  return {
    interpolate: interpolate,
    interpolateInText: function interpolateInText(variableViews, text) {
      return interpolate(text, variableViews, function (text) {
        return _.escape(text);
      });
    },
    interpolateInHtml: function interpolateInHtml(variableViews, text) {
      function quoteHtmlReplacement(replacement, replaced) {
        return '<span class="variable">' + (replacement && replaced ? _.escape(replacement) : replacement) + '</span>';
      }

      return interpolate(text, variableViews, quoteHtmlReplacement);
    }
  };
}]);

/***/ }),

/***/ 16:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "i", function() { return registerRequestInterceptor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "j", function() { return registerResponseInterceptors; });
/* unused harmony export directHttpRequest */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "h", function() { return httpRequest; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return httpCodes; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return httpGET; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "e", function() { return httpPOST; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "g", function() { return httpPUT; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return httpDELETE; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "f", function() { return httpPOSTBlob; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "d", function() { return httpGETBlob; });
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(516);
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(axios__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_http_backend__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(271);


function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }



var instance = axios__WEBPACK_IMPORTED_MODULE_1___default.a.create();
var registerRequestInterceptor = function registerRequestInterceptor(requestInterceptor) {
  instance.interceptors.request.use(requestInterceptor, function (error) {
    return error;
  });
};
var registerResponseInterceptors = function registerResponseInterceptors(successInterceptor, errorInterceptor) {
  instance.interceptors.response.use(successInterceptor, errorInterceptor);
};
var directHttpRequest = function directHttpRequest(method, url, config, headers) {
  var requestObject = _objectSpread(_objectSpread({}, config), {}, {
    headers: headers,
    method: method,
    url: url
  });

  return instance.request(requestObject);
};
var httpRequest = function httpRequest(method, url) {
  var config = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  var accept = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 'application/json';
  return directHttpRequest(method, "".concat(url), config, {
    'Accept': accept,
    'Accept-Type': accept,
    'X-HTTP-Auth-Override': 'true'
  });
};
var httpCodes = {
  UNAUTHORIZED: 401,
  PAYMENT_REQUIRED: 402,
  FORBIDDEN: 403,
  VERSION_CHANGED: 410
};
function httpGET(url) {
  var hideAlert = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
  var dontRedirectWhenForbidden = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
  return httpRequest('GET', url, {
    dontRedirectWhenForbidden: dontRedirectWhenForbidden,
    hideAlert: hideAlert
  });
}
function httpPOST(url, data) {
  var hideAlert = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
  return httpRequest('POST', url, {
    data: data,
    hideAlert: hideAlert
  });
}
function httpPUT(url, data) {
  return httpRequest('PUT', url, {
    data: data
  });
}
function httpDELETE(url, data) {
  return httpRequest('DELETE', url, {
    data: data
  });
}
function httpPOSTBlob(url, data) {
  var hideAlert = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
  return httpRequest('POST', url, {
    data: data,
    hideAlert: hideAlert,
    responseType: 'blob'
  }, '*/*');
}
function httpGETBlob(url, data) {
  var hideAlert = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
  return httpRequest('GET', url, {
    data: data,
    hideAlert: hideAlert,
    responseType: 'blob'
  }, '*/*');
}

/***/ }),

/***/ 166:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, "b", function() { return /* binding */ calculatePercentage; });
__webpack_require__.d(__webpack_exports__, "a", function() { return /* binding */ release_progress_component_ReleaseProgressComponent; });

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/classCallCheck.js
var classCallCheck = __webpack_require__(4);
var classCallCheck_default = /*#__PURE__*/__webpack_require__.n(classCallCheck);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/createClass.js
var createClass = __webpack_require__(5);
var createClass_default = /*#__PURE__*/__webpack_require__.n(createClass);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/inherits.js
var inherits = __webpack_require__(11);
var inherits_default = /*#__PURE__*/__webpack_require__.n(inherits);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/possibleConstructorReturn.js
var possibleConstructorReturn = __webpack_require__(10);
var possibleConstructorReturn_default = /*#__PURE__*/__webpack_require__.n(possibleConstructorReturn);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/getPrototypeOf.js
var getPrototypeOf = __webpack_require__(8);
var getPrototypeOf_default = /*#__PURE__*/__webpack_require__.n(getPrototypeOf);

// EXTERNAL MODULE: external "React"
var external_React_ = __webpack_require__(0);
var external_React_default = /*#__PURE__*/__webpack_require__.n(external_React_);

// EXTERNAL MODULE: ./node_modules/prop-types/index.js
var prop_types = __webpack_require__(2);

// EXTERNAL MODULE: ./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js
var injectStylesIntoStyleTag = __webpack_require__(9);
var injectStylesIntoStyleTag_default = /*#__PURE__*/__webpack_require__.n(injectStylesIntoStyleTag);

// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./core/xlr-ui/app/react/components/release-list/release-progress/release-progress.component.less
var release_progress_component = __webpack_require__(288);
var release_progress_component_default = /*#__PURE__*/__webpack_require__.n(release_progress_component);

// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/release-list/release-progress/release-progress.component.less

            

var options = {};

options.insert = "head";
options.singleton = false;

var update = injectStylesIntoStyleTag_default()(release_progress_component_default.a, options);



/* harmony default export */ var release_progress_release_progress_component = (release_progress_component_default.a.locals || {});
// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/release-list/release-progress/release-progress.component.js






function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }




var calculatePercentage = function calculatePercentage(progress) {
  if (!progress) {
    return 0;
  }

  var totalTasks = progress.totalTasks;
  var totalRemainingTasks = progress.totalRemainingTasks;
  var tasksFinished = totalTasks - totalRemainingTasks;
  return tasksFinished === 0 ? 0 : Math.round(tasksFinished * 100 / totalTasks);
};
var release_progress_component_ReleaseProgressComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(ReleaseProgressComponent, _Component);

  var _super = _createSuper(ReleaseProgressComponent);

  function ReleaseProgressComponent() {
    classCallCheck_default()(this, ReleaseProgressComponent);

    return _super.apply(this, arguments);
  }

  createClass_default()(ReleaseProgressComponent, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          completedPercentage = _this$props.completedPercentage,
          progress = _this$props.progress;
      var percentage = 0;

      if (completedPercentage) {
        percentage = completedPercentage;
      } else if (progress) {
        percentage = calculatePercentage(progress);
      }

      var barWidthStyle = {
        width: percentage + '%'
      };
      return /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "release-progress-bar-view"
      }, /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "percent-number"
      }, percentage, "% Completed"), /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "progress-bar-container"
      }, /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "progress-bar-line",
        style: barWidthStyle
      })));
    }
  }]);

  return ReleaseProgressComponent;
}(external_React_["Component"]);

/***/ }),

/***/ 167:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return XLRelease; });
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4);
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(1);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1__);



var XLRelease = function XLRelease() {
  _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0___default()(this, XLRelease);
};

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(XLRelease, "version", '10.2.14');



/***/ }),

/***/ 170:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return TIME_FRAME_TYPES; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return TIME_FRAME_LABELS; });
var TIME_FRAME_TYPES = {
  LAST_MONTH: 'LAST_MONTH',
  LAST_THREE_MONTHS: 'LAST_THREE_MONTHS',
  LAST_SIX_MONTHS: 'LAST_SIX_MONTHS',
  LAST_YEAR: 'LAST_YEAR',
  RANGE: 'RANGE'
};
var TIME_FRAME_LABELS = {
  LAST_MONTH: 'Last 30 days',
  LAST_THREE_MONTHS: 'Last 3 months',
  LAST_SIX_MONTHS: 'Last 6 months',
  LAST_YEAR: 'Last year',
  RANGE: 'Range'
};

/***/ }),

/***/ 171:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return lazyInjector; });
/**
 * Angular2react needs an $injector, but it doesn't actually invoke $injector.get
 * until we invoke ReactDOM.render. We can take advantage of this to provide the
 * "lazy" injector below to React components created with angular2react, as a way
 * to avoid component ordering issues.
 *
 * @see https://github.com/coatue-oss/angular2react/issues/12
 */
// state
var $injector;
var lazyInjector = {
  get $injector() {
    return {
      get get() {
        return $injector.get;
      }

    };
  },

  set $injector(_$injector) {
    $injector = _$injector;
  }

};

/***/ }),

/***/ 187:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return DownloadHelper; });
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4);
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(1);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1__);


var fileNameRegex = /filename[^;=\n]*=((['"]).*?\2|[^;\n]*)/;
var DownloadHelper = function DownloadHelper() {
  _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0___default()(this, DownloadHelper);
};

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(DownloadHelper, "getNameFromContentDisposition", function (contentDisposition) {
  if (contentDisposition !== null) {
    var matches = fileNameRegex.exec(contentDisposition);

    if (matches !== null && matches[1]) {
      return matches[1].replace(/['"]/g, '');
    }
  }

  return 'unnamed';
});

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(DownloadHelper, "click", function (link) {
  var eventType = 'click';

  try {
    var event = link.ownerDocument.defaultView.createEvent('MouseEvents');

    if (event.initMouseEvent) {
      event.initMouseEvent(eventType, true, true, link.ownerDocument.defaultView, 0, 1, 1, 1, 1, false, false, false, false, 0, null);
      link.dispatchEvent(event);
      return;
    } else if (event.initEvent) {
      event.initEvent(eventType, true, true);
      link.dispatchEvent(event);
      return;
    }
  } catch (e) {//
  }

  try {
    var _event = new link.ownerDocument.defaultView.MouseEvent(eventType, {
      bubbles: true,
      cancelable: true,
      view: link.ownerDocument.defaultView
    });

    link.dispatchEvent(_event);
    return;
  } catch (e) {//
  }

  try {
    link.click();
  } catch (e) {//
  }
});

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(DownloadHelper, "download", function (result) {
  var data = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : result.data;
  var fileName = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

  if (window.navigator.msSaveOrOpenBlob) {
    var contentDisposition = angular.isObject(result.headers) ? result.headers['content-disposition'] : result.headers('content-disposition');
    window.navigator.msSaveOrOpenBlob(data, DownloadHelper.getNameFromContentDisposition(contentDisposition));
  } else {
    var link = document.createElement('a');
    link.href = window.URL.createObjectURL(data);

    if (!!fileName) {
      link.download = fileName;
    } else {
      if (result.headers['content-disposition']) {
        link.download = DownloadHelper.getNameFromContentDisposition(result.headers['content-disposition']);
      } else {
        link.download = DownloadHelper.getNameFromContentDisposition(result.headers('content-disposition'));
      }
    }

    DownloadHelper.click(link);
    window.URL.revokeObjectURL(link.href);

    try {
      document.removeChild(link);
    } catch (e) {//
    }
  }
});

/***/ }),

/***/ 1929:
/***/ (function(module, exports) {

var template = "\n    <form name=\"createTeamForm\" class=\"form-horizontal\" novalidate>\n        <div class=\"modal-header\">\n            <h4 class=\"modal-title pull-left\" id=\"modal-title\">Create a new team</h4>\n            <button type=\"button\" class=\"close pull-right\" ng-click=\"$ctrl.dismiss()\"><i class=\"xl-icon close-icon\"></i></button>\n            <div class=\"clearfix\"></div>\n        </div>\n        <div class=\"modal-body\" id=\"modal-body\">\n            <div class=\"form-group\">\n                <label class=\"col-sm-3 control-label\" for=\"team-name\">\n                    Team name <span ng-if=\"createTeamForm.$dirty && createTeamForm.teamName.$error.required\" class=\"error\">*</span>\n                </label>\n                <div class=\"col-sm-9\">\n                    <input type=\"text\" class=\"input-block-level text\" id=\"team-name\" name=\"teamName\"\n                           ng-model=\"$ctrl.teamName\" not-in-list=\"$ctrl.resolve.teams\" case-insensitive required autofocus/>\n                    <span class=\"description\" ng-if=\"!createTeamForm.teamName.$error.notInList\">Unique name for the team.</span>\n                    <div class=\"field-errors\" ng-if=\"createTeamForm.teamName.$dirty\">\n                        <span ng-if=\"createTeamForm.teamName.$error.notInList\">Team with this name already exists</span>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"modal-footer\">\n            <button class=\"button cancel\" type=\"button\" ng-click=\"$ctrl.dismiss()\">Cancel</button>\n            <button class=\"button continue primary\" type=\"submit\" ng-click=\"$ctrl.close({$value: $ctrl.teamName})\" ng-disabled=\"createTeamForm.$invalid\">\n                Create\n            </button>\n        </div>\n    </form>\n";
var AddTeamModal = {
  bindings: {
    resolve: '<',
    close: '&',
    dismiss: '&'
  },
  template: template
};
angular.module('xlrelease').component('addTeamModal', AddTeamModal);

/***/ }),

/***/ 1930:
/***/ (function(module, exports) {

(function () {
  var template = "    \n    <sub-nav-content ng-if=\"!$ctrl.breadcrumbs\" sub-menu-items=\"$ctrl.subMenuItems\"></sub-nav-content>\n    <ol class=\"breadcrumb\" ng-if=\"$ctrl.breadcrumbs.length !== 0\">\n        <li ng-repeat='breadcrumb in $ctrl.breadcrumbs'>\n            <div ng-class=\"{'overflow': !$last, 'last-overflow': $last}\" ng-switch=\"$last\" title=\"{{breadcrumb.label}}\">\n                <a ng-switch-when=\"false\" ng-href=\"#/{{breadcrumb.pathSuffix}}\" class=\"bread-crumb\">{{breadcrumb.label}}</a>\n                <span ng-switch-when=\"true\" class=\"last-bread-crumb\">{{breadcrumb.label}}</span>                \n            </div>\n            <span ng-if=\"!$last\" class=\"bread-crumbs-separator\">/</span>\n        </li>\n    </ol>\n    ";
  var Breadcrumbs = {
    bindings: {
      breadcrumbs: '<',
      subMenuItems: '<'
    },
    template: template
  };
  angular.module('xlrelease').component('xlrBreadcrumbs', Breadcrumbs);
})();

/***/ }),

/***/ 1931:
/***/ (function(module, exports) {

var template = "\n    <div class=\"modal-header\">\n        <h4 class=\"modal-title pull-left\" id=\"modal-title\">Delete team</h4>\n        <button type=\"button\" class=\"close pull-right\" ng-click=\"$ctrl.close()\"><i class=\"xl-icon close-icon\"></i></button>\n        <div class=\"clearfix\"></div>\n    </div>\n    <div class=\"modal-body\" id=\"modal-body\">\n        You are about to delete the team <strong>{{$ctrl.resolve.teamName}}</strong>.\n    </div>\n    <div class=\"modal-footer\">\n        <button class=\"button cancel\" type=\"button\" ng-click=\"$ctrl.dismiss()\">Cancel</button>\n        <button class=\"button continue primary\" type=\"button\" focus-on=\"true\" ng-click=\"$ctrl.close({$value: true})\">Delete</button>\n    </div>\n";
var DeleteTeamModal = {
  bindings: {
    resolve: '<',
    close: '&',
    dismiss: '&'
  },
  template: template
};
angular.module('xlrelease').component('deleteTeamModal', DeleteTeamModal);

/***/ }),

/***/ 1932:
/***/ (function(module, exports) {

var template = "\n        <div class=\"delete-comment-modal\">\n       <div class=\"modal-header\">\n               <h4 class=\"modal-title pull-left\" id=\"modal-title\">Delete comment</h4>\n               <button type=\"button\" class=\"close pull-right\" ng-click=\"$ctrl.close()\"><i class=\"xl-icon close-icon\"></i></button>\n               <div class=\"clearfix\"></div>\n       </div>\n        <div class=\"modal-body\">\n            <b> Are you sure you want to delete this comment?</b>\n            <div class=\"delete-comment-view\">\n                <i class=\"xl-icon user-icon\"></i>\n                <strong ng-if=\"$ctrl.resolve.comment.author.username\" display-user=\"$ctrl.resolve.comment.author\"></strong>\n                <strong ng-if=\"!$ctrl.resolve.comment.author.username\">SYSTEM</strong>\n                <span class=\"delete-comment-date-format\">{{$ctrl.resolve.comment.date | date:'mediumDate'}} at {{$ctrl.resolve.comment.date | date:'shortTime'}}</span><br/>\n                <span class=\"delete-comment-text-modal\" markdown> <span ng-bind-html=\"$ctrl.resolve.comment.text | markdown\" class=\"markdown\"></span></span>\n            </div>\n        </div>\n         <div class=\"modal-footer\">\n                <button class=\"button cancel\" type=\"button\" ng-click=\"$ctrl.dismiss()\">Cancel</button>\n                <button class=\"button continue primary\" type=\"button\" focus-on=\"true\" ng-click=\"$ctrl.close({$value: true})\">Delete</button>\n         </div>\n         </div>\n     ";
var DeleteCommentOfTaskModal = {
  bindings: {
    resolve: '<',
    close: '&',
    dismiss: '&'
  },
  template: template
};
angular.module('xlrelease').component('deleteCommentOfTaskModal', DeleteCommentOfTaskModal);

/***/ }),

/***/ 1933:
/***/ (function(module, exports) {

var template = "\n    <div class=\"xl-icon risk-flag-icon dropdown-button {{ $ctrl.flag | lowercase }}\"\n         bs-popover data-content-template=\"static/10.2.14/xlr-components/flag-picker-component/flag-picker-popover-partial.html\" data-placement=\"bottom\" auto-close=\"true\">     \n    </div>\n    ";
var FlagPickerComponent = {
  bindings: {
    flag: '<',
    onUpdate: '&'
  },
  template: template
};
angular.module('xlrelease').component('flagPicker', FlagPickerComponent);

/***/ }),

/***/ 1934:
/***/ (function(module, exports) {

var template = "\n<div id=\"actions-container\">\n    <ul role=\"list\">\n        <li role=\"listitem\"><a class=\"action\" ng-click=\"$ctrl.removeHelpPopover()\" ng-href=\"{{ $ctrl.documentationURL }}\" target=\"_blank\" rel=\"noopener\" aria-describedby=\"new-tab\">Online documentation</a></li>\n        <li role=\"listitem\"><a class=\"action\" ng-click=\"$ctrl.removeHelpPopover()\" href=\"https://docs.xebialabs.com/xl-release/support-request.html\" target=\"_blank\" rel=\"noopener\" aria-describedby=\"new-tab\">Submit a support request</a></li>\n        <li role=\"listitem\"><a class=\"action\" ng-click=\"$ctrl.removeHelpPopover()\" href=\"https://docs.xebialabs.com/xl-release/suggest-feature.html\" target=\"_blank\" rel=\"noopener\" aria-describedby=\"new-tab\">Suggest a feature</a></li>        \n        <li role=\"listitem\"><a class=\"action\" ng-click=\"$ctrl.removeHelpPopover()\" href=\"https://digital.ai/\" target=\"_blank\" rel=\"noopener\" aria-describedby=\"new-tab\">Digital.ai website</a></li>\n    </ul>    \n</div>\n";

var controller = function controller($uibModal, Doc) {
  var $ctrl = this;
  $ctrl.documentationURL = Doc.getURL();

  $ctrl.removeHelpPopover = function () {
    angular.element('.helpPopover').click();
  };
};

controller.$inject = ['$uibModal', 'Doc'];
var helpPopoverComponent = {
  template: template,
  controller: controller
};
angular.module('xlrelease').component('helpPopover', helpPopoverComponent);

/***/ }),

/***/ 1935:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').directive('xlrMultilevelSubmenu', ['$window', function ($window) {
  return {
    scope: {
      isClosed: '<',
      level: '@',
      onClick: '&'
    },
    restrict: 'E',
    templateUrl: 'static/10.2.14/xlr-components/multilevel-dropdown/multilevel-submenu-partial.html',
    link: function link(scope, element, attr) {
      var subscribe = function subscribe() {
        var items = contextMenu.find('.xlr-ctx-menu-item');

        if (items.length) {
          items.off('mouseenter').on('mouseenter', onMouseEnter(container, $window));
        }
      };

      var unsubscribe = function unsubscribe() {
        var items = contextMenu.find('.xlr-ctx-menu-item');

        if (items.length) {
          items.off('mouseenter');
        }
      };

      scope.items = scope.$eval(attr.items);
      scope.level = scope.$eval(attr.level) || 1; // [div.xlr-ctx-menu-container] > [ul.xlr-ctx-menu] > [li.xlr-ctx-menu-item] > [xlr-submenu]

      var contextMenuItem = element.parent();
      var contextMenu = contextMenuItem.parent();
      var container = contextMenu.parent();

      if (container.length) {
        subscribe();
        var contentId = attr.contentId;
        contextMenuItem.attr('data-content-id', contentId);
        var content = element.children();
        content.attr('data-level', scope.level);
        content.attr('data-id', contentId);
        container.append(content);
      }

      element.remove();
      scope.$watch('isClosed', function (isClosed) {
        if (isClosed) {
          resetActiveElements(container, 0);
        }
      });
      scope.$on('$destroy', unsubscribe);
    }
  };
}]);

function onMouseEnter($container, $window) {
  return function (event) {
    var $li = angular.element(event.currentTarget);
    var $ul = $li.parent();
    var level = $ul.data('level') || 0;
    resetActiveElements($container, level);
    var contentId = $li.data('content-id');

    if (contentId) {
      var $contextMenu = $container.find("ul[data-id=\"".concat(contentId, "\"]"));

      if ($contextMenu.length) {
        $li.addClass('active');
        $contextMenu.addClass('active');

        var _getContentCoords = getContentCoords($li, $ul, $contextMenu, $window),
            top = _getContentCoords.top,
            left = _getContentCoords.left;

        $contextMenu.css({
          top: "".concat(top, "px"),
          left: "".concat(left, "px")
        });
      }
    }
  };
}

function getContentCoords($li, $ul, $contextMenu, $window) {
  var ulPaddingTop = parseInt($ul.css('padding-top'), 10);
  var ulBorderTop = parseInt($ul.css('border-top-width'), 10);
  var ulBorderLeft = parseInt($ul.css('border-left-width'), 10);
  var top = $ul.position().top + $li.position().top - ulPaddingTop + ulBorderTop - 1;
  var left = $ul.position().left + $li.position().left + $li.width() + ulBorderLeft;

  if ($li.offset().top + $contextMenu.height() > $window.innerHeight) {
    top = top - $contextMenu.height() + $li.height();
  }

  return {
    top: top,
    left: left
  };
}

function resetActiveElements(contentContainer, level) {
  var lis = level ? contentContainer.find("ul.xlr-ctx-menu[data-level=\"".concat(level, "\"] li")) : contentContainer.find("ul.xlr-ctx-menu li");
  lis.removeClass('active');
  contentContainer.find("ul.xlr-ctx-menu[data-level=\"".concat(level + 1, "\"]")).removeClass('active');
  contentContainer.find("ul.xlr-ctx-menu[data-level=\"".concat(level + 2, "\"]")).removeClass('active');
}

/***/ }),

/***/ 1936:
/***/ (function(module, exports) {

var template = "\n    <div class=\"modal-header\">\n        <h4 class=\"modal-title pull-left\" id=\"modal-title\">Override permissions</h4>\n        <button type=\"button\" class=\"close pull-right\" ng-click=\"$ctrl.close()\"><i class=\"xl-icon close-icon\"></i></button>\n        <div class=\"clearfix\"></div>\n    </div>\n    <div class=\"modal-body\" id=\"modal-body\">\n        Permissions and teams will now be taken from <b>{{$ctrl.resolve.inheritedFrom.title}}</b>. Current teams and permissions will be discarded.<br/>\n    </div>\n    <div class=\"modal-footer\">\n        <button class=\"button cancel\" type=\"button\" ng-click=\"$ctrl.dismiss()\">Cancel</button>\n        <button class=\"button continue primary\" type=\"button\" ng-click=\"$ctrl.close({$value: true})\">Ok</button>\n    </div>\n";
var overridePermissionsModal = {
  bindings: {
    resolve: '<',
    close: '&',
    dismiss: '&'
  },
  template: template
};
angular.module('xlrelease').component('overridePermissionsModal', overridePermissionsModal);

/***/ }),

/***/ 1937:
/***/ (function(module, exports) {

var template = "\n<div id=\"actions-container\" style=\"right:0\">\n    <ul>        \n        <li ng-if=\"$ctrl.isAdmin()\"><a class=\"action\" href ng-click=\"$ctrl.getSupportData()\">Get data for support</a></li>\n        <li ng-if=\"$ctrl.isAdmin()\"><a class=\"action\" href ng-click=\"$ctrl.showSystemInformation()\">System information</a></li>\n        <li ng-if=\"$ctrl.isAdmin()\"><a class=\"action\" href ng-click=\"$ctrl.configureSystemMessage()\">Configure system message</a></li>\n        <li ng-if=\"$ctrl.isAdmin()\"><a class=\"action\" ng-click=\"$ctrl.removeSettingPopover()\" ng-href=\"#/task-manager\">Task Manager</a></li>\n        <li ng-if=\"$ctrl.isAdmin()\"><a class=\"action\" ng-click=\"$ctrl.removeSettingPopover()\" href=\"productregistration\">Renew license</a></li>\n        <li class=\"about\"><a class=\"action\" href ng-click=\"$ctrl.openAbout()\">About</a></li>\n        <li class=\"divider\"><a class=\"logout action\" ng-click=\"$ctrl.removeSettingPopover()\" ng-href=\"#/login\">Log out</a></li>\n    </ul>\n</div>\n";

var controller = function controller($uibModal, Authenticator, $rootScope, Events) {
  var $ctrl = this;

  $ctrl.isAdmin = function () {
    return Authenticator.isAdminOr();
  };

  $ctrl.showSystemInformation = function () {
    $ctrl.removeSettingPopover();
    $uibModal.open({
      animation: false,
      component: 'systemInformationModal'
    });
  };

  $ctrl.getSupportData = function () {
    $ctrl.removeSettingPopover();
    $uibModal.open({
      animation: false,
      component: 'supportAcceleratorModal'
    });
  };

  $ctrl.openAbout = function () {
    $ctrl.removeSettingPopover();
    $uibModal.open({
      animation: false,
      controller: 'LicenseController',
      templateUrl: 'partials/menu/about.html'
    });
  };

  $ctrl.configureSystemMessage = function () {
    $ctrl.removeSettingPopover();
    $uibModal.open({
      animation: false,
      component: 'systemMessageModal'
    }).result.then(function (systemMessage) {
      $rootScope.$emit(Events.settings.systemMessageUpdated, systemMessage);
    });
  };

  $ctrl.removeSettingPopover = function () {
    angular.element('.settingPopover').click();
  };
};

controller.$inject = ['$uibModal', 'Authenticator', '$rootScope', 'Events'];
var settingsPopoverComponent = {
  template: template,
  controller: controller
};
angular.module('xlrelease').component('settingsPopover', settingsPopoverComponent);

/***/ }),

/***/ 1938:
/***/ (function(module, exports) {

var template = "\n<div class=\"modal-header\">\n    <button type=\"button\" class=\"close\" ng-click=\"$ctrl.dismiss()\"><i class=\"xl-icon close-icon\"></i></button>\n    <h5 class=\"modal-title\">Get data for support</h5>  \n</div>\n<div class=\"modal-body\">\n    <p>When you click <b>Download</b>, Digital.ai Release will create a support analytics ZIP file that you can send to Digital.ai Support when troubleshooting issues. The file \n    contains information about your Release installation, including the contents of the conf, ext, plugins, hotfix, and log directories.</p>\n    \n    <p>Digital.ai Release will attempt to remove configuration passwords from the ZIP file. Please inspect the ZIP file contents to ensure that it does not contain \n    passwords or other sensitive data.</p>\n    \n    <p>See <a href=\"https://support.digital.ai/\" target=\"_blank\" rel=\"noopener\">https://support.digital.ai</a> for more information or to open a support request.</p>\n</div>\n<div class=\"modal-footer\">\n    <button class=\"button primary\" ng-click=\"$ctrl.getSupportData()\">Download</button>\n</div>\n";

var controller = function controller(Download) {
  var $ctrl = this;

  $ctrl.getSupportData = function () {
    Download.launch('support/zip');
    $ctrl.close();
  };
};

controller.$inject = ['Download'];
var SupportAcceleratorModalComponent = {
  template: template,
  bindings: {
    close: '&',
    dismiss: '&'
  },
  controller: controller
};
angular.module('xlrelease').component('supportAcceleratorModal', SupportAcceleratorModalComponent);

/***/ }),

/***/ 1939:
/***/ (function(module, exports) {

angular.module('xlrelease').component('xlrTemplateListComponent', {
  bindings: {
    list: '<',
    templatesLoader: '<',
    onChange: '&',
    responsive: '<?',
    folders: '<'
  },
  bindToController: true,
  controllerAs: 'vm',
  templateUrl: 'static/10.2.14/xlr-components/template-list-component/template-list-partial.html'
});

/***/ }),

/***/ 196:
/***/ (function(module, exports) {

module.exports = jQuery;

/***/ }),

/***/ 207:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, "a", function() { return /* binding */ no_data_NoData; });

// EXTERNAL MODULE: external "React"
var external_React_ = __webpack_require__(0);
var external_React_default = /*#__PURE__*/__webpack_require__.n(external_React_);

// EXTERNAL MODULE: ./node_modules/prop-types/index.js
var prop_types = __webpack_require__(2);

// EXTERNAL MODULE: ./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js
var injectStylesIntoStyleTag = __webpack_require__(9);
var injectStylesIntoStyleTag_default = /*#__PURE__*/__webpack_require__.n(injectStylesIntoStyleTag);

// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./core/xlr-ui/app/react/components/no-data/no-data.less
var no_data = __webpack_require__(282);
var no_data_default = /*#__PURE__*/__webpack_require__.n(no_data);

// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/no-data/no-data.less

            

var options = {};

options.insert = "head";
options.singleton = false;

var update = injectStylesIntoStyleTag_default()(no_data_default.a, options);



/* harmony default export */ var no_data_no_data = (no_data_default.a.locals || {});
// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/no-data/no-data.js



var no_data_NoData = function NoData(_ref) {
  var className = _ref.className,
      message = _ref.message;
  return /*#__PURE__*/external_React_default.a.createElement("div", {
    className: 'no-data-message' + (className ? " ".concat(className) : '')
  }, message);
};

/***/ }),

/***/ 21:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return primaryColors; });
/* unused harmony export rgbToHexString */
/* unused harmony export hexToRgb */
/* unused harmony export hexToRgbString */
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__);


function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var primaryColors = {
  blue: '#0079BC',
  green: '#498500',
  red: '#CC4A3C',
  orange: '#FFAB00',
  purple: '#991C71',
  yellow: '#FCD866'
};
/* harmony default export */ __webpack_exports__["a"] = (_objectSpread(_objectSpread({}, primaryColors), {}, {
  // SECONDARY COLORS
  xldblue: '#14B0E4',
  lightblue: '#5FCBF4',
  darkblue: '#4C6C87',
  // SHADES OF GRAY
  black: '#414C58',
  antracite: '#495561',
  gray: '#65747C',
  lightgray: '#ADB9C3',
  background: '#F3F5F8',
  silver: '#F8F9FA',
  white: '#FFFFFF',
  // Semantic COLORS
  oddRowColor: '#FFFFFF',
  evenRowColor: '#F8F9FA',
  hoverColor: '#F3F5F8',
  selectedColor: '#E3E8Ef',
  highlightColor: '#CDEFDC',
  successBackground: '#E6F3EE',
  successHover: '#F6D2CE',
  warningBackground: '#FFF6E9',
  warningHover: '#FFE2C3',
  errorBackground: '#F7E4E2',
  errorHover: '#C1EBD4'
}));
function rgbToHexString(r, g, b) {
  return '#' + ((1 << 24) + (r << 16) + (g << 8) + b).toString(16).slice(1);
}
function hexToRgb(hex) {
  // Expand shorthand form (e.g. "03F") to full form (e.g. "0033FF")
  var shorthandRegex = /^#?([a-f\d])([a-f\d])([a-f\d])$/i;
  hex = hex.replace(shorthandRegex, function (m, r, g, b) {
    return r + r + g + g + b + b;
  });
  var result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);
  return result ? {
    r: parseInt(result[1], 16),
    g: parseInt(result[2], 16),
    b: parseInt(result[3], 16)
  } : null;
}
function hexToRgbString(hex) {
  var rgbObject = hexToRgb(hex);
  return "rgb(".concat(rgbObject.r, ", ").concat(rgbObject.g, ", ").concat(rgbObject.b, ")");
}

/***/ }),

/***/ 210:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return showError; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return showServerDownError; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return AlertsFactory; });
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(40);
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash_get__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash_isFunction__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(97);
/* harmony import */ var lodash_isFunction__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash_isFunction__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_util_toastrFactory__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(46);
/* harmony import */ var pluralize__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(55);
/* harmony import */ var pluralize__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(pluralize__WEBPACK_IMPORTED_MODULE_3__);





function getResponseData(response) {
  var contentType = getHeader(response, 'content-type');

  if (contentType && !contentType.includes('text/html')) {
    if (response.data instanceof Blob) {
      return 'Requested file is not found';
    }

    if (getHeader(response, 'x-validation-exception', "false") === "true") {
      return extractValidationMessages(response);
    }

    return response.data;
  }

  return '';
}

function extractValidationMessages(response) {
  var validationMessages = response.data["validation-messages"];
  var messages = validationMessages.map(function (item) {
    return "<p>".concat(item.message, "</p>");
  });
  return "There ".concat(pluralize__WEBPACK_IMPORTED_MODULE_3___default()('was', validationMessages.length), " ").concat(validationMessages.length, " validation ").concat(pluralize__WEBPACK_IMPORTED_MODULE_3___default()('error', validationMessages.length), ". ").concat(messages.join(""));
}

function getHeader(response, headerName) {
  var defaultVal = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : '';

  //we need this logic because we are still using different approaches to call a server
  if (lodash_isFunction__WEBPACK_IMPORTED_MODULE_1___default()(response.headers)) {
    //this is true for calls from $http
    return lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(response.headers(), headerName, defaultVal);
  } else {
    return lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(response.headers, headerName, defaultVal); //this is true for calls from axios
  }
}

function getAlertMsg(response) {
  var responseData = _.escape(getResponseData(response));

  var path = _.escape(getHeader(response, 'x-path', response.config.url));

  var date = _.escape(getHeader(response, 'date'));

  return "\n        <div class='alert-details'>\n            <p>".concat(responseData, "</p>\n            <p>Status code: ").concat(response.status, "</p>\n            <p><strong>").concat(response.config.method, " ").concat(path, "</strong></p>\n            <p>").concat(date, "</p>\n        </div>").split('\n').join('');
}

var toaster = Object(_js_util_toastrFactory__WEBPACK_IMPORTED_MODULE_2__[/* default */ "a"])();
function showError(response) {
  if (response.status === 409) {
    toaster.conflict(getAlertMsg(response), {
      escapeHtml: false
    });
  } else {
    toaster.error(getAlertMsg(response), 'An error occurred', {
      escapeHtml: false
    });
  }
}
function showServerDownError() {
  toaster.error('The Release server is not available', 'An error occurred');
}
function AlertsFactory() {
  return {
    error: showError,
    serverDownError: showServerDownError
  };
}

/***/ }),

/***/ 2161:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9);
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_mini_css_extract_plugin_dist_loader_js_node_modules_css_loader_dist_cjs_js_node_modules_less_loader_dist_cjs_js_xlrelease_less__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(809);
/* harmony import */ var _node_modules_mini_css_extract_plugin_dist_loader_js_node_modules_css_loader_dist_cjs_js_node_modules_less_loader_dist_cjs_js_xlrelease_less__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_mini_css_extract_plugin_dist_loader_js_node_modules_css_loader_dist_cjs_js_node_modules_less_loader_dist_cjs_js_xlrelease_less__WEBPACK_IMPORTED_MODULE_1__);

            

var options = {};

options.insert = "head";
options.singleton = false;

var update = _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_mini_css_extract_plugin_dist_loader_js_node_modules_css_loader_dist_cjs_js_node_modules_less_loader_dist_cjs_js_xlrelease_less__WEBPACK_IMPORTED_MODULE_1___default.a, options);



/* harmony default export */ __webpack_exports__["default"] = (_node_modules_mini_css_extract_plugin_dist_loader_js_node_modules_css_loader_dist_cjs_js_node_modules_less_loader_dist_cjs_js_xlrelease_less__WEBPACK_IMPORTED_MODULE_1___default.a.locals || {});

/***/ }),

/***/ 236:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return fetchTimeline; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return fetchDelivery; });
/* harmony import */ var _core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(16);

var RELEASE_DELIVERY_API = 'api/v1/deliveries';
var fetchTimeline = function fetchTimeline(deliveryId) {
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_0__[/* httpGET */ "c"])("".concat(RELEASE_DELIVERY_API, "/").concat(deliveryId, "/timeline"));
};
var fetchDelivery = function fetchDelivery(deliveryId) {
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_0__[/* httpGET */ "c"])("".concat(RELEASE_DELIVERY_API, "/").concat(deliveryId));
};

/***/ }),

/***/ 24:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, "a", function() { return /* reexport */ alert_message_AlertMessage; });
__webpack_require__.d(__webpack_exports__, "z", function() { return /* reexport */ alert_message_alertType; });
__webpack_require__.d(__webpack_exports__, "x", function() { return /* reexport */ delete_component_XlrDeleteButton; });
__webpack_require__.d(__webpack_exports__, "j", function() { return /* reexport */ help_block_HelpBlock; });
__webpack_require__.d(__webpack_exports__, "k", function() { return /* reexport */ no_data["a" /* NoData */]; });
__webpack_require__.d(__webpack_exports__, "m", function() { return /* reexport */ popup_Popup; });
__webpack_require__.d(__webpack_exports__, "p", function() { return /* reexport */ release_list_component_ReleaseListComponent; });
__webpack_require__.d(__webpack_exports__, "s", function() { return /* reexport */ release_status_component_ReleaseStatusComponent; });
__webpack_require__.d(__webpack_exports__, "l", function() { return /* reexport */ release_list_const["a" /* OrderConst */]; });
__webpack_require__.d(__webpack_exports__, "o", function() { return /* reexport */ ReleaseFlagComponent; });
__webpack_require__.d(__webpack_exports__, "r", function() { return /* reexport */ ReleaseRiskStatusIconComponent_ReleaseRiskStatusIconComponent; });
__webpack_require__.d(__webpack_exports__, "h", function() { return /* reexport */ inline_edit_EditableLabel; });
__webpack_require__.d(__webpack_exports__, "n", function() { return /* reexport */ release_count_component_ReleaseCountComponent; });
__webpack_require__.d(__webpack_exports__, "c", function() { return /* reexport */ button_with_popover_component_ButtonWithPopoverComponent; });
__webpack_require__.d(__webpack_exports__, "e", function() { return /* reexport */ context_menu_component_ContextMenuComponent; });
__webpack_require__.d(__webpack_exports__, "g", function() { return /* reexport */ doc_link_component["a" /* DocLinkComponent */]; });
__webpack_require__.d(__webpack_exports__, "t", function() { return /* reexport */ select_tree_component_SelectTreeComponent; });
__webpack_require__.d(__webpack_exports__, "y", function() { return /* reexport */ xlr_members_tags_component_XlrMembersTags; });
__webpack_require__.d(__webpack_exports__, "q", function() { return /* reexport */ release_progress_component["a" /* ReleaseProgressComponent */]; });
__webpack_require__.d(__webpack_exports__, "f", function() { return /* reexport */ display_variable_component_DisplayVariable; });
__webpack_require__.d(__webpack_exports__, "u", function() { return /* reexport */ TextAreaPassword_TextAreaPassword; });
__webpack_require__.d(__webpack_exports__, "v", function() { return /* reexport */ TextAreaPasswordEditMode_TextAreaPasswordEditMode; });
__webpack_require__.d(__webpack_exports__, "i", function() { return /* reexport */ folder_header_component_FolderHeader; });
__webpack_require__.d(__webpack_exports__, "d", function() { return /* reexport */ confirmation_dialog_component_ConfirmationDialog; });
__webpack_require__.d(__webpack_exports__, "w", function() { return /* reexport */ toggle_component_ToggleComponent; });
__webpack_require__.d(__webpack_exports__, "b", function() { return /* reexport */ avatar_component_AvatarComponent; });

// UNUSED EXPORTS: ReleaseCountResults, InfiniteListComponent, XlrTags, FolderDetails

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/classCallCheck.js
var classCallCheck = __webpack_require__(4);
var classCallCheck_default = /*#__PURE__*/__webpack_require__.n(classCallCheck);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/createClass.js
var createClass = __webpack_require__(5);
var createClass_default = /*#__PURE__*/__webpack_require__.n(createClass);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/assertThisInitialized.js
var assertThisInitialized = __webpack_require__(6);
var assertThisInitialized_default = /*#__PURE__*/__webpack_require__.n(assertThisInitialized);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/inherits.js
var inherits = __webpack_require__(11);
var inherits_default = /*#__PURE__*/__webpack_require__.n(inherits);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/possibleConstructorReturn.js
var possibleConstructorReturn = __webpack_require__(10);
var possibleConstructorReturn_default = /*#__PURE__*/__webpack_require__.n(possibleConstructorReturn);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/getPrototypeOf.js
var getPrototypeOf = __webpack_require__(8);
var getPrototypeOf_default = /*#__PURE__*/__webpack_require__.n(getPrototypeOf);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/defineProperty.js
var defineProperty = __webpack_require__(1);
var defineProperty_default = /*#__PURE__*/__webpack_require__.n(defineProperty);

// EXTERNAL MODULE: external "React"
var external_React_ = __webpack_require__(0);
var external_React_default = /*#__PURE__*/__webpack_require__.n(external_React_);

// EXTERNAL MODULE: ./node_modules/prop-types/index.js
var prop_types = __webpack_require__(2);
var prop_types_default = /*#__PURE__*/__webpack_require__.n(prop_types);

// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/alert-message/alert-message.js








function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }



var alert_message_alertType = {
  INFO: 'info',
  WARNING: 'warning'
};
var alert_message_AlertMessage = /*#__PURE__*/function (_PureComponent) {
  inherits_default()(AlertMessage, _PureComponent);

  var _super = _createSuper(AlertMessage);

  function AlertMessage() {
    var _this;

    classCallCheck_default()(this, AlertMessage);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    defineProperty_default()(assertThisInitialized_default()(_this), "alertIconsClasses", {
      'info': 'info-icon',
      'warning': 'warning-icon'
    });

    return _this;
  }

  createClass_default()(AlertMessage, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          children = _this$props.children,
          alertType = _this$props.alertType;
      var alertClass = "xlr-alert-".concat(alertType);
      var iconClass = "xl-icon ".concat(this.alertIconsClasses[alertType], " icon-l");
      return /*#__PURE__*/external_React_default.a.createElement("div", {
        className: alertClass
      }, /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "icon"
      }, /*#__PURE__*/external_React_default.a.createElement("i", {
        className: iconClass
      })), /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "message"
      }, children));
    }
  }]);

  return AlertMessage;
}(external_React_["PureComponent"]);
// EXTERNAL MODULE: ./node_modules/xl-react-components/dist/index.js
var dist = __webpack_require__(14);

// EXTERNAL MODULE: ./core/xlr-ui/app/react/constants/key-codes.js
var key_codes = __webpack_require__(43);

// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/delete/delete.component.js








function delete_component_createSuper(Derived) { var hasNativeReflectConstruct = delete_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function delete_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }





var delete_component_XlrDeleteButton = /*#__PURE__*/function (_Component) {
  inherits_default()(XlrDeleteButton, _Component);

  var _super = delete_component_createSuper(XlrDeleteButton);

  function XlrDeleteButton(props) {
    var _this;

    classCallCheck_default()(this, XlrDeleteButton);

    _this = _super.call(this, props);

    defineProperty_default()(assertThisInitialized_default()(_this), "delete", function (action) {
      var item = _this.props.item;

      if (action === deleteButton.action) {
        _this.props.onDelete(item);
      }

      _this.setState({
        deleteModalIsOpen: false
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "showDeleteModal", function () {
      return _this.setState({
        deleteModalIsOpen: true
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "_handleKeyDown", function (e) {
      if (e.key === 'Enter') {
        _this.showDeleteModal();
      }
    });

    _this.state = {
      deleteModalIsOpen: false
    };
    return _this;
  }

  createClass_default()(XlrDeleteButton, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          modalHeader = _this$props.modalHeader,
          renderModalBodyFn = _this$props.renderModalBodyFn;
      var deleteModalIsOpen = this.state.deleteModalIsOpen;
      var title = /*#__PURE__*/external_React_default.a.createElement(external_React_default.a.Fragment, null, modalHeader);
      return /*#__PURE__*/external_React_default.a.createElement("span", null, /*#__PURE__*/external_React_default.a.createElement("span", {
        className: "link delete",
        onClick: this.showDeleteModal,
        onKeyDown: this._handleKeyDown
      }, /*#__PURE__*/external_React_default.a.createElement("i", {
        className: "menu-item-icon xl-icon delete-icon",
        title: "Delete"
      }), /*#__PURE__*/external_React_default.a.createElement("span", {
        className: "action-label"
      }, deleteButton.label)), /*#__PURE__*/external_React_default.a.createElement(dist["XlReactWidgetConfirmationDialog"], {
        buttons: [delete_component_cancelButton, deleteButton],
        dialogClassName: "xl-default-modal no-cross",
        onButtonClick: this.delete,
        show: deleteModalIsOpen,
        title: title
      }, renderModalBodyFn()));
    }
  }]);

  return XlrDeleteButton;
}(external_React_["Component"]);
var deleteButton = {
  action: 'delete',
  className: 'button primary',
  keyCodes: [key_codes["a" /* keyCodes */].ENTER, key_codes["a" /* keyCodes */].DELETE],
  label: 'Delete'
};
var delete_component_cancelButton = {
  action: 'cancel',
  className: 'button cancel',
  keyCodes: [key_codes["a" /* keyCodes */].ESC],
  label: 'Cancel'
};
// EXTERNAL MODULE: ./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js
var injectStylesIntoStyleTag = __webpack_require__(9);
var injectStylesIntoStyleTag_default = /*#__PURE__*/__webpack_require__.n(injectStylesIntoStyleTag);

// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./core/xlr-ui/app/react/components/help-block/help-block.less
var help_block = __webpack_require__(281);
var help_block_default = /*#__PURE__*/__webpack_require__.n(help_block);

// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/help-block/help-block.less

            

var options = {};

options.insert = "head";
options.singleton = false;

var update = injectStylesIntoStyleTag_default()(help_block_default.a, options);



/* harmony default export */ var help_block_help_block = (help_block_default.a.locals || {});
// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/help-block/help-block.js



var help_block_HelpBlock = function HelpBlock(_ref) {
  var className = _ref.className,
      children = _ref.children;
  return /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "help-block-component ".concat(className)
  }, children);
};
help_block_HelpBlock.defaultProps = {
  className: ''
};
// EXTERNAL MODULE: ./core/xlr-ui/app/react/components/no-data/no-data.js + 1 modules
var no_data = __webpack_require__(207);

// EXTERNAL MODULE: external "ReactDOM"
var external_ReactDOM_ = __webpack_require__(31);
var external_ReactDOM_default = /*#__PURE__*/__webpack_require__.n(external_ReactDOM_);

// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/popup/click-outside.decorator.js







function click_outside_decorator_createSuper(Derived) { var hasNativeReflectConstruct = click_outside_decorator_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function click_outside_decorator_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/* global document */




function clickOutside() {
  return function (WrappedComponent) {
    return /*#__PURE__*/function (_Component) {
      inherits_default()(WithClickOutside, _Component);

      var _super = click_outside_decorator_createSuper(WithClickOutside);

      function WithClickOutside(props) {
        var _this;

        classCallCheck_default()(this, WithClickOutside);

        _this = _super.call(this, props);
        _this.mounted = true;
        _this.handleDocumentClick = _this.handleDocumentClick.bind(assertThisInitialized_default()(_this));
        return _this;
      }

      createClass_default()(WithClickOutside, [{
        key: "componentDidMount",
        value: function componentDidMount() {
          document.addEventListener('click', this.handleDocumentClick, false);
          document.addEventListener('touchend', this.handleDocumentClick, false);
        }
      }, {
        key: "componentWillUnmount",
        value: function componentWillUnmount() {
          this.mounted = false;
          document.removeEventListener('click', this.handleDocumentClick, false);
          document.removeEventListener('touchend', this.handleDocumentClick, false);
        }
      }, {
        key: "handleDocumentClick",
        value: function handleDocumentClick(event) {
          if (this.mounted && this.props.enable) {
            /* eslint-disable react/no-find-dom-node */
            if (!external_ReactDOM_default.a.findDOMNode(this).contains(event.target)) {
              if (this.props.onClickOutside) {
                this.props.onClickOutside();
              }
            }
          }
        }
      }, {
        key: "render",
        value: function render() {
          return /*#__PURE__*/external_React_default.a.createElement(WrappedComponent, this.props);
        }
      }], [{
        key: "propTypes",
        get: function get() {
          return {
            enable: prop_types_default.a.bool,
            onClickOutside: prop_types_default.a.func.isRequired
          };
        }
      }, {
        key: "defaultProps",
        get: function get() {
          return {
            enable: true
          };
        }
      }]);

      return WithClickOutside;
    }(external_React_["Component"]);
  };
}

/* harmony default export */ var click_outside_decorator = (clickOutside);
// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./core/xlr-ui/app/react/components/popup/popup.less
var popup = __webpack_require__(283);
var popup_default = /*#__PURE__*/__webpack_require__.n(popup);

// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/popup/popup.less

            

var popup_options = {};

popup_options.insert = "head";
popup_options.singleton = false;

var popup_update = injectStylesIntoStyleTag_default()(popup_default.a, popup_options);



/* harmony default export */ var popup_popup = (popup_default.a.locals || {});
// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/popup/popup-trigger.js




var popup_trigger_PopupTrigger = function PopupTrigger(props) {
  return /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "popup__trigger"
  }, /*#__PURE__*/external_React_default.a.createElement("i", {
    className: "xl-icon options-icon remove-outline",
    onClick: props.onClick,
    role: "button",
    tabIndex: -1
  }), props.children);
};

/* harmony default export */ var popup_trigger = (popup_trigger_PopupTrigger);
// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/popup/popup.js








function popup_createSuper(Derived) { var hasNativeReflectConstruct = popup_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function popup_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }






var Trigger = click_outside_decorator()(popup_trigger);
var popup_Popup = /*#__PURE__*/function (_Component) {
  inherits_default()(Popup, _Component);

  var _super = popup_createSuper(Popup);

  function Popup(props) {
    var _this;

    classCallCheck_default()(this, Popup);

    _this = _super.call(this, props);

    defineProperty_default()(assertThisInitialized_default()(_this), "onClickOutside", function () {
      var onStateChange = _this.props.onStateChange;

      _this.setState({
        isOpen: false
      });

      if (onStateChange) {
        onStateChange(false);
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "toggleDropdown", function (e) {
      e.stopPropagation();
      var onStateChange = _this.props.onStateChange;
      var state = !_this.state.isOpen;

      _this.setState({
        isOpen: state
      });

      if (onStateChange) {
        onStateChange(state);
      }
    });

    _this.state = {
      isOpen: false
    };
    return _this;
  }

  createClass_default()(Popup, [{
    key: "render",
    value: function render() {
      return /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "popup__container ".concat(this.state.isOpen ? 'popup--expanded' : '')
      }, /*#__PURE__*/external_React_default.a.createElement(Trigger, {
        enable: this.state.isOpen,
        onClick: this.toggleDropdown,
        onClickOutside: this.onClickOutside
      }, /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "popup__content ".concat(this.state.isOpen ? 'popup__content--open' : ''),
        role: "presentation"
      }, this.props.children)));
    }
  }]);

  return Popup;
}(external_React_["Component"]);
// EXTERNAL MODULE: ./core/xlr-ui/app/react/components/release-list/const/index.js
var release_list_const = __webpack_require__(57);

// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./core/xlr-ui/app/react/components/release-list/release-list-common.component.less
var release_list_common_component = __webpack_require__(284);
var release_list_common_component_default = /*#__PURE__*/__webpack_require__.n(release_list_common_component);

// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/release-list/release-list-common.component.less

            

var release_list_common_component_options = {};

release_list_common_component_options.insert = "head";
release_list_common_component_options.singleton = false;

var release_list_common_component_update = injectStylesIntoStyleTag_default()(release_list_common_component_default.a, release_list_common_component_options);



/* harmony default export */ var release_list_release_list_common_component = (release_list_common_component_default.a.locals || {});
// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/release-list/release-header-label.component.js








function release_header_label_component_createSuper(Derived) { var hasNativeReflectConstruct = release_header_label_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function release_header_label_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }





var release_header_label_component_ReleaseHeaderLabelComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(ReleaseHeaderLabelComponent, _Component);

  var _super = release_header_label_component_createSuper(ReleaseHeaderLabelComponent);

  function ReleaseHeaderLabelComponent() {
    var _this;

    classCallCheck_default()(this, ReleaseHeaderLabelComponent);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    defineProperty_default()(assertThisInitialized_default()(_this), "onOrderChange", function (column) {
      if (column.sortable) {
        _this.props.onOrderChange(column);
      }
    });

    return _this;
  }

  createClass_default()(ReleaseHeaderLabelComponent, [{
    key: "render",
    value: function render() {
      var _this2 = this;

      var header = this.props.header;
      var headerRow = header.map(function (column) {
        var className = column.sortable ? 'sortable' : '';
        return /*#__PURE__*/external_React_default.a.createElement("div", {
          className: "release-row-view-column ".concat(column.class, " ").concat(className),
          key: column.fieldName,
          onClick: function onClick() {
            return _this2.onOrderChange(column);
          }
        }, column.label, /*#__PURE__*/external_React_default.a.createElement("div", {
          className: "order-icons"
        }, (column.order === release_list_const["a" /* OrderConst */].SORT_DESC || column.order === release_list_const["a" /* OrderConst */].SORT_NONE) && /*#__PURE__*/external_React_default.a.createElement("i", {
          className: "xl-icon icon-s arrow-up-icon"
        }), (column.order === release_list_const["a" /* OrderConst */].SORT_ASC || column.order === release_list_const["a" /* OrderConst */].SORT_NONE) && /*#__PURE__*/external_React_default.a.createElement("i", {
          className: "xl-icon icon-s arrow-down-icon"
        })));
      });
      return /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "release-header-row-view"
      }, headerRow);
    }
  }]);

  return ReleaseHeaderLabelComponent;
}(external_React_["Component"]);
// EXTERNAL MODULE: ./node_modules/moment/moment.js-exposed
var moment_js_exposed = __webpack_require__(22);
var moment_js_exposed_default = /*#__PURE__*/__webpack_require__.n(moment_js_exposed);

// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./core/xlr-ui/app/react/components/release-list/display-duration/display-duration.component.less
var display_duration_component = __webpack_require__(285);
var display_duration_component_default = /*#__PURE__*/__webpack_require__.n(display_duration_component);

// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/release-list/display-duration/display-duration.component.less

            

var display_duration_component_options = {};

display_duration_component_options.insert = "head";
display_duration_component_options.singleton = false;

var display_duration_component_update = injectStylesIntoStyleTag_default()(display_duration_component_default.a, display_duration_component_options);



/* harmony default export */ var display_duration_display_duration_component = (display_duration_component_default.a.locals || {});
// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/release-list/display-duration/display-duration.component.js






function display_duration_component_createSuper(Derived) { var hasNativeReflectConstruct = display_duration_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function display_duration_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }





var display_duration_component_DisplayDurationComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(DisplayDurationComponent, _Component);

  var _super = display_duration_component_createSuper(DisplayDurationComponent);

  function DisplayDurationComponent() {
    classCallCheck_default()(this, DisplayDurationComponent);

    return _super.apply(this, arguments);
  }

  createClass_default()(DisplayDurationComponent, [{
    key: "render",
    value: function render() {
      var duration = this.props.duration;
      return /*#__PURE__*/external_React_default.a.createElement("span", {
        className: "display-duration-view"
      }, moment_js_exposed_default.a.duration(duration, 'ms').format("d[d] h[h] m[m]", {
        trim: false
      }));
    }
  }]);

  return DisplayDurationComponent;
}(external_React_["Component"]);
// EXTERNAL MODULE: ./core/xlr-ui/app/js/util/ids.js
var ids = __webpack_require__(52);

// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./core/xlr-ui/app/react/components/release-list/folder-path/folder-path.component.less
var folder_path_component = __webpack_require__(286);
var folder_path_component_default = /*#__PURE__*/__webpack_require__.n(folder_path_component);

// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/release-list/folder-path/folder-path.component.less

            

var folder_path_component_options = {};

folder_path_component_options.insert = "head";
folder_path_component_options.singleton = false;

var folder_path_component_update = injectStylesIntoStyleTag_default()(folder_path_component_default.a, folder_path_component_options);



/* harmony default export */ var folder_path_folder_path_component = (folder_path_component_default.a.locals || {});
// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/release-list/folder-path/folder-path.component.js






function folder_path_component_createSuper(Derived) { var hasNativeReflectConstruct = folder_path_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function folder_path_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }





var folder_path_component_FolderPathComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(FolderPathComponent, _Component);

  var _super = folder_path_component_createSuper(FolderPathComponent);

  function FolderPathComponent() {
    classCallCheck_default()(this, FolderPathComponent);

    return _super.apply(this, arguments);
  }

  createClass_default()(FolderPathComponent, [{
    key: "render",
    value: function render() {
      var folders = this.props.folders;
      var folderUrl = '#/folders/Applications';
      var folderList = folders.map(function (folder, idx) {
        folderUrl += '/' + "".concat(Object(ids["a" /* default */])().noApplications(folder.id));
        return /*#__PURE__*/external_React_default.a.createElement("li", {
          key: folder.id
        }, /*#__PURE__*/external_React_default.a.createElement("div", null, idx !== 0 && /*#__PURE__*/external_React_default.a.createElement("i", {
          className: "xl-icon icon-xs chevron-right-icon"
        }), " ", /*#__PURE__*/external_React_default.a.createElement("a", {
          href: "".concat(folderUrl, "/templates")
        }, /*#__PURE__*/external_React_default.a.createElement("i", {
          className: "xl-icon icon-xs folder-icon"
        }), " ", folder.title)));
      });
      return /*#__PURE__*/external_React_default.a.createElement("ul", {
        className: "folder-path-view"
      }, folderList);
    }
  }]);

  return FolderPathComponent;
}(external_React_["Component"]);
// EXTERNAL MODULE: ./node_modules/lodash/capitalize.js
var capitalize = __webpack_require__(208);
var capitalize_default = /*#__PURE__*/__webpack_require__.n(capitalize);

// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./core/xlr-ui/app/react/components/release-list/release-status/release-status.component.less
var release_status_component = __webpack_require__(287);
var release_status_component_default = /*#__PURE__*/__webpack_require__.n(release_status_component);

// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/release-list/release-status/release-status.component.less

            

var release_status_component_options = {};

release_status_component_options.insert = "head";
release_status_component_options.singleton = false;

var release_status_component_update = injectStylesIntoStyleTag_default()(release_status_component_default.a, release_status_component_options);



/* harmony default export */ var release_status_release_status_component = (release_status_component_default.a.locals || {});
// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/release-list/release-status/release-status.component.js






function release_status_component_createSuper(Derived) { var hasNativeReflectConstruct = release_status_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function release_status_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }





var release_status_component_ReleaseStatusComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(ReleaseStatusComponent, _Component);

  var _super = release_status_component_createSuper(ReleaseStatusComponent);

  function ReleaseStatusComponent() {
    classCallCheck_default()(this, ReleaseStatusComponent);

    return _super.apply(this, arguments);
  }

  createClass_default()(ReleaseStatusComponent, [{
    key: "getReleaseStatusLabel",
    value: function getReleaseStatusLabel(releaseStatus) {
      return capitalize_default()(releaseStatus.replace('_', ' '));
    }
  }, {
    key: "getStatusClassName",
    value: function getStatusClassName(releaseStatus) {
      return releaseStatus.toLowerCase();
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
          status = _this$props.status,
          isArchived = _this$props.isArchived;
      return /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "release-status-view"
      }, /*#__PURE__*/external_React_default.a.createElement("span", {
        className: "release-status-label ".concat(this.getStatusClassName(status))
      }, this.getReleaseStatusLabel(status)), isArchived && /*#__PURE__*/external_React_default.a.createElement("span", {
        className: "release-status-label archived"
      }, "Archived"));
    }
  }]);

  return ReleaseStatusComponent;
}(external_React_["Component"]);
// EXTERNAL MODULE: ./core/xlr-ui/app/react/components/release-list/release-progress/release-progress.component.js + 1 modules
var release_progress_component = __webpack_require__(166);

// EXTERNAL MODULE: ./core/xlr-ui/app/react/components/utils.js
var utils = __webpack_require__(123);

// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/release-list/display-date/display-date.component.js







function display_date_component_createSuper(Derived) { var hasNativeReflectConstruct = display_date_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function display_date_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }





var display_date_component_DisplayDateComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(DisplayDateComponent, _Component);

  var _super = display_date_component_createSuper(DisplayDateComponent);

  function DisplayDateComponent(props) {
    classCallCheck_default()(this, DisplayDateComponent);

    return _super.call(this, props);
  }

  createClass_default()(DisplayDateComponent, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          date = _this$props.date,
          dateFormat = _this$props.dateFormat,
          isLink = _this$props.isLink,
          color = _this$props.color,
          timeFormat = _this$props.timeFormat;
      var format = Object(utils["a" /* formatDateTime */])(date, dateFormat, timeFormat);
      var style = {
        color: color || '#414C58'
      };

      if (isLink) {
        return /*#__PURE__*/external_React_default.a.createElement("a", {
          href: "#/calendar?has_filter&date=".concat(moment_js_exposed_default()(date).format('YYYY-MM-DD')),
          style: style
        }, format);
      }

      return /*#__PURE__*/external_React_default.a.createElement("span", {
        style: style
      }, format);
    }
  }]);

  return DisplayDateComponent;
}(external_React_["Component"]);

defineProperty_default()(display_date_component_DisplayDateComponent, "defaultProps", {
  dateFormat: 'YYYY-MM-DD',
  timeFormat: 'h:mm A'
});
// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/release-list/release-row.component.js






function release_row_component_createSuper(Derived) { var hasNativeReflectConstruct = release_row_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function release_row_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }










var release_row_component_ReleaseRowComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(ReleaseRowComponent, _Component);

  var _super = release_row_component_createSuper(ReleaseRowComponent);

  function ReleaseRowComponent() {
    classCallCheck_default()(this, ReleaseRowComponent);

    return _super.apply(this, arguments);
  }

  createClass_default()(ReleaseRowComponent, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          id = _this$props.id,
          title = _this$props.title,
          status = _this$props.status,
          duration = _this$props.duration,
          currentPhase = _this$props.currentPhase,
          endDate = _this$props.endDate,
          progress = _this$props.progress,
          startDate = _this$props.startDate,
          folders = _this$props.folders,
          isArchived = _this$props.isArchived,
          dateFormat = _this$props.dateFormat,
          timeFormat = _this$props.timeFormat;
      return /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "release-list-row-view"
      }, /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "release-row-view-column release-title"
      }, /*#__PURE__*/external_React_default.a.createElement("div", null, /*#__PURE__*/external_React_default.a.createElement("a", {
        href: "#/releases/".concat(id)
      }, /*#__PURE__*/external_React_default.a.createElement("strong", null, title), currentPhase && " - ".concat(currentPhase))), folders && folders.length > 0 && /*#__PURE__*/external_React_default.a.createElement(folder_path_component_FolderPathComponent, {
        folders: folders
      })), /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "release-row-view-column release-status"
      }, /*#__PURE__*/external_React_default.a.createElement(release_status_component_ReleaseStatusComponent, {
        isArchived: isArchived,
        status: status
      })), /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "release-row-view-column release-progress"
      }, /*#__PURE__*/external_React_default.a.createElement(release_progress_component["a" /* ReleaseProgressComponent */], {
        progress: progress
      })), /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "release-row-view-column release-start-date"
      }, /*#__PURE__*/external_React_default.a.createElement(display_date_component_DisplayDateComponent, {
        date: startDate,
        dateFormat: dateFormat,
        isLink: true,
        timeFormat: timeFormat
      })), /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "release-row-view-column release-end-date"
      }, /*#__PURE__*/external_React_default.a.createElement(display_date_component_DisplayDateComponent, {
        date: endDate,
        dateFormat: dateFormat,
        isLink: true,
        timeFormat: timeFormat
      })), /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "release-row-view-column release-duration"
      }, /*#__PURE__*/external_React_default.a.createElement(display_duration_component_DisplayDurationComponent, {
        duration: duration
      })));
    }
  }]);

  return ReleaseRowComponent;
}(external_React_["Component"]);
// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/release-list/release-list.component.js






function release_list_component_createSuper(Derived) { var hasNativeReflectConstruct = release_list_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function release_list_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }







var release_list_component_ReleaseListComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(ReleaseListComponent, _Component);

  var _super = release_list_component_createSuper(ReleaseListComponent);

  function ReleaseListComponent() {
    classCallCheck_default()(this, ReleaseListComponent);

    return _super.apply(this, arguments);
  }

  createClass_default()(ReleaseListComponent, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          loadingReleases = _this$props.loadingReleases,
          header = _this$props.header,
          onOrderChange = _this$props.onOrderChange,
          releases = _this$props.releases,
          noData = _this$props.noData,
          dateFormat = _this$props.dateFormat,
          timeFormat = _this$props.timeFormat;
      var content = noData;

      if (releases.length > 0) {
        var releaseRows = releases.map(function (release) {
          return /*#__PURE__*/external_React_default.a.createElement(release_row_component_ReleaseRowComponent, {
            currentPhase: release.currentPhase,
            dateFormat: dateFormat,
            duration: release.duration,
            endDate: release.endDate,
            folders: release.folders,
            id: release.id,
            isArchived: release.isArchived,
            key: release.id,
            progress: release.progress,
            startDate: release.startDate,
            status: release.status,
            timeFormat: timeFormat,
            title: release.title
          });
        });
        content = /*#__PURE__*/external_React_default.a.createElement(external_React_default.a.Fragment, null, /*#__PURE__*/external_React_default.a.createElement("h4", {
          className: "release-list-view-title"
        }, "Search results (top ", releases.length, ")"), /*#__PURE__*/external_React_default.a.createElement(release_header_label_component_ReleaseHeaderLabelComponent, {
          header: header,
          onOrderChange: onOrderChange
        }), releaseRows);
      }

      if (loadingReleases) {
        content = /*#__PURE__*/external_React_default.a.createElement("div", {
          className: "spinner"
        }, /*#__PURE__*/external_React_default.a.createElement("img", {
          alt: "Loading...",
          src: "static/10.2.14/styles/img/big-ajax-loader.gif"
        }));
      }

      return /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "release-list-view"
      }, content);
    }
  }]);

  return ReleaseListComponent;
}(external_React_["Component"]);
// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/release-list/release-flag/ReleaseFlagComponent.js


var RELEASE_FLAG_STATUSES = {
  AT_RISK: /*#__PURE__*/external_React_default.a.createElement("i", {
    className: "xl-icon flag-risk-icon"
  }),
  OK: /*#__PURE__*/external_React_default.a.createElement("i", {
    className: "xl-icon flag-none-icon icon-l"
  }),
  ATTENTION_NEEDED: /*#__PURE__*/external_React_default.a.createElement("i", {
    className: "xl-icon flag-attention-icon"
  })
};

var ReleaseFlagComponent = function ReleaseFlagComponent(_ref) {
  var status = _ref.status;
  return RELEASE_FLAG_STATUSES[status];
};

ReleaseFlagComponent.propTypes = {
  status: prop_types_default.a.string.isRequired
};

// EXTERNAL MODULE: ./node_modules/classnames/index.js
var classnames = __webpack_require__(12);
var classnames_default = /*#__PURE__*/__webpack_require__.n(classnames);

// EXTERNAL MODULE: ./node_modules/lodash/get.js
var lodash_get = __webpack_require__(40);
var get_default = /*#__PURE__*/__webpack_require__.n(lodash_get);

// EXTERNAL MODULE: ./core/xlr-ui/app/features/common/services/risk-detector.js
var risk_detector = __webpack_require__(64);

// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/release-list/release-risk-status-icon/ReleaseRiskStatusIconComponent.js





var ICON_CLASSES = {
  completed: 'xl-icon circle-check-icon completed',
  onTrack: 'xl-icon circle-check-icon on-track',
  attentionNeeded: 'xl-icon circle-exclamation-icon attention-needed',
  atRisk: 'xl-icon circle-cross-icon at-risk'
};

var ReleaseRiskStatusIconComponent_ReleaseRiskStatusIconComponent = function ReleaseRiskStatusIconComponent(_ref) {
  var release = _ref.release,
      riskConfig = _ref.riskConfig;

  var hasCompletedStatus = function hasCompletedStatus(release) {
    return release.status === 'COMPLETED';
  };

  var hasAbortedStatus = function hasAbortedStatus(release) {
    return release.status === 'ABORTED';
  };

  var riskScore = parseInt(get_default()(release, 'syntheticProperties.riskScore'));

  var iconClass = function iconClass() {
    if (hasAbortedStatus(release) || hasCompletedStatus(release)) {
      return ICON_CLASSES.completed;
    } else if (Object(risk_detector["f" /* isOnTrack */])(release, riskScore, riskConfig)) {
      return ICON_CLASSES.onTrack;
    } else if (Object(risk_detector["d" /* isAttentionNeeded */])(release, riskScore, riskConfig)) {
      return ICON_CLASSES.attentionNeeded;
    } else if (Object(risk_detector["c" /* isAtRisk */])(release, riskScore, riskConfig)) {
      return ICON_CLASSES.atRisk;
    }

    return '';
  };

  return /*#__PURE__*/external_React_default.a.createElement("i", {
    className: classnames_default()('xl-icon', iconClass())
  });
};


// EXTERNAL MODULE: ./node_modules/lodash/isFunction.js
var isFunction = __webpack_require__(97);
var isFunction_default = /*#__PURE__*/__webpack_require__.n(isFunction);

// EXTERNAL MODULE: ./node_modules/lodash/noop.js
var noop = __webpack_require__(77);
var noop_default = /*#__PURE__*/__webpack_require__.n(noop);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/colors.js
var colors = __webpack_require__(21);

// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/inline-edit/index.js








function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function inline_edit_createSuper(Derived) { var hasNativeReflectConstruct = inline_edit_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function inline_edit_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }







var inline_edit_EditableLabel = /*#__PURE__*/function (_React$Component) {
  inherits_default()(EditableLabel, _React$Component);

  var _super = inline_edit_createSuper(EditableLabel);

  function EditableLabel(props) {
    var _this;

    classCallCheck_default()(this, EditableLabel);

    _this = _super.call(this, props);

    defineProperty_default()(assertThisInitialized_default()(_this), "_handleFocus", function () {
      var _this$props = _this.props,
          disabled = _this$props.disabled,
          onFocus = _this$props.onFocus,
          onFocusOut = _this$props.onFocusOut;

      if (!disabled) {
        var _this$state = _this.state,
            isEditing = _this$state.isEditing,
            text = _this$state.text,
            validationResult = _this$state.validationResult;

        if (isEditing) {
          /* eslint-disable angular/typecheck-function */
          if (isFunction_default()(onFocusOut)) {
            var _context;

            onFocusOut(text, (_context = _this).rollback.bind(_context), validationResult);
          }
          /* eslint-enable */

        } else {
          /* eslint-disable angular/typecheck-function */
          if (isFunction_default()(onFocus)) {
            onFocus(text);
          }
          /* eslint-enable */

        }

        if (text && text.length > 0) {
          _this.setState({
            lastSaved: text
          });
        }

        _this.setState({
          isEditing: !isEditing
        });
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "_selectValue", function (e) {
      e.target.select();
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "_handleChange", function (ev) {
      _this.setState({
        text: ev.target.value
      });

      _this.checkForValidation(ev.target.value);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "_handleKeyDown", function (e) {
      switch (e.key) {
        case 'Enter':
          _this._handleChange(e);

          _this._handleFocus(e);

          break;

        case 'Escape':
          _this.setState({
            text: _this.state.lastSaved,
            isEditing: false
          });

          if (isFunction_default()(_this.props.onDiscard)) {
            _this.props.onDiscard();
          }

          break;

        default:
          noop_default()();
      }
    });

    _this.state = {
      isEditing: _this.props.isEditing || false,
      text: _this.props.text || "",
      lastSaved: _this.props.text,
      validationResult: {
        valid: true
      }
    };
    return _this;
  }

  createClass_default()(EditableLabel, [{
    key: "rollback",
    value: function rollback() {
      this.setState({
        text: this.state.lastSaved
      });
      this.checkForValidation(this.state.lastSaved);
    }
  }, {
    key: "checkForValidation",
    value: function checkForValidation(value) {
      if (this.props.validators) {
        var isValid = function isValid(_ref) {
          var message = _ref.message;
          return message.type !== 'ERROR';
        };

        var validationToShow = this.props.validators.map(function (validator) {
          return validator(value.trim());
        }).find(function (result) {
          return result.condition;
        });
        var validationResult = validationToShow && validationToShow.condition ? {
          message: _objectSpread({}, validationToShow.message),
          valid: isValid(validationToShow)
        } : {
          valid: true
        };
        this.setState({
          validationResult: validationResult
        });
        this.props.onValidityChange(validationResult.valid);
      }
    }
  }, {
    key: "render",
    value: function render() {
      return /*#__PURE__*/external_React_default.a.createElement("div", null, this.state.isEditing ? /*#__PURE__*/external_React_default.a.createElement(external_React_default.a.Fragment, null, /*#__PURE__*/external_React_default.a.createElement("input", {
        autoFocus: true,
        className: "".concat(this.props.inputClassName, " ").concat(this.state.validationResult.valid ? '' : 'input-field-error'),
        maxLength: this.props.inputMaxLength,
        onBlur: this._handleFocus,
        onChange: this._handleChange,
        onFocus: this._selectValue,
        onKeyDown: this._handleKeyDown,
        placeholder: this.props.inputPlaceHolder,
        style: {
          width: this.props.inputWidth,
          height: this.props.inputHeight,
          fontSize: this.props.inputFontSize,
          fontWeight: this.props.inputFontWeight,
          borderWidth: this.props.inputBorderWidth,
          borderColor: this.props.required && this.state.text.length === 0 ? colors["a" /* default */].red : 'none'
        },
        tabIndex: this.props.inputTabIndex,
        type: "text",
        value: this.state.text
      }), this.state.validationResult.valid ? /*#__PURE__*/external_React_default.a.createElement("span", null) : /*#__PURE__*/external_React_default.a.createElement("span", {
        className: "validation-".concat(this.state.validationResult.message.type.toLowerCase())
      }, this.state.validationResult.message.text)) : /*#__PURE__*/external_React_default.a.createElement("label", {
        className: this.props.labelClassName,
        onClick: this._handleFocus,
        style: {
          fontSize: this.props.labelFontSize,
          fontWeight: this.props.labelFontWeight,
          height: '30px'
        },
        title: this.state.text
      }, this.state.text));
    }
  }]);

  return EditableLabel;
}(external_React_default.a.Component);

defineProperty_default()(inline_edit_EditableLabel, "defaultProps", {
  inputHeight: '30px'
});


// EXTERNAL MODULE: ./node_modules/antd/es/popover/index.js + 2 modules
var popover = __webpack_require__(3041);

// EXTERNAL MODULE: ./node_modules/lodash/map.js
var map = __webpack_require__(58);
var map_default = /*#__PURE__*/__webpack_require__.n(map);

// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./core/xlr-ui/app/react/components/release-count/release-count-component.less
var release_count_component = __webpack_require__(289);
var release_count_component_default = /*#__PURE__*/__webpack_require__.n(release_count_component);

// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/release-count/release-count-component.less

            

var release_count_component_options = {};

release_count_component_options.insert = "head";
release_count_component_options.singleton = false;

var release_count_component_update = injectStylesIntoStyleTag_default()(release_count_component_default.a, release_count_component_options);



/* harmony default export */ var release_count_release_count_component = (release_count_component_default.a.locals || {});
// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/release-count/release-count-component.js






function release_count_component_createSuper(Derived) { var hasNativeReflectConstruct = release_count_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function release_count_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }






var ReleaseCountResult = prop_types_default.a.shape({
  total: prop_types_default.a.number,
  byStatus: prop_types_default.a.object
});
var ReleaseCountResults = prop_types_default.a.shape({
  all: ReleaseCountResult.isRequired,
  live: ReleaseCountResult.isRequired,
  archived: ReleaseCountResult.isRequired
});
var release_count_component_ReleaseCountComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(ReleaseCountComponent, _Component);

  var _super = release_count_component_createSuper(ReleaseCountComponent);

  function ReleaseCountComponent() {
    classCallCheck_default()(this, ReleaseCountComponent);

    return _super.apply(this, arguments);
  }

  createClass_default()(ReleaseCountComponent, [{
    key: "render",
    value: function render() {
      var releaseCount = this.props.releaseCount;

      var getIconClass = function getIconClass(status) {
        return status.replace('_', '-').toLowerCase();
      };

      var getStatusText = function getStatusText(status) {
        var lowerCasedStatus = status.replace('_', ' ').toLowerCase();
        return lowerCasedStatus.charAt(0).toUpperCase() + lowerCasedStatus.slice(1);
      };

      var pluralizeReleaseWord = function pluralizeReleaseWord(count) {
        if (count === 1) {
          return 'release';
        } else {
          return 'releases';
        }
      }; // eslint-disable-next-line angular/definedundefined


      if (releaseCount === undefined) {
        return '';
      } else if (releaseCount.all.total === 0) {
        return '';
      }

      var all = map_default()(releaseCount.all.byStatus, function (count, status) {
        return /*#__PURE__*/external_React_default.a.createElement("p", {
          key: status
        }, /*#__PURE__*/external_React_default.a.createElement("i", {
          className: "circle ".concat(getIconClass(status))
        }), count, " ", getStatusText(status));
      });
      var content = /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "release-status-count-popup"
      }, /*#__PURE__*/external_React_default.a.createElement("div", null, all));
      return /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "release-count"
      }, /*#__PURE__*/external_React_default.a.createElement(popover["a" /* default */], {
        content: content,
        overlayClassName: "release-count-popover",
        placement: "bottom"
      }, releaseCount.all.total, " ", pluralizeReleaseWord(releaseCount.all.total)));
    }
  }]);

  return ReleaseCountComponent;
}(external_React_["Component"]);
// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./core/xlr-ui/app/react/components/button-with-popover/button-with-popover.less
var button_with_popover = __webpack_require__(290);
var button_with_popover_default = /*#__PURE__*/__webpack_require__.n(button_with_popover);

// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/button-with-popover/button-with-popover.less

            

var button_with_popover_options = {};

button_with_popover_options.insert = "head";
button_with_popover_options.singleton = false;

var button_with_popover_update = injectStylesIntoStyleTag_default()(button_with_popover_default.a, button_with_popover_options);



/* harmony default export */ var button_with_popover_button_with_popover = (button_with_popover_default.a.locals || {});
// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/button-with-popover/button-with-popover.component.js








function button_with_popover_component_createSuper(Derived) { var hasNativeReflectConstruct = button_with_popover_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function button_with_popover_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }






var placementList = ['top', 'left', 'right', 'bottom', 'topLeft', 'topRight', 'bottomLeft', 'bottomRight', 'leftTop', 'leftBottom', 'rightTop', 'rightBottom'];
var button_with_popover_component_ButtonWithPopoverComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(ButtonWithPopoverComponent, _Component);

  var _super = button_with_popover_component_createSuper(ButtonWithPopoverComponent);

  function ButtonWithPopoverComponent() {
    var _this;

    classCallCheck_default()(this, ButtonWithPopoverComponent);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    defineProperty_default()(assertThisInitialized_default()(_this), "handleClick", function (e) {
      var _this$props = _this.props,
          isDisabled = _this$props.isDisabled,
          onActionClick = _this$props.onActionClick;

      if (!isDisabled) {
        onActionClick(e);
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "renderPopoverContent", function () {
      var content = _this.props.content;
      return /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "bwp-message"
      }, content);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "renderLink", function () {
      var _this$props2 = _this.props,
          isDisabled = _this$props2.isDisabled,
          label = _this$props2.label,
          buttonClassName = _this$props2.buttonClassName;
      return /*#__PURE__*/external_React_default.a.createElement("span", {
        className: classnames_default()('link', defineProperty_default()({}, "".concat(buttonClassName), buttonClassName), {
          'disabled': isDisabled
        }),
        onClick: _this.handleClick
      }, label);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "renderButton", function () {
      var _this$props3 = _this.props,
          isDisabled = _this$props3.isDisabled,
          label = _this$props3.label,
          buttonClassName = _this$props3.buttonClassName;
      return /*#__PURE__*/external_React_default.a.createElement("button", {
        className: classnames_default()('button', defineProperty_default()({}, "".concat(buttonClassName), buttonClassName)),
        disabled: isDisabled,
        onClick: _this.handleClick
      }, label);
    });

    return _this;
  }

  createClass_default()(ButtonWithPopoverComponent, [{
    key: "render",
    value: function render() {
      var _this$props4 = this.props,
          isTooltipVisible = _this$props4.isTooltipVisible,
          placement = _this$props4.placement,
          showAsLink = _this$props4.showAsLink;
      var buttonTemplate = /*#__PURE__*/external_React_default.a.createElement("span", {
        className: classnames_default()('bwp-button')
      }, showAsLink ? this.renderLink() : this.renderButton());
      return isTooltipVisible ? /*#__PURE__*/external_React_default.a.createElement(popover["a" /* default */], {
        content: this.renderPopoverContent(),
        mouseEnterDelay: 0.5,
        mouseLeaveDelay: 0,
        overlayClassName: "button-with-popover",
        placement: placement
      }, buttonTemplate) : buttonTemplate;
    }
  }]);

  return ButtonWithPopoverComponent;
}(external_React_["Component"]);

defineProperty_default()(button_with_popover_component_ButtonWithPopoverComponent, "defaultProps", {
  placement: placementList[0]
});
// EXTERNAL MODULE: ./core/xlr-ui/app/react/components/infinite-list/infinite-list.component.js + 5 modules
var infinite_list_component = __webpack_require__(270);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/toConsumableArray.js
var toConsumableArray = __webpack_require__(23);
var toConsumableArray_default = /*#__PURE__*/__webpack_require__.n(toConsumableArray);

// EXTERNAL MODULE: ./node_modules/lodash/isUndefined.js
var isUndefined = __webpack_require__(53);
var isUndefined_default = /*#__PURE__*/__webpack_require__.n(isUndefined);

// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./core/xlr-ui/app/react/components/context-menu/contex-menu.component.less
var contex_menu_component = __webpack_require__(292);
var contex_menu_component_default = /*#__PURE__*/__webpack_require__.n(contex_menu_component);

// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/context-menu/contex-menu.component.less

            

var contex_menu_component_options = {};

contex_menu_component_options.insert = "head";
contex_menu_component_options.singleton = false;

var contex_menu_component_update = injectStylesIntoStyleTag_default()(contex_menu_component_default.a, contex_menu_component_options);



/* harmony default export */ var context_menu_contex_menu_component = (contex_menu_component_default.a.locals || {});
// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/context-menu/context-menu.component.js









function context_menu_component_createSuper(Derived) { var hasNativeReflectConstruct = context_menu_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function context_menu_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }






var context_menu_component_ContextMenuComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(ContextMenuComponent, _Component);

  var _super = context_menu_component_createSuper(ContextMenuComponent);

  function ContextMenuComponent(props) {
    var _this;

    classCallCheck_default()(this, ContextMenuComponent);

    _this = _super.call(this, props);

    defineProperty_default()(assertThisInitialized_default()(_this), "renderMenuContent", function (menuOptions) {
      return menuOptions.map(function (item, index) {
        return isUndefined_default()(item.isVisible) || !!item.isVisible ? !!item.isDisabled ? /*#__PURE__*/external_React_default.a.createElement("a", {
          className: "link-disabled",
          key: "menu-item-".concat(index)
        }, _this.renderLabel(item)) : /*#__PURE__*/external_React_default.a.createElement("a", {
          key: "menu-item-".concat(index),
          onClick: function onClick() {
            for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
              args[_key] = arguments[_key];
            }

            return _this.onItemClick(item, args);
          }
        }, _this.renderLabel(item)) : false;
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onVisibleChange", function (visible) {
      var onVisibilityChanged = _this.props.onVisibilityChanged;

      _this.setState({
        visible: visible
      });

      if (onVisibilityChanged) {
        onVisibilityChanged(visible);
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "renderLabel", function (item) {
      if (isUndefined_default()(item.iconClassName)) {
        return item.label;
      } else {
        return /*#__PURE__*/external_React_default.a.createElement("div", {
          className: "centered"
        }, /*#__PURE__*/external_React_default.a.createElement("i", {
          className: item.iconClassName
        }), item.label);
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "renderMenu", function (destroyTooltipOnHide, stageMenuOptions, menuWrapperClassName, menuName) {
      return /*#__PURE__*/external_React_default.a.createElement("span", {
        className: menuWrapperClassName
      }, /*#__PURE__*/external_React_default.a.createElement(popover["a" /* default */], {
        arrowPointAtCenter: true,
        content: _this.renderMenuContent(stageMenuOptions),
        destroyTooltipOnHide: destroyTooltipOnHide,
        onVisibleChange: _this.onVisibleChange,
        overlayClassName: "context-menu-popover",
        placement: "bottomRight",
        trigger: "click",
        visible: _this.state.visible
      }, /*#__PURE__*/external_React_default.a.createElement("i", {
        className: "xl-icon options-icon icon-l context-menu-btn",
        "data-cy": 'popup-' + menuName
      })));
    });

    _this.state = {
      visible: false
    };
    return _this;
  }

  createClass_default()(ContextMenuComponent, [{
    key: "onItemClick",
    value: function onItemClick(item, args) {
      if (this.props.dismissOnClick) {
        this.setState({
          visible: false
        });
      }

      item.handler.apply(item, toConsumableArray_default()(args));
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
          destroyTooltipOnHide = _this$props.destroyTooltipOnHide,
          menuName = _this$props.menuName,
          menuOptions = _this$props.menuOptions,
          menuWrapperClassName = _this$props.menuWrapperClassName;
      return this.renderMenu(destroyTooltipOnHide, menuOptions, menuWrapperClassName, menuName);
    }
  }]);

  return ContextMenuComponent;
}(external_React_["Component"]);

defineProperty_default()(context_menu_component_ContextMenuComponent, "defaultProps", {
  destroyTooltipOnHide: false,
  dismissOnClick: false,
  menuName: '',
  menuOptions: [],
  menuWrapperClassName: ''
});
// EXTERNAL MODULE: ./core/xlr-ui/app/react/components/doc-link/doc-link.component.js
var doc_link_component = __webpack_require__(269);

// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./core/xlr-ui/app/react/components/select-tree/select-tree.component.less
var select_tree_component = __webpack_require__(293);
var select_tree_component_default = /*#__PURE__*/__webpack_require__.n(select_tree_component);

// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/select-tree/select-tree.component.less

            

var select_tree_component_options = {};

select_tree_component_options.insert = "head";
select_tree_component_options.singleton = false;

var select_tree_component_update = injectStylesIntoStyleTag_default()(select_tree_component_default.a, select_tree_component_options);



/* harmony default export */ var select_tree_select_tree_component = (select_tree_component_default.a.locals || {});
// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/select-tree/select-tree.component.js





var select_tree_component_SelectTreeComponent = function SelectTreeComponent(_ref) {
  var clearable = _ref.clearable,
      data = _ref.data,
      onModelChange = _ref.onModelChange,
      selectedItemId = _ref.selectedItemId;
  return /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "select-tree-component"
  }, /*#__PURE__*/external_React_default.a.createElement(dist["XlReactWidgetTreeSelect"], {
    clearable: clearable,
    data: data,
    expandAll: true,
    indentGroupPadding: 10,
    onModelChange: onModelChange,
    selectedFolderId: selectedItemId
  }));
};


// EXTERNAL MODULE: ./node_modules/lodash/escapeRegExp.js
var escapeRegExp = __webpack_require__(527);
var escapeRegExp_default = /*#__PURE__*/__webpack_require__.n(escapeRegExp);

// EXTERNAL MODULE: ./node_modules/lodash/includes.js
var includes = __webpack_require__(42);
var includes_default = /*#__PURE__*/__webpack_require__.n(includes);

// EXTERNAL MODULE: ./node_modules/lodash/isEqual.js
var isEqual = __webpack_require__(85);
var isEqual_default = /*#__PURE__*/__webpack_require__.n(isEqual);

// EXTERNAL MODULE: ./node_modules/lodash/uniq.js
var uniq = __webpack_require__(528);
var uniq_default = /*#__PURE__*/__webpack_require__.n(uniq);

// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/tags-input/react-tags/suggestions.component.js








function suggestions_component_createSuper(Derived) { var hasNativeReflectConstruct = suggestions_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function suggestions_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }






var maybeScrollSuggestionIntoView = function maybeScrollSuggestionIntoView(suggestionEl, suggestionsContainer) {
  var containerHeight = suggestionsContainer.offsetHeight;
  var suggestionHeight = suggestionEl.offsetHeight;
  var relativeSuggestionTop = suggestionEl.offsetTop - suggestionsContainer.scrollTop;

  if (relativeSuggestionTop + suggestionHeight >= containerHeight) {
    suggestionsContainer.scrollTop += relativeSuggestionTop - containerHeight + suggestionHeight;
  } else if (relativeSuggestionTop < 0) {
    suggestionsContainer.scrollTop += relativeSuggestionTop;
  }
};

var suggestions_component_Suggestions = /*#__PURE__*/function (_Component) {
  inherits_default()(Suggestions, _Component);

  var _super = suggestions_component_createSuper(Suggestions);

  function Suggestions() {
    var _this;

    classCallCheck_default()(this, Suggestions);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    defineProperty_default()(assertThisInitialized_default()(_this), "shouldRenderSuggestions", function (query) {
      var _this$props = _this.props,
          minQueryLength = _this$props.minQueryLength,
          isFocused = _this$props.isFocused;
      return query.length >= minQueryLength && isFocused;
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "renderSuggestion", function (item, query) {
      var renderSuggestion = _this.props.renderSuggestion;

      if (isFunction_default()(renderSuggestion)) {
        return renderSuggestion(item, query);
      }

      var labelValue = item[_this.props.labelField];
      return /*#__PURE__*/external_React_default.a.createElement("span", null, labelValue);
    });

    return _this;
  }

  createClass_default()(Suggestions, [{
    key: "shouldComponentUpdate",
    value: function shouldComponentUpdate(nextProps) {
      var props = this.props;
      var shouldRenderSuggestions = props.shouldRenderSuggestions || this.shouldRenderSuggestions;
      return props.isFocused !== nextProps.isFocused || !isEqual_default()(props.suggestions, nextProps.suggestions) || shouldRenderSuggestions(nextProps.query) || shouldRenderSuggestions(nextProps.query) !== shouldRenderSuggestions(props.query);
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      var _this$props2 = this.props,
          selectedIndex = _this$props2.selectedIndex,
          classNames = _this$props2.classNames;

      if (this.suggestionsContainer && prevProps.selectedIndex !== selectedIndex) {
        var activeSuggestion = this.suggestionsContainer.querySelector(classNames.activeSuggestion);

        if (activeSuggestion) {
          maybeScrollSuggestionIntoView(activeSuggestion, this.suggestionsContainer);
        }
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      var props = this.props;
      var suggestions = props.suggestions.map(function (item, i) {
        return /*#__PURE__*/external_React_default.a.createElement("li", {
          className: i === props.selectedIndex ? props.classNames.activeSuggestion : '',
          key: i,
          onMouseDown: props.handleClick.bind(null, i),
          onMouseOver: props.handleHover.bind(null, i),
          onTouchStart: props.handleClick.bind(null, i)
        }, _this2.renderSuggestion(item, props.query));
      });
      var shouldRenderSuggestions = props.shouldRenderSuggestions || this.shouldRenderSuggestions;

      if (suggestions.length === 0 || !shouldRenderSuggestions(props.query)) {
        return /*#__PURE__*/external_React_default.a.createElement(external_React_["Fragment"], null);
      }

      return /*#__PURE__*/external_React_default.a.createElement("div", {
        className: this.props.classNames.suggestions,
        ref: function ref(elem) {
          return _this2.suggestionsContainer = elem;
        },
        style: props.isShowFromBottom ? {
          bottom: '0px',
          position: 'fixed'
        } : null
      }, /*#__PURE__*/external_React_default.a.createElement("ul", null, " ", suggestions, " "));
    }
  }]);

  return Suggestions;
}(external_React_["Component"]);

defineProperty_default()(suggestions_component_Suggestions, "defaultProps", {
  minQueryLength: 2
});
// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/tags-input/react-tags/xlr-tags-constants.js
var DEFAULT_PLACEHOLDER = 'Add...';
var DEFAULT_LABEL_FIELD = 'text';
var DEFAULT_CLASSNAMES = {
  tags: 'tags',
  tagInput: 'tag-new',
  tagInputField: 'tag-input',
  selected: 'tag',
  tag: 'tag-label',
  tagIcon: 'xl-icon tag-icon',
  tagHighlight: 'tag-highlight',
  remove: 'tag-close',
  suggestions: 'xlr-tags-suggestions',
  activeSuggestion: 'xlr-tags-active-suggestions'
};
// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/tags-input/react-tags/remove.component.js



var remove_component_RemoveComponent = function RemoveComponent(props) {
  var readOnly = props.readOnly,
      removeComponent = props.removeComponent,
      onClick = props.onClick,
      className = props.className;

  if (readOnly) {
    return /*#__PURE__*/external_React_default.a.createElement("span", null);
  }

  if (removeComponent) {
    var Component = removeComponent;
    return /*#__PURE__*/external_React_default.a.createElement(Component, props);
  }

  return /*#__PURE__*/external_React_default.a.createElement("a", {
    className: className,
    onClick: onClick,
    onKeyDown: onClick
  }, /*#__PURE__*/external_React_default.a.createElement("i", {
    className: "xl-icon close-icon icon-s"
  }));
};
remove_component_RemoveComponent.defaultProps = {
  className: DEFAULT_CLASSNAMES.remove,
  readOnly: false
};
// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/tags-input/react-tags/tag.component.js







function tag_component_createSuper(Derived) { var hasNativeReflectConstruct = tag_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function tag_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }





var tag_component_Tag = /*#__PURE__*/function (_Component) {
  inherits_default()(Tag, _Component);

  var _super = tag_component_createSuper(Tag);

  function Tag() {
    classCallCheck_default()(this, Tag);

    return _super.apply(this, arguments);
  }

  createClass_default()(Tag, [{
    key: "render",
    value: function render() {
      var props = this.props;
      var label = props.tag[props.labelField];
      var displayIcon = props.displayIcon,
          readOnly = props.readOnly,
          tag = props.tag,
          classNames = props.classNames;
      var _tag$className = tag.className,
          className = _tag$className === void 0 ? '' : _tag$className;
      return /*#__PURE__*/external_React_default.a.createElement(external_React_default.a.Fragment, null, displayIcon && /*#__PURE__*/external_React_default.a.createElement("span", {
        className: classNames.tagIcon
      }), /*#__PURE__*/external_React_default.a.createElement("span", {
        className: classnames_default()('tag-wrapper', classNames.tag, className),
        "data-tag-id": props.tag.id,
        onClick: props.onTagClicked,
        onKeyDown: props.onTagClicked,
        onTouchStart: props.onTagClicked
      }, label), /*#__PURE__*/external_React_default.a.createElement(remove_component_RemoveComponent, {
        className: classNames.remove,
        onClick: props.onDelete,
        readOnly: readOnly,
        removeComponent: props.removeComponent,
        tag: props.tag
      }));
    }
  }]);

  return Tag;
}(external_React_["Component"]);

defineProperty_default()(tag_component_Tag, "defaultProps", {
  displayIcon: true,
  labelField: 'text',
  readOnly: false
});
// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./core/xlr-ui/app/react/components/tags-input/react-tags/xlr-tags.less
var xlr_tags = __webpack_require__(294);
var xlr_tags_default = /*#__PURE__*/__webpack_require__.n(xlr_tags);

// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/tags-input/react-tags/xlr-tags.less

            

var xlr_tags_options = {};

xlr_tags_options.insert = "head";
xlr_tags_options.singleton = false;

var xlr_tags_update = injectStylesIntoStyleTag_default()(xlr_tags_default.a, xlr_tags_options);



/* harmony default export */ var react_tags_xlr_tags = (xlr_tags_default.a.locals || {});
// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/tags-input/react-tags/xlr-tags.component.js








function xlr_tags_component_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function xlr_tags_component_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { xlr_tags_component_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { xlr_tags_component_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function xlr_tags_component_createSuper(Derived) { var hasNativeReflectConstruct = xlr_tags_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function xlr_tags_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
















/**
 * @description
 * This component has been inspired from react-tags component (https://github.com/prakhar1989/react-tags/tree/v6.4.2)
 * It is customised as per XebiaLabs requirements.
 *
 * For all options, see https://github.com/prakhar1989/react-tags/tree/v6.4.2#options
 */

var xlr_tags_component_XlrTags = /*#__PURE__*/function (_Component) {
  inherits_default()(XlrTags, _Component);

  var _super = xlr_tags_component_createSuper(XlrTags);

  function XlrTags(props) {
    var _this;

    classCallCheck_default()(this, XlrTags);

    _this = _super.call(this, props);
    var suggestions = props.suggestions;
    _this.state = {
      suggestions: suggestions,
      query: '',
      isFocused: false,
      selectedIndex: -1,
      selectionMode: false,
      shouldShowSuggestionFromBottom: false
    };
    _this.handleFocus = _this.handleFocus.bind(assertThisInitialized_default()(_this));
    _this.handleBlur = _this.handleBlur.bind(assertThisInitialized_default()(_this));
    _this.handleKeyDown = _this.handleKeyDown.bind(assertThisInitialized_default()(_this));
    _this.handleChange = _this.handleChange.bind(assertThisInitialized_default()(_this));
    _this.handlePaste = _this.handlePaste.bind(assertThisInitialized_default()(_this));
    _this.resetAndFocusInput = _this.resetAndFocusInput.bind(assertThisInitialized_default()(_this));
    _this.handleSuggestionHover = _this.handleSuggestionHover.bind(assertThisInitialized_default()(_this));
    _this.handleSuggestionClick = _this.handleSuggestionClick.bind(assertThisInitialized_default()(_this));
    return _this;
  }

  createClass_default()(XlrTags, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var _this$props = this.props,
          autofocus = _this$props.autofocus,
          readOnly = _this$props.readOnly;

      if (autofocus && !readOnly) {
        this.resetAndFocusInput();
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (!isEqual_default()(prevProps.suggestions, this.props.suggestions)) {
        this.updateSuggestions();
      }
    }
  }, {
    key: "filteredSuggestions",
    value: function filteredSuggestions(query, suggestions) {
      var _this2 = this;

      if (this.props.handleFilterSuggestions) {
        return this.props.handleFilterSuggestions(query, suggestions);
      }

      var exactSuggestions = suggestions.filter(function (item) {
        return _this2.getQueryIndex(query, item) === 0 && !includes_default()(map_default()(_this2.props.tags, _this2.props.labelField), item[_this2.props.labelField]);
      });
      var partialSuggestions = suggestions.filter(function (item) {
        return _this2.getQueryIndex(query, item) > 0 && !includes_default()(map_default()(_this2.props.tags, _this2.props.labelField), item[_this2.props.labelField]);
      });
      return exactSuggestions.concat(partialSuggestions);
    }
  }, {
    key: "getQueryIndex",
    value: function getQueryIndex(query, item) {
      return item[this.props.labelField].toLowerCase().indexOf(query.toLowerCase());
    }
  }, {
    key: "resetAndFocusInput",
    value: function resetAndFocusInput() {
      this.setState({
        query: ''
      });

      if (this.textInput) {
        this.textInput.value = '';
        this.textInput.focus();
      }
    }
  }, {
    key: "handleDelete",
    value: function handleDelete(i, e) {
      this.props.handleDelete(i, e);

      if (!this.props.resetInputOnDelete) {
        this.textInput && this.textInput.focus();
      } else {
        this.resetAndFocusInput();
      }

      e.stopPropagation();
    }
  }, {
    key: "handleTagClick",
    value: function handleTagClick(i, e) {
      if (this.props.handleTagClick) {
        this.props.handleTagClick(i, e);
      }

      if (!this.props.resetInputOnDelete) {
        this.textInput && this.textInput.focus();
      } else {
        this.resetAndFocusInput();
      }
    }
  }, {
    key: "handleChange",
    value: function handleChange(e) {
      if (this.props.handleInputChange) {
        this.props.handleInputChange(e.target.value);
      }

      var query = e.target.value.trim();
      this.setState({
        query: query
      }, this.updateSuggestions);
    }
    /**
     * Convert an array of delimiter characters into a regular expression
     * that can be used to split content by those delimiters.
     * @param {Array<char>} delimiters Array of characters to turn into a regex
     * @returns {RegExp} Regular expression
     */

  }, {
    key: "buildRegExpFromDelimiters",
    value: function buildRegExpFromDelimiters(delimiters) {
      var delimiterChars = delimiters.map(function (delimiter) {
        // See: http://stackoverflow.com/a/34711175/1463681
        var chrCode = delimiter - 48 * Math.floor(delimiter / 48);
        return String.fromCharCode(96 <= delimiter ? chrCode : delimiter);
      }).join('');
      var escapedDelimiterChars = escapeRegExp_default()(delimiterChars);
      return new RegExp("[".concat(escapedDelimiterChars, "]+"));
    }
  }, {
    key: "updateSuggestions",
    value: function updateSuggestions() {
      var _this$state = this.state,
          query = _this$state.query,
          selectedIndex = _this$state.selectedIndex;
      var suggestions = this.filteredSuggestions(query, this.props.suggestions);
      this.setState({
        suggestions: suggestions,
        selectedIndex: selectedIndex >= suggestions.length ? suggestions.length - 1 : selectedIndex
      });
    }
  }, {
    key: "isOutOfViewport",
    value: function isOutOfViewport(elem) {
      var bounding = elem.getBoundingClientRect();
      return bounding.bottom + 150 > window.innerHeight; //150px is max height for suggestion component
    }
  }, {
    key: "handleFocus",
    value: function handleFocus(e) {
      var value = e.target.value;

      if (this.props.handleInputFocus) {
        this.props.handleInputFocus(value);
      }

      var isOutOfViewport = this.isOutOfViewport(this.textInput);
      this.setState({
        isFocused: true,
        shouldShowSuggestionFromBottom: isOutOfViewport
      });
    }
  }, {
    key: "handleBlur",
    value: function handleBlur(e) {
      var value = e.target.value;

      if (this.props.handleInputBlur) {
        this.props.handleInputBlur(value);

        if (this.textInput) {
          this.textInput.value = '';
        }
      }

      this.setState({
        isFocused: false
      });
    }
  }, {
    key: "handleKeyDown",
    value: function handleKeyDown(e) {
      var _this$state2 = this.state,
          query = _this$state2.query,
          selectedIndex = _this$state2.selectedIndex,
          suggestions = _this$state2.suggestions,
          selectionMode = _this$state2.selectionMode; // hide suggestions menu on escape

      if (e.keyCode === key_codes["a" /* keyCodes */].ESC) {
        e.preventDefault();
        e.stopPropagation();
        this.setState({
          selectedIndex: -1,
          selectionMode: false,
          suggestions: []
        });
      } // When one of the terminating keys is pressed, add current query to the tags.
      // If no text is typed in so far, ignore the action - so we don't end up with a terminating
      // character typed in.


      if (includes_default()(this.props.delimiters, e.keyCode) && !e.shiftKey) {
        if (e.keyCode !== key_codes["a" /* keyCodes */].TAB || query !== '') {
          e.preventDefault();
        }

        var selectedQuery = selectionMode && selectedIndex !== -1 ? suggestions[selectedIndex] : defineProperty_default()({
          id: query
        }, this.props.labelField, query);

        if (selectedQuery !== '') {
          this.addTag(selectedQuery);
        }
      } // when backspace key is pressed and query is blank, delete tag


      if (e.keyCode === key_codes["a" /* keyCodes */].BACKSPACE && query === '' && this.props.allowDeleteFromEmptyInput) {
        this.handleDelete(this.props.tags.length - 1, e);
      } // up arrow


      if (e.keyCode === key_codes["a" /* keyCodes */].UP) {
        e.preventDefault();
        this.setState({
          selectedIndex: selectedIndex <= 0 ? suggestions.length - 1 : selectedIndex - 1,
          selectionMode: true
        });
      } // down arrow


      if (e.keyCode === key_codes["a" /* keyCodes */].DOWN) {
        e.preventDefault();
        this.setState({
          selectedIndex: suggestions.length === 0 ? -1 : (selectedIndex + 1) % suggestions.length,
          selectionMode: true
        });
      }
    }
  }, {
    key: "handlePaste",
    value: function handlePaste(e) {
      var _this3 = this;

      if (!this.props.allowAddFromPaste) {
        return;
      }

      e.preventDefault();
      var clipboardData = e.clipboardData || window.clipboardData;
      var clipboardText = clipboardData.getData('text');
      var _this$props$maxLength = this.props.maxLength,
          maxLength = _this$props$maxLength === void 0 ? clipboardText.length : _this$props$maxLength;
      var maxTextLength = Math.min(maxLength, clipboardText.length);
      var pastedText = clipboardData.getData('text').substr(0, maxTextLength); // Used to determine how the pasted content is split.

      var delimiterRegExp = this.buildRegExpFromDelimiters(this.props.delimiters);
      var tags = pastedText.split(delimiterRegExp); // Only add unique tags

      uniq_default()(tags).forEach(function (tag) {
        return _this3.addTag(defineProperty_default()({
          id: tag
        }, _this3.props.labelField, tag));
      });
    }
  }, {
    key: "highlight",
    value: function highlight(tag) {
      var classNames = xlr_tags_component_objectSpread(xlr_tags_component_objectSpread({}, DEFAULT_CLASSNAMES), this.props.classNames);
      /* eslint-disable react/no-find-dom-node */


      var node = external_ReactDOM_default.a.findDOMNode(this);
      /* eslint-enable react/no-find-dom-node */

      if (node instanceof HTMLElement) {
        var parent = node.querySelector(".".concat(classNames.tag, "[data-tag-id='").concat(tag.id, "']")).parentNode;
        parent.classList.remove(classNames.tagHighlight);
        setTimeout(function () {
          return parent.classList.add(classNames.tagHighlight);
        }, 100);
      }
    }
  }, {
    key: "addTag",
    value: function addTag(tag) {
      var _tag$id;

      var _this$props2 = this.props,
          tags = _this$props2.tags,
          labelField = _this$props2.labelField,
          allowUnique = _this$props2.allowUnique;
      tag.readOnly = false; // by default, will be overwritten on  tag = possibleMatches[0];

      if (!tag.id || !tag[labelField]) {
        return;
      }

      var existingKeys = tags.map(function (item) {
        var _item$id;

        return (_item$id = item.id) === null || _item$id === void 0 ? void 0 : _item$id.toLowerCase();
      }); // Return if tag has been already added

      if (allowUnique && includes_default()(existingKeys, (_tag$id = tag.id) === null || _tag$id === void 0 ? void 0 : _tag$id.toLowerCase())) {
        this.highlight(tag);
        return;
      }

      if (this.props.autocomplete) {
        var possibleMatches = this.filteredSuggestions(tag[labelField], this.props.suggestions);

        if (this.props.autocomplete === 1 && possibleMatches.length === 1 || this.props.autocomplete === true && possibleMatches.length) {
          tag = possibleMatches[0];
        }
      } // Return if entered tag is any arbitrary value and not selected from suggestions


      if (this.props.allowAddOnlyFromSuggestion && !includes_default()(this.props.suggestions.map(function (item) {
        return item.id.toLowerCase();
      }), tag.id.toLowerCase())) {
        return;
      } // call method to add


      this.props.handleAddition(tag); // reset the state

      this.setState({
        query: '',
        selectionMode: false,
        selectedIndex: -1
      });
      this.resetAndFocusInput();
    }
  }, {
    key: "handleSuggestionClick",
    value: function handleSuggestionClick(i) {
      this.addTag(this.state.suggestions[i]);
    }
  }, {
    key: "handleSuggestionHover",
    value: function handleSuggestionHover(i) {
      this.setState({
        selectedIndex: i,
        selectionMode: true
      });
    }
  }, {
    key: "getTagItems",
    value: function getTagItems() {
      var _this4 = this;

      var _this$props3 = this.props,
          tags = _this$props3.tags,
          labelField = _this$props3.labelField,
          removeComponent = _this$props3.removeComponent;

      var classNames = xlr_tags_component_objectSpread(xlr_tags_component_objectSpread({}, DEFAULT_CLASSNAMES), this.props.classNames);

      return tags.map(function (tag, index) {
        return /*#__PURE__*/external_React_default.a.createElement("div", {
          className: classNames.selected,
          key: "div-".concat(tag.id, "-").concat(index)
        }, /*#__PURE__*/external_React_default.a.createElement(tag_component_Tag, {
          classNames: classNames,
          displayIcon: !tag.isVirtual,
          index: index,
          key: "".concat(tag.id, "-").concat(index),
          labelField: labelField,
          onDelete: _this4.handleDelete.bind(_this4, index),
          onTagClicked: _this4.handleTagClick.bind(_this4, index),
          readOnly: tag.readOnly,
          removeComponent: removeComponent,
          tag: tag
        }));
      });
    }
  }, {
    key: "render",
    value: function render() {
      var _this5 = this;

      var tagItems = this.getTagItems();

      var classNames = xlr_tags_component_objectSpread(xlr_tags_component_objectSpread({}, DEFAULT_CLASSNAMES), this.props.classNames); // get the suggestions for the given query


      var query = this.state.query.trim(),
          selectedIndex = this.state.selectedIndex,
          suggestions = this.state.suggestions;
      var _this$props4 = this.props,
          placeholder = _this$props4.placeholder,
          inputName = _this$props4.name,
          inputId = _this$props4.id,
          maxLength = _this$props4.maxLength;
      var tagInput = !this.props.readOnly ? /*#__PURE__*/external_React_default.a.createElement("div", {
        className: classNames.tagInput
      }, /*#__PURE__*/external_React_default.a.createElement("input", {
        "aria-label": placeholder,
        className: classNames.tagInputField,
        id: inputId,
        maxLength: maxLength,
        name: inputName,
        onBlur: this.handleBlur,
        onChange: this.handleChange,
        onFocus: this.handleFocus,
        onKeyDown: this.handleKeyDown,
        onPaste: this.handlePaste,
        placeholder: placeholder,
        ref: function ref(input) {
          _this5.textInput = input;
        },
        type: "text",
        value: this.props.inputValue
      }), /*#__PURE__*/external_React_default.a.createElement(suggestions_component_Suggestions, {
        classNames: classNames,
        handleClick: this.handleSuggestionClick,
        handleHover: this.handleSuggestionHover,
        isFocused: this.state.isFocused,
        isShowFromBottom: this.state.shouldShowSuggestionFromBottom,
        labelField: this.props.labelField,
        minQueryLength: this.props.minQueryLength,
        query: query,
        renderSuggestion: this.props.renderSuggestion,
        selectedIndex: selectedIndex,
        shouldRenderSuggestions: this.props.shouldRenderSuggestions,
        suggestions: suggestions
      })) : null;
      return /*#__PURE__*/external_React_default.a.createElement("div", {
        className: classnames_default()(classNames.tags, 'react-tags-wrapper')
      }, tagItems, tagInput);
    }
  }]);

  return XlrTags;
}(external_React_["Component"]);

defineProperty_default()(xlr_tags_component_XlrTags, "defaultProps", {
  placeholder: DEFAULT_PLACEHOLDER,
  labelField: DEFAULT_LABEL_FIELD,
  suggestions: [],
  delimiters: [key_codes["a" /* keyCodes */].ENTER],
  autofocus: true,
  handleDelete: noop_default.a,
  handleAddition: noop_default.a,
  allowAddOnlyFromSuggestion: false,
  allowDeleteFromEmptyInput: true,
  allowAddFromPaste: true,
  resetInputOnDelete: true,
  autocomplete: false,
  readOnly: false,
  allowUnique: true,
  tags: []
});
// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./core/xlr-ui/app/react/components/tags-input/xlr-members-tags.less
var xlr_members_tags = __webpack_require__(295);
var xlr_members_tags_default = /*#__PURE__*/__webpack_require__.n(xlr_members_tags);

// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/tags-input/xlr-members-tags.less

            

var xlr_members_tags_options = {};

xlr_members_tags_options.insert = "head";
xlr_members_tags_options.singleton = false;

var xlr_members_tags_update = injectStylesIntoStyleTag_default()(xlr_members_tags_default.a, xlr_members_tags_options);



/* harmony default export */ var tags_input_xlr_members_tags = (xlr_members_tags_default.a.locals || {});
// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/tags-input/xlr-members-tags.component.js








function xlr_members_tags_component_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function xlr_members_tags_component_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { xlr_members_tags_component_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { xlr_members_tags_component_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function xlr_members_tags_component_createSuper(Derived) { var hasNativeReflectConstruct = xlr_members_tags_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function xlr_members_tags_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }






/**
 * @description
 * React component to manage tag list input with auto-completion for members.
 *
 * @example
 * <XlrMembersTags
 *    classNames={{tagInput: 'tag-new principal', selected: 'tag principal'}}
 *    placeholder={'Add principal...'}
 *    tags={tags}
 *    suggestions={suggestions}
 *    handleDelete={this.onMemberDelete}
 *    handleAddition={this.onMemberChange}
 *    readOnly={false}
 * />
 *
 * handleDelete(i) {
 *    const { tags } = this.state;
 *    this.setState({
 *      tags: tags.filter((tag, index) => index !== i),
 *    });
 * }
 *
 * handleAddition(tag) {
 *    this.setState(state => ({ tags: [...state.tags, tag] }));
 * }
 *
 */

var xlr_members_tags_component_XlrMembersTags = /*#__PURE__*/function (_Component) {
  inherits_default()(XlrMembersTags, _Component);

  var _super = xlr_members_tags_component_createSuper(XlrMembersTags);

  function XlrMembersTags() {
    var _this;

    classCallCheck_default()(this, XlrMembersTags);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    defineProperty_default()(assertThisInitialized_default()(_this), "renderSuggestion", function (item) {
      var isVirtual = item.isVirtual;
      return /*#__PURE__*/external_React_default.a.createElement("div", {
        className: 'suggestion-wrapper'
      }, !isVirtual && /*#__PURE__*/external_React_default.a.createElement("span", {
        className: 'xl-icon tag-icon'
      }), /*#__PURE__*/external_React_default.a.createElement("span", {
        className: 'tag-label'
      }, item[_this.props.label]));
    });

    return _this;
  }

  createClass_default()(XlrMembersTags, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          allowAddOnlyFromSuggestion = _this$props.allowAddOnlyFromSuggestion,
          handleAddition = _this$props.handleAddition,
          handleDelete = _this$props.handleDelete,
          id = _this$props.id,
          label = _this$props.label,
          maxLength = _this$props.maxLength,
          name = _this$props.name,
          placeholder = _this$props.placeholder,
          readOnly = _this$props.readOnly,
          suggestions = _this$props.suggestions,
          tags = _this$props.tags;

      var classNames = xlr_members_tags_component_objectSpread(xlr_members_tags_component_objectSpread({}, XlrMembersTags.defaultProps.classNames), this.props.classNames);

      return /*#__PURE__*/external_React_default.a.createElement(external_React_default.a.Fragment, null, /*#__PURE__*/external_React_default.a.createElement(xlr_tags_component_XlrTags, {
        allowAddFromPaste: false,
        allowAddOnlyFromSuggestion: allowAddOnlyFromSuggestion,
        autofocus: false,
        classNames: classNames,
        handleAddition: handleAddition,
        handleDelete: handleDelete,
        id: id,
        labelField: label,
        maxLength: maxLength,
        minQueryLength: 1,
        name: name,
        placeholder: placeholder,
        readOnly: readOnly,
        renderSuggestion: this.renderSuggestion,
        suggestions: suggestions,
        tags: tags
      }));
    }
  }]);

  return XlrMembersTags;
}(external_React_["Component"]);

defineProperty_default()(xlr_members_tags_component_XlrMembersTags, "defaultProps", {
  allowAddOnlyFromSuggestion: false,
  classNames: xlr_members_tags_component_objectSpread(xlr_members_tags_component_objectSpread({}, DEFAULT_CLASSNAMES), {}, {
    tagInput: 'tag-new principal',
    selected: 'tag principal'
  }),
  label: "name",
  placeholder: "Add...",
  suggestions: [],
  readOnly: false,
  tags: []
});
// EXTERNAL MODULE: ./core/xlr-ui/app/js/variables/variable-constants.js
var variable_constants = __webpack_require__(41);

// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./core/xlr-ui/app/react/components/display-variable/display-variable.less
var display_variable = __webpack_require__(296);
var display_variable_default = /*#__PURE__*/__webpack_require__.n(display_variable);

// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/display-variable/display-variable.less

            

var display_variable_options = {};

display_variable_options.insert = "head";
display_variable_options.singleton = false;

var display_variable_update = injectStylesIntoStyleTag_default()(display_variable_default.a, display_variable_options);



/* harmony default export */ var display_variable_display_variable = (display_variable_default.a.locals || {});
// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/display-variable/display-variable.component.js





var display_variable_component_DisplayVariable = function DisplayVariable(_ref) {
  var variable = _ref.variable;

  var renderStringField = function renderStringField() {
    var isPassword = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
    return /*#__PURE__*/external_React_default.a.createElement(dist["XlReactWidgetString"], {
      displayMode: 'visual',
      metadata: {
        label: variable.key,
        type: isPassword ? 'password' : 'text'
      },
      model: variable.value
    });
  };

  var renderBooleanField = function renderBooleanField() {
    return /*#__PURE__*/external_React_default.a.createElement(dist["XlReactWidgetString"], {
      displayMode: 'visual',
      metadata: {
        label: variable.key
      },
      model: variable.value ? 'True' : 'False'
    });
  };

  var renderSetField = function renderSetField() {
    return /*#__PURE__*/external_React_default.a.createElement(dist["XlReactWidgetString"], {
      displayMode: 'visual',
      metadata: {
        label: variable.key
      },
      model: "set(".concat(transformObjectToText(), ")")
    });
  };

  var renderObjectField = function renderObjectField() {
    return /*#__PURE__*/external_React_default.a.createElement(dist["XlReactWidgetString"], {
      displayMode: 'visual',
      metadata: {
        label: variable.key
      },
      model: transformObjectToText()
    });
  };

  var renderDateTimeField = function renderDateTimeField() {
    var value = moment(variable.value).format('DD/MM/YYYY hh:mm A');
    return /*#__PURE__*/external_React_default.a.createElement(dist["XlReactWidgetString"], {
      displayMode: 'visual',
      metadata: {
        label: variable.key
      },
      model: value
    });
  }; // eslint-disable-next-line no-console, angular/json-functions


  var transformObjectToText = function transformObjectToText() {
    return JSON.stringify(variable.value).split(',').join(', ');
  };

  var renderSwitch = function renderSwitch() {
    switch (variable.type) {
      case variable_constants["a" /* VariableConstants */].type.string.key:
      case variable_constants["a" /* VariableConstants */].type.integer.key:
        return renderStringField();

      case variable_constants["a" /* VariableConstants */].type.passwordString.key:
        return renderStringField(true);

      case variable_constants["a" /* VariableConstants */].type.boolean.key:
        return renderBooleanField();

      case variable_constants["a" /* VariableConstants */].type.setString.key:
        return renderSetField();

      case variable_constants["a" /* VariableConstants */].type.date.key:
        return renderDateTimeField();

      case variable_constants["a" /* VariableConstants */].type.listString.key:
      case variable_constants["a" /* VariableConstants */].type.mapStringString.key:
      default:
        return renderObjectField();
    }
  };

  return /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "display-variable-wrapper form-group"
  }, renderSwitch());
};
// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/slicedToArray.js
var slicedToArray = __webpack_require__(20);
var slicedToArray_default = /*#__PURE__*/__webpack_require__.n(slicedToArray);

// EXTERNAL MODULE: ./node_modules/lodash/isEmpty.js
var isEmpty = __webpack_require__(29);
var isEmpty_default = /*#__PURE__*/__webpack_require__.n(isEmpty);

// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/text-area-password/TextAreaPassword.js






var PasswordCharacterCode = "\u2022";

var TextAreaPassword_TextAreaPassword = function TextAreaPassword(_ref) {
  var name = _ref.name,
      onChange = _ref.onChange,
      _ref$required = _ref.required,
      required = _ref$required === void 0 ? false : _ref$required,
      _ref$rows = _ref.rows,
      rows = _ref$rows === void 0 ? 4 : _ref$rows,
      value = _ref.value;

  var _useState = Object(external_React_["useState"])(""),
      _useState2 = slicedToArray_default()(_useState, 2),
      passwordValue = _useState2[0],
      setPasswordValue = _useState2[1];

  var _useState3 = Object(external_React_["useState"])(true),
      _useState4 = slicedToArray_default()(_useState3, 2),
      isValid = _useState4[0],
      setValid = _useState4[1];

  Object(external_React_["useEffect"])(function () {
    var val = isEmpty_default()(value) ? "" : map_default()(value, function (_) {
      return PasswordCharacterCode;
    }).join('');
    setPasswordValue(val);
    setValidity(val);
  }, []);

  var onValueChange = function onValueChange(event) {
    var value = event.target.value;
    setPasswordValue(value);
    setValidity(value);
    onChange(value);
  };

  var setValidity = function setValidity(value) {
    if (required) {
      return setValid(!isEmpty_default()(value));
    }

    return setValid(true);
  };

  return /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "password-textarea-component"
  }, /*#__PURE__*/external_React_default.a.createElement("textarea", {
    className: classnames_default()('password-textarea', {
      'is-invalid': !isValid
    }),
    name: name,
    onChange: onValueChange,
    spellCheck: "false",
    value: passwordValue
  }));
};


// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./core/xlr-ui/app/react/components/text-area-password/text-area-password-edit-mode.less
var text_area_password_edit_mode = __webpack_require__(297);
var text_area_password_edit_mode_default = /*#__PURE__*/__webpack_require__.n(text_area_password_edit_mode);

// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/text-area-password/text-area-password-edit-mode.less

            

var text_area_password_edit_mode_options = {};

text_area_password_edit_mode_options.insert = "head";
text_area_password_edit_mode_options.singleton = false;

var text_area_password_edit_mode_update = injectStylesIntoStyleTag_default()(text_area_password_edit_mode_default.a, text_area_password_edit_mode_options);



/* harmony default export */ var text_area_password_text_area_password_edit_mode = (text_area_password_edit_mode_default.a.locals || {});
// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/text-area-password/TextAreaPasswordEditMode.js








var TextAreaPasswordEditMode_TextAreaPasswordEditMode = function TextAreaPasswordEditMode(_ref) {
  var name = _ref.name,
      onChange = _ref.onChange,
      _ref$readOnly = _ref.readOnly,
      readOnly = _ref$readOnly === void 0 ? false : _ref$readOnly,
      _ref$required = _ref.required,
      required = _ref$required === void 0 ? false : _ref$required,
      value = _ref.value;

  var _useState = Object(external_React_["useState"])(false),
      _useState2 = slicedToArray_default()(_useState, 2),
      isEditMode = _useState2[0],
      setEditMode = _useState2[1];

  var _useState3 = Object(external_React_["useState"])(false),
      _useState4 = slicedToArray_default()(_useState3, 2),
      passwordValue = _useState4[0],
      setPasswordValue = _useState4[1];

  Object(external_React_["useEffect"])(function () {
    setPasswordValue(value);
  }, [value]);

  var save = function save() {
    onChange(passwordValue);
    setEditMode(false);
  };

  var cancel = function cancel() {
    setEditMode(false);
  };

  var isValid = function isValid() {
    if (required) {
      return !isEmpty_default()(passwordValue);
    }

    return true;
  };

  var notEditMode = function notEditMode() {
    return /*#__PURE__*/external_React_default.a.createElement("div", {
      className: classnames_default()("display inline-textarea", {
        'is-invalid': !isValid()
      })
    }, /*#__PURE__*/external_React_default.a.createElement("span", {
      className: "text placeholder light-text"
    }, "Click on edit icon to modify the password"), /*#__PURE__*/external_React_default.a.createElement("i", {
      className: "xl-icon edit-icon",
      onClick: function onClick() {
        return setEditMode(true);
      }
    }));
  };

  var editMode = function editMode() {
    return /*#__PURE__*/external_React_default.a.createElement(external_React_default.a.Fragment, null, /*#__PURE__*/external_React_default.a.createElement(TextAreaPassword_TextAreaPassword, {
      name: name,
      onChange: setPasswordValue,
      required: required,
      value: passwordValue
    }), /*#__PURE__*/external_React_default.a.createElement("div", {
      className: "text-area-password-action-buttons"
    }, /*#__PURE__*/external_React_default.a.createElement("div", {
      className: "ok",
      onClick: save
    }, /*#__PURE__*/external_React_default.a.createElement("i", {
      className: "xl-icon check-icon"
    }), "Save"), /*#__PURE__*/external_React_default.a.createElement("div", {
      className: "cancel",
      onClick: cancel
    }, /*#__PURE__*/external_React_default.a.createElement("i", {
      className: "xl-icon close-icon"
    }), "Cancel")));
  };

  var readOnlyMode = function readOnlyMode() {
    return /*#__PURE__*/external_React_default.a.createElement("div", {
      className: "field-readonly read-only"
    }, /*#__PURE__*/external_React_default.a.createElement("span", {
      className: "light-text"
    }, isEmpty_default()(passwordValue) ? '' : '*****'));
  };

  return /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "text-area-password-edit-mode"
  }, readOnly ? readOnlyMode() : isEditMode ? editMode() : notEditMode());
};


// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/folder/folder-details.component.js


var folder_details_component_FolderDetails = function FolderDetails(_ref) {
  var header = _ref.header,
      content = _ref.content;
  return /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "folder-details"
  }, /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "header"
  }, /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "grey"
  }, header)), /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "content"
  }, /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "content-inner"
  }, content)));
};
// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/folder/folder-header.component.js



var folder_header_component_FolderHeader = function FolderHeader(_ref) {
  var filters = _ref.filters,
      actions = _ref.actions,
      documentationPage = _ref.documentationPage;
  return /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "header"
  }, /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "grey"
  }, /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "container-fluid"
  }, filters && /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "filters"
  }, filters), actions && /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "buttons"
  }, actions), documentationPage && /*#__PURE__*/external_React_default.a.createElement(doc_link_component["a" /* DocLinkComponent */], {
    section: documentationPage
  }))));
};
// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/confirmation-dialog/confirmation-dialog.component.js



var confirmation_dialog_component_ConfirmationDialog = function ConfirmationDialog(_ref) {
  var isOpen = _ref.isOpen,
      onConfirm = _ref.onConfirm,
      onCancel = _ref.onCancel,
      _ref$title = _ref.title,
      title = _ref$title === void 0 ? 'Confirm' : _ref$title,
      _ref$message = _ref.message,
      message = _ref$message === void 0 ? 'Please confirm the action' : _ref$message,
      _ref$confirmationLabe = _ref.confirmationLabel,
      confirmationLabel = _ref$confirmationLabe === void 0 ? 'OK' : _ref$confirmationLabe;
  var confirmationButton = {
    action: 'confirm',
    className: 'button primary',
    keyCodes: [13],
    label: confirmationLabel
  };
  var cancelButton = {
    action: 'cancel',
    className: 'button cancel',
    keyCodes: [27],
    label: 'Cancel'
  };

  var onButtonClick = function onButtonClick(action) {
    if (action === confirmationButton.action) {
      onConfirm();
    } else {
      onCancel();
    }
  };

  return /*#__PURE__*/external_React_default.a.createElement(dist["XlReactWidgetConfirmationDialog"], {
    buttons: [confirmationButton, cancelButton],
    dialogClassName: "xl-default-modal",
    onButtonClick: onButtonClick,
    show: isOpen,
    title: title
  }, message);
};
// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/toggle/toggle.component.js


var toggle_component_ToggleComponent = function ToggleComponent(_ref) {
  var checked = _ref.checked,
      _onChange = _ref.onChange;
  return /*#__PURE__*/external_React_default.a.createElement("label", {
    className: "xl-ui-switch"
  }, /*#__PURE__*/external_React_default.a.createElement("input", {
    checked: checked,
    onChange: function onChange(e) {
      return _onChange(e.target.checked);
    },
    type: "checkbox"
  }), /*#__PURE__*/external_React_default.a.createElement("span", {
    className: "xl-ui-switch-slider round"
  }));
};
// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./core/xlr-ui/app/react/components/avatar/avatar.less
var avatar = __webpack_require__(298);
var avatar_default = /*#__PURE__*/__webpack_require__.n(avatar);

// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/avatar/avatar.less

            

var avatar_options = {};

avatar_options.insert = "head";
avatar_options.singleton = false;

var avatar_update = injectStylesIntoStyleTag_default()(avatar_default.a, avatar_options);



/* harmony default export */ var avatar_avatar = (avatar_default.a.locals || {});
// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/avatar/avatar.component.js





var defaultColors = [{
  background: colors["a" /* default */].green,
  text: colors["a" /* default */].white
}, {
  background: colors["a" /* default */].blue,
  text: colors["a" /* default */].white
}, {
  background: colors["a" /* default */].orange,
  text: colors["a" /* default */].black
}, {
  background: colors["a" /* default */].purple,
  text: colors["a" /* default */].white
}, {
  background: colors["a" /* default */].yellow,
  text: colors["a" /* default */].black
}, {
  background: colors["a" /* default */].red,
  text: colors["a" /* default */].white
}, {
  background: colors["a" /* default */].antracite,
  text: colors["a" /* default */].white
}, {
  background: colors["a" /* default */].lightgray,
  text: colors["a" /* default */].black
}];
var avatar_component_AvatarComponent = function AvatarComponent(_ref) {
  var text = _ref.text,
      _ref$title = _ref.title,
      title = _ref$title === void 0 ? '' : _ref$title;

  var parsedText = function parsedText() {
    var textArray = text.split(' ');

    if (textArray.length > 1) {
      var firstInitial = textArray[0].slice(0, 1).toUpperCase();
      var secondInitial = textArray[1].slice(0, 1).toUpperCase();
      return "".concat(firstInitial).concat(secondInitial);
    } else {
      return text ? text.slice(0, 1).toUpperCase() : '';
    }
  }; // https://en.wikipedia.org/wiki/Linear_congruential_generator


  var stringAsciiPRNG = function stringAsciiPRNG(value, m) {
    // Xn+1 = (a * Xn + c) % m
    // 0 < a < m
    // 0 <= c < m
    // 0 <= X0 < m
    var charCodes = toConsumableArray_default()(value).map(function (letter) {
      return letter.charCodeAt(0);
    });

    var len = charCodes.length;
    var a = len % (m - 1) + 1;
    var c = charCodes.reduce(function (current, next) {
      return current + next;
    }) % m;
    var random = charCodes[0] % m;

    for (var i = 0; i < len; i++) {
      random = (a * random + c) % m;
    }

    return random;
  };

  var getRandomColor = function getRandomColor(value) {
    if (!value) return {
      background: 'transparent',
      color: 'transparent'
    };
    var colorIndex = stringAsciiPRNG(value, defaultColors.length);
    return defaultColors[colorIndex];
  };

  return /*#__PURE__*/external_React_default.a.createElement("span", {
    className: "avatar",
    style: {
      background: getRandomColor(text).background,
      color: getRandomColor(text).text
    },
    title: title
  }, parsedText());
};
// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/index.js






























/***/ }),

/***/ 26:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return getAngularService; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return asyncGetAngularService; });
function getAngularService(name) {
  return angular.element(document.body).injector().get(name);
}
function asyncGetAngularService(name) {
  var service = getAngularService(name);
  return Promise.resolve(service);
}

/***/ }),

/***/ 269:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return DocLinkComponent; });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(0);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);


var DocLinkComponent = function DocLinkComponent(_ref) {
  var section = _ref.section;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("a", {
    className: "xl-icon qmark-icon doc-icon",
    href: "https://docs.xebialabs.com/xl-release/help/".concat(section),
    rel: "noopener noreferrer",
    target: "_blank",
    title: "Open documentation page related to this page in a new browser tab"
  });
};

/***/ }),

/***/ 270:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, "a", function() { return /* binding */ infinite_list_component_InfiniteListComponent; });

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/classCallCheck.js
var classCallCheck = __webpack_require__(4);
var classCallCheck_default = /*#__PURE__*/__webpack_require__.n(classCallCheck);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/createClass.js
var createClass = __webpack_require__(5);
var createClass_default = /*#__PURE__*/__webpack_require__.n(createClass);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/inherits.js
var inherits = __webpack_require__(11);
var inherits_default = /*#__PURE__*/__webpack_require__.n(inherits);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/possibleConstructorReturn.js
var possibleConstructorReturn = __webpack_require__(10);
var possibleConstructorReturn_default = /*#__PURE__*/__webpack_require__.n(possibleConstructorReturn);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/getPrototypeOf.js
var getPrototypeOf = __webpack_require__(8);
var getPrototypeOf_default = /*#__PURE__*/__webpack_require__.n(getPrototypeOf);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/defineProperty.js
var defineProperty = __webpack_require__(1);
var defineProperty_default = /*#__PURE__*/__webpack_require__.n(defineProperty);

// EXTERNAL MODULE: external "React"
var external_React_ = __webpack_require__(0);
var external_React_default = /*#__PURE__*/__webpack_require__.n(external_React_);

// EXTERNAL MODULE: ./node_modules/prop-types/index.js
var prop_types = __webpack_require__(2);
var prop_types_default = /*#__PURE__*/__webpack_require__.n(prop_types);

// EXTERNAL MODULE: ./node_modules/lodash/noop.js
var noop = __webpack_require__(77);
var noop_default = /*#__PURE__*/__webpack_require__.n(noop);

// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/infinite-list/constants.js

var OrderConst = {
  SORT_ASC: 'asc',
  SORT_DESC: 'desc'
};
var Column = prop_types_default.a.shape({
  class: prop_types_default.a.string,
  propertyName: prop_types_default.a.string.isRequired,
  label: prop_types_default.a.string.isRequired,
  sortable: prop_types_default.a.bool.isRequired
});
var OrderBy = prop_types_default.a.shape({
  propertyName: prop_types_default.a.string.isRequired,
  direction: prop_types_default.a.oneOf([OrderConst.SORT_DESC, OrderConst.SORT_ASC])
});
// EXTERNAL MODULE: ./node_modules/classnames/index.js
var classnames = __webpack_require__(12);
var classnames_default = /*#__PURE__*/__webpack_require__.n(classnames);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/extends.js
var helpers_extends = __webpack_require__(54);
var extends_default = /*#__PURE__*/__webpack_require__.n(helpers_extends);

// EXTERNAL MODULE: ./node_modules/lodash/omit.js
var omit = __webpack_require__(526);
var omit_default = /*#__PURE__*/__webpack_require__.n(omit);

// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/checkbox/checkbox.component.js








function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }




var checkbox_component_Checkbox = /*#__PURE__*/function (_Component) {
  inherits_default()(Checkbox, _Component);

  var _super = _createSuper(Checkbox);

  function Checkbox(props) {
    var _this;

    classCallCheck_default()(this, Checkbox);

    _this = _super.call(this, props);
    _this.checkboxRef = /*#__PURE__*/external_React_default.a.createRef();
    return _this;
  }

  createClass_default()(Checkbox, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.updateIndeterminateFlag();
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (prevProps.isIndeterminate !== this.props.isIndeterminate) {
        this.updateIndeterminateFlag();
      }
    }
  }, {
    key: "updateIndeterminateFlag",
    value: function updateIndeterminateFlag() {
      this.checkboxRef.current.indeterminate = this.props.isIndeterminate;
    }
  }, {
    key: "render",
    value: function render() {
      return /*#__PURE__*/external_React_default.a.createElement("input", extends_default()({}, omit_default()(this.props, 'isIndeterminate'), {
        ref: this.checkboxRef,
        type: "checkbox"
      }));
    }
  }]);

  return Checkbox;
}(external_React_["Component"]);

defineProperty_default()(checkbox_component_Checkbox, "defaultProps", {
  isIndeterminate: false
});
// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/infinite-list/infinite-list-header.component.js






function infinite_list_header_component_createSuper(Derived) { var hasNativeReflectConstruct = infinite_list_header_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function infinite_list_header_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }






var infinite_list_header_component_InfiniteListHeaderComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(InfiniteListHeaderComponent, _Component);

  var _super = infinite_list_header_component_createSuper(InfiniteListHeaderComponent);

  function InfiniteListHeaderComponent() {
    classCallCheck_default()(this, InfiniteListHeaderComponent);

    return _super.apply(this, arguments);
  }

  createClass_default()(InfiniteListHeaderComponent, [{
    key: "getNextDirection",
    value: function getNextDirection(propertyName) {
      var orderBy = this.props.orderBy;

      if (orderBy.propertyName !== propertyName) {
        return OrderConst.SORT_DESC;
      } else {
        return orderBy.direction === OrderConst.SORT_DESC ? OrderConst.SORT_ASC : OrderConst.SORT_DESC;
      }
    }
  }, {
    key: "onChangeOrder",
    value: function onChangeOrder(column) {
      this.props.onChangeOrder(column.propertyName, this.getNextDirection(column.propertyName));
    }
  }, {
    key: "renderOrderIcon",
    value: function renderOrderIcon() {
      var orderBy = this.props.orderBy;
      var orderedColumnClassNames = classnames_default()('xl-icon icon-s', {
        'arrow-up-icon': orderBy.direction === OrderConst.SORT_ASC,
        'arrow-down-icon': orderBy.direction === OrderConst.SORT_DESC
      });
      return /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "order-icons"
      }, /*#__PURE__*/external_React_default.a.createElement("i", {
        className: orderedColumnClassNames
      }));
    }
  }, {
    key: "renderDefaultIcon",
    value: function renderDefaultIcon() {
      return /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "order-icons order-default"
      }, /*#__PURE__*/external_React_default.a.createElement("i", {
        className: "xl-icon icon-s arrow-up-icon"
      }), /*#__PURE__*/external_React_default.a.createElement("i", {
        className: "xl-icon icon-s arrow-down-icon"
      }));
    }
  }, {
    key: "renderHeaderCell",
    value: function renderHeaderCell(column) {
      var _this = this;

      var orderBy = this.props.orderBy;
      return /*#__PURE__*/external_React_default.a.createElement("div", {
        className: classnames_default()("list-row-cell ".concat(column.class), {
          'sortable': column.sortable
        }),
        key: column.propertyName,
        onClick: function onClick() {
          return column.sortable && _this.onChangeOrder(column);
        }
      }, column.label, column.sortable && orderBy && (column.propertyName === orderBy.propertyName ? this.renderOrderIcon() : this.renderDefaultIcon()));
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$props = this.props,
          columns = _this$props.columns,
          toggleSelectAll = _this$props.toggleSelectAll,
          rows = _this$props.rows,
          selectedRows = _this$props.selectedRows;
      return /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "list-header"
      }, /*#__PURE__*/external_React_default.a.createElement(checkbox_component_Checkbox, {
        checked: rows.length === selectedRows.length,
        isIndeterminate: selectedRows.length > 0 && selectedRows.length < rows.length,
        onChange: toggleSelectAll
      }), columns.map(function (column) {
        return _this2.renderHeaderCell(column);
      }));
    }
  }]);

  return InfiniteListHeaderComponent;
}(external_React_["Component"]);
// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/assertThisInitialized.js
var assertThisInitialized = __webpack_require__(6);
var assertThisInitialized_default = /*#__PURE__*/__webpack_require__.n(assertThisInitialized);

// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/infinite-list/infinite-list-body.component.js








function infinite_list_body_component_createSuper(Derived) { var hasNativeReflectConstruct = infinite_list_body_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function infinite_list_body_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }



var infinite_list_body_component_InfiniteListBodyComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(InfiniteListBodyComponent, _Component);

  var _super = infinite_list_body_component_createSuper(InfiniteListBodyComponent);

  function InfiniteListBodyComponent(props) {
    var _this;

    classCallCheck_default()(this, InfiniteListBodyComponent);

    _this = _super.call(this, props);

    defineProperty_default()(assertThisInitialized_default()(_this), "loadMore", function () {
      var rowsRef = _this.rowsRef.current;

      if (rowsRef.scrollTop + rowsRef.clientHeight >= rowsRef.scrollHeight) {
        _this.props.loadMore();
      }
    });

    _this.rowsRef = /*#__PURE__*/external_React_default.a.createRef();
    return _this;
  }

  createClass_default()(InfiniteListBodyComponent, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.rowsRef.current.addEventListener('scroll', this.loadMore);
      this.loadMore();
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this.rowsRef.current.removeEventListener('scroll', this.loadMore);
    }
  }, {
    key: "renderRow",
    value: function renderRow(row) {
      var _this2 = this;

      return /*#__PURE__*/external_React_default.a.createElement("span", {
        className: "list-row-view-container",
        key: row.id
      }, /*#__PURE__*/external_React_default.a.createElement("input", {
        checked: this.props.selectedRows.includes(row.id),
        onChange: function onChange() {
          return _this2.props.toggleSelectedRows([row]);
        },
        type: "checkbox"
      }), this.props.renderRow(row));
    }
  }, {
    key: "render",
    value: function render() {
      var _this3 = this;

      var _this$props = this.props,
          rows = _this$props.rows,
          onScrollList = _this$props.onScrollList;
      return /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "list-view-rows",
        onScroll: onScrollList,
        ref: this.rowsRef
      }, rows.map(function (row) {
        return _this3.renderRow(row);
      }));
    }
  }]);

  return InfiniteListBodyComponent;
}(external_React_["Component"]);
// EXTERNAL MODULE: ./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js
var injectStylesIntoStyleTag = __webpack_require__(9);
var injectStylesIntoStyleTag_default = /*#__PURE__*/__webpack_require__.n(injectStylesIntoStyleTag);

// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./core/xlr-ui/app/react/components/infinite-list/infinite-list.component.less
var infinite_list_component = __webpack_require__(291);
var infinite_list_component_default = /*#__PURE__*/__webpack_require__.n(infinite_list_component);

// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/infinite-list/infinite-list.component.less

            

var options = {};

options.insert = "head";
options.singleton = false;

var update = injectStylesIntoStyleTag_default()(infinite_list_component_default.a, options);



/* harmony default export */ var infinite_list_infinite_list_component = (infinite_list_component_default.a.locals || {});
// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/infinite-list/infinite-list.component.js







function infinite_list_component_createSuper(Derived) { var hasNativeReflectConstruct = infinite_list_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function infinite_list_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }









var infinite_list_component_InfiniteListComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(InfiniteListComponent, _Component);

  var _super = infinite_list_component_createSuper(InfiniteListComponent);

  function InfiniteListComponent() {
    classCallCheck_default()(this, InfiniteListComponent);

    return _super.apply(this, arguments);
  }

  createClass_default()(InfiniteListComponent, [{
    key: "renderSpinner",
    value: function renderSpinner() {
      return /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "spinner"
      }, /*#__PURE__*/external_React_default.a.createElement("img", {
        alt: "Loading...",
        src: "static/10.2.14/styles/img/big-ajax-loader.gif"
      }));
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
          loading = _this$props.loading,
          columns = _this$props.columns,
          onChangeOrder = _this$props.onChangeOrder,
          onScrollList = _this$props.onScrollList,
          rows = _this$props.rows,
          noData = _this$props.noData,
          renderRow = _this$props.renderRow,
          listTitle = _this$props.listTitle,
          loadMore = _this$props.loadMore,
          orderBy = _this$props.orderBy,
          toggleSelectedRows = _this$props.toggleSelectedRows,
          toggleSelectAll = _this$props.toggleSelectAll,
          selectedRows = _this$props.selectedRows;
      var hasRows = !!rows.length;
      return /*#__PURE__*/external_React_default.a.createElement("div", {
        className: classnames_default()('infinite-list-container list-view', {
          'infinite-list-loading': loading
        })
      }, /*#__PURE__*/external_React_default.a.createElement("h4", {
        className: "list-view-title"
      }, listTitle), hasRows && /*#__PURE__*/external_React_default.a.createElement(external_React_default.a.Fragment, null, /*#__PURE__*/external_React_default.a.createElement(infinite_list_header_component_InfiniteListHeaderComponent, {
        columns: columns,
        onChangeOrder: onChangeOrder,
        orderBy: orderBy,
        rows: rows,
        selectedRows: selectedRows,
        toggleSelectAll: toggleSelectAll
      }), /*#__PURE__*/external_React_default.a.createElement(infinite_list_body_component_InfiniteListBodyComponent, {
        loadMore: loadMore,
        onScrollList: onScrollList,
        renderRow: renderRow,
        rows: rows,
        selectedRows: selectedRows,
        toggleSelectedRows: toggleSelectedRows
      }), loading && this.renderSpinner()), !hasRows && loading && this.renderSpinner(), !hasRows && !loading && /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "list-view-no-data alert notice"
      }, noData));
    }
  }]);

  return InfiniteListComponent;
}(external_React_["Component"]);

defineProperty_default()(infinite_list_component_InfiniteListComponent, "defaultProps", {
  onScrollList: function onScrollList() {
    return noop_default()();
  }
});

/***/ }),

/***/ 271:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return Backend; });
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4);
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5);
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var angular__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(38);
/* harmony import */ var angular__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(angular__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var ngimport__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(78);
/* harmony import */ var ngimport__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(ngimport__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _xlrelease__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(167);






var Backend;

var BackendServiceImpl = /*#__PURE__*/function () {
  function BackendServiceImpl() {
    _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0___default()(this, BackendServiceImpl);
  }

  _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1___default()(BackendServiceImpl, [{
    key: "post",
    value: function post(url, data, config) {
      if (Object(angular__WEBPACK_IMPORTED_MODULE_3__["isUndefined"])(data)) {
        data = {};
      }

      return ngimport__WEBPACK_IMPORTED_MODULE_4__["$http"].post(url, data, config);
    }
  }, {
    key: "get",
    value: function get(url, config) {
      return ngimport__WEBPACK_IMPORTED_MODULE_4__["$http"].get(url, this._extendWithVersion(this._extendWithCacheBuster(config)));
    }
  }, {
    key: "put",
    value: function put(url, data, config) {
      if (Object(angular__WEBPACK_IMPORTED_MODULE_3__["isUndefined"])(data)) {
        data = {};
      }

      return ngimport__WEBPACK_IMPORTED_MODULE_4__["$http"].put(url, data, this._extendWithVersion(config));
    }
  }, {
    key: "del",
    value: function del(url, config) {
      var extendedConfig = Object(angular__WEBPACK_IMPORTED_MODULE_3__["extend"])({}, BackendServiceImpl.DELETE_CONFIG, config);
      extendedConfig.url = url;
      return ngimport__WEBPACK_IMPORTED_MODULE_4__["$http"].delete(url, this._extendWithVersion(extendedConfig));
    } // overridden in unit tests

  }, {
    key: "_extendWithCacheBuster",
    value: function _extendWithCacheBuster(config) {
      var cacheBuster = {
        cb: new Date().getTime()
      };
      return this.addParams(config, cacheBuster);
    }
  }, {
    key: "_extendWithVersion",
    value: function _extendWithVersion(config) {
      var version = {
        xlrv: _xlrelease__WEBPACK_IMPORTED_MODULE_5__[/* default */ "a"].version
      };
      return this.addParams(config, version);
    }
  }, {
    key: "addParams",
    value: function addParams(config, params) {
      var extendedConfig = config ? Object(angular__WEBPACK_IMPORTED_MODULE_3__["copy"])(config) : {};
      extendedConfig.params = Object(angular__WEBPACK_IMPORTED_MODULE_3__["extend"])({}, extendedConfig.params || {}, params);
      return extendedConfig;
    }
  }]);

  return BackendServiceImpl;
}();

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_2___default()(BackendServiceImpl, "DELETE_CONFIG", {
  method: 'DELETE',
  // IE 8 do not support $http.delete()
  data: null,
  // Without data, Content-Type is deleted
  headers: {
    'Content-Type': 'application/json' // Without Content-Type, Browser's default Content-Type is used

  }
});

Object(angular__WEBPACK_IMPORTED_MODULE_3__["module"])('xlrelease').service('Backend', BackendServiceImpl);
Object(angular__WEBPACK_IMPORTED_MODULE_3__["module"])('xlrelease').run(function () {
  return Backend = ngimport__WEBPACK_IMPORTED_MODULE_4__["$injector"].get('Backend');
});

/***/ }),

/***/ 274:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return DateServiceFactory; });
/* harmony import */ var _releases_list_releases_status_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(107);
/* harmony import */ var _global_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(45);


var ReleasesStatusService = Object(_releases_list_releases_status_service__WEBPACK_IMPORTED_MODULE_0__[/* default */ "a"])();
DateServiceFactory.$inject = ['$filter'];
function DateServiceFactory($filter) {
  return {
    getMoment: function getMoment(dateString) {
      var dateFormat = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : _global_constants__WEBPACK_IMPORTED_MODULE_1__[/* dateTimeFormat */ "a"].ISODateTime;
      return moment(dateString, dateFormat);
    },
    isOverdue: function isOverdue(date) {
      var dateFormat = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : _global_constants__WEBPACK_IMPORTED_MODULE_1__[/* dateTimeFormat */ "a"].unixMillisecondTimestamp;
      if (!date) return false;
      return moment(date, dateFormat).isBefore();
    },
    getOverdueTooltipMessage: function getOverdueTooltipMessage(dueDate, endDate) {
      var compareDate = !!endDate ? moment(endDate) : moment();
      var overdueDuration = moment.duration(compareDate.diff(moment(dueDate)));

      if (overdueDuration.asSeconds() > 60) {
        return "Overdue: ".concat($filter('prettyDuration')(overdueDuration));
      } else {
        return "Overdue: ' ".concat($filter('prettyDuration')(moment.duration(1, 'minutes')));
      }
    },
    getToday: function getToday() {
      return this.atMidnight(moment());
    },
    getTodayWithTime: function getTodayWithTime() {
      return moment().seconds(0).milliseconds(0);
    },
    atMidnight: function atMidnight(date) {
      var dateFormat = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : _global_constants__WEBPACK_IMPORTED_MODULE_1__[/* dateTimeFormat */ "a"].ISODateTime;
      return moment(moment(date, dateFormat).hours(0).minutes(0).seconds(0).milliseconds(0).format());
    },
    getDateStatus: function getDateStatus(currentDay) {
      if (currentDay.isBefore(this.getToday())) {
        return 'past';
      } else if (currentDay.isAfter(this.getToday())) {
        return 'future';
      } else {
        return 'today';
      }
    },
    getStartOrScheduledDate: function getStartOrScheduledDate(planItem) {
      return planItem.startDate || planItem.scheduledStartDate;
    },
    getEndOrDueDate: function getEndOrDueDate(planItem) {
      var date = planItem.endDate || planItem.dueDate;

      if (date && planItem.type === "xlrelease.Release" && ReleasesStatusService.isReleaseInProgress(planItem)) {
        date = Math.max(date, this.getTodayWithTime().valueOf());
      }

      return date;
    },
    getDuration: function getDuration(startDate, endDate) {
      var start = this.getMoment(startDate);
      var end = this.getMoment(endDate);
      var diff = end.diff(start);

      if (diff > 0) {
        var duration = moment.duration(diff);

        if (duration.asMinutes() < 1) {
          return '1m';
        }

        return duration.format('d[d] h[h] m[m]');
      }
    },
    getRemainingDuration: function getRemainingDuration(endDate) {
      var dateFormat = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : _global_constants__WEBPACK_IMPORTED_MODULE_1__[/* dateTimeFormat */ "a"].ISODateTime;
      var currentDate = moment(this.getTodayWithTime());
      var end = this.getMoment(endDate, dateFormat);
      var diff = end.diff(currentDate);
      var duration = moment.duration(diff);

      if (duration.asMinutes() < 1 && duration.asMinutes() >= -1) {
        return "1m";
      } else if (duration.asMinutes() < -1) {
        var displayDate = duration.format('d[d] h[h] m[m]');
        displayDate = displayDate.substr(1, displayDate.length);
        return "Overdue " + displayDate;
      }

      return duration.format('d[d] h[h] m[m]');
    },
    getOverdueDuration: function getOverdueDuration(actualDate, expectedDate) {
      var dateFormat = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : _global_constants__WEBPACK_IMPORTED_MODULE_1__[/* dateTimeFormat */ "a"].unixMillisecondTimestamp;
      var duration = moment.duration(this.getMoment(actualDate, dateFormat).diff(this.getMoment(expectedDate, dateFormat)));

      if (!duration.isValid() || duration.asSeconds() <= 0) {
        return '';
      }

      if (duration.asMinutes() < 1) {
        return "(1m overdue)";
      }

      return "(".concat(duration.format('d[d] h[h] m[m]'), " overdue)");
    },
    getReportDuration: function getReportDuration(durationInMs) {
      var duration = moment.duration(durationInMs);
      return duration < moment.duration(1, 'days').asMilliseconds() ? duration.format('d[d] h[h] m[m] s[s]') : duration.format('d[d] h[h] m[m]');
    },
    checkDatesValidator: function checkDatesValidator(form) {
      return function () {
        if (form) {
          var dueDate = form.dueDate;
          var scheduledStartDate = form.scheduledStartDate;

          if (dueDate && scheduledStartDate) {
            form.hasValidDates = scheduledStartDate <= dueDate;
          }
        }
      };
    }
  };
}

/***/ }),

/***/ 276:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony default export */ __webpack_exports__["a"] = ("<div class=\"item-count-tooltip tooltip in\">\n    <div class=\"tooltip-arrow\"></div>\n    <div class=\"tooltip-inner\">\n        <div ng-init=\"live = $ctrl.itemsCount.live.byStatus\">\n            <p ng-if=\"live.PLANNED > 0\">\n                <i class=\"circle planned\"></i>\n                {{live.PLANNED}} Planned\n            </p>\n            <p ng-if=\"live.IN_PROGRESS > 0\">\n                <i class=\"circle in-progress\"></i>\n                {{live.IN_PROGRESS}} In progress\n            </p>\n            <p ng-if=\"live.QUEUED > 0\">\n                <i class=\"circle queued\"></i>\n                {{live.QUEUED}} Queued\n            </p>\n            <p ng-if=\"live.PAUSED > 0\">\n                <i class=\"circle paused\"></i>\n                {{live.PAUSED}} Paused\n            </p>\n            <p ng-if=\"live.FAILED > 0\">\n                <i class=\"circle failed\"></i>\n                {{live.FAILED}} Failed\n            </p>\n            <p ng-if=\"live.FAILING > 0\">\n                <i class=\"circle failing\"></i>\n                {{live.FAILING}} Failing\n            </p>\n            <p ng-if=\"live.COMPLETED > 0\">\n                <i class=\"circle completed\"></i>\n                {{live.COMPLETED}} Completed\n            </p>\n            <p ng-if=\"live.ABORTED > 0\">\n                <i class=\"circle aborted\"></i>\n                {{live.ABORTED}} Aborted\n            </p>\n        </div>\n        <div ng-init=\"archived = $ctrl.itemsCount.archived.byStatus\">\n            <hr ng-if=\"$ctrl.itemsCount.live.total > 0 && $ctrl.itemsCount.archived.total > 0\"/>\n            <p ng-if=\"$ctrl.itemsCount.archived.total > 0\">\n                <i class=\"xl-icon archive-icon\"></i> Archived\n            </p>\n            <p ng-if=\"archived.COMPLETED > 0\">\n                <i class=\"circle completed\"></i>\n                {{archived.COMPLETED}} Completed\n            </p>\n            <p ng-if=\"archived.ABORTED > 0\">\n                <i class=\"circle aborted\"></i>\n                {{archived.ABORTED}} Aborted\n            </p>\n        </div>\n    </div>\n</div>\n");

/***/ }),

/***/ 277:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return releaseStatusLabelComponent; });
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4);
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5);
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1__);


var HTML = "<div class=\"release-status\">\n    <span class=\"label label-{{$ctrl.getClassSuffix()}}\">{{$ctrl.getLabel()}}</span>\n    <span ng-if=\"$ctrl.isArchived()\" class=\"label label-archived\">Archived</span>\n</div>";

var ReleaseStatusLabelController = /*#__PURE__*/function () {
  function ReleaseStatusLabelController() {
    _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0___default()(this, ReleaseStatusLabelController);
  }

  _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1___default()(ReleaseStatusLabelController, [{
    key: "$onInit",
    value: function $onInit() {
      this._mapping = {
        'IN_PROGRESS': {
          suffix: 'inprogress',
          label: 'In progress'
        },
        'FAILING': {
          suffix: 'warning-failing',
          label: 'Failing'
        },
        'PAUSED': {
          suffix: 'paused',
          label: 'Paused'
        },
        'FAILED': {
          suffix: 'warning-failed',
          label: 'Failed'
        },
        'PLANNED': {
          suffix: 'planned',
          label: 'Planned'
        },
        'ABORTED': {
          suffix: 'aborted',
          label: 'Aborted'
        },
        'COMPLETED': {
          suffix: 'completed',
          label: 'Completed'
        }
      };
    }
  }, {
    key: "getClassSuffix",
    value: function getClassSuffix() {
      return this._mapping[this.release.status].suffix;
    }
  }, {
    key: "getLabel",
    value: function getLabel() {
      return this._mapping[this.release.status].label;
    }
  }, {
    key: "isArchived",
    value: function isArchived() {
      return this.showArchived && this.release && this.release.archived;
    }
  }]);

  return ReleaseStatusLabelController;
}();

ReleaseStatusLabelController.$inject = [];
var releaseStatusLabelComponent = {
  controller: ReleaseStatusLabelController,
  template: HTML,
  bindings: {
    release: '<',
    showArchived: '<'
  }
};

/***/ }),

/***/ 278:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return loadUsernames; });
/* harmony import */ var _http__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(16);

function loadUsernames(release) {
  return Object(_http__WEBPACK_IMPORTED_MODULE_0__[/* httpGET */ "c"])('users/names').then(function (resp) {
    return resp.data;
  });
}

/***/ }),

/***/ 279:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, "a", function() { return /* binding */ compositeFilterComponent; });

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/classCallCheck.js
var classCallCheck = __webpack_require__(4);
var classCallCheck_default = /*#__PURE__*/__webpack_require__.n(classCallCheck);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/createClass.js
var createClass = __webpack_require__(5);
var createClass_default = /*#__PURE__*/__webpack_require__.n(createClass);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/defineProperty.js
var defineProperty = __webpack_require__(1);
var defineProperty_default = /*#__PURE__*/__webpack_require__.n(defineProperty);

// CONCATENATED MODULE: ./core/xlr-ui/app/xlr-components/filter-component/composite-filter/composite-filter.html
/* harmony default export */ var composite_filter = ("<div ng-if=\"$ctrl.isLoading\" class=\"spinner\" style=\"text-align: center\">\n    <img src=\"static/10.2.14/styles/img/big-ajax-loader.gif\" alt=\"Loading...\"/>\n</div>\n<div ng-if=\"!$ctrl.isLoading\" class=\"filter-container\">\n    <div ng-repeat=\"filter in $ctrl.filters\">\n        <p data-ng-if=\"$index > 0\">AND</p>\n        <div class=\"composite-filter\">\n            <select class=\"filter-type-select\"\n                    name=\"filter-type-select\"\n                    ng-model=\"filter.type\"\n                    ng-change=\"$ctrl.onFilterTypeChange(filter)\"\n            >\n                <option value=\"\">Select filter</option>\n                <option ng-repeat=\"availableType in $ctrl.availableTypes\" value=\"{{availableType}}\">{{$ctrl.getFilterByType(availableType).title}}</option>\n            </select>\n            <div ng-if=\"filter.type\">\n                <select ng-model=\"filter.operator\"\n                        ng-change=\"$ctrl.onOperatorChange()\"\n                        class=\"filter-operator-select\">\n                    <option ng-repeat=\"operator in $ctrl.getOperators(filter.type)\" value=\"{{operator.value}}\">{{operator.title}}</option>\n                </select>\n                <div ng-if=\"$ctrl.isFilterTagsInput(filter.type)\" ng-init=\"$ctrl.setFocus()\"\n                     name=\"tags\"\n                     class=\"transparent filter\"\n                     filter-tag-input\n                     placeholder=\"Add more...\"\n                     on-change=\"$ctrl.onFilterChange(tags, filter)\"\n                     tags=\"filter.values\"\n                     completion-candidates=\"$ctrl.getAutoCompleteCandidates(filter.type)\">\n                </div>\n                <div ng-if=\"!$ctrl.isFilterTagsInput(filter.type)\" ng-init=\"$ctrl.setFocus()\"\n                     name=\"tags\"\n                     class=\"transparent filter\"\n                     tags-input\n                     placeholder=\"Add more...\"\n                     on-change=\"$ctrl.onFilterChange(tags, filter)\"\n                     tags=\"filter.values\"\n                     completion-candidates=\"$ctrl.getAutoCompleteCandidates(filter.type)\">\n                </div>\n            </div>\n            <button class=\"filter-remove-btn button\"\n                    ng-click=\"$ctrl.onRemoveFilterClick($index)\"\n                    type=\"button\"\n            ><i class=\"xl-icon delete-icon\"></i></button>\n        </div>\n    </div>\n    <div class=\"horizontal\">\n        <button class=\"filter-add-btn button\"\n                ng-click=\"$ctrl.onAddFilterClick()\"\n                type=\"button\">\n            <i class=\"xl-icon add-icon\"></i>Add filter\n        </button>\n        <button class=\"filter-add-btn button\" ng-click=\"$ctrl.clearAllFilters()\"><i class=\"xl-icon close-icon\"></i>Clear all</button>\n    </div>\n</div>\n");
// EXTERNAL MODULE: ./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js
var injectStylesIntoStyleTag = __webpack_require__(9);
var injectStylesIntoStyleTag_default = /*#__PURE__*/__webpack_require__.n(injectStylesIntoStyleTag);

// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./core/xlr-ui/app/xlr-components/filter-component/composite-filter/composite-filter.less
var composite_filter_composite_filter = __webpack_require__(299);
var composite_filter_default = /*#__PURE__*/__webpack_require__.n(composite_filter_composite_filter);

// CONCATENATED MODULE: ./core/xlr-ui/app/xlr-components/filter-component/composite-filter/composite-filter.less

            

var options = {};

options.insert = "head";
options.singleton = false;

var update = injectStylesIntoStyleTag_default()(composite_filter_default.a, options);



/* harmony default export */ var filter_component_composite_filter_composite_filter = (composite_filter_default.a.locals || {});
// CONCATENATED MODULE: ./core/xlr-ui/app/xlr-components/filter-component/composite-filter/composite-filter-component.js






var composite_filter_component_CompositeFilterController = /*#__PURE__*/function () {
  function CompositeFilterController($element, CompositeFilterService) {
    classCallCheck_default()(this, CompositeFilterController);

    this.$element = $element;
    this.CompositeFilterService = CompositeFilterService;
  }

  createClass_default()(CompositeFilterController, [{
    key: "$onInit",
    value: function $onInit() {
      var _this = this;

      this.isLoading = true;
      this.CompositeFilterService.loadCandidates(this.availableTypes, true).then(function () {
        _this.isLoading = false;
        _this.filters = _this.getStoredFilters();
      }).catch(function () {
        return _this.isLoading = false;
      });
    }
  }, {
    key: "$onChanges",
    value: function $onChanges(changes) {
      var storedFilters = changes.storedFilters;

      if (_.get(storedFilters, ['storedFilters', 'currentValue', 'length'])) {
        this.filters = this.getStoredFilters();
      }
    }
  }, {
    key: "getFilterByType",
    value: function getFilterByType(type) {
      return this.CompositeFilterService.getFilter(type);
    }
  }, {
    key: "isFilterTagsInput",
    value: function isFilterTagsInput(type) {
      return this.getFilterByType(type).filterTag;
    }
  }, {
    key: "getOperators",
    value: function getOperators(type) {
      return this.getFilterByType(type).operators;
    }
  }, {
    key: "getAutoCompleteCandidates",
    value: function getAutoCompleteCandidates(type) {
      return this.getFilterByType(type).loadedAutocompleteCandidates;
    }
  }, {
    key: "setFocus",
    value: function setFocus() {
      this.$element.find('.filter input').focus();
    }
  }, {
    key: "onAddFilterClick",
    value: function onAddFilterClick() {
      var _this2 = this;

      this.filters.push({
        type: null,
        operator: null,
        values: []
      }); // run the scroll after next angularjs render as the filters will be on screen

      setTimeout(function () {
        return _this2.$element.scrollParent().animate({
          scrollTop: 300 * _this2.filters.length
        }, 0);
      }, 0);
    }
  }, {
    key: "onRemoveFilterClick",
    value: function onRemoveFilterClick(index) {
      if (index !== null && angular.isDefined(index)) {
        if (index !== -1) {
          this.filters.splice(index, 1);
          this.triggerOnChange(this.filters.filter(function (f) {
            return f.type && f.values && f.values.length;
          }));
        }
      }
    }
  }, {
    key: "onOperatorChange",
    value: function onOperatorChange() {
      this.triggerOnChange(this.filters);
    }
  }, {
    key: "onFilterChange",
    value: function onFilterChange(tags, filter) {
      if (filter) {
        filter.values = tags;
      }

      this.triggerOnChange(this.filters.filter(function (f) {
        return f.type && f.values && f.values.length;
      }));
    }
  }, {
    key: "triggerOnChange",
    value: function triggerOnChange(filters) {
      this.onChange({
        filters: this.CompositeFilterService.convertToStored(filters)
      });
    }
  }, {
    key: "onFilterTypeChange",
    value: function onFilterTypeChange(filter) {
      filter.values = [];
      filter.operator = filter.type === 'xlrelease.TagsFilter' ? 'CONTAINS_ALL' : 'OR';
    }
  }, {
    key: "getStoredFilters",
    value: function getStoredFilters() {
      return this.CompositeFilterService.convertFromStored(this.storedFilters, this.availableTypes);
    }
  }, {
    key: "clearAllFilters",
    value: function clearAllFilters() {
      this.filters.length = 0;
      this.onChange({
        filters: this.CompositeFilterService.convertToStored(this.filters),
        isEmpty: true
      });
    }
  }]);

  return CompositeFilterController;
}();

defineProperty_default()(composite_filter_component_CompositeFilterController, "$inject", ['$element', 'CompositeFilterService']);

var compositeFilterComponent = {
  bindings: {
    storedFilters: '<',
    availableTypes: '<',
    onChange: '<'
  },
  controller: composite_filter_component_CompositeFilterController,
  template: composite_filter
};

/***/ }),

/***/ 281:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 282:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 283:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 284:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 285:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 286:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 287:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 288:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 289:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 290:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 291:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 292:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 293:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 294:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 295:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 296:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 297:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 298:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 299:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 300:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 3012:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXTERNAL MODULE: ./node_modules/@rweda/layout/source/stable/jquery.layout.js
var jquery_layout = __webpack_require__(1303);

// EXTERNAL MODULE: ./node_modules/blueimp-file-upload/js/jquery.fileupload.js
var jquery_fileupload = __webpack_require__(1304);

// EXTERNAL MODULE: ./node_modules/blueimp-file-upload/js/jquery.iframe-transport.js
var jquery_iframe_transport = __webpack_require__(1306);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/classCallCheck.js
var classCallCheck = __webpack_require__(4);
var classCallCheck_default = /*#__PURE__*/__webpack_require__.n(classCallCheck);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/createClass.js
var createClass = __webpack_require__(5);
var createClass_default = /*#__PURE__*/__webpack_require__.n(createClass);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/auth/authentication-registry.js



var authentication_registry_AuthenticationRegistry = /*#__PURE__*/function () {
  function AuthenticationRegistry() {
    classCallCheck_default()(this, AuthenticationRegistry);

    this.providers = new Map();
  }

  createClass_default()(AuthenticationRegistry, [{
    key: "provider",
    value: function provider(name, config) {
      this.providers.set(name, config);
    }
  }, {
    key: "getProvider",
    value: function getProvider(name) {
      return this.providers.get(name);
    }
  }, {
    key: "getProviders",
    value: function getProviders() {
      return _.sortBy(Array.from(this.providers.values()), 'order');
    }
  }, {
    key: "getAutoProviders",
    value: function getAutoProviders() {
      return _.filter(this.getProviders(), 'autoLogin');
    }
  }, {
    key: "getFormProviders",
    value: function getFormProviders() {
      return _.filter(this.getProviders(), 'formLogin');
    }
  }]);

  return AuthenticationRegistry;
}();

angular.module('xlrelease').service('AuthenticationRegistry', authentication_registry_AuthenticationRegistry);
angular.module('xlrelease').run(['AuthenticationRegistry', '$state', 'RedirectOnLoginService', function (AuthenticationRegistry, $state, RedirectOnLoginService) {
  AuthenticationRegistry.provider('default', {
    order: 10,
    autoLogin: true,
    formLogin: false,
    login: function login() {
      RedirectOnLoginService.registerRequestedURL();
      $state.go('login');
      return true;
    }
  });
}]);
// EXTERNAL MODULE: ./core/xlr-ui/app/js/auth/authenticator.js
var auth_authenticator = __webpack_require__(1307);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/auth/base64.js
var base64 = __webpack_require__(1308);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/auth/redirect-on-login-service.js
var redirect_on_login_service = __webpack_require__(1309);

// CONCATENATED MODULE: ./core/xlr-ui/app/features/folders/folder-constants.js
var DEFAULT_FOLDER_TAB = 'templates';
// CONCATENATED MODULE: ./core/xlr-ui/app/js/breadcrumbs/breadcrumbs-service.js




(function () {
  var BreadcrumbsService = /*#__PURE__*/function () {
    function BreadcrumbsService($rootScope, Events, FolderPathService) {
      classCallCheck_default()(this, BreadcrumbsService);

      this._$rootScope = $rootScope;
      this._Events = Events;
      this._FolderPathService = FolderPathService;
    }

    createClass_default()(BreadcrumbsService, [{
      key: "_mapAndUpdateBreadcrumbs",
      value: function _mapAndUpdateBreadcrumbs(folders, ci) {
        var breadcrumbs = [];

        _.forEach(folders, function (folder) {
          breadcrumbs.push({
            pathSuffix: 'folders/' + folder.id + "/".concat(DEFAULT_FOLDER_TAB),
            label: folder.title
          });
        });

        breadcrumbs.push({
          label: ci.title
        });
        this.updateBreadcrumbs(breadcrumbs, false);
      }
    }, {
      key: "updateBreadcrumbs",
      value: function updateBreadcrumbs(breadcrumbs) {
        var dropFirstCrumb = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
        breadcrumbs = breadcrumbs.length > 1 && dropFirstCrumb ? _.drop(breadcrumbs) : breadcrumbs;

        this._$rootScope.$emit(this._Events.breadcrumbs.update, breadcrumbs);
      }
    }, {
      key: "updateBreadcrumbsWithRelease",
      value: function updateBreadcrumbsWithRelease(release) {
        var _this = this;

        this._FolderPathService.getPathFromReleaseId(release.id).then(function (folders) {
          _this._mapAndUpdateBreadcrumbs(folders, release);
        });
      }
    }, {
      key: "updateBreadcrumbsWithEntity",
      value: function updateBreadcrumbsWithEntity(folderId, entity) {
        var _this2 = this;

        this._FolderPathService.getPathFromParentFolderId(folderId).then(function (folders) {
          _this2._mapAndUpdateBreadcrumbs(folders, entity);
        });
      }
    }, {
      key: "updateBreadcrumbsWithDelivery",
      value: function updateBreadcrumbsWithDelivery(delivery) {
        var breadcrumbs = [];
        breadcrumbs.push({
          pathSuffix: 'deliveries',
          label: 'Deliveries'
        });
        breadcrumbs.push({
          label: delivery.title
        });
        this.updateBreadcrumbs(breadcrumbs, false);
      }
    }, {
      key: "updateBreadcrumbsWithFolder",
      value: function updateBreadcrumbsWithFolder(folder) {
        var _this3 = this;

        this._FolderPathService.getPathFromFolderId(folder.id).then(function (folders) {
          _this3._mapAndUpdateBreadcrumbs(folders, folder);
        });
      }
    }, {
      key: "updateBreadcrumbsWithRiskProfile",
      value: function updateBreadcrumbsWithRiskProfile(riskProfile) {
        var breadcrumbs = [];
        breadcrumbs.push({
          pathSuffix: 'risks',
          label: 'Risk profile settings'
        });
        breadcrumbs.push({
          label: riskProfile.title || "Create new risk profile "
        });
        this.updateBreadcrumbs(breadcrumbs, false);
      }
    }, {
      key: "updateBreadcrumbsWithDashboard",
      value: function updateBreadcrumbsWithDashboard(dashboard) {
        var _this4 = this;

        this._FolderPathService.getPathFromParentFolderId(dashboard.parentId).then(function (folders) {
          _this4._mapAndUpdateBreadcrumbs(folders, dashboard);
        });
      }
    }, {
      key: "updateBreadcrumbsWithTrigger",
      value: function updateBreadcrumbsWithTrigger(trigger) {
        var _this5 = this;

        this._FolderPathService.getPathFromParentFolderId(trigger.folderId).then(function (folders) {
          _this5._mapAndUpdateBreadcrumbs(folders, trigger);
        });
      }
    }]);

    return BreadcrumbsService;
  }();

  BreadcrumbsService.$inject = ['$rootScope', 'Events', 'FolderPathService'];
  angular.module('xlrelease').service('BreadcrumbsService', BreadcrumbsService);
})();
// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/defineProperty.js
var defineProperty = __webpack_require__(1);
var defineProperty_default = /*#__PURE__*/__webpack_require__.n(defineProperty);

// EXTERNAL MODULE: external "angular"
var external_angular_ = __webpack_require__(38);
var external_angular_default = /*#__PURE__*/__webpack_require__.n(external_angular_);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/system-message/system-message-service.js





var system_message_service_SystemMessageService = /*#__PURE__*/function () {
  function SystemMessageService(Backend, $rootScope, Events) {
    classCallCheck_default()(this, SystemMessageService);

    defineProperty_default()(this, "SYSTEM_MESSAGE_ID", 'Configuration/settings/SystemMessageSettings');

    this.Backend = Backend;
    this.$rootScope = $rootScope;
    this.Events = Events;
    this.systemMessage = undefined;
  }

  createClass_default()(SystemMessageService, [{
    key: "saveSystemMessage",
    value: function saveSystemMessage(systemMessage) {
      var _this = this;

      return this.Backend.put("settings/ci/".concat(this.SYSTEM_MESSAGE_ID), systemMessage).then(function (response) {
        _this.systemMessage = response.data;
        return external_angular_default.a.copy(_this.systemMessage);
      });
    }
  }, {
    key: "loadSystemMessage",
    value: function loadSystemMessage() {
      var _this2 = this;

      return this.Backend.get("settings/system-message").then(function (response) {
        _this2.systemMessage = response.data;
        return external_angular_default.a.copy(_this2.systemMessage);
      });
    }
  }, {
    key: "emitSystemMessage",
    value: function emitSystemMessage() {
      var _this3 = this;

      if (external_angular_default.a.isDefined(this.systemMessage)) {
        this.$rootScope.$emit(this.Events.settings.systemMessageUpdated, this.systemMessage);
      } else {
        this.loadSystemMessage().then(function (systemMessage) {
          _this3.$rootScope.$emit(_this3.Events.settings.systemMessageUpdated, systemMessage);
        });
      }
    }
  }, {
    key: "isMessageEnabled",
    value: function isMessageEnabled(systemMessage) {
      if (external_angular_default.a.isUndefined(systemMessage)) return false;
      return (!!systemMessage.automated && !!systemMessage.enabled && this._isInRange(systemMessage.startDate, systemMessage.endDate) || !systemMessage.automated && !!systemMessage.enabled) && !!systemMessage.message;
    }
  }, {
    key: "_isInRange",
    value: function _isInRange(startDate, endDate) {
      if (startDate === null || endDate === null) return false;
      return moment().isBetween(startDate, endDate);
    }
  }]);

  return SystemMessageService;
}();

defineProperty_default()(system_message_service_SystemMessageService, "$inject", ['Backend', '$rootScope', 'Events']);

external_angular_default.a.module('xlrelease').service('SystemMessageService', system_message_service_SystemMessageService);
// CONCATENATED MODULE: ./core/xlr-ui/app/js/calendar/calendar-service.js




var calendar_service_CalendarService = /*#__PURE__*/function () {
  function CalendarService(Backend) {
    classCallCheck_default()(this, CalendarService);

    defineProperty_default()(this, "_withinBlackoutUrl", _.constant('calendar/blackouts/withinBlackout'));

    this.Backend = Backend;
  } // BLACKOUTS


  createClass_default()(CalendarService, [{
    key: "getBlackout",
    value: function getBlackout(id) {
      return this.Backend.get(this._blackoutsUrl(id));
    }
  }, {
    key: "getBlackouts",
    value: function getBlackouts(range) {
      var params = {
        from: range.from.valueOf(),
        to: range.to.valueOf()
      };
      return this.Backend.get(this._blackoutsUrl(), {
        params: params
      });
    }
  }, {
    key: "saveBlackout",
    value: function saveBlackout(blackout) {
      return blackout.id ? this._updateBlackout(blackout) : this._createBlackout(blackout);
    }
  }, {
    key: "deleteBlackout",
    value: function deleteBlackout(id) {
      return this.Backend.del(this._blackoutsUrl(id));
    }
  }, {
    key: "_createBlackout",
    value: function _createBlackout(blackout) {
      return this.Backend.post(this._blackoutsUrl(), this._toBlackoutForm(blackout));
    }
  }, {
    key: "_updateBlackout",
    value: function _updateBlackout(blackout) {
      return this.Backend.put(this._blackoutsUrl(blackout.id), this._toBlackoutForm(blackout));
    }
  }, {
    key: "_toBlackoutForm",
    value: function _toBlackoutForm(blackout) {
      return {
        id: blackout.id || null,
        type: 'xlrelease.Blackout',
        label: blackout.label,
        startDate: moment(blackout.startDate).toISOString(),
        endDate: moment(blackout.endDate).toISOString()
      };
    } // SPECIAL DAYS

  }, {
    key: "getSpecialDay",
    value: function getSpecialDay(date) {
      return this.Backend.get(this._specialDaysUrl(date));
    }
  }, {
    key: "setSpecialDay",
    value: function setSpecialDay(date, specialDay) {
      var params = {
        id: null,
        type: 'xlrelease.SpecialDay',
        label: specialDay.label,
        color: specialDay.color
      };
      return this.Backend.put(this._specialDaysUrl(date), params);
    }
  }, {
    key: "getSpecialDays",
    value: function getSpecialDays(range) {
      var params = {
        from: range.from.valueOf(),
        to: range.to.valueOf()
      };
      return this.Backend.get(this._specialDaysUrl(), {
        params: params
      });
    }
  }, {
    key: "specialDayId",
    value: function specialDayId(date) {
      return "Configuration/Calendar/".concat(date.format('YYYYMMDD'));
    }
  }, {
    key: "withinBlackout",
    value: function withinBlackout() {
      return this.Backend.get(this._withinBlackoutUrl());
    } // PRIVATE

  }, {
    key: "_blackoutsUrl",
    value: function _blackoutsUrl(id) {
      return "calendar/blackouts".concat(id ? '/' + id : '');
    }
  }, {
    key: "_specialDaysUrl",
    value: function _specialDaysUrl(date) {
      return "calendar/specialDays".concat(date ? '/' + this.specialDayId(date) : '');
    }
  }]);

  return CalendarService;
}();

defineProperty_default()(calendar_service_CalendarService, "$inject", ['Backend']);

angular.module('xlrelease').service('CalendarService', calendar_service_CalendarService);
// EXTERNAL MODULE: ./core/xlr-ui/app/js/configuration/configuration-instances-service.js
var configuration_instances_service = __webpack_require__(1310);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/custom/ui-extensions-service.js




function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

var ui_extensions_service_UiExtensionsService = /*#__PURE__*/function () {
  function UiExtensionsService($q, Backend, Authenticator, UiExtensionProperties, FeatureSettingsService) {
    classCallCheck_default()(this, UiExtensionsService);

    this._$q = $q;
    this._Backend = Backend;
    this._Authenticator = Authenticator;
    this._UiExtensionProperties = UiExtensionProperties;
    this._FeatureSettingsService = FeatureSettingsService;
    this._cachedPromise = undefined;
    this._promiseWasRejected = false;
  }

  createClass_default()(UiExtensionsService, [{
    key: "getMainMenuItems",
    value: function getMainMenuItems() {
      return this.getMenuItems('xlrelease.menu.Main');
    }
  }, {
    key: "getReleaseMenuExtensions",
    value: function getReleaseMenuExtensions(release) {
      return this.getMenuItems('xlrelease.ReleasePageMenu', release);
    }
  }, {
    key: "getMenuItems",
    value: function getMenuItems(menuId, container) {
      var _this = this;

      return this._getAllMenuExtensions().then(function (extensions) {
        if (!_.isEmpty(extensions)) {
          return _this._FeatureSettingsService.getFeatures().then(function (features) {
            return _this._filterDisabledFeatures(_this._fillDefaultsAndPermissions(_this._findMenu(extensions, menuId).items, container), features);
          });
        } else {
          return [];
        }
      });
    }
  }, {
    key: "findMenuItemForPath",
    value: function findMenuItemForPath(path) {
      var _this2 = this;

      if (path) {
        path = path[0] === '/' ? path.substr(1) : path;
      }

      return this.getMainMenuItems().then(function (items) {
        var allItems = _this2._flattenMenu(items);

        return _(allItems).filter(function (item) {
          return _.startsWith(path, item.pathSuffix);
        }).sortBy(function (item) {
          return -item.pathSuffix.length;
        }).value()[0];
      });
    }
  }, {
    key: "_getAllMenuExtensions",
    value: function _getAllMenuExtensions() {
      var _this3 = this;

      if (!this._Authenticator.isAuthenticated()) {
        this._cachedPromise = undefined;

        var noItemsPromise = this._$q.defer();

        noItemsPromise.resolve([]);
        return noItemsPromise.promise;
      }

      if (!this._cachedPromise || this._promiseWasRejected) {
        this._cachedPromise = this._Backend.get('api/extension/metadata', {
          headers: {
            'Accept': 'application/json'
          }
        }).then(function (response) {
          _this3._promiseWasRejected = false;
          return response.data;
        }, function () {
          _this3._promiseWasRejected = true;
          return [];
        });
      }

      return this._cachedPromise;
    }
  }, {
    key: "_findMenu",
    value: function _findMenu(items, id) {
      return _.find(items, {
        id: id
      }) || {};
    }
  }, {
    key: "_fillDefaultsAndPermissions",
    value: function _fillDefaultsAndPermissions(items, container) {
      var _this4 = this;

      items = items || [];

      this._forAllItems(items, function (item) {
        item.permitted = _this4._isPermitted(item, container);

        if (_.isUndefined(item.pathSuffix) && item.label) {
          item.pathSuffix = item.label.replace(/[^A-Za-z0-9-_]/g, '').toLowerCase();
        }
      });

      return items;
    }
  }, {
    key: "_filterDisabledFeatures",
    value: function _filterDisabledFeatures(items, features) {
      var featureMap = _.keyBy(features, function (f) {
        return f.type;
      });

      return items.filter(function (item) {
        var featureType = _.get(item, ['properties', 'feature']);

        if (featureType) {
          return !!_.get(featureMap, [featureType, 'enabled']);
        }

        return true;
      });
    }
  }, {
    key: "_isPermitted",
    value: function _isPermitted(item, container) {
      var _this5 = this;

      var PROPERTY_PERMISSIONS = this._UiExtensionProperties.PERMISSIONS;
      var isPermitted = true;

      if (item.properties && item.properties[PROPERTY_PERMISSIONS]) {
        var permissions = _.chain(item.properties[PROPERTY_PERMISSIONS]).split(",").map(function (e) {
          return _.trim(e);
        }).filter(function (e) {
          return !_.isEmpty(e);
        }).value();

        isPermitted = _.isEmpty(permissions) || _.some(permissions, function (perm) {
          return container && _this5._Authenticator.hasPermission(perm, container) || _this5._Authenticator.hasPermission(perm);
        });
      }

      return isPermitted;
    }
  }, {
    key: "_flattenMenu",
    value: function _flattenMenu(items) {
      var allItems = [];

      this._forAllItems(items, function (item) {
        return allItems.push(item);
      });

      return allItems;
    }
  }, {
    key: "_forAllItems",
    value: function _forAllItems(items, fnCallback) {
      var _iterator = _createForOfIteratorHelper(items),
          _step;

      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var item = _step.value;
          fnCallback(item);

          if (item.items) {
            this._forAllItems(item.items, fnCallback);
          }
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
    }
  }]);

  return UiExtensionsService;
}();

defineProperty_default()(ui_extensions_service_UiExtensionsService, "$inject", ['$q', 'Backend', 'Authenticator', 'UiExtensionProperties', 'FeatureSettingsService']);

var ui_extensions_service_UiExtensionProperties = {
  PERMISSIONS: 'permissions'
};
angular.module('xlrelease').constant('UiExtensionProperties', ui_extensions_service_UiExtensionProperties).service('UiExtensionsService', ui_extensions_service_UiExtensionsService);
// CONCATENATED MODULE: ./core/xlr-ui/app/js/directives/view-container-directive.js





var view_container_directive_ViewContainerController = /*#__PURE__*/function () {
  function ViewContainerController($element) {
    classCallCheck_default()(this, ViewContainerController);

    defineProperty_default()(this, "CLASSES", {
      '#release #navigator.navigator-shifted': 144,
      '.dashboard-sidebar': 92,
      '.view-content': 0,
      '#release #navigator': 93,
      '#release #navigator-toggler': 93,
      '#calendar #navigator-toggler': 93,
      '#calendar #navigator': 93,
      '#delivery-flow .fixed-container': 93,
      '#delivery-flow .fixed-container .content-container #scrollable-content #content #top-left': 153
    });

    this.$element = $element;
    this.viewContainerStyle = undefined;
  }

  createClass_default()(ViewContainerController, [{
    key: "$onInit",
    value: function $onInit() {
      this.body = external_angular_default.a.element('body');
      this.css = _.map(this.CLASSES, function (fromTop, className) {
        return "".concat(className, "{top: ").concat(fromTop, "px !important;}");
      }).join('');
      this.setViewContainerStyle();
    }
  }, {
    key: "$onDestroy",
    value: function $onDestroy() {
      if (external_angular_default.a.isDefined(this.viewContainerStyle)) {
        this.viewContainerStyle.remove();
        this.viewContainerStyle = undefined;
      }
    }
  }, {
    key: "setHeight",
    value: function setHeight(height) {
      this.css = _.map(this.CLASSES, function (fromTop, className) {
        return "".concat(className, "{top: ").concat(fromTop + height, "px !important;}");
      }).join('');
      this.setViewContainerStyle();
    }
  }, {
    key: "setViewContainerStyle",
    value: function setViewContainerStyle() {
      if (external_angular_default.a.isUndefined(this.viewContainerStyle)) {
        this.viewContainerStyle = external_angular_default.a.element("<style>".concat(this.css, "</style>")).appendTo(this.body);
      } else if (this.viewContainerStyle.html() !== this.css) {
        this.viewContainerStyle.html(this.css);
      }
    }
  }]);

  return ViewContainerController;
}();

defineProperty_default()(view_container_directive_ViewContainerController, "$inject", ['$element']);

external_angular_default.a.module('xlrelease').directive('viewContainer', [function () {
  return {
    restrict: 'A',
    controller: view_container_directive_ViewContainerController
  };
}]).directive('headerContainer', ['$window', function ($window) {
  return {
    restrict: 'A',
    require: '^^viewContainer',
    link: function link(scope, element, attrs, ctrl) {
      var windowEl = external_angular_default.a.element($window);
      windowEl.bind('resize', function () {
        ctrl.setHeight(element.height());
      });
      scope.$watch(function () {
        return element.height();
      }, function (newHeight) {
        ctrl.setHeight(newHeight);
      });
    }
  };
}]);
// EXTERNAL MODULE: ./core/xlr-ui/app/js/colors.js
var colors = __webpack_require__(21);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/directives/color-picker-directive.js
/*
 * Adapted from :
 *
 *   https://github.com/tkrotoff/jquery-simplecolorpicker
 *   Copyright (C) 2012-2013 Tanguy Krotoff <tkrotoff@gmail.com>
 *
 *   Licensed under the MIT license.
 */

angular.module('xlrelease').value('PhaseColors', [{
  name: "Blue",
  value: colors["a" /* default */].blue
}, {
  name: "Green",
  value: colors["a" /* default */].green
}, {
  name: "Orange",
  value: colors["a" /* default */].orange
}, {
  name: "Red",
  value: colors["a" /* default */].red
}, {
  name: "Grey",
  value: colors["a" /* default */].gray
}, {
  name: "Purple",
  value: colors["a" /* default */].purple
}]);
angular.module('xlrelease').value('DayColors', [// TODO UX: discuss this with UX
{
  name: "None",
  value: ''
}, {
  name: "Blue",
  value: colors["a" /* default */].hoverColor
}, {
  name: "Green",
  value: colors["a" /* default */].successBackground
}, {
  name: "Orange",
  value: colors["a" /* default */].warningBackground
}, {
  name: "Red",
  value: colors["a" /* default */].errorBackground
}]);
angular.module('xlrelease').directive('colorPickerSwatch', function () {
  return {
    templateUrl: 'partials/colorpicker/swatch.html',
    replace: true,
    scope: {
      'color': '=cpColor',
      'currentColor': '=cpCurrentColor'
    },
    link: function link(scope, element) {
      scope.clicked = function () {
        if (element.hasClass('button')) {
          scope.$parent.selectColor(scope.color.value);
        }
      };
    }
  };
});
angular.module('xlrelease').directive('colorPicker', function () {
  var bootstrapArrowWidth = 18,
      bootstrapArrowHeight = 6;
  return {
    templateUrl: 'partials/colorpicker/main.html',
    replace: true,
    scope: {
      'colors': '=',
      'currentColor': '=',
      'onChange': '&',
      'inline': '='
    },
    link: function link(scope, element, attrs) {
      if (!scope.currentColor) {
        scope.currentColor = scope.colors[0].value;
      }

      var picker = element.find('.simplecolorpicker');

      if (attrs.inline) {
        picker.addClass('inline');
      } else {
        picker.addClass('popup');
      }

      var toggler = element.find('.toggle-picker');
      var popup = element.find('.popup');

      var showPicker = function showPicker() {
        var pos = toggler.position();
        popup.css({
          left: pos.left + toggler.width() / 2 - bootstrapArrowWidth + 2,
          top: pos.top + toggler.outerHeight() + bootstrapArrowHeight
        });
        popup.show();
      };

      var hidePicker = function hidePicker() {
        popup.hide();
      };

      var togglePicker = function togglePicker() {
        if (popup.is(':visible')) {
          hidePicker();
        } else {
          showPicker();
        }
      };

      var mouseDown = function mouseDown(e) {
        e.stopPropagation();
        e.preventDefault();
      };

      toggler.on('mousedown', togglePicker);
      element.on('mousedown', '.popup, .toggle-picker', mouseDown);
      element.parents('.phase-header').on('mouseleave', hidePicker);

      scope.selectColor = function (color) {
        scope.currentColor = color;
        hidePicker();
        scope.onChange({
          color: color
        });
      };
    }
  };
});
// EXTERNAL MODULE: ./core/xlr-ui/app/js/directives/attachments-list.js
var attachments_list = __webpack_require__(1311);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/directives/date-editor-directive.js


angular.module('xlrelease').directive('dateEditor', [function () {
  function setValidity(isRequired, value, ngModelCtrl) {
    if (!_.isUndefined(isRequired) && isRequired === true) {
      if (_.isNull(value) || _.isUndefined(value)) {
        ngModelCtrl.$setValidity('ngModel', false);
      } else {
        ngModelCtrl.$setValidity('ngModel', true);
      }
    }
  }

  return {
    templateUrl: "partials/directives/date-editor.html",
    restrict: 'A',
    scope: {
      placeholder: '@',
      onChange: '&',
      ngModel: '=',
      inferredDate: '&',
      deletable: '&',
      readonly: '&',
      dateFormat: '@',
      isRequired: '<'
    },
    require: 'ngModel',
    link: function link(scope, element, attrs, controller) {
      scope.$watch('ngModel', function (newDate, oldDate) {
        setValidity(scope.isRequired, scope.ngModel, controller);

        if (angular.isUndefined(oldDate) && (angular.isUndefined(newDate) || newDate === null)) {
          return;
        }

        if (newDate !== oldDate) {
          scope.onChange();
        }
      });

      scope.deleteDate = function () {
        scope.ngModel = null;
      };

      scope.displayedDate = function () {
        return scope.ngModel || scope.inferredDate();
      };

      scope.hasNoDate = function () {
        return !scope.ngModel;
      };
    }
  };
}]);
angular.module('xlrelease').directive('ganttDateEditor', ['GanttElementsEditor', function (GanttElementsEditor) {
  return {
    scope: true,
    template: "<div date-editor ng-model='date' inferred-date='inferredDate' on-change='setDate(date)' editable='true' deletable='deletable'></div>",
    link: function link(scope, element) {
      var parent = element.parent();
      if (!parent.length) return;
      var timestamp = parent.data('date');
      var id = parent.data('id');
      var type = parent.data('type');
      var date = new Date(parseInt(timestamp, 10));

      if (parent.data('has-own-date')) {
        scope.date = date;
      } else {
        scope.inferredDate = date;
        scope.date = null;
      }

      scope.deletable = parent.data('deletable');
      scope.$watch('date', function (newValue, oldValue) {
        if (newValue !== oldValue) {
          var ganttElement = gantt.getTask(id);

          if (type === 'start') {
            GanttElementsEditor.setStartDate(ganttElement, newValue);
          } else {
            GanttElementsEditor.setEndDate(ganttElement, newValue);
          }
        }
      });
    }
  };
}]);
angular.module('xlrelease').directive('modalDateEditor', function () {
  return {
    templateUrl: "partials/directives/modal-date-editor.html",
    restrict: 'A',
    scope: {
      dateModel: '=',
      readonly: '&',
      dateTitle: '@',
      inferredDate: '&',
      onChange: '&'
    },
    link: function link(scope) {
      scope.removeDate = function () {
        scope.dateModel = null;
      };

      var dateModelWatcher = scope.$watch('dateModel', function (newDate, oldDate) {
        if (angular.isDefined(oldDate) && newDate !== oldDate) {
          scope.onChange();
        }
      });

      scope.displayedDate = function () {
        return scope.dateModel || scope.inferredDate();
      };

      scope.$on('destroy', dateModelWatcher);
    }
  };
});

var date_editor_directive_GridDateEditor = /*#__PURE__*/function () {
  function GridDateEditor() {
    classCallCheck_default()(this, GridDateEditor);

    this.restrict = 'A';
    this.templateUrl = 'partials/directives/grid-date-editor.html';
    this.scope = {
      placeholder: '=',
      date: '=',
      readonly: '&'
    };
  }

  createClass_default()(GridDateEditor, [{
    key: "link",
    value: function link(scope) {
      scope.displayedDate = function () {
        return scope.date;
      };
    }
  }], [{
    key: "factory",
    value: function factory() {
      GridDateEditor.instance = new GridDateEditor();
      return GridDateEditor.instance;
    }
  }]);

  return GridDateEditor;
}();

angular.module('xlrelease').directive('gridDateEditor', date_editor_directive_GridDateEditor.factory);
// EXTERNAL MODULE: ./core/xlr-ui/app/js/global.constants.js
var global_constants = __webpack_require__(45);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/directives/date-time-picker-directive.js

angular.module('xlrelease').directive('dateTimePicker', ['$parse', '$locale', 'DateFormatDetector', 'DateService', 'RegionalSettings', function ($parse, $locale, DateFormatDetector, DateService, RegionalSettings) {
  function overrideDatePart(oldDate, componentDate, dateTimeFormatter, dateFormat) {
    var newDate = moment(componentDate.toISOString());

    var _oldDate = moment(oldDate, dateFormat);

    newDate.hour(_oldDate.hour());
    newDate.minute(_oldDate.minute());
    newDate.second(_oldDate.second());
    return dateTimeFormatter(newDate);
  }

  function overrideTimePart(oldDate, time, dateTimeFormatter, dateFormat) {
    var date = moment(oldDate, dateFormat);
    var newHoursMinutes = moment(time.value, "hh:mm a");
    date.hours(newHoursMinutes.hours());
    date.minutes(newHoursMinutes.minutes());
    date.seconds(0);
    date.milliseconds(0);
    return dateTimeFormatter(date);
  }

  function saveDateAndClosePicker(scope, dateGetter, dateSetter, date, dateTimeFormatter, dateFormat) {
    scope.$apply(function () {
      dateSetter.assign(scope, overrideDatePart(getTodayIfDateIsEmpty(scope, dateGetter), date, dateTimeFormatter, dateFormat));
    });
  }

  function _formatShortDate() {
    var shortFormat = $locale.DATETIME_FORMATS.shortDate.toLowerCase();

    if (shortFormat.match(/y/gi).length < 2) {
      shortFormat = shortFormat.replace('y', 'yy');
    }

    return shortFormat;
  }

  function setupDatePicker(element, scope, dateGetter, dateSetter, dateTimeFormatter, dateFormat) {
    var datePickerHolder = element.find('.date-picker-holder');
    datePickerHolder.datepicker({
      format: _formatShortDate(),
      language: $locale.id,
      autoclose: true,
      weekStart: RegionalSettings.currentFirstDayOfWeek
    });

    var onHide = function onHide() {
      var newDate = datePickerHolder.datepicker('getDate');

      if (moment(newDate).isValid()) {
        saveDateAndClosePicker(scope, dateGetter, dateSetter, newDate, dateTimeFormatter, dateFormat);
      } else {
        var selectedDates = datePickerHolder.datepicker('getDates');

        if (selectedDates.length === 0) {
          // if date was deselected by clicking on the already selected date, set it back again
          // (see bootstrap-datepicker:_toggle_multidate for more details)
          newDate = moment(getTodayIfDateIsEmpty(scope, dateGetter)).toDate();
        } else {
          // if date is invalid reset to the current date
          newDate = DateService.getToday().toDate();
        }

        setDateTime(element, scope, dateGetter, dateFormat);
        saveDateAndClosePicker(scope, dateGetter, dateSetter, newDate, dateTimeFormatter, dateFormat);
      }
    };

    datePickerHolder.datepicker().on('hide', function () {
      return onHide();
    });
    var dateHolder = element.find('.date');

    var onClickDatePickerHolder = function onClickDatePickerHolder() {
      return datePickerHolder.datepicker('show');
    };

    dateHolder.on('click', onClickDatePickerHolder);
    return function () {
      dateHolder.datepicker().off('hide', onHide);
      dateHolder.off('click', onClickDatePickerHolder);
    };
  }

  function setupTimePicker(element, scope, dateGetter, dateSetter, dateTimeFormatter, dateFormat) {
    var timePickerHolder = element.find('.time-picker-holder');
    var ESC_KEY = 27;
    timePickerHolder.timepicker({
      showMeridian: DateFormatDetector.isAmPmVisible()
    });

    var timeClickHandler = function timeClickHandler() {
      timePickerHolder.timepicker('showWidget').one('hide.timepicker', function (event) {
        scope.$apply(function () {
          dateSetter.assign(scope, overrideTimePart(getTodayIfDateIsEmpty(scope, dateGetter), event.time, dateTimeFormatter, dateFormat));
        });
      });
    };

    var timeEl = element.find('.time');
    timeEl.on('click', function () {
      return timeClickHandler();
    });

    var hideTimePicker = function hideTimePicker(e) {
      if (e.keyCode === ESC_KEY) {
        timePickerHolder.timepicker('hideWidget');
      }
    };

    var document = angular.element(document);
    timePickerHolder.one('show.timepicker', function () {
      document.on('keydown', function () {
        hideTimePicker();
      });
    });
    return function () {
      document.off('keydown', hideTimePicker);
      timeEl.off('click', timeClickHandler);
    };
  }

  function getTodayIfDateIsEmpty(scope, dateGetter) {
    if (dateGetter(scope) === null || angular.isUndefined(dateGetter(scope))) {
      var today = new Date();
      today.setSeconds(0);
      today.setMilliseconds(0);
      return today;
    }

    return dateGetter(scope);
  }

  function setDateTime(element, scope, dateGetter, dateFormat) {
    var date = getTodayIfDateIsEmpty(scope, dateGetter);
    var timePickerFormat = DateFormatDetector.isAmPmVisible() ? 'hh:mm A' : 'HH:mm';
    var formattedTime = moment(date, dateFormat).format(timePickerFormat);
    var datePickerHolder = element.find('.date-picker-holder');
    datePickerHolder.datepicker('setDate', DateService.atMidnight(date, dateFormat).toDate());
    var timePickerHolder = element.find('.time-picker-holder');
    timePickerHolder.timepicker('setTime', formattedTime);
  }

  return {
    restrict: 'A',
    link: function link(scope, element, attrs) {
      var parentForm = element.inheritedData('$formController');
      var dateGetter = $parse('displayedDate()');
      var dateSetter = $parse(attrs.date);
      var dateFormat = angular.isDefined(attrs.dateFormat) && !!attrs.dateFormat ? attrs.dateFormat : global_constants["a" /* dateTimeFormat */].unixMillisecondTimestamp;
      var dateSetterWrapper = {
        assign: function assign(scope, value) {
          if (parentForm) {
            parentForm.$setDirty();
          }

          dateSetter.assign(scope, value);
        }
      };

      var dateTimeFormatter = function dateTimeFormatter(dateFormat) {
        return function (dateTime) {
          return angular.isDefined(dateFormat) && !!dateFormat ? moment(dateTime).format(dateFormat) : moment(dateTime).valueOf();
        };
      };

      var clearDatePickerHandlers;
      var clearTimePickerHandlers;
      var readOnlyWatcher = scope.$watch('readonly()', function (isReadOnly) {
        if (!isReadOnly) {
          if (angular.isUndefined(clearDatePickerHandlers)) {
            clearDatePickerHandlers = setupDatePicker(element, scope, dateGetter, dateSetterWrapper, dateTimeFormatter(attrs.dateFormat), dateFormat);
          }

          if (angular.isUndefined(clearTimePickerHandlers)) {
            clearTimePickerHandlers = setupTimePicker(element, scope, dateGetter, dateSetterWrapper, dateTimeFormatter(attrs.dateFormat), dateFormat);
          }
        } else {
          if (angular.isDefined(clearDatePickerHandlers)) {
            clearDatePickerHandlers();
          }

          if (angular.isDefined(clearTimePickerHandlers)) {
            clearTimePickerHandlers();
          }
        }
      });
      var dateWatcher = scope.$watch('displayedDate()', function (newDate) {
        if (angular.isDefined(newDate) && !scope.readonly()) {
          setDateTime(element, scope, dateGetter, dateFormat);
        }
      });
      scope.$on('$destroy', function () {
        element.find('.date').off();
        element.find('.date-picker-holder').datepicker('destroy');
        dateWatcher();
        readOnlyWatcher();

        if (angular.isDefined(clearDatePickerHandlers)) {
          clearDatePickerHandlers();
        }

        if (angular.isDefined(clearTimePickerHandlers)) {
          clearTimePickerHandlers();
        }
      });
    }
  };
}]);
angular.module('xlrelease').factory('DateFormatDetector', ['dateFilter', '$locale', function (dateFilter, $locale) {
  return {
    isAmPmVisible: function isAmPmVisible() {
      var formattedTime = dateFilter(new Date(2013, 0, 1, 14), 'shortTime');
      return !_.includes(formattedTime, '14');
    },
    isMonthDisplayedBeforeDay: function isMonthDisplayedBeforeDay() {
      var shortDate = $locale.DATETIME_FORMATS.shortDate.toLowerCase();
      return shortDate.indexOf('m') < shortDate.indexOf('d');
    }
  };
}]);
// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/slicedToArray.js
var slicedToArray = __webpack_require__(20);
var slicedToArray_default = /*#__PURE__*/__webpack_require__.n(slicedToArray);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/directives/dip-control-directive.js




angular.module('xlrelease').directive('dipControl', [function () {
  return {
    templateUrl: 'partials/directives/dip-control.html',
    controllerAs: 'vm',
    controller: dip_control_directive_DipControlController,
    bindToController: true,
    scope: {
      property: '=',
      container: '=',
      large: '=?',
      readonly: '<',
      useShortId: '<',
      folder: '<?',
      rendererProps: '<?',
      ciDescriptor: '=?',
      validationMessage: '<',
      variables: '<?',
      varMappingRef: '<?'
    },
    require: {
      form: '^'
    }
  };
}]);
var DEPENDENT_PROPERTIES_SUFFIX = "DependentProperties";
var DEPENDENT_PROPERTIES_STRING_SEPARATOR = ";";

var dip_control_directive_DipControlController = /*#__PURE__*/function () {
  function DipControlController($scope, $q, $stateParams, ConfigurationInstances, Ids) {
    var _this = this;

    classCallCheck_default()(this, DipControlController);

    defineProperty_default()(this, "onTypeChange", function (value) {
      if (_this.container[_this.property.name] !== value.selectedId) {
        _this.container[_this.property.name] = value.selectedId;
      }
    });

    defineProperty_default()(this, "onPasswordPropertyChange", function (_ref) {
      var variable = _ref.variable;

      _this.setDirtyForm();

      _this.container[_this.property.name] = variable.value;
      var propName = _this.varMappingRef.path + _this.property.name;

      if (variable.variable) {
        _this.varMappingRef.originVarMapping[propName] = variable.variable;
      } else {
        delete _this.varMappingRef.originVarMapping[propName];
      }
    });

    this.scope = $scope;
    this.ConfigurationInstances = ConfigurationInstances;
    this.$stateParams = $stateParams;
    this.$q = $q;
    this.Ids = Ids;
    this.configurationInstancesLoaded = false;
    this.value = undefined;
    this.items = [];
    this.supportedRenderers = ['TypeBounds'];
    this.renderer = 'BasicInput';
    this.annotation = undefined;
    this.password = undefined;
  }

  createClass_default()(DipControlController, [{
    key: "$onInit",
    value: function $onInit() {
      var _this2 = this;

      var foundRenderer = this.supportedRenderers.find(function (annotation) {
        return _this2.hasAnnotation(annotation);
      });

      if (angular.isDefined(foundRenderer)) {
        this.renderer = foundRenderer;
        this.annotation = this.property.annotations[foundRenderer];
      }

      var realValue = this.container[this.property.name];
      var defaultValue = this.property.default;
      this.container[this.property.name] = angular.isDefined(realValue) ? realValue : defaultValue;
      var vm = this;
      this.ciHandlers = {
        onSelect: function onSelect(newVal) {
          vm.container[vm.property.name] = newVal.id;
        },
        removeElement: function removeElement() {
          delete vm.container[vm.property.name];
        },
        addCandidates: function addCandidates(metadata, options) {
          var deferred = vm.$q.defer();

          var candidates = _.filter(vm.items, function (_ref2) {
            var title = _ref2.title;
            return title.toLowerCase().includes(options.term.toLowerCase());
          });

          deferred.resolve(candidates);
          return deferred.promise;
        }
      };

      if (this.property.kind === 'CI') {
        if (!this.ConfigurationInstances.loaded()) {
          this.loadConfigurationInstances();
        }
      } else if (this.property.kind === 'ENUM') {
        this.enumItems = this.property.enumValues;
      } else if (this.property.password && this.varMappingRef) {
        // initial values
        this.password = {
          value: this.container[this.property.name],
          variable: this.varMappingRef.originVarMapping[this.varMappingRef.path + this.property.name]
        };
      }

      this.watchDependentProperties();
    }
  }, {
    key: "watchDependentProperties",
    value: function watchDependentProperties() {
      var vm = this; // needs ciDescriptor bound

      if (vm.ciDescriptor) {
        var dependentPropertiesMap = vm.ciDescriptor.properties.find(function (p) {
          return p.name === "".concat(vm.property.name, "_").concat(DEPENDENT_PROPERTIES_SUFFIX);
        }); // if some (non hidden) property has a property matching its name and the suffix

        if (dependentPropertiesMap && !vm.property.hidden) {
          // lets set up a watcher on that property to show dependent properties given the selection
          vm.scope.$watch(function () {
            return vm.container[vm.property.name];
          }, function (newValue) {
            var defaultValuesString = dependentPropertiesMap.default[newValue];
            var propNamesToShow = defaultValuesString ? defaultValuesString.split(DEPENDENT_PROPERTIES_STRING_SEPARATOR) : [];

            var _vm$ciDescriptor$prop = vm.ciDescriptor.properties.filter(function (it) {
              return it.category === dependentPropertiesMap.category;
            }).filter(function (it) {
              return it.name !== dependentPropertiesMap.name;
            }).reduce(function (acc, it) {
              acc[propNamesToShow.includes(it.name) ? 0 : 1].push(it);
              return acc;
            }, [[], []]),
                _vm$ciDescriptor$prop2 = slicedToArray_default()(_vm$ciDescriptor$prop, 2),
                propsToShow = _vm$ciDescriptor$prop2[0],
                propsToHide = _vm$ciDescriptor$prop2[1];

            propsToShow.forEach(function (it) {
              return it.hidden = false;
            });
            propsToHide.forEach(function (it) {
              it.hidden = true;
              if (vm.container[it.name]) vm.container[it.name] = null;
            });
          });
        }
      }
    }
  }, {
    key: "$onDestroy",
    value: function $onDestroy() {
      this.ConfigurationInstances.reset();
    }
  }, {
    key: "$onChanges",
    value: function $onChanges(changes) {
      if (changes.folder) {
        this.configurationInstancesLoaded = false;
        this.ConfigurationInstances.reset();
        this.loadConfigurationInstances();
      }
    }
  }, {
    key: "loadConfigurationInstances",
    value: function loadConfigurationInstances() {
      var _this3 = this;

      if (this.property.kind === 'CI') {
        var stateFolderId = this.$stateParams.folderId ? this.$stateParams.folderId : this.Ids.releaseIdToFolderId(this.$stateParams.releaseId);
        var folderId = angular.isUndefined(this.folder) ? stateFolderId : this.folder;
        this.ConfigurationInstances.load(folderId, this.useShortId).then(function (configurationInstances) {
          _this3.configurationInstancesLoaded = true;

          _this3.loadItems();
        });
      }
    }
  }, {
    key: "loadItems",
    value: function loadItems() {
      var _this4 = this;

      this.items = this.ConfigurationInstances.getInstancesByType(this.property.referencedType);
      this.value = this.items.find(function (it) {
        return it.id === _this4.container[_this4.property.name];
      });

      if (this._hasInputHintWithValues()) {
        this.items = this.property.inputHint.values.flatMap(function (hintValue) {
          return hintValue.label === 'configurationTypeHint' ? _this4.ConfigurationInstances.getInstancesByType(hintValue.value) : [];
        });
      }
    }
  }, {
    key: "isError",
    value: function isError(field) {
      return field && (field.$touched || field.$dirty) && field.$invalid;
    }
  }, {
    key: "setDirtyForm",
    value: function setDirtyForm() {
      this.form.$setDirty();
      this.form[this.property.name].$dirty = true;
      this.form.$$element.keyup();
    }
  }, {
    key: "_hasInputHintWithValues",
    value: function _hasInputHintWithValues() {
      var property = this.property;
      return _.has(property, ['inputHint', 'values']);
    }
  }, {
    key: "hasInputHintWithMethodRef",
    value: function hasInputHintWithMethodRef() {
      var property = this.property;
      return _.has(property, ['inputHint', 'method-ref']);
    }
  }, {
    key: "isDynamicLookup",
    value: function isDynamicLookup() {
      var property = this.property;
      return _.has(property, ['inputHint', 'dynamic-lookup']) && _.get(property, ['inputHint', 'dynamic-lookup']);
    }
  }, {
    key: "hasAnnotation",
    value: function hasAnnotation(annotationName) {
      var property = this.property;
      return property.hasOwnProperty('annotations') && annotationName in property.annotations;
    }
  }]);

  return DipControlController;
}();

defineProperty_default()(dip_control_directive_DipControlController, "$inject", ['$scope', '$q', '$stateParams', 'ConfigurationInstances', 'Ids']);
// CONCATENATED MODULE: ./core/xlr-ui/app/js/directives/hover-menu-directive.js

angular.module('xlrelease').directive('hoverMenu', ['Page', function (Page) {
  return {
    restrict: 'A',
    scope: {
      isActiveItem: '='
    },
    link: function link(scope, element) {
      element.on('mouseenter', function () {
        element.css({
          backgroundColor: Page.theme.headerAccentColor,
          color: Page.theme.headerAccentColor === colors["a" /* default */].orange ? colors["a" /* default */].black : colors["a" /* default */].white
        });
      });
      element.on('mouseleave', function () {
        if (!scope.isActiveItem) {
          element.css({
            backgroundColor: '',
            color: colors["a" /* default */].white
          });
        }
      });
    }
  };
}]);
// EXTERNAL MODULE: ./core/xlr-ui/app/js/directives/display-member-directive.js
var display_member_directive = __webpack_require__(1313);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/directives/display-user-directive.js
var display_user_directive = __webpack_require__(1314);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/directives/duration-editor-directive.js
var duration_editor_directive = __webpack_require__(1315);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/directives/expander-directive.js
var expander_directive = __webpack_require__(1316);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/directives/focus-on.js



var focus_on_FocusOnDirective = /*#__PURE__*/function () {
  function FocusOnDirective($timeout) {
    classCallCheck_default()(this, FocusOnDirective);

    this.restrict = 'A';
    this.$timeout = $timeout;
  }

  createClass_default()(FocusOnDirective, [{
    key: "link",
    value: function link(scope, el, attrs) {
      var _this = this;

      scope.$watch(attrs.focusOn, function (val) {
        return _this.$timeout(function () {
          return !!val ? el.focus() : el.blur();
        });
      });
    }
  }]);

  return FocusOnDirective;
}();

angular.module('xlrelease').directive('focusOn', ['$timeout', function ($timeout) {
  return new focus_on_FocusOnDirective($timeout);
}]);
// EXTERNAL MODULE: ./core/xlr-ui/app/js/directives/focus-on-click.js
var focus_on_click = __webpack_require__(1317);

// EXTERNAL MODULE: ./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js
var injectStylesIntoStyleTag = __webpack_require__(9);
var injectStylesIntoStyleTag_default = /*#__PURE__*/__webpack_require__.n(injectStylesIntoStyleTag);

// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./core/xlr-ui/app/js/directives/code-editor/ace-editor.less
var ace_editor = __webpack_require__(715);
var ace_editor_default = /*#__PURE__*/__webpack_require__.n(ace_editor);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/directives/code-editor/ace-editor.less

            

var ace_editor_options = {};

ace_editor_options.insert = "head";
ace_editor_options.singleton = false;

var ace_editor_update = injectStylesIntoStyleTag_default()(ace_editor_default.a, ace_editor_options);



/* harmony default export */ var code_editor_ace_editor = (ace_editor_default.a.locals || {});
// CONCATENATED MODULE: ./core/xlr-ui/app/js/directives/code-editor/xlr-jython-mode.js


function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var MODE_NAME = 'xlr-jython';
var COMPLETION_ITEM_SCORE = 100;

function createMode(metadata) {
  var builtinSupport = _.reduce(metadata, function (acc, variable) {
    var idx = variable.name.lastIndexOf('.');
    var _ref = [variable.name.substring(0, idx), variable.name.substring(idx + 1)],
        packageName = _ref[0],
        className = _ref[1];

    var variableName = _.lowerFirst(className);

    if (/com\.xebialabs\.xlrelease\.(?:.*)(?:api\.v1)/.test(packageName)) {
      acc.variables[variableName] = variable;

      _.reduce(variable.methods, function (acc, m) {
        if (m.annotations.includes('com.xebialabs.xlplatform.documentation.PublicApiMember') && !acc.includes(m.name)) {
          acc.push(m.name);
        }

        return acc;
      }, acc.functions);
    }

    return acc;
  }, {
    variables: {},
    functions: []
  });

  builtinSupport.variables = Object.keys(builtinSupport.variables).sort().reduce(function (acc, key) {
    acc[key] = builtinSupport.variables[key];
    acc[key].methods.sort(byName);
    return acc;
  }, {});

  var builtinSupportVariables = _.keys(builtinSupport.variables);

  var builtinSupportFunctions = builtinSupport.functions;

  var TokenIterator = ace.require('ace/token_iterator').TokenIterator;

  var $modeId = "ace/mode/".concat(MODE_NAME);
  ace.define($modeId, function (require, exports) {
    var oop = require('ace/lib/oop');

    var PythonMode = require('ace/mode/python').Mode;

    var jythonHighlightRules = require("ace/mode/".concat(MODE_NAME, "_highlight_rules")).jythonHighlightRules;

    var Mode = function Mode() {
      this.HighlightRules = jythonHighlightRules;
    };

    oop.inherits(Mode, PythonMode);
    exports.Mode = Mode;
  });
  ace.define("ace/mode/".concat(MODE_NAME, "_highlight_rules"), function (require, exports) {
    var oop = require('ace/lib/oop');

    var PythonHighlightRules = require('ace/mode/python_highlight_rules').PythonHighlightRules;

    var customHighlightRules = function customHighlightRules() {
      PythonHighlightRules.call(this);
      var rules = [{
        token: 'support.variable',
        regex: builtinSupportVariables.join('|')
      }, {
        token: 'support.function',
        regex: builtinSupportFunctions.join('|\.')
      }];

      for (var key in this.$rules) {
        this.$rules[key].unshift.apply(this.$rules[key], rules);
      }
    };

    oop.inherits(customHighlightRules, PythonHighlightRules);
    exports.jythonHighlightRules = customHighlightRules;
  });

  var langTools = ace.require('ace/ext/language_tools');

  var jythonCompleter = {
    getCompletions: function getCompletions(editor, session, pos, prefix, callback) {
      if (session.$modeId !== $modeId) {
        return callback(null, []);
      }

      var stream = new TokenIterator(session, pos.row, pos.column);
      var currToken = stream.getCurrentToken();
      var prevToken = stream.stepBackward();

      if (currToken && currToken.value === '.' && prevToken && prevToken.type === 'support.variable' && builtinSupport.variables[prevToken.value]) {
        var prevValue = undefined;
        var cnt = 0;
        var methods = builtinSupport.variables[prevToken.value].methods;
        var completions = methods.filter(function (it) {
          return it.annotations.includes('com.xebialabs.xlplatform.documentation.PublicApiMember');
        }).map(function (it, index) {
          return {
            value: it.name,
            meta: 'XLRelease API',
            score: COMPLETION_ITEM_SCORE + methods.length - index,
            metadata: it
          };
        })
        /*
            to make autocomplete keep items with the same name
            in sorted array
         */
        .map(function (it) {
          if (angular.isUndefined(prevValue) || it.value !== prevValue) {
            prevValue = it.value;
            cnt = 0;
            return _objectSpread(_objectSpread({}, it), {}, {
              caption: it.value
            });
          }

          return _objectSpread(_objectSpread({}, it), {}, {
            caption: it.value + ' '.repeat(++cnt)
          });
        });
        return callback(null, completions);
      }

      var maybeVariables = builtinSupportVariables.filter(function (it) {
        return it.startsWith(prefix);
      });

      if (maybeVariables) {
        return callback(null, maybeVariables.map(function (it, index) {
          return {
            value: it,
            meta: 'XLRelease API',
            score: COMPLETION_ITEM_SCORE + maybeVariables.length - index,
            metadata: builtinSupport[it]
          };
        }));
      }
    },
    getDocTooltip: function getDocTooltip(item) {
      var docHTML = [];

      if (item.metadata) {
        docHTML.push('<div>', '<span class="ace_doc-name">', "<span class=\"ace_icon ".concat(item.metadata.constructors ? 'ace_icon-object' : 'ace_icon-method', "\"></span>"), item.metadata.name, '</span>', '</div>', "<div class=\"ace_doc-description\">".concat(item.metadata.description, "</div>"));

        if (item.metadata.parameters) {
          docHTML.push('<ul>', item.metadata.parameters.map(function (p) {
            return '<li>' + "<div class=\"ace_doc-p-type\">".concat(p.type, " <span class=\"ace_doc-p-name\">").concat(p.name, "</span></div>") + "<div class=\"ace_doc-p-comment\">".concat(!!p.comment && p.comment, "</div>") + '</li>';
          }).join(''), '</ul>');
        }
      }

      item.docHTML = docHTML.join('');
    }
  };
  langTools.addCompleter(jythonCompleter);
}

/* harmony default export */ var xlr_jython_mode = ({
  name: MODE_NAME,
  initialized: false,
  init: function init() {
    return $.getJSON("static/10.2.14/metadata/".concat(MODE_NAME, ".json"), function (metadata) {
      return createMode(metadata);
    });
  }
});

function byName(a, b) {
  if (a.name < b.name) return -1;
  if (a.name > b.name) return 1;
  return 0;
}
// CONCATENATED MODULE: ./core/xlr-ui/app/js/directives/code-editor/xlr-groovy-mode.js


function xlr_groovy_mode_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function xlr_groovy_mode_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { xlr_groovy_mode_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { xlr_groovy_mode_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var xlr_groovy_mode_MODE_NAME = 'xlr-groovy';
var xlr_groovy_mode_COMPLETION_ITEM_SCORE = 100;

function xlr_groovy_mode_createMode(metadata) {
  var contexts = _.find(metadata, function (m) {
    return !m.plugin;
  }).contexts;

  var builtinDsl = _.chain(contexts).keys().reduce(function (acc, cn) {
    contexts[cn].methods.forEach(function (m) {
      return !acc.includes(m.name) && acc.push(m.name);
    });
    return acc;
  }, ['xlr']).sort().value();

  var $modeId = "ace/mode/".concat(xlr_groovy_mode_MODE_NAME);
  ace.define($modeId, function (require, exports) {
    var oop = require('ace/lib/oop');

    var GroovyMode = require('ace/mode/groovy').Mode;

    var groovyHighlightRules = require("ace/mode/".concat(xlr_groovy_mode_MODE_NAME, "_highlight_rules")).groovyHighlightRules;

    var Mode = function Mode() {
      GroovyMode.call(this);
      this.HighlightRules = groovyHighlightRules;
    };

    oop.inherits(Mode, GroovyMode);
    exports.Mode = Mode;
  });
  ace.define("ace/mode/".concat(xlr_groovy_mode_MODE_NAME, "_highlight_rules"), function (require, exports) {
    var oop = require('ace/lib/oop');

    var GroovyHighlightRules = require('ace/mode/groovy_highlight_rules').GroovyHighlightRules;

    var customHighlightRules = function customHighlightRules() {
      GroovyHighlightRules.call(this);
      var rules = [{
        token: 'support.variable',
        regex: "(".concat(builtinDsl.join('|'), "){1}\\b")
      }];

      for (var key in this.$rules) {
        this.$rules[key].unshift.apply(this.$rules[key], rules);
      }
    };

    oop.inherits(customHighlightRules, GroovyHighlightRules);
    exports.groovyHighlightRules = customHighlightRules;
  });

  var langTools = ace.require('ace/ext/language_tools');

  var groovyCompleter = {
    getCompletions: function getCompletions(editor, session, pos, prefix, callback) {
      if (session.$modeId !== $modeId) {
        return callback(null, []);
      }

      var prevValue = undefined;
      var cnt = 0;
      var vars = builtinDsl.filter(function (m) {
        return m.startsWith(prefix);
      });
      var completions = vars.map(function (m, index) {
        return {
          value: m,
          meta: 'XLRelease DSL',
          score: xlr_groovy_mode_COMPLETION_ITEM_SCORE + vars.length - index
        };
      })
      /*
          to make autocomplete keep items with the same name
          in sorted array
       */
      .map(function (it) {
        if (angular.isUndefined(prevValue) || it.value !== prevValue) {
          prevValue = it.value;
          cnt = 0;
          return xlr_groovy_mode_objectSpread(xlr_groovy_mode_objectSpread({}, it), {}, {
            caption: it.value
          });
        }

        return xlr_groovy_mode_objectSpread(xlr_groovy_mode_objectSpread({}, it), {}, {
          caption: it.value + ' '.repeat(++cnt)
        });
      });
      callback(null, completions);
    }
  };
  langTools.addCompleter(groovyCompleter);
}

/* harmony default export */ var xlr_groovy_mode = ({
  name: xlr_groovy_mode_MODE_NAME,
  initialized: false,
  init: function init() {
    return $.getJSON("static/10.2.14/metadata/".concat(xlr_groovy_mode_MODE_NAME, ".json"), function (metadata) {
      return xlr_groovy_mode_createMode(metadata);
    });
  }
});
// EXTERNAL MODULE: ./node_modules/caret-pos/lib/esm2015/main.js
var main = __webpack_require__(1246);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/directives/inline-editor-directive.js








angular.module('xlrelease').factory('inlineEditor', ['Doc', '$compile', function (Doc, $compile) {
  var setEnableMode = function setEnableMode(scope) {
    scope.enableAutoComplete = angular.isDefined(scope.enableAutoComplete) ? false : scope.enableAutoComplete;
  };

  var leaveEditMode = function leaveEditMode(scope, editable, refocus) {
    scope.editMode = false;
    setEnableMode(scope);
    variableTerm = "";

    if (angular.isUndefined(refocus) || refocus === true) {
      editable.parents(".modal").focus();
    }
  };

  var leaveAutoComplete = function leaveAutoComplete(scope) {
    scope.$apply(function () {
      variableTerm = "";
      startPosition = -1;
      setEnableMode(scope);
    });
  };

  var enableAutoComplete = function enableAutoComplete(scope, editable) {
    scope.$apply(function () {
      variableTerm = "";
      scope.enableAutoComplete = true;

      if (angular.isDefined(editable.autocomplete().data('ui-autocomplete'))) {
        editable.autocomplete('enable');
      }
    });
  };

  var setVariableKey = function setVariableKey(e) {
    if (e.key !== 'Meta') {
      if (COMBINED_KEY_SET.includes(e.which)) {
        variableTerm = variableTerm + e.key;
      } else if (e.which === 8) {
        variableTerm = variableTerm.substring(0, variableTerm.length - 1);
      }
    }

    return variableTerm;
  };

  function validate(scope) {
    var status = scope.validate({
      'draft': scope.draft
    });
    if (angular.isUndefined(status)) // No validation function provided
      return true;
    scope.$apply(function () {
      scope.validationStatus = status;
    });
    return status;
  }

  function commit(scope, editable, draggablePhase, options, refocus) {
    var canCommit = scope.allowCommitOnInvalid === 'true' || isValid(editable) && validate(scope);

    if (!scope.enableAutoComplete) {
      if (draggablePhase && !draggablePhase.hasClass(scope.phaseSortHandle)) {
        draggablePhase.addClass(scope.phaseSortHandle);
      }

      scope.$apply(function () {
        scope.model = options.getModelFromDraft(canCommit ? scope.draft : scope.tempDraft, scope.model);
        leaveEditMode(scope, editable, refocus);
      }); // Callback must be called in a separate apply call in order to update the text property first.

      scope.$apply(function () {
        scope.onChange();
      });
    }
  }

  function rollback(scope, editable, refocus) {
    scope.$apply(function () {
      if (angular.isDefined(scope.enableAutoComplete)) {
        scope.draft = scope.tempDraft;
        scope.model = scope.tempDraft;
      } else {
        scope.draft = scope.model;
      }

      leaveEditMode(scope, editable, refocus);

      if (angular.isDefined(scope.validationStatus)) {
        scope.validationStatus = true;
      }
    });
  }

  function edit(scope, editable, draggablePhase, options) {
    scope.$apply(function () {
      scope.editMode = true;
      scope.draft = options.getDraftFromModel(scope.model);
      scope.tempDraft = options.getDraftFromModel(scope.model);
    });

    if (draggablePhase) {
      draggablePhase.removeClass(scope.phaseSortHandle);
    }

    if (editable.is('select')) {
      editable.focus();
    } else {
      editable.select();
    }
  }

  function commitOnBlur(scope, element, editable, draggablePhase, options) {
    var onClickHandler = function onClickHandler(event) {
      if (scope.editMode && !angular.element.contains(element[0], event.target)) {
        commit(scope, editable, draggablePhase, options);
      }
    };

    var unbindActionHandlers = function unbindActionHandlers() {
      angular.element(document).off('mousedown', onClickHandler);
    };

    unbindActionHandlers();
    angular.element(document).on('mousedown', onClickHandler);
    element.on('$destroy', unbindActionHandlers);
  }

  function switchOnTab(scope, element, editable, draggablePhase, options) {
    var onFocusHandler = function onFocusHandler(event) {
      edit(scope, editable, draggablePhase, options);
    };

    var onTabHandler = function onTabHandler(event) {
      if (event.which === 9 && scope.editMode) {
        commit(scope, editable, draggablePhase, options, false);
      }
    };

    element.find('.focusable').focus(onFocusHandler);
    editable.keydown(onTabHandler);
  }

  function setupAutocomplete(scope, element, editable, draggablePhase, options) {
    scope.$watch('autocompleteData', function (candidates) {
      if (candidates) {
        var autocomplete = editable.autocomplete({
          autoFocus: true,
          source: options.filterCandidates(candidates),
          delay: 0,
          minLength: 0,
          position: {
            my: "left top",
            at: "left bottom",
            collision: "flip",
            within: ".view-container" // ??? jquery 3.5.1 returns undefined for $('.modal-body').offset(), which doesn't exist anyway...

          },
          classes: {
            'ui-autocomplete': scope.autocompleteClasses
          },
          select: function select(event, ui) {
            scope.$apply(function () {
              scope.draft = options.getModelFromCandidate(ui.item);
            });
            commit(scope, editable, draggablePhase, options, false);
          }
        });

        if (angular.isDefined(options.renderAutocompleteItem)) {
          autocomplete.data('ui-autocomplete')._renderItem = options.renderAutocompleteItem;
        }

        editable.focus(function () {
          autocomplete.autocomplete('widget').position(
          /* eslint-disable lodash/preferred-alias */
          $.extend({
            of: editable
          }, autocomplete.autocomplete('option', 'position'))
          /* eslint-enable lodash/preferred-alias */
          );
        });
      }
    });
  }

  function setupRequired(scope, editable, attrs) {
    scope.$watch(attrs.required, function (value) {
      if (angular.isDefined(attrs.required)) {
        scope.isRequired = angular.isDefined(attrs.required) && attrs.required !== false;
      }
    });
  }

  var getCursorPos = function getCursorPos(input) {
    if ("selectionStart" in input && document.activeElement === input) {
      return {
        start: input.selectionStart,
        end: input.selectionEnd
      };
    } else if (input.createTextRange) {
      var sel = document.selection.createRange();

      if (sel.parentElement() === input) {
        var rng = input.createTextRange();
        rng.moveToBookmark(sel.getBookmark());
        var len;
        var pos;

        for (len = 0; rng.compareEndPoints("EndToStart", rng) > 0; rng.moveEnd("character", -1)) {
          len++;
        }

        rng.setEndPoint("StartToStart", input.createTextRange());

        for (pos = {
          start: 0,
          end: len
        }; rng.compareEndPoints("EndToStart", rng) > 0; rng.moveEnd("character", -1)) {
          pos.start++;
          pos.end++;
        }

        return pos;
      }
    }

    return -1;
  };

  function isValid(editable) {
    return editable.hasClass('ng-valid');
  } // Reference for Key codes : https://www.cambiaresearch.com/articles/15/javascript-char-codes-key-codes


  var ALLOWED_KEYS_SET1 = _.range(48, 91);

  var ALLOWED_KEYS_SET2 = _.range(96, 112);

  var ALLOWED_KEYS_SET3 = _.range(186, 192);

  var ALLOWED_KEYS_SET4 = [32, 219, 220, 221, 222];
  var COMBINED_KEY_SET = ALLOWED_KEYS_SET1.concat(ALLOWED_KEYS_SET2).concat(ALLOWED_KEYS_SET3).concat(ALLOWED_KEYS_SET4);
  var variableTerm = "";
  var startPosition = -1;
  var DEFAULT_OPTIONS = {
    multiline: false,
    // Use autocomplete filtering by default
    filterCandidates: angular.identity,
    getModelFromCandidate: function getModelFromCandidate(item) {
      return item.value;
    },
    // Use model for draft by default
    getDraftFromModel: angular.identity,
    // Use draft for model by default
    getModelFromDraft: angular.identity
  };
  return {
    directive: function directive(template, options) {
      options = _.defaults(options || {}, DEFAULT_OPTIONS);
      return {
        restrict: 'A',
        templateUrl: 'partials/inline-editor/' + template,
        scope: {
          name: '@',
          placeholder: '@',
          maxlength: '=',
          model: '=',
          onChange: '&',
          validate: '&',
          validationStatus: '=',
          selectOptions: '=',
          autocompleteData: '=',
          autocompleteClasses: '@',
          allowCommitOnInvalid: '@',
          enableAutoComplete: '=?',
          position: '=?',
          extension: '=?'
        },
        transclude: true,
        link: function link(scope, element, attrs) {
          var elemScrollTop = 0;
          scope.editMode = false;
          setEnableMode(scope);
          var editable = element.find('.editable');
          var draggablePhase = element.parent();
          scope.phaseSortHandle = 'phase-sort-handle';

          var extAttributes = _.get(scope, "extension.attributes", {});

          if (!_.isEmpty(extAttributes)) {
            Object.entries(extAttributes).forEach(function (_ref) {
              var _ref2 = slicedToArray_default()(_ref, 2),
                  key = _ref2[0],
                  value = _ref2[1];

              editable.attr(key, value);
            });
            $compile(editable)(scope);
          }

          if (!draggablePhase.hasClass(scope.phaseSortHandle)) {
            draggablePhase = null;
          } // On click


          element.find('.display').on('click', function (event) {
            if (options.multiline && !angular.element(event.target).hasClass('edit-icon')) {
              return;
            }

            edit(scope, editable, draggablePhase, options);
          });
          element.on('click', '.display-edit-mode', function () {
            edit(scope, editable, draggablePhase, options);
          });

          if (options.multiline) {
            element.find('.ok').on('click', function () {
              setEnableMode(scope);
              commit(scope, editable, draggablePhase, options);
            });
            element.find('.cancel').on('click', function () {
              setEnableMode(scope);
              rollback(scope, editable);
            });
          } else {
            // On enter
            editable.on('keypress', function (e) {
              if (e.which === 13 && e.ctrlKey === false) {
                setEnableMode(scope);
                commit(scope, editable, draggablePhase, options);
                e.preventDefault();
              }
            });
          }

          setupAutocomplete(scope, element, editable, draggablePhase, options);
          setupRequired(scope, editable, attrs); // On blur

          if (!options.doNotCommitOnBlur) {
            commitOnBlur(scope, element, editable, draggablePhase, options);
          }

          editable.on('change', function (event) {
            if (scope.editMode && event.target.type.includes('select-one')) {
              commit(scope, editable, draggablePhase, options);
            }
          }); // On escape

          editable.on('keyup', function (e) {
            if (e.which === 27) {
              setEnableMode(scope);
              rollback(scope, editable);
              e.stopPropagation();
            }
          });
          editable.on('keydown', function (e) {
            if (options.multiline) {
              var pointerLocation = getCursorPos(editable[0]).start;
              var left, top;
              var off = Object(main["a" /* offset */])(editable[0]);

              if (getCursorPos(editable[0]) !== -1) {
                top = off.top - off.height;
                left = off.left;
              }

              elemScrollTop = editable[0].scrollTop;

              if (angular.isDefined(scope.enableAutoComplete) && !scope.enableAutoComplete && scope.draft && scope.draft.substring(pointerLocation - 2, pointerLocation) === "${" && e.which !== 8 && COMBINED_KEY_SET.includes(e.which)) {
                enableAutoComplete(scope, editable);
                setVariableKey(e);

                if (startPosition < 0) {
                  startPosition = pointerLocation;
                }

                scope.position = {
                  'top': top - elemScrollTop,
                  left: left,
                  startPosition: startPosition,
                  'zindex': 100000,
                  'cursor': pointerLocation,
                  'value': variableTerm
                };
              } else if (angular.isDefined(scope.enableAutoComplete) && scope.enableAutoComplete && e.which !== 27) {
                setVariableKey(e);

                if (scope.draft.substring(pointerLocation - 2, pointerLocation) === "${" && variableTerm.length === 0) {
                  leaveAutoComplete(scope);
                } else {
                  scope.position = {
                    'top': top - elemScrollTop,
                    left: left,
                    startPosition: startPosition,
                    'zindex': 100000,
                    'cursor': pointerLocation,
                    'value': variableTerm
                  };
                }
              } else {
                leaveAutoComplete(scope);
              }

              if (e.which === 27) {
                rollback(scope, editable, true);
              }
            }
          }); // On tab

          switchOnTab(scope, element, editable, draggablePhase, options);
          scope.isNumber = angular.isNumber;

          scope.hasText = function (data) {
            return !_.isEmpty(data);
          };

          if (angular.isDefined(attrs.markdown)) {
            scope.helpUrl = Doc.getMarkdownSyntaxURL();
          } // Populate the draft on link so validation attributes run on the correct state


          scope.$watch('model', function (newModel) {
            if (newModel) {
              scope.draft = options.getDraftFromModel(newModel);
            }
          });

          var isVariableWithValueProvider = _.has(scope, 'model.valueProvider'); // convert enum structure


          if (!isVariableWithValueProvider && scope.selectOptions && angular.isString(scope.selectOptions[0])) {
            scope.selectOptions = scope.selectOptions.map(function (item) {
              return {
                id: item,
                title: item
              };
            });

            if (!attrs.required) {
              scope.selectOptions.unshift({
                title: "",
                id: null
              });
            }
          }
        }
      };
    }
  };
}]);
angular.module('xlrelease').directive('inlineTextEditor', function (inlineEditor) {
  return inlineEditor.directive('text-field.html');
});
angular.module('xlrelease').directive('inlinePasswordEditor', function (inlineEditor) {
  return inlineEditor.directive('password-field.html');
});
angular.module('xlrelease').directive('focusWhen', [function () {
  return {
    restrict: 'A',
    link: function link(scope, element, attrs) {
      scope.$watch(attrs.focusWhen, function (value) {
        if (value) {
          setTimeout(function () {
            angular.element(element).focus();
          });
        }
      });
    }
  };
}]);
angular.module('xlrelease').directive('inlineNumberEditor', function (inlineEditor) {
  return inlineEditor.directive('number-field.html');
});
angular.module('xlrelease').directive('inlineTextareaEditor', function (inlineEditor) {
  return inlineEditor.directive('textarea.html', {
    multiline: true
  });
});
angular.module('xlrelease').directive('textareaEditor', function (inlineEditor) {
  return inlineEditor.directive('textarea.html', {
    multiline: true,
    doNotCommitOnBlur: true
  });
});
angular.module('xlrelease').directive('inlineSelectEditor', function (inlineEditor) {
  return inlineEditor.directive('select.html');
});
angular.module('xlrelease').directive('inlineSimpleSelectEditor', function (inlineEditor) {
  return inlineEditor.directive('simple-select.html');
});
angular.module('xlrelease').directive('inlineListEditor', function (inlineEditor) {
  return inlineEditor.directive('list.html');
});

function inlineCodeEditor(inlineEditor, mode, VariablesInterpolator, VariablesService) {
  var codeEditor = inlineEditor.directive('code-editor.html', {
    multiline: true,
    doNotCommitOnBlur: true
  });
  return _.assignIn({}, codeEditor, {
    scope: _.assignIn({}, codeEditor.scope, {
      readOnlyMode: '=',
      variables: '=',
      ignoreScriptVariableInterpolation: '<',
      small: '<',
      resizable: '<',
      mode: '<'
    }),
    link: function link(scope, element, attrs) {
      var ESC_KEY_CODE = 27;
      var aceEditor = element.find('.ace-script-editor');
      var aceScriptEditorContainer = element.find('.ace-script-editor-container');
      var resizableModal = angular.element('#resizable-modal');
      scope.isResizable = _.isUndefined(scope.resizable) || scope.resizable === true;

      var _editor;

      var _isFullScreenMode = false;

      if (scope.isResizable) {
        scope.$watch('editMode', function (editMode) {
          if (editMode) {
            scope.aceToggleFullScreenMode();
          }
        });
      }

      Object.defineProperty(scope, 'codeEditorModel', {
        get: function get() {
          if (scope.editMode || scope.ignoreScriptVariableInterpolation) {
            return scope.draft;
          } else {
            return VariablesInterpolator.interpolateInText(VariablesService.convertToMap(scope.variables), scope.model || '');
          }
        },
        set: function set(value) {
          scope.draft = value;
        }
      });

      scope.aceLoaded = function (editor) {
        var scriptEditorCode = element.find('.ace-script-editor-code');
        _editor = editor;
        editor.$blockScrolling = Infinity;
        editor.setOptions({
          enableBasicAutocompletion: true,
          enableLiveAutocompletion: true
        });
        editor.commands.on('afterExec', function (e) {
          if (e.command.name === 'insertstring' && e.args === '.') {
            editor.execCommand('startAutocomplete');
          }
        });

        if (scope.isResizable) {
          editor.commands.addCommand({
            name: 'exitFullScreenMode',
            bindKey: {
              win: 'ESC',
              mac: 'ESC'
            },
            exec: function exec() {
              aceEditor.removeClass('full-screen');
              aceScriptEditorContainer.append(aceEditor);
              aceEditor.off('keyup', handleExitFullScreenMode);
              editor.resize();
              editor.focus();
              _isFullScreenMode = false;
            },
            readOnly: true
          });
          editor.commands.addCommand({
            name: 'enterFullScreenMode',
            bindKey: {
              win: 'Ctrl-Alt-f',
              mac: 'Command-Alt-f'
            },
            exec: function exec() {
              aceEditor.addClass('full-screen');
              resizableModal.append(aceEditor);
              aceEditor.on('keyup', handleExitFullScreenMode);
              editor.resize();
              editor.focus();
              _isFullScreenMode = true;
            },
            readOnly: true
          });
          editor.keyBinding.addKeyboardHandler(function (editor, hashId, keyString, keyCode, event) {
            if (keyCode === ESC_KEY_CODE) {
              event.preventDefault();
              event.stopPropagation();
              return {
                command: 'null'
              }; // prevent modal close when press esc key
            }
          });
        } else {
          editor.focus();
        }

        if (scope.small) {
          scriptEditorCode.addClass('small');
        }
      };

      if (mode) {
        scope.codeEditorModeInitialized = mode.initialized;

        if (!scope.codeEditorModeInitialized) {
          mode.init().always(function () {
            return scope.$apply(function () {
              scope.codeEditorModeInitialized = mode.initialized = true;
            });
          });
        }

        scope.codeEditorMode = mode.name;
      } else {
        scope.codeEditorModeInitialized = true;
        scope.codeEditorMode = scope.mode;
      }

      scope.aceToggleFullscreenBtn = function ($event) {
        if ($event) {
          $event.preventDefault();
          $event.stopPropagation();
        }

        var currentEditModeState = scope.editMode;

        if (!_isFullScreenMode && !scope.readOnlyMode) {
          scope.editMode = true;

          if (currentEditModeState === scope.editMode) {
            scope.aceToggleFullScreenMode();
          }
        } else {
          scope.aceToggleFullScreenMode();
        }
      };

      scope.aceToggleFullScreenMode = function ($event) {
        if ($event) {
          $event.preventDefault();
          $event.stopPropagation();
        }

        if (_editor) {
          _editor.gotoLine(0, 0);

          _editor.session.setScrollTop(-1);

          _editor.session.setScrollLeft(-1);

          _isFullScreenMode ? _editor.execCommand('exitFullScreenMode') : _editor.execCommand('enterFullScreenMode');
        }
      };

      var handleExitFullScreenMode = function handleExitFullScreenMode(event) {
        event.preventDefault();
        event.stopPropagation();

        if (event.keyCode === ESC_KEY_CODE) {
          _editor.execCommand('exitFullScreenMode');
        }
      };

      codeEditor.link(scope, element, attrs);
    }
  });
}

angular.module('xlrelease').directive('inlineJythonEditor', ['inlineEditor', 'VariablesInterpolator', 'VariablesService', function (inlineEditor, VariablesInterpolator, VariablesService) {
  return inlineCodeEditor(inlineEditor, xlr_jython_mode, VariablesInterpolator, VariablesService);
}]);
angular.module('xlrelease').directive('inlineGroovyEditor', ['inlineEditor', 'VariablesInterpolator', 'VariablesService', function (inlineEditor, VariablesInterpolator, VariablesService) {
  return inlineCodeEditor(inlineEditor, xlr_groovy_mode, VariablesInterpolator, VariablesService);
}]);
angular.module('xlrelease').directive('inlineCodeEditor', ['inlineEditor', 'VariablesInterpolator', 'VariablesService', function (inlineEditor, VariablesInterpolator, VariablesService) {
  return inlineCodeEditor(inlineEditor, null, VariablesInterpolator, VariablesService);
}]);
angular.module('xlrelease').directive('inlineUserEditor', ['inlineEditor', 'UserCompletion', function (inlineEditor, UserCompletion) {
  return inlineEditor.directive('user.html', {
    renderAutocompleteItem: UserCompletion.renderItem,
    filterCandidates: UserCompletion.completionMatcher,
    getModelFromCandidate: UserCompletion.getUserFromItem,
    getDraftFromModel: function getDraftFromModel(model) {
      var username = model ? model.username : '';
      return {
        username: username,
        fullName: ''
      };
    },
    getModelFromDraft: function getModelFromDraft(draft, previousModel) {
      if (previousModel && previousModel.username === draft.username) {
        return previousModel;
      }

      return _.isEmpty(draft.username) ? undefined : draft;
    }
  });
}]);

var inline_editor_directive_InlineDropDownListEditorController = /*#__PURE__*/function () {
  function InlineDropDownListEditorController(VariablesService, $q) {
    var _this = this;

    classCallCheck_default()(this, InlineDropDownListEditorController);

    defineProperty_default()(this, "_hasValueWhichIsNotPresentInList", function (values) {
      return _this.variable.value && !values.includes(_this.variable.value);
    });

    this._variablesService = VariablesService;
    this._$q = $q;
    this._values = [];
    this.isLoaded = false;
    this.isListOfObjects = false;
    this.selectedAutocompleteValue = undefined;
    this.autocompleteHandlers = {
      addCandidates: function addCandidates(metadata, options) {
        return _this.addCandidates(metadata, options);
      },
      onSelect: function onSelect(newValue) {
        _this.selectedAutocompleteValue = newValue;
        _this.variable.value = newValue.id;

        _this.onChange({
          variable: _this.variable
        });
      },
      removeElement: function removeElement() {
        _this.selectedAutocompleteValue = undefined;
        _this.variable.value = undefined;

        _this.onChange({
          variable: _this.variable
        });
      }
    };
  }

  createClass_default()(InlineDropDownListEditorController, [{
    key: "$onInit",
    value: function $onInit() {
      var _this2 = this;

      this._variablesService.getPossibleValues(this.variable).then(function (response) {
        var values = response.data; // use autocomplete dropdown if response contain list of object with keys 'title' and 'id'

        _this2.isListOfObjects = !_.isEmpty(values) && _.every(values, function (value) {
          return _.isPlainObject(value) && _.has(value, "id") && _.has(value, "title");
        });

        if (_this2._hasValueWhichIsNotPresentInList(values) && !_this2.isListOfObjects) {
          values.unshift(_this2.variable.value);
        }

        if (_this2.isListOfObjects) {
          _this2.selectedAutocompleteValue = values.find(function (item) {
            return item.id === _this2.variable.value;
          });
        }

        _this2._values = values;
        _this2.isLoaded = true;
      });
    }
  }, {
    key: "values",
    get: function get() {
      return this._values;
    },
    set: function set(values) {
      this._values = values;
    }
  }, {
    key: "addCandidates",
    value: function addCandidates(metadata, options) {
      var result = this.values.filter(function (item) {
        return item.title.toLowerCase().includes(options.term.toLowerCase());
      });
      return this._$q.resolve(result);
    }
  }]);

  return InlineDropDownListEditorController;
}();

inline_editor_directive_InlineDropDownListEditorController.$inject = ['VariablesService', '$q'];
angular.module('xlrelease').component('inlineDropDownListEditor', {
  bindings: {
    variable: '=',
    onChange: '&'
  },
  controller: inline_editor_directive_InlineDropDownListEditorController,
  templateUrl: 'partials/inline-editor/inline-drop-down-list.html'
});
// EXTERNAL MODULE: ./core/xlr-ui/app/js/directives/not-in-list-directive.js
var not_in_list_directive = __webpack_require__(1318);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/directives/pagination-directive.js
var pagination_directive = __webpack_require__(1319);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/directives/on-click-outside-directive.js
var on_click_outside_directive = __webpack_require__(1320);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/directives/tags-input-directive.js


function tags_input_directive_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function tags_input_directive_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { tags_input_directive_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { tags_input_directive_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

/**
 * @description
 * Directive to manage tag list input with auto-completion.
 *
 * @example
 * <div tags-input tags="releaseForm.tags" placeholder="Add a tag..." completion-candidates="candidates"></div>
 *
 * @param tags List of values within the scope.
 * @param placeholder Placeholder for the input.
 * @param completion-candidates List of candidates values within the scope.
 * @param readOnly Read only mode.
 * @param on-change Callback when tags is updated.
 */
function tagInputsFactory() {
  return {
    directive: function directive(options) {
      options.scope = options.scope || {};
      return {
        templateUrl: options.templateUrl,
        scope: tags_input_directive_objectSpread({
          tags: '=',
          readOnly: '=',
          strict: '=',
          completionCandidates: '<',
          variables: '=',
          placeholder: '@',
          onChange: '&',
          onType: '&'
        }, options.scope),
        controller: ['$scope', '$element', function (scope, element) {
          var ctrl = this;

          ctrl.add = function (tag) {
            if (!options.tagFormat.isEmpty(tag)) {
              var alreadyExist;
              scope.$apply(function () {
                alreadyExist = options.tagFormat.alreadyExist(scope.tags, tag);
                var canAdd = true;

                if (scope.strict) {
                  canAdd = scope.completionCandidates.find(function (e) {
                    return e.name === tag.name;
                  });
                }

                if (!alreadyExist && canAdd) {
                  scope.tags.push(tag);
                  triggerChange();
                  scope.newTag = '';
                } else {
                  scope.newTag = '';
                }
              });

              if (alreadyExist) {
                highlight(tag);
              }
            }
          };

          ctrl.remove = function (tag) {
            scope.tags = _.without(scope.tags, tag);
            triggerChange();
          };

          ctrl.initAutocomplete = function (candidates) {
            var input = element.find('.tag-input');
            var sortedCandidates = candidates.sort(options.tagFormat.comparator);

            var fixPositioning = function fixPositioning(element) {
              element.autocomplete('widget').position(_.assign({
                of: input
              }, element.autocomplete('option', 'position')));
            };

            var autocomplete = input.autocomplete({
              source: function source(request, response) {
                var onlyUnusedTags = scope.tags && scope.tags.length ? sortedCandidates.filter(function (tag) {
                  return !options.tagFormat.alreadyExist(scope.tags, tag);
                }) : sortedCandidates;
                return response(options.autocomplete.sourceFrom(onlyUnusedTags, request, scope));
              },
              delay: 0,
              autoFocus: true,
              select: function select(event, ui) {
                ctrl.add(options.tagFormat.getTagFromAutocomplete(ui.item));
              },
              close: function close() {
                var ul = angular.element(this).autocomplete('widget');
                input.val(scope.newTag);
                ul.removeClass('tags-input-autocomplete');
                ul.css('width', '');
              },
              open: function open() {
                var ul = angular.element(this).autocomplete('widget');
                var ulW = ul.prop('clientWidth');
                ul.addClass('tags-input-autocomplete');
                ul.width('+=' + (ulW - ul.prop('clientWidth')));
                fixPositioning(angular.element(this));
              },
              position: {
                at: 'left bottom',
                my: 'left top',
                collision: 'fit flip'
              }
            });

            if (angular.isDefined(options.autocomplete.renderItem)) {
              autocomplete.data("ui-autocomplete")._renderItem = options.autocomplete.renderItem;
            }
          };

          function triggerChange() {
            if (scope.onChange) scope.onChange({
              'tags': scope.tags
            });
          }

          function highlight(tag) {
            element.find(".tag-label:contains('" + options.tagFormat.getTagLabel(tag) + "')").parents(".tag").effect('highlight');
          }
        }],
        link: function link(scope, element, attributes, ctrl) {
          var hasAutocompletion = angular.isDefined(attributes.completionCandidates);
          scope.newTag = '';
          scope.remove = ctrl.remove;

          if ('autofocus' in attributes) {
            element.find('.tag-input').focus();
          }

          if (hasAutocompletion && !scope.readOnly) {
            scope.$watch('completionCandidates', function (candidates) {
              if (angular.isDefined(candidates)) {
                ctrl.initAutocomplete(candidates);
              }
            });
          }

          element.find('.tag-input').on('keypress', function (event) {
            // on enter
            if (event.which === 13) {
              ctrl.add(options.tagFormat.getTagFromInput(scope.newTag, attributes.tagType));
              event.preventDefault();
            }
          });
          element.find('.tag-input').on('blur', function (event) {
            ctrl.add(options.tagFormat.getTagFromInput(scope.newTag, attributes.tagType));
            event.preventDefault();
          });
          element.find('.tag-input').on('keydown', function (evt) {
            var val = element.find('.tag-input').val();

            if (evt.which === 8 && val.length === 0) {
              scope.$apply(function () {
                return scope.remove(scope.tags.pop());
              });
            }
          });
        }
      };
    }
  };
}

function tagsInput(TagsInputs) {
  return TagsInputs.directive({
    templateUrl: 'partials/directives/tags-input.html',
    tagFormat: {
      comparator: function comparator(tag1, tag2) {
        return tag1.localeCompare(tag2, undefined, {
          numeric: true
        });
      },
      isEmpty: function isEmpty(tag) {
        return tag === '';
      },
      alreadyExist: function alreadyExist(tags, tag) {
        return _.includes(tags, tag);
      },
      getTagLabel: angular.identity,
      getTagFromAutocomplete: function getTagFromAutocomplete(item) {
        return item.value;
      },
      getTagFromInput: angular.identity
    },
    autocomplete: {
      sourceFrom: function sourceFrom(tags, request) {
        // check https://github.com/jquery/jquery-ui/blob/master/ui/widgets/autocomplete.js#L630
        return angular.element.ui.autocomplete.filter(tags, request.term);
      }
    }
  });
}

function membersInput(TagsInputs, MemberType, memberNameFormatterFilter) {
  return TagsInputs.directive({
    templateUrl: 'partials/directives/members-input.html',
    tagFormat: {
      comparator: function comparator(member1, member2) {
        return member1.name.localeCompare(member2.name, undefined, {
          numeric: true
        });
      },
      isEmpty: function isEmpty(member) {
        return member.name === '';
      },
      alreadyExist: function alreadyExist(members, member) {
        return _.some(members, {
          'name': member.name,
          'type': member.type
        });
      },
      getTagLabel: function getTagLabel(member) {
        return member.name;
      },
      getTagFromAutocomplete: function getTagFromAutocomplete(member) {
        return tags_input_directive_objectSpread({}, member);
      },
      getTagFromInput: function getTagFromInput(value, tagType) {
        if (tagType) {
          return {
            name: value,
            type: tagType
          };
        } else {
          return {
            name: value,
            type: MemberType.PRINCIPAL
          };
        }
      }
    },
    autocomplete: {
      sourceFrom: function sourceFrom(members, request) {
        var search = request.term.toLowerCase();

        function matches(name, search) {
          return name ? name.toLowerCase().includes(search) : false;
        }

        var filteredMembers = _.filter(members, function (member) {
          return matches(member.name, search) || matches(member.fullName, search);
        });

        return filteredMembers.slice(0, 100);
      },
      renderItem: function renderItem(ul, member) {
        var div = angular.element('<div>');
        var a = angular.element("<a class=\"".concat(member.type.toLowerCase(), "\"><span class=\"xl-icon tag-icon\">"));
        var label = angular.element('<span class="tag-label">');
        label.append(document.createTextNode(memberNameFormatterFilter(member)));
        label.appendTo(a);
        a.appendTo(div);
        return angular.element('<li>').attr('data-ui-autocomplete-item', angular.toJson(member)).append(div).appendTo(ul);
      }
    }
  });
}

function filterTagInput(TagsInputs) {
  return TagsInputs.directive({
    templateUrl: 'partials/directives/filter-tag-input.html',
    scope: {
      prepend: '<'
    },
    tagFormat: {
      comparator: function comparator(tag1, tag2) {
        return tag1.id.localeCompare(tag2.id, undefined, {
          numeric: true
        });
      },
      isEmpty: function isEmpty(tag) {
        return !tag || !tag.id;
      },
      alreadyExist: function alreadyExist(tags, tag) {
        return !!tags.find(function (t) {
          return t.id === tag.id;
        });
      },
      getTagLabel: function getTagLabel(tag) {
        return tag.title;
      },
      getTagFromAutocomplete: function getTagFromAutocomplete(tag) {
        return tags_input_directive_objectSpread({}, tag);
      },
      getTagFromInput: angular.identity
    },
    autocomplete: {
      sourceFrom: function sourceFrom(candidates, request, scope) {
        var search = request.term.toLowerCase();

        function matches(title, search) {
          return title ? title.toLowerCase().includes(search) : false;
        }

        return candidates.filter(function (candidate) {
          return matches(candidate.title, search);
        }).slice(0, 100);
      },
      renderItem: function renderItem(ul, tag) {
        var jqLite = angular.element('<li>');

        if (!_.isUndefined(tag.tooltip)) {
          jqLite.tooltip({
            title: tag.tooltip,
            container: 'body',
            placement: 'bottom',
            template: '<div class="tooltip" role="tooltip"><div class="tooltip-arrow"></div><div class="tooltip-inner no-max-width"></div></div>'
          });
        }

        return jqLite.append("<a><span class=\"tag-label\">".concat(_.escape(tag.title), "</span></a>")).appendTo(ul);
      }
    }
  });
}
filterTagInput.$inject = ['TagsInputs'];
tagsInput.$inject = ['TagsInputs'];
membersInput.$inject = ['TagsInputs', 'MemberType', 'memberNameFormatterFilter'];
angular.module('xlrelease').factory('TagsInputs', tagInputsFactory);
angular.module('xlrelease').directive('tagsInput', tagsInput);
angular.module('xlrelease').directive('membersInput', membersInput);
angular.module('xlrelease').directive('filterTagInput', filterTagInput);
// EXTERNAL MODULE: ./core/xlr-ui/app/js/directives/stop-event-propagation.js
var stop_event_propagation = __webpack_require__(1321);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/directives/scroll-item-directive.js
var scroll_item_directive = __webpack_require__(1322);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/directives/detect-fully-visible-items-directive.js
var detect_fully_visible_items_directive = __webpack_require__(1323);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/directives/task-context-menu-directive.js
var task_context_menu_directive = __webpack_require__(1324);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/directives/time-zone-directive.js
var time_zone_directive = __webpack_require__(1325);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/directives/tooltip-directive.js
var tooltip_directive = __webpack_require__(1326);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/directives/user-completion-service.js
var user_completion_service = __webpack_require__(1327);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/directives/xlr-dip-of-inline-with-variables-directive.js
var xlr_dip_of_inline_with_variables_directive = __webpack_require__(1328);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/directives/xlr-input-with-variables-directive.js
var xlr_input_with_variables_directive = __webpack_require__(1329);

// EXTERNAL MODULE: ./node_modules/echarts/dist/echarts.common.min.js-exposed
var echarts_common_min_js_exposed = __webpack_require__(699);
var echarts_common_min_js_exposed_default = /*#__PURE__*/__webpack_require__.n(echarts_common_min_js_exposed);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/directives/echarts-directive.js

var THROTTLE_TIMEOUT = 100;
angular.module('xlrelease').directive('echarts', ['$window', 'Events', function ($window, Events) {
  var events = {
    ecClick: 'click',
    ecDblclick: 'dblclick',
    ecMousedown: 'mousedown',
    ecMousemove: 'mousemove',
    ecMouseup: 'mouseup',
    ecMouseover: 'mouseover',
    ecMouseout: 'mouseout'
  };

  var eventsKey = _.keys(events);

  var eventsBinding = _.zipObject(eventsKey, _.map(eventsKey, _.constant('&')));

  return {
    restrict: 'E',
    scope: angular.extend({
      options: '=',
      container: '@'
    }, eventsBinding),
    template: '<div options="options"></div>',
    link: function link(scope, element, attrs) {
      var ngWrapper = element.find('div').get(0);
      var ngParent = scope.container ? angular.element(element).closest(scope.container).get(0) : element.parent().parent().get(0);
      var chart;

      function initChart() {
        chart = echarts_common_min_js_exposed_default.a.init(ngWrapper); // Bind listeners

        _(attrs).keys().forEach(function (attrName) {
          if (eventsKey.includes(attrName)) {
            chart.on(events[attrName], function (params) {
              scope[attrName]({
                params: params
              });
            });
          }
        });
      }

      function updateSize() {
        ngWrapper.style.width = ngParent.clientWidth + 'px';
        ngWrapper.style.height = ngParent.clientHeight + 'px';

        if (chart) {
          chart.resize();
        }
      }

      function setOptions(value) {
        updateSize();

        if (!chart) {
          initChart();
        }

        chart.setOption(value);
      }

      scope.$watch(function () {
        return scope.options;
      }, function (value) {
        return value && setOptions(value);
      }, true); // Add responsiveness to echarts

      var updateSizeWithThrottle = _.throttle(updateSize, THROTTLE_TIMEOUT);

      angular.element($window).on('resize', updateSizeWithThrottle);
      scope.$on(Events.tile.resized, function () {
        return updateSizeWithThrottle();
      });
      scope.$on('$destroy', function () {
        return angular.element($window).off('resize', updateSizeWithThrottle);
      });
    }
  };
}]);
// EXTERNAL MODULE: ./core/xlr-ui/app/js/directives/shorten-content-directive.js
var shorten_content_directive = __webpack_require__(1331);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/directives/handle-first-tab.js
var handle_first_tab = __webpack_require__(1332);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/directives/non-negative.js
var non_negative = __webpack_require__(1333);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/documentation/doc-link-directive.js
var doc_link_directive = __webpack_require__(1334);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/documentation/doc-service.js
var doc_service = __webpack_require__(1335);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/facets/facets-service.js






var facets_service_FacetsService = /*#__PURE__*/function () {
  function FacetsService(Backend) {
    classCallCheck_default()(this, FacetsService);

    this._backend = Backend;
  }

  createClass_default()(FacetsService, [{
    key: "getFacets",
    value: function getFacets(taskId) {
      return this._backend.post("api/v1/facets/search", {
        targetId: taskId
      });
    }
  }, {
    key: "getTypes",
    value: function getTypes(type) {
      return this._backend.get("api/v1/facets/types?baseType=".concat(type));
    }
  }, {
    key: "save",
    value: function save(facet) {
      return this._backend.post('api/v1/facets', facet);
    }
  }, {
    key: "update",
    value: function update(facet) {
      return this._backend.put("api/v1/facets/".concat(facet.id), facet);
    }
  }, {
    key: "remove",
    value: function remove(facetId) {
      return this._backend.del("api/v1/facets/".concat(facetId));
    }
  }, {
    key: "isImmutable",
    value: function isImmutable(facetType) {
      return facetType.superTypes.includes('xlrelease.TaskReportingRecord');
    }
  }]);

  return FacetsService;
}();

defineProperty_default()(facets_service_FacetsService, "$inject", ['Backend']);

angular.module('xlrelease').service('FacetsService', facets_service_FacetsService);
// EXTERNAL MODULE: ./core/xlr-ui/app/js/flags/delayed-line-directive.js
var delayed_line_directive = __webpack_require__(1336);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/flags/flag-line-directive.js
var flag_line_directive = __webpack_require__(1337);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/flags/flag-service.js
var flag_service = __webpack_require__(1338);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/filters/filters-controller.js
var filters_controller = __webpack_require__(1339);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/filters/filters-query-params.js


function filters_query_params_createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = filters_query_params_unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function filters_query_params_unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return filters_query_params_arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return filters_query_params_arrayLikeToArray(o, minLen); }

function filters_query_params_arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

(function () {
  var FiltersQueryParams = function FiltersQueryParams($rootScope, $location, $state, Events, Filters) {
    var _shouldReload = true;
    var previousUrl = null;

    var parseSearchParams = function parseSearchParams(searchString) {
      var searchParams = {};

      _.forEach(searchString.split('&'), function (searchSegment) {
        var _searchSegment$split = searchSegment.split('='),
            _searchSegment$split2 = slicedToArray_default()(_searchSegment$split, 2),
            key = _searchSegment$split2[0],
            value = _searchSegment$split2[1];

        if (_.isUndefined(searchParams[key])) {
          searchParams[key] = decodeURIComponent(value); // If second entry with this name
        } else if (_.isString(searchParams[key])) {
          searchParams[key] = [searchParams[key], decodeURIComponent(value)]; // If third or later entry with this name
        } else {
          searchParams[key].push(decodeURIComponent(value));
        }
      });

      return searchParams;
    }; // gets the state and stateParams based on path and search params


    var getStateAndParams = function getStateAndParams(path, searchParams) {
      var _iterator = filters_query_params_createForOfIteratorHelper($state.get()),
          _step;

      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var state = _step.value;

          if (angular.isFunction(state.$$state)) {
            var internalState = state.$$state();

            if (internalState.url) {
              var params = internalState.url.exec(path, _.keys(parseSearchParams(searchParams)));

              if (params) {
                return {
                  state: state,
                  params: params
                };
              }
            }
          }
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }

      return null;
    };

    var getPath = function getPath(url) {
      var start = url.indexOf('#');
      var end = url.indexOf('?') > 0 ? url.indexOf('?') : url.length;
      return url.substring(start + 1, end);
    };

    var getSearchParams = function getSearchParams(url) {
      return url.indexOf('?') > 0 ? url.substring(url.indexOf('?') + 1, url.length) : '';
    };

    var setPreviousUrl = function setPreviousUrl(prevUrl) {
      var start = prevUrl.indexOf('#');
      previousUrl = prevUrl.substring(start + 1);
    };

    var registerRouteListener = function registerRouteListener() {
      var cachedSearchParams = null; // we save the search path on a failed transition if it matches the errors...

      $rootScope.$on('$stateChangeError', function (evt, toState, toParams, fromState, fromParams, error) {
        if (error && (error === 'FILTERS_NOT_SET' || error === 'CALENDAR_MONTH_NOT_SET')) {
          cachedSearchParams = $location.search();
          $state.go(toState.name, toParams);
        }
      }); // and reapply them at the start if available...

      $rootScope.$on('$stateChangeStart', function () {
        if (cachedSearchParams) {
          $location.search(cachedSearchParams).replace();
          _shouldReload = false;
        }
      }); // and reapply them after a successful one because UI router strips them off...

      $rootScope.$on('$stateChangeSuccess', function () {
        if (cachedSearchParams) {
          $location.search(cachedSearchParams).replace();
          cachedSearchParams = null;
          _shouldReload = false;
        }
      }); // this should mimic this functionality of ngRoute...
      // preparedRouteIsUpdateOnly = preparedRoute && lastRoute && preparedRoute.$$route === lastRoute.$$route
      //     && angular.equals(preparedRoute.pathParams, lastRoute.pathParams)
      //     && !preparedRoute.reloadOnSearch && !forceReload;

      $rootScope.$on('$locationChangeStart', function (evt, next, previous) {
        setPreviousUrl(previous);
        var nextPath = getPath(next);
        var nextSearchParams = getSearchParams(next);
        var nextStateAndParams = getStateAndParams(nextPath, nextSearchParams);

        if (nextStateAndParams) {
          var nextState = nextStateAndParams.state;
          var nextStateParams = nextStateAndParams.params;

          var reloadOnSearch = _.get(nextState, 'reloadOnSearch', true);

          if (!reloadOnSearch) {
            var previousPath = getPath(previous);
            var previousSearchParams = getSearchParams(previous);
            var previousStateAndParams = getStateAndParams(previousPath, previousSearchParams);
            var onlySearchParamsChanged = previousStateAndParams && nextPath === previousPath && nextSearchParams !== previousSearchParams;

            if (onlySearchParamsChanged) {
              if (_shouldReload) {
                $state.transitionTo(nextState, nextStateParams, {
                  reload: nextState.name,
                  inherit: false,
                  location: false
                });
              } else {
                _shouldReload = true;
              }
            }
          }
        }
      });
    };

    return {
      update: function update(filters) {
        _shouldReload = false;
        $location.search(Filters.asQueryString(filters));
        $rootScope.$broadcast(Events.filters.filterChanged, filters);
      },
      updateAsync: function updateAsync(filters) {
        _shouldReload = false;
        $rootScope.$evalAsync(function () {
          $location.search(Filters.asQueryString(filters)).replace();
          $rootScope.$broadcast(Events.filters.filterChanged, filters);
        });
      },
      shouldReload: function shouldReload(value) {
        _shouldReload = value;
      },
      getPreviousUrl: function getPreviousUrl() {
        return previousUrl;
      },
      registerRouteListener: registerRouteListener
    };
  };

  FiltersQueryParams.$inject = ['$rootScope', '$location', '$state', 'Events', 'Filters'];
  angular.module('xlrelease').service('FiltersQueryParams', FiltersQueryParams);
})();
// EXTERNAL MODULE: ./node_modules/redux-persist/es/index.js + 9 modules
var es = __webpack_require__(304);

// EXTERNAL MODULE: ./node_modules/lodash/forEach.js
var forEach = __webpack_require__(716);
var forEach_default = /*#__PURE__*/__webpack_require__.n(forEach);

// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-overview/actions/release-overview-actions.js
var actionTypes = {
  RELEASES_SUCCEEDED: 'RELEASES_SUCCEEDED',
  RELEASES_FAILED: 'RELEASES_FAILED',
  MORE_RELEASES_SUCCEEDED: 'MORE_RELEASES_SUCCEEDED',
  MORE_RELEASES_FAILED: 'MORE_RELEASES_FAILED',
  MORE_RELEASES_REQUESTED: 'MORE_RELEASES_REQUESTED',
  RELEASES_PRE_LOAD: 'RELEASES_PRE_LOAD',
  RISKS_REQUESTED: 'RISKS_REQUESTED',
  RISKS_SUCCEEDED: 'RISKS_SUCCEEDED',
  RISKS_REQUEST_FAILED: 'RISKS_REQUEST_FAILED',
  LOAD_RELEASES: 'LOAD_RELEASES',
  LOAD_RELEASES_IMMEDIATELY: 'LOAD_RELEASES_IMMEDIATELY',
  UPDATE_FILTERS_REQUESTED: 'UPDATE_FILTERS_REQUESTED',
  UPDATE_FILTERS_SUCCEEDED: 'UPDATE_FILTERS_SUCCEEDED',
  TOGGLE_RELEASE: 'TOGGLE_RELEASE',
  START_RELEASES: 'START_RELEASES',
  GROUP_RELEASES: 'GROUP_RELEASES',
  DO_START_RELEASES: 'DO_START_RELEASES',
  ABORT_RELEASES: 'ABORT_RELEASES',
  DO_ABORT_RELEASES: 'DO_ABORT_RELEASES',
  BULK_ACTION_STARTED: 'BULK_ACTION_STARTED',
  BULK_ACTION_STOPPED: 'BULK_ACTION_STOPPED',
  AFTER_BULK_ACTION_EXECUTED: 'AFTER_BULK_ACTION_EXECUTED',
  UNSELECT_ALL: 'UNSELECT_ALL',
  TOGGLE_SELECT_ALL: 'TOGGLE_SELECT_ALL',
  FETCH_TAGS_REQUESTED: 'FETCH_TAGS_REQUESTED',
  FETCH_TAGS_SUCCEEDED: 'FETCH_TAGS_SUCCEEDED',
  COUNT_SUCCEEDED: 'RELEASES_COUNT_SUCCEEDED',
  COUNT_FAILED: 'RELEASES_COUNT_FAILED'
};

var showModalAction = function showModalAction(type) {
  return function (uibModalService) {
    return {
      type: type,
      uibModalService: uibModalService
    };
  };
};

var showModalActionWithPayload = function showModalActionWithPayload(type, payload) {
  return function (uibModalService) {
    return {
      type: type,
      payload: payload,
      uibModalService: uibModalService
    };
  };
};

var release_overview_actions_toggleRelease = function toggleRelease($event, $index, releaseId) {
  return {
    type: actionTypes.TOGGLE_RELEASE,
    payload: {
      $event: $event,
      $index: $index,
      releaseId: releaseId
    }
  };
};
var startReleases = showModalAction(actionTypes.START_RELEASES);
var groupReleases = function groupReleases(uibModalService, selectedReleases) {
  return {
    type: actionTypes.GROUP_RELEASES,
    payload: {
      uibModalService: uibModalService,
      selectedReleases: selectedReleases
    }
  };
};
var release_overview_actions_abortReleases = function abortReleases(uibModalService, abortComment) {
  return showModalActionWithPayload(actionTypes.ABORT_RELEASES, {
    abortComment: abortComment
  })(uibModalService);
};
var getMoreReleases = function getMoreReleases() {
  return {
    type: actionTypes.MORE_RELEASES_REQUESTED
  };
};
var release_overview_actions_getRisks = function getRisks(releaseId) {
  return {
    type: actionTypes.RISKS_REQUESTED,
    payload: releaseId
  };
};
var doAbortAction = function doAbortAction(releaseIds, abortComment) {
  return {
    type: actionTypes.DO_ABORT_RELEASES,
    payload: {
      releaseIds: releaseIds,
      abortComment: abortComment
    }
  };
};
var doStartAction = function doStartAction(releaseIds) {
  return {
    type: actionTypes.DO_START_RELEASES,
    payload: releaseIds
  };
};
var fetchTags = function fetchTags() {
  return {
    type: actionTypes.FETCH_TAGS_REQUESTED
  };
};
var fetchTagsSucceeded = function fetchTagsSucceeded(tags) {
  return {
    type: actionTypes.FETCH_TAGS_SUCCEEDED,
    payload: tags
  };
};
var setFilters = function setFilters(filters) {
  var loadReleases = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
  var loadImmediately = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
  return {
    type: actionTypes.UPDATE_FILTERS_REQUESTED,
    payload: {
      filters: filters,
      loadReleases: loadReleases,
      loadImmediately: loadImmediately
    }
  };
};
var release_overview_actions_toggleSelectAll = function toggleSelectAll() {
  return {
    type: actionTypes.TOGGLE_SELECT_ALL
  };
};
var release_overview_actions_unSelectAll = function unSelectAll() {
  return {
    type: actionTypes.UNSELECT_ALL
  };
};
/* harmony default export */ var release_overview_actions = ({
  setFilters: setFilters
});
// CONCATENATED MODULE: ./core/xlr-ui/app/features/release-groups/actions/release-groups-actions.js
var release_groups_actions_actionTypes = {
  GROUPS_PRE_LOAD: 'GROUPS_PRE_LOAD',
  GROUPS_SUCCEEDED: 'GROUPS_SUCCEEDED',
  GROUPS_FAILED: 'GROUPS_FAILED',
  MORE_GROUPS_SUCCEEDED: 'MORE_GROUPS_SUCCEEDED',
  MORE_GROUPS_FAILED: 'MORE_GROUPS_FAILED',
  MORE_GROUPS_REQUESTED: 'MORE_GROUPS_REQUESTED',
  UPDATE_FILTERS_REQUESTED: 'UPDATE_GROUPS_FILTERS_REQUESTED',
  UPDATE_FILTERS_SUCCEEDED: 'UPDATE_GROUPS_FILTERS_SUCCEEDED',
  UPDATE_FILTERS_FAILED: 'UPDATE_GROUPS_FILTERS_FAILED',
  DO_ADD_RELEASES_SUCCEEDED: 'DO_ADD_RELEASES_SUCCEEDED',
  DO_ADD_RELEASES_REQUESTED: 'DO_ADD_RELEASES_REQUESTED',
  DO_ADD_RELEASES_FAILED: 'DO_ADD_RELEASES_FAILED',
  DO_DELETE_GROUP: 'DELETE_GROUP',
  CONFIRM_DELETE_GROUP: 'CONFIRM_DELETE_GROUP'
};
var getMoreGroups = function getMoreGroups() {
  return {
    type: release_groups_actions_actionTypes.MORE_GROUPS_REQUESTED
  };
};
var release_groups_actions_setFilters = function setFilters(filters) {
  var loadGroups = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
  return {
    type: release_groups_actions_actionTypes.UPDATE_FILTERS_REQUESTED,
    payload: {
      filters: filters,
      loadGroups: loadGroups
    }
  };
};
var doAddRelease = function doAddRelease(groupId, releaseIds, closeModal) {
  return {
    type: release_groups_actions_actionTypes.DO_ADD_RELEASES_REQUESTED,
    payload: {
      groupId: groupId,
      releaseIds: releaseIds,
      closeModal: closeModal
    }
  };
};
var release_groups_actions_deleteGroup = function deleteGroup(id) {
  return {
    type: release_groups_actions_actionTypes.DO_DELETE_GROUP,
    payload: id
  };
};
/* harmony default export */ var release_groups_actions = ({
  setFilters: release_groups_actions_setFilters
});
// EXTERNAL MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries/actions/deliveries-actions.js
var deliveries_actions = __webpack_require__(68);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/filters/filters-service.js





/*
 * Handle the filters available on various pages of the application.
 *
 * The filter settings are always reflected in the URL query parameters, in order to make the pages bookmarkable.
 * In addition, the last used settings are remembered, and used if the page is accessed without query parameters.
 *
 * The functions exposed here are used as route "resolve" handlers in app.js.
 */

angular.module('xlrelease').factory('Filters', ['$q', '$location', '$state', 'ClientSettings', '$ngRedux', function ($q, $location, $state, ClientSettings, $ngRedux) {
  // Defines the parameters of a filter (can be either booleans or strings)
  function filterDefinition(defaults) {
    var booleans = _(defaults).pickBy(function (value) {
      return _.isBoolean(value);
    }).keys().value();

    var strings = _(defaults).pickBy(function (value) {
      return angular.isString(value);
    }).keys().value();

    var hasEmptyDefaultQueryString = _(defaults).values().every(function (value) {
      return value === false || value === '';
    });

    return {
      defaults: defaults,
      names: _.keys(defaults),
      eachBoolean: function eachBoolean(callback) {
        _.forEach(booleans, callback);
      },
      eachString: function eachString(callback) {
        _.forEach(strings, callback);
      },
      hasEmptyDefaultQueryString: hasEmptyDefaultQueryString
    };
  } // Generic algorithm to resolve the filter for a route.


  function generateGetter(defaults, getFromLocalStorage, putInLocalStorage, rules, paths, actionToDispatch) {
    var definition = filterDefinition(defaults);
    return function () {
      var deferred = $q.defer(); // if filter params are provided in the URL, use that

      var queryFilters = fromQueryString($location.search(), definition);

      if (queryFilters) {
        if (rules) {
          queryFilters = rules(queryFilters);
        }

        if (isReduxCompatible(paths)) {
          if (actionToDispatch) {
            $ngRedux.dispatch(actionToDispatch(queryFilters));
          }
        } else {
          putInLocalStorage(queryFilters);
        }

        deferred.resolve(queryFilters);
      } else {
        // have to reject or the state will be loaded twice
        if (isReduxCompatible(paths)) {
          restoreFromRedux(rules, deferred, paths[0]);
        } else {
          useSavedOrDefaultsFilters(rules);
          deferred.reject('FILTERS_NOT_SET');
        }
      }

      return deferred.promise;
    };

    function isReduxCompatible(paths) {
      return paths && paths.includes($location.path());
    }

    function restoreFromRedux(rules, deferred, path) {
      Object(es["c" /* getStoredState */])({
        keyPrefix: 'filters:'
      }, function (err, loaded) {
        var filters = definition.defaults;

        if (!err) {
          var state = $state.get().find(function (state) {
            return state.url === path;
          });
          var stateName = state.name === 'default' ? 'releaseOverview' : state.name;

          if (loaded[stateName]) {
            filters = loaded[stateName].filters;
          }
        }

        if (rules) {
          filters = rules(filters);
        }

        $location.search(asQueryString(filters)).replace();
        deferred.reject('FILTERS_NOT_SET');
      });
    }

    function useSavedOrDefaultsFilters(rules) {
      var queryString = $location.search();
      var filters = getFromLocalStorage() || definition.defaults;

      if (rules) {
        filters = rules(filters);
      }

      _.assign(queryString, asQueryString(filters));

      $location.search(queryString).replace();
    }
  }

  function generateMapItemGetter(defaults, getFromLocalStorage, putInLocalStorage, rules) {
    return function (id) {
      return generateGetter(defaults, _.partial(getFromLocalStorage, id), _.partial(putInLocalStorage, id), rules)();
    };
  } // Used to mark the URL once we have applied filters retrieved from local storage.
  // Without this param we would not be able to differentiate the following cases:
  // 1) 'empty' configuration (all booleans false and all strings empty) that was
  //    previously set by the user
  // 2) no configuration at all (first access to the page)


  var HAS_FILTER = "has_filter";
  var MUST_NOT_BE_EMPTY = ["timeFrame", "orderBy"];

  function fromQueryString(queryString, definition) {
    if (!queryString[HAS_FILTER]) {
      return null;
    }

    var filter = _.pick(queryString, definition.names);

    definition.eachBoolean(function (name) {
      filter[name] = !!filter[name];
    });
    definition.eachString(function (name) {
      if (!filter[name]) {
        if (_.includes(MUST_NOT_BE_EMPTY, name)) {
          filter[name] = definition.defaults[name];
        } else {
          filter[name] = "";
        }
      }
    }); // for objects

    forEach_default()(queryString, function (value, key) {
      var match = key.match(/^([^[]+)\s*(\[\s*(\w+)\s*]\s*)+\s*$/);

      if (match !== null && _.size(match) === 4 && _.includes(definition.names, match[1])) {
        if (!filter[match[1]]) {
          filter[match[1]] = {};
        }

        filter[match[1]][match[3]] = _.isBoolean(value) ? !!value : value;
      }
    });
    return filter;
  }

  function asQueryString(filters) {
    var queryString = {};
    queryString[HAS_FILTER] = true;

    _.forEach(filters, function (value, key) {
      if (value === true) {
        queryString[key] = true;
      } else if (angular.isString(value) && value.length > 0) {
        queryString[key] = value;
      } else if (angular.isNumber(value)) {
        queryString[key] = value;
      } else if (angular.isArray(value)) {
        queryString[key] = value;
      } else if (angular.isObject(value)) {
        forEach_default()(value, function (objectValue, objectKey) {
          queryString["".concat(key, "[").concat(objectKey, "]")] = objectValue;
        });
      }
    });

    return queryString;
  }

  function dateFromFilter(dateFilter) {
    return dateFilter ? moment.utc(parseInt(dateFilter, 10)).local().toDate() : null;
  }

  function dateForFilter(date) {
    return date ? moment(date).valueOf() : null;
  }

  var groupsDefaults = {
    planned: false,
    inProgress: true,
    paused: true,
    failing: true,
    failed: true,
    aborted: false,
    completed: false,
    title: '',
    orderBy: 'risk'
  };
  var deliveryDefaults = {
    inProgress: true,
    completed: true,
    title: '',
    orderBy: 'start_date'
  };
  var groupsDetailsDefaults = {
    title: '',
    orderBy: 'risk'
  };
  var releasesDefaults = {
    planned: false,
    inProgress: true,
    paused: true,
    failing: true,
    failed: true,
    aborted: false,
    completed: false,
    onlyArchived: false,
    onlyMine: false,
    onlyFlagged: false,
    title: '',
    from: null,
    to: null,
    orderBy: 'risk',
    tags: [],
    parentId: null
  };
  var calendarDefaults = {
    active: true,
    planned: true,
    inactive: false,
    onlyMine: false,
    onlyFlagged: false,
    title: '',
    tags: [],
    from: null,
    to: null
  };
  var tasksDefaults = {
    planned: true,
    inProgress: true,
    pending: true,
    failed: true,
    assignedToMe: true,
    assignedToMyTeams: false,
    assignedToAnybody: false,
    filter: '',
    from: null,
    to: null,
    tags: [],
    folderId: null,
    orderBy: 'due_date'
  };
  var reportsDefaults = {
    timeFrame: 'LAST_SIX_MONTHS',
    tags: [],
    from: null,
    to: null
  };
  var templatesDefaults = {
    title: '',
    tags: []
  };
  var releaseValueStreamDefaults = {
    title: '',
    from: null,
    to: null,
    tags: [],
    timeFrame: 'LAST_MONTH'
  };
  var logsDefaults = {
    filter: '',
    from: null,
    to: null,
    important: true,
    releaseEdit: false,
    taskEdit: false,
    deliveryEdit: false,
    comments: false,
    lifecycle: false,
    reassign: false,
    security: false,
    other: false,
    dateAsc: false
  };
  var triggerLogsDefaults = {
    filter: '',
    from: null,
    to: null,
    triggerEdit: false,
    lifecycle: true,
    execution: true
  };
  var dashboardDefaults = {
    title: ''
  };
  var folderTriggersDefaults = {
    orderBy: null,
    dir: null,
    triggerTitle: null,
    triggerType: [],
    templateTitle: null
  };
  var timelineDefaults = {
    tags: [],
    taskTags: [],
    title: "",
    planned: false,
    inProgress: false,
    failed: false,
    paused: false,
    failing: false,
    aborted: false,
    completed: false,
    riskStatusWithThresholds: null,
    onlyFlagged: false,
    onlyMine: false,
    date: undefined,
    view: 'month'
  };

  function timelineRules(filters) {
    return _(filters).thru(convertTagsToArray).thru(convertTaskTagsToArray).thru(fixTitle).value();
  }

  function calendarRules(filters) {
    return _(filters).thru(convertTagsToArray).thru(fixTitle).value();
  }

  function reportRules(filters) {
    return _(filters).thru(convertTimestampsToNumber).thru(convertTagsToArray).thru(fixTitle).value();
  }

  function templateRules(filters) {
    return _(filters).thru(fixTitle).thru(convertTagsToArray).value();
  }

  function triggerRules(filters) {
    return _(filters).thru(convertPropertyToArray('triggerType')).value();
  }

  function fixTitle(filters) {
    if (filters && filters.filter && !filters.title) {
      filters.title = filters.filter;
      delete filters.filter;
    } else if (_.has(filters, 'filter')) {
      delete filters.filter;
    }

    return filters;
  }

  function convertTimestampsToNumber(filters) {
    if (filters && filters.from && _.isString(filters.from)) {
      filters.from = _.toNumber(filters.from);
    }

    if (filters && filters.to && _.isString(filters.to)) {
      filters.to = _.toNumber(filters.to);
    }

    return filters;
  }

  function convertTagsToArray(filters) {
    return convertPropertyToArray('tags')(filters);
  }

  function convertTaskTagsToArray(filters) {
    return convertPropertyToArray('taskTags')(filters);
  }

  function convertPropertyToArray(propertyName) {
    return function (filters) {
      if (filters) {
        filters[propertyName] = _.isString(filters[propertyName]) ? filters[propertyName].split(',') : filters[propertyName] || [];
      }

      return filters;
    };
  }

  function fixOrderBy(filters) {
    if (filters && !['start_date', 'end_date', 'risk'].includes(filters.orderBy)) {
      filters.orderBy = 'risk';
    }

    return filters;
  }

  function taskRules(filters) {
    return _(filters).thru(convertTimestampsToNumber).thru(convertTagsToArray).value();
  }

  function releaseRules(filters) {
    return _(filters).thru(convertTimestampsToNumber).thru(fixOrderBy).thru(fixTitle).thru(convertTagsToArray).value();
  }

  function deliveryRules(filters) {
    return _.thru(filters, fixTitle);
  }

  function groupRules(filters) {
    return _(filters).thru(fixOrderBy).thru(fixTitle).value();
  }

  function groupsDetailsRules(filters) {
    return _(filters).thru(fixOrderBy).thru(fixTitle).value();
  }

  return {
    getTasksFilterSettings: generateGetter(tasksDefaults, ClientSettings.getTasksFilters, ClientSettings.setTasksFilters, taskRules),
    getReleasesFilterSettings: generateGetter(releasesDefaults, ClientSettings.getReleasesListFilters, ClientSettings.setReleasesListFilters, releaseRules, ['/default', '/releases'], release_overview_actions.setFilters),
    // TODO bdevic: MOVE THIS TO MODULE
    getDeliveriesFilterSettings: generateGetter(deliveryDefaults, ClientSettings.getDeliveryListFilters, ClientSettings.setDeliveryListFilters, deliveryRules, ['/deliveries'], deliveries_actions["b" /* default */].setFilters),
    getGroupsFilterSettings: generateGetter(groupsDefaults, ClientSettings.getGroupsListFilters, ClientSettings.setGroupsListFilters, groupRules, ['/groups'], release_groups_actions.setFilters),
    getGroupsDetailsFilterSettings: generateGetter(groupsDetailsDefaults, angular.noop, angular.noop, groupsDetailsRules),
    getCalendarFilterSettings: generateGetter(calendarDefaults, ClientSettings.getCalendarFilters, ClientSettings.setCalendarFilters, calendarRules),
    getReportsFiltersSettings: generateGetter(reportsDefaults, ClientSettings.getReportsFilters, ClientSettings.setReportsFilters, reportRules),
    getTemplatesFilterSettings: generateGetter(templatesDefaults, ClientSettings.getTemplatesListFilters, ClientSettings.setTemplatesListFilters, templateRules),
    getReleaseValueStreamFilterSettings: generateGetter(releaseValueStreamDefaults, ClientSettings.getReleaseValueStreamFilters, ClientSettings.setReleaseValueStreamFilters, reportRules),
    getLogsFiltersSettings: generateMapItemGetter(logsDefaults, ClientSettings.getLogsFilters, ClientSettings.setLogsFilters, convertTimestampsToNumber),
    getTriggerLogsFiltersSettings: generateMapItemGetter(triggerLogsDefaults, ClientSettings.getLogsFilters, ClientSettings.setLogsFilters, convertTimestampsToNumber),
    getDashboardsFilterSettings: generateGetter(dashboardDefaults, ClientSettings.getFolderDashboardListFilters, ClientSettings.setFolderDashboardListFilters),
    getFolderTriggersFilterSettings: generateGetter(folderTriggersDefaults, ClientSettings.getFolderTriggersFilters, ClientSettings.setFolderTriggersFilters, triggerRules),
    getTimelineFilterSettings: generateGetter(timelineDefaults, ClientSettings.getTimelineFilters, ClientSettings.setTimelineFilters, timelineRules),
    asQueryString: asQueryString,
    dateFromFilter: dateFromFilter,
    dateForFilter: dateForFilter
  };
}]);
// EXTERNAL MODULE: ./core/xlr-ui/app/js/http/backend.ts
var backend = __webpack_require__(271);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/http/http-interceptor.js
var http_interceptor = __webpack_require__(1351);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/xlrelease.ts
var xlrelease = __webpack_require__(167);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/http/version-enforcer.js



angular.module('xlrelease').factory('VersionEnforcer', [function () {
  return {
    addPrefix: function addPrefix(request) {
      if (request.url.match(/^partials\//)) {
        request.url = 'static/' + xlrelease["a" /* default */].version + '/' + request.url;
      }
    }
  };
}]);
// EXTERNAL MODULE: ./core/xlr-ui/app/js/index/default-route-controller.js
var default_route_controller = __webpack_require__(1352);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/index/license-controller.js



angular.module('xlrelease').controller('LicenseController', ['$scope', 'Backend', 'DateService', 'Authenticator', function ($scope, Backend, DateService, Authenticator) {
  var DAYS_BEFORE_EXPIRATION_WARNING = 5;
  var expirationDate = null;
  $scope.version = xlrelease["a" /* default */].version;
  Backend.get('server/license').then(function (resp) {
    $scope.license = resp.data;
    expirationDate = moment($scope.license.expiresAfter);
  });

  $scope.licenseIsExpired = function () {
    return expirationDate !== null && expirationDate.isBefore(DateService.getToday());
  };

  $scope.licenseIsAlmostExpired = function () {
    return expirationDate !== null && !$scope.licenseIsExpired() && expirationDate.isBefore(DateService.getToday().add(DAYS_BEFORE_EXPIRATION_WARNING, 'days'));
  };

  $scope.showLicenseInfo = function () {
    return $scope.isAdmin() && ($scope.licenseIsAlmostExpired() || $scope.licenseIsExpired() && $scope.license.repositoryId);
  };

  $scope.isAdmin = function () {
    return Authenticator.isAdminOr();
  };
}]);
// CONCATENATED MODULE: ./core/xlr-ui/app/js/index/main-controller.js





var main_controller_MainController = /*#__PURE__*/function () {
  function MainController($scope, Authenticator, ClientSettings, Page, UiExtensionsService, $rootScope, Events, Backend, $state, SystemMessageService, FeatureSettingsService) {
    var _this = this;

    classCallCheck_default()(this, MainController);

    defineProperty_default()(this, "ensureMainMenuLoaded", function () {
      if (!_this.$scope.mainMenuItems.length) {
        _this.loadMainMenu();
      }
    });

    defineProperty_default()(this, "loadMainMenu", function () {
      _this.UiExtensionsService.getMainMenuItems().then(function (items) {
        _this.$scope.mainMenuItems = items;

        _this.loadSubMenu();
      });
    });

    defineProperty_default()(this, "loadSubMenu", function (event, data) {
      _this.Page.fetchSubNavMenuItems().then(function (items) {
        _this.$scope.subMenuItems = items;

        if (data && _.isFunction(data.onRefresh)) {
          data.onRefresh();
        }
      });
    });

    this.UiExtensionsService = UiExtensionsService;
    this.Authenticator = Authenticator;
    this.$rootScope = $rootScope;
    this.Events = Events;
    this.Page = Page;
    this.$scope = $scope;
    this.Backend = Backend;
    this.FeatureSettingsService = FeatureSettingsService;
    $scope.version = xlrelease["a" /* default */].version;

    $scope.logout = function () {
      return Authenticator.logout();
    };

    $scope.clearClientSettings = function () {
      return ClientSettings.clear();
    };

    $scope.getPageTitle = function () {
      return Page.getTitle();
    };

    $scope.isFullPage = function () {
      return Page.isFullPage();
    };

    $scope.isPage = function (path, isRootPath) {
      return Page.isOnPage(path, isRootPath);
    };

    $scope.isLoginPage = function () {
      return Page.isLoginPage();
    };

    $scope.isTemplateDetailsPage = function () {
      return Page.isTemplateDetailsPage();
    };

    $scope.isDeliveryPatternDetails = function () {
      return $state.is('deliveryPatternsDetails') || $state.is('deliveryPatternsDetailsPageExtension');
    };

    $scope.isReleaseFlowPage = function () {
      return Page.isReleaseFlowPage();
    };

    $scope.isTemplateReleaseFlowPage = function () {
      return Page.isTemplateReleaseFlowPage();
    };

    $scope.isRolePage = function () {
      return Page.isRolePage();
    };

    $scope.isTimelinePage = function () {
      return Page.isTimelinePage();
    };

    $scope.isDashboardsPages = function () {
      return Page.isDashboardsPages();
    };

    $scope.isGlobalDashboardsPages = function () {
      return Page.isGlobalDashboardsPages();
    };

    $scope.isReportsPages = function () {
      return Page.isReportsPages();
    };

    $scope.isAuditReportPages = function () {
      return Page.isAuditReportPages();
    };

    $scope.hasActionButton = function () {
      return Page.isGlobalDashboardsPages() || Page.isReportsPages() || Page.isAuditReportPages();
    };

    $scope.isDefinitionPage = function () {
      return Page.isDefinitionPage();
    };

    $scope.refreshPage = function () {
      return Page.refresh();
    };

    $scope.isSystemMessageEnabled = function () {
      return SystemMessageService.isMessageEnabled(_this.$scope.systemMessage);
    };

    $scope.mainMenuItems = [];
    $scope.subMenuItems = [];
  }

  createClass_default()(MainController, [{
    key: "$onInit",
    value: function $onInit() {
      var _this2 = this;

      this.listeners = [this.$rootScope.$on(this.Events.permission.loggedIn, function () {
        _this2.loadMainMenu();

        _this2.FeatureSettingsService.loadFeatures();
      }), this.$rootScope.$on(this.Events.ui.ensureMainMenuLoaded, this.ensureMainMenuLoaded), this.$rootScope.$on(this.Events.ui.subMenuRefresh, this.loadSubMenu), this.$rootScope.$on(this.Events.ui.themeRefresh, function () {
        return _this2.$scope.theme = _this2.Page.theme;
      }), this.$rootScope.$on(this.Events.ui.customLogoRefresh, function () {
        return _this2.$scope.customLogoSrc = _this2.Page.customLogoSrc;
      }), this.$rootScope.$on(this.Events.breadcrumbs.update, function (event, breadcrumbs) {
        return _this2.$scope.breadcrumbs = breadcrumbs;
      }), this.$rootScope.$on(this.Events.settings.systemMessageUpdated, function (event, systemMessageSettings) {
        return _this2.$scope.systemMessage = systemMessageSettings;
      })];

      if (this.Authenticator.isAuthenticated()) {
        this.loadMainMenu();
        this.FeatureSettingsService.loadFeatures();
      }

      this.Backend.get('server/logo/xl-release', {
        hideAlert: true
      }).then(function () {
        return _this2.$scope.productLogoSrc = 'server/logo/xl-release';
      }, function () {
        return _this2.$scope.productLogoSrc = 'static/10.2.14/styles/img/digital-ai-release.svg';
      });
      this.Page.initTheme();
      this.Page.initCustomLogo();
    }
  }, {
    key: "$onDestroy",
    value: function $onDestroy() {
      this.listeners.forEach(function (listener) {
        return listener();
      });
    }
  }]);

  return MainController;
}();

defineProperty_default()(main_controller_MainController, "$inject", ['$scope', 'Authenticator', 'ClientSettings', 'Page', 'UiExtensionsService', '$rootScope', 'Events', 'Backend', '$state', 'SystemMessageService', 'FeatureSettingsService']);

angular.module('xlrelease').controller('MainController', main_controller_MainController);
// EXTERNAL MODULE: ./core/xlr-ui/app/js/index/main-menu-extension-controller.js
var main_menu_extension_controller = __webpack_require__(1353);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/index/menu-items-provider-registry.js



var menu_items_provider_registry_MenuItemsProviderRegistry = /*#__PURE__*/function () {
  function MenuItemsProviderRegistry() {
    classCallCheck_default()(this, MenuItemsProviderRegistry);

    this.providers = new Map();
  }

  createClass_default()(MenuItemsProviderRegistry, [{
    key: "hasProvider",
    value: function hasProvider(name) {
      return this.providers.has(name);
    }
  }, {
    key: "addProvider",
    value: function addProvider(name, config) {
      this.providers.set(name, config);
    }
  }, {
    key: "getProvider",
    value: function getProvider(name) {
      return this.providers.get(name);
    }
  }]);

  return MenuItemsProviderRegistry;
}();

angular.module('xlrelease').service('MenuItemsProviderRegistry', menu_items_provider_registry_MenuItemsProviderRegistry);
// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/toConsumableArray.js
var toConsumableArray = __webpack_require__(23);
var toConsumableArray_default = /*#__PURE__*/__webpack_require__.n(toConsumableArray);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/index/page-service.js





/**
 * @deprecated Since we use ui-router, use states!
 */

var PageUrls = {
  START_PAGE: '/tasks',
  LOGIN_PAGE: '/login',
  FORBIDDEN_CONTENT_PAGE: '/forbidden-access',
  INVALID_LICENSE_PAGE: '/invalid-license',
  TEMPLATE: /templates\/.*Release[^\/]*/
};
var CUSTOM_LOGO_SRC = 'settings/custom-logo/download';

var page_service_Page = /*#__PURE__*/function () {
  function Page($rootScope, $location, $state, UiExtensionsService, BreadcrumbsService, Backend, Events, MenuItemsProviderRegistry, $uibModal, SystemMessageService, Authenticator) {
    var _this = this;

    classCallCheck_default()(this, Page);

    this._$uibModal = $uibModal;
    this._MenuItemsProviderRegistry = MenuItemsProviderRegistry;
    this._$rootScope = $rootScope;
    this._$location = $location;
    this._$state = $state;
    this._UiExtensionsService = UiExtensionsService;
    this._BreadcrumbsService = BreadcrumbsService;
    this._activeMenuItems = [];
    this._currentTitle = '';
    this._folder = null;
    this._breadcrumbsSet = false;
    this._Backend = Backend;
    this._Events = Events;
    this._SystemMessageService = SystemMessageService;
    this._Authenticator = Authenticator;
    this._theme = {
      headerAccentColor: colors["a" /* default */].green,
      headerName: ''
    };
    this._customLogoSrc = CUSTOM_LOGO_SRC;

    this._$rootScope.$on('$stateChangeSuccess', function () {
      _this._updateCurrentPage();

      _this._breadcrumbsSet = false;

      _this._$rootScope.$emit(_this._Events.ui.subMenuRefresh);

      if (_this._Authenticator.isAuthenticated()) {
        _this._SystemMessageService.emitSystemMessage();
      }
    });
  }

  createClass_default()(Page, [{
    key: "_updateCurrentPage",
    value: function _updateCurrentPage() {
      var _this2 = this;

      this._UiExtensionsService.getMainMenuItems().then(function (menuItems) {
        if (_this2._breadcrumbsSet) {
          return;
        }

        var newActiveMenuItems = _this2._findActiveMenuPath(menuItems);

        var activeMenuHasChanged = !_.isEqual(newActiveMenuItems, _this2._activeMenuItems);

        var isAtRootPath = _this2.isOnPage(_this2._getLeafActiveMenu(newActiveMenuItems).pathSuffix, true);

        if (activeMenuHasChanged || isAtRootPath) {
          if (!_.isEmpty(newActiveMenuItems)) {
            _this2._currentTitle = _.last(newActiveMenuItems).label;
          } else {
            _this2._currentTitle = '';
          }
        }

        _this2._activeMenuItems = newActiveMenuItems;

        _this2._BreadcrumbsService.updateBreadcrumbs('');
      });
    }
  }, {
    key: "_findActiveMenuPath",
    value: function _findActiveMenuPath(allItems) {
      for (var i = 0; i < allItems.length; i++) {
        var item = allItems[i];

        var subItems = this._findActiveMenuPath(item.items || []);

        if (subItems.length || this.isOnPage(item.pathSuffix)) {
          return [item].concat(subItems);
        }
      }

      return [];
    }
  }, {
    key: "_getLeafActiveMenu",
    value: function _getLeafActiveMenu() {
      return _.last(this._activeMenuItems) || {};
    }
  }, {
    key: "_isFolderPresent",
    value: function _isFolderPresent() {
      return this._folder;
    } // public methods

  }, {
    key: "initTheme",
    value: function initTheme() {
      var _this3 = this;

      this._Backend.get("settings/theme", {
        hideAlert: true
      }).then(function (resp) {
        return _this3.applyTheme(resp.data);
      });
    }
  }, {
    key: "applyTheme",
    value: function applyTheme(data) {
      this._theme = data;

      this._$rootScope.$emit(this._Events.ui.themeRefresh);
    }
  }, {
    key: "theme",
    get: function get() {
      return this._theme;
    }
  }, {
    key: "initCustomLogo",
    value: function initCustomLogo() {
      this.applyCustomLogo(true);
    }
  }, {
    key: "applyCustomLogo",
    value: function applyCustomLogo(apply) {
      this._customLogoSrc = apply ? CUSTOM_LOGO_SRC + "?cb=" + new Date().valueOf() : null;

      this._$rootScope.$emit(this._Events.ui.customLogoRefresh);
    }
  }, {
    key: "customLogoSrc",
    get: function get() {
      return this._customLogoSrc;
    }
  }, {
    key: "getTitle",
    value: function getTitle() {
      return _.isEmpty(this._currentTitle) ? 'Digital.ai Release' : [this._currentTitle, 'Digital.ai Release'].join(' - ');
    }
  }, {
    key: "addToTitle",
    value: function addToTitle(subtitle) {
      this._currentTitle = subtitle;
    }
  }, {
    key: "setReleaseOpened",
    value: function setReleaseOpened(release) {
      this.addToTitle(release.title);
      this._breadcrumbsSet = true;

      this._BreadcrumbsService.updateBreadcrumbsWithRelease(release);
    }
  }, {
    key: "setFolderOpened",
    value: function setFolderOpened(folder) {
      this.addToTitle(folder.title);
    }
  }, {
    key: "setRiskProfileOpened",
    value: function setRiskProfileOpened(riskProfile) {
      this.addToTitle(riskProfile.title);
      this._breadcrumbsSet = true;

      this._BreadcrumbsService.updateBreadcrumbsWithRiskProfile(riskProfile);

      this._updateCurrentPage();
    }
  }, {
    key: "setFolderEntityOpened",
    value: function setFolderEntityOpened(folderId, entity) {
      this.addToTitle(entity.title);
      this._breadcrumbsSet = true;

      this._BreadcrumbsService.updateBreadcrumbsWithEntity(folderId, entity);

      this._updateCurrentPage();
    }
  }, {
    key: "setDeliveryOpened",
    value: function setDeliveryOpened(delivery) {
      this.addToTitle(delivery.title);
      this._breadcrumbsSet = true;

      this._BreadcrumbsService.updateBreadcrumbsWithDelivery(delivery);

      this._updateCurrentPage();
    }
  }, {
    key: "setDashboardOpened",
    value: function setDashboardOpened(dashboard) {
      this.addToTitle(dashboard.title);
      this._breadcrumbsSet = true;

      this._BreadcrumbsService.updateBreadcrumbsWithDashboard(dashboard);

      this._updateCurrentPage();
    }
  }, {
    key: "setTriggerOpened",
    value: function setTriggerOpened(trigger) {
      this.addToTitle(trigger.title);
      this._breadcrumbsSet = true;

      this._BreadcrumbsService.updateBreadcrumbsWithTrigger(trigger);
    }
  }, {
    key: "fetchSubNavMenuItems",
    value: function fetchSubNavMenuItems() {
      var _this4 = this;

      return this._UiExtensionsService.getMainMenuItems().then(function (items) {
        var activeMenu = _this4._findActiveMenuPath(items);

        if (activeMenu.length > 1) {
          return _.head(activeMenu).items.filter(function (item) {
            return item.permitted;
          });
        }

        return activeMenu;
      }).then(function (menuItems) {
        return _this4.useMenuItemsProviders(menuItems);
      });
    }
  }, {
    key: "useMenuItemsProviders",
    value: function useMenuItemsProviders(menuItems) {
      var _this5 = this;

      var promises = _.reduce(menuItems, function (replacements, item) {
        var providerId = _.get(item, ['properties', 'itemProvider']);

        if (providerId && _this5._MenuItemsProviderRegistry.hasProvider(providerId)) {
          var provider = _this5._MenuItemsProviderRegistry.getProvider(providerId);

          replacements.push(provider().then(function (dynamicItems) {
            return {
              dynamicItems: dynamicItems,
              item: item
            };
          }));
        }

        return replacements;
      }, []);

      return Promise.all(promises).then(function (replacements) {
        replacements.forEach(function (replacement) {
          var index = _.findIndex(menuItems, replacement.item);

          menuItems = [].concat(toConsumableArray_default()(menuItems.slice(0, index)), toConsumableArray_default()(replacement.dynamicItems), toConsumableArray_default()(menuItems.slice(index + 1)));
        });
        return menuItems;
      });
    }
  }, {
    key: "isFullPage",
    value: function isFullPage() {
      return this.isLoginPage() || this.isOnPage(PageUrls.INVALID_LICENSE_PAGE);
    }
  }, {
    key: "isLoginPage",
    value: function isLoginPage() {
      return this.isOnPage(PageUrls.LOGIN_PAGE);
    }
  }, {
    key: "isTemplateDetailsPage",
    value: function isTemplateDetailsPage() {
      return PageUrls.TEMPLATE.test(this._$location.path());
    }
  }, {
    key: "isReleaseFlowPage",
    value: function isReleaseFlowPage() {
      return this._$state.is('release');
    }
  }, {
    key: "isTemplateReleaseFlowPage",
    value: function isTemplateReleaseFlowPage() {
      return this._$state.is('template');
    }
  }, {
    key: "isRolePage",
    value: function isRolePage() {
      return this._$state.is('roles');
    }
  }, {
    key: "isTimelinePage",
    value: function isTimelinePage() {
      return this._$state.is('calendar');
    }
  }, {
    key: "isDashboardsPages",
    value: function isDashboardsPages() {
      return this.isGlobalDashboardsPages() || this.isFolderDashboardPage();
    }
  }, {
    key: "isGlobalDashboardsPages",
    value: function isGlobalDashboardsPages() {
      return this._$state.is('dashboards') || this._$state.is('defaultDashboard');
    }
  }, {
    key: "isFolderDashboardPage",
    value: function isFolderDashboardPage() {
      return this._$state.is('folderDashboards');
    }
  }, {
    key: "isReportsPages",
    value: function isReportsPages() {
      return this._$state.is('reports') || this._$state.is('releaseValueStream');
    }
  }, {
    key: "isAuditReportPages",
    value: function isAuditReportPages() {
      return this.isOneOfStates('auditReport', 'auditReportManagement', 'auditReportDownload');
    }
  }, {
    key: "isOneOfStates",
    value: function isOneOfStates() {
      var _this6 = this;

      for (var _len = arguments.length, states = new Array(_len), _key = 0; _key < _len; _key++) {
        states[_key] = arguments[_key];
      }

      return !!states.find(function (state) {
        return _this6._$state.is(state);
      });
    }
  }, {
    key: "isDefinitionPage",
    value: function isDefinitionPage() {
      return this._$state.is('deliveryDefsDetails');
    }
  }, {
    key: "refresh",
    value: function refresh() {
      document.location.reload(true);
    }
  }, {
    key: "isOnPage",
    value: function isOnPage(path, isRootPath) {
      if (!path) return false;
      path = path[0] === '/' ? path.substr(1) : path;

      var currentPath = this._$location.path().substr(1);

      var firstPathSegment = currentPath.substr(0, path.length);

      if (!isRootPath) {
        return firstPathSegment === path;
      }

      return firstPathSegment === path && !currentPath.substr(0, path.length + 1).match(/\/$/);
    }
  }]);

  return Page;
}();

defineProperty_default()(page_service_Page, "$inject", ['$rootScope', '$location', '$state', 'UiExtensionsService', 'BreadcrumbsService', 'Backend', 'Events', 'MenuItemsProviderRegistry', '$uibModal', 'SystemMessageService', 'Authenticator']);

angular.module('xlrelease').constant('PageUrls', PageUrls).service('Page', page_service_Page);
// CONCATENATED MODULE: ./core/xlr-ui/app/js/index/system-message-modal.js





var system_message_modal_template = "\n<form id=\"system-message-modal\" name=\"systemMessageForm\" novalidate>\n    <div class=\"modal-header\">\n        <h4 class=\"modal-title pull-left\" id=\"modal-title\">System message</h4>\n        <button type=\"button\" class=\"close pull-right\" ng-click=\"$ctrl.dismiss()\"><i class=\"xl-icon close-icon\"></i></button>\n        <div class=\"clearfix\"></div>\n    </div>\n    <div class=\"modal-body\" id=\"modal-body\">\n        <div class=\"form-group\">\n            <div class=\"checkbox\">\n                <label for=\"enabled\">\n                    <input type=\"checkbox\" id=\"enabled\" name=\"enabled\" data-ng-model=\"$ctrl.systemMessage.enabled\" />\n                    Enable system message\n                </label>\n            </div>\n        </div>\n        <div class=\"form-group\">\n            <label for=\"message\">\n                System message text \n            </label>        \n             <rich-editor\n                name=\"message\"\n                data-ng-if=\"$ctrl.isLoaded\"\n                content=\"$ctrl.systemMessage.message\"\n                data-disabled=\"!$ctrl.systemMessage.enabled\"\n                toolbar-config=\"$ctrl.DEFAULT_TOOLBAR_CONFIG\"\n                on-content-change=\"$ctrl.onMessageChange\"></rich-editor>\n        </div>\n        <div class=\"form-group\">\n            <div class=\"checkbox\">\n                <label for=\"automated\">\n                    <input type=\"checkbox\" id=\"automated\" name=\"automated\" data-ng-model=\"$ctrl.systemMessage.automated\" />\n                    Automatically enable/disable system message\n                </label>\n            </div>\n        </div>       \n        <div data-ng-if=\"$ctrl.systemMessage.automated\" class=\"form-inline\">\n            <div class=\"form-group\">\n                <label for=\"startDate\">\n                    Start date\n                </label>\n                <div date-editor\n                     data-ng-model=\"$ctrl.systemMessage.startDate\"\n                     data-deletable=\"true\"\n                     class=\"date-picker\"\n                     is-required=\"$ctrl.systemMessage.automated\"\n                     date-format=\"{{::$ctrl.DEFAULT_DATE_TIME_FORMAT}}\">\n                </div>\n            </div>\n            <div class=\"form-group\">\n                <label for=\"endDate\">\n                    End date\n                </label>\n                <div date-editor\n                     data-ng-model=\"$ctrl.systemMessage.endDate\"\n                     data-deletable=\"true\"\n                     class=\"date-picker\"\n                     is-required=\"$ctrl.systemMessage.automated\"\n                     date-format=\"{{::$ctrl.DEFAULT_DATE_TIME_FORMAT}}\">\n                </div>\n            </div>\n            <div ng-if=\"$ctrl.systemMessage.startDate && $ctrl.systemMessage.endDate && !$ctrl.isStartDateBeforeEndDate()\">\n                <span class=\"error\">Start date must be before end date</span>\n            </div>\n        </div>\n    </div>\n    <div class=\"modal-footer\">\n        <button class=\"button cancel\" type=\"button\" ng-click=\"$ctrl.dismiss()\">Cancel</button>\n        <button class=\"button save primary\" type=\"submit\" ng-click=\"$ctrl.save()\" ng-disabled=\"!$ctrl.isFormValid() || systemMessageForm.$invalid\">Save</button>\n    </div>\n</div>\n";

var system_message_modal_SystemMessageController = /*#__PURE__*/function () {
  function SystemMessageController(SystemMessageService, ConfirmLeaveService, $scope, $timeout) {
    var _this = this;

    classCallCheck_default()(this, SystemMessageController);

    defineProperty_default()(this, "DEFAULT_DATE_TIME_FORMAT", global_constants["a" /* dateTimeFormat */].ISODateTime);

    defineProperty_default()(this, "DEFAULT_TOOLBAR_CONFIG", {
      display: ['INLINE_STYLE_BUTTONS'],
      INLINE_STYLE_BUTTONS: [{
        label: 'Bold',
        style: 'BOLD'
      }, {
        label: 'Italic',
        style: 'ITALIC'
      }, {
        label: 'Underline',
        style: 'UNDERLINE'
      }]
    });

    defineProperty_default()(this, "onMessageChange", function (value) {
      _this.$timeout(function () {
        value = this._removeHtmlHeadings(value);
        this.systemMessage.message = value;
      }.bind(_this));
    });

    this.SystemMessageService = SystemMessageService;
    this.ConfirmLeaveService = ConfirmLeaveService;
    this.$scope = $scope;
    this.$timeout = $timeout;
    this.isLoaded = false;
    this.systemMessageCopy = {};
    this.systemMessage = {};
  }

  createClass_default()(SystemMessageController, [{
    key: "$onInit",
    value: function $onInit() {
      var _this2 = this;

      this.$scope.$on('modal.closing', function (event) {
        if (!_this2._isUnchanged()) {
          event.preventDefault();

          _this2.ConfirmLeaveService.openConfirmationDialog().then(function () {
            _this2.systemMessage = external_angular_default.a.copy(_this2.systemMessageCopy);

            _this2.dismiss();
          });
        }
      });
      this.SystemMessageService.loadSystemMessage().then(function (systemMessage) {
        _this2.systemMessage = systemMessage;

        if (external_angular_default.a.isUndefined(_this2.systemMessage.message)) {
          _this2.systemMessage.message = '';
        }

        if (external_angular_default.a.isUndefined(_this2.systemMessage.startDate)) {
          _this2.systemMessage.startDate = moment().format(_this2.DEFAULT_DATE_TIME_FORMAT);
        }

        if (external_angular_default.a.isUndefined(_this2.systemMessage.endDate)) {
          _this2.systemMessage.endDate = moment().add(1, 'days').format(_this2.DEFAULT_DATE_TIME_FORMAT);
        }

        _this2.systemMessageCopy = external_angular_default.a.copy(_this2.systemMessage);
        _this2.isLoaded = true;
      });
    }
  }, {
    key: "_isUnchanged",
    value: function _isUnchanged() {
      return external_angular_default.a.equals(this.systemMessage, this.systemMessageCopy);
    }
  }, {
    key: "save",
    value: function save() {
      var _this3 = this;

      this.SystemMessageService.saveSystemMessage(this.systemMessage).then(function (systemMessage) {
        _this3.ConfirmLeaveService.disableConfirmation();

        _this3.systemMessage = external_angular_default.a.copy(systemMessage);
        _this3.systemMessageCopy = external_angular_default.a.copy(systemMessage);

        _this3.close({
          $value: systemMessage
        });
      });
    }
  }, {
    key: "_removeHtmlHeadings",
    value: function _removeHtmlHeadings(value) {
      return value.replace(/<h[1-6]>/gi, '<p>').replace(/<\/h[1-6]>/gi, '</p>');
    }
  }, {
    key: "isFormValid",
    value: function isFormValid() {
      return !this.systemMessage.enabled && !this.systemMessage.automated || this.systemMessage.enabled && !this.isSystemMessageEmpty() && (!this.systemMessage.automated || this.isStartDateBeforeEndDate());
    }
  }, {
    key: "isStartDateBeforeEndDate",
    value: function isStartDateBeforeEndDate() {
      return moment(this.systemMessage.startDate).isBefore(this.systemMessage.endDate);
    }
  }, {
    key: "isSystemMessageEmpty",
    value: function isSystemMessageEmpty() {
      return this.systemMessage.message.replace(/<p>|<br>|<\/p>|\n|\r|\r\n|&nbsp;/gi, '') === '';
    }
  }]);

  return SystemMessageController;
}();

defineProperty_default()(system_message_modal_SystemMessageController, "$inject", ['SystemMessageService', 'ConfirmLeaveService', '$scope', '$timeout']);

var SystemMessageModal = {
  bindings: {
    close: '&',
    dismiss: '&'
  },
  controller: system_message_modal_SystemMessageController,
  template: system_message_modal_template
};
external_angular_default.a.module('xlrelease').component('systemMessageModal', SystemMessageModal);
// EXTERNAL MODULE: ./node_modules/ngimport/index.js
var ngimport = __webpack_require__(78);

// EXTERNAL MODULE: ./node_modules/moment/moment.js-exposed
var moment_js_exposed = __webpack_require__(22);
var moment_js_exposed_default = /*#__PURE__*/__webpack_require__.n(moment_js_exposed);

// EXTERNAL MODULE: ./node_modules/lodash/lodash.js-exposed
var lodash_js_exposed = __webpack_require__(82);
var lodash_js_exposed_default = /*#__PURE__*/__webpack_require__.n(lodash_js_exposed);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/locale/regional-settings.ts







var DATE_FORMATS = {
  // Month first
  'M/d/yy': {
    shortDate: 'M/d/yy',
    mediumDate: 'MMM d, y',
    longDate: 'MMMM d, y',
    fullDate: 'EEEE, MMMM d, y',
    name: 'Month first'
  },
  // Day first
  'dd/MM/yy': {
    shortDate: 'dd/MM/yy',
    mediumDate: 'dd MMM y',
    longDate: 'dd MMMM y',
    fullDate: 'EEEE dd MMMM y',
    name: 'Day first'
  },
  // Year first
  'yy/MM/dd': {
    shortDate: 'yy/MM/dd',
    mediumDate: 'y MMM dd',
    longDate: 'y MMMM dd',
    fullDate: 'y MMMM dd EEEE',
    name: 'Year first'
  }
};
var TIME_FORMATS = {
  // 24h format
  'HH:mm': {
    shortTime: 'HH:mm',
    mediumTime: 'HH:mm:ss',
    name: '24 hours'
  },
  // 12h format
  'h:mm a': {
    shortTime: 'h:mm a',
    mediumTime: 'h:mm:ss a',
    name: '12 hours'
  }
};
var MONTHS = [{
  short: 'Jan',
  long: 'January'
}, {
  short: 'Feb',
  long: 'February'
}, {
  short: 'Mar',
  long: 'March'
}, {
  short: 'Apr',
  long: 'April'
}, {
  short: 'May',
  long: 'May'
}, {
  short: 'Jun',
  long: 'June'
}, {
  short: 'Jul',
  long: 'July'
}, {
  short: 'Aug',
  long: 'August'
}, {
  short: 'Sep',
  long: 'September'
}, {
  short: 'Oct',
  long: 'October'
}, {
  short: 'Nov',
  long: 'November'
}, {
  short: 'Dec',
  long: 'December'
}];
var DAYS = [{
  short: 'Sun',
  long: 'Sunday'
}, {
  short: 'Mon',
  long: 'Monday'
}, {
  short: 'Tue',
  long: 'Tuesday'
}, {
  short: 'Wed',
  long: 'Wednesday'
}, {
  short: 'Thu',
  long: 'Thursday'
}, {
  short: 'Fri',
  long: 'Friday'
}, {
  short: 'Sat',
  long: 'Saturday'
}];
var AMPMS = ['AM', 'PM'];
var regional_settings_RegionalSettings;

var regional_settings_RegionalSettingsImpl = /*#__PURE__*/function () {
  function RegionalSettingsImpl() {
    classCallCheck_default()(this, RegionalSettingsImpl);

    defineProperty_default()(this, "WEEK_DAYS", lodash_js_exposed_default.a.map(DAYS, 'long'));

    defineProperty_default()(this, "DEFAULT_DATE_FORMATS", ['M/d/yy', 'dd/MM/yy', 'yy/MM/dd']);

    defineProperty_default()(this, "DEFAULT_TIME_FORMATS", ['HH:mm', 'h:mm a']);

    defineProperty_default()(this, "DEFAULT_FIRST_DAY_OF_WEEK_FORMATS", [0, 1]);

    defineProperty_default()(this, "_browserLocale", {
      id: ngimport["$locale"].id,
      firstDayOfWeek: this._detectFirstDayOfWeek(moment_js_exposed_default.a.localeData(ngimport["$locale"].id)),
      dateFormat: {
        shortDate: ngimport["$locale"].DATETIME_FORMATS.shortDate,
        mediumDate: ngimport["$locale"].DATETIME_FORMATS.mediumDate,
        longDate: ngimport["$locale"].DATETIME_FORMATS.longDate,
        fullDate: ngimport["$locale"].DATETIME_FORMATS.fullDate
      },
      timeFormat: {
        shortTime: ngimport["$locale"].DATETIME_FORMATS.shortTime,
        mediumTime: ngimport["$locale"].DATETIME_FORMATS.mediumTime
      }
    });

    defineProperty_default()(this, "_firstDayOfWeek", this._detectFirstDayOfWeek());

    defineProperty_default()(this, "$locale", this._setEnUserLocale(ngimport["$locale"]));
  }

  createClass_default()(RegionalSettingsImpl, [{
    key: "update",
    value: function update(userProfile) {
      if (userProfile) {
        this._updateNgLocale(userProfile);

        this._updateMomentLocale(userProfile);
      }
    }
  }, {
    key: "_setEnUserLocale",
    value: function _setEnUserLocale(locale) {
      locale.id = 'en-user';
      locale.DATETIME_FORMATS.DAY = lodash_js_exposed_default.a.map(DAYS, 'long');
      locale.DATETIME_FORMATS.SHORTDAY = lodash_js_exposed_default.a.map(DAYS, 'short');
      locale.DATETIME_FORMATS.STANDALONEMONTH = lodash_js_exposed_default.a.map(MONTHS, 'long');
      locale.DATETIME_FORMATS.MONTH = lodash_js_exposed_default.a.map(MONTHS, 'long');
      locale.DATETIME_FORMATS.SHORTMONTH = lodash_js_exposed_default.a.map(MONTHS, 'short');
      locale.DATETIME_FORMATS.AMPMS = AMPMS;
      return locale;
    }
  }, {
    key: "_updateNgLocale",
    value: function _updateNgLocale(userProfile) {
      this._updateNgDates(DATE_FORMATS[userProfile.dateFormat] || this._browserLocale.dateFormat);

      this._updateNgTimes(TIME_FORMATS[userProfile.timeFormat] || this._browserLocale.timeFormat);

      this.$locale.DATETIME_FORMATS.short = this.$locale.DATETIME_FORMATS.shortDate + ' ' + this.$locale.DATETIME_FORMATS.shortTime;
      this.$locale.DATETIME_FORMATS.medium = this.$locale.DATETIME_FORMATS.mediumDate + ' ' + this.$locale.DATETIME_FORMATS.mediumTime;
    }
  }, {
    key: "_updateNgDates",
    value: function _updateNgDates(overrides) {
      var _this = this;

      ['shortDate', 'mediumDate', 'longDate', 'fullDate'].forEach(function (property) {
        if (overrides[property]) {
          _this.$locale.DATETIME_FORMATS[property] = overrides[property];
        }
      });
    }
  }, {
    key: "_updateNgTimes",
    value: function _updateNgTimes(overrides) {
      var _this2 = this;

      ['shortTime', 'mediumTime'].forEach(function (property) {
        if (overrides[property]) {
          _this2.$locale.DATETIME_FORMATS[property] = overrides[property];
        }
      });
    }
  }, {
    key: "_updateMomentLocale",
    value: function _updateMomentLocale(userProfile) {
      if (this.isValidFirstDayOfWeek(userProfile.firstDayOfWeek)) {
        var localeConfig = {
          parentLocale: 'en',
          ordinalParse: /\d{1,2}(st|nd|rd|th)/,
          // remove these ordinal overrides once we upgrade to a 2.12+ version
          ordinal: function ordinal(number) {
            var b = number % 10;
            var output = ~~(number % 100 / 10) === 1 ? 'th' : b === 1 ? 'st' : b === 2 ? 'nd' : b === 3 ? 'rd' : 'th';
            return number + output;
          },
          week: {
            dow: userProfile.firstDayOfWeek,
            doy: 4 // https://github.com/moment/momentjs.com/issues/279

          }
        };

        if (moment_js_exposed_default.a.locale('en-user') !== 'en-user') {
          moment_js_exposed_default.a.defineLocale('en-user', localeConfig);
        } else {
          moment_js_exposed_default.a.updateLocale('en-user', localeConfig);
        }
      } else {
        moment_js_exposed_default.a.locale(this._browserLocale.id);
      }

      this._firstDayOfWeek = this._detectFirstDayOfWeek();
    }
  }, {
    key: "_detectFirstDayOfWeek",
    value: function _detectFirstDayOfWeek(date) {
      return (date || moment_js_exposed_default()().localeData()).firstDayOfWeek();
    }
  }, {
    key: "isValidFirstDayOfWeek",
    value: function isValidFirstDayOfWeek(format) {
      return lodash_js_exposed_default.a.isInteger(format) && format >= 0 && format <= 6;
    }
  }, {
    key: "browserDateFormat",
    get: function get() {
      return this._browserLocale.dateFormat.shortDate;
    }
  }, {
    key: "browserTimeFormat",
    get: function get() {
      return this._browserLocale.timeFormat.shortTime;
    }
  }, {
    key: "browserFirstDayOfWeek",
    get: function get() {
      return this._browserLocale.firstDayOfWeek;
    }
  }, {
    key: "currentDateFormat",
    get: function get() {
      return this.$locale.DATETIME_FORMATS.shortDate;
    }
  }, {
    key: "currentTimeFormat",
    get: function get() {
      return this.$locale.DATETIME_FORMATS.shortTime;
    }
  }, {
    key: "currentMediumDateFormat",
    get: function get() {
      return this.$locale.DATETIME_FORMATS.mediumDate;
    }
  }, {
    key: "currentFullDateFormat",
    get: function get() {
      return this.$locale.DATETIME_FORMATS.fullDate;
    }
  }, {
    key: "currentFirstDayOfWeek",
    get: function get() {
      return this._firstDayOfWeek;
    }
  }, {
    key: "weekDays",
    get: function get() {
      return this.WEEK_DAYS.slice(this.currentFirstDayOfWeek).concat(this.WEEK_DAYS.slice(0, this.currentFirstDayOfWeek));
    }
  }, {
    key: "getDateFormats",
    value: function getDateFormats(format) {
      return DATE_FORMATS[format] || this._browserLocale.dateFormat;
    }
  }, {
    key: "getTimeFormats",
    value: function getTimeFormats(format) {
      return TIME_FORMATS[format] || this._browserLocale.timeFormat;
    }
  }]);

  return RegionalSettingsImpl;
}();

Object(external_angular_["module"])('xlrelease').service('RegionalSettings', regional_settings_RegionalSettingsImpl);
Object(external_angular_["module"])('xlrelease').run(function () {
  return regional_settings_RegionalSettings = ngimport["$injector"].get('RegionalSettings');
});
// EXTERNAL MODULE: ./core/xlr-ui/app/js/login/login-controller.js
var login_controller = __webpack_require__(1360);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/menu/navigation-menu-component.js




(function () {
  var NavigationMenu = {
    bindings: {
      items: '<',
      level: '@'
    },
    templateUrl: 'partials/menu/navigation-menu.html'
  };

  var NavigationMenuItemCtrl = /*#__PURE__*/function () {
    function NavigationMenuItemCtrl($location, $state, $uibModal, Page, ConfirmLeaveService) {
      classCallCheck_default()(this, NavigationMenuItemCtrl);

      this._$location = $location;
      this._$state = $state;
      this._$uibModal = $uibModal;
      this._Page = Page;
      this._ConfirmLeaveService = ConfirmLeaveService;
    }

    createClass_default()(NavigationMenuItemCtrl, [{
      key: "$onInit",
      value: function $onInit() {
        this._isMenuItem = _.isUndefined(this.item.items);
      }
    }, {
      key: "isItemActive",
      value: function isItemActive(item) {
        var _this = this;

        return this._Page.isOnPage(item.pathSuffix) || _.some(item.items, function (subItem) {
          return _this.isItemActive(subItem);
        });
      }
    }, {
      key: "goToRoute",
      value: function goToRoute() {
        var _this2 = this;

        if (!this._ConfirmLeaveService.isConfirmationRequired()) {
          return this._goToRouteInternal();
        }

        var promise = this._ConfirmLeaveService.openConfirmationDialog();

        promise.then(function () {
          return _this2._goToRouteInternal();
        });
      }
    }, {
      key: "isPermitted",
      value: function isPermitted(item) {
        if (!_.isEmpty(item.items)) {
          return _.some(item.items, this.isPermitted);
        }

        return item.permitted;
      }
    }, {
      key: "_goToRouteInternal",
      value: function _goToRouteInternal() {
        var url = this.getTransition(this.item);

        if (this._$location.path() === "/".concat(url.pathSuffix)) {
          // we basically say stay in this state, but just reload while preserving the current location path...
          // if the only goal is to keep the location, only the location flag is needed!
          this._$state.transitionTo(this._$state.current, {}, {
            reload: true,
            inherit: false,
            notify: true,
            location: false
          });
        } else {
          this._$location.url("".concat(url.pathSuffix));
        }
      }
    }, {
      key: "getTransition",
      value: function getTransition(item) {
        if (item && item.items) {
          var permittedItems = item.items.filter(function (itemElement) {
            return itemElement.permitted;
          });
          return permittedItems[0];
        } else {
          return item;
        }
      }
    }, {
      key: "hasSubItems",
      get: function get() {
        return this._hasSubItems;
      }
    }, {
      key: "getHoverColor",
      value: function getHoverColor() {
        return this._Page.theme.headerAccentColor;
      }
    }, {
      key: "getTextColor",
      value: function getTextColor() {
        return this._Page.theme.headerAccentColor === colors["a" /* default */].orange ? colors["a" /* default */].black : colors["a" /* default */].white;
      }
    }]);

    return NavigationMenuItemCtrl;
  }();

  NavigationMenuItemCtrl.$inject = ['$location', '$state', '$uibModal', 'Page', 'ConfirmLeaveService'];
  var NavigationMenuItem = {
    bindings: {
      item: '<'
    },
    controller: NavigationMenuItemCtrl,
    templateUrl: 'partials/menu/navigation-menu-item.html'
  };
  angular.module('xlrelease').component('navigationMenu', NavigationMenu).component('navigationMenuItem', NavigationMenuItem);
})();
// CONCATENATED MODULE: ./core/xlr-ui/app/js/profile/profile-controller.js



(function () {
  var ProfileController = /*#__PURE__*/function () {
    function ProfileController($filter, UsersService, UserProfile, RegionalSettings, Authenticator, ConfirmLeaveService, PendoAnalytics) {
      classCallCheck_default()(this, ProfileController);

      this._UsersService = UsersService;
      this._UserProfile = UserProfile;
      this._$filter = $filter;
      this._RegionalSettings = RegionalSettings;
      this._ConfirmLeaveService = ConfirmLeaveService;
      this._PendoAnalytics = PendoAnalytics;
      this._lastSavedDate = null;
      this._username = Authenticator.getUsername();
      this._previousPasswordIsInvalid = false;
      this._saveError = false;
      this.isInternalUser = UsersService.isInternalUser;
      this.now = new Date();
      this.passwordStatus = {};
      this.profileAnalyticsEnabled = false;
      this.globalAnalyticsEnabled = false;

      this._loadProfile();
    }

    createClass_default()(ProfileController, [{
      key: "save",
      value: function save() {
        var _this = this;

        var profileForm = {
          email: this._profile.email,
          fullName: this._profile.fullName,
          timeFormat: this._profile.timeFormat,
          dateFormat: this._profile.dateFormat,
          firstDayOfWeek: this._profile.firstDayOfWeek,
          analyticsEnabled: this._profile.analyticsEnabled
        };

        if (this._profile.password) {
          profileForm.password = this._profile.password;
          profileForm.previousPassword = this._profile.previousPassword;
        }

        var error = function error(response) {
          if (_this._profile.password && response.status === 400) {
            _this._previousPasswordIsInvalid = response.data && response.data.includes('Failed to change password: Old password does not match');
            _this._saveError = !_this._previousPasswordIsInvalid && response.data;
          }
        };

        var success = function success() {
          _this._lastSavedDate = moment().toDate();

          if (_this._profile.password) {
            delete _this._profile.password;
            delete _this._profile.passwordConfirmation;
            delete _this._profile.previousPassword;
          }

          if (_this._profile.analyticsEnabled !== _this.profileAnalyticsEnabled) {
            _this.profileAnalyticsEnabled = _this._profile.analyticsEnabled;

            _this._PendoAnalytics.changeStatus(_this._profile.analyticsEnabled);
          }

          _this._previousPasswordIsInvalid = false;
          _this._saveError = false;

          _this._ConfirmLeaveService.disableConfirmation();
        };

        this._UserProfile.save(profileForm).then(success, error);
      }
    }, {
      key: "getDateLabel",
      value: function getDateLabel(format) {
        var formats = this._RegionalSettings.getDateFormats(format);

        return "".concat(formats.name || 'Browser setting', " \u2013 ").concat(this._formatDate(formats.mediumDate));
      }
    }, {
      key: "getTimeLabel",
      value: function getTimeLabel(format) {
        var formats = this._RegionalSettings.getTimeFormats(format);

        return "".concat(formats.name || 'Browser setting', " \u2013 ").concat(this._formatDate(formats.shortTime));
      }
    }, {
      key: "getFirstDayOfWeekLabel",
      value: function getFirstDayOfWeekLabel(format) {
        return this._RegionalSettings.isValidFirstDayOfWeek(format) ? this._RegionalSettings.WEEK_DAYS[format] : 'Browser setting – ' + this._RegionalSettings.WEEK_DAYS[this._RegionalSettings.browserFirstDayOfWeek];
      }
    }, {
      key: "username",
      get: function get() {
        return this._username;
      }
    }, {
      key: "profile",
      get: function get() {
        return this._profile;
      }
    }, {
      key: "previousPasswordIsInvalid",
      get: function get() {
        return this._previousPasswordIsInvalid;
      }
    }, {
      key: "saveError",
      get: function get() {
        return this._saveError;
      }
    }, {
      key: "lastSavedDate",
      get: function get() {
        return this._lastSavedDate;
      }
    }, {
      key: "dateFormats",
      get: function get() {
        return this._RegionalSettings.DEFAULT_DATE_FORMATS.concat([null]);
      }
    }, {
      key: "timeFormats",
      get: function get() {
        return this._RegionalSettings.DEFAULT_TIME_FORMATS.concat([null]);
      }
    }, {
      key: "firstDayOfWeekFormats",
      get: function get() {
        return this._RegionalSettings.DEFAULT_FIRST_DAY_OF_WEEK_FORMATS.concat([-1]);
      }
    }, {
      key: "_loadProfile",
      value: function _loadProfile() {
        var _this2 = this;

        this._UserProfile.load().then(function (profile) {
          _this2._profile = profile;
          _this2.profileAnalyticsEnabled = profile.analyticsEnabled;
          _this2.globalAnalyticsEnabled = _this2._PendoAnalytics.areGlobalAnalyticsEnabled();
        });
      }
    }, {
      key: "_formatDate",
      value: function _formatDate(format) {
        return "".concat(this._$filter('date')(this.now, format));
      }
    }]);

    return ProfileController;
  }();

  ProfileController.$inject = ['$filter', 'UsersService', 'UserProfile', 'RegionalSettings', 'Authenticator', 'ConfirmLeaveService', 'PendoAnalytics'];
  angular.module('xlrelease').controller('ProfileController', ProfileController);
})();
// CONCATENATED MODULE: ./core/xlr-ui/app/js/profile/user-profile.ts








var user_profile_UserProfile;

var user_profile_UserProfileImpl = /*#__PURE__*/function () {
  function UserProfileImpl($state, ClientSettings) {
    classCallCheck_default()(this, UserProfileImpl);

    defineProperty_default()(this, "$state", void 0);

    defineProperty_default()(this, "ClientSettings", void 0);

    defineProperty_default()(this, "userProfile", undefined);

    this.$state = $state;
    this.ClientSettings = ClientSettings;
  }

  createClass_default()(UserProfileImpl, [{
    key: "applyProfile",
    value: function applyProfile(resp) {
      this.userProfile = resp.data;
      regional_settings_RegionalSettings.update(this.userProfile);
      return this.userProfile;
    }
  }, {
    key: "isProfileOutdated",
    value: function isProfileOutdated(authenticationData, userProfile) {
      var path = 'username.toLowerCase';
      return authenticationData && lodash_js_exposed_default.a.invoke(authenticationData, path) !== lodash_js_exposed_default.a.invoke(userProfile, path);
    }
  }, {
    key: "load",
    value: function load() {
      var _this = this;

      return backend["a" /* Backend */].get('profile').then(function (response) {
        return _this.applyProfile(response);
      }).then(function () {
        var authenticationData = _this.ClientSettings.getAuthenticationData();

        if (_this.isProfileOutdated(authenticationData, _this.userProfile)) {
          // Cannot load profile because of outdated authenticationData, reload it
          _this.$state.go('login', {
            reloadUserDetails: true
          });
        } else {
          return _this.userProfile;
        }
      });
    }
  }, {
    key: "save",
    value: function save(profile) {
      var _this2 = this;

      return backend["a" /* Backend */].put('profile', profile, {
        hideAlert: true
      }).then(function (response) {
        return _this2.applyProfile(response);
      });
    }
  }, {
    key: "getCurrentUser",
    value: function getCurrentUser() {
      return this.userProfile ? {
        username: this.userProfile.username,
        fullName: this.userProfile.fullName
      } : undefined;
    }
  }, {
    key: "clear",
    value: function clear() {
      this.userProfile = null;
    }
  }]);

  return UserProfileImpl;
}();

defineProperty_default()(user_profile_UserProfileImpl, "$inject", ['$state', 'ClientSettings']);

Object(external_angular_["module"])('xlrelease').service('UserProfile', user_profile_UserProfileImpl);
Object(external_angular_["module"])('xlrelease').run(function () {
  return user_profile_UserProfile = ngimport["$injector"].get('UserProfile');
});
// CONCATENATED MODULE: ./core/xlr-ui/app/features/common/services/type-bound-renderer.service.js


var annotationName = 'TypeBounds';

var type_bound_renderer_service_typeBoundRenderer = function typeBoundRenderer($q, ConfigurationServices, MetadataService) {
  var getCIPropertiesKey = function getCIPropertiesKey(instance, key) {
    if (instance === null) return undefined;

    if (instance.hasOwnProperty('properties') && instance.properties.hasOwnProperty(key)) {
      return 'properties';
    } else if (instance.hasOwnProperty('inputProperties') && instance.inputProperties.hasOwnProperty(key)) {
      return 'inputProperties';
    } else if (instance.hasOwnProperty('outputProperties') && instance.outputProperties.hasOwnProperty(key)) {
      return 'outputProperties';
    }

    return undefined;
  };

  var getCurrentAndNextJsonPathValue = function getCurrentAndNextJsonPathValue(jsonPath) {
    var firstDotIndex = jsonPath.indexOf(".");
    var currentPath = jsonPath.substr(0, firstDotIndex !== -1 ? firstDotIndex : jsonPath.length);
    var nextPath = jsonPath.substr(firstDotIndex !== -1 ? firstDotIndex + 1 : jsonPath.length, jsonPath.length);
    return [currentPath, nextPath];
  };

  var getDefaultValueFromMetadata = function getDefaultValueFromMetadata(type, propertyName, defaultValue) {
    if (angular.isUndefined(type)) return $q.resolve(defaultValue);
    return MetadataService.getDescriptor(type).then(function (descriptor) {
      var propertyDescriptor = descriptor.properties.find(function (property) {
        return property.name === propertyName;
      });

      if (angular.isDefined(propertyDescriptor) && propertyDescriptor.default !== "") {
        return propertyDescriptor.default;
      }

      return defaultValue;
    });
  };

  var getRenderer = function getRenderer(descriptor, instance) {
    return descriptor.properties.filter(function (p) {
      return p.hasOwnProperty('annotations') && annotationName in p.annotations;
    }).flatMap(function (p) {
      var propertyName = p.name;
      var annotation = p.annotations[annotationName];

      var result = defineProperty_default()({}, propertyName, {
        topType: annotation.topType,
        focusType: annotation.focusType,
        canSelectVirtualType: annotation.canBeVirtual
      });

      var getPropsByJsonPath = function getPropsByJsonPath(jsonPathToWatch, configuration, rendererPropertyName) {
        var _getCurrentAndNextJso = getCurrentAndNextJsonPathValue(jsonPathToWatch),
            _getCurrentAndNextJso2 = slicedToArray_default()(_getCurrentAndNextJso, 2),
            currentPropertyName = _getCurrentAndNextJso2[0],
            nextPath = _getCurrentAndNextJso2[1];

        var cIPropertiesKey = getCIPropertiesKey(configuration, currentPropertyName);
        var valueOrConfiguration = angular.isDefined(cIPropertiesKey) ? configuration[cIPropertiesKey][currentPropertyName] : !_.isUndefined(_.get(configuration, currentPropertyName)) ? configuration[currentPropertyName] : undefined;

        if (_.isEmpty(nextPath) || angular.isUndefined(valueOrConfiguration)) {
          if (angular.isUndefined(valueOrConfiguration)) {
            if (configuration === null) {
              result[propertyName][rendererPropertyName] = annotation[rendererPropertyName];
              return $q.resolve(result);
            } // get default value from metadata


            return getDefaultValueFromMetadata(configuration.type, currentPropertyName, annotation[rendererPropertyName]).then(function (value) {
              result[propertyName][rendererPropertyName] = value || annotation[rendererPropertyName];
              return result;
            });
          } // we have nested CI(set the value)


          result[propertyName][rendererPropertyName] = valueOrConfiguration;
          return $q.resolve(result);
        } else {
          if (_.isString(valueOrConfiguration)) {
            // current property is a string and not an object so we need to load them
            return ConfigurationServices.getConfiguration(ConfigurationServices.formatShortIdToLong(valueOrConfiguration)).then(function (response) {
              return getPropsByJsonPath(nextPath, response, rendererPropertyName);
            });
          } else {
            // go deeper
            return getPropsByJsonPath(nextPath, valueOrConfiguration, rendererPropertyName);
          }
        }
      };

      var rendererPropsFn = function rendererPropsFn(jsonPathToWatch, rendererPropertyName) {
        return function () {
          return getPropsByJsonPath(jsonPathToWatch, instance, rendererPropertyName);
        };
      };

      var renderers = {
        defaultProps: result,
        watchers: []
      };

      if (annotation.focusProperty !== null) {
        renderers.watchers.push({
          propToWatch: annotation.focusProperty.split('.')[0],
          loadDependentProps: rendererPropsFn(annotation.focusProperty, 'focusType')
        });
      }

      if (annotation.topProperty !== null) {
        renderers.watchers.push({
          propToWatch: annotation.topProperty.split('.')[0],
          loadDependentProps: rendererPropsFn(annotation.topProperty, 'topType')
        });
      }

      return renderers;
    });
  };

  return {
    getRenderer: getRenderer,
    getDefaultValueFromMetadata: getDefaultValueFromMetadata
  };
};

type_bound_renderer_service_typeBoundRenderer.$inject = ['$q', 'ConfigurationService', 'MetadataService'];
angular.module('xlrelease').service('TypeBoundRenderer', type_bound_renderer_service_typeBoundRenderer);
// EXTERNAL MODULE: ./core/xlr-ui/app/js/releases/editor/release-editor-collapse-service.js
var release_editor_collapse_service = __webpack_require__(1361);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/releases/editor/release-editor-controller.js
var release_editor_controller = __webpack_require__(1362);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/releases/editor/release-editor-task-filter-service.js
var release_editor_task_filter_service = __webpack_require__(1363);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/releases/editor/restart-phases-controller.js




var restart_phases_controller_RestartPhasesController = /*#__PURE__*/function () {
  function RestartPhasesController($scope, Authenticator, Backend, ClientSettings, PhasesService, TasksService, VariablesInterpolator) {
    classCallCheck_default()(this, RestartPhasesController);

    this._$scope = $scope;
    this._authenticator = Authenticator;
    this._backend = Backend;
    this._clientSettings = ClientSettings;
    this._phasesService = PhasesService;
    this._tasksService = TasksService;
    this._variablesInterpolator = VariablesInterpolator;
    this.dismiss = this._$scope.dismiss;
    this.resumeRelease = this._$scope.resumeRelease;
    this.restartPhaseTypes = [{
      label: 'Original',
      type: 'ORIGINAL'
    }, {
      label: 'Latest',
      type: 'LATEST'
    }];
  }

  createClass_default()(RestartPhasesController, [{
    key: "$onInit",
    value: function $onInit() {
      this.releaseRestored = false;
      this.phaseRestartInProgress = false;
      this.phaseType = this._getInitialPhaseType();
      this.phases2restart = this._getPhases2Restart(this.phaseType.type);
      this.fromPhase = this.phases2restart && this.phases2restart[0];
      this.fromTask = this._getFirstTask(this.fromPhase);
      this.tasks2restart = this._getTasks2Restart(this.fromPhase);
    }
  }, {
    key: "onTypeChange",
    value: function onTypeChange() {
      this.phases2restart = this._getPhases2Restart(this.phaseType.type);
      var fromPhase = this.phases2restart && this.phases2restart[0];

      if (fromPhase.id !== this.fromPhase.id) {
        this.fromPhase = fromPhase;
        this.tasks2restart = this._getTasks2Restart(this.fromPhase);
        this.fromTask = this._getFirstTask(this.fromPhase);
      }
    }
  }, {
    key: "onPhaseChange",
    value: function onPhaseChange() {
      this.tasks2restart = this._getTasks2Restart(this.fromPhase);
      this.fromTask = this._getFirstTask(this.fromPhase);
    }
  }, {
    key: "restartPhasesFrom",
    value: function restartPhasesFrom(phaseType) {
      var _this = this;

      if (phaseType) {
        this._clientSettings.setRestartPhaseVersion(phaseType.type);
      }

      this.phaseRestartInProgress = true;
      this.numberOfPhaseRestarted = this.phases2restart.length - _.indexOf(this.phases2restart, this.fromPhase);

      this._backend.post("releases/".concat(this._$scope.release.id, "/restartPhases"), undefined, {
        params: {
          fromPhaseId: this.fromPhase.id,
          fromTaskId: this.fromTask ? this.fromTask.id : undefined,
          phaseVersion: phaseType ? phaseType.type : ''
        }
      }).then(function () {
        _this.phaseRestartInProgress = false;

        _this._$scope.loadRelease();

        _this.releaseRestored = true;
      }, function () {
        _this.phaseRestartInProgress = false;
        _this.releaseRestored = false;

        _this._$scope.dismiss();
      });
    }
  }, {
    key: "interpolate",
    value: function interpolate(title) {
      return this._variablesInterpolator.interpolateInText(this._$scope.release.variables, title);
    }
  }, {
    key: "canSelectTasks",
    value: function canSelectTasks() {
      var _this2 = this;

      if (!this.fromPhase || !this.fromPhase.tasks) {
        return false;
      }

      if (this._getTasks2Restart(this.fromPhase).length <= 1) {
        return false;
      }

      var tasks = this.fromPhase.tasks;

      var currentTaskIndex = _.findIndex(tasks, {
        id: this._$scope.release.currentTask.id
      });

      var tasksToSkips = tasks.slice(0, currentTaskIndex);
      return _.every(tasksToSkips, function (task) {
        return _this2._authenticator.hasPermissionToWorkOnTask(_this2._$scope.release, task);
      });
    }
  }, {
    key: "_getInitialPhaseType",
    value: function _getInitialPhaseType() {
      var phaseTypeId = this._clientSettings.getRestartPhaseVersion();

      if (!phaseTypeId) {
        return this.restartPhaseTypes[1];
      }

      var phaseType = this.restartPhaseTypes.find(function (type) {
        return type.type.toUpperCase() === phaseTypeId.toUpperCase();
      });
      return phaseType || this.restartPhaseTypes[1];
    }
  }, {
    key: "_getPhases2Restart",
    value: function _getPhases2Restart(phaseType) {
      var phases = this._$scope.release.phases;

      if (phaseType === 'ORIGINAL') {
        return _.reject(phases, this._phasesService.isPlannedOrNotOriginal); // notice, this is rejecting, not filtering!
      }

      return _.reject(phases, this._phasesService.isPlannedOrNotMostRecentCopy); // notice, this is rejecting, not filtering!
    }
  }, {
    key: "_getTasks2Restart",
    value: function _getTasks2Restart(fromPhase) {
      var _this3 = this;

      if (!fromPhase || !fromPhase.tasks.length) {
        return [];
      }

      return fromPhase.tasks.filter(function (task) {
        return _this3._tasksService.isActive(task) || _this3._tasksService.isDone(task);
      });
    }
  }, {
    key: "_getFirstTask",
    value: function _getFirstTask(fromPhase) {
      return fromPhase && fromPhase.tasks.length ? fromPhase.tasks[0] : null;
    }
  }]);

  return RestartPhasesController;
}();

defineProperty_default()(restart_phases_controller_RestartPhasesController, "$inject", ['$scope', 'Authenticator', 'Backend', 'ClientSettings', 'PhasesService', 'TasksService', 'VariablesInterpolator']);

angular.module('xlrelease').controller('restartPhasesController', restart_phases_controller_RestartPhasesController);
// EXTERNAL MODULE: ./core/xlr-ui/app/js/releases/editor/sortable-directive.js
var sortable_directive = __webpack_require__(1364);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/releases/editor/worksheet-scrolling-directive.js
var worksheet_scrolling_directive = __webpack_require__(1365);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/releases/editor/worksheet-service.js
var worksheet_service = __webpack_require__(1366);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/releases/gantt/gantt.js
var gantt_gantt = __webpack_require__(1367);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/releases/gantt/gantt-controller.js
var gantt_controller = __webpack_require__(1368);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/releases/gantt/gantt-directive.js
var gantt_directive = __webpack_require__(1369);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/releases/gantt/gantt-elements-editor.js
var gantt_elements_editor = __webpack_require__(1370);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/releases/gantt/gantt-wrapper.js
var gantt_wrapper = __webpack_require__(1371);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/releases/gantt/gantt-zoom.js
var gantt_zoom = __webpack_require__(1372);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/releases/gantt/planner-service.js

angular.module('xlrelease').factory('Planner', ['TasksService', 'TopologicalSort', 'VariablesInterpolator', 'PhaseColors', 'GanttCssClasses', 'PhasesService', 'ClientSettings', 'ReleasesService', 'taskTypeCssClassFilter', 'DateService', 'Ids', function (TasksService, TopologicalSort, VariablesInterpolator, PhaseColors, GanttCssClasses, PhasesService, ClientSettings, ReleasesService, taskTypeCssClassFilter, DateService, Ids) {
  var MANUAL_TASK_DURATION = 60;
  var AUTOMATED_TASK_DURATION = 1;

  var PHASE_COLORS = _.keyBy(PhaseColors, 'value');

  var DEFAULT_PHASE_COLOR = PhaseColors[0].name;
  var FROM_END_TO_START = '0';
  var RELEASE_TYPE = "xlrelease.Release";
  var release, releaseTree;

  function makeLinkId(sourceId, targetId) {
    return sourceId + '|' + targetId;
  }

  function hasPlannedDuration(planItem) {
    return planItem.plannedDuration !== null && angular.isDefined(planItem.plannedDuration);
  }

  function flattenPlan(plan) {
    var elements = [plan];

    _.forEach(plan.children, function (child) {
      elements = elements.concat(flattenPlan(child));
    });

    return elements;
  }

  var getCollapseState = function getCollapseState(item) {
    var states = ClientSettings.getGanttElementsCollapseState();
    var isOpenByDefault = ReleasesService.isRelease(item) || TasksService.isTask(item) && !TasksService.isTaskGroup(item);
    return states === null || angular.isUndefined(states[item.id]) ? isOpenByDefault : states[item.id];
  };

  return {
    makePlan: function makePlan(showAdditionalProperties) {
      if (_.isUndefined(showAdditionalProperties)) {
        showAdditionalProperties = true;
      }

      var releaseTreeById = flattenReleaseTree(releaseTree, release);
      var now = DateService.getTodayWithTime();
      var processingStack = [];
      var plannedReleaseIds = new Set();
      var plan = makePlan(release, now, now, null, showAdditionalProperties);
      var elements = flattenPlan(plan);
      return {
        plan: plan,
        elements: elements,
        plannedEndDate: findMaxDisplayEndDate(elements)
      };

      function makePlan(item, proposedStartDate, now, parent, enrichPlan) {
        var plan = {
          id: item.id,
          type: item.type,
          displayStartDate: computeStartDate(item, proposedStartDate),
          displayDueDate: computeDueDate(item),
          children: [],
          locked: item.locked
        };

        if (_.includes(processingStack, item.id)) {
          plan.displayEndDate = plan.displayStartDate;
          plan.displayDuration = 0;
          cacheDisplayDates(plan, releaseTreeById);
          return plan;
        }

        processingStack.push(item.id);

        if (TasksService.isParallelGroup(item)) {
          plan.children = makeSubTaskPlans(item, plan.displayStartDate, now, item, enrichPlan);
          var proposedDate = findMaxDisplayEndDate(plan.children) || plan.displayStartDate;
          plan.displayEndDate = computeEndDate(item, proposedDate, plan.displayStartDate);
        } else if (TasksService.isGateTask(item)) {
          plan.displayEndDate = computeEndDate(item, computeDependenciesEndDate(plan, item), plan.displayStartDate, now);
        } else {
          var currentDate = plan.displayStartDate;

          _.forEach(getChildren(item), function (child) {
            var childPlan = makePlan(child, currentDate, now, item, enrichPlan);
            plan.children.push(childPlan);

            if (!TasksService.isTaskDoneInAdvance(child)) {
              currentDate = childPlan.displayEndDate;
            }
          });

          plan.displayEndDate = computeEndDate(item, currentDate, plan.displayStartDate, now);
        }

        plan.displayDuration = plan.displayEndDate.diff(plan.displayStartDate, 'milliseconds');

        if (enrichPlan) {
          addAdditionalProperties(plan, item, parent);
        }

        cacheDisplayDates(plan, releaseTreeById);
        processingStack.pop();
        return plan;
      }

      function addAdditionalProperties(plan, item, parent) {
        plan.hasBeenStarted = item.hasBeenStarted;
        plan.text = getItemText(plan, item);
        plan.plainText = VariablesInterpolator.interpolateInText(release.variables, _.escape(item.title));
        plan.childrenIds = toIds(plan.children);
        plan.cssClass = GanttCssClasses.DEFAULT + ' ' + getCssClass(item);
        plan.isUpdatable = item.updatable;
        plan.open = getCollapseState(item);
        plan.start_date = plan.displayStartDate.toDate();
        plan.end_date = plan.displayEndDate.toDate();
        plan.parent = getParentId(parent);
        plan.planItem = item;
        plan.hasOwnStartDate = hasOwnStartDate(item);
        plan.hasOwnEndDate = hasOwnEndDate(item);
        plan.status = item.status;
      }

      function getItemText(plan, item) {
        if (plan && plan.type !== RELEASE_TYPE) {
          var titleEligibleVariables = _.pickBy(_.get(release, 'variables'), function (v) {
            return _.isString(v) && !!v.trim();
          });

          return VariablesInterpolator.interpolateInHtml(titleEligibleVariables, _.escape(item.title));
        }

        return VariablesInterpolator.interpolateInHtml(release.variables, _.escape(item.title));
      }

      function hasOwnStartDate(planItem) {
        return planItem.scheduledStartDate || planItem.startDate;
      }

      function hasOwnEndDate(planItem) {
        return planItem.dueDate || planItem.endDate;
      }

      function getParentId(parentElement) {
        return parentElement ? parentElement.id : undefined;
      }

      function getCssClass(item) {
        if (ReleasesService.isRelease(item)) {
          return GanttCssClasses.RELEASE;
        } else if (PhasesService.isPhase(item)) {
          return getPhaseCssClass(item);
        } else {
          return getTaskCssClass(item);
        }
      }

      function getPhaseCssClass(phase) {
        var cssClass = GanttCssClasses.PHASE;

        if (phase.color && PHASE_COLORS[phase.color]) {
          cssClass += ' ' + GanttCssClasses.PHASE_PREFIX + PHASE_COLORS[phase.color].name;
        } else {
          cssClass += ' ' + GanttCssClasses.PHASE_PREFIX + DEFAULT_PHASE_COLOR;
        }

        return cssClass;
      }

      function getTaskCssClass(task) {
        var cssClasses = GanttCssClasses.TASK + ' ' + taskTypeCssClassFilter(task.type);

        if (task.status) {
          cssClasses += ' ' + GanttCssClasses.TASK_STATUS_PREFIX + task.status.toLowerCase();
        }

        return cssClasses;
      }

      function toIds(planItems) {
        return _.map(planItems, 'id');
      }

      function makeSubTaskPlans(item, currentDate, now, parent, enrichPlan) {
        var tasks = getChildren(item);
        var taskIds = toIds(tasks);
        var orderedTaskIds = TopologicalSort.sort({
          adjacencyList: item.links,
          vertices: taskIds
        });
        var orderedTasks = mapIdsToObjects(orderedTaskIds, tasks);
        var orderedPlans = [];
        orderedTasks.forEach(function (task) {
          var predecessors = mapIdsToObjects(findPredecessorsIds(item.links, task.id), orderedPlans);
          var startDate = predecessors.length ? findMaxDisplayEndDate(predecessors) : currentDate;
          var childPlan = makePlan(task, startDate, now, parent, enrichPlan);
          orderedPlans.push(childPlan);
        });
        return mapIdsToObjects(taskIds, orderedPlans);
      }
      /* eslint-disable lodash/chain-style */


      function findPredecessorsIds(links, taskId) {
        var directPredecessorsIds = _.chain(links).filter({
          targetId: taskId
        }).map('sourceId').value();

        var predecessorsIds = [];

        _.forEach(directPredecessorsIds, function (predecessorId) {
          predecessorsIds = predecessorsIds.concat(findPredecessorsIds(links, predecessorId));
        });

        return _.uniq(predecessorsIds.concat(directPredecessorsIds));
      }
      /* eslint-enable lodash/chain-style */


      function getChildren(item) {
        return item.phases || item.tasks || item.children;
      }

      function computeStartDate(item, proposedDate) {
        if (item.startDate) {
          return moment(item.startDate).startOf('minute');
        }

        if (item.scheduledStartDate) {
          return moment(item.scheduledStartDate).startOf('minute');
        }

        if (item.dueDate && hasPlannedDuration(item)) {
          return moment(item.dueDate).subtract(item.plannedDuration, 'milliseconds').startOf('minute');
        }

        return moment(proposedDate).startOf('minute');
      }

      function computeEndDate(item, proposedDate, displayStartDate, now) {
        var endDate;

        if (item.endDate) {
          endDate = moment(item.endDate);
        } else if (item.dueDate) {
          endDate = moment(item.dueDate);
        } else if (hasPlannedDuration(item)) {
          endDate = moment(displayStartDate).add(item.plannedDuration, 'milliseconds');
        } else if (isAutomatedTask(item)) {
          endDate = moment(proposedDate).add(AUTOMATED_TASK_DURATION, 'minutes');
        } else if (isManualTask(item) && !isDependentTask(item)) {
          endDate = moment(proposedDate).add(MANUAL_TASK_DURATION, 'minutes');
        } else {
          endDate = moment(proposedDate);
        }

        if (endDate.isBefore(displayStartDate)) {
          endDate = moment(displayStartDate);
        }

        if (isActiveLeafTask(item) && endDate.isBefore(now)) {
          endDate = moment(now);
        }

        return endDate.startOf('minute');
      }

      function computeDueDate(item) {
        if (!item.dueDate && !!item.startDate && !!item.plannedDuration) {
          return moment(item.startDate).add(item.plannedDuration, 'milliseconds').valueOf();
        } else {
          return item.dueDate;
        }
      }

      function cacheDisplayDates(plan, releaseTreeById) {
        if (_.has(releaseTreeById, plan.id)) {
          var cachedItem = releaseTreeById[plan.id];
          cachedItem.startDate = plan.displayStartDate;
          cachedItem.endDate = plan.displayEndDate;
        }
      }

      function computeDependenciesEndDate(plan, item) {
        var proposedEndDate = plan.displayStartDate;

        if (!hasOwnEndDate(item) && !hasPlannedDuration(item) && item.dependencies) {
          item.dependencies.filter(isDependencyUnresolved).forEach(function (dependency) {
            var calculatedEndDate = computeDependencyEndDate(dependency);

            if (calculatedEndDate && calculatedEndDate.isAfter(proposedEndDate)) {
              proposedEndDate = calculatedEndDate;
            }
          });
        }

        return proposedEndDate;
      }

      function isDependencyUnresolved(dependency) {
        return !dependency.resolved && !dependency.archived && _.has(dependency, ['variableOrTarget', 'value', 'id']);
      }

      function computeDependencyEndDate(dependency) {
        var dependencyNode = dependency.variableOrTarget.value;
        var calculatedEndDate = null;

        if (hasOwnEndDate(dependencyNode)) {
          calculatedEndDate = moment(dependencyNode.endDate || dependencyNode.dueDate);
        } else {
          var target = _.get(releaseTreeById, dependencyNode.id);

          var targetRelease = _.get(releaseTreeById, dependencyNode.id && Ids.releaseIdFrom(dependencyNode.id));

          if (targetRelease && target) {
            if (!plannedReleaseIds.has(targetRelease.id)) {
              makePlan(targetRelease, now, now);
              plannedReleaseIds.add(targetRelease.id);
            }

            calculatedEndDate = moment(target.endDate);
          }
        }

        return calculatedEndDate;
      }

      function isAutomatedTask(item) {
        return TasksService.isTask(item) && TasksService.isAutomated(item);
      }

      function isManualTask(item) {
        return !TasksService.isTaskGroup(item) && TasksService.isTask(item) && !TasksService.isAutomated(item);
      }

      function isDependentTask(item) {
        return TasksService.isGateTask(item) && !_.isEmpty(item.dependencies);
      }

      function isActiveLeafTask(item) {
        return item.active && TasksService.isTask(item) && !TasksService.isTaskGroup(item);
      }

      function findMaxDisplayEndDate(items) {
        return findMaxDate(items, 'displayEndDate');
      }

      function findMaxDate(items, dateProperty) {
        if (!items || _.isEmpty(items)) {
          return null;
        }

        return _.maxBy(items, function (child) {
          var date = child[dateProperty] || 0;
          return _.isNumber(date) ? date : date.valueOf();
        })[dateProperty];
      }

      function mapIdsToObjects(ids, objects) {
        return _.map(ids, function (id) {
          return _.find(objects, {
            id: id
          });
        });
      }

      function flattenReleaseTree(releaseTree, release) {
        if (_.isEmpty(releaseTree)) {
          return {};
        }

        return _([release].concat(toConsumableArray_default()(Object.values(releaseTree.dependentReleases)))).map(function (releaseTreeItem) {
          return flattenPlan(angular.copy(releaseTreeItem));
        }).flatten().groupBy('id').mapValues(function (items) {
          return _.head(items);
        }).value();
      }
    },
    getLinks: function getLinks() {
      var links = [];
      addLinksBetweenPhases();
      addLinksBetweenTasks();
      addLinksWithinTaskGroups();
      return links;

      function addLinksBetweenPhases() {
        for (var i = 0; i < release.phases.length - 1; i++) {
          addLink(release.phases[i].id, release.phases[i + 1].id, true);
        }
      }

      function addLinksBetweenTasks() {
        _.forEach(release.phases, function (phase) {
          for (var i = 0; i < phase.tasks.length - 1; i++) {
            addLink(phase.tasks[i].id, phase.tasks[i + 1].id, true);
          }
        });
      }

      function addLinksWithinTaskGroups() {
        _.forEach(release.phases, function (phase) {
          _.forEach(phase.tasks, addLinkWithinTaskGroup);
        });
      }

      function addLinkWithinTaskGroup(task) {
        if (TasksService.isTaskGroup(task)) {
          if (TasksService.isParallelGroup(task)) {
            _.forEach(task.links, function (link) {
              var readonly = !!task.hasBeenStarted || task.locked;
              addLink(link.sourceId, link.targetId, readonly, link.id);
            });
          } else {
            for (var i = 0; i < task.tasks.length - 1; i++) {
              addLink(task.tasks[i].id, task.tasks[i + 1].id, true);
            }
          }

          _.forEach(task.tasks, addLinkWithinTaskGroup);
        }
      }

      function addLink(sourceId, targetId, readOnly, linkId) {
        links.push({
          id: makeLinkId(sourceId, targetId),
          source: sourceId,
          target: targetId,
          type: FROM_END_TO_START,
          readOnly: readOnly,
          linkId: linkId
        });
      }
    },
    makeLinkId: makeLinkId,
    setRelease: function setRelease(newRelease) {
      release = newRelease;

      if (!_.isEmpty(releaseTree) && releaseTree.releaseId !== release.id) {
        releaseTree = null;
      }
    },
    setReleaseTree: function setReleaseTree(newReleaseTree) {
      releaseTree = newReleaseTree;
    }
  };
}]);
// EXTERNAL MODULE: ./core/xlr-ui/app/js/releases/gantt/planning-data-editor.js
var planning_data_editor = __webpack_require__(1373);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/releases/gantt/planning-data-editor-mixin.js
var planning_data_editor_mixin = __webpack_require__(1374);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/releases/grid/release-grid-controller.js



var release_grid_controller_ReleaseGridController = /*#__PURE__*/function () {
  function ReleaseGridController($scope, $location, releasePromise, Page, ViewStorage, ReleasesService, Events) {
    classCallCheck_default()(this, ReleaseGridController);

    this.ReleasesService = ReleasesService;
    this.Events = Events;
    this.$scope = $scope;
    this.release = $scope.release = releasePromise.data;
    ViewStorage.setView(this.release.id, $location.path());
    Page.setReleaseOpened(this.release);

    this._createScopeBindings();
  }

  createClass_default()(ReleaseGridController, [{
    key: "_createScopeBindings",
    value: function _createScopeBindings() {
      var _this = this;

      this.$scope.startRelease = function (release) {
        return _this.ReleasesService.startRelease(release).then(function () {
          return _this.refreshGrid();
        });
      };

      this.$scope.abortRelease = function (release, abortComment) {
        return _this.ReleasesService.abortRelease(release, abortComment).then(function () {
          return _this.refreshGrid();
        });
      };
    } // view model

  }, {
    key: "canAbortRelease",
    value: function canAbortRelease(release) {
      return !this.ReleasesService.isTemplate(release) && this.$scope.security.hasPermission('release#abort', release) && !this.ReleasesService.isReleaseCompleted(release) && !this.ReleasesService.hasAutomatedTaskInProgress(release);
    }
  }, {
    key: "canStartRelease",
    value: function canStartRelease(release) {
      return this.ReleasesService.isReleasePlanned(release) && this.$scope.security.hasPermission('release#start', release);
    }
  }, {
    key: "canRefreshGrid",
    value: function canRefreshGrid(release) {
      return !this.ReleasesService.isTemplate(release) && !this.ReleasesService.isReleaseCompleted(release);
    }
  }, {
    key: "refreshGrid",
    value: function refreshGrid() {
      var _this2 = this;

      this.ReleasesService.getRelease(this.release.id).then(function (resp) {
        var updatedRelease = resp.data;
        _this2.release = _this2.$scope.release = updatedRelease;

        _this2.$scope.$broadcast(_this2.Events.grid.refresh, {
          release: updatedRelease
        });
      });
    }
  }]);

  return ReleaseGridController;
}();

release_grid_controller_ReleaseGridController.$inject = ['$scope', '$location', 'releasePromise', 'Page', 'ViewStorage', 'ReleasesService', 'Events'];
angular.module('xlrelease').controller('releaseGridController', release_grid_controller_ReleaseGridController);
// CONCATENATED MODULE: ./core/xlr-ui/app/js/releases/grid/release-grid-edit-controller.js





(function () {
  var ReleaseGridEditController = /*#__PURE__*/function () {
    function ReleaseGridEditController($scope, TasksService, Authenticator, Events, TaskDetailsUpdates, PhaseDetailsUpdates, PhasesService, ReleasesService) {
      classCallCheck_default()(this, ReleaseGridEditController);

      this._scope = $scope;
      this._events = Events;
      this._taskDetailsUpdates = TaskDetailsUpdates;
      this._phaseDetailsUpdates = PhaseDetailsUpdates;
      this._phasesService = PhasesService;
      this._releasesService = ReleasesService;
      this.bindEvents(Events);
      this.bindContext(TasksService, Authenticator);
    }

    createClass_default()(ReleaseGridEditController, [{
      key: "bindEvents",
      value: function bindEvents(events) {
        this._scope.$on(events.grid.edit, this.editItem.bind(this));
      }
    }, {
      key: "bindContext",
      value: function bindContext(tasksService, authenticator) {
        var _this = this;

        var reloadRelease = function reloadRelease() {
          return _this.loadRelease(true);
        };

        this._scope.security = authenticator;

        this._scope.deleteTask = function (container, taskToDelete) {
          return tasksService.deleteTask(container, taskToDelete);
        };

        this._scope.changeType = function (container, taskToConvert, convertToType) {
          return tasksService.changeTaskType(container, taskToConvert, convertToType);
        };

        this._scope.duplicateTask = function (release, container, task) {
          return tasksService.duplicateTask(release, task, container);
        };

        this._scope.completeTask = function (task, commentText) {
          return tasksService.completeTask(task.id, commentText).then(reloadRelease);
        };

        this._scope.skipTask = function (task, commentText) {
          return tasksService.skipTask(task.id, commentText).then(reloadRelease);
        };

        this._scope.failTask = function (task, commentText) {
          return tasksService.failTask(task.id, commentText).then(reloadRelease);
        };

        this._scope.abortTask = function (task, commentText) {
          return tasksService.abortTask(task.id, commentText).then(reloadRelease);
        };

        this._scope.retryTask = function (task, commentText) {
          return tasksService.retryTask(task.id, commentText).then(reloadRelease);
        };

        this._scope.cancelTask = function (task, commentText) {
          return tasksService.cancelTask(task.id, commentText).then(reloadRelease);
        };

        this._scope.startNow = function (task, commentText) {
          return tasksService.startNow(task.id, commentText).then(reloadRelease);
        };

        this._scope.startTaskWithInput = function (task, variables) {
          return tasksService.startTaskWithInput(task.id, variables).then(reloadRelease);
        };

        this._scope.reopenTask = function (task, commentText) {
          return tasksService.reopenTask(task.id, commentText).then(reloadRelease);
        };
      } //

    }, {
      key: "endEditTask",
      value: function endEditTask(task) {
        this.editTask = false;

        if (this._taskDetailsUpdates.planningDataChanged || this._taskDetailsUpdates.assigneeChanged || this.previousTitle !== task.title) {
          this.loadRelease();

          this._taskDetailsUpdates.reset();
        }
      }
    }, {
      key: "endEditPhase",
      value: function endEditPhase(phase) {
        this.editPhase = false;

        if (this._phaseDetailsUpdates.planningDataChanged || this.previousTitle !== phase.title) {
          this.loadRelease();

          this._phaseDetailsUpdates.reset();
        }
      }
    }, {
      key: "loadRelease",
      value: function loadRelease() {
        var reload = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;

        this._scope.$emit(this._events.grid.refresh, {
          reload: reload
        });
      }
    }, {
      key: "editItem",
      value: function editItem(event, args) {
        if (!args.planItem) {
          return;
        }

        this._scope.release = args.release;
        this.previousTitle = args.planItem.title;

        if (this._phasesService.isPhase(args.planItem)) {
          this._scope.phase = args.planItem;
          this.editPhase = true;
        } else if (!this._releasesService.isRelease(args.planItem) && !this._releasesService.isTemplate(args.planItem)) {
          this._scope.task = args.planItem;
          this.editTask = true;
        }
      }
    }]);

    return ReleaseGridEditController;
  }();

  ReleaseGridEditController.$inject = ['$scope', 'TasksService', 'Authenticator', 'Events', 'TaskDetailsUpdates', 'PhaseDetailsUpdates', 'PhasesService', 'ReleasesService'];
  angular.module('xlrelease').controller('releaseGridEditController', ReleaseGridEditController);
})();
// CONCATENATED MODULE: ./core/xlr-ui/app/js/releases/grid/release-grid-service.js





(function () {
  var GridItem = /*#__PURE__*/function () {
    function GridItem(planItem, treeLevel, container) {
      classCallCheck_default()(this, GridItem);

      this.container = container;
      this.planItem = planItem;
      this.id = planItem.id;
      this.$$treeLevel = treeLevel;
      this.status = planItem.status;
      this.title = planItem.title;
      this.type = planItem.type;
      this.typeDisplayName = GridItem.getTypeDisplayName(planItem);
      this.assignedTo = GridItem.getAssignedTo(planItem);
      this.duration = this.startDate = this.endDate = this.dueDate = null;
      this.editable = planItem.editable;
      this.tags = planItem.tags;
    }

    createClass_default()(GridItem, null, [{
      key: "getAssignedTo",
      value: function getAssignedTo(planItem) {
        if (planItem.owner) {
          return planItem.owner.fullName || planItem.owner.username;
        } else if (planItem.team) {
          return planItem.team;
        }

        return null;
      }
    }, {
      key: "getTypeDisplayName",
      value: function getTypeDisplayName(planItem) {
        if (planItem.type === 'xlrelease.Release' || planItem.type === 'xlrelease.ScmConnectedTemplate') {
          return 'Release';
        } else if (planItem.type === 'xlrelease.Phase') {
          return 'Phase';
        } else if (planItem.typeDisplayGroup === 'Core') {
          return planItem.typeDisplayName;
        }

        return planItem.typeDisplayGroup + ': ' + planItem.typeDisplayName;
      }
    }]);

    return GridItem;
  }();

  var ReleaseGridService = /*#__PURE__*/function () {
    function ReleaseGridService(planner, variablesInterpolator) {
      classCallCheck_default()(this, ReleaseGridService);

      this.planner = planner;
      this.variablesInterpolator = variablesInterpolator;
    }

    createClass_default()(ReleaseGridService, [{
      key: "getGridItems",
      value: function getGridItems(release, releaseTree) {
        var gridItems = this._toGridItems(0, release);

        this._calculateDates(release, releaseTree, gridItems);

        this._interpolateVariables(release, gridItems);

        return gridItems;
      }
    }, {
      key: "_toGridItems",
      value: function _toGridItems(level, planItem, container) {
        var _this = this;

        var children = planItem.phases ? planItem.phases : planItem.tasks ? planItem.tasks : [];
        return _.flatten([new GridItem(planItem, level, container)].concat(_.map(children, function (child) {
          return _this._toGridItems(level + 1, child, planItem);
        })));
      }
    }, {
      key: "_interpolateVariables",
      value: function _interpolateVariables(release, gridItems) {
        var _this2 = this;

        gridItems.forEach(function (item) {
          if (_.isString(item.assignedTo)) {
            item.assignedTo = _this2.variablesInterpolator.interpolateInText(release.variables, item.assignedTo);
          }
        });
      }
    }, {
      key: "_calculateDates",
      value: function _calculateDates(release, releaseTree, gridItems) {
        this.planner.setRelease(release);
        this.planner.setReleaseTree(releaseTree);
        var plan = this.planner.makePlan(false);
        gridItems.forEach(function (item) {
          var itemPlan = _.find(plan.elements, {
            'id': item.id
          });

          if (!_.isUndefined(itemPlan)) {
            item.startDate = itemPlan.displayStartDate.toDate();
            item.endDate = itemPlan.displayEndDate.toDate();
            item.dueDate = itemPlan.displayDueDate;
            item.duration = itemPlan.displayDuration;
          }
        });
      }
    }]);

    return ReleaseGridService;
  }();

  ReleaseGridService.$inject = ['Planner', 'VariablesInterpolator'];
  angular.module('xlrelease').service('ReleaseGridService', ReleaseGridService);
})();
// EXTERNAL MODULE: ./core/xlr-ui/app/features/common/services/risk-detector.js
var risk_detector = __webpack_require__(64);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/releases/list/releases-service.js



angular.module('xlrelease').factory('ReleasesService', ['Backend', 'ReleasesStatusService', 'DependenciesService', 'TasksService', 'PhasesService', 'DateService', '$q', 'Download', '$location', 'UserProfile', 'FlagService', 'VariablesService', 'CiLoaderSettings', 'Ids', function (Backend, ReleasesStatusService, DependenciesService, TasksService, PhasesService, DateService, $q, Download, $location, UserProfile, FlagService, VariablesService, CiLoaderSettings, Ids) {
  var DEFAULT_START_HOUR = 9;
  var DEFAULT_DUE_HOUR = 17;

  function mapSelectedReleasesToDomainId(selectedReleases) {
    return Array.from(selectedReleases).map(function (item) {
      return Ids.toDomainId(item);
    });
  }

  function getLeafTasks(release) {
    return _.flattenDeep(_.map(release.phases, PhasesService.getLeafTasks));
  }

  function getAllTasks(release) {
    return _.flattenDeep(_.map(release.phases, function (phase) {
      return _.map(phase.tasks, TasksService.getAllSubTasks);
    }));
  }

  function downloadReleaseReport(release, reportType) {
    Download.get("api/v1/reports/download/".concat(reportType, "/").concat(release.id));
  }

  function hasAutomatedTaskInProgress(release) {
    return _.some(release.currentSimpleTasks, function (task) {
      return TasksService.isTaskInProgress(task) && TasksService.isAutomated(task);
    });
  }

  function computeGroupedReleases(releases, filters) {
    var releasesByMonth = _.groupBy(releases, function (release) {
      var dateFormatter = 'MMMM YYYY';

      if (filters.completed) {
        return moment(release.endDate).format(dateFormatter);
      } else {
        return formatReleaseStartDate(release, dateFormatter);
      }
    });

    return _.map(_.keys(releasesByMonth), function (month) {
      return {
        month: month,
        releases: releasesByMonth[month]
      };
    });
  }

  function formatReleaseStartDate(release, dateFormatter) {
    if (release.startDate) {
      return moment(release.startDate).format(dateFormatter);
    } else if (release.scheduledStartDate) {
      return moment(release.scheduledStartDate).format(dateFormatter);
    }
  }

  function search(filters, config) {
    return Backend.post('releases/search', filters, config);
  }

  function searchFull(filters, config) {
    return search(filters, _.merge({
      params: {
        depth: CiLoaderSettings.itemsMaxDepth
      }
    }, config));
  }

  function dateRange(filters, config) {
    return Backend.post('releases/daterange', filters, config);
  }

  var getRelease = function getRelease(releaseId, config) {
    return Backend.get('releases/' + releaseId, config);
  };

  var getTemplateDuration = function getTemplateDuration(templateId) {
    return Backend.get('releases/templates/' + templateId + '/duration');
  };

  return {
    getLeafTasks: getLeafTasks,
    getAllTasks: getAllTasks,
    isReleaseCompleted: ReleasesStatusService.isReleaseCompleted,
    hasCompletedStatus: ReleasesStatusService.hasCompletedStatus,
    isReleaseAborted: ReleasesStatusService.isReleaseAborted,
    isReleasePlanned: ReleasesStatusService.isReleasePlanned,
    isReleaseInProgress: ReleasesStatusService.isReleaseInProgress,
    isReleaseFailed: ReleasesStatusService.isReleaseFailed,
    isReleaseFailing: ReleasesStatusService.isReleaseFailing,
    isReleasePaused: ReleasesStatusService.isReleasePaused,
    isReleaseArchived: ReleasesStatusService.isReleaseArchived,
    isReleaseInsideFolder: function isReleaseInsideFolder(release) {
      return release.id.includes('Folder');
    },
    computeGroupedReleases: computeGroupedReleases,
    startRelease: function startRelease(release) {
      return Backend.post('releases/' + release.id + '/start');
    },
    abortRelease: function abortRelease(release, abortComment) {
      return Backend.post('releases/' + release.id + '/abort', {
        abortComment: abortComment
      });
    },
    downloadCalendar: function downloadCalendar(release) {
      Download.get('export/calendar/' + release.id);
    },
    downloadExcel: function downloadExcel(release) {
      downloadReleaseReport(release, 'xlrelease.ReleaseAuditExcelReport');
    },
    exportZip: function exportZip(release) {
      Download.get('api/v1/templates/zip/' + release.id);
    },
    exportDsl: function exportDsl(release) {
      Download.launch("api/v1/dsl/export/".concat(Ids.toDomainId(release.id), "?exportTemplate=true"));
    },
    getReleasePermissions: function getReleasePermissions(releaseId) {
      return Backend.get("releases/".concat(releaseId, "/permissions"));
    },
    getReleaseDependencies: function getReleaseDependencies(releaseId, params) {
      return Backend.get('dependencies/' + releaseId, {
        params: params
      });
    },
    getRelease: getRelease,
    getTemplateDuration: getTemplateDuration,
    getTemplateWithDuration: function getTemplateWithDuration(templateId) {
      return getRelease(templateId).then(function (releaseResponse) {
        return getTemplateDuration(templateId).then(function (durationResponse) {
          releaseResponse.data.computed_duration = durationResponse.data;
          return releaseResponse;
        });
      });
    },
    getReleaseWithDependencies: function getReleaseWithDependencies(releaseId, config) {
      return Backend.get("releases/".concat(releaseId), config).then(function (response) {
        var tree = DependenciesService.getReleaseTree(response.data);
        var release = Promise.resolve(response);
        return Promise.all([tree, release]);
      }).then(function (values) {
        var _values = slicedToArray_default()(values, 2),
            tree = _values[0],
            release = _values[1];

        release.tree = tree;
        return release;
      });
    },
    search: search,
    searchFull: searchFull,
    searchArchived: function searchArchived(filters, config) {
      return searchFull(_.merge(filters, {
        onlyArchived: true
      }), config);
    },
    dateRange: dateRange,
    cropToReleaseDate: function cropToReleaseDate(phase, release) {
      var phaseStartDate = DateService.getStartOrScheduledDate(phase);
      var releaseStartDate = DateService.getStartOrScheduledDate(release);
      var phaseEndDate = DateService.getEndOrDueDate(phase);
      var releaseEndDate = DateService.getEndOrDueDate(release);
      return {
        startDate: moment(phaseStartDate).isBefore(moment(releaseStartDate)) ? moment(releaseStartDate) : moment(phaseStartDate),
        endDate: moment(phaseEndDate).isAfter(moment(releaseEndDate)) ? moment(releaseEndDate) : moment(phaseEndDate)
      };
    },
    countPhasesDone: function countPhasesDone(release) {
      return release ? _.filter(release.phases, PhasesService.isPhaseReadOnly).length : undefined;
    },
    hasAttachments: function hasAttachments(release) {
      if (release.attachments && release.attachments.length > 0) {
        return true;
      }

      return _(getAllTasks(release)).map('attachments').flatten().value().length > 0;
    },
    redirectToSummary: function redirectToSummary(release) {
      $location.url('/releases/' + release.id + '/summary');
    },
    redirectToOverview: function redirectToOverview(filters) {
      $location.url('/releases');
      $location.search(filters);
    },
    redirectToEditor: function redirectToEditor(release) {
      $location.url('/releases/' + release.id);
    },
    isRelease: function isRelease(planItem) {
      return planItem.type === 'xlrelease.Release';
    },
    isTemplate: function isTemplate(release) {
      return ReleasesStatusService.isTemplate(release);
    },
    hasAutomatedTaskInProgress: hasAutomatedTaskInProgress,
    isNewRelease: function isNewRelease(release) {
      return !release.id;
    },
    initNewTemplate: function initNewTemplate() {
      return {
        title: '',
        status: 'TEMPLATE',
        tags: [],
        scheduledStartDate: DateService.getToday().hours(DEFAULT_START_HOUR).toDate(),
        dueDate: null,
        plannedDuration: null,
        type: 'xlrelease.Release',
        allowConcurrentReleasesFromTrigger: true
      };
    },
    initNewReleaseFromTemplate: function initNewReleaseFromTemplate(templateId) {
      var _this = this;

      return this.getTemplateWithDuration(templateId).then(function (templateResponse) {
        return VariablesService.getReleaseVariables(templateId).then(function (variablesResponse) {
          var newRelease = _this.initNewRelease();

          var template = templateResponse.data;
          var variables = variablesResponse.data;
          var now = DateService.getTodayWithTime();
          var due = moment(now).add(template.computed_duration / 60, 'minutes');
          newRelease.templateId = template.id;

          _.assign(newRelease, {
            scheduledStartDate: now,
            dueDate: due,
            description: template.description,
            tags: template.tags,
            abortOnFailure: template.abortOnFailure,
            allowPasswordsInAllFields: template.allowPasswordsInAllFields,
            disableNotifications: template.disableNotifications,
            scriptUsername: template.scriptUsername,
            scriptUserPassword: template.scriptUserPassword,
            syntheticProperties: {
              riskProfile: template.syntheticProperties.riskProfile
            },
            variables: variables,
            variableMapping: template.variableMapping
          });

          return newRelease;
        });
      });
    },
    initNewRelease: function initNewRelease() {
      return {
        title: '',
        owner: UserProfile.getCurrentUser(),
        scriptUsername: null,
        scriptUserPassword: null,
        scheduledStartDate: DateService.getToday().hours(DEFAULT_START_HOUR).toDate(),
        dueDate: DateService.getToday().hours(DEFAULT_DUE_HOUR).toDate(),
        plannedDuration: null,
        tags: [],
        variables: [],
        type: 'xlrelease.Release',
        flag: {
          status: FlagService.NOT_FLAGGED_STATUS
        },
        syntheticProperties: {},
        variableMapping: {}
      };
    },
    getReleaseWithVariables: function getReleaseWithVariables(releaseId) {
      return this.getRelease(releaseId).then(function (releaseResponse) {
        var release = releaseResponse.data;
        return VariablesService.getReleaseVariables(releaseId).then(function (variablesResponse) {
          release.variables = variablesResponse.data;
          return release;
        });
      });
    },
    startReleases: function startReleases(selectedReleases) {
      return Backend.post('releases/start', mapSelectedReleasesToDomainId(selectedReleases));
    },
    abortReleases: function abortReleases(selectedReleases, abortComment) {
      return Backend.post('releases/abort', {
        releasesIds: mapSelectedReleasesToDomainId(selectedReleases),
        abortComment: abortComment
      });
    },
    getRiskStatusIcon: function getRiskStatusIcon(release, riskScore, riskConfig) {
      var _ref;

      var iconSize = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 'icon-xl';
      return _ref = {}, defineProperty_default()(_ref, "xl-icon circle-cross-icon ".concat(iconSize), risk_detector["c" /* isAtRisk */](release, riskScore, riskConfig)), defineProperty_default()(_ref, "xl-icon circle-exclamation-icon ".concat(iconSize), risk_detector["d" /* isAttentionNeeded */](release, riskScore, riskConfig)), defineProperty_default()(_ref, "xl-icon circle-check-icon ".concat(iconSize), risk_detector["f" /* isOnTrack */](release, riskScore, riskConfig)), defineProperty_default()(_ref, "xl-icon circle-check-icon completed ".concat(iconSize), this.hasCompletedStatus(release) || this.isReleaseAborted(release)), _ref;
    }
  };
}]);
// CONCATENATED MODULE: ./core/xlr-ui/app/js/releases/permissions/release-permissions-controller.js





function release_permissions_controller_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function release_permissions_controller_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { release_permissions_controller_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { release_permissions_controller_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var release_permissions_controller_ReleasePermissionsController = /*#__PURE__*/function () {
  function ReleasePermissionsController($stateParams, $uibModal, ReleasesService, TeamsService, MemberType, Page, release, teams, users, roles, Ids, permissionTableUtils, FolderPathService, AvailableGroupedReleasePermission, PermissionLabels) {
    var _this = this;

    classCallCheck_default()(this, ReleasePermissionsController);

    this._$stateParams = $stateParams;
    this._$uibModal = $uibModal;
    this._ReleasesService = ReleasesService;
    this._TeamsService = TeamsService;
    this._MemberType = MemberType;
    this._Page = Page;
    this._release = release;
    this._loadedTeams = teams;
    this._users = users;
    this._roles = roles;
    this._Ids = Ids;
    this._permissionTableUtils = permissionTableUtils;
    this._FolderPathService = FolderPathService;
    this._AvailableGroupedReleasePermission = AvailableGroupedReleasePermission;
    this._PermissionLabels = PermissionLabels;
    this._readOnly = ReleasesService.isReleaseCompleted(release) || ReleasesService.isReleaseInsideFolder(release);
    this._permissionsCollapsed = 0;
    this._teamsCollapsed = 0;

    this._mapTeamToContainer = function (team) {
      return {
        name: team.teamName,
        type: _this._MemberType.TEAM
      };
    };

    this._Page.setReleaseOpened(release);

    this._loadData();
  }

  createClass_default()(ReleasePermissionsController, [{
    key: "_loadData",
    value: function _loadData() {
      var _this2 = this;

      this._teams = this._loadedTeams.map(function (team) {
        var validTeam = release_permissions_controller_objectSpread({}, team);

        validTeam.valid = true;
        return validTeam;
      });

      this._ReleasesService.getReleasePermissions(this._$stateParams.releaseId).then(function (response) {
        _this2._initPermissionsTableData(response.data);

        _this2._initTeamsTableData();
      });

      this._inherited = this.isInherited();
      this._dirty = false;
    }
  }, {
    key: "_initTeamsTableData",
    value: function _initTeamsTableData() {
      var _context;

      this._teamsTableColumns = [{
        title: 'Team name',
        key: 'teamName'
      }, {
        title: 'Global roles',
        key: 'globalRoles',
        suggestionData: this._roles,
        type: this._MemberType.ROLE
      }, {
        title: 'Users',
        key: 'users',
        suggestionData: this._users,
        type: this._MemberType.PRINCIPAL
      }];
      this._teamsPermissionsContainer = this._teams.map((_context = this._permissionTableUtils).teamPermissionsToContainer.bind(_context));
    }
  }, {
    key: "_initPermissionsTableData",
    value: function _initPermissionsTableData(releasePermissionsView) {
      var _this3 = this;

      this._permissions = releasePermissionsView.permissions;
      this._permissionsTableColumns = [{
        title: 'Action',
        key: 'action'
      }, {
        title: 'Teams',
        key: 'teams',
        suggestionData: this._teams.map(this._mapTeamToContainer),
        type: this._MemberType.TEAM
      }];
      this._permissionsContainer = [];

      this._AvailableGroupedReleasePermission.filter(function (group) {
        return !_this3.isTemplate() && group.label !== 'Templates' || _this3.isTemplate();
      }).forEach(function (group) {
        var permissions = group.permissions;
        var permissionsMap = permissions.map(function (permission) {
          return {
            action: _this3._PermissionLabels[permission].label,
            clazz: defineProperty_default()({}, _this3._PermissionLabels[permission].clazz, true),
            value: permission,
            description: _this3._PermissionLabels[permission].description,
            teams: _this3._teams.filter(function (team) {
              return team.permissions.includes(permission);
            }).map(_this3._mapTeamToContainer)
          };
        });

        var sortTeam = function sortTeam(teams) {
          return _this3._sortBy(teams, "name");
        };

        var formattedPermissionMap = permissionsMap.map(function (p) {
          return release_permissions_controller_objectSpread(release_permissions_controller_objectSpread({}, p), {}, {
            teams: sortTeam(p.teams)
          });
        });

        _this3._permissionsContainer.push({
          label: group.label,
          icon: group.icon,
          permissions: formattedPermissionMap
        });
      });
    }
  }, {
    key: "save",
    value: function save() {
      var _this4 = this;

      var teams = this._teams.map(function (t) {
        return _this4._mapTeamToTeamWithPermissions(t);
      });

      this._TeamsService.updateTeams(this._$stateParams.releaseId, teams).then(function () {
        _this4._lastSavedDate = moment().toDate();
        _this4._dirty = false;
      });
    }
  }, {
    key: "reset",
    value: function reset() {
      this._loadData();

      this._lastSavedDate = null;
      this._dirty = false;
    }
  }, {
    key: "isInherited",
    value: function isInherited() {
      var _this5 = this;

      if (this._teams.length === 0) return false;
      var team = this._teams[0];

      var parentId = this._Ids.getParentIdGeneral(team.id, '-');

      var isInherited = parentId !== this._release.id;

      if (isInherited) {
        this._FolderPathService.getPathFromRelativeFolderId(parentId).then(function (paths) {
          _this5._inheritedFrom = _.last(paths);
        });
      }

      return isInherited;
    }
  }, {
    key: "setDirty",
    value: function setDirty() {
      this._dirty = true;
    }
  }, {
    key: "openAddTeamModal",
    value: function openAddTeamModal() {
      var _this6 = this;

      var modal = this._$uibModal.open({
        animation: false,
        resolve: {
          teams: function teams() {
            return _this6._teams.map(function (t) {
              return t.teamName;
            });
          }
        },
        component: 'addTeamModal'
      });

      modal.result.then(function (teamName) {
        if (teamName) {
          var newTeam = {
            teamName: teamName,
            members: [],
            permissions: []
          };

          _this6._teams.push(newTeam);

          _this6._teamsPermissionsContainer.push(_this6._permissionTableUtils.teamPermissionsToContainer(newTeam));

          _this6.updateTeamsSuggestions();

          _this6.setDirty();
        }
      });
    }
  }, {
    key: "updateTeamsSuggestions",
    value: function updateTeamsSuggestions() {
      this._permissionsTableColumns[1].suggestionData = this._teams.map(this._mapTeamToContainer);
    }
  }, {
    key: "onRemoveTeam",
    value: function onRemoveTeam(team) {
      var _this7 = this;

      var modal = this._$uibModal.open({
        animation: false,
        component: 'deleteTeamModal',
        resolve: {
          teamName: function teamName() {
            return team.teamName;
          }
        }
      });

      modal.result.then(function (pressedDelete) {
        if (pressedDelete) {
          _.remove(_this7._teams, {
            teamName: team.teamName
          });

          _this7._permissionsContainer.map(function (permission) {
            return _.remove(permission.teams, {
              name: team.teamName
            });
          });

          _.remove(_this7._teamsPermissionsContainer, {
            teamName: team.teamName
          });

          _this7.updateTeamsSuggestions();

          _this7.setDirty();
        }
      });
    }
  }, {
    key: "validate",
    value: function validate(newName, team) {
      return !this._nameAlreadyUsed(newName, team);
    }
  }, {
    key: "isReleaseCompleted",
    value: function isReleaseCompleted() {
      return this._ReleasesService.isReleaseCompleted(this._release);
    }
  }, {
    key: "isTemplate",
    value: function isTemplate() {
      return this._ReleasesService.isTemplate(this._release);
    }
  }, {
    key: "_nameAlreadyUsed",
    value: function _nameAlreadyUsed(teamName, teamToIgnore) {
      return _.some(this._teams, function (team) {
        return team.teamName === teamName && team !== teamToIgnore;
      });
    }
  }, {
    key: "_mapTeamToTeamWithPermissions",
    value: function _mapTeamToTeamWithPermissions(team) {
      team.permissions = _.flatMap(this._permissionsContainer, 'permissions').filter(function (p) {
        return _.find(p.teams, {
          name: team.teamName
        });
      }).map(function (permission) {
        return permission.value;
      });
      team.members = _.flatMap(this._teamsPermissionsContainer.filter(function (c) {
        return c.teamName === team.teamName;
      }), function (c) {
        return [].concat(toConsumableArray_default()(c.globalRoles), toConsumableArray_default()(c.users));
      });
      return _.omit(team, 'valid');
    }
  }, {
    key: "_sortBy",
    value: function _sortBy(collection, prop) {
      return _.sortBy(collection, [this._sortProperty(prop)]);
    }
  }, {
    key: "_sortProperty",
    value: function _sortProperty(prop) {
      var valueToLowerCase = function valueToLowerCase(val) {
        return val ? val.toLowerCase() : '';
      };

      var sortProperty = function sortProperty(property) {
        return function (obj) {
          return valueToLowerCase(obj[property]);
        };
      };

      return sortProperty(prop);
    }
  }, {
    key: "release",
    get: function get() {
      return this._release;
    }
  }, {
    key: "permissions",
    get: function get() {
      return this._permissions;
    }
  }, {
    key: "lastSavedDate",
    get: function get() {
      return this._lastSavedDate;
    }
  }, {
    key: "dirty",
    get: function get() {
      return this._dirty;
    }
  }, {
    key: "teams",
    get: function get() {
      return this._teams;
    }
  }, {
    key: "users",
    get: function get() {
      return this._users;
    }
  }, {
    key: "roleNames",
    get: function get() {
      return this._roleNames;
    }
  }, {
    key: "permissionsTableColumns",
    get: function get() {
      return this._permissionsTableColumns;
    }
  }, {
    key: "permissionsContainers",
    get: function get() {
      return this._permissionsContainer;
    }
  }, {
    key: "teamsTableColumns",
    get: function get() {
      return this._teamsTableColumns;
    }
  }, {
    key: "teamsPermissionsContainer",
    get: function get() {
      return this._teamsPermissionsContainer;
    }
  }, {
    key: "readOnly",
    get: function get() {
      return this._readOnly;
    }
  }, {
    key: "permissionsCollapsed",
    get: function get() {
      return this._permissionsCollapsed;
    },
    set: function set(permissionsCollapsed) {
      this._permissionsCollapsed = permissionsCollapsed;
    }
  }, {
    key: "teamsCollapsed",
    get: function get() {
      return this._teamsCollapsed;
    },
    set: function set(teamsCollapsed) {
      this._teamsCollapsed = teamsCollapsed;
    }
  }, {
    key: "inherited",
    get: function get() {
      return this._inherited;
    }
  }, {
    key: "inheritedFrom",
    get: function get() {
      return this._inheritedFrom;
    }
  }]);

  return ReleasePermissionsController;
}();

defineProperty_default()(release_permissions_controller_ReleasePermissionsController, "$inject", ['$stateParams', '$uibModal', 'ReleasesService', 'TeamsService', 'MemberType', 'Page', 'release', 'teams', 'users', 'roles', 'Ids', 'permissionTableUtils', 'FolderPathService', 'AvailableGroupedReleasePermission', 'PermissionLabels']);

angular.module('xlrelease').controller('releasePermissionsController', release_permissions_controller_ReleasePermissionsController);
// CONCATENATED MODULE: ./core/xlr-ui/app/js/releases/phase-details-controller.js




function phase_details_controller_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function phase_details_controller_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { phase_details_controller_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { phase_details_controller_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

angular.module('xlrelease').controller('phaseDetailsController', ['$scope', 'Backend', 'PhasesService', 'PhaseDetailsUpdates', 'PlanningDataEditorMixin', 'VariablesService', function ($scope, Backend, PhasesService, PhaseDetailsUpdates, PlanningDataEditorMixin, VariablesService) {
  $scope.$watch('phase.scheduledStartDate + phase.dueDate', validatePhaseDates);
  $scope.$watch('phase.title', loadVariablesOnPhaseSaved);
  angular.extend($scope, PlanningDataEditorMixin.withSaveCallback(function (phase) {
    $scope.updatePhase(phase);
    PhaseDetailsUpdates.planningDataChanged = true;
  }));
  $scope.planning.initPlanningData($scope.phase, $scope.release);

  function validatePhaseDates() {
    if (!$scope.phase) return;
    $scope.warning = {
      displayScheduledStartDateBefore: $scope.phase.scheduledStartDate !== null && $scope.release.scheduledStartDate !== null && moment($scope.phase.scheduledStartDate).isBefore(moment($scope.release.scheduledStartDate), 'minutes'),
      displayScheduledStartDateAfter: $scope.phase.scheduledStartDate !== null && $scope.release.dueDate !== null && moment($scope.phase.scheduledStartDate).isAfter(moment($scope.release.dueDate), 'minutes'),
      displayDueDateBefore: $scope.phase.dueDate !== null && $scope.release.scheduledStartDate !== null && moment($scope.phase.dueDate).isBefore(moment($scope.release.scheduledStartDate), 'minutes'),
      displayDueDateAfter: $scope.phase.dueDate !== null && $scope.release.dueDate !== null && moment($scope.phase.dueDate).isAfter(moment($scope.release.dueDate), 'minutes')
    };
    loadVariables();
  }

  function loadVariablesOnPhaseSaved() {
    var VARIABLE_MATCHER = /(\$\{[^}]+\})/g;

    var variables = _.uniq($scope.phase.title.match(VARIABLE_MATCHER));

    variables.filter(function (var1) {
      return !($scope.allVariables ? $scope.allVariables.some(function (var2) {
        return var1 === var2.key;
      }) : true);
    }).forEach(function (newVar) {
      return $scope.allVariablesWithReleaseVars.push({
        'displayName': newVar,
        'id': '',
        'key': newVar.replace('${', '').replace('}', ''),
        'requiresValue': false,
        'showOnReleaseStart': false,
        'type': "xlrelease.StringVariable",
        'variableName': newVar
      });
    });
  }

  function loadAllVariablesWithSpecialRelVars(allVariables, release) {
    if (release.variables) {
      var specialVariables = Object.keys(release.variables).filter(function (key) {
        return key.includes('release.');
      }).reduce(function (obj, key) {
        return phase_details_controller_objectSpread(phase_details_controller_objectSpread({}, obj), {}, defineProperty_default()({}, key, release.variables[key]));
      }, {});
      Object.keys(specialVariables).forEach(function (key) {
        var obj = {
          'displayName': key,
          'id': '',
          'key': key.replace('${', '').replace('}', ''),
          'requiresValue': false,
          'showOnReleaseStart': false,
          'type': "xlrelease.StringVariable",
          'value': specialVariables[key],
          'variableName': key
        };
        allVariables.push(obj);
      });
    }

    return allVariables;
  }

  function loadVariables() {
    VariablesService.getAllVariables($scope.release.id).then(function (allVariables) {
      $scope.allVariables = allVariables;
      $scope.allVariablesWithReleaseVars = loadAllVariablesWithSpecialRelVars(allVariables, $scope.release);
    });
  }

  $scope.isEditable = function () {
    return !$scope.isPhaseReadOnly($scope.phase) && $scope.security.hasEditPermission($scope.release);
  };

  $scope.updatePhase = PhasesService.updatePhase;
  $scope.isPhaseInProgress = PhasesService.isPhaseInProgress;
  $scope.isPhaseReadOnly = PhasesService.isPhaseReadOnly;
  $scope.isPhasePlanned = PhasesService.isPhasePlanned;
}]);
// EXTERNAL MODULE: ./core/xlr-ui/app/js/releases/phase-details-updates.js
var phase_details_updates = __webpack_require__(1377);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/releases/release-flow-header-directive.js
var release_flow_header_directive = __webpack_require__(1378);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/releases/release-header-controller.js



var release_header_controller_ReleaseSubpages = /*#__PURE__*/function () {
  function ReleaseSubpages(ViewStorage) {
    classCallCheck_default()(this, ReleaseSubpages);

    this.ViewStorage = ViewStorage;
  }

  createClass_default()(ReleaseSubpages, [{
    key: "getSubpages",
    value: function getSubpages(releaseId) {
      return {
        editor: {
          path: this._getEditorPath(releaseId),
          label: 'Release flow',
          weight: 20
        },
        grid: {
          path: '/table',
          label: 'Release flow',
          weight: 25,
          hidden: true
        },
        gantt: {
          path: '/planner',
          label: 'Release flow',
          weight: 30,
          hidden: true
        },
        releaseXfile: {
          path: '/code',
          label: 'Release flow',
          weight: 40,
          hidden: true
        },
        properties: {
          path: '/properties',
          label: 'Properties',
          weight: 45
        },
        variables: {
          path: '/variables',
          label: 'Variables',
          weight: 50
        },
        permissions: {
          path: '/permissions',
          label: 'Teams & Permissions',
          weight: 70,
          displayIf: 'security.hasEditSecurityPermission(release)',
          class: 'release-permissions'
        }
      };
    }
  }, {
    key: "_getEditorPath",
    value: function _getEditorPath(releaseId) {
      var editorPath = '/';

      if (this.ViewStorage.getView(releaseId)) {
        var storedView = this.ViewStorage.getView(releaseId);
        editorPath += storedView.substr(storedView.lastIndexOf(releaseId) + releaseId.length + 1);
      }

      return editorPath === '/' ? '' : editorPath; // UI router doesn't like trailing slashes
    }
  }]);

  return ReleaseSubpages;
}();

release_header_controller_ReleaseSubpages.$inject = ['ViewStorage'];
angular.module('xlrelease').service('ReleaseSubpages', release_header_controller_ReleaseSubpages); // Allows the release header to be customized according to the current location

var injectParams = ['$scope', '$location', 'ReleaseSubpages', '$parse', '$stateParams', 'Authenticator', 'ReleasesService', 'UiExtensionsService', '$ngRedux', 'Ids'];

var ReleaseHeaderController = function ReleaseHeaderController($scope, $location, ReleaseSubpages, $parse, $stateParams, Authenticator, ReleasesService, UiExtensionsService, $ngRedux, Ids) {
  $scope.isSubpageDropdownAvailable = false;
  $scope.getSubpageLink = getSubpageLink;
  init(); // TODO: refactor. onDestroy...

  $scope.unsubscribe = $ngRedux.connect(mapStateToThis)($scope);

  function mapStateToThis(state) {
    var releaseGrid = state.releaseGrid;
    return {
      selectedCount: releaseGrid.selectedItems.length
    };
  }

  function init() {
    $scope.releaseId = $stateParams.releaseId;
    $scope.security = Authenticator;
    $scope.releaseTemplateVariable = _.includes($location.path(), '/templates/') ? 'templates' : 'releases';

    if ($scope.releasePageExtensionCtrl) {
      $scope.release = $scope.releasePageExtensionCtrl.release;
    }

    if ($scope.release) {
      generateReleaseSubpages($scope.release);
    } else if ($scope.releaseId) {
      ReleasesService.getRelease($scope.releaseId).then(function (response) {
        generateReleaseSubpages(response.data);
      });
    }
  }

  function generateReleaseSubpages(release) {
    $scope.release = release;
    $scope.isSubpageDropdownAvailable = angular.isDefined($scope.release) && !!$scope.release;
    $scope.releaseSubpages = ReleaseSubpages.getSubpages($scope.releaseId); // to avoid errors while extended subpages are being fetched

    extendReleaseSubpages($scope.release).then(function (extendedSubpages) {
      $scope.releaseSubpages = extendedSubpages;

      var notDefaultPages = _.omit($scope.releaseSubpages, 'editor');

      $scope.page = _.find(notDefaultPages, function (aPage) {
        var regexp = new RegExp(aPage.path, 'i');
        return $location.path().match(regexp); // if current location ends with one of the subpages
      });
      $scope.page = $scope.page || $scope.releaseSubpages.editor;
    });
    $scope.isSubpageDisplayed = isSubpageDisplayed;
    $scope.showNewReleaseButton = showNewReleaseButton; //

    $scope.isActive = function (viewMode) {
      if ($scope.page && $scope.page.path !== null) {
        return $scope.page.path === viewMode;
      } else {
        return false;
      }
    };
  }

  function isSubpageDisplayed(subpage) {
    if (_.isString(subpage.displayIf)) {
      var displayFunction = $parse(subpage.displayIf);
      return displayFunction($scope);
    }

    return !subpage.hidden;
  }

  function showNewReleaseButton() {
    var isProperPage = angular.isDefined($scope.release) && $scope.release.status === 'TEMPLATE' && ($scope.releaseSubpages.editor === $scope.page || $scope.releaseSubpages.properties === $scope.page);
    var isInFolder = _.isEmpty(_.get($scope.release, 'id')) ? false : Ids.isInFolder($scope.release.id);
    var isAllowed = isInFolder ? $scope.security.hasPermission('template#create_release', $scope.release) : $scope.security.hasPermission('release#create');
    return isProperPage && isAllowed;
  }

  function extendReleaseSubpages(release) {
    return UiExtensionsService.getReleaseMenuExtensions(release).then(function (extensions) {
      /* eslint-disable lodash/no-extra-args */
      var extendedSubpages = _.clone(ReleaseSubpages.getSubpages(release.id), false);
      /* eslint-enable lodash/no-extra-args */


      _(extensions).filter({
        permitted: true
      }).filter(function (extension) {
        if (extension.properties && extension.properties.showOnlyOnTemplate) {
          return release.status === 'TEMPLATE';
        }

        return true;
      }).forEach(function (extension) {
        extendedSubpages[extension.pathSuffix] = {
          path: '/' + extension.pathSuffix,
          label: extension.label,
          weight: extension.weight
        };
      });

      extendedSubpages = _(extendedSubpages).toPairs().sortBy(function (keyValue) {
        return keyValue[1].weight;
      }).fromPairs().value();
      return extendedSubpages;
    });
  }

  function getSubpageLink(subpage) {
    return "#/".concat($scope.release.status === 'TEMPLATE' ? 'templates' : 'releases', "/").concat($scope.releaseId).concat(subpage.path);
  }
};

ReleaseHeaderController.$inject = injectParams;
angular.module('xlrelease').controller('releaseHeaderController', ReleaseHeaderController);
// EXTERNAL MODULE: ./core/xlr-ui/app/js/releases/release-header-directive.js
var release_header_directive = __webpack_require__(1379);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/releases/release-page-extension-controller.js
var release_page_extension_controller = __webpack_require__(1380);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/releases/variables/release-variables-controller.js
var release_variables_controller = __webpack_require__(1381);

// EXTERNAL MODULE: ./node_modules/lodash/values.js
var lodash_values = __webpack_require__(133);
var values_default = /*#__PURE__*/__webpack_require__.n(lodash_values);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/reports/echarts-reports-service.js




function echarts_reports_service_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function echarts_reports_service_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { echarts_reports_service_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { echarts_reports_service_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }



var sizes = {
  SYMBOL: 5,
  LINE: 1,
  LEGEND: 11,
  LABEL: 11,
  BAR: 20,
  BAR_VERTICAL: 45
};
var position = {
  CENTER: 'center',
  OUTSIDE: 'outside'
};
var echarts_reports_service_defaults = {
  TITLE_TEXT_STYLE: {
    color: colors["a" /* default */].black,
    fontSize: 30,
    fontWeight: '600',
    fontFamily: 'OpenSans'
  },
  SUB_TITLE_TEXT_STYLE: {
    color: colors["a" /* default */].black,
    fontSize: 12,
    fontFamily: 'OpenSans'
  }
};
var pieChartSmallSizeSettings = {
  title: {
    show: true,
    textStyle: {
      fontSize: 17
    },
    subtextStyle: {
      fontSize: 9
    },
    y: '38%'
  },
  legend: {
    show: true,
    bottom: 0
  },
  tooltip: {
    position: [0, '12%']
  },
  series: {
    radius: [35, '65%']
  }
};
var pieChartSmallHeightSettings = {
  title: {
    show: true,
    textStyle: {
      fontSize: 22
    },
    subtextStyle: {
      fontSize: 10
    },
    y: '35%'
  },
  legend: {
    show: true,
    bottom: 0
  },
  series: {
    radius: [45, '70%']
  }
};
var pieChartSmallWidthSettings = {
  title: {
    show: true,
    textStyle: {
      fontSize: 20
    },
    subtextStyle: {
      fontSize: 9
    },
    y: '45%'
  },
  tooltip: {
    position: [0, '30%']
  },
  series: {
    radius: [42, '80%']
  }
};
var HORIZONTAL_BAR_NUMS = 10;

var echarts_reports_service_EchartsReportsService = /*#__PURE__*/function () {
  function EchartsReportsService(durationFilter) {
    classCallCheck_default()(this, EchartsReportsService);

    defineProperty_default()(this, "getPrimaryColorList", function () {
      return values_default()(colors["b" /* primaryColors */]);
    });

    defineProperty_default()(this, "getPrimaryColor", function () {
      return colors["b" /* primaryColors */].blue;
    });

    defineProperty_default()(this, "getTextColor", function () {
      return colors["a" /* default */].gray;
    });

    this.durationFilter = durationFilter;
  }
  /** Report configurations **/


  createClass_default()(EchartsReportsService, [{
    key: "taskEfficiency",
    value: function taskEfficiency(releaseEfficiency) {
      var _this = this;

      var that = this;
      return this.automationTaskReport(releaseEfficiency.totalAutomatedTasks, releaseEfficiency.totalManualTasks, releaseEfficiency.totalTasks, 'tasks executed', function (params) {
        return _this.automationTaskReportTooltip(params.data.name, params.color, params.data.value, _this.formatPercentage(params.data.value, releaseEfficiency.totalTasks));
      });
    }
  }, {
    key: "taskTimeSpent",
    value: function taskTimeSpent(releaseEfficiency) {
      var _this2 = this;

      var that = this;
      var durationFormatter = this.getDurationFormatter(releaseEfficiency.totalTimeSpent);
      return this.automationTaskReport(releaseEfficiency.totalAutomatedTimeSpent, releaseEfficiency.totalManualTimeSpent, "".concat(durationFormatter.format(releaseEfficiency.totalTimeSpent), " ").concat(durationFormatter.name.charAt(0)), 'in total', function (params) {
        return _this2.automationTaskReportTooltip(params.data.name, params.color, _this2.durationFilter(params.data.value), _this2.formatPercentage(params.data.value, releaseEfficiency.totalTimeSpent));
      });
    }
  }, {
    key: "longestReleases",
    value: function longestReleases(_longestReleases) {
      return this.longestItemsHorizontalBarReport('release', _longestReleases);
    }
  }, {
    key: "longestTasks",
    value: function longestTasks(_longestTasks) {
      return this.longestItemsHorizontalBarReport('task', _longestTasks);
    }
  }, {
    key: "longestPhases",
    value: function longestPhases(_longestPhases) {
      return this.longestItemsHorizontalBarReport('phase', _longestPhases);
    }
  }, {
    key: "releaseEfficiency",
    value: function releaseEfficiency(averageDurationAndAutomation) {
      var _this3 = this;

      return {
        grid: {
          bottom: 80
        },
        tooltip: {
          trigger: 'axis',
          backgroundColor: 'transparent',
          formatter: function formatter(params) {
            return _this3.getReleaseEfficiencyTooltip(params);
          }
        },
        legend: {
          bottom: 25,
          itemWidth: 10,
          data: ['Automation', 'Manual'],
          selectedMode: false,
          textStyle: {
            color: colors["a" /* default */].gray,
            fontSize: sizes.LEGEND
          }
        },
        xAxis: {
          type: 'category',
          boundaryGap: false,
          data: averageDurationAndAutomation.releasesAutomation.map(function (it) {
            return _this3.formatMonth(it.name);
          }),
          axisTick: {
            show: false
          },
          axisLine: {
            show: false,
            lineStyle: {
              color: colors["a" /* default */].gray
            }
          },
          axisLabel: {
            fontSize: sizes.LABEL
          }
        },
        yAxis: {
          type: 'value',
          axisTick: {
            show: false
          },
          axisLine: {
            show: false,
            lineStyle: {
              color: colors["a" /* default */].gray
            }
          },
          axisLabel: {
            fontSize: sizes.LABEL,
            formatter: function formatter(value) {
              return value > 0 ? "".concat(value, "%") : value;
            }
          }
        },
        series: [{
          type: 'line',
          name: 'Automation',
          data: averageDurationAndAutomation.releasesAutomation.map(function (it) {
            return it.y;
          }),
          lineStyle: {
            normal: {
              color: colors["a" /* default */].purple,
              width: sizes.LINE
            }
          },
          itemStyle: {
            normal: {
              color: colors["a" /* default */].purple
            }
          },
          symbol: 'circle',
          symbolSize: sizes.SYMBOL
        }, {
          type: 'line',
          name: 'Manual',
          data: averageDurationAndAutomation.releasesAutomation.map(function (it) {
            return 100 - it.y;
          }),
          lineStyle: {
            normal: {
              color: colors["a" /* default */].yellow,
              width: sizes.LINE
            }
          },
          itemStyle: {
            normal: {
              color: colors["a" /* default */].yellow
            }
          },
          symbol: 'circle',
          symbolSize: sizes.SYMBOL
        }, {
          type: 'line',
          name: 'Duration',
          show: false,
          data: averageDurationAndAutomation.releasesDuration.map(function (it) {
            return _this3.durationFilter(it.y);
          })
        }]
      };
    }
  }, {
    key: "numberOfReleasesPerMonth",
    value: function numberOfReleasesPerMonth(releaseEfficiency) {
      var _this4 = this;

      return {
        color: [colors["a" /* default */].blue],
        tooltip: {
          trigger: 'axis',
          backgroundColor: 'transparent',
          formatter: this.getNumberOfReleasesPerMonth.bind(this),
          axisPointer: {
            lineStyle: {
              opacity: 0
            }
          }
        },
        xAxis: {
          type: 'category',
          data: releaseEfficiency.numberOfReleasesPerMonth.map(function (it) {
            return _this4.formatMonth(it.name);
          }),
          axisTick: {
            show: false
          },
          axisLine: {
            show: false,
            lineStyle: {
              color: colors["a" /* default */].gray
            }
          },
          axisLabel: {
            fontSize: sizes.LABEL
          }
        },
        yAxis: {
          type: 'value',
          axisTick: {
            show: false
          },
          axisLine: {
            show: false,
            lineStyle: {
              color: colors["a" /* default */].gray
            }
          }
        },
        series: [{
          type: 'bar',
          barWidth: sizes.BAR_VERTICAL,
          name: 'Releases',
          data: releaseEfficiency.numberOfReleasesPerMonth.map(function (it) {
            return it.y;
          })
        }, {
          type: 'line',
          show: false,
          name: 'Automation',
          data: releaseEfficiency.releasesAutomation.map(function (it) {
            return "".concat(it.y, "%");
          })
        }, {
          type: 'line',
          show: false,
          name: 'Avg. release duration',
          data: releaseEfficiency.releasesDuration.map(function (it) {
            return _this4.durationFilter(it.y);
          })
        }]
      };
    }
  }, {
    key: "releaseDuration",
    value: function releaseDuration(averageDurationAndAutomation) {
      var _this5 = this;

      var durations = averageDurationAndAutomation.releasesDuration.map(function (it) {
        return it.y;
      });

      var maxDuration = _.max(durations);

      var durationFormatter = this.getDurationFormatter(maxDuration);
      return {
        tooltip: {
          trigger: 'axis',
          backgroundColor: 'transparent',
          // Note: passing in first element of array since the value is taken from the axis
          formatter: function formatter(params) {
            return _this5.wrapTooltipTextContext(_this5.getAverageReleaseDuration(_this5.durationFilter(params[0].value)));
          }
        },
        xAxis: {
          type: 'category',
          boundaryGap: false,
          data: averageDurationAndAutomation.releasesDuration.map(function (it) {
            return _this5.formatMonth(it.name);
          }),
          axisTick: {
            show: false
          },
          axisLine: {
            show: false,
            lineStyle: {
              color: colors["a" /* default */].gray
            }
          }
        },
        yAxis: {
          name: durationFormatter.name,
          nameLocation: 'start',
          type: 'value',
          axisTick: {
            show: false
          },
          axisLine: {
            show: false,
            lineStyle: {
              color: colors["a" /* default */].gray
            }
          },
          axisLabel: {
            formatter: durationFormatter.format
          }
        },
        series: {
          type: 'line',
          lineStyle: {
            normal: {
              color: colors["a" /* default */].blue,
              width: sizes.LINE
            }
          },
          itemStyle: {
            normal: {
              color: colors["a" /* default */].blue
            }
          },
          symbol: 'circle',
          symbolSize: sizes.SYMBOL,
          areaStyle: {
            normal: {
              color: colors["a" /* default */].lightblue
            }
          },
          data: durations
        }
      };
    }
    /** Helper methods **/

  }, {
    key: "formatPercentage",
    value: function formatPercentage(num, total) {
      var round10 = parseFloat((num / total * 100).toFixed(2));

      if (round10 === 0) {
        return '<0.01';
      }

      return "".concat(round10);
    }
  }, {
    key: "getReleaseEfficiencyTooltip",
    value: function getReleaseEfficiencyTooltip(params) {
      var _this6 = this;

      return this.wrapTooltipTextContext(params.map(function (param) {
        if (param.seriesName === 'Duration') {
          return "<div class=\"tooltip-text-offset\">".concat(_this6.getAverageReleaseDuration(param.value), "</div>");
        }

        return "<div><span class=\"tooltip-text-circle\" style=\"background: ".concat(param.color, "\">&nbsp;</span>\n                    <span>").concat(param.seriesName, ": ").concat(param.value, "%</span></div>");
      }).join(''));
    }
  }, {
    key: "getNumberOfReleasesPerMonth",
    value: function getNumberOfReleasesPerMonth(params) {
      return this.wrapTooltipTextContext(params.map(function (param) {
        return "<div>".concat(param.seriesName, ": ").concat(param.data, "</div>");
      }).join(''));
    }
  }, {
    key: "automationTaskReportTooltip",
    value: function automationTaskReportTooltip(name, color, value, percentage) {
      return this.wrapTooltipTextContext("<span class=\"tooltip-text-circle\" style=\"background: ".concat(color, "\">&nbsp;</span>\n             <span>").concat(name, ": ").concat(value, " (").concat(percentage, "%)</span>"));
    }
  }, {
    key: "automationTaskReport",
    value: function automationTaskReport(automatedValue, manualValue, text, subtext, tooltipFormatter) {
      var automatedName = 'Automated task';
      var manualName = 'Manual task';
      return {
        title: {
          text: text,
          subtext: subtext,
          x: position.CENTER,
          y: '42%',
          textStyle: echarts_reports_service_defaults.TITLE_TEXT_STYLE,
          subtextStyle: echarts_reports_service_defaults.SUB_TITLE_TEXT_STYLE
        },
        tooltip: {
          trigger: 'item',
          backgroundColor: 'transparent',
          formatter: tooltipFormatter
        },
        color: [colors["a" /* default */].purple, colors["a" /* default */].yellow],
        legend: {
          selectedMode: false,
          left: position.CENTER,
          bottom: 15,
          itemWidth: 10,
          data: [{
            name: automatedName,
            icon: 'circle',
            textStyle: {
              color: colors["a" /* default */].gray,
              fontSize: sizes.LEGEND
            }
          }, {
            name: manualName,
            icon: 'circle',
            textStyle: {
              color: colors["a" /* default */].gray,
              fontSize: sizes.LEGEND
            }
          }]
        },
        label: {
          normal: {
            show: true
          }
        },
        series: {
          type: 'pie',
          radius: [70, 100],
          avoidLabelOverlap: false,
          label: {
            normal: {
              show: false,
              position: position.CENTER
            },
            emphasis: {
              show: false,
              textStyle: {
                fontSize: '16'
              }
            }
          },
          labelLine: {
            normal: {
              show: false
            }
          },
          data: [{
            value: automatedValue,
            name: automatedName
          }, {
            value: manualValue,
            name: manualName
          }]
        }
      };
    }
  }, {
    key: "sortOnDuration",
    value: function sortOnDuration(a, b) {
      if (a.duration < b.duration) return -1;
      if (a.duration > b.duration) return 1;
      return 0;
    }
  }, {
    key: "getDurationFormatter",
    value: function getDurationFormatter(durationInMs) {
      var round10 = function round10(val) {
        return parseFloat(val.toFixed(2));
      };

      var durationInSec = function durationInSec(durationInMs) {
        return round10(durationInMs / 1000);
      };

      if (durationInSec(durationInMs) < 60) {
        return {
          format: durationInSec,
          name: 'sec'
        };
      }

      var durationInMin = function durationInMin(durationInMs) {
        return round10(durationInSec(durationInMs) / 60);
      };

      if (durationInMin(durationInMs) < 60) {
        return {
          format: durationInMin,
          name: 'min'
        };
      }

      var durationInHours = function durationInHours(durationInMs) {
        return round10(Math.ceil(durationInMin(durationInMs) / 6) / 10);
      };

      if (durationInHours(durationInMs) < 24) {
        return {
          format: durationInHours,
          name: 'hours'
        };
      }

      return {
        format: function format(durationInMs) {
          return round10(durationInHours(durationInMs) / 24);
        },
        name: 'days'
      };
    }
  }, {
    key: "longestItemsHorizontalBarReport",
    value: function longestItemsHorizontalBarReport(seriesName, data) {
      var _this7 = this;

      // sort the data before using it
      data = data.sort(this.sortOnDuration); // add placeholders if needed

      if (data.length < HORIZONTAL_BAR_NUMS) {
        data = _.times(HORIZONTAL_BAR_NUMS - data.length, _.constant({
          title: '',
          duration: 0,
          isPlaceholder: true
        })).concat(data);
      }

      var durations = data.map(function (it) {
        return it.duration;
      });

      var maxDuration = _.max(durations);

      var durationFormatter = this.getDurationFormatter(maxDuration);
      return {
        sortedData: data,
        color: [colors["a" /* default */].blue],
        grid: {
          left: 220
        },
        sort: 'descending',
        tooltip: {
          trigger: 'axis',
          axisPointer: {
            lineStyle: {
              opacity: 0
            }
          },
          backgroundColor: 'transparent',
          formatter: function formatter(params) {
            return _this7.getHorizontalBarTooltip(data, params[0]);
          }
        },
        yAxis: {
          type: 'category',
          data: data.map(function (it) {
            return it.title;
          }),
          axisTick: {
            show: false
          },
          axisLine: {
            show: false
          },
          axisLabel: {
            color: colors["a" /* default */].black,
            margin: 200,
            textStyle: {
              align: 'left'
            },
            formatter: function formatter(label) {
              return _this7.wrapText(label, 30);
            }
          }
        },
        xAxis: {
          name: durationFormatter.name,
          nameTextStyle: {
            fontSize: sizes.LABEL,
            color: colors["a" /* default */].gray
          },
          type: 'value',
          axisTick: {
            show: false
          },
          axisLine: {
            show: false,
            lineStyle: {
              color: colors["a" /* default */].gray
            }
          },
          axisLabel: {
            formatter: durationFormatter.format
          }
        },
        series: {
          type: 'bar',
          barWidth: sizes.BAR,
          name: seriesName,
          data: durations
        }
      };
    }
  }, {
    key: "getAverageReleaseDuration",
    value: function getAverageReleaseDuration(avg) {
      return "Avg. release duration: ".concat(avg);
    }
  }, {
    key: "getHorizontalBarTooltip",
    value: function getHorizontalBarTooltip(data, params) {
      var item = data[params.dataIndex];
      if (item.isPlaceholder) return '';
      var wrapTextNum = 40;
      var context = [];

      if (params.seriesName === 'release') {
        context.push("<div class=\"tooltip-release-title\" >Release: ".concat(_.escape(item.title), "</div>"));
        context.push("<span>Duration: ".concat(this.durationFilter(item.duration), "</span>"));
      }

      if (params.seriesName === 'phase') {
        context.push("<div>Phase: ".concat(this.wrapText(_.escape(item.title), wrapTextNum), "</div>"));
        context.push("<div>Duration: ".concat(this.durationFilter(item.duration), "</div>"));
        context.push("<div>Belongs to: ".concat(this.wrapText(_.escape(item.release), wrapTextNum), "</div>"));
      }

      if (params.seriesName === 'task') {
        context.push("<div>Task: ".concat(this.wrapText(_.escape(item.title), wrapTextNum), "</div>"));
        context.push("<div>Duration: ".concat(this.durationFilter(item.duration), "</div>"));
        context.push("<div>Belongs to: ".concat(this.wrapText(_.escape(item.release), wrapTextNum), "</div>"));
        context.push("<div>Owner: ".concat(_.escape(item.owner.username) || 'Not assigned', "</div>"));
      }

      return this.wrapTooltipTextContext(context.join(''));
    }
  }, {
    key: "wrapTooltipTextContext",
    value: function wrapTooltipTextContext(context) {
      return "<div class=\"tooltip-text-content\">".concat(context, "</div>");
    }
  }, {
    key: "wrapText",
    value: function wrapText(string, len) {
      return string.length < len ? string : "".concat(string.substring(0, len - 3), "...");
    }
  }, {
    key: "formatMonth",
    value: function formatMonth(month) {
      return month.substr(0, 3);
    }
  }, {
    key: "responsivePie",
    value: function responsivePie(options) {
      var responsiveOptions = {};
      var mediaOptions = angular.copy(options);
      responsiveOptions.baseOption = angular.copy(options);
      responsiveOptions.media = [// Media queries order matters
      {
        query: {
          maxWidth: 290
        },
        option: echarts_reports_service_objectSpread(echarts_reports_service_objectSpread({}, mediaOptions), pieChartSmallWidthSettings)
      }, {
        query: {
          maxHeight: 300
        },
        option: echarts_reports_service_objectSpread(echarts_reports_service_objectSpread({}, mediaOptions), pieChartSmallHeightSettings)
      }, {
        query: {
          maxHeight: 300,
          maxWidth: 290
        },
        option: echarts_reports_service_objectSpread(echarts_reports_service_objectSpread({}, mediaOptions), pieChartSmallSizeSettings)
      }, {
        option: options
      }];
      return responsiveOptions;
    }
  }, {
    key: "responsiveReleaseCountsPie",
    value: function responsiveReleaseCountsPie(options) {
      var responsiveOptions = {};
      var mediaOptions = angular.copy(options);
      responsiveOptions.baseOption = angular.copy(options);
      responsiveOptions.media = [// Media queries order matters
      {
        query: {
          maxWidth: 290
        },
        option: echarts_reports_service_objectSpread(echarts_reports_service_objectSpread({}, mediaOptions), {}, {
          tooltip: {
            position: [0, '30%']
          },
          legend: {
            data: [{
              name: 'Planned',
              icon: 'circle',
              textStyle: {
                color: colors["a" /* default */].gray,
                fontSize: 11
              }
            }, {
              name: 'In progress',
              icon: 'circle',
              textStyle: {
                color: colors["a" /* default */].gray,
                fontSize: 11
              }
            }, {
              name: 'Failed',
              icon: 'circle',
              textStyle: {
                color: colors["a" /* default */].gray,
                fontSize: 11
              }
            }],
            itemWidth: 10,
            bottom: 0,
            selectedMode: false
          },
          series: {
            radius: [35, '65%'],
            label: {
              normal: {
                formatter: '{c}'
              },
              emphasis: {
                formatter: '{c}'
              }
            },
            labelLine: {
              normal: {
                length: 10,
                length2: 5
              }
            }
          }
        })
      }, {
        query: {
          maxHeight: 300
        },
        option: echarts_reports_service_objectSpread(echarts_reports_service_objectSpread({}, mediaOptions), {}, {
          series: {
            radius: [30, '70%'],
            labelLine: {
              normal: {
                length: 5,
                length2: 15
              }
            }
          }
        })
      }, {
        query: {
          maxHeight: 300,
          maxWidth: 290
        },
        option: echarts_reports_service_objectSpread(echarts_reports_service_objectSpread({}, mediaOptions), {}, {
          tooltip: {
            position: [0, '12%']
          },
          series: {
            radius: [28, '65%']
          }
        })
      }, {
        option: options
      }];
      return responsiveOptions;
    }
  }, {
    key: "getReleaseCountsByStatusToolTip",
    value: function getReleaseCountsByStatusToolTip(param) {
      return this.wrapTooltipTextContext("<div>".concat(param.seriesName, " <br />").concat(param.name, ": ").concat(param.value, " (").concat(param.percent, "%)</div>"));
    }
  }, {
    key: "releaseCountsByStatus",
    value: function releaseCountsByStatus(data) {
      return {
        tooltip: {
          trigger: 'item',
          backgroundColor: 'transparent',
          formatter: this.getReleaseCountsByStatusToolTip.bind(this)
        },
        series: [{
          type: 'pie',
          name: 'Releases',
          radius: [55, 100],
          avoidLabelOverlap: true,
          label: {
            normal: {
              formatter: '{b} ({c})',
              show: true,
              position: position.OUTSIDE,
              textStyle: {
                fontSize: 14,
                fontFamily: 'OpenSans'
              }
            },
            emphasis: {
              show: true
            }
          },
          labelLine: {
            normal: {
              show: true,
              textStyle: {
                fontFamily: 'OpenSans'
              }
            }
          },
          data: [{
            value: data.planned,
            name: 'Planned',
            itemStyle: {
              normal: {
                color: colors["a" /* default */].gray
              }
            }
          }, {
            value: data.in_progress,
            name: 'In progress',
            itemStyle: {
              normal: {
                color: colors["a" /* default */].blue
              }
            }
          }, {
            value: data.failed,
            name: 'Failed',
            itemStyle: {
              normal: {
                color: colors["a" /* default */].red
              }
            }
          }]
        }]
      };
    } // ----- utils -----
    // used by plugins

  }]);

  return EchartsReportsService;
}();

defineProperty_default()(echarts_reports_service_EchartsReportsService, "$inject", ['durationFilter']);

angular.module('xlrelease').service('EchartsReportsService', echarts_reports_service_EchartsReportsService);
// EXTERNAL MODULE: ./core/xlr-ui/app/js/reports/duration-filter.js
var duration_filter = __webpack_require__(1383);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/reports/most-recent-releases-report.js
var most_recent_releases_report = __webpack_require__(1384);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/reports/phase-duration.js
var phase_duration = __webpack_require__(1385);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/reports/release-efficiency.js
var release_efficiency = __webpack_require__(1386);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/reports/release-number-report.js

angular.module('xlrelease').directive('releaseNumberReport', ['reportConfigurationService', function (reportConfigurationService) {
  return function (scope, element) {
    scope.$watch('reports.numberOfReleasesPerMonth.data', function (numberOfReleasesPerMonth) {
      if (element.highcharts()) {
        element.highcharts().destroy();
      }

      if (numberOfReleasesPerMonth && numberOfReleasesPerMonth.length) {
        var categories = _.map(_.map(numberOfReleasesPerMonth, 'x'), function (date) {
          return moment(date).format("MMMM YYYY");
        });

        var data = _.map(numberOfReleasesPerMonth, 'y');

        element.highcharts(reportConfigurationService.getHighchartsOptions({
          tooltip: {
            enabled: false
          },
          legend: {
            enabled: false
          },
          xAxis: {
            categories: categories
          },
          yAxis: {
            title: {
              text: 'Number'
            },
            min: 0
          },
          series: [{
            type: 'column',
            name: 'Number',
            data: data,
            dataLabels: {
              enabled: true,
              color: colors["a" /* default */].white,
              align: 'center',
              y: 30
            }
          }]
        }));
      }
    });
  };
}]);
// EXTERNAL MODULE: ./core/xlr-ui/app/js/reports/report-configuration-service.js
var report_configuration_service = __webpack_require__(1387);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/reports/report-container-directive.js
var report_container_directive = __webpack_require__(1388);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/reports/reports-controller.js




var reports_controller_ReportsController = /*#__PURE__*/function () {
  function ReportsController($scope, TagsService, $location, ReportsService, filterSettings, Events, ClientSettings, DateService, durationFilter, $state, TaskDefinitionsService) {
    classCallCheck_default()(this, ReportsController);

    this.scope = $scope;
    this.ClientSettings = ClientSettings;
    this.Events = Events;
    this.DateService = DateService;
    this.durationFilter = durationFilter;
    this.ReportsService = ReportsService;
    this.TagsService = TagsService;
    this.state = $state;
    this.TaskDefinitionsService = TaskDefinitionsService;
    $scope.filters = filterSettings;
    $scope.reportType = $location.path().substring(1);
    $scope.allTags = [];
    $scope.exportReport = ReportsService.exportReport;
    $scope.goToRelease = this.goToRelease.bind(this);
    $scope.formatDuration = this.formatDuration.bind(this);
    $scope.getTaskNameByType = this.getTaskNameByType.bind(this);
    ReportsService.setFilterSettings(filterSettings);
  }

  createClass_default()(ReportsController, [{
    key: "$onInit",
    value: function $onInit() {
      var _this = this;

      this.scope.$on(this.Events.filters.filterChanged, function (evt, filters) {
        _this.loadReports();

        _this.ClientSettings.setReportsFilters(filters);
      });
      this.loadTaskDefinitions();
      this.loadTags();
      this.loadReports();
    }
  }, {
    key: "formatDuration",
    value: function formatDuration(durationInMs) {
      return this.DateService.getReportDuration(durationInMs);
    }
  }, {
    key: "goToRelease",
    value: function goToRelease(params, data) {
      var release = data[params.dataIndex];

      if (release && release.releaseId) {
        this.state.go('release', {
          releaseId: release.releaseId
        });
      }
    }
  }, {
    key: "loadReports",
    value: function loadReports() {
      this.ReportsService.loadReports(this.scope.reportType);
      this.scope.reports = this.ReportsService.getReports();
    }
  }, {
    key: "loadTags",
    value: function loadTags() {
      var _this2 = this;

      this.TagsService.getArchivedReleaseTags().then(function (tags) {
        _this2.scope.allTags = tags;
      });
    }
  }, {
    key: "loadTaskDefinitions",
    value: function loadTaskDefinitions() {
      var _this3 = this;

      this.TaskDefinitionsService.getTaskDefinitions().then(function (resp) {
        _this3.scope.taskDefinitions = _.reduce(resp.data, function (result, value) {
          result[value.typeName] = _.omit(value, 'typeName');
          return result;
        }, {});
      });
    }
  }, {
    key: "getTaskNameByType",
    value: function getTaskNameByType(taskType) {
      var taskDefs = this.scope.taskDefinitions;
      var isDefExist = angular.isDefined(taskDefs) && angular.isDefined(taskDefs[taskType]);
      return isDefExist ? "".concat(taskDefs[taskType].displayGroup, ": ").concat(taskDefs[taskType].displayName) : taskType;
    }
  }]);

  return ReportsController;
}();

defineProperty_default()(reports_controller_ReportsController, "$inject", ['$scope', 'TagsService', '$location', 'ReportsService', 'filterSettings', 'Events', 'ClientSettings', 'DateService', 'durationFilter', '$state', 'TaskDefinitionsService']);

angular.module('xlrelease').controller('ReportsController', reports_controller_ReportsController);
// EXTERNAL MODULE: ./core/xlr-ui/app/js/reports/reports-service.js
var reports_service = __webpack_require__(1389);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/reports/tile-container.js
var tile_container = __webpack_require__(1390);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/security/display-permission-filter.js
var display_permission_filter = __webpack_require__(1391);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/security/forbidden-access-controller.js
var forbidden_access_controller = __webpack_require__(1392);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/security/forbidden-access-service.js
var forbidden_access_service = __webpack_require__(1393);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/security/limited-users-service.js
var limited_users_service = __webpack_require__(1394);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/security/permissions-constants.js
var permissions_constants = __webpack_require__(32);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/security/permissions-controller.js



(function () {
  var PermissionsController = /*#__PURE__*/function () {
    function PermissionsController($scope, Backend, MemberType, displayPermissionFilter, ConfirmLeaveService, Events) {
      classCallCheck_default()(this, PermissionsController);

      this._$scope = $scope;
      this._Backend = Backend;
      this._MemberType = MemberType;
      this._displayPermissionFilter = displayPermissionFilter;
      this._ConfirmLeaveService = ConfirmLeaveService;
      this._Events = Events;
      this._roles = null;
      this._permissionsTableColumns = null;
      this._permissionsContainer = null;
      this._lastSavedDate = null;
      this._dirty = false;

      this._loadPermissions();
    }

    createClass_default()(PermissionsController, [{
      key: "save",
      value: function save() {
        var _this = this;

        var permissionsContainer = this._roles.map(function (role) {
          return {
            role: role,
            permissions: _this._permissionsContainer.filter(function (permission) {
              return permission.roles.find(function (r) {
                return role.name === r.name;
              });
            }).map(function (permission) {
              return permission.value;
            })
          };
        });

        this._Backend.put('roles/permissions/global', permissionsContainer).then(function () {
          _this._lastSavedDate = moment().toDate();
          _this._dirty = false;

          _this._ConfirmLeaveService.disableConfirmation();

          _this._$scope.$emit(_this._Events.permission.refresh);
        });
      }
    }, {
      key: "reset",
      value: function reset() {
        this._loadPermissions();

        this._lastSavedDate = null;
        this._dirty = false;

        this._ConfirmLeaveService.disableConfirmation();
      }
    }, {
      key: "setDirty",
      value: function setDirty() {
        this._dirty = true;

        this._ConfirmLeaveService.requireConfirmation();
      }
    }, {
      key: "_loadPermissions",
      value: function _loadPermissions() {
        var _this2 = this;

        this._Backend.get('roles/permissions/global').then(function (resp) {
          var rolePermissionsView = resp.data;
          _this2._roles = rolePermissionsView.rolePermissions.map(function (rolePermission) {
            return rolePermission.role;
          });
          _this2._permissionsTableColumns = [{
            title: 'Action',
            key: 'action'
          }, {
            title: 'Roles',
            key: 'roles',
            suggestionData: _this2._roles.map(function (role) {
              return {
                name: role.name,
                type: _this2._MemberType.ROLE
              };
            }),
            type: _this2._MemberType.ROLE
          }];
          _this2._permissionsContainer = rolePermissionsView.permissions.filter(function (permission) {
            return _this2._displayPermissionFilter(permission);
          }).map(function (permission) {
            return {
              action: _this2._displayPermissionFilter(permission).label,
              value: permission,
              description: _this2._displayPermissionFilter(permission).description,
              roles: rolePermissionsView.rolePermissions.filter(function (rolePermission) {
                return rolePermission.permissions.includes(permission);
              }).map(function (rolePermission) {
                return {
                  name: rolePermission.role.name,
                  type: _this2._MemberType.ROLE
                };
              })
            };
          });
        });
      }
    }, {
      key: "permissionsTableColumns",
      get: function get() {
        return this._permissionsTableColumns;
      }
    }, {
      key: "permissionsContainer",
      get: function get() {
        return this._permissionsContainer;
      }
    }, {
      key: "lastSavedDate",
      get: function get() {
        return this._lastSavedDate;
      }
    }, {
      key: "dirty",
      get: function get() {
        return this._dirty;
      }
    }]);

    return PermissionsController;
  }();

  PermissionsController.$inject = ['$scope', 'Backend', 'MemberType', 'displayPermissionFilter', 'ConfirmLeaveService', 'Events'];
  angular.module('xlrelease').controller('PermissionsController', PermissionsController);
})();
// EXTERNAL MODULE: ./core/xlr-ui/app/js/security/roles-service.js
var roles_service = __webpack_require__(1395);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/security/task-access-controller.js


var task_access_controller_injectParams = ['Backend', 'RolesService', 'ConfirmLeaveService'];

var task_access_controller_TaskAccessController = /*#__PURE__*/function () {
  function TaskAccessController(Backend, RolesService, ConfirmLeaveService) {
    var _this = this;

    classCallCheck_default()(this, TaskAccessController);

    this._Backend = Backend;
    this._RolesService = RolesService;
    this._ConfirmLeaveService = ConfirmLeaveService;
    this._taskAccesses = [];
    this._taskAccessesMaster = [];
    this._groupedTaskAccesses = [];

    this._RolesService.getRoleNames().then(function (roleNames) {
      _this._roleNames = roleNames.data;
    });

    this._loadTaskAccesses();
  }

  createClass_default()(TaskAccessController, [{
    key: "_loadTaskAccesses",
    value: function _loadTaskAccesses() {
      var ctx = this;

      this._Backend.get('tasks/types-access').then(function (resp) {
        var taskAccesses = resp.data;
        ctx._groupedTaskAccesses = _.groupBy(taskAccesses, function (taskAccess) {
          return taskAccess.taskGroup;
        });
        ctx._taskAccesses = taskAccesses;
        ctx._taskAccessesMaster = angular.copy(taskAccesses);
      });
    }
  }, {
    key: "save",
    value: function save() {
      var ctx = this;

      ctx._Backend.put('tasks/types-access', ctx._taskAccesses).then(function () {
        ctx._loadTaskAccesses();

        ctx._lastSavedDate = moment().toDate();

        ctx._ConfirmLeaveService.disableConfirmation();
      });
    }
  }, {
    key: "isUnchanged",
    value: function isUnchanged() {
      return angular.equals(this._taskAccesses, this._taskAccessesMaster);
    }
  }, {
    key: "reset",
    value: function reset() {
      var _this2 = this;

      // works much faster than copying the entire object
      _.forEach(this._taskAccesses, function (task, i) {
        task.allowedToAll = _this2._taskAccessesMaster[i].allowedToAll;
        task.roles = angular.copy(_this2._taskAccessesMaster[i].roles);
      });

      this._ConfirmLeaveService.disableConfirmation();
    }
  }, {
    key: "onCheckboxAllowToAllChange",
    value: function onCheckboxAllowToAllChange(taskAccess) {
      if (taskAccess.allowedToAll) {
        taskAccess.roles = [];
      }
    }
  }, {
    key: "groupedTaskAccesses",
    get: function get() {
      return this._groupedTaskAccesses;
    }
  }, {
    key: "allRoles",
    get: function get() {
      return this._roleNames;
    }
  }, {
    key: "lastSavedDate",
    get: function get() {
      return this._lastSavedDate;
    }
  }]);

  return TaskAccessController;
}();

task_access_controller_TaskAccessController.$inject = task_access_controller_injectParams;
angular.module('xlrelease').controller('taskAccessController', task_access_controller_TaskAccessController);
// EXTERNAL MODULE: ./core/xlr-ui/app/js/security/users-controller.js
var users_controller = __webpack_require__(1396);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/security/users-service.js




function users_service_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function users_service_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { users_service_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { users_service_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

angular.module('xlrelease').factory('UsersService', ['Backend', 'MemberType', '$q', function (Backend, MemberType, $q) {
  var _this = this;

  var ADMINISTRATOR = 'admin';

  function isUserNameAdmin(user) {
    return user && user.toLowerCase() === ADMINISTRATOR;
  }

  this.mapUsersToObject = function (usersList) {
    return usersList.map(function (o) {
      return {
        name: o.username,
        fullName: o.fullName,
        type: MemberType.PRINCIPAL
      };
    });
  };

  return {
    isUserNameAdmin: isUserNameAdmin,
    isInternalUser: function isInternalUser(user) {
      return user.external === false;
    },
    getAllUsers: function getAllUsers() {
      return Backend.get('users/names');
    },
    getAllUsersAsObjects: function getAllUsersAsObjects() {
      return Backend.get('users/names').then(function (v) {
        return v.data;
      }).then(_this.mapUsersToObject);
    },
    getAllUsersAsObject: function getAllUsersAsObject() {
      return Backend.get('users/names').then(function (v) {
        return v.data.reduce(function (acc, user) {
          return users_service_objectSpread(users_service_objectSpread({}, acc), {}, defineProperty_default()({}, user.username, user));
        }, {});
      });
    }
  };
}]);
// CONCATENATED MODULE: ./core/xlr-ui/app/js/settings/general-settings-controller.js




function general_settings_controller_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function general_settings_controller_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { general_settings_controller_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { general_settings_controller_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

angular.module('xlrelease').controller('generalSettingsController', ['$scope', 'MetadataService', 'CIManager', 'ValueStreamMapping', 'PollingSettings', 'ConfirmLeaveService', 'PhaseColors', 'Page', 'UploadService', 'ContentTypeService', function ($scope, MetadataService, CIManager, ValueStreamMapping, PollingSettings, ConfirmLeaveService, PhaseColors, Page, UploadService, ContentTypeService) {
  var _reportsSettingsCICopy = {};
  var _pollingSettingsCICopy = {};
  var _themeSettingsCICopy = {};
  var _customLogoSettingsCICopy = {};
  var _pluginCICopies = {};
  $scope.UploadService = UploadService;
  UploadService.reset();
  $scope.pluginsInitialized = false;
  $scope.pluginSettings = [{
    title: 'Track changes in template version control',
    help: 'Release will use these settings to enable automatic versioning of template edits. Settings will take effect after 1 minute.',
    descriptorType: 'xlrelease.TemplateVersioningSettings',
    isPresent: false,
    ciManagerSettings: {
      type: 'TemplateVersioningSettings',
      directory: 'Configuration/settings'
    }
  }];
  $scope.pluginCIs = {};
  $scope.allowedContentType = "";

  _initPluginsSettings();

  _initContentTypes();

  $scope.PhaseColors = PhaseColors;

  var _reportsSettingsSaveCallback = function _reportsSettingsSaveCallback() {
    ValueStreamMapping.refreshReportsSettings();
    _reportsSettingsCICopy = angular.copy($scope.reportsSettings.ci);
  };

  var _pollingSettingsSaveCallback = function _pollingSettingsSaveCallback() {
    PollingSettings.refresh();
    _pollingSettingsCICopy = angular.copy($scope.pollingSettings.ci);
  };

  var _themeSettingsSaveCallback = function _themeSettingsSaveCallback() {
    return _themeSettingsCICopy = angular.copy($scope.themeSettings.ci);
  };

  var _customLogoSettingsDeleteCallback = function _customLogoSettingsDeleteCallback() {
    _customLogoSettingsCICopy = angular.copy($scope.customLogoSettings.ci);
    Page.applyCustomLogo(false);
  };

  $scope.reportsSettings = new CIManager({
    type: 'ReportsSettings',
    directory: 'Configuration/reports',
    saveCallback: _reportsSettingsSaveCallback
  });
  $scope.pollingSettings = new CIManager({
    type: 'PollingSettings',
    directory: 'Configuration/settings',
    saveCallback: _pollingSettingsSaveCallback
  });
  $scope.auditReportSettings = new CIManager({
    type: 'AuditReportSettings',
    directory: 'Configuration/settings'
  });
  $scope.archivingSettings = new CIManager({
    type: 'ArchivingSettings',
    directory: 'Configuration/settings'
  });
  $scope.triggerDataPurgeSettings = new CIManager({
    type: 'TriggerDataPurgeSettings',
    directory: 'Configuration/settings'
  });
  $scope.themeSettings = new CIManager({
    type: 'ThemeSettings',
    directory: 'Configuration/settings',
    saveCallback: _themeSettingsSaveCallback
  });
  $scope.customLogoSettings = new CIManager({
    type: 'CustomLogoSettings',
    directory: 'Configuration/settings',
    deleteCallback: _customLogoSettingsDeleteCallback
  });
  $scope.archivingSettingsAge = 0;
  $scope.archivingSettingsAgeCopy = $scope.archivingSettingsAge;
  $scope.archivingSettingsAgeUnit = 'Days';
  $scope.auditReportRetentionPeriod = 0;
  $scope.triggerDataPurgingEnabled = false;
  $scope.triggersDataPurgeAgeThreshold = 0;
  $scope.triggersDataPurgeAgeThresholdCopy = $scope.triggersDataPurgeAgeThreshold;
  $scope.triggersDataPurgeSettingsAgeUnit = 'Days';
  $scope.$watch('archivingSettings.ci.releaseAgeToDeleteFromJcr', function (hours) {
    _setArchiving(hours);
  });
  $scope.$watch('auditReportSettings.ci.reportsRetentionPeriod', function (days) {
    _setAuditReport(days);
  });
  $scope.$watch('triggerDataPurgeSettings.ci.enabled', function (enabled) {
    $scope.triggerDataPurgingEnabled = enabled;
  });
  $scope.$watch('triggerDataPurgeSettings.ci.triggersDataPurgeAgeThreshold', function (hours) {
    _setTriggerDataPurging(hours);
  });

  $scope.setHeaderColor = function (color) {
    $scope.themeSettings.ci.headerAccentColor = color;
  };

  $scope.changeArchivingSettingsAgeUnitType = function () {
    if ($scope.archivingSettingsAgeUnit === 'Days') {
      $scope.archivingSettingsAge = Math.round($scope.archivingSettingsAge / 24);
    } else {
      $scope.archivingSettingsAge = $scope.archivingSettingsAge * 24;
    }
  };

  $scope.changeTriggerPurgeSettingsAgeUnitType = function () {
    if ($scope.triggersDataPurgeSettingsAgeUnit === 'Days') {
      $scope.triggersDataPurgeAgeThreshold = Math.round($scope.triggersDataPurgeAgeThreshold / 24);
    } else {
      $scope.triggersDataPurgeAgeThreshold = $scope.triggersDataPurgeAgeThreshold * 24;
    }
  };

  $scope.save = function () {
    UploadService.reset();

    _setArchivingCI();

    _setAuditReportsCI();

    _setTriggerDataPurgingCI();

    $scope.reportsSettings.save();
    $scope.pollingSettings.save();
    $scope.archivingSettings.save();
    $scope.themeSettings.save();
    $scope.auditReportSettings.save();
    $scope.triggerDataPurgeSettings.save();

    _savePluginSettings();

    if ($scope.file) {
      $scope.upload();
    } else if (angular.isDefined(_customLogoSettingsCICopy.filename) && angular.isUndefined($scope.customLogoSettings.ci.filename)) {
      $scope.customLogoSettings.deleteCi();
    }

    $scope.lastSavedDate = moment().toDate();
    ConfirmLeaveService.disableConfirmation();
    Page.applyTheme($scope.themeSettings.ci);
  };

  $scope.customLogoAddedCallback = function (result) {
    $scope.file = null;
    $scope.customLogoSettings.ci = result;
    _customLogoSettingsCICopy = angular.copy($scope.customLogoSettings.ci);
    Page.applyCustomLogo(true);
  };

  $scope.isCustomLogoImageUndefined = function () {
    return angular.isUndefined($scope.customLogoSettings.ci.filename) && (angular.isUndefined($scope.file) || $scope.file === null || $scope.file === '');
  };

  $scope.getProperty = function (ciManager, propertyName) {
    if (ciManager.type) {
      return _.find(ciManager.type.properties, {
        name: propertyName
      });
    }

    return null;
  };

  $scope.reset = function () {
    $scope.reportsSettings.ci = angular.copy(_reportsSettingsCICopy);
    $scope.pollingSettings.ci = angular.copy(_pollingSettingsCICopy);
    $scope.themeSettings.ci = angular.copy(_themeSettingsCICopy);
    $scope.customLogoSettings.ci = angular.copy(_customLogoSettingsCICopy);
    $scope.file = null;
    UploadService.reset();

    _resetPluginSettings();

    _setArchiving($scope.archivingSettings.ci.releaseAgeToDeleteFromJcr);

    _setAuditReport($scope.auditReportSettings.ci.reportsRetentionPeriod);

    ConfirmLeaveService.disableConfirmation();
  };

  $scope.isUnchanged = function () {
    return angular.equals(_reportsSettingsCICopy, $scope.reportsSettings.ci) && angular.equals(_pollingSettingsCICopy, $scope.pollingSettings.ci) && angular.equals(_themeSettingsCICopy, $scope.themeSettings.ci) && angular.equals(_customLogoSettingsCICopy, $scope.customLogoSettings.ci) && (angular.isUndefined($scope.file) || $scope.file === null || $scope.file === "") && _isPluginSettingsUnchanged() && angular.equals($scope.archivingSettingsAgeCopy, $scope.archivingSettings.ci.releaseAgeToDeleteFromJcr) && angular.equals($scope.auditReportRetentionPeriod, $scope.auditReportSettings.ci.reportsRetentionPeriod) && angular.equals($scope.triggerDataPurgingEnabled, $scope.triggerDataPurgeSettings.ci.enabled) && angular.equals($scope.triggersDataPurgeAgeThresholdCopy, $scope.triggerDataPurgeSettings.ci.triggersDataPurgeAgeThreshold);
  };

  $scope.removeLoadedImage = function () {
    UploadService.reset();
    $scope.customLogoSettings.ci = {};
    $scope.file = null;
  };

  $scope.$watch('reportsSettings.ciLoaded', function (newVal) {
    if (newVal) {
      _reportsSettingsCICopy = angular.copy($scope.reportsSettings.ci);
    }
  });
  $scope.$watch('pollingSettings.ciLoaded', function (newVal) {
    if (newVal) {
      _pollingSettingsCICopy = angular.copy($scope.pollingSettings.ci);
    }
  });
  $scope.$watch('themeSettings.ciLoaded', function (newVal) {
    if (newVal) {
      _themeSettingsCICopy = angular.copy($scope.themeSettings.ci);
    }
  });
  $scope.$watch('customLogoSettings.ciLoaded', function (newVal) {
    if (newVal) {
      _customLogoSettingsCICopy = angular.copy($scope.customLogoSettings.ci);
    }
  });
  $scope.$watch('auditReportSettings.ciLoaded', function (newVal) {
    if (newVal) {
      $scope.auditReportRetentionPeriod = angular.copy($scope.auditReportSettings.ci.reportsRetentionPeriod);
    }
  });
  $scope.$watch('archivingSettingsAge', function (newVal) {
    $scope.archivingSettingsAgeCopy = _convertAgeToHours(newVal, $scope.archivingSettingsAgeUnit);
  });
  $scope.$watch('triggersDataPurgeAgeThreshold', function (newVal) {
    $scope.triggersDataPurgeAgeThresholdCopy = _convertAgeToHours(newVal, $scope.triggersDataPurgeSettingsAgeUnit);
  });

  var _setArchivingCI = function _setArchivingCI() {
    $scope.archivingSettings.ci.releaseAgeToDeleteFromJcr = _convertAgeToHours($scope.archivingSettingsAge, $scope.archivingSettingsAgeUnit);
  };

  var _setAuditReportsCI = function _setAuditReportsCI() {
    $scope.auditReportSettings.ci.reportsRetentionPeriod = $scope.auditReportRetentionPeriod;
  };

  var _convertAgeToHours = function _convertAgeToHours(ageSetting, ageSettingUnit) {
    if (ageSettingUnit === 'Days') {
      return ageSetting * 24;
    }

    return ageSetting;
  };

  var _setArchiving = function _setArchiving(hours) {
    if (!_.isUndefined(hours)) {
      if (hours % 24 === 0) {
        $scope.archivingSettingsAgeUnit = 'Days';
        $scope.archivingSettingsAge = hours / 24;
      } else {
        $scope.archivingSettingsAgeUnit = 'Hours';
        $scope.archivingSettingsAge = hours;
      }
    }
  };

  var _setTriggerDataPurging = function _setTriggerDataPurging(hours) {
    if (!_.isUndefined(hours)) {
      if (hours % 24 === 0) {
        $scope.triggersDataPurgeSettingsAgeUnit = 'Days';
        $scope.triggersDataPurgeAgeThreshold = hours / 24;
      } else {
        $scope.triggersDataPurgeSettingsAgeUnit = 'Hours';
        $scope.triggersDataPurgeAgeThreshold = hours;
      }
    }
  };

  var _setTriggerDataPurgingCI = function _setTriggerDataPurgingCI() {
    $scope.triggerDataPurgeSettings.ci.enabled = $scope.triggerDataPurgingEnabled;
    $scope.triggerDataPurgeSettings.ci.triggersDataPurgeAgeThreshold = _convertAgeToHours($scope.triggersDataPurgeAgeThreshold, $scope.triggersDataPurgeSettingsAgeUnit);
  };

  var _setAuditReport = function _setAuditReport(days) {
    if (!_.isUndefined(days)) {
      $scope.auditReportRetentionPeriod = angular.copy(days);
    }
  };

  function _initPluginsSettings() {
    $scope.pluginSettings.forEach(function (plugin) {
      MetadataService.isTypePresent(plugin.descriptorType).then(function (isPresent) {
        if (isPresent) {
          plugin.isPresent = isPresent;
          $scope.pluginCIs[plugin.descriptorType] = new CIManager(general_settings_controller_objectSpread({
            saveCallback: function saveCallback() {
              return _pluginCICopies[plugin.descriptorType] = angular.copy($scope.pluginCIs[plugin.descriptorType].ci);
            },
            loadCallback: function loadCallback(ci) {
              _pluginCICopies[plugin.descriptorType] = angular.copy(ci);
            }
          }, plugin.ciManagerSettings));
        }
      });
    });
  }

  function _savePluginSettings() {
    $scope.pluginSettings.filter(function (plugin) {
      return plugin.isPresent;
    }).forEach(function (plugin) {
      $scope.pluginCIs[plugin.descriptorType].save();
    });
  }

  function _resetPluginSettings() {
    $scope.pluginSettings.filter(function (plugin) {
      return plugin.isPresent;
    }).forEach(function (plugin) {
      $scope.pluginCIs[plugin.descriptorType].ci = angular.copy(_pluginCICopies[plugin.descriptorType]);
    });
  }

  function _isPluginSettingsUnchanged() {
    return $scope.pluginSettings.filter(function (plugin) {
      return plugin.isPresent;
    }).every(function (plugin) {
      return angular.equals(_pluginCICopies[plugin.descriptorType], $scope.pluginCIs[plugin.descriptorType].ci);
    });
  }

  function _initContentTypes() {
    ContentTypeService.getContentTypesForImage().then(function (resp) {
      $scope.allowedContentType = resp.data.toString();
    });
  }
}]);
// EXTERNAL MODULE: ./core/xlr-ui/app/js/util/toastrFactory.js
var toastrFactory = __webpack_require__(46);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/smtp/smtp-controller.js



angular.module('xlrelease').controller('SmtpController', ['$scope', '$parse', 'Backend', 'CIManager', 'UserProfile', 'ConfirmLeaveService', function ($scope, $parse, Backend, CIManager, UserProfile, ConfirmLeaveService) {
  var init = function init() {
    var ciManager = new CIManager({
      type: 'SmtpServer',
      directory: 'Configuration/mail',
      loadCallback: function loadCallback(ci) {
        if (!ci.testAddress) {
          UserProfile.load().then(function (profile) {
            ci.testAddress = profile.email;
          });
        }

        if (ci.authentication === undefined) {
          ci.authentication = {};
        }
      },
      saveCallback: function saveCallback() {
        return ConfirmLeaveService.disableConfirmation();
      }
    });
    return ciManager;
  };

  $scope.smtp = init();
  var toaster = Object(toastrFactory["a" /* default */])();

  $scope.testConfiguration = function () {
    $scope.isBusy = true;
    $scope.smtp.ci.type = 'xlrelease.SmtpServer';
    $scope.smtp.ci.id = 'Configuration/mail/SmtpServer';
    var URL = 'settings/smtp/checkConfig';
    Backend.post(URL, $scope.smtp.ci).then(function (resp) {
      if (resp) {
        toaster.success("Successfully sent the notification");
      }
    }).finally(function () {
      $scope.isBusy = false;
    });
  };

  $scope.invalidTestAddress = function (testAddress) {
    if (testAddress) {
      return testAddress.length === 0;
    } else {
      return true;
    }
  };
}]);
// EXTERNAL MODULE: ./node_modules/copy-text-to-clipboard/index.js
var copy_text_to_clipboard = __webpack_require__(226);
var copy_text_to_clipboard_default = /*#__PURE__*/__webpack_require__.n(copy_text_to_clipboard);

// EXTERNAL MODULE: ./node_modules/lodash/head.js
var head = __webpack_require__(126);
var head_default = /*#__PURE__*/__webpack_require__.n(head);

// CONCATENATED MODULE: ./core/xlr-ui/app/features/groovy/dsl-template-controller.js




var generateOptions = [{
  group: 'YAML',
  language: 'yaml',
  options: [{
    label: 'Template as-code',
    value: true
  }]
}, {
  group: 'Groovy',
  language: 'groovy',
  options: [{
    label: 'Create template',
    value: true
  }, {
    label: 'Create release',
    value: false
  }]
}];

var dsl_template_controller_DslTemplateController = /*#__PURE__*/function () {
  function DslTemplateController(Page, releasePromise, Backend, Ids, Download, Toastr, FoldersService) {
    classCallCheck_default()(this, DslTemplateController);

    this.release = releasePromise.data;
    this.Ids = Ids;
    this.Backend = Backend;
    this.Download = Download;
    this.Toastr = Toastr;
    this.FoldersService = FoldersService;
    this.templateCode = '';
    this.renderAsTemplate = true;
    this.generateLabel = '';
    this.generateOptions = generateOptions;
    Page.setReleaseOpened(this.release);
  }

  createClass_default()(DslTemplateController, [{
    key: "$onInit",
    value: function $onInit() {
      var group = head_default()(this.generateOptions);
      this.loadCode(group, head_default()(group.options));
    }
  }, {
    key: "loadCode",
    value: function loadCode(generateGroup, selectedOption) {
      var _this = this;

      this.renderAsTemplate = selectedOption.value;
      this.generateLabel = "".concat(generateGroup.group, ": ").concat(selectedOption.label);
      this.templateCode = '';
      var promise = generateGroup.group === 'YAML' ? this.loadYaml() : this.loadDsl();
      promise.then(function (resp) {
        _this.templateCode = resp.data;
        _this.codeLanguage = generateGroup.language;
      });
    }
  }, {
    key: "loadDsl",
    value: function loadDsl() {
      return this.Backend.get(this.getDslExportUrl(true, this.renderAsTemplate));
    }
  }, {
    key: "loadYaml",
    value: function loadYaml() {
      return this.Backend.get(this.getYamlExportUrl(), {
        headers: {
          Accept: 'text/vnd.yaml'
        }
      });
    }
  }, {
    key: "exportDsl",
    value: function exportDsl() {
      this.Download.launch(this.getDslExportUrl(false, true));
    }
  }, {
    key: "exportYaml",
    value: function exportYaml() {
      this.Download.get(this.getYamlExportUrl(), "".concat(this.release.title, ".yaml"), 'text/vnd.yaml');
    }
  }, {
    key: "getDslExportUrl",
    value: function getDslExportUrl() {
      var preview = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
      var renderAsTemplate = arguments.length > 1 ? arguments[1] : undefined;
      return "api/v1/dsl".concat(preview ? '/preview' : '/export', "/").concat(this.Ids.toDomainId(this.release.id), "?exportTemplate=").concat(renderAsTemplate);
    }
  }, {
    key: "getYamlExportUrl",
    value: function getYamlExportUrl() {
      var params = {
        templates: true,
        ciIds: [this.Ids.toDomainId(this.release.id)]
      };
      return "devops-as-code/generate?".concat($.param(params, true));
    }
  }, {
    key: "copyCode",
    value: function copyCode() {
      copy_text_to_clipboard_default()(this.templateCode);
      this.Toastr.success('Code was copied to the clipboard!', {
        preventDuplicates: true
      });
    }
  }]);

  return DslTemplateController;
}();


dsl_template_controller_DslTemplateController.$inject = ['Page', 'releasePromise', 'Backend', 'Ids', 'Download', 'Toastr', 'FoldersService'];
// CONCATENATED MODULE: ./core/xlr-ui/app/features/groovy/dsl-tpl.html
/* harmony default export */ var dsl_tpl = ("<div release-flow-header>\n    <div class=\"buttons\">\n        <button type=\"button\" class=\"export-buttons button dropdown-button\" bs-popover\n                data-content-template=\"partials/releases/template-code-export-dropdown.html\"\n                data-placement=\"bottom\"\n                auto-close=\"true\">\n            <span>Export</span>\n            <i class=\"xl-icon arrow-down-icon icon-s\"></i>\n        </button>\n        <span doc-icon=\"xfile.html\"></span>\n    </div>\n</div>\n<div class=\"content-under-header\">\n    <div class=\"form-horizontal\">\n        <div class=\"form-group\">\n            <div class=\"col-sm-12\">\n                <label class=\"radio-inline\" style=\"padding-left: 0\">\n                    Generate as\n                </label>\n                <div class=\"btn-group generate-menu\" uib-dropdown keyboard-nav>\n                    <button id=\"generate-btn\" type=\"button\" class=\"button\" uib-dropdown-toggle>\n                        {{$ctrl.generateLabel}} <i class='xl-icon arrow-down-icon'></i>\n                    </button>\n                    <ul class=\"dropdown-menu\" uib-dropdown-menu role=\"menu\" aria-labelledby=\"generate-btn\">\n                        <li ng-repeat-start=\"optionGroup in $ctrl.generateOptions\" class=\"dropdown-header\">\n                            {{optionGroup.group}}\n                        </li>\n                        <li ng-repeat-end ng-repeat=\"option in optionGroup.options\" role=\"menuitem\">\n                            <a href ng-click=\"$ctrl.loadCode(optionGroup, option)\">{{option.label}}</a>\n                        </li>\n                    </ul>\n                </div>\n                <a ng-click=\"$ctrl.copyCode()\" class=\"button btn-copy\" tooltip=\"'Copy code'\" tooltip-position=\"right\">\n                    <i class='xl-icon duplicate-icon'></i>\n                </a>\n            </div>\n        </div>\n    </div>\n\n    <div id=\"dsl-content\" ng-if=\"$ctrl.templateCode\" hljs hljs-source=\"$ctrl.templateCode\" hljs-language=\"{{$ctrl.codeLanguage}}\"></div>\n</div>\n");
// CONCATENATED MODULE: ./core/xlr-ui/app/js/states.js



angular.module('xlrelease').config(['$urlMatcherFactoryProvider', '$stateProvider', '$urlRouterProvider', function ($urlMatcherFactoryProvider, $stateProvider, $urlRouterProvider) {
  // add this to have "pretty" URLs, by default UI Router encodes '/' to '~2F'
  $urlMatcherFactoryProvider.type('RiskProfileId', {
    raw: true
  }); // see https://stackoverflow.com/questions/29892353/angular-ui-router-resolve-state-from-url/30926025#30926025

  $stateProvider.decorator('parent', function (internalStateObj, parentFn) {
    internalStateObj.self.$$state = function () {
      return internalStateObj;
    };

    return parentFn(internalStateObj);
  });
  $stateProvider.state('login', {
    url: '/login?reloadUserDetails',
    templateUrl: 'partials/login/login.html',
    controller: 'LoginController',
    resolve: {
      configuration: ['Backend', function (Backend) {
        return Backend.get("server/configuration").then(function (response) {
          return response.data;
        });
      }],
      auth: ['Backend', 'Authenticator', '$stateParams', 'ClientSettings', function (Backend, Authenticator, $stateParams, ClientSettings) {
        if (Authenticator.isAuthenticated() && !$stateParams.reloadUserDetails) {
          // FIXME: Tech debt from LoginController: should always call logout.
          return Authenticator.logout();
        }

        delete $stateParams.reloadUserDetails;
        return Authenticator.tryLoginByIdentityProvider().then(function () {
          if (!ClientSettings.getIdentityProvider()) {
            return Authenticator.logout();
          }
        });
      }]
    }
  }).state('tasks', {
    url: '/tasks',
    reloadOnSearch: false,
    templateUrl: 'partials/tasks/tasks.html',
    controller: 'TasksController',
    resolve: {
      filterSettings: ['Filters', function (Filters) {
        return Filters.getTasksFilterSettings();
      }]
    }
  }).state('task', {
    url: '/tasks/:taskId?showDetails',
    templateUrl: 'partials/tasks/task.html',
    controller: 'TaskController'
  }).state('releaseCreate', {
    url: '/releases/create?fromTemplateId',
    template: '<release-properties release="$resolve.release"></release-properties>',
    resolve: {
      release: ['$stateParams', 'ReleasesService', function ($stateParams, ReleasesService) {
        if ($stateParams.fromTemplateId) {
          return ReleasesService.initNewReleaseFromTemplate($stateParams.fromTemplateId);
        } else {
          return ReleasesService.initNewRelease();
        }
      }]
    }
  }).state('release', {
    url: '/releases/:releaseId',
    templateUrl: 'partials/releases/release-editor.html',
    controller: 'releaseEditorController',
    resolve: {
      release: ['$stateParams', 'ReleasesService', function ($stateParams, ReleasesService) {
        return ReleasesService.getRelease($stateParams.releaseId).then(function (response) {
          return response.data;
        });
      }]
    }
  }).state('releasePlanner', {
    url: '/releases/:releaseId/planner',
    templateUrl: 'partials/releases/gantt/gantt.html',
    controller: 'GanttController',
    resolve: {
      releasePromise: ['$stateParams', 'ReleasesService', function ($stateParams, ReleasesService) {
        return ReleasesService.getRelease($stateParams.releaseId);
      }]
    }
  }).state('releaseTable', {
    url: '/releases/:releaseId/table',
    templateUrl: 'partials/releases/grid/release-grid.html',
    controller: 'releaseGridController',
    controllerAs: 'pageCtrl',
    resolve: {
      releasePromise: ['$stateParams', 'ReleasesService', function ($stateParams, ReleasesService) {
        return ReleasesService.getRelease($stateParams.releaseId);
      }]
    }
  }).state('releasePermissions', {
    url: '/{page:releases|templates}/:releaseId/{optional:permissions|teams}',
    templateUrl: 'partials/releases/release-permissions.html',
    controller: 'releasePermissionsController',
    controllerAs: '$ctrl',
    resolve: {
      release: ['$stateParams', 'ReleasesService', function ($stateParams, ReleasesService) {
        return ReleasesService.getRelease($stateParams.releaseId).then(function (response) {
          return response.data;
        });
      }],
      teams: ['$stateParams', 'TeamsService', function ($stateParams, TeamsService) {
        return TeamsService.getTeams($stateParams.releaseId).then(function (response) {
          return response.data;
        });
      }],
      users: ['UsersService', function (UsersService) {
        return UsersService.getAllUsersAsObjects();
      }],
      roles: ['RolesService', function (RolesService) {
        return RolesService.getRoles();
      }]
    }
  }).state('releaseProperties', {
    url: '/releases/:releaseId/properties',
    template: '<release-properties release="$resolve.release"></release-properties>',
    resolve: {
      release: ['$stateParams', 'ReleasesService', function ($stateParams, ReleasesService) {
        return ReleasesService.getReleaseWithVariables($stateParams.releaseId);
      }]
    }
  }).state('releaseVariables', {
    url: '/releases/:releaseId/variables',
    templateUrl: 'partials/releases/release-variables.html',
    controller: 'releaseVariablesController',
    resolve: {
      releasePromise: ['$stateParams', 'ReleasesService', function ($stateParams, ReleasesService) {
        return ReleasesService.getRelease($stateParams.releaseId);
      }]
    }
  }).state('releasePageExtension', {
    url: '/releases/:releaseId/:extensionPath',
    templateUrl: 'partials/releases/release-page-extension-container.html',
    controller: 'releasePageExtensionController',
    controllerAs: 'releasePageExtensionCtrl',
    resolve: {
      releasePromise: ['$stateParams', 'ReleasesService', function ($stateParams, ReleasesService) {
        return ReleasesService.getReleaseWithDependencies($stateParams.releaseId);
      }]
    }
  }).state('templates', {
    url: '/templates',
    reloadOnSearch: false,
    templateUrl: 'partials/templates/templates.html',
    controller: 'TemplatesController',
    resolve: {
      filters: ['Filters', function (Filters) {
        return Filters.getTemplatesFilterSettings();
      }]
    }
  }).state('templateCreate', {
    url: '/templates/create',
    template: '<template-properties template="$resolve.template"></template-properties>',
    resolve: {
      template: ['ReleasesService', function (ReleasesService) {
        return ReleasesService.initNewTemplate();
      }]
    }
  }).state('template', {
    url: '/templates/:releaseId',
    templateUrl: 'partials/releases/release-editor.html',
    controller: 'releaseEditorController',
    resolve: {
      release: ['$stateParams', 'ReleasesService', function ($stateParams, ReleasesService) {
        return ReleasesService.getRelease($stateParams.releaseId).then(function (response) {
          return response.data;
        });
      }]
    }
  }).state('templateTable', {
    url: '/templates/:releaseId/table',
    templateUrl: 'partials/releases/grid/release-grid.html',
    controller: 'releaseGridController',
    controllerAs: 'pageCtrl',
    resolve: {
      releasePromise: ['$stateParams', 'ReleasesService', function ($stateParams, ReleasesService) {
        return ReleasesService.getRelease($stateParams.releaseId);
      }]
    }
  }).state('templateProperties', {
    url: '/templates/:releaseId/properties',
    template: '<template-properties template="$resolve.template"></template-properties>',
    resolve: {
      template: ['$stateParams', 'ReleasesService', function ($stateParams, ReleasesService) {
        return ReleasesService.getReleaseWithVariables($stateParams.releaseId);
      }]
    }
  }).state('templateVariables', {
    url: '/templates/:releaseId/variables',
    templateUrl: 'partials/releases/release-variables.html',
    controller: 'releaseVariablesController',
    resolve: {
      releasePromise: ['$stateParams', 'ReleasesService', function ($stateParams, ReleasesService) {
        return ReleasesService.getRelease($stateParams.releaseId);
      }]
    }
  }).state('templatePlanner', {
    url: '/templates/:releaseId/planner',
    templateUrl: 'partials/releases/gantt/gantt.html',
    controller: 'GanttController',
    resolve: {
      releasePromise: ['$stateParams', 'ReleasesService', function ($stateParams, ReleasesService) {
        return ReleasesService.getRelease($stateParams.releaseId);
      }]
    }
  }).state('templateDsl', {
    url: '/templates/:releaseId/code',
    controller: dsl_template_controller_DslTemplateController,
    controllerAs: '$ctrl',
    template: dsl_tpl,
    resolve: {
      releasePromise: ['$stateParams', 'ReleasesService', function ($stateParams, ReleasesService) {
        return ReleasesService.getRelease($stateParams.releaseId);
      }]
    }
  }).state('templatePageExtension', {
    url: '/templates/:releaseId/:extensionPath',
    templateUrl: 'partials/releases/release-page-extension-container.html',
    controller: 'releasePageExtensionController',
    controllerAs: 'releasePageExtensionCtrl',
    resolve: {
      releasePromise: ['$stateParams', 'ReleasesService', function ($stateParams, ReleasesService) {
        return ReleasesService.getReleaseWithDependencies($stateParams.releaseId);
      }]
    }
  }).state('profile', {
    url: '/profile',
    templateUrl: 'partials/profile/profile.html',
    controller: 'ProfileController',
    controllerAs: '$ctrl'
  }).state('users', {
    url: '/users',
    permissions: [permissions_constants["b" /* GlobalPermissions */].EDIT_SECURITY],
    templateUrl: 'partials/security/users.html',
    controller: 'UsersController',
    controllerAs: 'users'
  }).state('permissions', {
    url: '/permissions',
    permissions: [permissions_constants["b" /* GlobalPermissions */].EDIT_SECURITY],
    templateUrl: 'partials/security/permissions.html',
    controller: 'PermissionsController',
    controllerAs: '$ctrl'
  }).state('taskAccess', {
    url: '/task-access',
    permissions: [permissions_constants["b" /* GlobalPermissions */].EDIT_SECURITY],
    templateUrl: 'partials/security/task-access.html',
    controller: 'taskAccessController',
    controllerAs: '$pageCtrl'
  }).state('generalSettings', {
    url: '/general-settings',
    permissions: [permissions_constants["b" /* GlobalPermissions */].ADMINISTRATOR],
    templateUrl: 'partials/settings/general-settings.html',
    controller: 'generalSettingsController'
  }).state('globalVariables', {
    url: '/global-variables',
    templateUrl: 'partials/variables/global-variables.html',
    controller: 'globalVariablesController'
  }).state('calendar', {
    controller: function controller(filterSettings, $scope, ClientSettings, Events, FiltersQueryParams) {
      var _this = this;

      this.filterSettings = filterSettings;
      this.initialDate = filterSettings.date;
      this.filtersQueryParams = FiltersQueryParams;

      this.updateFilters = function (filters) {
        var newFilters = _.assign(_.cloneDeep(filters), {
          date: filters.date
        });

        _this.filtersQueryParams.updateAsync(newFilters);

        ClientSettings.setTimelineFilters(newFilters);
      };
    },
    controllerAs: '$ctrl',
    resolve: {
      filterSettings: ['Filters', function (Filters) {
        return Filters.getTimelineFilterSettings();
      }]
    },
    url: '/calendar',
    reloadOnSearch: false,
    template: '<timeline-page filter-settings="$ctrl.filterSettings" update-filters="$ctrl.updateFilters" />'
  }).state('reports', {
    url: '/reports',
    permissions: [permissions_constants["b" /* GlobalPermissions */].VIEW_REPORTS, permissions_constants["b" /* GlobalPermissions */].AUDIT_ALL],
    reloadOnSearch: false,
    templateUrl: 'partials/reports/dashboard.html',
    controller: 'ReportsController',
    resolve: {
      filterSettings: ['Filters', function (Filters) {
        return Filters.getReportsFiltersSettings();
      }]
    }
  }).state('releaseValueStream', {
    url: '/release-value-stream',
    permissions: [permissions_constants["b" /* GlobalPermissions */].VIEW_REPORTS, permissions_constants["b" /* GlobalPermissions */].AUDIT_ALL],
    reloadOnSearch: false,
    templateUrl: 'partials/value-stream-mapping/release-value-stream.html',
    controller: 'releaseValueStreamController',
    resolve: {
      filterSettings: ['Filters', function (Filters) {
        return Filters.getReleaseValueStreamFilterSettings();
      }]
    }
  }).state('smtp', {
    url: '/smtp',
    permissions: [permissions_constants["b" /* GlobalPermissions */].ADMINISTRATOR],
    templateUrl: 'partials/smtp/smtp.html',
    controller: 'SmtpController'
  }).state('riskSettings', {
    url: '/risks',
    params: {
      edit: null
    },
    templateUrl: 'partials/risks/risk-settings.html',
    controller: 'riskSettingsController',
    controllerAs: 'ctrl'
  }).state('riskProfile', {
    url: '/risks/riskProfile/{riskProfileId:RiskProfileId}',
    templateUrl: 'partials/risks/risk-profile/risk-profile.html',
    controller: 'riskProfileController',
    controllerAs: 'ctrl'
  }).state('configuration', {
    url: '/configuration',
    permissions: [permissions_constants["b" /* GlobalPermissions */].ADMINISTRATOR, permissions_constants["b" /* GlobalPermissions */].AUDIT_ALL],
    templateUrl: 'partials/configuration/configuration.html'
  }).state('forbiddenAccess', {
    url: '/forbidden-access',
    templateUrl: 'partials/server-error/forbidden-access.html',
    controller: 'forbiddenAccessController'
  }).state('invalidLicense', {
    url: '/invalid-license',
    templateUrl: 'partials/licenses/invalid-license.html',
    controller: 'LicenseController'
  }).state('default', {
    url: '/default',
    template: '<div></div>',
    controller: 'defaultRouteController'
  }).state('mainMenuExtensions', {
    templateUrl: 'partials/index/main-menu-extension-container.html',
    controller: 'mainMenuExtensionController',
    controllerAs: 'vm'
  });
  $urlRouterProvider.when(/(^$|\/$)/, '/default').otherwise(function ($injector) {
    var $state = $injector.get('$state');
    $state.go('mainMenuExtensions', {}, {
      location: false,
      reload: true
    });
  });
}]).run(['$rootScope', '$state', 'Authenticator', 'Events', 'RedirectOnLoginService', function ($rootScope, $state, Authenticator, Events, RedirectOnLoginService) {
  $rootScope.$on('$stateChangeError', function (event, toState, toParams, fromState) {
    if (fromState && fromState.name === 'login') {
      $state.go('releaseOverview');
    }
  });
  $rootScope.$on('$stateChangeStart', function (event, toState, toStateParams) {
    if (toState && !['login', 'loginSpnego', 'default'].includes(toState.name) && !Authenticator.isAuthenticated()) {
      // if user is not logged in, we should redirect to login page instead of "not authorized" page
      event.preventDefault(); // save toState url into RedirectOnLoginService.redirectOnLoginURL

      RedirectOnLoginService.registerRequestedURL();
      return Authenticator.loadUserDetailsByAuth().then(function () {
        if (Authenticator.isAuthenticated()) {
          // ok, I'm authenticated this time, so I shouldn't
          // get in a redirection loop unless Authenticator
          // changes its mind very quickly
          $state.go(toState, toStateParams, {
            reload: true
          });
        }
      }).catch(function () {
        $state.go('login');
      });
    }

    if (toState.permissions) {
      var hasAny = Authenticator.hasAnyOfPermissions(toState.permissions);

      if (!hasAny) {
        event.preventDefault();
        var errorMessage = "You do not have ".concat(toState.permissions, " permission");
        $rootScope.$emit(Events.permission.forbidden, errorMessage);
      }
    }
  });
}]);
// CONCATENATED MODULE: ./core/xlr-ui/app/js/tags/tags-service.js



var tags_service_TagsService = /*#__PURE__*/function () {
  function TagsService(Backend) {
    classCallCheck_default()(this, TagsService);

    this._Backend = Backend;
  }

  createClass_default()(TagsService, [{
    key: "getReleaseTags",
    value: function getReleaseTags() {
      return this._Backend.get('releases/tags').then(function (response) {
        return response.data;
      });
    }
  }, {
    key: "getArchivedReleaseTags",
    value: function getArchivedReleaseTags() {
      return this._Backend.get('releases/tags/archived').then(function (response) {
        return response.data;
      });
    }
  }, {
    key: "getAllTags",
    value: function getAllTags() {
      return Promise.all([this.getReleaseTags(), this.getArchivedReleaseTags()]).then(function (promises) {
        return _.uniq(_.flattenDeep(promises));
      });
    }
  }]);

  return TagsService;
}();

tags_service_TagsService.$inject = ['Backend'];
angular.module('xlrelease').service('TagsService', tags_service_TagsService);
// EXTERNAL MODULE: ./core/xlr-ui/app/js/tasks/assignee-directive.js
var assignee_directive = __webpack_require__(1397);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/tasks/component/mentions-textarea-component.js




function mentions_textarea_component_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function mentions_textarea_component_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { mentions_textarea_component_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { mentions_textarea_component_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var mentions_textarea_component_template = "\n    <textarea rows=\"{{$ctrl.rows}}\" class=\"input-block-level {{$ctrl.cssClass}}\"\n        ng-model=\"$ctrl.model\"\n        placeholder=\"{{$ctrl.placeholder}}\"\n        ng-required=\"$ctrl.isRequired\"\n        auto-focus\n        mentio\n        mentio-require-leading-space=\"true\"\n        mentio-items=\"$ctrl.users | filter:typedTerm\"\n        mentio-select=\"'@' + item.username\">\n    </textarea>\n";

var mentions_textarea_component_MentionsTextareaController = /*#__PURE__*/function () {
  function MentionsTextareaController(UsersService) {
    classCallCheck_default()(this, MentionsTextareaController);

    this.UsersService = UsersService;
  }

  createClass_default()(MentionsTextareaController, [{
    key: "$onInit",
    value: function $onInit() {
      var _this = this;

      this.placeholder = this.placeholder || 'Give feedback or place a comment...';
      this.rows = this.rows || 4;

      if (this.users === undefined) {
        this.UsersService.getAllUsers().then(function (resp) {
          _this.users = _.sortBy(resp.data, [function (rp) {
            return rp.username.toLowerCase();
          }]).map(function (user) {
            return mentions_textarea_component_objectSpread(mentions_textarea_component_objectSpread({}, user), {}, {
              label: user.fullName ? "".concat(user.fullName, " (").concat(user.username, ")") : user.username
            });
          });
        });
      }
    }
  }]);

  return MentionsTextareaController;
}();

defineProperty_default()(mentions_textarea_component_MentionsTextareaController, "$inject", ['UsersService']);

var MentionsTextareaComponent = {
  bindings: {
    model: '=',
    users: '<',
    rows: '@',
    cssClass: '@',
    isRequired: '<',
    placeholder: '@'
  },
  controller: mentions_textarea_component_MentionsTextareaController,
  template: mentions_textarea_component_template
};
angular.module('xlrelease').component('mentionsTextarea', MentionsTextareaComponent);
// CONCATENATED MODULE: ./core/xlr-ui/app/js/tasks/component/facet-form-component.js





function facet_form_component_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function facet_form_component_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { facet_form_component_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { facet_form_component_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var facet_form_component_FacetFormController = /*#__PURE__*/function () {
  function FacetFormController(FacetsService) {
    classCallCheck_default()(this, FacetFormController);

    this.FacetsService = FacetsService;
  }

  createClass_default()(FacetFormController, [{
    key: "$onInit",
    value: function $onInit() {
      var _this = this;

      this.facetTemplateUrl = '';
      this.selectedType = null;

      if (!this.facet) {
        this.facet = {};
      } else {
        this.selectedType = this.facet.type;

        this._fetchFacetProperties();
      }

      this.facetTypeNames = this.facetTypes.filter(function (facet) {
        return !_this.FacetsService.isImmutable(_this.facetTypes.find(function (t) {
          return t.type === facet.type;
        }));
      }).map(function (t) {
        return {
          id: t.type,
          title: t.label
        };
      });
    }
  }, {
    key: "onFacetTypeChange",
    value: function onFacetTypeChange() {
      if (this.readonly) {
        return;
      }

      this.facet = {
        id: this.facet.id,
        targetId: this.facet.targetId
      };

      this._fetchFacetProperties();
    }
  }, {
    key: "_fetchFacetProperties",
    value: function _fetchFacetProperties() {
      var _this2 = this;

      var facetType = this.facetTypes.find(function (t) {
        return t.type === _this2.selectedType;
      });
      this.facet.type = this.selectedType;
      this.facetSelected = facetType.properties.filter(function (prop) {
        return prop.name === 'configurationUri';
      })[0];
      this.facetTemplateUrl = "static/10.2.14/".concat(this.facetSelected.default || 'include/Facets/dip-facet-config.html');

      if (!this.facetSelected.default) {
        this.facetPropertyDefinitions = _.filter(facetType.properties, function (p) {
          return p.category === 'input' && p.hidden !== true;
        });
        this.facetProperties = this._expandProperties(this.facet, this.facetPropertyDefinitions);
      }
    }
  }, {
    key: "onFormSubmit",
    value: function onFormSubmit() {
      if (this.readonly) {
        return;
      }

      if (this.facetProperties) {
        this._collapseProperties(this.facet, this.facetProperties);
      }

      if (!this.facet.id) {
        this.facet.id = '-1';
      }

      this.onSubmit({
        facet: facet_form_component_objectSpread({}, this.facet)
      });
    }
  }, {
    key: "_expandProperties",
    value: function _expandProperties(ci, definitions) {
      return definitions.reduce(function (properties, prop) {
        properties[prop.name] = {
          value: ci[prop.name],
          variable: (ci.variableMapping || {})[prop.name]
        };
        return properties;
      }, {});
    }
  }, {
    key: "_collapseProperties",
    value: function _collapseProperties(ci, properties) {
      var _this3 = this;

      Object.entries(properties).forEach(function (_ref) {
        var _ref2 = slicedToArray_default()(_ref, 2),
            name = _ref2[0],
            variableOrValue = _ref2[1];

        if (variableOrValue && _.isObject(variableOrValue)) {
          ci[name] = variableOrValue.value;

          var propDef = _this3.facetPropertyDefinitions.find(function (p) {
            return p.name === name;
          });

          if (propDef && propDef.kind === "DATE") {
            ci[name] = new Date(variableOrValue.value);
          }

          ci.variableMapping = ci.variableMapping || {};

          if (variableOrValue.variable) {
            ci.variableMapping[name] = variableOrValue.variable;
          } else {
            delete ci.variableMapping[name];
          }
        } else {
          ci[name] = variableOrValue;
        }
      });
    }
  }]);

  return FacetFormController;
}();

defineProperty_default()(facet_form_component_FacetFormController, "$inject", ['FacetsService']);

var FacetFormComponent = {
  bindings: {
    facet: '<',
    facetTypes: '<',
    onCancel: '&',
    onSubmit: '&',
    readonly: '<',
    variables: '<',
    resolvedVariables: '<',
    onNewVariable: '&'
  },
  controller: facet_form_component_FacetFormController,
  templateUrl: 'partials/tasks/details/component/facet-form-component.html'
};
angular.module('xlrelease').component('facetForm', FacetFormComponent);
// CONCATENATED MODULE: ./core/xlr-ui/app/js/tasks/component/task-icon-component.js



var task_icon_component_template = "\n    <!--Core tasks-->\n    <i ng-if=\"$ctrl.TasksService.isUserInputTask($ctrl.task)\" class=\"xl-icon keyboard-icon\" title=\"User Input\"></i>\n    <i ng-if=\"$ctrl.TasksService.isNotificationTask($ctrl.task)\" class=\"xl-icon mail-icon\" title=\"Notification\"></i>\n    <i ng-if=\"$ctrl.TasksService.isScriptTask($ctrl.task)\" class=\"xl-icon script-icon\" title=\"Script\"></i>\n    <i ng-if=\"$ctrl.TasksService.isGateTask($ctrl.task)\" class=\"xl-icon check-icon\" title=\"Gate\"></i>\n    <i ng-if=\"$ctrl.TasksService.isParallelGroup($ctrl.task)\" class=\"xl-icon parallel-icon\" title=\"Parallel Group\"></i>\n    <i ng-if=\"$ctrl.TasksService.isSequentialGroup($ctrl.task)\" class=\"xl-icon sequential-icon\" title=\"Sequential Group\"></i>\n    <i ng-if=\"$ctrl.TasksService.isCreateReleaseTask($ctrl.task)\" class=\"xl-icon add-icon\" title=\"Create Release\"></i>\n    \n    <!--Manual task-->\n    <i ng-if=\"$ctrl.TasksService.isManualTask($ctrl.task) && $ctrl.taskOwner\" class=\"xl-icon user-icon\" title=\"Manual\"></i>\n    <i ng-if=\"$ctrl.TasksService.isManualTask($ctrl.task) && !$ctrl.taskOwner\" class=\"xl-icon users-icon\" title=\"Manual\"></i>\n    \n    <!--Custom script tasks-->\n    <i ng-if=\"$ctrl.TasksService.isCustomScriptTask($ctrl.task) && !$ctrl.task.customIconLocation && !$ctrl.task.customIconClass\" class=\"xl-icon script-icon\"></i>\n    <i ng-if=\"$ctrl.TasksService.isCustomScriptTask($ctrl.task) && $ctrl.task.customIconClass\" class=\"xl-icon {{$ctrl.task.customIconClass}}\"></i>\n    <i ng-if=\"$ctrl.TasksService.isCustomScriptTask($ctrl.task) && $ctrl.task.customIconLocation && !$ctrl.task.customIconClass\" class=\"custom-script-image\">\n      <img ng-src=\"static/10.2.14/{{ $ctrl.task.customIconLocation }}\">\n    </i>\n";

var task_icon_component_TaskIconController = /*#__PURE__*/function () {
  function TaskIconController(TasksService) {
    classCallCheck_default()(this, TaskIconController);

    this.TasksService = TasksService;
  }

  createClass_default()(TaskIconController, [{
    key: "$onInit",
    value: function $onInit() {
      this.task = {
        type: this.taskType,
        taskOwner: this.taskOwner,
        customIconLocation: this.customIconLocation,
        customIconClass: this.customIconClass
      };
    }
  }]);

  return TaskIconController;
}();

defineProperty_default()(task_icon_component_TaskIconController, "$inject", ['TasksService']);

var TaskIconComponent = {
  bindings: {
    taskType: '<',
    taskOwner: '<',
    customIconLocation: '<',
    customIconClass: '<'
  },
  controller: task_icon_component_TaskIconController,
  template: task_icon_component_template
};
angular.module('xlrelease').component('taskIcon', TaskIconComponent);
// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/asyncToGenerator.js
var asyncToGenerator = __webpack_require__(128);
var asyncToGenerator_default = /*#__PURE__*/__webpack_require__.n(asyncToGenerator);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/regenerator/index.js
var regenerator = __webpack_require__(7);
var regenerator_default = /*#__PURE__*/__webpack_require__.n(regenerator);

// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./core/xlr-ui/app/js/tasks/component/dip-lookup-component.less
var dip_lookup_component = __webpack_require__(717);
var dip_lookup_component_default = /*#__PURE__*/__webpack_require__.n(dip_lookup_component);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/tasks/component/dip-lookup-component.less

            

var dip_lookup_component_options = {};

dip_lookup_component_options.insert = "head";
dip_lookup_component_options.singleton = false;

var dip_lookup_component_update = injectStylesIntoStyleTag_default()(dip_lookup_component_default.a, dip_lookup_component_options);



/* harmony default export */ var component_dip_lookup_component = (dip_lookup_component_default.a.locals || {});
// CONCATENATED MODULE: ./core/xlr-ui/app/js/tasks/component/dip-lookup-component.js




function dip_lookup_component_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function dip_lookup_component_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { dip_lookup_component_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { dip_lookup_component_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }



var dip_lookup_component_template = "\n<div class=\"dip-lookup-component\">\n     <xl-react-widget-autocomplete id=\"{{$ctrl.property.name}}-xlr-autocomplete\"\n                                   ng-if=\"$ctrl.showLookup\"\n                                   disable-sorting=\"true\"\n                                   handlers=\"$ctrl.lookupHandlers\"\n                                   metadata=\"$ctrl.metadata\"\n                                   on-pristinity-change=\"$ctrl.onPristinityChange\"\n                                   model=\"$ctrl.lookupModel\"\n                                   obj-label=\"'label'\"\n                                   on-suggestion-selected=\"$ctrl.onSuggestionSelected\"\n                                   on-model-change=\"$ctrl.onModelChange\"\n                                   register=\"$ctrl.registerAutocomplete\"\n    ></xl-react-widget-autocomplete>\n    <span inline-text-editor\n      class=\"field\"\n      ng-if=\"$ctrl.isTask && !$ctrl.showLookup && $ctrl.property.size != 'LARGE'\"\n      model=\"$ctrl.model[$ctrl.property.name]\"\n      on-change=\"$ctrl.onChange()\"\n      name=\"{{::$ctrl.property.name}}\">\n        <span display-variables=\"$ctrl.model[$ctrl.property.name]\" variables=\"$ctrl.variables\" tabindex=\"0\"></span>\n    </span>\n    <input ng-show=\"!$ctrl.isTask && !$ctrl.showLookup && $ctrl.property.size != 'LARGE'\" type=\"text\"\n           id=\"{{$ctrl.property.name}}\" ng-model=\"$ctrl.model[$ctrl.property.name]\"\n           name=\"{{$ctrl.property.name}}\"\n           ng-required=\"$ctrl.property.required\" class=\"input-block-level\" autocomplete=\"off\"\n           data-ng-disabled=\"$ctrl.readOnly\">\n    <button class=\"button button-icon\" data-ng-class=\"{primary: $ctrl.showLookup, secondary: !$ctrl.showLookup}\" ng-click=\"$ctrl.toggleLookup()\" title=\"Lookup\">\n        <i class=\"button-toggle-filter-icon xl-icon search-icon\"></i>\n     </button>\n</div>\n";

var dip_lookup_component_DipLookupController = function DipLookupController(Backend, $scope, MetadataService) {
  var _this = this;

  classCallCheck_default()(this, DipLookupController);

  defineProperty_default()(this, "$onInit", /*#__PURE__*/asyncToGenerator_default()( /*#__PURE__*/regenerator_default.a.mark(function _callee() {
    var _this$ci;

    return regenerator_default.a.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            // TODO hack to get the type
            _this.ci_type = _this !== null && _this !== void 0 && (_this$ci = _this.ci) !== null && _this$ci !== void 0 && _this$ci.type ? _this.ci.type : _this.property.fqn.substring(0, _this.property.fqn.lastIndexOf('.'));
            _context.next = 3;
            return _this.MetadataService.getDescriptor(_this.ci_type);

          case 3:
            _this.ci_descriptor = _context.sent;
            _this.isTask = _.includes(_this.ci_descriptor.superTypes, 'xlrelease.Task');
            _this.isTile = _.includes(_this.ci_descriptor.superTypes, 'xlrelease.Tile');

          case 6:
          case "end":
            return _context.stop();
        }
      }
    }, _callee);
  })));

  defineProperty_default()(this, "registerAutocomplete", function (api) {
    api.focus();
  });

  defineProperty_default()(this, "lookupHandlers", {
    addCandidates: function () {
      var _addCandidates = asyncToGenerator_default()( /*#__PURE__*/regenerator_default.a.mark(function _callee2(_ref2) {
        var value;
        return regenerator_default.a.wrap(function _callee2$(_context2) {
          while (1) {
            switch (_context2.prev = _context2.next) {
              case 0:
                value = _ref2.value;

                if (!(!_.isEmpty(_this.lookupValues) && !_this.dynamicLookup)) {
                  _context2.next = 5;
                  break;
                }

                return _context2.abrupt("return", Promise.resolve(_this.lookupValues.filter(function (suggestion) {
                  return suggestion.label.toLowerCase().includes(value.toLowerCase());
                })));

              case 5:
                if (!_this.isTask) {
                  _context2.next = 11;
                  break;
                }

                _context2.next = 8;
                return _this.addCandidatesForTask(value);

              case 8:
                _this.lookupValues = _context2.sent;
                _context2.next = 20;
                break;

              case 11:
                if (!_this.isTile) {
                  _context2.next = 17;
                  break;
                }

                _context2.next = 14;
                return _this.addCandidatesForTile(value);

              case 14:
                _this.lookupValues = _context2.sent;
                _context2.next = 20;
                break;

              case 17:
                _context2.next = 19;
                return _this.addCandidatesForSharedConfiguration(value);

              case 19:
                _this.lookupValues = _context2.sent;

              case 20:
                return _context2.abrupt("return", Promise.resolve(_this.lookupValues));

              case 21:
              case "end":
                return _context2.stop();
            }
          }
        }, _callee2);
      }));

      function addCandidates(_x) {
        return _addCandidates.apply(this, arguments);
      }

      return addCandidates;
    }()
  });

  defineProperty_default()(this, "addCandidatesForTask", function (value) {
    var ci = dip_lookup_component_objectSpread(dip_lookup_component_objectSpread({}, _this.ci), {}, {
      inputProperties: dip_lookup_component_objectSpread({}, _this.ci.inputProperties)
    });

    if (value) {
      ci.inputProperties[_this.property.name] = value;
    }

    ci.id = ci.id || "";
    return _this._doPost('lookup/fullview', ci);
  });

  defineProperty_default()(this, "addCandidatesForSharedConfiguration", function (value) {
    var ci = _this._create_ci(value);

    return _this._doPost('lookup', ci);
  });

  defineProperty_default()(this, "addCandidatesForTile", function (value) {
    var ci = _this._create_ci(value);

    return _this._doPost('lookup/tile', ci);
  });

  defineProperty_default()(this, "_create_ci", function (value) {
    var ci = dip_lookup_component_objectSpread({}, _this.ci);

    if (value) {
      ci[_this.property.name] = value;
    }

    ci.id = ci.id || "";
    ci.type = _this.ci_type;
    return ci;
  });

  defineProperty_default()(this, "toggleLookup", function () {
    _this.showLookup = !_this.showLookup;

    if (_this.showLookup) {
      _this.lookupModel.label = "";
      _this.lookupModel.value = "";
    }
  });

  defineProperty_default()(this, "onSuggestionSelected", function (_ref3) {
    var label = _ref3.label,
        value = _ref3.value;
    _this.model[_this.property.name] = value;
    _this.lookupModel = {
      label: label,
      value: value
    };
    _this.showLookup = false;

    _this.onChange(); // somehow for shared configuration we need to apply to make the toggle work and make the form update pristine


    _this.$scope.$apply();
  });

  defineProperty_default()(this, "onModelChange", function (value) {
    // to clean the model when X is pressed
    if (_.isEmpty(value)) {
      _this.model[_this.property.name] = "";
      _this.lookupModel = {
        label: "",
        value: ""
      };

      _this.onChange();
    }
  });

  defineProperty_default()(this, "_doPost", /*#__PURE__*/function () {
    var _ref4 = asyncToGenerator_default()( /*#__PURE__*/regenerator_default.a.mark(function _callee3(url, ci) {
      var response;
      return regenerator_default.a.wrap(function _callee3$(_context3) {
        while (1) {
          switch (_context3.prev = _context3.next) {
            case 0:
              _context3.prev = 0;
              _context3.next = 3;
              return _this.Backend.post(url, {
                ci: ci,
                propertyName: _this.property.name
              });

            case 3:
              response = _context3.sent;
              return _context3.abrupt("return", Promise.resolve(response.data.result));

            case 7:
              _context3.prev = 7;
              _context3.t0 = _context3["catch"](0);
              return _context3.abrupt("return", Promise.reject(_context3.t0));

            case 10:
            case "end":
              return _context3.stop();
          }
        }
      }, _callee3, null, [[0, 7]]);
    }));

    return function (_x2, _x3) {
      return _ref4.apply(this, arguments);
    };
  }());

  this.Backend = Backend;
  this.$scope = $scope;
  this.MetadataService = MetadataService;
  this.lookupModel = {
    label: "",
    value: ""
  };
  this.showLookup = false;
  this.metadata = {
    placeholder: 'Type...'
  };
  this.lookupValues = [];
};

defineProperty_default()(dip_lookup_component_DipLookupController, "$inject", ['Backend', '$scope', 'MetadataService']);

var dipLookupComponent = {
  bindings: {
    ci: '<',
    dynamicLookup: '<',
    model: '=',
    onChange: '&',
    property: '=',
    variables: '=',
    readOnly: '<'
  },
  controller: dip_lookup_component_DipLookupController,
  template: dip_lookup_component_template
};
angular.module('xlrelease').component('dipLookup', dipLookupComponent);
// EXTERNAL MODULE: ./core/xlr-ui/app/features/common/services/http.js
var http = __webpack_require__(16);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/tasks/create-release-details-controller.js





function create_release_details_controller_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function create_release_details_controller_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { create_release_details_controller_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { create_release_details_controller_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }


var DEFAULT_RISK_PROFILE_ID = "Configuration/riskProfiles/RiskProfileDefault";
var CHANGE_TEMPLATE_MSGS = {
  default: 'Are you sure you want to change the template to "${targetTemplate}"?',
  noPermission: 'You do not have the permissions required to revert this change. Are you sure you want to select "${targetTemplate}"?',
  variableChanged: 'Template variables have been changed. Are you sure you want to select "${targetTemplate}"?',
  blank: 'Are you sure you want to remove this template from the task?',
  blankVarChanged: 'Template variables have been changed. Are you sure you want to remove this template from the task?',
  both: 'Template variables have been changed and reverting this template will not be possible. Are you sure you want to select "${targetTemplate}"?'
};
var CHANGE_FOLDER_MSGS = {
  default: 'Are you sure you want to change the folder to "${targetFolderTitle}"?',
  blank: 'Are you sure you want to remove this folder from the task?',
  noPermission: "You won't be able to select the previously selected folder again since you lack permissions"
};
var FOLDER_DESC = {
  default: 'The new release will be created in this folder.',
  parentFolder: 'The new release will be created in folder "${parentFolder}".'
};
var EMPTY_VARIABLES = [];

var create_release_details_controller_CreateReleaseDetailsController = /*#__PURE__*/function () {
  function CreateReleaseDetailsController($scope, $q, $timeout, TemplatesService, Backend, VariablesService, TasksService, FoldersService, Ids) {
    var _this = this;

    classCallCheck_default()(this, CreateReleaseDetailsController);

    defineProperty_default()(this, "onFolderValueChange", function (folder) {
      if (_.get(folder, 'selectedId')) {
        var foundFolder = _this._findFolderById(folder.selectedId, _this._folders, 1000);

        if (_.get(_this._selectedFolder, 'value')) {
          if (foundFolder) {
            _this._newSelectedFolder = foundFolder;
            _this._folderConfirmationMsg = CHANGE_FOLDER_MSGS.default.replace('${targetFolderTitle}', _.get(_this._newSelectedFolder, 'title'));
            _this._showFolderConfirmation = true;

            _this.$scope.$apply(function () {
              return _this._showFolderConfirmation;
            });
          }
        } else {
          _this._setSelectedFolderFrom(foundFolder.id, foundFolder.enabled);

          _this.folderId = _this._selectedFolder.id;

          _this.$scope.$apply(function () {
            return _this.folderId;
          });

          _this._setFolderInfoOnFolderChange();
        }
      } else {
        //Clear selection
        _this._newSelectedFolder = null;
        _this._folderConfirmationMsg = CHANGE_FOLDER_MSGS.blank;
        _this._showFolderConfirmation = true;

        _this.$scope.$apply(function () {
          return _this._showFolderConfirmation;
        });
      }
    });

    this._propertiesWithVars = ['templateVariables[]', 'startRelease'];
    this.$scope = $scope;
    this.TemplatesService = TemplatesService;
    this.Backend = Backend;
    this.VariablesService = VariablesService;
    this.TasksService = TasksService;
    this.$q = $q;
    this.$timeout = $timeout;
    this.FoldersService = FoldersService;
    this.Ids = Ids;
    this._templates = [];
    this._riskProfiles = [];
    this._folders = []; // prevent tree-select component from rendering until this._folders is actually populated

    this.foldersReady = false;
    this._templateVariablesLoading = false;
    this._release = $scope.release;
    this._task = $scope.task;

    if (!this._task.releaseTags) {
      this._task.releaseTags = [];
    }

    this._findFolderById = function (folderId, folders, maxDepth) {
      return _this.FoldersService.findFolderInFolderTreeById(folderId, folders, maxDepth);
    };
  }

  createClass_default()(CreateReleaseDetailsController, [{
    key: "$onInit",
    value: function $onInit() {
      var _this2 = this;

      this._readOnly = !this.TasksService.canEditTaskConfigurationPropertiesAndTaskNotInProgress(this._release, this._task);
      this._selectedTemplateHasPermission = true;
      this._variableChanged = false;
      this._showTemplateConfirmation = false;
      this.hiddenVariables = false;
      this.hasTemplateViewPermission = true;
      this._selectedFolder = {
        variable: undefined,
        value: undefined
      };
      this.templateVariables = [];
      var templateIdIsFromVariable = this.VariablesService.containsOnlyVariable(this._task.templateId);
      var templateIdIsFromValue = !templateIdIsFromVariable;

      var folderIdIsFromVariable = this._idIsFromVariable(this._task.folderId);

      this.$scope.$watchCollection(function () {
        return _this2.$scope.allVariables;
      }, function (allVariables) {
        if (allVariables) {
          _this2.templateVariables = allVariables.filter(function (v) {
            return !v.key.startsWith('release.');
          }); // need allVariables loaded for this

          if (templateIdIsFromVariable) {
            _this2.setTemplateIdAsVariable(_this2._task.templateId, _this2._task.variables);
          }

          if (folderIdIsFromVariable) {
            _this2._setSelectedFolderFrom(_this2._task.folderId);
          }
        }
      });
      this._changeTemplateMsg = CHANGE_TEMPLATE_MSGS.default;
      this._folderConfirmationMsg = CHANGE_FOLDER_MSGS.default;
      this._folderDescription = FOLDER_DESC.default;
      this._newSelectedFolder = undefined;
      this._showFolderConfirmation = false;

      this._expandTask(this._task);

      this._fetchTemplates().then(function () {
        _this2._selectedTemplate = {
          variable: undefined,
          value: undefined
        };

        if (templateIdIsFromVariable) {
          _this2.setTemplateIdAsVariable(_this2._task.templateId, _this2._task.variables);
        } else {
          // find template by its (unique) id, disregarding the folder it's in:
          var id = _this2.Ids.getName(_this2.Ids.toDomainId(_this2._task.templateId));

          var templateWithTitle = id ? _.find(_this2._templates, function (t) {
            return t.id.endsWith(id);
          }) : undefined;

          if (id && templateWithTitle === undefined) {
            _this2._fetchTemplateById(id).then(function (template) {
              templateWithTitle = template;

              _this2._setTemplateDescription(templateWithTitle, id);
            });
          } else {
            _this2._setTemplateDescription(templateWithTitle, id);
          }
        }
      });

      this._fetchRiskProfiles().then(function () {
        var profile = _this2._getSelectedRiskProfile(_this2._riskProfiles);

        _this2._selectedRiskProfile = profile;
        _this2._task.riskProfileId = profile && profile.id;
      });

      if (!this._readOnly && templateIdIsFromValue) {
        this._fetchTemplateVariables(this._task.templateId).then(function (vars) {
          if (vars) {
            _this2._processVariables(vars);

            _this2._originalVariables = _.cloneDeep(vars);
          }
        });
      }

      this._createListHandlers(); // this one is used to indicate that user have clicked "inherit the value from template" icon or link


      this.resetCounter = {};
      var ifFolderIdEmptyAndTaskComplete = !_.get(this._task, 'folderId') && _.get(this._task, 'createdReleaseId') !== null;

      if (ifFolderIdEmptyAndTaskComplete) {
        this._task.folderId = this.Ids.getParentFolderIdFrom(this._task.createdReleaseId);
      }

      this.FoldersService.fetchUserVisibleFoldersTree(this._task.folderId).then(function (folders) {
        if (_.get(_this2._task, 'folderId') && !_this2._idIsFromVariable(_this2._task.folderId)) {
          var folderIdDomain = _this2.Ids.toDomainId(_this2._task.folderId);

          var folder = _this2._findFolderById(folderIdDomain, folders, 1000);

          if (folder) {
            _this2._setSelectedFolderFrom(folder, folder.enabled);
          }
        }

        _this2._folders = folders;
        _this2.foldersReady = true;

        _this2._fetchFolder();
      });
    }
  }, {
    key: "_fetchTemplates",
    value: function _fetchTemplates(matchTitle) {
      var _this3 = this;

      return this.TemplatesService.getAllIds(matchTitle).then(function (templates) {
        _this3._templates = _.reject(templates.data.cis, {
          id: _this3.release.id
        });
        return _this3._templates;
      });
    }
  }, {
    key: "_fetchTemplateById",
    value: function _fetchTemplateById(templateId) {
      return this.TemplatesService.getTemplateTitleById(templateId).then(function (template) {
        return _.head(template.data.cis, {
          id: templateId
        });
      }).catch(function (err) {
        if (err.status === http["a" /* httpCodes */].FORBIDDEN) {
          return undefined;
        }
      });
    }
  }, {
    key: "_setTemplateDescription",
    value: function _setTemplateDescription(templateWithTitle, id) {
      // if not found it might be either deleted or user has no permission.
      this.hasTemplateViewPermission = templateWithTitle ? true : false;
      var templateWithId = {
        id: this._task.templateId,
        title: id
      };
      this._selectedTemplate.value = templateWithTitle || templateWithId;
    }
  }, {
    key: "_updateFolderDescription",
    value: function _updateFolderDescription() {
      var _this4 = this;

      if (!this._task.folderId) {
        var setDescriptionIfFolderExists = function setDescriptionIfFolderExists(folderId) {
          _this4.FoldersService.getSilent(folderId).then(function (folder) {
            _this4._folderDescription = FOLDER_DESC.parentFolder.replace('${parentFolder}', folder.title);
          });
        };

        var parentFolder = this.Ids.getParentFolderIdFrom(this._task.id);
        var templateParentFolder = _.get(this._task, 'templateId') ? this.Ids.getParentFolderIdFrom(this._task.templateId) : null;

        if (templateParentFolder) {
          setDescriptionIfFolderExists("Applications/".concat(this.Ids.getName(templateParentFolder)));
        } else if (parentFolder) {
          setDescriptionIfFolderExists("Applications/".concat(this.Ids.getName(parentFolder)));
        } else {
          this._folderDescription = FOLDER_DESC.default;
        }
      } else {
        this._folderDescription = FOLDER_DESC.default;
      }
    }
  }, {
    key: "_fetchFolder",
    value: function _fetchFolder() {
      var _this5 = this;

      if (this._task.folderId) {
        if (this._idIsFromVariable(this._task.folderId)) {
          this._setSelectedFolderFrom(this._task.folderId);
        } else {
          this.FoldersService.getSilent(this._task.folderId).then(function (folder) {
            if (_this5.folderId !== folder.id) {
              _this5._setSelectedFolderFrom(folder.id, folder.enabled);
            }
          }).catch(function (err) {
            // for 403 'forbidden', we should keep the original folderId as it was likely set by someone else
            if (err.status === 403 || _this5._release.archived) {
              if (_this5._selectedFolder) {
                _this5._selectedFolder.enabled = false;
              } else {
                _this5._setSelectedFolderFrom(_this5._task.folderId, false);
              }
            }
          });
        }
      } else {
        this._updateFolderDescription();
      }
    }
  }, {
    key: "_fetchRiskProfiles",
    value: function _fetchRiskProfiles() {
      var _this6 = this;

      return this.Backend.get('api/v1/risks/profiles').then(function (response) {
        return _this6._riskProfiles = response.data;
      });
    }
  }, {
    key: "_fetchTemplateVariables",
    value: function _fetchTemplateVariables(templateId) {
      var _this7 = this;

      if (templateId) {
        this._templateVariablesLoading = true;
        return this.VariablesService.getReleaseVariables(templateId, {
          dontRedirectWhenForbidden: true,
          hideAlertOnCodes: [403, 404, 500]
        }).then(function (r) {
          _this7.hiddenVariables = false;
          _this7._templateVariablesLoading = false;
          return r.data;
        }).catch(function (err) {
          if ([403].includes(err.status)) {
            _this7._selectedTemplateHasPermission = false;
            _this7._changeTemplateMsg = CHANGE_TEMPLATE_MSGS.noPermission;
            _this7.hiddenVariables = true;
            _this7._templateVariablesLoading = false;
          }
        });
      }

      var deferred = this.$q.defer();
      deferred.resolve([]);
      return deferred.promise;
    }
  }, {
    key: "_processVariables",
    value: function _processVariables(vars) {
      this._expandTask(this._task);

      var templateVariables = vars;
      var taskVariables = this.variables;
      this.variables = _(templateVariables).filter(function (templateVariable) {
        return !!templateVariable.showOnReleaseStart;
      }).map(function (templateVariable) {
        templateVariable.id = '';
        templateVariable.inherited = true;

        var taskVariable = _.find(taskVariables, {
          key: templateVariable.key,
          type: templateVariable.type
        });

        var omitted = ['valueProvider', 'requiresValue', 'description', 'label'];

        if (taskVariable && taskVariable.inherited) {
          omitted.push('value');
        }

        return create_release_details_controller_objectSpread(create_release_details_controller_objectSpread({}, templateVariable), _.omit(taskVariable, omitted));
      }).value();
      return this.variables;
    }
  }, {
    key: "_expandTask",
    value: function _expandTask(task) {
      var variableMapping = _.mapKeys(task.variableMapping, function (value, key) {
        return _.includes(key, 'templateVariables') ? _.trim(key, '.value') : key;
      });

      this._expandedTask = this.VariablesService.expandProperties(_.mapKeys(task, function (value, key) {
        return key.replace('variables', 'templateVariables');
      }), variableMapping, this._propertiesWithVars);
      this._expandedTask.createdReleaseId = {
        variable: task.createdReleaseId,
        value: null
      };
    }
  }, {
    key: "_updateTaskFromExpandedTask",
    value: function _updateTaskFromExpandedTask(task, expandedTask) {
      var transformTemplateVarsToTaskVars = function transformTemplateVarsToTaskVars(variable) {
        var newTaskVariable = _.omit(variable, '$token');

        if (_.has(variable, 'valueProvider')) {
          newTaskVariable = create_release_details_controller_objectSpread(create_release_details_controller_objectSpread({}, newTaskVariable), {}, {
            'valueProvider': variable.valueProvider.id
          });
        }

        return newTaskVariable;
      };

      var _this$VariablesServic = this.VariablesService.collapseProperties(expandedTask, this._propertiesWithVars),
          _this$VariablesServic2 = slicedToArray_default()(_this$VariablesServic, 2),
          collapsedTask = _this$VariablesServic2[0],
          variableMapping = _this$VariablesServic2[1];

      task.variables = this.hiddenVariables ? this._task.variables : collapsedTask.templateVariables.map(transformTemplateVarsToTaskVars);
      task.startRelease = collapsedTask.startRelease;
      task.variableMapping = _.mapKeys(variableMapping, function (value, key) {
        return _.includes(key, 'templateVariables') ? key + '.value' : key;
      });
      task.createdReleaseId = this._expandedTask.createdReleaseId.variable;
    }
  }, {
    key: "_createListHandlers",
    value: function _createListHandlers() {
      var _this8 = this;

      var templateAutocompleteHandler = function templateAutocompleteHandler(term) {
        var deferred = _this8.$q.defer();

        var result = _this8._fetchTemplates(term);

        deferred.resolve(result);
        return deferred.promise;
      };

      var riskAutocompleteHandler = function riskAutocompleteHandler(items, term) {
        var deferred = _this8.$q.defer();

        var candidates = _.filter(items, function (item) {
          return item.title.includes(term);
        });

        deferred.resolve(candidates);
        return deferred.promise;
      };

      this._templateListHandlers = {
        addCandidates: function addCandidates(metadata, options) {
          return templateAutocompleteHandler(options.term);
        },
        onSelect: function onSelect(newTemplate) {
          return _this8._onTemplateValueSelect(newTemplate);
        },
        removeElement: function removeElement() {
          return _this8._onTemplateValueRemove();
        }
      };
      this._riskProfileListHandlers = {
        addCandidates: function addCandidates(metadata, options) {
          return riskAutocompleteHandler(_this8._riskProfiles, options.term);
        }
      };
    }
  }, {
    key: "_getSelectedRiskProfile",
    value: function _getSelectedRiskProfile(riskProfiles) {
      var selected;

      if (this._task.riskProfileId) {
        selected = _.find(riskProfiles, {
          id: this._task.riskProfileId
        });

        if (selected) {
          return selected;
        }
      }

      var syntheticValue = this._release.syntheticProperties && this._release.syntheticProperties.riskProfile;

      if (syntheticValue) {
        selected = _.find(riskProfiles, {
          id: syntheticValue
        });

        if (selected) {
          return selected;
        }
      }

      return _.find(riskProfiles, {
        id: DEFAULT_RISK_PROFILE_ID
      });
    }
  }, {
    key: "updateReleaseTags",
    value: function updateReleaseTags(tags) {
      this.releaseTags = tags;
      this.saveTask();
    }
  }, {
    key: "saveTask",
    value: function saveTask() {
      var _this9 = this;

      this._variableChanged = false;

      this._updateTaskFromExpandedTask(this._task, this._expandedTask);

      return this.TasksService.updateTask(this._task).then(function (resp) {
        var savedTask = resp.data; // update task variables

        _this9._task.variables = savedTask.variables; // update expanded task variables and set them to non-initial state

        savedTask.variables.forEach(function (updatedVariable) {
          return _.assign(_.find(_this9.variables, {
            key: updatedVariable.key
          }), _.omit(updatedVariable, 'valueProvider'));
        });
      });
    }
  }, {
    key: "createVariable",
    value: function createVariable(name, variableType, createdCallback, isRequired) {
      if (isRequired) {
        this.$scope.createRequiredVariable(this._task, name, variableType, createdCallback);
      } else {
        this.$scope.createOptionalVariable(this._task, name, variableType, createdCallback);
      }
    }
  }, {
    key: "connectToInheritDefaultValue",
    value: function connectToInheritDefaultValue(variable) {
      if (variable) {
        var taskVariable = _.find(this.variables, {
          key: variable.key,
          type: variable.type
        });

        if (taskVariable) {
          taskVariable.inherited = true;

          var orig = this._originalVariables.find(function (o) {
            return o.key === variable.key;
          });

          if (orig) {
            taskVariable.value = orig.value;
          } else {
            taskVariable.value = undefined;
          }

          this.resetCounter[taskVariable.key] = (this.resetCounter[taskVariable.key] || 0) + 1;
          this.saveTask();
        }
      }
    }
  }, {
    key: "isFromVariable",
    value: function isFromVariable(templateOrFolder) {
      return angular.isDefined(templateOrFolder) && this._idIsFromVariable(templateOrFolder.variable);
    }
  }, {
    key: "_idIsFromVariable",
    value: function _idIsFromVariable(id) {
      return angular.isDefined(id) && this.VariablesService.containsOnlyVariable(id);
    }
  }, {
    key: "_isTemplateFromValue",
    value: function _isTemplateFromValue(template) {
      return angular.isDefined(template) && angular.isDefined(template.value) && template.value !== null;
    }
  }, {
    key: "getReleaseIdFromVariable",
    value: function getReleaseIdFromVariable(variableName) {
      var variable = this.allVariables.find(function (variable) {
        return variable.variableName === variableName;
      });

      if (angular.isDefined(variable) && angular.isDefined(variable.value) && variable.value.includes('Release')) {
        return this.Ids.toInternalId(variable.value);
      }

      return undefined;
    }
  }, {
    key: "getFolderIdFromVariable",
    value: function getFolderIdFromVariable(variableName) {
      var variable = this.allVariables.find(function (variable) {
        return variable.variableName === variableName;
      });

      if (angular.isDefined(variable) && angular.isDefined(variable.value) && variable.value.includes('Folder')) {
        return this.Ids.toDomainId(variable.value);
      }

      return undefined;
    }
  }, {
    key: "setTemplateIdAsVariable",
    value: function setTemplateIdAsVariable(variableName, variables) {
      var _this10 = this;

      var templateId = this.getReleaseIdFromVariable(variableName);

      if (angular.isDefined(templateId)) {
        this._fetchTemplateVariables(templateId).then(function (vars) {
          _this10._processVariables(vars);

          _this10.saveTask();

          _this10._originalVariables = _.cloneDeep(vars);
        });
      } else {
        this._processVariables(variables);

        this.saveTask();
        this._originalVariables = _.cloneDeep(variables);
      }

      this.selectedTemplate = {
        variable: variableName,
        value: undefined
      };
    }
  }, {
    key: "_onTemplateValueSelect",
    value: function _onTemplateValueSelect(newValue) {
      this._newSelectedTemplate = {
        value: newValue,
        variable: undefined
      };

      if (this._task.templateId) {
        this.enableTemplateConfirmation();
      } else {
        this.confirmTemplateChange(false);
      }
    }
  }, {
    key: "onTemplateVariableChange",
    value: function onTemplateVariableChange() {
      if (this.isFromVariable(this._selectedTemplate)) {
        this.confirmTemplateChange(true);
      } else {
        //Switcher/Remove event
        this._resetAllTemplateValues();
      }
    }
  }, {
    key: "_onTemplateValueRemove",
    value: function _onTemplateValueRemove() {
      var _this11 = this;

      var currentSelectedValue = this._selectedTemplate.value;
      this.$timeout(function () {
        return _this11.selectedTemplate = {
          value: currentSelectedValue,
          variable: undefined
        };
      });
      this.enableTemplateConfirmation();
    }
  }, {
    key: "_resetAllTemplateValues",
    value: function _resetAllTemplateValues() {
      this._oldSelectedTemplate = {
        value: undefined,
        variable: undefined
      };
      this.selectedTemplate = {
        value: undefined,
        variable: undefined
      };
      this._newSelectedTemplate = {
        value: undefined,
        variable: undefined
      };
      this.confirmTemplateChange(true);
    }
  }, {
    key: "_getNewTemplateId",
    value: function _getNewTemplateId() {
      if (this.isFromVariable(this._newSelectedTemplate)) {
        return this._newSelectedTemplate.variable;
      } else if (this._isTemplateFromValue(this._newSelectedTemplate)) {
        return this._newSelectedTemplate.value.id;
      } else {
        return null;
      }
    }
  }, {
    key: "_getNewTemplateTitle",
    value: function _getNewTemplateTitle() {
      if (this.isFromVariable(this._newSelectedTemplate)) {
        return this._newSelectedTemplate.variable;
      } else if (this._isTemplateFromValue(this._newSelectedTemplate)) {
        return this._newSelectedTemplate.value.title;
      } else {
        return null;
      }
    }
  }, {
    key: "addNewVariable",
    value: function addNewVariable() {
      this.saveTask();
    }
  }, {
    key: "removeVariable",
    value: function removeVariable() {
      this.saveTask();
    }
  }, {
    key: "confirmTemplateChange",
    value: function confirmTemplateChange(fromVariable) {
      var _this12 = this;

      this._task.templateId = fromVariable ? this._selectedTemplate.variable : this._getNewTemplateId();

      if (fromVariable) {
        this.setTemplateIdAsVariable(this._task.templateId, []);
      } else {
        this._fetchTemplateVariables(this._task.templateId).then(function (vars) {
          _this12._processVariables(vars);

          _this12.saveTask();

          _this12._originalVariables = _.cloneDeep(vars);
        });
      }

      this._oldSelectedTemplate = fromVariable ? angular.copy(this._selectedTemplate) : this._newSelectedTemplate;
      this.selectedTemplate = fromVariable ? this._selectedTemplate : this._newSelectedTemplate;
      this._showTemplateConfirmation = false;
      this._changeTemplateMsg = CHANGE_TEMPLATE_MSGS.default;
      this._newSelectedTemplate = {
        value: undefined,
        variable: undefined
      };

      if (!fromVariable) {
        this._updateFolderDescription();
      }

      this.hasTemplateViewPermission = true;
      this.hiddenVariables = false;
    }
  }, {
    key: "cancelTemplateChange",
    value: function cancelTemplateChange() {
      var _this13 = this;

      var isTemplateFromBackend = false;

      if (this._isTemplateRestoreFromCurrent() || !this._oldSelectedTemplate.value.id) {
        this._oldSelectedTemplate = {
          value: _.find(this._templates, {
            id: this._task.templateId
          })
        };

        if (this._oldSelectedTemplate.value === undefined) {
          isTemplateFromBackend = true;
          var templateId = this.Ids.getName(this.Ids.toDomainId(this._task.templateId));

          this._fetchTemplateById(templateId).then(function (template) {
            _this13._oldSelectedTemplate = {
              value: template
            };

            _this13._setSelectedTemplate();
          });
        }
      }

      if (!isTemplateFromBackend) {
        this._setSelectedTemplate();
      }
    }
  }, {
    key: "_setSelectedTemplate",
    value: function _setSelectedTemplate() {
      if (!!this._oldSelectedTemplate.value) {
        this._selectedTemplate = angular.copy(this._oldSelectedTemplate);
      }

      this._newSelectedTemplate = undefined;
      this._showTemplateConfirmation = false;
    }
  }, {
    key: "_isTemplateRestoreFromCurrent",
    value: function _isTemplateRestoreFromCurrent() {
      return (!this._oldSelectedTemplate || !this._oldSelectedTemplate.value) && this._task.templateId;
    }
  }, {
    key: "enableTemplateConfirmation",
    value: function enableTemplateConfirmation() {
      var newMessage;

      if (this._variableChanged && this._selectedTemplateHasPermission) {
        newMessage = CHANGE_TEMPLATE_MSGS.variableChanged;
      } else if (this._variableChanged && !this._selectedTemplateHasPermission) {
        newMessage = CHANGE_TEMPLATE_MSGS.both;
      } else if (!this._selectedTemplateHasPermission) {
        newMessage = CHANGE_TEMPLATE_MSGS.noPermission;
      } else {
        newMessage = CHANGE_TEMPLATE_MSGS.default;
      }

      if (this._variableChanged) {
        this._changeTemplateMsg = this._getNewTemplateTitle() !== null ? newMessage.replace('${targetTemplate}', this._getNewTemplateTitle()) : CHANGE_TEMPLATE_MSGS.blankVarChanged;
      } else {
        this._changeTemplateMsg = this._getNewTemplateTitle() !== null ? newMessage.replace('${targetTemplate}', this._getNewTemplateTitle()) : CHANGE_TEMPLATE_MSGS.blank;
      }

      this._showTemplateConfirmation = true;
    }
  }, {
    key: "onVariableChanged",
    value: function onVariableChanged(variable) {
      var _this14 = this;

      var orig = this._originalVariables.find(function (o) {
        return o.key === variable.key;
      });

      if (orig && orig.value !== variable.value) {
        variable.inherited = false;
      }

      if (variable.value && variable.type === 'xlrelease.DateVariable') {
        variable.value = moment(variable.value).format();
      }

      this.saveTask().then(function () {
        if (orig && orig.value !== variable.value) {
          _this14._variableChanged = true;
        }
      });
    }
  }, {
    key: "_setFolderInfoOnFolderChange",
    value: function _setFolderInfoOnFolderChange() {
      if (!this._idIsFromVariable(this._task.folderId)) {
        this._updateFolderDescription();
      }
    }
  }, {
    key: "confirmFolderChange",
    value: function confirmFolderChange() {
      this._setSelectedFolderFrom(this._newSelectedFolder);

      this.folderId = this._selectedFolder.id;
      this._showFolderConfirmation = false;

      this._setFolderInfoOnFolderChange();
    }
  }, {
    key: "cancelFolderChange",
    value: function cancelFolderChange() {
      this._newSelectedFolder = null;
      this._showFolderConfirmation = false;
      this.folderId = this._selectedFolder.id;
    }
  }, {
    key: "onFolderVariableChange",
    value: function onFolderVariableChange() {
      if (this.isFromVariable(this._selectedFolder)) {
        this._setSelectedFolderFrom(this._selectedFolder.variable);

        this.folderId = this._selectedFolder.variable;
      } else {
        this._resetAllFolderValues();
      }

      this._updateFolderDescription();
    }
  }, {
    key: "_resetAllFolderValues",
    value: function _resetAllFolderValues() {
      this._setSelectedFolderFrom(this._selectedFolder.variable);

      this.folderId = this._selectedFolder.variable;
      this._newSelectedFolder = this._selectedFolder;
    }
  }, {
    key: "_setSelectedFolderFrom",
    value: function _setSelectedFolderFrom(folder) {
      var enabled = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
      var id = _.get(folder, 'id') ? folder.id : folder;

      if (_.isString(id)) {
        this._selectedFolder = this._idIsFromVariable(id) ? {
          id: undefined,
          value: undefined,
          variable: id,
          title: id,
          enabled: this.getFolderIdFromVariable(id) ? !!this._findFolderById(this.getFolderIdFromVariable(id), this.folders, 1000) : true
        } : {
          id: id,
          value: id,
          variable: undefined,
          title: folder.title || this.Ids.getName(id),
          enabled: enabled
        };
      } else {
        this._selectedFolder = {
          id: undefined,
          value: undefined,
          variable: undefined
        };
      }
    }
  }, {
    key: "newReleaseTitle",
    get: function get() {
      return this._task.newReleaseTitle;
    },
    set: function set(title) {
      this._task.newReleaseTitle = title;
      this.saveTask();
    }
  }, {
    key: "selectedTemplate",
    get: function get() {
      return this._selectedTemplate;
    },
    set: function set(template) {
      this._selectedTemplate = template;
    }
  }, {
    key: "selectedFolder",
    get: function get() {
      return this._selectedFolder;
    }
  }, {
    key: "changeTemplateErrorMsg",
    get: function get() {
      return this._changeTemplateMsg;
    }
  }, {
    key: "folderId",
    get: function get() {
      return this._task.folderId;
    },
    set: function set(folderId) {
      this._task.folderId = folderId;
      this.saveTask();
    }
  }, {
    key: "folderTitle",
    get: function get() {
      return this._selectedFolder.title;
    },
    set: function set(folderTitle) {
      this._selectedFolder.title = folderTitle;
    }
  }, {
    key: "hiddenFolder",
    get: function get() {
      if (this._selectedFolder && this._selectedFolder.id || this.isFromVariable(this.selectedFolder)) {
        return !this._selectedFolder.enabled;
      } else {
        return false;
      }
    }
  }, {
    key: "selectedRiskProfile",
    get: function get() {
      return this._selectedRiskProfile;
    },
    set: function set(profile) {
      this._selectedRiskProfile = profile;
      this._task.riskProfileId = profile && profile.id;
      this.saveTask();
    }
  }, {
    key: "variables",
    get: function get() {
      return this._templateVariablesLoading ? EMPTY_VARIABLES : this._expandedTask.templateVariables;
    },
    set: function set(vars) {
      this._expandedTask.templateVariables = vars;
    }
  }, {
    key: "startRelease",
    get: function get() {
      return this._expandedTask.startRelease;
    },
    set: function set(startRelease) {
      this._expandedTask.startRelease = startRelease;
    }
  }, {
    key: "createdReleaseId",
    get: function get() {
      return this._expandedTask.createdReleaseId;
    },
    set: function set(createdReleaseId) {
      this._expandedTask.createdReleaseId = createdReleaseId;
    }
  }, {
    key: "readOnly",
    get: function get() {
      return this._readOnly;
    }
  }, {
    key: "readOnlyOrLocked",
    get: function get() {
      return this.readOnly || this.TasksService.isLocked(this._task);
    }
  }, {
    key: "showTemplateConfirmation",
    get: function get() {
      return this._showTemplateConfirmation;
    }
  }, {
    key: "showFolderConfirmation",
    get: function get() {
      return this._showFolderConfirmation;
    }
  }, {
    key: "folderConfirmationMsg",
    get: function get() {
      return this._folderConfirmationMsg;
    }
  }, {
    key: "folderDescription",
    get: function get() {
      return this._folderDescription;
    }
  }, {
    key: "release",
    get: function get() {
      return this._release;
    }
  }, {
    key: "task",
    get: function get() {
      return this._task;
    }
  }, {
    key: "releaseVariables",
    get: function get() {
      return this._release.variables;
    }
  }, {
    key: "templateListHandlers",
    get: function get() {
      return this._templateListHandlers;
    }
  }, {
    key: "riskProfileListHandlers",
    get: function get() {
      return this._riskProfileListHandlers;
    }
  }, {
    key: "allVariables",
    get: function get() {
      return this.$scope.allVariables;
    }
  }, {
    key: "editableReleaseVariables",
    get: function get() {
      return this.$scope.editableReleaseVariables;
    }
  }, {
    key: "templates",
    get: function get() {
      return this._templates;
    }
  }, {
    key: "riskProfiles",
    get: function get() {
      return this._riskProfiles;
    }
  }, {
    key: "releaseTags",
    get: function get() {
      return this._task.releaseTags;
    },
    set: function set(value) {
      this._task.releaseTags = value;
    }
  }, {
    key: "folders",
    get: function get() {
      return this._folders;
    }
  }]);

  return CreateReleaseDetailsController;
}();

defineProperty_default()(create_release_details_controller_CreateReleaseDetailsController, "$inject", ['$scope', '$q', '$timeout', 'TemplatesService', 'Backend', 'VariablesService', 'TasksService', 'FoldersService', 'Ids']);

angular.module('xlrelease').controller('xlrelease.CreateReleaseDetailsController', create_release_details_controller_CreateReleaseDetailsController);
// CONCATENATED MODULE: ./core/xlr-ui/app/js/tasks/dependencies-service.js





(function () {
  var DependenciesService = /*#__PURE__*/function () {
    function DependenciesService(Backend, $q, ReleasesStatusService) {
      classCallCheck_default()(this, DependenciesService);

      this.backend = Backend;
      this.$q = $q;
      this.releasesStatusService = ReleasesStatusService;
      this.cachedReleaseTreePromise = null;
      this.cachedReleaseId = null;
    }

    createClass_default()(DependenciesService, [{
      key: "getReleaseTree",
      value: function getReleaseTree(release) {
        if (this.releasesStatusService.isReleaseCompleted(release)) {
          var deferred = this.$q.defer();
          deferred.resolve(null);
          this.cachedReleaseTreePromise = deferred.promise;
        } else if (!this.cachedReleaseTreePromise || this.cachedReleaseId !== release.id) {
          this.cachedReleaseTreePromise = this.backend.get('dependencies/' + release.id + '/tree').then(function (result) {
            return result.data;
          });
        }

        this.cachedReleaseId = release.id;
        return this.cachedReleaseTreePromise;
      }
    }, {
      key: "clearCache",
      value: function clearCache() {
        this.cachedReleaseId = null;
        this.cachedReleaseTreePromise = null;
      }
    }]);

    return DependenciesService;
  }();

  DependenciesService.$inject = ['Backend', '$q', 'ReleasesStatusService'];
  angular.module('xlrelease').service('DependenciesService', DependenciesService);
})();
// EXTERNAL MODULE: ./core/xlr-ui/app/js/tasks/display-with-separators.js
var display_with_separators = __webpack_require__(1415);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/tasks/gate/gate-details-controller.js
var gate_details_controller = __webpack_require__(1416);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/tasks/gate/gate-service.js



(function () {
  'use strict';

  var GateService = /*#__PURE__*/function () {
    function GateService($q, Backend) {
      classCallCheck_default()(this, GateService);

      this._$q = $q;
      this._Backend = Backend;
      this._dependencyTargetCandidatesCache = new Map();
    }

    createClass_default()(GateService, [{
      key: "fetchDependencyTargetCandidates",
      value: function fetchDependencyTargetCandidates(taskId) {
        var _this = this;

        return this._fetchData(function () {
          return _this._Backend.get("gates/".concat(taskId, "/dependency-target-candidates"));
        }, 'DEPENDENCY_TARGET_CANDIDATES');
      }
    }, {
      key: "fetchDependencyTargetCandidate",
      value: function fetchDependencyTargetCandidate(taskId, releaseId) {
        var _this2 = this;

        return this._fetchData(function () {
          return _this2._Backend.get("gates/".concat(taskId, "/dependency-target-candidates/").concat(releaseId));
        }, releaseId);
      }
    }, {
      key: "clearDependencyTargetCache",
      value: function clearDependencyTargetCache() {
        this._dependencyTargetCandidatesCache.clear();
      }
    }, {
      key: "getDependencies",
      value: function getDependencies(taskId) {
        return this._Backend.get("gates/".concat(taskId, "/dependencies")).then(function (response) {
          return response.data;
        });
      }
    }, {
      key: "getDependenciesTargetStatuses",
      value: function getDependenciesTargetStatuses(taskId) {
        return this._Backend.get("gates/".concat(taskId, "/dependency-target-statuses")).then(function (response) {
          return response.data;
        });
      } ////

    }, {
      key: "_fetchData",
      value: function _fetchData(call, cacheKey) {
        var _this3 = this;

        var deferred = this._$q.defer();

        if (this._dependencyTargetCandidatesCache.has(cacheKey)) {
          deferred.resolve(this._dependencyTargetCandidatesCache.get(cacheKey));
        } else {
          call().then(function (response) {
            var data = response.data;

            _this3._dependencyTargetCandidatesCache.set(cacheKey, data);

            deferred.resolve(data);
          });
        }

        return deferred.promise;
      }
    }]);

    return GateService;
  }();

  GateService.$inject = ['$q', 'Backend'];
  angular.module('xlrelease').service('GateService', GateService);
})();
// CONCATENATED MODULE: ./core/xlr-ui/app/js/tasks/quick-task-generator-directive.js


function quick_task_generator_directive_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function quick_task_generator_directive_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { quick_task_generator_directive_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { quick_task_generator_directive_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

angular.module('xlrelease').directive('quickTaskGenerator', ['TaskDefinitionsService', function (TaskDefinitionsService) {
  function enableForm(scope) {
    scope.$apply(function () {
      scope.showForm = true;
    });
  }

  function submitTask(scope) {
    scope.$apply(function () {
      if (angular.isDefined(scope.title) && scope.title !== null && scope.title !== '') {
        var taskForm = {
          title: scope.title,
          taskType: scope.taskType
        };
        scope.addTask({
          taskForm: taskForm
        });
        scope.title = '';
      }
    });
  }

  function disableForm(scope) {
    scope.$apply(function () {
      scope.showForm = false;
      scope.title = '';
    });
  }

  return {
    templateUrl: 'partials/tasks/quick-task-generator.html',
    scope: {
      'addTask': '&',
      'taskDefinitions': '='
    },
    link: function link(scope, element) {
      scope.showForm = false;
      scope.title = '';

      scope.onSelect = function (item) {
        if (item) {
          scope.taskTypeName = getTaskTypeName(item.group, item.text);
          scope.taskType = item.id;
        }
      };

      scope.$watch('taskDefinitions', function (taskDefinitions) {
        if (!taskDefinitions) return;
        var groupedTaskDefs = TaskDefinitionsService.groupTaskDefinitions(taskDefinitions);

        _.forEach(groupedTaskDefs.groups, function (value, key) {
          _.remove(value, function (v) {
            return !v.isAllowed;
          });

          var founded = _.find(value, {
            isAllowed: true
          });

          if (!founded) {
            delete groupedTaskDefs.groups[key];
          }
        });

        scope.groupedTaskDefinitions = getGroupedTasks(groupedTaskDefs.groups);
        var defaultValue = groupedTaskDefs.defaultValue;
        scope.taskType = defaultValue && defaultValue.typeName;
        scope.taskTypeName = defaultValue ? getTaskTypeName(defaultValue.displayGroup, defaultValue.displayName) : null;

        if (!defaultValue) {
          scope.taskGeneratorDisabled = true;
        }
      });
      var input = element.find('input');
      element.find('.add-task').bind('click', function () {
        enableForm(scope);
        input.focus();
      });
      element.find('.add').bind('click', function () {
        submitTask(scope);
        input.focus();
      });
      element.find('.cancel').bind('click', function () {
        disableForm(scope);
      });
      input.bind('keyup', function (e) {
        if (e.which === 27) {
          // on escape
          disableForm(scope);
        }

        if (e.which === 13) {
          // on enter
          submitTask(scope);
          input.focus();
        }
      });
    }
  };
}]);
var topGroups = ['Core', 'Patterns & Deliveries', 'Script', 'Remote Script', 'Webhook'];

var getGroupedTasks = _.flow([convert, sort, addDivider(topGroups.length), applyItemTypes]);

function getTaskTypeName(groupName, taskName) {
  return "".concat(groupName, " > ").concat(taskName);
}

function addDivider(position) {
  return function (groupedTasks) {
    groupedTasks.splice(position, 0, {
      divider: true
    });
    return groupedTasks;
  };
}

function applyItemTypes(groupedTasks) {
  return groupedTasks.map(function (item) {
    return quick_task_generator_directive_objectSpread(quick_task_generator_directive_objectSpread({}, item), {}, {
      items: item.items && applyItemTypes(item.items),
      type: getItemType(item)
    });
  });
}

function getItemType(item) {
  if (item.items) {
    return 'submenu';
  }

  if (item.divider) {
    return 'divider';
  }

  return 'common';
}

function convert(groupedTasks) {
  return Object.keys(groupedTasks).map(function (key) {
    var tasks = groupedTasks[key];
    return {
      id: key,
      text: key,
      items: tasks.map(function (task) {
        return {
          id: task.typeName,
          text: task.displayName,
          group: key
        };
      })
    };
  });
}

function sort(groupedTasks) {
  return groupedTasks.sort(byGroupName(topGroups)).map(function (group) {
    return quick_task_generator_directive_objectSpread(quick_task_generator_directive_objectSpread({}, group), {}, {
      items: group.items.sort(byTaskType)
    });
  });
}

function byGroupName(topGroups) {
  return function (a, b) {
    var aIdx = topGroups.indexOf(a.text);
    var bIdx = topGroups.indexOf(b.text);

    if (aIdx > -1 && bIdx > -1) {
      return aIdx - bIdx;
    }

    if (aIdx > -1 && bIdx === -1) {
      return -1;
    }

    if (aIdx === -1 && bIdx > -1) {
      return 1;
    }

    if (a.text < b.text) {
      return -1;
    }

    if (a.text > b.text) {
      return 1;
    }

    return 0;
  };
}

function byTaskType(a, b) {
  if (a.text < b.text) return -1;
  if (a.text > b.text) return 1;
  return 0;
}
// EXTERNAL MODULE: ./core/xlr-ui/app/js/tasks/scheduled-start-date-tooltip-directive.js
var scheduled_start_date_tooltip_directive = __webpack_require__(1417);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/util/ids.js
var ids = __webpack_require__(52);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/tasks/task-context-menu-service.js


var task_context_menu_service_Ids = Object(ids["a" /* default */])();
angular.module('xlrelease').factory('TaskContextMenuService', ['Authenticator', 'TasksService', 'ReleasesService', '$state', '$location', 'ViewStorage', function (Authenticator, TasksService, ReleasesService, $state, $location, ViewStorage) {
  function controlFlowActions(task, release, withinBlackout) {
    var items = [];

    if (!TasksService.isTaskReadOnly(task)) {
      items.push({
        text: 'Assign to me',
        disabled: !TasksService.canAssignTaskToCurrentUser(task, release),
        click: function click() {
          return TasksService.assignToCurrentUser(task);
        }
      });
    }

    if (TasksService.isTaskPending(task)) {
      items.push({
        text: 'Start now',
        disabled: !TasksService.canStartTask(release, task) || task.delayDuringBlackout && withinBlackout && !TasksService.canEditBlackout(release, task),
        modal: 'partials/tasks/start-task-modal.html'
      });
    }

    if (TasksService.isTaskInProgress(task) && !TasksService.isAutomated(task) && !TasksService.isTaskGroup(task)) {
      items = items.concat([{
        text: 'Complete',
        disabled: !TasksService.canCompleteTask(release, task),
        modal: 'partials/tasks/complete-task-modal.html'
      }, {
        text: 'Skip',
        disabled: !TasksService.canSkipTask(release, task),
        modal: 'partials/tasks/skip-task-modal.html'
      }, {
        text: 'Fail',
        disabled: !TasksService.canFailTask(release, task),
        modal: 'partials/tasks/fail-task-modal.html'
      }]);
    }

    if (TasksService.isInProgressScriptTask(task) || TasksService.isQueuedScriptTask(task) || TasksService.isTaskPreconditionInProgress(task) || TasksService.isTaskFailureHandlerInProgress(task) || TasksService.isTaskAbortScriptInProgress(task) || TasksService.isTaskFacetInProgress(task)) {
      items.push({
        text: 'Abort',
        disabled: !TasksService.canAbortTask(release, task),
        modal: 'partials/tasks/abort-task-modal.html'
      });
    }

    if (TasksService.isTaskFailed(task) && (!TasksService.isTaskGroup(task) || TasksService.isTaskGroupSkippableOrRetriable(task))) {
      items.push({
        text: 'Skip',
        disabled: !TasksService.canSkipTask(release, task),
        modal: 'partials/tasks/skip-task-modal.html'
      });

      if (!TasksService.isUnknownTask(task)) {
        items.push({
          text: 'Retry',
          disabled: !TasksService.canRetryTask(release, task),
          modal: 'partials/tasks/retry-task-modal.html'
        });
      }
    }

    if (TasksService.isTaskPlanned(task) && !TasksService.isTaskGroup(task) && (ReleasesService.isReleaseInProgress(release) || ReleasesService.isReleaseFailed(release) || ReleasesService.isReleaseFailing(release) || ReleasesService.isReleasePaused(release))) {
      if (!TasksService.isAutomated(task)) {
        items.push({
          text: 'Complete',
          disabled: !TasksService.canCompleteTask(release, task),
          modal: 'partials/tasks/complete-task-modal.html'
        });
      }

      items.push({
        text: 'Skip',
        disabled: !TasksService.canSkipTask(release, task),
        modal: 'partials/tasks/skip-task-modal.html'
      });
    }

    if ((ReleasesService.isReleaseInProgress(release) || ReleasesService.isReleaseFailed(release) || ReleasesService.isReleaseFailing(release) || ReleasesService.isReleasePaused(release)) && TasksService.isTaskDoneInAdvance(task) && !TasksService.isTaskGroup(task)) {
      items.push({
        text: 'Reopen',
        disabled: !TasksService.canReopenTask(release, task),
        modal: 'partials/tasks/reopen-task-modal.html'
      });
    }

    return items;
  }

  function lockActions(task, release) {
    var items = [];

    var setTaskLock = function setTaskLock(lock) {
      var flatten = function flatten(t) {
        return [t].concat(toConsumableArray_default()(TasksService.isTaskGroup(t) ? _.flatMap(t.tasks, flatten) : []));
      };

      flatten(task).forEach(function (t) {
        return t.locked = lock;
      });
    };

    if (!task.locked) {
      items.push({
        text: 'Lock',
        disabled: !Authenticator.hasLockTaskPermission(release),
        click: function click() {
          return TasksService.lock(task.id).then(function () {
            setTaskLock(true);
          });
        }
      });
    } else {
      items.push({
        text: 'Unlock',
        disabled: !Authenticator.hasLockTaskPermission(release),
        click: function click() {
          return TasksService.unlock(task.id).then(function () {
            setTaskLock(false);
          });
        }
      });
    }

    if (items.length) {
      items.push({
        divider: true
      });
    }

    return items;
  }

  function editActions(task, release, container) {
    return [{
      text: 'Duplicate',
      disabled: !TasksService.isDuplicateEnabled(task, release, container),
      click: function click() {
        if (TasksService.isDuplicateEnabled(task, release, container)) {
          return TasksService.duplicateTask(release, task, container);
        }
      }
    }, {
      text: 'Delete',
      disabled: !TasksService.isRemoveEnabled(task, release, container),
      modal: 'partials/releases/delete-task-modal.html',
      cssClass: 'remove-task-button'
    }];
  }

  function changeTypeSubmenu(task, release, container, groupedTaskDefinitions) {
    if (TasksService.isTaskPlanned(task) && !TasksService.isTaskGroup(task) && Authenticator.hasEditTaskPermission(release)) {
      var mapTaskToType = function mapTaskToType(taskDefinition) {
        var isSameType = TasksService.isOfType(task, taskDefinition);
        return {
          templateUrl: 'partials/tasks/change-type-submenu-item.html',
          isSameType: isSameType,
          taskDefinition: taskDefinition
        };
      };

      var topGroups = ['Core', 'Delivery', 'Script', 'Remote Script', 'Webhook'];

      var types = _.map(groupedTaskDefinitions, function (taskDefinitions, group) {
        return {
          text: group,
          items: taskDefinitions.filter(function (taskDefinition) {
            return taskDefinition.isAllowed;
          }).sort(function (a, b) {
            var aDisplayName = a.displayName.toUpperCase();
            var bDisplayName = b.displayName.toUpperCase();

            if (aDisplayName < bDisplayName) {
              return -1;
            }

            if (aDisplayName > bDisplayName) {
              return 1;
            }

            return 0;
          }).map(function (taskDefinition) {
            return mapTaskToType(taskDefinition);
          })
        };
      }).sort(function (a, b) {
        var aIdx = topGroups.indexOf(a.text);
        var bIdx = topGroups.indexOf(b.text);

        if (aIdx > -1 && bIdx > -1) {
          return aIdx - bIdx;
        }

        if (aIdx > -1 && bIdx === -1) {
          return -1;
        }

        if (aIdx === -1 && bIdx > -1) {
          return 1;
        }

        if (a.text < b.text) {
          return -1;
        }

        if (a.text > b.text) {
          return 1;
        }

        return 0;
      });

      types.splice(topGroups.length, 0, {
        divider: true
      });
      return [{
        text: 'Change type',
        disabled: !TasksService.isChangeTypeEnabled(task, release, container),
        items: types,
        filter: true
      }];
    } else {
      return [];
    }
  }

  function typeOf(item) {
    if (item.modal) return 'modal';
    if (item.click) return 'click';
    if (item.divider) return 'divider';
    if (item.templateUrl) return 'template';
    if (item.items) return 'submenu';
    return 'noAction';
  }

  function enhanceMenuItemsWithType(items) {
    _.map(items, function (item) {
      if (item.items) {
        enhanceMenuItemsWithType(item.items);
      }

      return _.assignIn(item, {
        type: typeOf(item)
      });
    });
  }

  function getReleaseUrl(releaseId) {
    var internalId = task_context_menu_service_Ids.toInternalId(releaseId);
    return "#".concat(ViewStorage.getView(internalId, "/releases/".concat(internalId)));
  }

  function getTaskUrl(releaseId, phaseTaskId) {
    var internalId = task_context_menu_service_Ids.toInternalId(phaseTaskId);
    return "".concat(getReleaseUrl(releaseId), "?openTaskDetailsModal=").concat(internalId);
  }

  return {
    getMenuItems: function getMenuItems(task, release, container, groupedTaskDefinitions, withinBlackout) {
      var res = controlFlowActions(task, release, withinBlackout);
      res = res.concat(lockActions(task, release));
      res = res.concat(changeTypeSubmenu(task, release, container, groupedTaskDefinitions));
      res = res.concat(editActions(task, release, container));
      enhanceMenuItemsWithType(res);
      return res;
    },
    getTaskCardMenuItems: function getTaskCardMenuItems(task, release, withinBlackout) {
      var res = controlFlowActions(task, release, withinBlackout);

      if (Authenticator.hasViewPermission(release)) {
        res.push({
          text: 'View in Release',
          click: function click() {
            $state.go('release', {
              releaseId: task.releaseId
            });
          }
        });
      }

      enhanceMenuItemsWithType(res);
      return res;
    },
    getTaskReleaseFlowUrl: function getTaskReleaseFlowUrl(task) {
      var releaseId = task_context_menu_service_Ids.releaseIdFrom(task.id);
      var phaseTaskId = task_context_menu_service_Ids.phaseTaskIdFrom(task.id);
      var hostUrl = $location.$$absUrl.split('/#/')[0];
      var taskUrl = getTaskUrl(releaseId, phaseTaskId);
      return hostUrl + '/' + taskUrl;
    },
    getTaskReleaseTableUrl: function getTaskReleaseTableUrl(task) {
      var releaseId = task_context_menu_service_Ids.releaseIdFrom(task.id);
      var phaseTaskId = task_context_menu_service_Ids.phaseTaskIdFrom(task.id);
      var taskUrl = getTaskUrl(releaseId, phaseTaskId);
      taskUrl = $location.$$absUrl.split('/#/')[0] + '/' + taskUrl;
      return taskUrl.replace("/table", "");
    }
  };
}]);
// EXTERNAL MODULE: ./core/xlr-ui/app/js/tasks/task-controller.js
var task_controller = __webpack_require__(1418);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/tasks/task-definitions-service.js
var task_definitions_service = __webpack_require__(1419);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/tasks/task-details-controller.js





function task_details_controller_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function task_details_controller_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { task_details_controller_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { task_details_controller_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }


angular.module('xlrelease').controller('taskDetailsController', ['$scope', 'ModalService', 'Backend', 'Toastr', 'TasksService', 'ReleasesService', '$location', 'Authenticator', 'FlagService', 'TaskDetailsUpdates', 'UsersService', 'UserProfile', 'PlanningDataEditorMixin', 'ConfigurationInstances', 'ReleaseEditorCollapse', 'VariablesService', 'TaskContextMenuService', 'CalendarService', '$stateParams', 'Ids', 'ViewStorage', '$uibModal', function ($scope, ModalService, Backend, Toastr, TasksService, ReleasesService, $location, Authenticator, FlagService, TaskDetailsUpdates, UsersService, UserProfile, PlanningDataEditorMixin, ConfigurationInstances, ReleaseEditorCollapse, VariablesService, TaskContextMenuService, CalendarService, $stateParams, Ids, ViewStorage, $uibModal) {
  $scope.data = {
    newComment: '',
    showCommentForm: false
  };

  if ($scope.task) {
    if (TasksService.isTaskGroup($scope.task)) {
      $scope.isCollapsed = ReleaseEditorCollapse.isTaskGroupCollapsed($scope.task);
    }
  }

  $scope.mentionsExtension = {
    attributes: {
      "mentio": "true",
      "mentio-require-leading-space": "true",
      "mentio-items": "extension.data | filter:typedTerm",
      "mentio-select": "'@' + item.username"
    },
    data: []
  };
  $scope.allUsers = [];
  $scope.ctrl = $scope;
  $scope.ctrlScope = $scope;
  $scope.tasksServices = TasksService;
  $scope.taskRecoverOps = [{
    id: "Skip task",
    title: "Skip task"
  }, {
    id: "Run script",
    title: "Define additional action"
  }];

  $scope.getPhaseTitle = function () {
    return $scope.phase && $scope.phase.title || $scope.task.phaseTitle;
  };

  $scope.formValid = true;

  $scope.findRelease = function (task, releases) {
    return releases.find(function (r) {
      return r.id === task.releaseId;
    });
  };

  $scope.canAddComment = function (release) {
    return !release.archived;
  };

  function loadModalScope(task) {
    return CalendarService.withinBlackout().then(function (response) {
      var modalScope = $scope.$new();
      modalScope.withinBlackout = response.data;

      modalScope.canStartTaskWithinBlackout = function (release) {
        return task.delayDuringBlackout && TasksService.canEditBlackout(release, task) && modalScope.withinBlackout || TasksService.canWorkOnTask(release, task) && (!task.delayDuringBlackout || !modalScope.withinBlackout);
      };

      return modalScope;
    });
  }

  $scope.openTaskDetailsModal = function (task) {
    if (isTaskDisabledInView(task)) {
      return;
    }

    loadModalScope(task).then(function (modalScope) {
      ModalService.open(modalScope, "'partials/tasks/details/task-details-modal.html'", "editTask(task, release)", "loadReleaseAfterTaskUpdate()", true, true);
      modalScope.showModal();
    });
  };

  $scope.openTaskDetailsModalIfRequested = function () {
    if ($location.search().openTaskDetailsModal && Ids.phaseTaskIdFrom($location.search().openTaskDetailsModal) === Ids.phaseTaskIdFrom($scope.task.id)) {
      $scope.openTaskDetailsModal($scope.task);
    }
  };

  function decorateWithReleaseLoading(menuItems) {
    menuItems.forEach(function (i) {
      if (i.text === 'Duplicate') {
        var oldFn = i.click;

        i.click = function () {
          return oldFn().then($scope.loadRelease);
        }; //it is a dirty hack but I cannot find a proper one

      }
    });
    return menuItems;
  }

  function copyUrlToClipboard(task) {
    var status = copy_text_to_clipboard_default()(TaskContextMenuService.getTaskReleaseFlowUrl(task));

    if (status) {
      Toastr.success('Task url was copied to the clipboard!');
    } else {
      Toastr.error('Can not access clipboard to copy task url. Please check if you have given this browser sufficient permissions to copy data to clipboard.');
    }
  }

  $scope.taskContextMenuItems = function (task, release, container, groupedTaskDefinitions, withinBlackout) {
    var items = TaskContextMenuService.getMenuItems(task, release, container, groupedTaskDefinitions, withinBlackout);
    var dividerIndex = items.indexOf({
      divider: true
    });
    items.splice(dividerIndex, 0, {
      text: 'Copy URL',
      type: 'click',
      disabled: false,
      click: function click() {
        copyUrlToClipboard(task);
      }
    });

    if (!$scope.isTaskContextMenuAvailable(task)) {
      items = items.filter(function (item, index, arr) {
        return item.text === 'Copy URL';
      });
    }

    return decorateWithReleaseLoading(items);
  };

  $scope.createOptionalVariable = function (task, name, variableType, createdCallback) {
    var variable = {
      key: name,
      requiresValue: false,
      showOnReleaseStart: false,
      type: variableType
    };
    $scope.createReleaseVariable(task, variable, createdCallback);
  };

  $scope.createRequiredVariable = function (task, name, variableType, createdCallback) {
    var variable = {
      key: name,
      type: variableType
    };
    $scope.createReleaseVariable(task, variable, createdCallback);
  };

  $scope.createReleaseVariable = function (task, variable, createdCallback) {
    VariablesService.createReleaseVariable(task.releaseId, variable).then(function (resp) {
      if (createdCallback) {
        createdCallback(resp.data);
      }
    });
  };

  $scope.updateTags = function (tags, task) {
    task.tags = tags;
    $scope.saveTask(task);
    TaskDetailsUpdates.tagsChanged = true;
  };

  $scope.initTaskRecoverOp = function (task) {
    if (!task.taskRecoverOp) {
      task.taskRecoverOp = 'Skip task';
      $scope.saveTask(task);
    }
  };

  $scope.saveTask = function (task, saveCallback) {
    return TasksService.updateTask(task).then(function (resp) {
      var savedTask = resp.data;
      task.password = savedTask.password;
      task.outputProperties = savedTask.outputProperties;
      task.inputProperties = savedTask.inputProperties;
      task.variables = savedTask.variables;
      loadVariablesOnTaskSaved(task.releaseId);

      if (saveCallback) {
        saveCallback(task);
      }
    });
  };

  angular.extend($scope, PlanningDataEditorMixin.withSaveCallback(function (task) {
    resetWaitForScheduledStartDate(task);
    $scope.saveTask(task);
    TaskDetailsUpdates.planningDataChanged = true;
  }));

  function resetWaitForScheduledStartDate(task) {
    if (!task.scheduledStartDate) {
      task.waitForScheduledStartDate = true; // reset to default value
    }
  }

  $scope.reloadTaskVariablesCallback = function (release) {
    return function (task) {
      loadVariables(task, release);
    };
  };

  $scope.loadReleaseForEditTask = function (task, release) {
    $scope.isPartialLoad = true;
    ReleasesService.getRelease(release.id, {
      dontRedirectWhenForbidden: true,
      hideAlert: true
    }).then(function (result) {
      $scope.release.variables = result.data.variables;
      $scope.editTask(task, result.data);
    }).catch(function (response) {
      if (response.status === 403) {
        Backend.get("tasks/".concat(task.id, "/release")).then(function (resp) {
          return $scope.editTask(task, resp.data);
        });
      }
    });
  };

  $scope.editTask = function (task, release) {
    loadModalScope(task).then(function (modalScope) {
      $scope.withinBlackout = modalScope.withinBlackout;
      $scope.canStartTaskWithinBlackout = modalScope.canStartTaskWithinBlackout;
    });

    if ('type' in release) {
      $scope.planning.initPlanningData(task, release);
    }

    loadVariables(task, release);
    loadUsernames().then(function () {
      loadWatchers(task);
    });
    loadTeams(task.id, release);
    loadComments(task.id);
    loadCustomType(task);
    var folderId = Ids.releaseIdToFolderId($stateParams.releaseId);
    ConfigurationInstances.load(folderId);
  };

  $scope.ConfigurationInstances = ConfigurationInstances;

  function loadVariables(task, release) {
    $scope.variables = undefined;
    $scope.allVariables = undefined;
    $scope.releaseVariables = undefined;
    $scope.editableReleaseVariables = undefined;

    if (TasksService.isTaskWaitingForInput(task) && TasksService.canWorkOnTask(release, task)) {
      TasksService.getTaskVariables(task).then(function (resp) {
        return $scope.variables = resp.data;
      });
    }

    if (canViewRelease(release)) {
      VariablesService.getAllVariables(release.id).then(function (allVariables) {
        $scope.allVariables = allVariables;
        $scope.allVariablesWithReleaseVars = loadAllVariablesWithSpecialRelVars(allVariables, release);
        $scope.releaseVariables = _.filter(allVariables, function (v) {
          return !VariablesService.isFolderOrGlobalVariable(v.key);
        });
        $scope.editableReleaseVariables = _.filter($scope.releaseVariables, function (v) {
          return !VariablesService.isCiPropertyVariableName(v.key);
        });
      });
    }
  }

  function loadVariablesOnTaskSaved(releaseId) {
    VariablesService.getAllVariables(releaseId).then(function (allVariables) {
      allVariables.filter(function (var1) {
        return !$scope.allVariables.some(function (var2) {
          return var1.key === var2.key;
        });
      }).forEach(function (newVar) {
        return $scope.allVariablesWithReleaseVars.push(newVar);
      });
    });
  }

  function loadAllVariablesWithSpecialRelVars(allVariables, release) {
    if (release.variables) {
      var specialVariables = Object.keys(release.variables).filter(function (key) {
        return key.includes('release.') === true;
      }).reduce(function (obj, key) {
        return task_details_controller_objectSpread(task_details_controller_objectSpread({}, obj), {}, defineProperty_default()({}, key, release.variables[key]));
      }, {});
      Object.keys(specialVariables).forEach(function (key) {
        allVariables.push({
          'displayName': key,
          'id': '',
          'key': key.replace('${', '').replace('}', ''),
          'requiresValue': false,
          'showOnReleaseStart': false,
          'type': "xlrelease.StringVariable",
          'value': specialVariables[key],
          'variableName': key
        });
      });
    }

    return allVariables;
  }

  function loadUsernames() {
    return UsersService.getAllUsers().then(function (resp) {
      $scope.allUsers = _.sortBy(resp.data, [function (rp) {
        return rp.username.toLowerCase();
      }]);
      $scope.allUsers.forEach(function (user) {
        return user.label = user.fullName ? "".concat(user.fullName, " (").concat(user.username, ")") : user.username;
      });
      $scope.mentionsExtension.data = $scope.allUsers;
    });
  }

  function loadTeams(taskId, release) {
    $scope.teams = [];

    if (Authenticator.hasEditTaskPermission(release) || Authenticator.hasReassignTaskPermission(release)) {
      Backend.get("releases/".concat(release.id, "/teams/assignable")).then(function (resp) {
        return $scope.teams = _(resp.data).map(function (team) {
          return {
            id: team.teamName,
            title: team.teamName
          };
        }).sortBy(function (t) {
          return t.title.toLowerCase();
        }).value();
      });
    }
  }

  function loadComments(taskId) {
    $scope.comments = [];
    Backend.get("tasks/".concat(taskId, "/comments")).then(function (resp) {
      return $scope.comments = resp.data;
    });
  }

  function loadCustomType(task) {
    $scope.scriptDefinition = null;

    if (task.scriptDefinitionType) {
      Backend.get("tasks/task-definitions/".concat(task.scriptDefinitionType)).then(function (resp) {
        return $scope.scriptDefinition = resp.data;
      });
    }
  }

  $scope.saveComment = function (comment) {
    Backend.put("comments/".concat(comment.id), comment).then(function (resp) {
      var updatedComment = resp.data;
      comment.date = updatedComment.date;
      comment.text = updatedComment.text;
    });
  };

  $scope.openDeleteCommentModal = function (_comment) {
    $uibModal.open({
      animation: false,
      component: 'deleteCommentOfTaskModal',
      windowClass: 'delete-comment-window',
      backdropClass: 'delete-comment-backdrop',
      resolve: {
        comment: function comment() {
          return _comment;
        }
      }
    }).result.then(function (pressedDelete) {
      if (pressedDelete) {
        Backend.del("comments/".concat(_comment.id), {
          data: _comment
        }).then(function (resp) {
          var index = $scope.comments.indexOf(_comment);
          $scope.comments.splice(index, 1);
          task.numberOfComments--;
        });
      }
    });
  };

  $scope.addComment = function (task, commentText) {
    var newComment = {
      text: commentText
    };
    Backend.post("tasks/".concat(task.id, "/comments"), newComment).then(function (resp) {
      $scope.comments.push(resp.data);
      task.numberOfComments++;
      $scope.resetCreateCommentForm();
    });
  };

  $scope.resetCreateCommentForm = function () {
    $scope.data.newComment = '';
    $scope.data.showCommentForm = false;
  };

  $scope.showCreateCommentForm = function () {
    $scope.data.showCommentForm = true;
  };

  $scope.flag = function (flagStatus) {
    $scope.task.flag.status = flagStatus;

    if (!FlagService.isTaskFlagged($scope.task)) {
      $scope.task.flag.comment = '';
    }

    $scope.saveTask($scope.task);
  };

  $scope.removeOwner = function () {
    $scope.task.owner = null;
    Backend.del('tasks/' + $scope.task.id + '/owner');
    TaskDetailsUpdates.assigneeChanged = true;
  };

  $scope.updateOwner = function (task) {
    if (task.owner) {
      Backend.put('tasks/' + task.id + '/owner', TasksService.toTaskFullView(task));
      TaskDetailsUpdates.assigneeChanged = true;
    } else {
      $scope.removeOwner();
    }
  };

  $scope.removeTeam = function () {
    $scope.task.team = null;
    Backend.del('tasks/' + $scope.task.id + '/team');
    TaskDetailsUpdates.assigneeChanged = true;
  };

  $scope.updateTeam = function (task) {
    Backend.put('tasks/' + task.id + '/team', TasksService.toTaskFullView(task));
    TaskDetailsUpdates.assigneeChanged = true;
  };

  $scope.viewTaskInRelease = function (releaseId) {
    $location.url('releases/' + releaseId);
  };

  $scope.canWorkOnTask = function (release) {
    return TasksService.canWorkOnTask(release, $scope.task);
  };

  $scope.canUpdateCommentOnTask = function (release, comment) {
    return TasksService.canUpdateCommentOnTask(release, $scope.task, comment);
  };

  $scope.canWorkOnReadOnlyTask = function (release) {
    return TasksService.canWorkOnReadOnlyTask(release, $scope.task);
  };

  function canEditTask(release, task) {
    return TasksService.canEditTask(release, task || $scope.task);
  }

  function canEditTaskConfigurationFacet(release) {
    return TasksService.canEditTaskConfigurationFacet(release);
  }

  $scope.canEditTaskConfigurationPropertiesAndIsUnlocked = function () {
    return !TasksService.isLocked($scope.task) && TasksService.canEditTaskConfigurationPropertiesAndTaskNotInProgress($scope.release, $scope.task);
  };

  $scope.canEditTaskAttachment = function () {
    return TasksService.canEditTaskAttachment($scope.release, $scope.task);
  };

  $scope.canEditGateTaskConfigurationPropertiesAndIsUnlocked = function () {
    return !TasksService.isLocked($scope.task) && TasksService.canEditTaskConfigurationProperties($scope.release, $scope.task);
  };

  $scope.canClaimTask = function (task, release) {
    return TasksService.canAssignTaskToCurrentUser(task, release);
  };

  $scope.canCompleteTask = function (release, task) {
    return TasksService.canCompleteTask(release, task);
  };

  $scope.canSkipTask = function (release, task) {
    return TasksService.canSkipTask(release, task);
  };

  $scope.$on('formValidityChanged', function (event, validity) {
    $scope.formValid = validity;
  });

  $scope.isPlannedOrPending = function (task) {
    return TasksService.isTaskPlanned(task) || TasksService.isTaskPending(task);
  };

  $scope.isTaskPostponedDueToBlackout = function (task) {
    return task.postponedDueToBlackout;
  };

  $scope.isTaskPostponedUntilEnvironmentsAreReserved = function (task) {
    return task.postponedUntilEnvironmentsAreReserved;
  };

  $scope.getOriginalScheduledStartDate = function (task) {
    if ($scope.isTaskPostponedDueToBlackout(task) || $scope.isTaskPostponedUntilEnvironmentsAreReserved(task)) {
      return task.originalScheduledStartDate;
    } else {
      return null;
    }
  };

  $scope.isTaskInFinishedState = function (task) {
    return TasksService.isTaskCompleted(task) || TasksService.isTaskFailed(task) || TasksService.isTaskSkipped(task) || TasksService.isTaskAborted(task);
  };

  $scope.assignToMe = function (task) {
    task.owner = UserProfile.getCurrentUser();
    $scope.updateOwner(task);
  };

  $scope.deleteAttachment = function (release, task, attachment) {
    Backend.del("releases/".concat(release.id, "/").concat(task.id, "/attachments/").concat(attachment.id)).then(function () {
      return _.remove(task.attachments, {
        id: attachment.id
      });
    });
  };

  function isTaskDisabledInView(task) {
    return task.disabledInView;
  }

  $scope.isTaskDisabledInView = isTaskDisabledInView;

  $scope.isTaskContextMenuAvailable = function (task) {
    return (!TasksService.isTaskReadOnly(task) || TasksService.isTaskDoneInAdvance(task)) && !isTaskDisabledInView(task);
  }; // Task Watchers


  var sortWatchers = function sortWatchers(watchers) {
    var currentUser = UserProfile.getCurrentUser();

    var users = _.remove(watchers, {
      username: currentUser.username
    });

    var sortedWatchers = _.orderBy(watchers, [function (w) {
      return _.toLower(w.fullName);
    }, function (w) {
      return w.username.toLowerCase();
    }], ['asc', 'asc']);

    return [].concat(toConsumableArray_default()(users), toConsumableArray_default()(sortedWatchers));
  };

  var excludeWatchersFromAllUsers = function excludeWatchersFromAllUsers(allUsers, watchers) {
    return _.differenceWith(allUsers, watchers, function (u1, u2) {
      return u1.username === u2.username;
    });
  };

  var handleWatcherResponse = function handleWatcherResponse(response) {
    $scope.watchers = sortWatchers(response.data);
    $scope.nonWatchingUsers = excludeWatchersFromAllUsers($scope.allUsers, $scope.watchers);
  };

  var loadWatchers = function loadWatchers(task) {
    $scope.watchers = [];
    Backend.get("tasks/".concat(task.id, "/watchers")).then(handleWatcherResponse);
  };

  var isWatchingTask = function isWatchingTask(watcher) {
    return _.some($scope.watchers, {
      username: watcher.username
    });
  };

  var addWatcher = function addWatcher(task, watcher) {
    var found = _.find($scope.watchers, {
      username: watcher.username
    });

    if (!found) {
      Backend.post("tasks/".concat(task.id, "/watchers"), watcher).then(handleWatcherResponse);
    }
  };

  var removeWatcher = function removeWatcher(task, watcher) {
    Backend.del("tasks/".concat(task.id, "/watchers/").concat(watcher.username)).then(handleWatcherResponse);
  };

  $scope.isUserWatchingTask = function () {
    return isWatchingTask(UserProfile.getCurrentUser());
  };

  $scope.addMeAsWatcher = function (task) {
    addWatcher(task, UserProfile.getCurrentUser());
  };

  $scope.canRemoveWatcher = function (release, watcher) {
    var currentUser = UserProfile.getCurrentUser();
    return $scope.canEditTask(release) || currentUser.username === watcher.username;
  };

  $scope.removeWatcher = function (task, watcher) {
    removeWatcher(task, watcher);
  };

  $scope.watcherContainer = {
    watcher: null
  };

  $scope.handleWatcherChange = function (task) {
    var watcher = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {
      username: ''
    };

    if (watcher.username !== '') {
      addWatcher(task, watcher);
    }

    $scope.watcherContainer.watcher = null;
  };

  $scope.watchersTooltip = {
    placement: 'auto bottom',
    text: 'Assigning a watcher role to a user will allow him to receive notifications for this tasks events'
  };
  $scope.canEditTask = canEditTask;
  $scope.canEditBlackout = TasksService.canEditBlackout;
  $scope.canDelayTask = TasksService.canDelayTask;
  $scope.canWorkOnFailedTask = TasksService.canWorkOnFailedTask;
  $scope.isStatusUpdatable = TasksService.isStatusUpdatable;
  $scope.canUpdateInProgressStatus = TasksService.canUpdateInProgressStatus;
  $scope.canUpdatePlannedStatus = TasksService.canUpdatePlannedStatus;
  $scope.canUpdateFailedStatus = TasksService.canUpdateFailedStatus;
  $scope.isTaskDoneInAdvance = TasksService.isTaskDoneInAdvance;
  $scope.isStatusUpdatable = TasksService.isStatusUpdatable;
  $scope.isTaskInProgress = TasksService.isTaskInProgress;
  $scope.isTaskQueued = TasksService.isTaskQueued;
  $scope.isGateTask = TasksService.isGateTask;
  $scope.isUserInputTask = TasksService.isUserInputTask;
  $scope.isNotificationTask = TasksService.isNotificationTask;
  $scope.isScriptTask = TasksService.isScriptTask;
  $scope.isTaskGroup = TasksService.isTaskGroup;
  $scope.isParallelGroup = TasksService.isParallelGroup;
  $scope.isSequentialGroup = TasksService.isSequentialGroup;
  $scope.isCustomScriptTask = TasksService.isCustomScriptTask;
  $scope.isCreateReleaseTask = TasksService.isCreateReleaseTask;
  $scope.isInProgressScriptTask = TasksService.isInProgressScriptTask;
  $scope.isGateClosed = TasksService.isGateClosed;
  $scope.isTaskReadOnly = TasksService.isTaskReadOnly;
  $scope.isTaskFailed = TasksService.isTaskFailed;
  $scope.isTaskFailing = TasksService.isTaskFailing;
  $scope.isTaskPending = TasksService.isTaskPending;
  $scope.isTaskAborted = TasksService.isTaskAborted;
  $scope.isTaskCompleted = TasksService.isTaskCompleted;
  $scope.isTaskPreconditionInProgress = TasksService.isTaskPreconditionInProgress;
  $scope.isTaskFacetInProgress = TasksService.isTaskFacetInProgress;
  $scope.hasDeploymentFacet = TasksService.hasDeploymentFacet;
  $scope.isTaskFailureHandlerInProgress = TasksService.isTaskFailureHandlerInProgress;
  $scope.isTaskAbortScriptInProgress = TasksService.isTaskAbortScriptInProgress;
  $scope.isTaskGroupSkippableOrRetriable = TasksService.isTaskGroupSkippableOrRetriable;
  $scope.isTaskCompletedInAdvance = TasksService.isTaskCompletedInAdvance;
  $scope.isTaskSkippedInAdvance = TasksService.isTaskSkippedInAdvance;
  $scope.isTaskSkipped = TasksService.isTaskSkipped;
  $scope.isDone = TasksService.isDone;
  $scope.isDoneInAdvance = TasksService.isTaskDoneInAdvance;
  $scope.isAutomated = TasksService.isAutomated;
  $scope.isTaskDelayedDuringBlackout = TasksService.isTaskDelayedDuringBlackout;
  $scope.hasOwner = TasksService.hasOwner;
  $scope.isReleaseInProgress = ReleasesService.isReleaseInProgress;
  $scope.hasConfigurationUri = TasksService.hasConfigurationUri;
  $scope.getConfigurationUri = TasksService.getConfigurationUri;
  $scope.isPreConditionCollapsed = ReleaseEditorCollapse.isPreConditionCollapsed;
  $scope.togglePreConditionState = ReleaseEditorCollapse.togglePreConditionState;
  $scope.areTaskPropertiesReadonly = areTaskPropertiesReadonly;
  $scope.areFacetsCollapsed = ReleaseEditorCollapse.areFacetsCollapsed;
  $scope.toggleFacetsState = ReleaseEditorCollapse.toggleFacetsState;
  $scope.isFailureHandlerCollapsed = ReleaseEditorCollapse.isFailureHandlerCollapsed;
  $scope.toggleFailureHandlerState = ReleaseEditorCollapse.toggleFailureHandlerState;
  $scope.isCommentsCollapsed = ReleaseEditorCollapse.isCommentsCollapsed;
  $scope.toggleCommentsState = ReleaseEditorCollapse.toggleCommentsState;
  $scope.isAttachmentsCollapsed = ReleaseEditorCollapse.isAttachmentsCollapsed;
  $scope.toggleAttachmentsState = ReleaseEditorCollapse.toggleAttachmentsState;

  $scope.toggleTaskGroupCollapseState = function (task) {
    $scope.isCollapsed = !$scope.isCollapsed;
    ReleaseEditorCollapse.toggleTaskGroupCollapseState(task);
  };

  $scope.hasLockPermission = function (release) {
    return Authenticator.hasLockTaskPermission(release);
  };

  $scope.isLocked = function () {
    return TasksService.isLocked($scope.task);
  };

  $scope.isUnknownTask = function () {
    return TasksService.isUnknownTask($scope.task);
  };

  $scope.canEditAndIsUnlocked = function () {
    return !$scope.isLocked() && canEditTask($scope.release, $scope.task);
  };

  $scope.canEditTaskTags = function () {
    return !$scope.isLocked() && TasksService.canEditTaskTags($scope.release, $scope.task);
  };

  $scope.canEditFacet = function () {
    return !$scope.isLocked() && (canEditTask($scope.release, $scope.task) || canEditTaskConfigurationFacet($scope.release));
  };

  $scope.canEditFailureHandler = function () {
    return !$scope.isLocked() && TasksService.canEditFailureHandler($scope.release, $scope.task);
  };

  $scope.canEditPrecondition = function () {
    return !$scope.isLocked() && TasksService.canEditPrecondition($scope.release, $scope.task);
  };

  $scope.canEditScriptAndIsUnlocked = function () {
    return TasksService.canEditTaskScript($scope.release, $scope.task) && !$scope.isLocked();
  };

  $scope.areTaskPropertiesReadonlyOrLocked = function () {
    return areTaskPropertiesReadonly() || $scope.isLocked();
  };

  $scope.unlock = function (task) {
    return TasksService.unlock(task.id).then(function () {
      setTaskLock(task, false);
    });
  };

  $scope.canEditWaitForScheduledStartDate = function () {
    return TasksService.canEditWaitForScheduledStartDate($scope.release);
  };

  $scope.canEditEnvironmentAvailability = function () {
    return TasksService.canEditEnvironmentAvailability($scope.release);
  };

  function setTaskLock(task, lock) {
    var flatten = function flatten(t) {
      return [t].concat(toConsumableArray_default()(TasksService.isTaskGroup(t) ? _.flatMap(t.tasks, flatten) : []));
    };

    flatten(task).forEach(function (t) {
      t.locked = lock;
    });
  }

  function areTaskPropertiesReadonly() {
    var release = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : $scope.release;
    var task = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : $scope.task;
    return TasksService.areTaskPropertiesReadonly(release, task);
  }

  function canViewRelease(release) {
    return Authenticator.hasViewPermission(release);
  }

  $scope.$on('$destroy', function () {
    ConfigurationInstances.reset();
  });

  $scope.getEnvironmentAvailabilityTooltip = function (task) {
    if (TasksService.isTaskReadOnly(task)) {
      return undefined;
    } else if (TasksService.hasDeploymentFacet(task)) {
      return 'Postpone the task until the environment is available';
    } else {
      return 'To use this feature, you must add deployment attributes';
    }
  };

  $scope.getTaskStatusTooltip = function () {
    $scope.statusTooltip = "";
    TasksService.getLatestTaskActivityLog($scope.release.id, Ids.toDomainId($scope.task.id)).then(function (logEntry) {
      var displayedName = !logEntry.user.fullName || 0 === logEntry.user.fullName.length ? logEntry.user.username : "".concat(logEntry.user.fullName, " (").concat(logEntry.user.username, ")");

      if (["TASK_COMPLETED", "TASK_COMPLETED_IN_ADVANCE"].includes(logEntry.activityType)) {
        $scope.statusTooltip = "Completed by ".concat(displayedName);
      } else if (["TASK_SKIPPED", "TASK_SKIPPED_IN_ADVANCE"].includes(logEntry.activityType)) {
        $scope.statusTooltip = "Skipped by ".concat(displayedName);
      } else if (["TASK_FAILED"].includes(logEntry.activityType)) {
        $scope.statusTooltip = "Failed by ".concat(displayedName);
      }
    });
  };

  $scope.canEditTaskTitleAndDescription = function () {
    return TasksService.canEditTaskTitleAndDescription($scope.release, $scope.task) && !$scope.isLocked();
  };

  $scope.canEditTaskDates = function () {
    return TasksService.canEditTaskDates($scope.release, $scope.task) && !$scope.isLocked();
  };

  $scope.canEditTaskFlag = function () {
    return TasksService.canEditTaskFlag($scope.release, $scope.task);
  };
}]);
// EXTERNAL MODULE: ./core/xlr-ui/app/js/tasks/task-details-updates.js
var task_details_updates = __webpack_require__(1420);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/tasks/task-list-controller.js
var task_list_controller = __webpack_require__(1421);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/tasks/task-polling-service.js
var task_polling_service = __webpack_require__(1422);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/tasks/task-status-css-class-filter.js
var task_status_css_class_filter = __webpack_require__(1423);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/tasks/task-type-css-class-filter.js
var task_type_css_class_filter = __webpack_require__(1424);

// CONCATENATED MODULE: ./core/xlr-ui/app/features/common/ci-statuses.js

var CommonStatuses = [{
  label: 'Planned',
  value: 'Planned',
  color: colors["a" /* default */].gray
}, {
  label: 'In progress',
  value: 'In progress',
  color: colors["a" /* default */].blue
}, {
  label: 'Failed',
  value: 'Failed',
  color: colors["a" /* default */].red
}];
var ReleaseStatuses = [].concat(CommonStatuses, [{
  label: 'Paused',
  value: 'Paused',
  color: colors["a" /* default */].gray
}, {
  label: 'Failing',
  value: 'Failing',
  color: colors["a" /* default */].orange
}, {
  label: 'Aborted',
  value: 'Aborted',
  color: colors["a" /* default */].gray
}, {
  label: 'Completed',
  value: 'Completed',
  color: colors["a" /* default */].green
}]);
var TaskStatuses = [].concat(CommonStatuses, [{
  label: 'Pendind',
  value: 'Pending',
  color: colors["a" /* default */].gray
}, {
  label: 'Queued',
  value: 'Queued',
  color: colors["a" /* default */].blue
}]);
// CONCATENATED MODULE: ./core/xlr-ui/app/js/tasks/tasks-controller.js


angular.module('xlrelease').controller('TasksController', ['$scope', 'filterSettings', 'Backend', 'TaskPolling', 'Events', 'Modal', 'TaskDetailsUpdates', 'ClientSettings', 'TaskConstants', 'UsersService', 'FoldersService', 'Timeout', 'PollingSettings', function ($scope, filterSettings, Backend, TaskPolling, Events, Modal, TaskDetailsUpdates, ClientSettings, TaskConstants, UsersService, FoldersService, Timeout, PollingSettings) {
  var allTasksPromise = null;
  $scope.statuses = TaskStatuses;
  $scope.filters = filterSettings;
  $scope.orderByValues = _.values(global_constants["d" /* taskOrderValues */]);
  $scope.assigneeOptions = global_constants["c" /* taskAssigneeOptions */];
  $scope.filters = filterSettings;
  $scope.foldersReady = false;
  $scope.folders = [];
  $scope.expanderState = {};
  $scope.onGroupTasksByRelease = onGroupTasksByRelease;
  $scope.onFiltersChanged = onFiltersChanged;
  $scope.onTaskChange = onTaskChange;
  $scope.onTaskDetailsClosed = onTaskDetailsClosed;
  $scope.isHeaderExpanded = isHeaderExpanded;
  $scope.switchView = switchView;

  $scope.isListView = function () {
    return $scope.viewMode === 'list';
  };

  $scope.isGridView = function () {
    return $scope.viewMode === 'grid';
  };

  init();
  $scope.$on('$destroy', cancelAllTasksPolling);

  function init() {
    var layout = ClientSettings.getTaskFiltersLayout();
    $scope.isGroupedByRelease = !!layout && !_.isUndefined(layout.isGroupedByRelease) ? layout.isGroupedByRelease : true;
    $scope.viewMode = !!layout && !_.isUndefined(layout.viewMode) ? layout.viewMode : 'list';
    loadTasks();
    loadTaskTags();
    loadUsers();
    loadFolders();
  }

  function loadFolders() {
    FoldersService.list().then(function (result) {
      $scope.folders = result.data;
      $scope.foldersReady = true;
    });
  }

  function loadTasks() {
    $scope.$emit(Events.permission.refresh);
    var config = {
      params: {
        limitTasksHint: TaskConstants.LIMIT_TASKS_HINT
      }
    };
    Backend.post('tasks/search', $scope.filters, config).then(function (resp) {
      var taskSearchView = resp.data;
      $scope.releases = taskSearchView.releaseTasks;
      $scope.tasks = _.flatten($scope.releases.map(function (r) {
        return r.tasks;
      }));
      orderTasksInReleases($scope.filters.orderBy);
      $scope.limitReached = taskSearchView.limitReached;
      startPolling();
    });
  }

  function loadTaskTags() {
    Backend.get('tasks/tags').then(function (resp) {
      $scope.allTags = resp.data;
    });
  }

  function loadUsers() {
    UsersService.getAllUsersAsObject().then(function (users) {
      $scope.users = users;
    });
  }

  function onFiltersChanged(filters) {
    loadTasks();
    ClientSettings.setTasksFilters(filters);
  }

  function onGroupTasksByRelease() {
    ClientSettings.updateTaskFiltersLayout({
      isGroupedByRelease: $scope.isGroupedByRelease
    });
  }

  function orderTasksInReleases(orderBy) {
    var originalReleases = $scope.releases;
    var order = orderBy ? orderBy : $scope.orderBy;
    $scope.orderBy = order;
    var orderFunc = null;

    if (order === global_constants["d" /* taskOrderValues */].startDate.orderBy) {
      orderFunc = function orderFunc(tasks) {
        return _.orderBy(tasks, ['startDate', 'scheduledStartDate'], ['asc', 'asc']);
      };
    } else if (order === global_constants["d" /* taskOrderValues */].status.orderBy) {
      orderFunc = function orderFunc(tasks) {
        return _.sortBy(tasks, function (task) {
          return global_constants["e" /* taskStatusPriorities */][task.status.toLowerCase()];
        });
      };
    } else {
      orderFunc = function orderFunc(tasks) {
        return _.orderBy(tasks, 'dueDate', 'asc');
      };
    }

    _.forEach(originalReleases, function (release) {
      return release.tasks = orderFunc(release.tasks);
    });

    $scope.tasks = orderFunc($scope.tasks);
  }

  function onTaskChange() {
    loadTasks();
  }

  function onTaskDetailsClosed() {
    if (TaskDetailsUpdates.assigneeChanged || TaskDetailsUpdates.planningDataChanged || TaskDetailsUpdates.tagsChanged) {
      if (TaskDetailsUpdates.tagsChanged) {
        loadTaskTags();
      }

      loadTasks();
      TaskDetailsUpdates.reset();
    }
  }

  function switchView(mode) {
    $scope.viewMode = mode;
    ClientSettings.updateTaskFiltersLayout({
      viewMode: mode
    });
  }

  function startPolling() {
    TaskPolling.startTaskPolling($scope.tasks, $scope).then(loadTasks);
    startAllTasksPolling();
    Modal.withScope($scope).onNextOpen(stopPolling).onNextClose(startPolling);
  }

  function startAllTasksPolling() {
    if (!$scope.$$destroyed) {
      allTasksPromise = Timeout(function () {
        if (allTasksPromise !== null) {
          stopPolling();
          loadTasks();
        }
      }, PollingSettings.getListInterval());
    }
  }

  function cancelAllTasksPolling() {
    Timeout.cancel(allTasksPromise);
    allTasksPromise = null;
  }

  function stopPolling() {
    cancelAllTasksPolling();
    $scope.$broadcast(Events.polling.stop);
  }

  function isHeaderExpanded() {
    var layout = ClientSettings.getTaskFiltersLayout();
    return layout ? layout.expanded : false;
  }
}]);
// EXTERNAL MODULE: ./core/xlr-ui/app/js/util/date-service.js
var date_service = __webpack_require__(274);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/releases/list/releases-status-service.js
var releases_status_service = __webpack_require__(107);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/tasks/tasks-service.js



var tasks_service_DateService = Object(date_service["a" /* default */])();
var tasks_service_ReleasesStatusService = Object(releases_status_service["a" /* default */])();
var tasks_service_Ids = Object(ids["a" /* default */])();

function TaskService(Backend, Authenticator, UserProfile, TaskDetailsUpdates, VariablesService) {
  function isTaskPlanned(task) {
    return isStatusOneOf(task, 'PLANNED');
  }

  function isTaskPending(task) {
    return isStatusOneOf(task, 'PENDING');
  }

  function isTaskInProgress(task) {
    return isStatusOneOf(task, 'IN_PROGRESS');
  }

  function isTaskQueued(task) {
    return isStatusOneOf(task, 'QUEUED', 'FAILURE_HANDLER_QUEUED', 'ABORT_SCRIPT_QUEUED');
  }

  function isTaskPreconditionInProgress(task) {
    return isStatusOneOf(task, 'PRECONDITION_IN_PROGRESS');
  }

  function isTaskFacetInProgress(task) {
    return isStatusOneOf(task, 'FACET_CHECK_IN_PROGRESS');
  }

  function isTaskFailureHandlerInProgress(task) {
    return isStatusOneOf(task, 'FAILURE_HANDLER_IN_PROGRESS');
  }

  function isTaskAbortScriptInProgress(task) {
    return isStatusOneOf(task, 'ABORT_SCRIPT_IN_PROGRESS');
  }

  function isTaskOrPreconditionInProgress(task) {
    return isTaskInProgress(task) || isTaskPreconditionInProgress(task) || isTaskFailureHandlerInProgress(task) || isTaskAbortScriptInProgress(task) || isTaskFacetInProgress(task);
  }

  function isTaskCompleted(task) {
    return isStatusOneOf(task, 'COMPLETED', 'ABORTED');
  }

  function isTaskCompletedInAdvance(task) {
    return isStatusOneOf(task, 'COMPLETED_IN_ADVANCE');
  }

  function isTaskSkippedInAdvance(task) {
    return isStatusOneOf(task, 'SKIPPED_IN_ADVANCE');
  }

  function isTaskDraggable(task, container) {
    var isReorderable = isTaskPlannedOrDoneInAdvance;

    if (container && isLocked(container)) {
      return false;
    }

    if (!isReorderable(task)) {
      return false;
    }

    return !(container && isParallelGroup(container) && !isReorderable(container));
  }

  function isTaskGroupDroppable(container) {
    if (!isTaskGroup(container) || isLocked(container)) {
      return false;
    }

    if (isParallelGroup(container)) {
      return isTaskPlanned(container) || isTaskPending(container);
    }

    if (isSequentialGroup(container)) {
      return !isTaskReadOnly(container);
    }
  }

  function isTaskSkipped(task) {
    return isStatusOneOf(task, 'SKIPPED');
  }

  function areAllRequiredValuesPresent(task) {
    var isRequiredAndEmpty = function isRequiredAndEmpty(v) {
      return v.requiresValue === true && (v.value === null || v.value === angular.undefined);
    };

    var emptyRequiredVariables = _.find(task.variables, function (v) {
      return isRequiredAndEmpty(v);
    });

    return !_.isObject(emptyRequiredVariables);
  }

  function noInProgressVariableUpdate(task) {
    return !task.updatingVariablesCount || task.updatingVariablesCount === 0;
  }

  function isTaskFailed(task) {
    return isStatusOneOf(task, 'FAILED');
  }

  function isTaskFailing(task) {
    return isStatusOneOf(task, 'FAILING');
  }

  function isTaskDoneInAdvance(task) {
    return isTaskCompletedInAdvance(task) || isTaskSkippedInAdvance(task);
  }

  function isTaskPlannedOrDoneInAdvance(task) {
    return isTaskPlanned(task) || isTaskDoneInAdvance(task);
  }

  function isTaskWaitingForInput(task) {
    return isStatusOneOf(task, 'WAITING_FOR_INPUT');
  }

  function isUserInputTask(task) {
    return 'xlrelease.UserInputTask' === task.type;
  }

  function hasConfigurationUri(task) {
    return task.configurationUri;
  }

  function getConfigurationUri(task) {
    return 'static/10.2.14/' + task.configurationUri;
  }

  function isGateTask(task) {
    return 'xlrelease.GateTask' === task.type;
  }

  function isNotificationTask(task) {
    return 'xlrelease.NotificationTask' === task.type;
  }

  function isScriptTask(task) {
    return 'xlrelease.ScriptTask' === task.type || 'xlrelease.GroovyScriptTask' === task.type || 'xlrelease.ExternalScriptTask' === task.type;
  }

  function isTaskGroup(task) {
    return isParallelGroup(task) || isSequentialGroup(task);
  }

  function isUnknownTask(task) {
    return "Unknown Type" === task.typeDisplayName;
  }

  function isParallelGroup(task) {
    return 'xlrelease.ParallelGroup' === task.type;
  }

  function isSequentialGroup(task) {
    return 'xlrelease.SequentialGroup' === task.type;
  }

  function isManualTask(task) {
    return 'xlrelease.Task' === task.type;
  }

  function isCustomScriptTask(task) {
    return 'xlrelease.CustomScriptTask' === task.type;
  }

  function isTaskGroupInProgress(task) {
    return isTaskGroup(task) && isTaskInProgress(task);
  }

  function isCreateReleaseTask(task) {
    return 'xlrelease.CreateReleaseTask' === task.type;
  }

  function isParallelGroupInProgress(task) {
    return isParallelGroup(task) && isTaskInProgress(task);
  }

  function isTaskGroupSkippableOrRetriable(group) {
    var subTasks = _.flattenDeep(getSubTasks(group));

    return isTaskGroup(group) && isTaskFailed(group) && _.every(subTasks, isTaskPlannedOrDoneInAdvance);
  }

  function canUserInputTaskBeCompleted(task) {
    return isUserInputTask(task) && isTaskInProgress(task) && areAllRequiredValuesPresent(task) && noInProgressVariableUpdate(task);
  }

  function someGateConditionUnchecked(task) {
    return _.some(task.conditions, {
      checked: false
    });
  }

  function someGateDependencyUnresolved(task) {
    return _.some(task.dependencies, {
      resolved: false
    });
  }

  function isGateClosed(task) {
    return isGateTask(task) && (someGateConditionUnchecked(task) || someGateDependencyUnresolved(task));
  }

  function hasOwner(task) {
    return angular.isDefined(task.owner) && task.owner !== null;
  }

  function hasTeam(task) {
    return angular.isDefined(task.team) && task.team !== null;
  }

  function updateTaskStatusTo(status, id, commentText) {
    var comment = {
      text: commentText
    };
    return Backend.post("tasks/".concat(id, "/").concat(status), comment);
  }

  function startTaskWithInput(id, variables) {
    return Backend.post("api/v1/tasks/".concat(tasks_service_Ids.toDomainId(id), "/start"), {
      variables: variables
    });
  }

  function updateReleaseVariable(variable) {
    VariablesService.updateReleaseVariable(variable);
  }

  function isAutomated(task) {
    return task.automated;
  }

  function getSubTasks(task) {
    if (isTaskGroup(task)) {
      return _.map(task.tasks, getSubTasks);
    }

    return [task];
  }

  function getAllSubTasks(task) {
    var subTasks = [];

    if (isTaskGroup(task)) {
      subTasks = _.map(task.tasks, getAllSubTasks);
    }

    return [subTasks, task];
  }

  function isDone(task) {
    return isStatusOneOf(task, 'COMPLETED', 'SKIPPED');
  }

  function isActive(task) {
    return isStatusOneOf(task, 'PENDING', 'PRECONDITION_IN_PROGRESS', 'WAITING_FOR_INPUT', 'IN_PROGRESS', 'QUEUED', 'FAILURE_HANDLER_QUEUED', 'ABORT_SCRIPT_QUEUED', 'FAILING', 'FAILED');
  }

  function isStatusOneOf(task) {
    return _.includes(arguments, task.status);
  }

  function canDelayTask(task) {
    return isTaskPlanned(task) || isTaskPending(task) || isTaskFailed(task) || isTaskWaitingForInput(task);
  }

  function isTaskDelayedDuringBlackout(task) {
    return task.delayDuringBlackout && canDelayTask(task);
  }

  function isTask(task) {
    return task.type !== 'xlrelease.ScmConnectedTemplate' && task.type !== 'xlrelease.Release' && task.type !== 'xlrelease.Phase';
  }

  function isTaskReadOnly(task) {
    return isTaskCompleted(task) || isTaskSkipped(task) || isTaskDoneInAdvance(task);
  }

  function isRemoveEnabled(task, release, container) {
    return canExecuteActionOnLockedTask(task, container) && !isTaskReadOnly(task) && !isTaskPending(task) && !isTaskWaitingForInput(task) && !isTaskInProgress(task) && !isTaskFailed(task) && !isParallelGroupInProgress(container) && !isTaskFailureHandlerInProgress(task) && !isTaskAbortScriptInProgress(task) && !isTaskFacetInProgress(task) && Authenticator.hasEditPermission(release);
  }

  function isDuplicateEnabled(task, release, container) {
    return canExecuteActionOnLockedTask(task, container) && (!isTaskReadOnly(task) || isTaskDoneInAdvance(task)) && Authenticator.hasEditPermission(release) && !isParallelGroupInProgress(container);
  }

  function hasPermissionToWorkOnTask(release, task) {
    return Authenticator.hasPermissionToWorkOnTask(release, task);
  }

  function canWorkOnReadOnlyTask(release, task) {
    return hasPermissionToWorkOnTask(release, task);
  }

  function canUpdateFailedStatus(task) {
    return isTaskFailed(task) && (isAutomated(task) || hasOwner(task) || hasTeam(task));
  }

  function canWorkOnTask(release, task) {
    if (isTaskReadOnly(task)) {
      return false;
    }

    return hasPermissionToWorkOnTask(release, task);
  }

  function canStartTask(release, task) {
    return !isTaskReadOnly(task) && (hasPermissionToWorkOnTask(release, task) || Authenticator.hasTaskTransitionPermission(release));
  }

  function canCompleteTask(release, task) {
    if (!isTaskGroup(task) && !isAutomated(task)) {
      var canPerformTaskTransition = !isTaskReadOnly(task) && (hasPermissionToWorkOnTask(release, task) || Authenticator.hasTaskTransitionPermission(release));

      if (isTaskPlanned(task) && tasks_service_ReleasesStatusService.isReleaseActive(release) && canPerformTaskTransition) {
        return canExecuteActionOnLockedTask(task) && canUpdatePlannedStatus(task) && !isGateClosed(task);
      }

      if (isTaskInProgress(task) && canUpdateInProgressStatus(task) && !isGateClosed(task) && canPerformTaskTransition) {
        return isUserInputTask(task) ? canUserInputTaskBeCompleted(task) : true;
      }
    }

    return false;
  }

  function canEditTask(release, task) {
    return Authenticator.hasEditTaskPermission(release) && !isTaskReadOnly(task) && task.editable;
  }

  function canEditTaskTitleAndDescription(release, task) {
    var isEditable = !isTaskReadOnly(task) && task.editable;
    return isEditable && (Authenticator.hasEditTaskPermission(release) || Authenticator.hasEditTaskDescription(release));
  }

  function canEditTaskDates(release, task) {
    var isEditable = !isTaskReadOnly(task) && task.editable;
    return isEditable && (Authenticator.hasEditTaskPermission(release) || Authenticator.hasEditTaskDatesPermission(release));
  }

  function canEditTaskFlag(release, task) {
    var isEditable = !isTaskReadOnly(task) && task.editable;
    return isEditable && (Authenticator.hasEditTaskPermission(release) || Authenticator.hasEditTaskFlagPermission(release));
  }

  function canEditTaskConfigurationPropertiesAndTaskNotInProgress(release, task) {
    return !isTaskInProgress(task) && canEditTaskConfigurationProperties(release, task);
  }

  function canEditTaskTags(release, task) {
    var hasPermissionToEditTaskTag = Authenticator.hasEditTaskPermission(release) || Authenticator.hasEditTaskTagsPermission(release);
    return !isTaskReadOnly(task) && task.editable && hasPermissionToEditTaskTag;
  }

  function canEditTaskConfigurationProperties(release, task) {
    return task.editable && (Authenticator.hasEditTaskConfigurationPropertiesPermission(release) || canEditTask(release, task));
  }

  function canEditTaskAttachment(release, task) {
    return task.editable && (Authenticator.hasEditTaskAttachmentPermission(release) || canEditTask(release, task));
  }

  function canEditTaskConfigurationFacet(release) {
    return Authenticator.hasEditTaskConfigurationFacetPermission(release);
  }

  function canEditTaskScript(release, task) {
    return !isTaskInProgress(task) && task.editable && (Authenticator.hasEditTaskScriptPermission(release) || canEditTask(release, task));
  }

  function canEditBlackout(release, task) {
    return Authenticator.hasEditBlackoutPermission(release) || canEditTask(release, task);
  }

  function canEditFailureHandler(release, task) {
    var canWorkOnTask = !isTaskReadOnly(task) && task.editable;
    return canWorkOnTask && (Authenticator.hasEditFailureHandlerPermission(release) || release.status !== 'TEMPLATE' && Authenticator.hasEditTaskPermission(release));
  }

  function canEditPrecondition(release, task) {
    var canWorkOnTask = !isTaskReadOnly(task) && task.editable;
    return canWorkOnTask && (Authenticator.hasEditPreconditionPermission(release) || release.status !== 'TEMPLATE' && Authenticator.hasEditTaskPermission(release));
  }

  function areTaskPropertiesReadonly(release, task) {
    return !canEditTask(release, task) || isTaskInProgress(task);
  }

  function canUpdateCommentOnTask(release, task, comment) {
    return (canEditTask(release, task) || comment.author.username === Authenticator.getUsername()) && !release.archived;
  }

  function canAddTask(release, taskGroup) {
    if (isLocked(taskGroup) || !Authenticator.hasEditPermission(release)) {
      return false;
    }

    if (isParallelGroup(taskGroup)) {
      return isTaskPlanned(taskGroup);
    }

    if (isSequentialGroup(taskGroup)) {
      return !isTaskReadOnly(taskGroup);
    }

    return false;
  }

  function canEditWaitForScheduledStartDate(release) {
    return Authenticator.hasEditTaskOrEditDatesPermission(release);
  }

  function canEditEnvironmentAvailability(release) {
    return Authenticator.hasEditTaskOrEditBlackoutPermission(release);
  }

  function addTask(container, taskForm) {
    return Backend.post("tasks/".concat(container.id), taskForm).then(function (addedTaskResp) {
      var addedTask = addedTaskResp.data;

      if (taskForm.taskType === 'xlrelease.ParallelGroup' || taskForm.taskType === 'xlrelease.SequentialGroup') {
        addedTask.wasJustAdded = true;
      }

      container.tasks.push(addedTask);
      return addedTask;
    });
  }

  function deleteTask(container, taskToDelete) {
    return Backend.del("tasks/".concat(taskToDelete.id)).then(function () {
      container.tasks = _.reject(container.tasks, {
        id: taskToDelete.id
      });
    });
  }

  function updateTask(task) {
    var taskForm = toTaskFullView(task);
    return Backend.put("tasks/".concat(taskForm.id), taskForm);
  }

  function duplicateTask(release, task, container) {
    return Backend.put("releases/".concat(release.id, "/tasks/duplicate/").concat(task.id)).then(function (duplicatedTaskResp) {
      var duplicatedTask = duplicatedTaskResp.data;

      _.forEach(container.tasks, function (aTask, index) {
        if (aTask.id === task.id) {
          container.tasks.splice(index + 1, 0, duplicatedTask);
        }
      });

      return duplicatedTask;
    });
  }

  function changeTaskType(container, task, convertToType) {
    task.disabledInView = true;
    return Backend.post("tasks/".concat(task.id, "/changeType?targetType=").concat(convertToType)).then(function (newTaskResp) {
      task.disabledInView = false;
      var newTask = newTaskResp.data;
      newTask.$$hashKey = task.$$hashKey; //otherwise angular data-binding will be broken

      container.tasks[container.tasks.indexOf(task)] = newTask;
      return newTask;
    }).catch(function () {
      return task.disabledInView = false;
    });
  }

  function getTaskVariables(task) {
    return Backend.get("api/v1/tasks/".concat(tasks_service_Ids.toDomainId(task.id), "/variables"));
  }

  function isAssignedToUser(task, user) {
    return hasOwner(task) && user && task.owner.username.toLowerCase() === user.username.toLowerCase();
  }

  function canAssignTaskToCurrentUser(task, release) {
    var taskNotAssignedToCurrentUser = !isAssignedToUser(task, UserProfile.getCurrentUser());
    var taskIsEditable = !isTaskReadOnly(task) && task.editable;
    var userHasReassignTaskPermission = Authenticator.hasEditTaskPermission(release) || Authenticator.hasReassignTaskPermission(release);
    var userInTeam = release.security.teams.includes(task.team);
    return taskNotAssignedToCurrentUser && taskIsEditable && (Authenticator.isAdmin() || userHasReassignTaskPermission && !isLocked(task) || userInTeam);
  }

  function canReassignTask(release, task) {
    var taskIsNotReadOnly = !isTaskReadOnly(task);
    var userHasReassignPermission = Authenticator.hasEditTaskPermission(release) || Authenticator.hasReassignTaskPermission(release);
    return canExecuteActionOnLockedTask(task) && userHasReassignPermission && taskIsNotReadOnly && task.editable;
  }

  function canExecuteActionOnLockedTask(task, container) {
    if (angular.isDefined(container) && isTaskGroup(container) && container.locked) {
      return false;
    }

    return !task.locked;
  }

  function assignToCurrentUser(task) {
    task.owner = UserProfile.getCurrentUser();
    return Backend.put("tasks/".concat(task.id, "/owner"), toTaskFullView(task)).then(function () {
      TaskDetailsUpdates.assigneeChanged = true;
    });
  }

  function getTask(taskId) {
    return Backend.get("tasks/".concat(taskId));
  }

  function toTaskFullView(task) {
    return {
      checkAttributes: task.checkAttributes,
      cc: task.cc,
      bcc: task.bcc,
      replyTo: task.replyTo,
      from: task.from,
      mailPriority: task.mailPriority,
      addresses: task.addresses,
      body: task.body,
      createdReleaseId: task.createdReleaseId,
      delayDuringBlackout: task.delayDuringBlackout,
      deploymentPackage: task.deploymentPackage,
      description: task.description,
      dueDate: task.dueDate,
      environment: task.environment,
      failureHandler: task.failureHandler,
      taskFailureHandlerEnabled: task.taskFailureHandlerEnabled,
      taskRecoverOp: task.taskRecoverOp,
      flag: task.flag,
      gateId: task.gateId,
      id: task.id,
      inputProperties: task.inputProperties,
      newReleaseTitle: task.newReleaseTitle,
      outputProperties: task.outputProperties,
      owner: task.owner,
      password: task.password,
      plannedDuration: task.plannedDuration,
      precondition: task.precondition,
      releaseTags: task.releaseTags,
      riskProfileId: task.riskProfileId,
      scheduledStartDate: task.scheduledStartDate,
      script: task.script,
      scriptDefinitionType: task.scriptDefinitionType,
      server: task.server,
      startRelease: task.startRelease,
      subject: task.subject,
      tags: task.tags,
      team: task.team,
      templateId: task.templateId,
      folderId: task.folderId,
      title: task.title,
      type: task.type,
      username: task.username,
      variableMapping: task.variableMapping,
      variables: VariablesService.toSerializableVariables(task.variables),
      waitForScheduledStartDate: task.waitForScheduledStartDate,
      ignoreScriptVariableInterpolation: task.ignoreScriptVariableInterpolation,
      keepPreviousOutputPropertiesOnRetry: angular.isDefined(task.keepPreviousOutputPropertiesOnRetry) ? task.keepPreviousOutputPropertiesOnRetry : false
    };
  }

  function canUpdateInProgressStatus(task) {
    return isTaskInProgress(task) && !isAutomated(task) && (hasOwner(task) || hasTeam(task));
  }

  function canUpdatePlannedStatus(task) {
    return isTaskPlanned(task) && (hasOwner(task) || hasTeam(task));
  }

  function canSkipTask(release, task) {
    if (!task.locked && !isUserInputTask(task)) {
      if (isTaskInProgress(task) && !isAutomated(task)) {
        var canPerformTaskTransition = canUpdateInProgressStatus(task) && !isTaskReadOnly(task);
        return canPerformTaskTransition && (hasPermissionToWorkOnTask(release, task) || Authenticator.hasTaskTransitionPermission(release));
      }

      if (isTaskPlanned(task) && tasks_service_ReleasesStatusService.isReleaseActive(release) && !isTaskGroup(task)) {
        var _canPerformTaskTransition = canUpdatePlannedStatus(task) && !isTaskReadOnly(task);

        return _canPerformTaskTransition && (hasPermissionToWorkOnTask(release, task) || Authenticator.hasTaskTransitionPermission(release));
      }

      if (isTaskFailed(task) && (!isTaskGroup(task) || isTaskGroupSkippableOrRetriable(task))) {
        var _canPerformTaskTransition2 = canUpdateFailedStatus(task) && !isTaskReadOnly(task) && (!isTaskGroup(task) || isTaskGroupSkippableOrRetriable(task));

        return _canPerformTaskTransition2 && (hasPermissionToWorkOnTask(release, task) || Authenticator.hasTaskTransitionPermission(release));
      }
    } else {
      return false;
    }
  }

  function canFailTask(release, task) {
    if (!isTaskReadOnly(task) && isTaskInProgress(task) && !isAutomated(task) && !isTaskGroup(task)) {
      var canPerformTaskTransition = canUpdateInProgressStatus(task) && !isTaskReadOnly(task);
      return canPerformTaskTransition && (hasPermissionToWorkOnTask(release, task) || Authenticator.hasTaskTransitionPermission(release));
    }

    return false;
  }

  function canRetryTask(release, task) {
    if (isTaskFailed(task) && (!isTaskGroup(task) && !isUnknownTask(task) || isTaskGroupSkippableOrRetriable(task))) {
      var canPerformTaskTransition = canUpdateFailedStatus(task) && !isTaskReadOnly(task) && (!isTaskGroup(task) || isTaskGroupSkippableOrRetriable(task));
      return canPerformTaskTransition && (Authenticator.hasTaskTransitionPermission(release) || Authenticator.isAdminOr(task.releaseOwner) || hasPermissionToWorkOnTask(release, task));
    }

    return false;
  }

  function canAbortTask(release, task) {
    if (isInProgressScriptTask(task) || isQueuedScriptTask(task) || isTaskPreconditionInProgress(task) || isTaskFailureHandlerInProgress(task) || isTaskFacetInProgress(task) || isTaskAbortScriptInProgress(task)) {
      var canPerformTaskTransition = !isTaskReadOnly(task);
      return canPerformTaskTransition && (hasPermissionToWorkOnTask(release, task) || Authenticator.hasTaskTransitionPermission(release));
    }

    return false;
  }

  function canReopenTask(release, task) {
    if (tasks_service_ReleasesStatusService.isReleaseActive(release) && isTaskDoneInAdvance(task) && !isTaskGroup(task)) {
      return canWorkOnReadOnlyTask(release, task) || Authenticator.hasTaskTransitionPermission(release);
    }

    return false;
  }

  function canWorkOnFailedTask(release, task) {
    return canUpdateFailedStatus(task) && canWorkOnTask(release, task) && (!isTaskGroup(task) || isTaskGroupSkippableOrRetriable(task));
  }

  function isInProgressScriptTask(task) {
    return (isScriptTask(task) || isCustomScriptTask(task)) && isTaskInProgress(task);
  }

  function isQueuedScriptTask(task) {
    return (isScriptTask(task) || isCustomScriptTask(task)) && isTaskQueued(task);
  }

  var isLocked = function isLocked(task) {
    return task.locked;
  };

  var lock = function lock(taskId) {
    return Backend.put("api/v1/tasks/".concat(tasks_service_Ids.toDomainId(taskId), "/lock"));
  };

  var unlock = function unlock(taskId) {
    return Backend.del("api/v1/tasks/".concat(tasks_service_Ids.toDomainId(taskId), "/lock"));
  };

  var toInternalId = function toInternalId(releaseId) {
    return tasks_service_Ids.toInternalId(releaseId);
  };

  var hasDeploymentFacet = function hasDeploymentFacet(task) {
    return task.facets.filter(function (f) {
      return f.type === 'udm.DeploymentTaskFacet';
    }).length > 0;
  };

  var getLatestTaskActivityLog = function getLatestTaskActivityLog(releaseId, taskId) {
    var filters = {
      "important": false,
      "releaseEdit": false,
      "taskEdit": false,
      "comments": false,
      "lifecycle": true,
      "reassign": false,
      "security": false,
      "other": false,
      "dateAsc": false,
      "filter": "",
      "targetId": taskId
    };
    return Backend.post("activity/".concat(releaseId, "/logs/search"), filters).then(function (resp) {
      return _.head(resp.data);
    });
  };

  return {
    toInternalId: toInternalId,
    hasOwner: hasOwner,
    hasTeam: hasTeam,
    isTaskPlanned: isTaskPlanned,
    isTaskPending: isTaskPending,
    isTaskInProgress: isTaskInProgress,
    isTaskQueued: isTaskQueued,
    isTaskFacetInProgress: isTaskFacetInProgress,
    isTaskPreconditionInProgress: isTaskPreconditionInProgress,
    isTaskFailureHandlerInProgress: isTaskFailureHandlerInProgress,
    isTaskAbortScriptInProgress: isTaskAbortScriptInProgress,
    isTaskOrPreconditionInProgress: isTaskOrPreconditionInProgress,
    isTaskCompleted: isTaskCompleted,
    isTaskCompletedInAdvance: isTaskCompletedInAdvance,
    isTaskSkippedInAdvance: isTaskSkippedInAdvance,
    isTaskDraggable: isTaskDraggable,
    isTaskGroupDroppable: isTaskGroupDroppable,
    isTaskSkipped: isTaskSkipped,
    isTaskFailed: isTaskFailed,
    isTaskFailing: isTaskFailing,
    isTaskDoneInAdvance: isTaskDoneInAdvance,
    isTaskWaitingForInput: isTaskWaitingForInput,
    isUserInputTask: isUserInputTask,
    isAutomated: isAutomated,
    canDelayTask: canDelayTask,
    isTaskDelayedDuringBlackout: isTaskDelayedDuringBlackout,
    isGateTask: isGateTask,
    isNotificationTask: isNotificationTask,
    isScriptTask: isScriptTask,
    isCustomScriptTask: isCustomScriptTask,
    isManualTask: isManualTask,
    isUnknownTask: isUnknownTask,
    isTaskGroup: isTaskGroup,
    isParallelGroup: isParallelGroup,
    isSequentialGroup: isSequentialGroup,
    isTaskGroupInProgress: isTaskGroupInProgress,
    isCreateReleaseTask: isCreateReleaseTask,
    isParallelGroupInProgress: isParallelGroupInProgress,
    isGateClosed: isGateClosed,
    getSubTasks: getSubTasks,
    getAllSubTasks: getAllSubTasks,
    isTaskGroupSkippableOrRetriable: isTaskGroupSkippableOrRetriable,
    canUserInputTaskBeCompleted: canUserInputTaskBeCompleted,
    areAllRequiredValuesPresent: areAllRequiredValuesPresent,
    isActive: isActive,
    isDone: isDone,
    isTaskReadOnly: isTaskReadOnly,
    isRemoveEnabled: isRemoveEnabled,
    isDuplicateEnabled: isDuplicateEnabled,
    hasPermissionToWorkOnTask: hasPermissionToWorkOnTask,
    canUpdateFailedStatus: canUpdateFailedStatus,
    canWorkOnReadOnlyTask: canWorkOnReadOnlyTask,
    canWorkOnTask: canWorkOnTask,
    canEditTask: canEditTask,
    canEditTaskConfigurationProperties: canEditTaskConfigurationProperties,
    canEditTaskAttachment: canEditTaskAttachment,
    canEditTaskConfigurationFacet: canEditTaskConfigurationFacet,
    canEditTaskScript: canEditTaskScript,
    canEditTaskConfigurationPropertiesAndTaskNotInProgress: canEditTaskConfigurationPropertiesAndTaskNotInProgress,
    canEditBlackout: canEditBlackout,
    canEditFailureHandler: canEditFailureHandler,
    canEditPrecondition: canEditPrecondition,
    canReassignTask: canReassignTask,
    areTaskPropertiesReadonly: areTaskPropertiesReadonly,
    canUpdateCommentOnTask: canUpdateCommentOnTask,
    canAddTask: canAddTask,
    canEditWaitForScheduledStartDate: canEditWaitForScheduledStartDate,
    canEditEnvironmentAvailability: canEditEnvironmentAvailability,
    addTask: addTask,
    deleteTask: deleteTask,
    duplicateTask: duplicateTask,
    updateTask: updateTask,
    changeTaskType: changeTaskType,
    startTaskWithInput: startTaskWithInput,
    getTaskVariables: getTaskVariables,
    assignToCurrentUser: assignToCurrentUser,
    getTask: getTask,
    isAssignedToUser: isAssignedToUser,
    canAssignTaskToCurrentUser: canAssignTaskToCurrentUser,
    toTaskFullView: toTaskFullView,
    hasConfigurationUri: hasConfigurationUri,
    getConfigurationUri: getConfigurationUri,
    canCompleteTask: canCompleteTask,
    canStartTask: canStartTask,
    canSkipTask: canSkipTask,
    canFailTask: canFailTask,
    canRetryTask: canRetryTask,
    canAbortTask: canAbortTask,
    canReopenTask: canReopenTask,
    canEditTaskTags: canEditTaskTags,
    canExecuteActionOnLockedTask: canExecuteActionOnLockedTask,
    canEditTaskTitleAndDescription: canEditTaskTitleAndDescription,
    canEditTaskDates: canEditTaskDates,
    canEditTaskFlag: canEditTaskFlag,
    updateReleaseVariable: updateReleaseVariable,
    isTaskAborted: function isTaskAborted(task) {
      return 'ABORTED' === task.status;
    },
    canUpdateInProgressStatus: canUpdateInProgressStatus,
    canWorkOnFailedTask: canWorkOnFailedTask,
    canUpdatePlannedStatus: canUpdatePlannedStatus,
    isInProgressScriptTask: isInProgressScriptTask,
    isQueuedScriptTask: isQueuedScriptTask,
    isStatusUpdatable: function isStatusUpdatable(task) {
      return isTaskInProgress(task) && !isAutomated(task) && (hasOwner(task) || hasTeam(task));
    },
    completeTask: function completeTask(taskId, commentText) {
      return updateTaskStatusTo('complete', taskId, commentText);
    },
    failTask: function failTask(taskId, commentText) {
      return updateTaskStatusTo('fail', taskId, commentText);
    },
    abortTask: function abortTask(taskId, commentText) {
      return updateTaskStatusTo('abort', taskId, commentText);
    },
    skipTask: function skipTask(taskId, commentText) {
      return updateTaskStatusTo('skip', taskId, commentText);
    },
    retryTask: function retryTask(taskId, commentText) {
      return updateTaskStatusTo('retry', taskId, commentText);
    },
    cancelTask: function cancelTask(taskId, commentText) {
      return updateTaskStatusTo('cancel', taskId, commentText);
    },
    startNow: function startNow(taskId, commentText) {
      return updateTaskStatusTo('startNow', taskId, commentText);
    },
    reopenTask: function reopenTask(taskId, commentText) {
      return updateTaskStatusTo('reopen', taskId, commentText);
    },
    isTaskDelayed: function isTaskDelayed(task) {
      if (!isTaskPlanned(task)) return false;
      return tasks_service_DateService.isOverdue(task.scheduledStartDate) || tasks_service_DateService.isOverdue(task.dueDate);
    },
    isAssignedToTeam: function isAssignedToTeam(task, team) {
      return hasTeam(task) && task.team === team;
    },
    isTask: isTask,
    isChangeTypeEnabled: function isChangeTypeEnabled(task, release, container) {
      return canExecuteActionOnLockedTask(task, container) && isRemoveEnabled(task, release, container) && !isTaskGroup(task);
    },
    isOfType: function isOfType(task, taskDefinition) {
      return taskDefinition.typeName === task.type || taskDefinition.typeName === task.scriptDefinitionType;
    },
    isValidCollapsedState: function isValidCollapsedState(state) {
      return _.isBoolean(state);
    },
    isLocked: isLocked,
    lock: lock,
    unlock: unlock,
    hasDeploymentFacet: hasDeploymentFacet,
    getLatestTaskActivityLog: getLatestTaskActivityLog
  };
}

TaskService.$inject = ['Backend', 'Authenticator', 'UserProfile', 'TaskDetailsUpdates', 'VariablesService'];
angular.module('xlrelease').constant('TaskConstants', {
  LIMIT_TASKS_HINT: 50
});
angular.module('xlrelease').factory('TasksService', TaskService);
// EXTERNAL MODULE: ./core/xlr-ui/app/js/tasks/user-input-details-controller.js
var user_input_details_controller = __webpack_require__(1425);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/templates/templates-controller.js
var templates_controller = __webpack_require__(1426);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/templates/templates-service.js



(function () {
  'use strict';

  var DEFAULT_TEMPLATE_LIST_SIZE = 100;
  var DEFAULT_TEMPLATE_LIST_DEPTH = 1;

  var TemplatesService = /*#__PURE__*/function () {
    function TemplatesService(Backend) {
      classCallCheck_default()(this, TemplatesService);

      this._backend = Backend;
    }

    createClass_default()(TemplatesService, [{
      key: "getAll",
      value: function getAll() {
        return this._backend.post('releases/templates/search', {}, {
          params: {
            numberbypage: DEFAULT_TEMPLATE_LIST_SIZE,
            depth: DEFAULT_TEMPLATE_LIST_DEPTH
          }
        });
      }
    }, {
      key: "getById",
      value: function getById(releaseId) {
        return this._backend.get("releases/".concat(releaseId));
      }
    }, {
      key: "getTemplateTitleById",
      value: function getTemplateTitleById(templateId) {
        return this._backend.get('releases/template/search', {
          params: {
            matchTemplate: templateId
          }
        });
      }
    }, {
      key: "getAllIds",
      value: function getAllIds(matchTitle) {
        return this._backend.get('releases/templates/search', {
          params: {
            numberbypage: DEFAULT_TEMPLATE_LIST_SIZE,
            matchTemplate: matchTitle
          }
        });
      }
    }, {
      key: "getAllIdsWithPermission",
      value: function getAllIdsWithPermission(permission) {
        var folderId = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
        var params = {
          params: {
            numberbypage: DEFAULT_TEMPLATE_LIST_SIZE,
            permission: permission
          }
        };

        if (!_.isUndefined(folderId)) {
          params.params.folderId = folderId;
        }

        return this._backend.get('releases/templates/search', params);
      }
    }, {
      key: "search",
      value: function search(filters, config) {
        return this._backend.post('releases/templates/search', filters, config);
      }
    }, {
      key: "create",
      value: function create(template) {
        var templateForm = {
          title: template.title,
          description: template.description,
          tags: template.tags,
          scheduledStartDate: template.scheduledStartDate,
          dueDate: template.dueDate,
          plannedDuration: template.plannedDuration,
          abortOnFailure: template.abortOnFailure,
          allowPasswordsInAllFields: template.allowPasswordsInAllFields,
          disableNotifications: template.disableNotifications,
          allowConcurrentReleasesFromTrigger: template.allowConcurrentReleasesFromTrigger,
          scriptUsername: template.scriptUsername,
          scriptUserPassword: template.scriptUserPassword,
          variables: template.variables,
          syntheticProperties: template.syntheticProperties,
          parentId: template.parentId,
          variableMapping: template.variableMapping
        };
        return this._backend.post('releases/templates', templateForm);
      }
    }, {
      key: "update",
      value: function update(templateId, template) {
        var templateForm = {
          title: template.title,
          description: template.description,
          tags: template.tags,
          scheduledStartDate: template.scheduledStartDate,
          dueDate: template.dueDate,
          plannedDuration: template.plannedDuration,
          abortOnFailure: template.abortOnFailure,
          allowPasswordsInAllFields: template.allowPasswordsInAllFields,
          disableNotifications: template.disableNotifications,
          allowConcurrentReleasesFromTrigger: template.allowConcurrentReleasesFromTrigger,
          scriptUsername: template.scriptUsername,
          scriptUserPassword: template.scriptUserPassword,
          variables: template.variables,
          syntheticProperties: template.syntheticProperties,
          variableMapping: template.variableMapping
        };
        return this._backend.put('releases/templates/' + templateId, templateForm);
      }
    }]);

    return TemplatesService;
  }();

  TemplatesService.$inject = ['Backend'];
  angular.module('xlrelease').service('TemplatesService', TemplatesService);
})();
// EXTERNAL MODULE: ./core/xlr-ui/app/js/upload/upload-controller.js
var upload_controller = __webpack_require__(1427);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/upload/upload-directive.js
var upload_directive = __webpack_require__(1428);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/upload/upload-service.js
var upload_service = __webpack_require__(1429);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/upload/content-type-service.js




var content_type_service_ContentTypeService = /*#__PURE__*/function () {
  function ContentTypeService(Backend) {
    classCallCheck_default()(this, ContentTypeService);

    this._Backend = Backend;
  }

  createClass_default()(ContentTypeService, [{
    key: "getContentTypesForImage",
    value: function getContentTypesForImage() {
      return this._Backend.get('settings/content-type/image');
    }
  }]);

  return ContentTypeService;
}();

defineProperty_default()(content_type_service_ContentTypeService, "$inject", ['Backend']);

angular.module('xlrelease').service('ContentTypeService', content_type_service_ContentTypeService);
// EXTERNAL MODULE: ./core/xlr-ui/app/js/util/bootstrap-modal-patch.js
var bootstrap_modal_patch = __webpack_require__(553);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/util/ci-manager.js
var ci_manager = __webpack_require__(1430);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/util/cis-loader.js
var cis_loader = __webpack_require__(1431);

// CONCATENATED MODULE: ./core/xlr-ui/app/js/util/client-settings.js


function client_settings_ownKeys(object, enumerableOnly) { var keys = Ob