/*
 * Decompiled with CFR 0.152.
 */
package net.conjur.api;

import java.io.Serializable;
import java.net.URI;
import net.conjur.util.Args;

public class Endpoints
implements Serializable {
    private static final String URL_PROPERTY_NAME = "CONJUR_APPLIANCE_URL";
    private static final String ACCOUNT_PROPERTY_NAME = "CONJUR_ACCOUNT";
    private final URI authnUri;
    private final URI secretsUri;

    public Endpoints(URI authnUri, URI secretsUri) {
        this.authnUri = Args.notNull(authnUri, "authnUri");
        this.secretsUri = Args.notNull(secretsUri, "secretsUri");
    }

    public Endpoints(String authnUri, String secretsUri) {
        this(URI.create(authnUri), URI.create(secretsUri));
    }

    public URI getAuthnUri() {
        return this.authnUri;
    }

    public URI getSecretsUri() {
        return this.secretsUri;
    }

    public static Endpoints fromSystemProperties() {
        String account = System.getProperty(ACCOUNT_PROPERTY_NAME);
        return new Endpoints(Endpoints.getServiceUri("authn", account), Endpoints.getServiceUri("secrets", account, "variable"));
    }

    private static URI getServiceUri(String service, String accountName) {
        return Endpoints.getServiceUri(service, accountName, "");
    }

    private static URI getServiceUri(String service, String accountName, String path) {
        return URI.create(String.format("%s/%s/%s/%s", System.getProperty(URL_PROPERTY_NAME), service, accountName, path));
    }

    public String toString() {
        return "Endpoints{authnUri=" + this.authnUri + "secretsUri=" + this.secretsUri + '}';
    }
}

