/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.spring.repository;

import com.xebialabs.xlrelease.db.sql.DatabaseInfo;
import com.xebialabs.xlrelease.spring.repository.CustomJdbcIndexedSessionRepository;
import org.springframework.session.config.SessionRepositoryCustomizer;

public class CustomJdbcIndexedSessionRepositoryCustomizer
implements SessionRepositoryCustomizer<CustomJdbcIndexedSessionRepository> {
    private static final String CREATE_SESSION_ATTRIBUTE_QUERY = "INSERT INTO %TABLE_NAME%_ATTRIBUTES (SESSION_PRIMARY_ID, ATTRIBUTE_NAME, ATTRIBUTE_BYTES) VALUES (?, ?, ?)";
    private static final String DB2_CREATE_SESSION_ATTRIBUTE_QUERY = "MERGE INTO %TABLE_NAME%_ATTRIBUTES SA USING (     VALUES (?, ?, ?) ) A (SESSION_PRIMARY_ID, ATTRIBUTE_NAME, ATTRIBUTE_BYTES) ON (SA.SESSION_PRIMARY_ID = A.SESSION_PRIMARY_ID and SA.ATTRIBUTE_NAME = A.ATTRIBUTE_NAME) WHEN MATCHED THEN     UPDATE SET ATTRIBUTE_BYTES = A.ATTRIBUTE_BYTES WHEN NOT MATCHED THEN     INSERT (SESSION_PRIMARY_ID, ATTRIBUTE_NAME, ATTRIBUTE_BYTES)     VALUES (A.SESSION_PRIMARY_ID, A.ATTRIBUTE_NAME, A.ATTRIBUTE_BYTES)";
    private static final String MYSQL_CREATE_SESSION_ATTRIBUTE_QUERY = "INSERT INTO %TABLE_NAME%_ATTRIBUTES (SESSION_PRIMARY_ID, ATTRIBUTE_NAME, ATTRIBUTE_BYTES) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE ATTRIBUTE_BYTES = VALUES(ATTRIBUTE_BYTES)";
    private static final String ORACLE_CREATE_SESSION_ATTRIBUTE_QUERY = "MERGE INTO %TABLE_NAME%_ATTRIBUTES SA USING (     SELECT ? AS SESSION_PRIMARY_ID, ? AS ATTRIBUTE_NAME, ? AS ATTRIBUTE_BYTES     FROM DUAL ) A ON (SA.SESSION_PRIMARY_ID = A.SESSION_PRIMARY_ID and SA.ATTRIBUTE_NAME = A.ATTRIBUTE_NAME) WHEN MATCHED THEN     UPDATE SET ATTRIBUTE_BYTES = A.ATTRIBUTE_BYTES WHEN NOT MATCHED THEN     INSERT (SESSION_PRIMARY_ID, ATTRIBUTE_NAME, ATTRIBUTE_BYTES)     VALUES (A.SESSION_PRIMARY_ID, A.ATTRIBUTE_NAME, A.ATTRIBUTE_BYTES)";
    private static final String POSTGRES_CREATE_SESSION_ATTRIBUTE_QUERY = "INSERT INTO %TABLE_NAME%_ATTRIBUTES (SESSION_PRIMARY_ID, ATTRIBUTE_NAME, ATTRIBUTE_BYTES) VALUES (?, ?, ?) ON CONFLICT (SESSION_PRIMARY_ID, ATTRIBUTE_NAME) DO UPDATE SET ATTRIBUTE_BYTES = EXCLUDED.ATTRIBUTE_BYTES";
    private static final String MSSQL_CREATE_SESSION_ATTRIBUTE_QUERY = "MERGE INTO %TABLE_NAME%_ATTRIBUTES SA USING (     VALUES (?, ?, ?) ) A (SESSION_PRIMARY_ID, ATTRIBUTE_NAME, ATTRIBUTE_BYTES) ON (SA.SESSION_PRIMARY_ID = A.SESSION_PRIMARY_ID and SA.ATTRIBUTE_NAME = A.ATTRIBUTE_NAME) WHEN MATCHED THEN     UPDATE SET ATTRIBUTE_BYTES = A.ATTRIBUTE_BYTES WHEN NOT MATCHED THEN     INSERT (SESSION_PRIMARY_ID, ATTRIBUTE_NAME, ATTRIBUTE_BYTES)     VALUES (A.SESSION_PRIMARY_ID, A.ATTRIBUTE_NAME, A.ATTRIBUTE_BYTES);";
    private final DatabaseInfo dbInfo;

    public CustomJdbcIndexedSessionRepositoryCustomizer(DatabaseInfo dbInfo) {
        this.dbInfo = dbInfo;
    }

    public void customize(CustomJdbcIndexedSessionRepository sessionRepository) {
        String createSessionAttributeQuery = this.dbInfo instanceof DatabaseInfo.Db2 ? DB2_CREATE_SESSION_ATTRIBUTE_QUERY : (this.dbInfo instanceof DatabaseInfo.Oracle ? ORACLE_CREATE_SESSION_ATTRIBUTE_QUERY : (this.dbInfo instanceof DatabaseInfo.MsSqlServer ? MSSQL_CREATE_SESSION_ATTRIBUTE_QUERY : (this.dbInfo instanceof DatabaseInfo.MySql ? MYSQL_CREATE_SESSION_ATTRIBUTE_QUERY : (this.dbInfo instanceof DatabaseInfo.PostgreSql ? POSTGRES_CREATE_SESSION_ATTRIBUTE_QUERY : CREATE_SESSION_ATTRIBUTE_QUERY))));
        sessionRepository.setCreateSessionAttributeQuery(createSessionAttributeQuery);
    }
}

