/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.batching;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.batching.BatchEntry;
import com.google.api.gax.batching.Batcher;
import com.google.api.gax.batching.BatcherStats;
import com.google.api.gax.batching.BatchingDescriptor;
import com.google.api.gax.batching.BatchingException;
import com.google.api.gax.batching.BatchingRequestBuilder;
import com.google.api.gax.batching.BatchingSettings;
import com.google.api.gax.batching.FlowController;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.MoreExecutors;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

@BetaApi(value="The surface for batching is not stable yet and may change in the future.")
@InternalApi(value="For google-cloud-java client use only")
public class BatcherImpl<ElementT, ElementResultT, RequestT, ResponseT>
implements Batcher<ElementT, ElementResultT> {
    private static final Logger LOG = Logger.getLogger(BatcherImpl.class.getName());
    private final BatchingDescriptor<ElementT, ElementResultT, RequestT, ResponseT> batchingDescriptor;
    private final UnaryCallable<RequestT, ResponseT> unaryCallable;
    private final RequestT prototype;
    private final BatchingSettings batchingSettings;
    private final BatcherReference currentBatcherReference;
    private Batch<ElementT, ElementResultT, RequestT, ResponseT> currentOpenBatch;
    private final AtomicInteger numOfOutstandingBatches = new AtomicInteger(0);
    private final Object flushLock = new Object();
    private final Object elementLock = new Object();
    private final Future<?> scheduledFuture;
    private volatile boolean isClosed = false;
    private final BatcherStats batcherStats = new BatcherStats();
    private final FlowController flowController;

    public BatcherImpl(BatchingDescriptor<ElementT, ElementResultT, RequestT, ResponseT> batchingDescriptor, UnaryCallable<RequestT, ResponseT> unaryCallable, RequestT prototype, BatchingSettings batchingSettings, ScheduledExecutorService executor) {
        this(batchingDescriptor, unaryCallable, prototype, batchingSettings, executor, null);
    }

    public BatcherImpl(BatchingDescriptor<ElementT, ElementResultT, RequestT, ResponseT> batchingDescriptor, UnaryCallable<RequestT, ResponseT> unaryCallable, RequestT prototype, BatchingSettings batchingSettings, ScheduledExecutorService executor, @Nullable FlowController flowController) {
        this.batchingDescriptor = (BatchingDescriptor)Preconditions.checkNotNull(batchingDescriptor, (Object)"batching descriptor cannot be null");
        this.unaryCallable = (UnaryCallable)Preconditions.checkNotNull(unaryCallable, (Object)"callable cannot be null");
        this.prototype = Preconditions.checkNotNull(prototype, (Object)"request prototype cannot be null");
        this.batchingSettings = (BatchingSettings)Preconditions.checkNotNull((Object)batchingSettings, (Object)"batching setting cannot be null");
        Preconditions.checkNotNull((Object)executor, (Object)"executor cannot be null");
        if (flowController == null) {
            flowController = new FlowController(batchingSettings.getFlowControlSettings());
        }
        if (flowController.getLimitExceededBehavior() != FlowController.LimitExceededBehavior.Ignore) {
            Preconditions.checkArgument((flowController.getMaxOutstandingElementCount() == null || batchingSettings.getElementCountThreshold() == null || flowController.getMaxOutstandingElementCount() >= batchingSettings.getElementCountThreshold() ? 1 : 0) != 0, (Object)"If throttling and batching on element count are enabled, FlowController#maxOutstandingElementCount must be greater or equal to elementCountThreshold");
            Preconditions.checkArgument((flowController.getMaxOutstandingRequestBytes() == null || batchingSettings.getRequestByteThreshold() == null || flowController.getMaxOutstandingRequestBytes() >= batchingSettings.getRequestByteThreshold() ? 1 : 0) != 0, (Object)"If throttling and batching on request bytes are enabled, FlowController#maxOutstandingRequestBytes must be greater or equal to requestByteThreshold");
        }
        this.flowController = flowController;
        this.currentOpenBatch = new Batch(prototype, batchingDescriptor, batchingSettings, this.batcherStats);
        if (batchingSettings.getDelayThreshold() != null) {
            long delay = batchingSettings.getDelayThreshold().toMillis();
            PushCurrentBatchRunnable runnable = new PushCurrentBatchRunnable(this);
            this.scheduledFuture = executor.scheduleWithFixedDelay(runnable, delay, delay, TimeUnit.MILLISECONDS);
        } else {
            this.scheduledFuture = Futures.immediateCancelledFuture();
        }
        this.currentBatcherReference = new BatcherReference(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApiFuture<ElementResultT> add(ElementT element) {
        Preconditions.checkState((!this.isClosed ? 1 : 0) != 0, (Object)"Cannot add elements on a closed batcher");
        try {
            this.flowController.reserve(1L, this.batchingDescriptor.countBytes(element));
        }
        catch (FlowController.FlowControlException e) {
            throw FlowController.FlowControlRuntimeException.fromFlowControlException(e);
        }
        SettableApiFuture result = SettableApiFuture.create();
        Object object = this.elementLock;
        synchronized (object) {
            this.currentOpenBatch.add(element, result);
        }
        if (this.currentOpenBatch.hasAnyThresholdReached()) {
            this.sendOutstanding();
        }
        return result;
    }

    @Override
    public void flush() throws InterruptedException {
        this.sendOutstanding();
        this.awaitAllOutstandingBatches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendOutstanding() {
        Batch<ElementT, ElementResultT, RequestT, ResponseT> accumulatedBatch;
        Object object = this.elementLock;
        synchronized (object) {
            if (this.currentOpenBatch.isEmpty()) {
                return;
            }
            accumulatedBatch = this.currentOpenBatch;
            this.currentOpenBatch = new Batch(this.prototype, this.batchingDescriptor, this.batchingSettings, this.batcherStats);
        }
        ApiFuture<ResponseT> batchResponse = this.unaryCallable.futureCall(((Batch)accumulatedBatch).builder.build());
        this.numOfOutstandingBatches.incrementAndGet();
        ApiFutures.addCallback(batchResponse, (ApiFutureCallback)new ApiFutureCallback<ResponseT>(){

            public void onSuccess(ResponseT response) {
                try {
                    BatcherImpl.this.flowController.release(accumulatedBatch.elementCounter, accumulatedBatch.byteCounter);
                    accumulatedBatch.onBatchSuccess(response);
                }
                finally {
                    BatcherImpl.this.onBatchCompletion();
                }
            }

            public void onFailure(Throwable throwable) {
                try {
                    BatcherImpl.this.flowController.release(accumulatedBatch.elementCounter, accumulatedBatch.byteCounter);
                    accumulatedBatch.onBatchFailure(throwable);
                }
                finally {
                    BatcherImpl.this.onBatchCompletion();
                }
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onBatchCompletion() {
        if (this.numOfOutstandingBatches.decrementAndGet() == 0) {
            Object object = this.flushLock;
            synchronized (object) {
                this.flushLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void awaitAllOutstandingBatches() throws InterruptedException {
        while (this.numOfOutstandingBatches.get() > 0) {
            Object object = this.flushLock;
            synchronized (object) {
                if (this.numOfOutstandingBatches.get() == 0) {
                    break;
                }
                this.flushLock.wait();
            }
        }
    }

    @Override
    public void close() throws InterruptedException {
        if (this.isClosed) {
            return;
        }
        this.flush();
        this.scheduledFuture.cancel(true);
        this.isClosed = true;
        this.currentBatcherReference.closed = true;
        this.currentBatcherReference.clear();
        BatchingException exception = this.batcherStats.asException();
        if (exception != null) {
            throw exception;
        }
    }

    @VisibleForTesting
    FlowController getFlowController() {
        return this.flowController;
    }

    @VisibleForTesting
    static final class BatcherReference
    extends WeakReference<BatcherImpl> {
        private static final ReferenceQueue<BatcherImpl> refQueue = new ReferenceQueue();
        private static final ConcurrentMap<BatcherReference, BatcherReference> refs = new ConcurrentHashMap<BatcherReference, BatcherReference>();
        private static final String ALLOCATION_SITE_PROPERTY_NAME = "com.google.api.gax.batching.Batcher.enableAllocationTracking";
        private static final boolean ENABLE_ALLOCATION_TRACKING = Boolean.parseBoolean(System.getProperty("com.google.api.gax.batching.Batcher.enableAllocationTracking", "true"));
        private static final RuntimeException missingCallSite = BatcherReference.missingCallSite();
        private final Reference<RuntimeException> allocationSite = new SoftReference<RuntimeException>(ENABLE_ALLOCATION_TRACKING ? new RuntimeException("Batcher allocation site") : missingCallSite);
        private volatile boolean closed;

        BatcherReference(BatcherImpl referent) {
            super(referent, refQueue);
            refs.put(this, this);
            BatcherReference.cleanQueue();
        }

        @Override
        public void clear() {
            this.clearInternal();
            BatcherReference.cleanQueue();
        }

        private void clearInternal() {
            super.clear();
            refs.remove(this);
            this.allocationSite.clear();
        }

        @VisibleForTesting
        static int cleanQueue() {
            BatcherReference ref;
            int orphanedBatchers = 0;
            while ((ref = (BatcherReference)refQueue.poll()) != null) {
                RuntimeException maybeAllocationSite = ref.allocationSite.get();
                ref.clearInternal();
                if (ref.closed) continue;
                ++orphanedBatchers;
                if (!LOG.isLoggable(Level.SEVERE)) continue;
                String message = "Batcher was not closed properly!!! Make sure to call close().";
                LOG.log(Level.SEVERE, message, maybeAllocationSite);
            }
            return orphanedBatchers;
        }

        private static RuntimeException missingCallSite() {
            RuntimeException e = new RuntimeException("Batcher allocation site not recorded.  Set -Dcom.google.api.gax.batching.Batcher.enableAllocationTracking=true to enable it");
            e.setStackTrace(new StackTraceElement[0]);
            return e;
        }
    }

    @VisibleForTesting
    static class PushCurrentBatchRunnable<ElementT, ElementResultT, RequestT, ResponseT>
    implements Runnable {
        private Future<?> scheduledFuture;
        private final WeakReference<BatcherImpl<ElementT, ElementResultT, RequestT, ResponseT>> batcherReferent;

        PushCurrentBatchRunnable(BatcherImpl<ElementT, ElementResultT, RequestT, ResponseT> batcher) {
            this.batcherReferent = new WeakReference<BatcherImpl<ElementT, ElementResultT, RequestT, ResponseT>>(batcher);
        }

        @Override
        public void run() {
            BatcherImpl batcher = (BatcherImpl)this.batcherReferent.get();
            if (batcher == null) {
                this.scheduledFuture.cancel(true);
            } else {
                batcher.sendOutstanding();
            }
        }

        void setScheduledFuture(Future<?> scheduledFuture) {
            this.scheduledFuture = scheduledFuture;
        }

        boolean isCancelled() {
            return this.scheduledFuture.isCancelled();
        }
    }

    private static class Batch<ElementT, ElementResultT, RequestT, ResponseT> {
        private final BatchingRequestBuilder<ElementT, RequestT> builder;
        private final List<BatchEntry<ElementT, ElementResultT>> entries;
        private final BatchingDescriptor<ElementT, ElementResultT, RequestT, ResponseT> descriptor;
        private final BatcherStats batcherStats;
        private final long elementThreshold;
        private final long bytesThreshold;
        private long elementCounter = 0L;
        private long byteCounter = 0L;

        private Batch(RequestT prototype, BatchingDescriptor<ElementT, ElementResultT, RequestT, ResponseT> descriptor, BatchingSettings batchingSettings, BatcherStats batcherStats) {
            this.descriptor = descriptor;
            this.builder = descriptor.newRequestBuilder(prototype);
            this.entries = new ArrayList<BatchEntry<ElementT, ElementResultT>>();
            Long elementCountThreshold = batchingSettings.getElementCountThreshold();
            this.elementThreshold = elementCountThreshold == null ? 0L : elementCountThreshold;
            Long requestByteThreshold = batchingSettings.getRequestByteThreshold();
            this.bytesThreshold = requestByteThreshold == null ? 0L : requestByteThreshold;
            this.batcherStats = batcherStats;
        }

        void add(ElementT element, SettableApiFuture<ElementResultT> result) {
            this.builder.add(element);
            this.entries.add(BatchEntry.create(element, result));
            ++this.elementCounter;
            this.byteCounter += this.descriptor.countBytes(element);
        }

        void onBatchSuccess(ResponseT response) {
            try {
                this.descriptor.splitResponse(response, this.entries);
                this.batcherStats.recordBatchElementsCompletion(this.entries);
            }
            catch (Exception ex) {
                this.onBatchFailure(ex);
            }
        }

        void onBatchFailure(Throwable throwable) {
            try {
                this.descriptor.splitException(throwable, this.entries);
            }
            catch (Exception ex) {
                for (BatchEntry<ElementT, ElementResultT> batchEntry : this.entries) {
                    batchEntry.getResultFuture().setException((Throwable)ex);
                }
            }
            this.batcherStats.recordBatchFailure(throwable);
        }

        boolean isEmpty() {
            return this.elementCounter == 0L;
        }

        boolean hasAnyThresholdReached() {
            return this.elementCounter >= this.elementThreshold || this.byteCounter >= this.bytesThreshold;
        }
    }
}

