/*
 * Decompiled with CFR 0.152.
 */
package com.ryantenney.metrics.spring;

import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.Ordered;

class HealthCheckBeanPostProcessor
implements BeanPostProcessor,
Ordered {
    private static final Logger LOG = LoggerFactory.getLogger(HealthCheckBeanPostProcessor.class);
    private final HealthCheckRegistry healthChecks;

    public HealthCheckBeanPostProcessor(HealthCheckRegistry healthChecks) {
        this.healthChecks = healthChecks;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        if (bean instanceof HealthCheck) {
            this.healthChecks.register(beanName, (HealthCheck)bean);
            LOG.debug("Registering HealthCheck bean {}", (Object)beanName);
        }
        return bean;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

