/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere;

import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.util.OverthereUtils;
import com.xebialabs.overthere.util.UnixCommandLineArgsSanitizer;
import com.xebialabs.overthere.util.WinRSCommandLinePasswordSanitizer;
import com.xebialabs.overthere.util.WindowsCommandLineArgsSanitizer;
import java.io.Serializable;

public abstract class CmdLineArgument
implements Serializable {
    private static final String EMPTY_ARGUMENT = "\"\"";

    public static CmdLineArgument arg(String arg) {
        OverthereUtils.checkNotNull(arg, "Cannot create a null argument", new Object[0]);
        return new Basic(arg);
    }

    public static CmdLineArgument password(String arg) {
        OverthereUtils.checkNotNull(arg, "Cannot create a null password argument", new Object[0]);
        return new Password(arg);
    }

    public static CmdLineArgument raw(String arg) {
        OverthereUtils.checkNotNull(arg, "Cannot create a null raw argument", new Object[0]);
        return new Raw(arg);
    }

    public static CmdLineArgument nested(CmdLine line) {
        OverthereUtils.checkNotNull(line, "Cannot create a null nested command", new Object[0]);
        return new Nested(line);
    }

    public abstract String toString(OperatingSystemFamily var1, boolean var2);

    public abstract void buildString(OperatingSystemFamily var1, boolean var2, StringBuilder var3);

    protected void encodeString(String str, OperatingSystemFamily os, StringBuilder builder) {
        if (str.length() == 0) {
            builder.append(EMPTY_ARGUMENT);
            return;
        }
        switch (os) {
            case WINDOWS: {
                if (!WindowsCommandLineArgsSanitizer.containsAnySpecialChars(str)) {
                    builder.append(str);
                    break;
                }
                builder.append(WindowsCommandLineArgsSanitizer.sanitize(str));
                break;
            }
            case UNIX: 
            case ZOS: {
                if (!UnixCommandLineArgsSanitizer.containsAnySpecialChars(str)) {
                    builder.append(str);
                    break;
                }
                builder.append(UnixCommandLineArgsSanitizer.sanitize(str));
                break;
            }
            default: {
                throw new RuntimeException("Unknown os " + (Object)((Object)os));
            }
        }
    }

    private static class Nested
    extends CmdLineArgument {
        private final CmdLine line;

        public Nested(CmdLine line) {
            this.line = line;
        }

        @Override
        public String toString(OperatingSystemFamily os, boolean forLogging) {
            StringBuilder builder = new StringBuilder();
            this.encodeString(this.line.toCommandLine(os, forLogging), os, builder);
            return builder.toString();
        }

        @Override
        public void buildString(OperatingSystemFamily os, boolean forLogging, StringBuilder builder) {
            this.encodeString(this.line.toCommandLine(os, forLogging), os, builder);
        }

        public String toString() {
            return this.line.toString();
        }
    }

    private static class Password
    extends Basic {
        private static final String HIDDEN_PASSWORD = "********";

        public Password(String arg) {
            super(arg);
        }

        @Override
        public String toString(OperatingSystemFamily os, boolean forLogging) {
            if (forLogging) {
                return HIDDEN_PASSWORD;
            }
            return this.arg;
        }

        @Override
        public void buildString(OperatingSystemFamily os, boolean forLogging, StringBuilder builder) {
            if (forLogging) {
                builder.append(HIDDEN_PASSWORD);
            } else {
                super.buildString(os, forLogging, builder);
            }
        }

        @Override
        protected void encodeString(String str, OperatingSystemFamily os, StringBuilder builder) {
            if (str.length() == 0) {
                builder.append(CmdLineArgument.EMPTY_ARGUMENT);
                return;
            }
            switch (os) {
                case WINDOWS: {
                    if (!WinRSCommandLinePasswordSanitizer.containsAnySpecialChars(str)) {
                        builder.append(str);
                        break;
                    }
                    builder.append(WinRSCommandLinePasswordSanitizer.sanitize(str));
                    break;
                }
                case UNIX: 
                case ZOS: {
                    super.encodeString(str, os, builder);
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown os " + (Object)((Object)os));
                }
            }
        }
    }

    private static class Basic
    extends Single {
        public Basic(String arg) {
            super(arg);
        }

        @Override
        public String toString(OperatingSystemFamily os, boolean forLogging) {
            return this.arg;
        }

        @Override
        public void buildString(OperatingSystemFamily os, boolean forLogging, StringBuilder builder) {
            String s = this.arg;
            this.encodeString(s, os, builder);
        }
    }

    private static class Raw
    extends Single {
        public Raw(String arg) {
            super(arg);
        }

        @Override
        public String toString(OperatingSystemFamily os, boolean forLogging) {
            return this.arg;
        }

        @Override
        public void buildString(OperatingSystemFamily os, boolean forLogging, StringBuilder builder) {
            if (this.arg.length() == 0) {
                builder.append(CmdLineArgument.EMPTY_ARGUMENT);
            } else {
                builder.append(this.arg);
            }
        }
    }

    private static abstract class Single
    extends CmdLineArgument {
        protected String arg;

        private Single(String arg) {
            this.arg = arg;
        }

        public String toString() {
            return this.toString(OperatingSystemFamily.UNIX, true);
        }
    }
}

