/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.scheduler;

import com.codahale.metrics.annotation.Timed;
import com.typesafe.config.Config;
import com.xebialabs.xlplatform.cluster.ClusterMode;
import com.xebialabs.xlrelease.config.XlrConfig$;
import com.xebialabs.xlrelease.scheduler.Job;
import com.xebialabs.xlrelease.scheduler.JobQueue;
import com.xebialabs.xlrelease.scheduler.JobRow$;
import com.xebialabs.xlrelease.scheduler.JobStatus;
import com.xebialabs.xlrelease.scheduler.StopWorkerThread;
import com.xebialabs.xlrelease.scheduler.repository.JobRepository;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.DelayQueue;
import java.util.function.Predicate;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Component
@ScalaSignature(bytes="\u0006\u0005\u0005\rc\u0001B\u0007\u000f\u0001]A\u0001B\u000b\u0001\u0003\u0006\u0004%\ta\u000b\u0005\te\u0001\u0011\t\u0011)A\u0005Y!)1\u0007\u0001C\u0001i!Aa\t\u0001b\u0001\n\u0003qq\t\u0003\u0004V\u0001\u0001\u0006I\u0001\u0013\u0005\t-\u0002A)\u0019!C\u0005/\")1\r\u0001C!I\")A\u000f\u0001C#k\"9\u0011Q\u0001\u0001\u0005\n\u0005\u001d\u0001bBA\u0006\u0001\u0011\u0005\u0013Q\u0002\u0005\b\u0003'\u0001A\u0011IA\u000b\u0011\u001d\t\t\u0003\u0001C!\u0003G\u0011q\u0002R3gCVdGOS8c#V,W/\u001a\u0006\u0003\u001fA\t\u0011b]2iK\u0012,H.\u001a:\u000b\u0005E\u0011\u0012!\u0003=me\u0016dW-Y:f\u0015\t\u0019B#A\u0005yK\nL\u0017\r\\1cg*\tQ#A\u0002d_6\u001c\u0001a\u0005\u0003\u00011y\u0011\u0003CA\r\u001d\u001b\u0005Q\"\"A\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uQ\"AB!osJ+g\r\u0005\u0002 A5\ta\"\u0003\u0002\"\u001d\tA!j\u001c2Rk\u0016,X\r\u0005\u0002$Q5\tAE\u0003\u0002&M\u0005)1\u000f\u001c45U*\tq%\u0001\u0005he&T(\u0010\\3e\u0013\tICEA\u0004M_\u001e<\u0017N\\4\u0002\u001b)|'MU3q_NLGo\u001c:z+\u0005a\u0003CA\u00171\u001b\u0005q#BA\u0018\u000f\u0003)\u0011X\r]8tSR|'/_\u0005\u0003c9\u0012QBS8c%\u0016\u0004xn]5u_JL\u0018A\u00046pEJ+\u0007o\\:ji>\u0014\u0018\u0010I\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005U2\u0004CA\u0010\u0001\u0011\u0015Q3\u00011\u0001-Q\t\u0019\u0001\b\u0005\u0002:\t6\t!H\u0003\u0002<y\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005ur\u0014a\u00024bGR|'/\u001f\u0006\u0003\u007f\u0001\u000bQAY3b]NT!!\u0011\"\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011aQ\u0001\u0004_J<\u0017BA#;\u0005%\tU\u000f^8xSJ,G-A\u0005m_\u000e\fGNS8cgV\t\u0001\nE\u0002J!Jk\u0011A\u0013\u0006\u0003\u00172\u000b!bY8oGV\u0014(/\u001a8u\u0015\tie*\u0001\u0003vi&d'\"A(\u0002\t)\fg/Y\u0005\u0003#*\u0013!\u0002R3mCf\fV/Z;f!\ty2+\u0003\u0002U\u001d\t\u0019!j\u001c2\u0002\u00151|7-\u00197K_\n\u001c\b%\u0001\u0004o_\u0012,\u0017\nZ\u000b\u00021B\u0011\u0011\f\u0019\b\u00035z\u0003\"a\u0017\u000e\u000e\u0003qS!!\u0018\f\u0002\rq\u0012xn\u001c;?\u0013\ty&$\u0001\u0004Qe\u0016$WMZ\u0005\u0003C\n\u0014aa\u0015;sS:<'BA0\u001b\u0003\u0019\u0019XOY7jiR\u0011Q\r\u001b\t\u00033\u0019L!a\u001a\u000e\u0003\tUs\u0017\u000e\u001e\u0005\u0006S\u001e\u0001\rAU\u0001\u0004U>\u0014\u0007FA\u0004l!\ta'/D\u0001n\u0015\tYdN\u0003\u0002pa\u00069Q.\u001a;sS\u000e\u001c(BA9\u0015\u0003!\u0019w\u000eZ1iC2,\u0017BA:n\u0005\u0015!\u0016.\\3e\u0003\r9W\r\u001e\u000b\u0003%ZDQa\u001e\u0005A\u0002a\faBY1dWB\u0014Xm]:ve\u00164e\u000e\u0005\u0002zu6\t\u0001!\u0003\u0002|A\tq!)Y2laJ,7o];sK\u001as\u0007F\u0001\u0005~!\rq\u0018\u0011A\u0007\u0002\u007f*\u00111HG\u0005\u0004\u0003\u0007y(a\u0002;bS2\u0014XmY\u0001\u0005Y>\u001c7\u000eF\u0002S\u0003\u0013AQ![\u0005A\u0002I\u000baAZ5oSNDGcA3\u0002\u0010!)\u0011N\u0003a\u0001%\"\u0012!b[\u0001\u0012gR|\u0007oV8sW\u0016\u0014H\u000b\u001b:fC\u0012\u001cHcA3\u0002\u0018!9\u0011\u0011D\u0006A\u0002\u0005m\u0011!B2pk:$\bcA\r\u0002\u001e%\u0019\u0011q\u0004\u000e\u0003\u0007%sG/\u0001\u0005dC:\u001cW\r\\%g)\r)\u0017Q\u0005\u0005\b\u0003Oa\u0001\u0019AA\u0015\u0003%\u0001(/\u001a3jG\u0006$X\rE\u0003\u0002,\u0005E\"+\u0004\u0002\u0002.)\u0019\u0011q\u0006'\u0002\u0011\u0019,hn\u0019;j_:LA!a\r\u0002.\tI\u0001K]3eS\u000e\fG/\u001a\u0015\u0004\u0001\u0005]\u0002\u0003BA\u001d\u0003\u007fi!!a\u000f\u000b\u0007\u0005u\u0002)\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LA!!\u0011\u0002<\tI1i\\7q_:,g\u000e\u001e")
public class DefaultJobQueue
implements JobQueue,
Logging {
    private String nodeId;
    private final JobRepository jobRepository;
    private final DelayQueue<Job> localJobs;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DefaultJobQueue defaultJobQueue = this;
        synchronized (defaultJobQueue) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public JobRepository jobRepository() {
        return this.jobRepository;
    }

    public DelayQueue<Job> localJobs() {
        return this.localJobs;
    }

    private String nodeId$lzycompute() {
        DefaultJobQueue defaultJobQueue = this;
        synchronized (defaultJobQueue) {
            if (!this.bitmap$0) {
                String string;
                ClusterMode clusterMode = XlrConfig$.MODULE$.getInstance().clusterMode();
                boolean bl = ClusterMode.Full$.MODULE$.equals(clusterMode) ? true : ClusterMode.HotStandby$.MODULE$.equals(clusterMode);
                if (bl) {
                    Config clusterConfig = XlrConfig$.MODULE$.getInstance().cluster().config().getConfig("node");
                    string = new StringBuilder(1).append(clusterConfig.getString("hostname")).append(":").append(clusterConfig.getInt("clusterPort")).toString();
                } else if (ClusterMode.Standalone$.MODULE$.equals(clusterMode)) {
                    string = "default";
                } else {
                    throw new MatchError((Object)clusterMode);
                }
                this.nodeId = string;
                this.bitmap$0 = true;
            }
        }
        return this.nodeId;
    }

    private String nodeId() {
        return !this.bitmap$0 ? this.nodeId$lzycompute() : this.nodeId;
    }

    @Override
    @Timed
    public void submit(Job job) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(14).append("submitted job ").append(job).toString());
        job.id_$eq(this.jobRepository().create(JobRow$.MODULE$.apply(job)).id());
        this.localJobs().add(job);
    }

    @Override
    public final Job get(Function1<Job, Object> backpressureFn) {
        Job job;
        block4: {
            Try try_;
            while (true) {
                Job job2;
                if ((job2 = (Job)this.localJobs().take()) instanceof StopWorkerThread) {
                    StopWorkerThread stopWorkerThread = (StopWorkerThread)job2;
                    this.logger().debug((Function0 & Serializable)() -> "giving StopWorkerThread");
                    job = stopWorkerThread;
                    break block4;
                }
                if (!BoxesRunTime.unboxToBoolean((Object)backpressureFn.apply((Object)job2))) continue;
                try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> this.lock(job2));
                if (try_ instanceof Success) break;
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable exception = failure.exception();
                    if (!(exception instanceof OptimisticLockingFailureException)) {
                        this.logger().error((Function0 & Serializable)() -> "Unexpected error", (Function0 & Serializable)() -> exception);
                        continue;
                    }
                    this.logger().warn((Function0 & Serializable)() -> new StringBuilder(19).append("Unable to lock job ").append(job2).toString());
                    continue;
                }
                throw new MatchError((Object)try_);
            }
            Success success = (Success)try_;
            Job reservedJob = (Job)success.value();
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(7).append("giving ").append(reservedJob).toString());
            Job job3 = reservedJob;
            job = job3;
        }
        return job;
    }

    private Job lock(Job job) {
        job.version_$eq(job.version() + 1L);
        job.status_$eq(JobStatus.RESERVED);
        job.node_$eq(this.nodeId());
        job.startTime_$eq(Instant.now().truncatedTo(ChronoUnit.MILLIS));
        this.jobRepository().updateWithVersionCheck(JobRow$.MODULE$.apply(job));
        return job;
    }

    @Override
    @Timed
    public void finish(Job job) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(14).append("finishing job ").append(job).toString());
        this.jobRepository().delete(JobRow$.MODULE$.apply(job));
    }

    @Override
    public void stopWorkerThreads(int count) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(24).append("stopping ").append(count).append(" worker threads").toString());
        this.localJobs().clear();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), count).foreach((Function1)(JFunction1.mcZI.sp & Serializable)i -> this.localJobs().add(new StopWorkerThread()));
    }

    @Override
    public void cancelIf(Predicate<Job> predicate) {
        this.localJobs().removeIf(predicate);
    }

    @Autowired
    public DefaultJobQueue(JobRepository jobRepository) {
        this.jobRepository = jobRepository;
        Logging.$init$((Logging)this);
        this.localJobs = new DelayQueue();
    }
}

