/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.core;

import java.io.Serializable;
import org.springframework.util.Assert;

public class OAuth2Error
implements Serializable {
    private static final long serialVersionUID = 540L;
    private final String errorCode;
    private final String description;
    private final String uri;

    public OAuth2Error(String errorCode) {
        this(errorCode, null, null);
    }

    public OAuth2Error(String errorCode, String description, String uri) {
        Assert.hasText((String)errorCode, (String)"errorCode cannot be empty");
        this.errorCode = errorCode;
        this.description = description;
        this.uri = uri;
    }

    public final String getErrorCode() {
        return this.errorCode;
    }

    public final String getDescription() {
        return this.description;
    }

    public final String getUri() {
        return this.uri;
    }

    public String toString() {
        return "[" + this.getErrorCode() + "] " + (this.getDescription() != null ? this.getDescription() : "");
    }
}

