/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.platform.sso.oidc.web;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.web.authentication.logout.SimpleUrlLogoutSuccessHandler;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.util.Assert;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class CustomOidcClientInitiatedLogoutSuccessHandler
extends SimpleUrlLogoutSuccessHandler {
    private final ClientRegistrationRepository clientRegistrationRepository;
    private String postLogoutRedirectUri;

    public CustomOidcClientInitiatedLogoutSuccessHandler(ClientRegistrationRepository clientRegistrationRepository) {
        Assert.notNull((Object)clientRegistrationRepository, (String)"clientRegistrationRepository cannot be null");
        this.clientRegistrationRepository = clientRegistrationRepository;
    }

    protected String determineTargetUrl(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        String registrationId;
        ClientRegistration clientRegistration;
        String endSessionEndpoint;
        String targetUrl = null;
        if (authentication instanceof OAuth2AuthenticationToken && authentication.getPrincipal() instanceof OidcUser && (endSessionEndpoint = this.endSessionEndpoint(clientRegistration = this.clientRegistrationRepository.findByRegistrationId(registrationId = ((OAuth2AuthenticationToken)authentication).getAuthorizedClientRegistrationId()))) != null) {
            String idToken = this.idToken(authentication);
            URI logoutRedirectUri = this.postLogoutRedirectUri(request);
            targetUrl = this.endpointUri(endSessionEndpoint, idToken, logoutRedirectUri);
        }
        if (targetUrl == null) {
            targetUrl = super.determineTargetUrl(request, response);
        }
        return targetUrl;
    }

    private String endSessionEndpoint(ClientRegistration clientRegistration) {
        Object endSessionEndpoint;
        String result = null;
        if (clientRegistration != null && (endSessionEndpoint = clientRegistration.getProviderDetails().getConfigurationMetadata().get("end_session_endpoint")) != null) {
            result = endSessionEndpoint.toString();
        }
        return result;
    }

    private String idToken(Authentication authentication) {
        return ((OidcUser)authentication.getPrincipal()).getIdToken().getTokenValue();
    }

    private URI postLogoutRedirectUri(HttpServletRequest request) {
        if (this.postLogoutRedirectUri == null) {
            return null;
        }
        UriComponents uriComponents = UriComponentsBuilder.fromHttpUrl((String)UrlUtils.buildFullRequestUrl((HttpServletRequest)request)).replacePath(request.getContextPath()).replaceQuery(null).fragment(null).build();
        return UriComponentsBuilder.fromUriString((String)this.postLogoutRedirectUri).buildAndExpand(Collections.singletonMap("baseUrl", uriComponents.toUriString())).toUri();
    }

    private String endpointUri(String endSessionEndpoint, String idToken, URI postLogoutRedirectUri) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)endSessionEndpoint);
        builder.queryParam("id_token_hint", new Object[]{idToken});
        if (postLogoutRedirectUri != null) {
            builder.queryParam("post_logout_redirect_uri", new Object[]{postLogoutRedirectUri});
        }
        return builder.encode(StandardCharsets.UTF_8).build().toUriString();
    }

    public void setPostLogoutRedirectUri(String postLogoutRedirectUri) {
        Assert.notNull((Object)postLogoutRedirectUri, (String)"postLogoutRedirectUri cannot be null");
        this.postLogoutRedirectUri = postLogoutRedirectUri;
    }
}

