/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.resource.authentication;

import com.nimbusds.jwt.JWTParser;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.log.LogMessage;
import org.springframework.lang.NonNull;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationManagerResolver;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtDecoders;
import org.springframework.security.oauth2.server.resource.InvalidBearerTokenException;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationProvider;
import org.springframework.security.oauth2.server.resource.web.BearerTokenResolver;
import org.springframework.security.oauth2.server.resource.web.DefaultBearerTokenResolver;
import org.springframework.util.Assert;

public final class JwtIssuerAuthenticationManagerResolver
implements AuthenticationManagerResolver<HttpServletRequest> {
    private final AuthenticationManagerResolver<String> issuerAuthenticationManagerResolver;
    private final Converter<HttpServletRequest, String> issuerConverter = new JwtClaimIssuerConverter();

    public JwtIssuerAuthenticationManagerResolver(String ... trustedIssuers) {
        this(Arrays.asList(trustedIssuers));
    }

    public JwtIssuerAuthenticationManagerResolver(Collection<String> trustedIssuers) {
        Assert.notEmpty(trustedIssuers, (String)"trustedIssuers cannot be empty");
        this.issuerAuthenticationManagerResolver = new TrustedIssuerJwtAuthenticationManagerResolver(Collections.unmodifiableCollection(trustedIssuers)::contains);
    }

    public JwtIssuerAuthenticationManagerResolver(AuthenticationManagerResolver<String> issuerAuthenticationManagerResolver) {
        Assert.notNull(issuerAuthenticationManagerResolver, (String)"issuerAuthenticationManagerResolver cannot be null");
        this.issuerAuthenticationManagerResolver = issuerAuthenticationManagerResolver;
    }

    public AuthenticationManager resolve(HttpServletRequest request) {
        String issuer = (String)this.issuerConverter.convert((Object)request);
        AuthenticationManager authenticationManager = this.issuerAuthenticationManagerResolver.resolve((Object)issuer);
        if (authenticationManager == null) {
            throw new InvalidBearerTokenException("Invalid issuer");
        }
        return authenticationManager;
    }

    private static class TrustedIssuerJwtAuthenticationManagerResolver
    implements AuthenticationManagerResolver<String> {
        private final Log logger = LogFactory.getLog(this.getClass());
        private final Map<String, AuthenticationManager> authenticationManagers = new ConcurrentHashMap<String, AuthenticationManager>();
        private final Predicate<String> trustedIssuer;

        TrustedIssuerJwtAuthenticationManagerResolver(Predicate<String> trustedIssuer) {
            this.trustedIssuer = trustedIssuer;
        }

        public AuthenticationManager resolve(String issuer) {
            if (this.trustedIssuer.test(issuer)) {
                AuthenticationManager authenticationManager = this.authenticationManagers.computeIfAbsent(issuer, k -> {
                    this.logger.debug((Object)"Constructing AuthenticationManager");
                    JwtDecoder jwtDecoder = JwtDecoders.fromIssuerLocation((String)issuer);
                    return new JwtAuthenticationProvider(jwtDecoder)::authenticate;
                });
                this.logger.debug((Object)LogMessage.format((String)"Resolved AuthenticationManager for issuer '%s'", (Object)issuer));
                return authenticationManager;
            }
            this.logger.debug((Object)"Did not resolve AuthenticationManager since issuer is not trusted");
            return null;
        }
    }

    private static class JwtClaimIssuerConverter
    implements Converter<HttpServletRequest, String> {
        private final BearerTokenResolver resolver = new DefaultBearerTokenResolver();

        private JwtClaimIssuerConverter() {
        }

        public String convert(@NonNull HttpServletRequest request) {
            String token = this.resolver.resolve(request);
            try {
                String issuer = JWTParser.parse((String)token).getJWTClaimsSet().getIssuer();
                if (issuer != null) {
                    return issuer;
                }
            }
            catch (Exception ex) {
                throw new InvalidBearerTokenException(ex.getMessage(), ex);
            }
            throw new InvalidBearerTokenException("Missing issuer");
        }
    }
}

