/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.ItemAlreadyExistsException;
import com.xebialabs.deployit.repository.ItemInUseException;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.CiWithUid;
import com.xebialabs.xlrelease.domain.Comment;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.events.ReleaseCreationSource;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.utils.syntax;
import com.xebialabs.xlrelease.domain.utils.syntax$;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.FacetRepositoryDispatcher;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.Page$;
import com.xebialabs.xlrelease.repository.PersistenceInterceptor;
import com.xebialabs.xlrelease.repository.ReleaseExtensionsRepository;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.ReleaseSearchByParams;
import com.xebialabs.xlrelease.repository.TeamRepository;
import com.xebialabs.xlrelease.repository.sql.ConfigurationReferencesSupport;
import com.xebialabs.xlrelease.repository.sql.DeserializationSupport;
import com.xebialabs.xlrelease.repository.sql.InterceptedRepository;
import com.xebialabs.xlrelease.repository.sql.SqlReleaseRepositoryHelper;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$RichCiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.CommentPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.CommentPersistence$CommentRow$;
import com.xebialabs.xlrelease.repository.sql.persistence.DependencyPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasesSqlBuilder;
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.configuration.ConfigurationReferencePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.DependencyRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.DependencyRow$;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ReleaseRow;
import com.xebialabs.xlrelease.security.SecuredCi;
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptions;
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptionsBuilder;
import com.xebialabs.xlrelease.utils.Diff$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.slf4j.Marker;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\r-f\u0001B\u00193\u0001uB\u0001b\u0019\u0001\u0003\u0002\u0003\u0006I\u0001\u001a\u0005\tU\u0002\u0011)\u0019!C\tW\"Aq\u000e\u0001B\u0001B\u0003%A\u000e\u0003\u0005q\u0001\t\u0015\r\u0011\"\u0005r\u0011!)\bA!A!\u0002\u0013\u0011\b\u0002\u0003<\u0001\u0005\u000b\u0007I\u0011C<\t\u0011m\u0004!\u0011!Q\u0001\naD\u0001\u0002 \u0001\u0003\u0006\u0004%\t\" \u0005\n\u0003\u0007\u0001!\u0011!Q\u0001\nyD!\"!\u0002\u0001\u0005\u000b\u0007I\u0011CA\u0004\u0011)\ty\u0001\u0001B\u0001B\u0003%\u0011\u0011\u0002\u0005\u000b\u0003#\u0001!Q1A\u0005\u0002\u0005M\u0001BCA\u0011\u0001\t\u0005\t\u0015!\u0003\u0002\u0016!Q\u00111\u0005\u0001\u0003\u0006\u0004%\t!!\n\t\u0015\u00055\u0002A!A!\u0002\u0013\t9\u0003\u0003\u0006\u00020\u0001\u0011\t\u0011)A\u0005\u0003cA!\"a\u000e\u0001\u0005\u000b\u0007I1AA\u001d\u0011)\tI\u0007\u0001B\u0001B\u0003%\u00111\b\u0005\b\u0003W\u0002A\u0011AA7\u0011\u001d\t9\t\u0001C!\u0003\u0013Cq!!3\u0001\t\u0003\nY\rC\u0004\u0002d\u0002!\t%!:\t\u000f\u0005\r\b\u0001\"\u0011\u0002l\"9!q\u0001\u0001\u0005B\t%\u0001b\u0002B\"\u0001\u0011\u0005#Q\t\u0005\b\u0005\u001b\u0002A\u0011\u0001B(\u0011\u001d\u0011\u0019\b\u0001C!\u0005kBqAa\"\u0001\t\u0003\u0011I\tC\u0004\u0003\u0018\u0002!\tE!'\t\u000f\t5\u0006\u0001\"\u0011\u00030\"9!Q\u0017\u0001\u0005\n\t]\u0006b\u0002B`\u0001\u0011\u0005#\u0011\u0019\u0005\b\u0005\u0013\u0004A\u0011\tBf\u0011\u001d\u00119\u000e\u0001C!\u00053DqAa8\u0001\t\u0003\u0012\t\u000fC\u0004\u0003l\u0002!\tE!<\t\u000f\t]\b\u0001\"\u0011\u0003z\"91q\u0001\u0001\u0005B\r%\u0001bBB\t\u0001\u0011\u000531\u0003\u0005\b\u00077\u0001A\u0011IB\u000f\u0011\u001d\u0019Y\u0002\u0001C!\u0007GAqaa\f\u0001\t\u0003\u001a\t\u0004C\u0004\u0004:\u0001!\tea\u000f\t\u000f\r-\u0003\u0001\"\u0003\u0004N!91Q\u000e\u0001\u0005\n\r=\u0004bBB;\u0001\u0011\u00053q\u000f\u0005\b\u0007#\u0003A\u0011IBJ\u0011\u001d\u0019I\n\u0001C!\u00077\u0013AcU9m%\u0016dW-Y:f%\u0016\u0004xn]5u_JL(BA\u001a5\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003kY\n!B]3q_NLGo\u001c:z\u0015\t9\u0004(A\u0005yYJ,G.Z1tK*\u0011\u0011HO\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011aO\u0001\u0004G>l7\u0001A\n\t\u0001y\"\u0005J\u0015.^AB\u0011qHQ\u0007\u0002\u0001*\t\u0011)A\u0003tG\u0006d\u0017-\u0003\u0002D\u0001\n1\u0011I\\=SK\u001a\u0004\"!\u0012$\u000e\u0003QJ!a\u0012\u001b\u0003#I+G.Z1tKJ+\u0007o\\:ji>\u0014\u0018\u0010E\u0002J\u00152k\u0011AM\u0005\u0003\u0017J\u0012Q#\u00138uKJ\u001cW\r\u001d;fIJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002N!6\taJ\u0003\u0002Pm\u00051Am\\7bS:L!!\u0015(\u0003\u000fI+G.Z1tKB\u00111\u000bW\u0007\u0002)*\u0011QKV\u0001\u0006g24GG\u001b\u0006\u0002/\u0006AqM]5{u2,G-\u0003\u0002Z)\n9Aj\\4hS:<\u0007CA%\\\u0013\ta&G\u0001\fEKN,'/[1mSj\fG/[8o'V\u0004\bo\u001c:u!\tIe,\u0003\u0002`e\tq2i\u001c8gS\u001e,(/\u0019;j_:\u0014VMZ3sK:\u001cWm]*vaB|'\u000f\u001e\t\u0003\u0013\u0006L!A\u0019\u001a\u00035M\u000bHNU3mK\u0006\u001cXMU3q_NLGo\u001c:z\u0011\u0016d\u0007/\u001a:\u0002%I,G.Z1tKB+'o]5ti\u0016t7-\u001a\t\u0003K\"l\u0011A\u001a\u0006\u0003OJ\n1\u0002]3sg&\u001cH/\u001a8dK&\u0011\u0011N\u001a\u0002\u0013%\u0016dW-Y:f!\u0016\u00148/[:uK:\u001cW-A\buCN\\\u0007+\u001a:tSN$XM\\2f+\u0005a\u0007CA3n\u0013\tqgMA\bUCN\\\u0007+\u001a:tSN$XM\\2f\u0003A!\u0018m]6QKJ\u001c\u0018n\u001d;f]\u000e,\u0007%A\u000beKB,g\u000eZ3oGf\u0004VM]:jgR,gnY3\u0016\u0003I\u0004\"!Z:\n\u0005Q4'!\u0006#fa\u0016tG-\u001a8dsB+'o]5ti\u0016t7-Z\u0001\u0017I\u0016\u0004XM\u001c3f]\u000eL\b+\u001a:tSN$XM\\2fA\u0005\u00112m\\7nK:$\b+\u001a:tSN$XM\\2f+\u0005A\bCA3z\u0013\tQhM\u0001\nD_6lWM\u001c;QKJ\u001c\u0018n\u001d;f]\u000e,\u0017aE2p[6,g\u000e\u001e)feNL7\u000f^3oG\u0016\u0004\u0013A\u0004;fC6\u0014V\r]8tSR|'/_\u000b\u0002}B\u0011Qi`\u0005\u0004\u0003\u0003!$A\u0004+fC6\u0014V\r]8tSR|'/_\u0001\u0010i\u0016\fWNU3q_NLGo\u001c:zA\u0005Y\"/\u001a7fCN,W\t\u001f;f]NLwN\\:SKB|7/\u001b;pef,\"!!\u0003\u0011\u0007\u0015\u000bY!C\u0002\u0002\u000eQ\u00121DU3mK\u0006\u001cX-\u0012=uK:\u001c\u0018n\u001c8t%\u0016\u0004xn]5u_JL\u0018\u0001\b:fY\u0016\f7/Z#yi\u0016t7/[8ogJ+\u0007o\\:ji>\u0014\u0018\u0010I\u0001\u0019G>tg-[4ve\u0006$\u0018n\u001c8QKJ\u001c\u0018n\u001d;f]\u000e,WCAA\u000b!\u0011\t9\"!\b\u000e\u0005\u0005e!bAA\u000eM\u0006i1m\u001c8gS\u001e,(/\u0019;j_:LA!a\b\u0002\u001a\t\t3i\u001c8gS\u001e,(/\u0019;j_:\u0014VMZ3sK:\u001cW\rU3sg&\u001cH/\u001a8dK\u0006I2m\u001c8gS\u001e,(/\u0019;j_:\u0004VM]:jgR,gnY3!\u0003E\u0011X\r]8tSR|'/_!eCB$XM]\u000b\u0003\u0003O\u00012!SA\u0015\u0013\r\tYC\r\u0002\u0015'Fd'+\u001a9pg&$xN]=BI\u0006\u0004H/\u001a:\u0002%I,\u0007o\\:ji>\u0014\u00180\u00113baR,'\u000fI\u0001\u001aM\u0006\u001cW\r\u001e*fa>\u001c\u0018\u000e^8ss\u0012K7\u000f]1uG\",'\u000fE\u0002F\u0003gI1!!\u000e5\u0005e1\u0015mY3u%\u0016\u0004xn]5u_JLH)[:qCR\u001c\u0007.\u001a:\u0002\u0015M\fH\u000eR5bY\u0016\u001cG/\u0006\u0002\u0002<A!\u0011QHA2\u001d\u0011\ty$!\u0018\u000f\t\u0005\u0005\u0013\u0011\f\b\u0005\u0003\u0007\n)F\u0004\u0003\u0002F\u0005Mc\u0002BA$\u0003#rA!!\u0013\u0002P5\u0011\u00111\n\u0006\u0004\u0003\u001bb\u0014A\u0002\u001fs_>$h(C\u0001<\u0013\tI$(\u0003\u00028q%\u0019\u0011q\u000b\u001c\u0002\u0005\u0011\u0014\u0017bA\u001a\u0002\\)\u0019\u0011q\u000b\u001c\n\t\u0005}\u0013\u0011M\u0001\u000b'Fd')^5mI\u0016\u0014(bA\u001a\u0002\\%!\u0011QMA4\u0005\u001d!\u0015.\u00197fGRTA!a\u0018\u0002b\u0005Y1/\u001d7ES\u0006dWm\u0019;!\u0003\u0019a\u0014N\\5u}Q!\u0012qNA;\u0003o\nI(a\u001f\u0002~\u0005}\u0014\u0011QAB\u0003\u000b#B!!\u001d\u0002tA\u0011\u0011\n\u0001\u0005\b\u0003o\u0019\u00029AA\u001e\u0011\u0015\u00197\u00031\u0001e\u0011\u0015Q7\u00031\u0001m\u0011\u0015\u00018\u00031\u0001s\u0011\u001518\u00031\u0001y\u0011\u0015a8\u00031\u0001\u007f\u0011\u001d\t)a\u0005a\u0001\u0003\u0013Aq!!\u0005\u0014\u0001\u0004\t)\u0002C\u0004\u0002$M\u0001\r!a\n\t\u000f\u0005=2\u00031\u0001\u00022\u00051Q\r_5tiN$B!a#\u0002\u0012B\u0019q(!$\n\u0007\u0005=\u0005IA\u0004C_>dW-\u00198\t\u000f\u0005ME\u00031\u0001\u0002\u0016\u0006\u0011\u0011\u000e\u001a\t\u0005\u0003/\u000byJ\u0004\u0003\u0002\u001a\u0006m\u0005cAA%\u0001&\u0019\u0011Q\u0014!\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t+a)\u0003\rM#(/\u001b8h\u0015\r\ti\n\u0011\u0015\u0004)\u0005\u001d\u0006\u0003BAU\u0003_k!!a+\u000b\t\u00055\u0016\u0011M\u0001\fiJ\fgn]1di&|g.\u0003\u0003\u00022\u0006-&AC%t%\u0016\fGm\u00148ms\"\u001aA#!.\u0011\t\u0005]\u0016QY\u0007\u0003\u0003sSA!a/\u0002>\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\t\u0005}\u0016\u0011Y\u0001\b[\u0016$(/[2t\u0015\r\t\u0019MO\u0001\tG>$\u0017\r[1mK&!\u0011qYA]\u0005\u0015!\u0016.\\3e\u0003\u0019\u0019'/Z1uKR)A*!4\u0002R\"1\u0011qZ\u000bA\u00021\u000bqA]3mK\u0006\u001cX\rC\u0004\u0002TV\u0001\r!!6\u0002+I,G.Z1tK\u000e\u0013X-\u0019;j_:\u001cv.\u001e:dKB!\u0011q[Ao\u001b\t\tINC\u0002\u0002\\:\u000ba!\u001a<f]R\u001c\u0018\u0002BAp\u00033\u0014QCU3mK\u0006\u001cXm\u0011:fCRLwN\\*pkJ\u001cW\rK\u0002\u0016\u0003k\u000b\u0001BZ5oI\nK\u0018\n\u001a\u000b\u0004\u0019\u0006\u001d\bbBAJ-\u0001\u0007\u0011Q\u0013\u0015\u0004-\u0005UF#\u0002'\u0002n\u0006=\bbBAJ/\u0001\u0007\u0011Q\u0013\u0005\b\u0003c<\u0002\u0019AAz\u00039\u0011Xm]8mm\u0016|\u0005\u000f^5p]N\u0004B!!>\u0003\u00025\u0011\u0011q\u001f\u0006\u0004k\u0005e(\u0002BA~\u0003{\fAA[:p]*\u0019\u0011q \u001c\u0002\u001bM,'/[1mSj\fG/[8o\u0013\u0011\u0011\u0019!a>\u0003\u001dI+7o\u001c7wK>\u0003H/[8og\"\u001aq#!.\u0002\u001f\u0019Lg\u000eZ%eg\nK8\u000b^1ukN$BAa\u0003\u0003\u001eA1!Q\u0002B\f\u0003+sAAa\u0004\u0003\u00149!\u0011\u0011\nB\t\u0013\u0005\t\u0015b\u0001B\u000b\u0001\u00069\u0001/Y2lC\u001e,\u0017\u0002\u0002B\r\u00057\u00111aU3r\u0015\r\u0011)\u0002\u0011\u0005\b\u0005?A\u0002\u0019\u0001B\u0011\u0003!\u0019H/\u0019;vg\u0016\u001c\b#B \u0003$\t\u001d\u0012b\u0001B\u0013\u0001\nQAH]3qK\u0006$X\r\u001a \u0011\t\t%\"qF\u0007\u0003\u0005WQ1A!\fO\u0003\u0019\u0019H/\u0019;vg&!!\u0011\u0007B\u0016\u00055\u0011V\r\\3bg\u0016\u001cF/\u0019;vg\"\u001a\u0001$a*)\u0007a\t)\fK\u0002\u0019\u0005s\u0001BAa\u000f\u0003@5\u0011!Q\b\u0006\u0004\u0003w\u0003\u0015\u0002\u0002B!\u0005{\u0011qA^1sCJ<7/A\ngS:$')_\"bY\u0016tG-\u0019:U_.,g\u000eF\u0002M\u0005\u000fBqA!\u0013\u001a\u0001\u0004\t)*A\u0007dC2,g\u000eZ1s)>\\WM\u001c\u0015\u00043\u0005U\u0016\u0001\u00074j]\u0012\f%o\u00195jm\u0006\u0014G.\u001a*fY\u0016\f7/Z%egR1!1\u0002B)\u0005KBqAa\u0015\u001b\u0001\u0004\u0011)&\u0001\u0003eCR,\u0007\u0003\u0002B,\u0005Cj!A!\u0017\u000b\t\tm#QL\u0001\u0005kRLGN\u0003\u0002\u0003`\u0005!!.\u0019<b\u0013\u0011\u0011\u0019G!\u0017\u0003\t\u0011\u000bG/\u001a\u0005\b\u0005OR\u0002\u0019\u0001B5\u0003!\u0001\u0018mZ3TSj,\u0007cA \u0003l%\u0019!Q\u000e!\u0003\u0007%sG\u000fK\u0002\u001b\u0003OC3AGA[\u00039\u0019X\r\u001e)sK\u0006\u00138\r[5wK\u0012$bAa\u001e\u0003~\t\u0005\u0005cA \u0003z%\u0019!1\u0010!\u0003\tUs\u0017\u000e\u001e\u0005\b\u0005\u007fZ\u0002\u0019AAK\u0003%\u0011X\r\\3bg\u0016LE\rC\u0004\u0003\u0004n\u0001\r!a#\u0002\u0017A\u0014X-\u0011:dQ&4X\r\u001a\u0015\u00047\u0005U\u0016!\u00074j]\u0012\u0004&/Z!sG\"Lg/\u00192mKJ+G.Z1tKN$bAa#\u0003\u000e\nE\u0005#\u0002B\u0007\u0005/a\u0005b\u0002BH9\u0001\u0007!\u0011N\u0001\u0005a\u0006<W\rC\u0004\u0003hq\u0001\rA!\u001b)\u0007q\t9\u000bK\u0002\u001d\u0003k\u000baa]3be\u000eDG\u0003\u0002BN\u0005C\u0003RAa\u0016\u0003\u001e2KAAa(\u0003Z\t!A*[:u\u0011\u001d\u0011\u0019+\ba\u0001\u0005K\u000bAb]3be\u000eD\u0007+\u0019:b[N\u00042!\u0012BT\u0013\r\u0011I\u000b\u000e\u0002\u0016%\u0016dW-Y:f'\u0016\f'o\u00195CsB\u000b'/Y7tQ\ri\u0012QW\u0001\u0007I\u0016dW\r^3\u0015\t\t]$\u0011\u0017\u0005\b\u0003's\u0002\u0019AAKQ\rq\u0012QW\u0001\u0018I\u0016dW\r^3SK2,\u0017m]3SK\u001a,'/\u001a8dKN$bAa\u001e\u0003:\nm\u0006bBAJ?\u0001\u0007\u0011Q\u0013\u0005\b\u0005{{\u0002\u0019\u0001B5\u0003)\u0011X\r\\3bg\u0016,\u0016\u000eZ\u0001\u000eI\u0016dW\r^3XSRDW+\u001b3\u0015\r\t]$1\u0019Bc\u0011\u001d\t\u0019\n\ta\u0001\u0003+CqA!0!\u0001\u0004\u0011I\u0007K\u0002!\u0003k\u000bA!\\8wKR1!q\u000fBg\u0005#DqAa4\"\u0001\u0004\t)*\u0001\u0006pe&<\u0017N\\1m\u0013\u0012DqAa5\"\u0001\u0004\t)*A\u0003oK^LE\rK\u0002\"\u0003k\u000b\u0011bZ3u'R\fG/^:\u0015\t\t\u001d\"1\u001c\u0005\b\u0003'\u0013\u0003\u0019AAKQ\r\u0011\u0013QW\u0001\fO\u0016$8\u000b^1ukN,7\u000f\u0006\u0003\u0003d\n\u0015\bC\u0002B\u0007\u0005/\u00119\u0003C\u0004\u0003h\u000e\u0002\rAa\u0003\u0002\u0007%$7\u000fK\u0002$\u0003k\u000bQbZ3u%&\u001c8nU2pe\u0016\u001cH\u0003\u0002Bx\u0005c\u0004bA!\u0004\u0003\u0018\t%\u0004b\u0002BtI\u0001\u0007!1\u0002\u0015\u0004I\u0005\u001d\u0006f\u0001\u0013\u00026\u0006i1/\u001a;SSN\\7kY8sKN$\u0002Ba\u001e\u0003|\nu8\u0011\u0001\u0005\b\u0005\u007f*\u0003\u0019AAK\u0011\u001d\u0011y0\na\u0001\u0005S\nQa]2pe\u0016Dqaa\u0001&\u0001\u0004\u0011I'\u0001\u0006u_R\fGnU2pe\u0016D3!JA[\u0003)I7\u000fV3na2\fG/\u001a\u000b\u0005\u0003\u0017\u001bY\u0001C\u0004\u0003\u0000\u0019\u0002\r!!&)\u0007\u0019\n9\u000bK\u0002'\u0003k\u000b\u0001bZ3u)&$H.\u001a\u000b\u0005\u0003+\u001b)\u0002C\u0004\u0002\u0014\u001e\u0002\r!!&)\u0007\u001d\n9\u000bK\u0002(\u0003k\u000ba!\u001e9eCR,Gc\u0001'\u0004 !1\u0011q\u001a\u0015A\u00021C3\u0001KA[)\u0015a5QEB\u0015\u0011\u0019\u00199#\u000ba\u0001\u0019\u0006AqN]5hS:\fG\u000e\u0003\u0004\u0004,%\u0002\r\u0001T\u0001\bkB$\u0017\r^3eQ\rI\u0013QW\u0001\be\u0016\u0004H.Y2f)\u0015a51GB\u001b\u0011\u0019\u00199C\u000ba\u0001\u0019\"111\u0006\u0016A\u00021C3AKA[\u0003)9W\r^!mYR\u000bwm\u001d\u000b\u0005\u0007{\u0019\u0019\u0005\u0005\u0004\u0003X\r}\u0012QS\u0005\u0005\u0007\u0003\u0012IFA\u0002TKRDqa!\u0012,\u0001\u0004\u0011I'A\u0006mS6LGOT;nE\u0016\u0014\bfA\u0016\u0002(\"\u001a1&!.\u0002\u0015\u001d,GOU3mK\u0006\u001cX\rF\u0003M\u0007\u001f\u001aY\u0007C\u0004\u0003\u00001\u0002\ra!\u0015\u0011\t\rM3Q\r\b\u0005\u0007+\u001a\tG\u0004\u0003\u0004X\r}c\u0002BB-\u0007;rA!a\u0011\u0004\\%\u0011QGN\u0005\u0003gQJ!a\u001a\u001a\n\u0007\r\rd-\u0001\u0003DS&#\u0017\u0002BB4\u0007S\u0012AaQ5JI*\u001911\r4\t\u000f\u0005EH\u00061\u0001\u0002t\u0006\u00113\r[3dW&\u001bhj\u001c;SK\u001a,'/\u001a8dK\u0012\u0014\u0015\u0010R3qK:$WM\\2jKN$BAa\u001e\u0004r!911O\u0017A\u0002\rE\u0013a\u00069mC:LE/Z7JI>\u0013\u0018\n^:DQ&dGM]3o\u0003=1\u0017N\u001c3T\u00076#\u0015\r^1Cs&#G\u0003BB=\u0007\u0017\u0003RaPB>\u0007\u007fJ1a! A\u0005\u0019y\u0005\u000f^5p]B!1\u0011QBD\u001b\t\u0019\u0019I\u0003\u0003\u0004\u0006\nu\u0013\u0001\u00027b]\u001eLAa!#\u0004\u0004\n9\u0011J\u001c;fO\u0016\u0014\bbBAJ]\u0001\u0007\u0011Q\u0013\u0015\u0004]\u0005\u001d\u0006f\u0001\u0018\u00026\u0006)b-\u001b8e\u001fZ,'\u000fZ;f%\u0016dW-Y:f\u0013\u0012\u001cHC\u0001B\u0006Q\ry\u0013q\u0015\u0015\u0004_\u0005U\u0016AD4fiJ+G.Z1tK*\u001bxN\u001c\u000b\u0005\u0003+\u001bi\nC\u0004\u0003\u0000A\u0002\r!!&)\u0007A\n9\u000bK\u00021\u0003kC3\u0001ABS!\u0011\tIka*\n\t\r%\u00161\u0016\u0002\u0010\u0013N$&/\u00198tC\u000e$\u0018n\u001c8bY\u0002")
public class SqlReleaseRepository
implements ReleaseRepository,
InterceptedRepository<Release>,
Logging,
DeserializationSupport,
ConfigurationReferencesSupport,
SqlReleaseRepositoryHelper {
    private final ReleasePersistence releasePersistence;
    private final TaskPersistence taskPersistence;
    private final DependencyPersistence dependencyPersistence;
    private final CommentPersistence commentPersistence;
    private final TeamRepository teamRepository;
    private final ReleaseExtensionsRepository releaseExtensionsRepository;
    private final ConfigurationReferencePersistence configurationPersistence;
    private final SqlRepositoryAdapter repositoryAdapter;
    private final FacetRepositoryDispatcher facetRepositoryDispatcher;
    private final SqlBuilder.Dialect sqlDialect;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private scala.collection.immutable.Seq<PersistenceInterceptor<Release>> persistenceInterceptors;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public void replaceTasks(Release original, Release updated) {
        SqlReleaseRepositoryHelper.replaceTasks$(this, original, updated);
    }

    @Override
    public void replaceReleaseExtensions(Release original, Release updated) {
        SqlReleaseRepositoryHelper.replaceReleaseExtensions$(this, original, updated);
    }

    @Override
    public void replaceReleaseTeams(Release original, Release updated) {
        SqlReleaseRepositoryHelper.replaceReleaseTeams$(this, original, updated);
    }

    @Override
    public void updateCommentsOnTasks(Task originalTask, Task updatedTask) {
        SqlReleaseRepositoryHelper.updateCommentsOnTasks$(this, originalTask, updatedTask);
    }

    @Override
    public void insertDependency(Integer gateTaskUid, Dependency dependency) {
        SqlReleaseRepositoryHelper.insertDependency$(this, gateTaskUid, dependency);
    }

    @Override
    public void updateConfigurationRefs(CiWithUid entity) {
        ConfigurationReferencesSupport.updateConfigurationRefs$(this, entity);
    }

    @Override
    public void deleteConfigurationRefs(Integer uid) {
        ConfigurationReferencesSupport.deleteConfigurationRefs$(this, uid);
    }

    @Override
    public Release deserializeRelease(ReleaseRow releaseData, ResolveOptions resolveOptions) {
        return DeserializationSupport.deserializeRelease$(this, releaseData, resolveOptions);
    }

    @Override
    public Option<Release> tryDeserializeRelease(ReleaseRow releaseData, ResolveOptions resolveOptions) {
        return DeserializationSupport.tryDeserializeRelease$(this, releaseData, resolveOptions);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    public void registerPersistenceInterceptor(PersistenceInterceptor<Release> persistenceInterceptor) {
        InterceptedRepository.registerPersistenceInterceptor$((InterceptedRepository)this, persistenceInterceptor);
    }

    public void interceptCreate(ConfigurationItem ci) {
        InterceptedRepository.interceptCreate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void interceptDelete(String ciId) {
        InterceptedRepository.interceptDelete$((InterceptedRepository)this, (String)ciId);
    }

    public void interceptUpdate(ConfigurationItem ci) {
        InterceptedRepository.interceptUpdate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterCreate(ConfigurationItem ci) {
        InterceptedRepository.afterCreate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterUpdate(ConfigurationItem ci) {
        InterceptedRepository.afterUpdate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterDelete(String ciId) {
        InterceptedRepository.afterDelete$((InterceptedRepository)this, (String)ciId);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlReleaseRepository sqlReleaseRepository = this;
        synchronized (sqlReleaseRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public scala.collection.immutable.Seq<PersistenceInterceptor<Release>> persistenceInterceptors() {
        return this.persistenceInterceptors;
    }

    public void persistenceInterceptors_$eq(scala.collection.immutable.Seq<PersistenceInterceptor<Release>> x$1) {
        this.persistenceInterceptors = x$1;
    }

    public scala.collection.immutable.Seq<String> findIdsByStatus(ReleaseStatus ... statuses) {
        return this.findIdsByStatus((scala.collection.immutable.Seq<ReleaseStatus>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])statuses));
    }

    public TaskPersistence taskPersistence() {
        return this.taskPersistence;
    }

    public DependencyPersistence dependencyPersistence() {
        return this.dependencyPersistence;
    }

    public CommentPersistence commentPersistence() {
        return this.commentPersistence;
    }

    public TeamRepository teamRepository() {
        return this.teamRepository;
    }

    public ReleaseExtensionsRepository releaseExtensionsRepository() {
        return this.releaseExtensionsRepository;
    }

    @Override
    public ConfigurationReferencePersistence configurationPersistence() {
        return this.configurationPersistence;
    }

    @Override
    public SqlRepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    public SqlBuilder.Dialect sqlDialect() {
        return this.sqlDialect;
    }

    @Timed
    @IsReadOnly
    public boolean exists(String id) {
        return this.releasePersistence.existsRelease(CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(id)));
    }

    @Timed
    public Release create(Release release, ReleaseCreationSource releaseCreationSource) {
        if (this.releasePersistence.existsRelease(release.getId())) {
            throw new ItemAlreadyExistsException("A release with ID [%s] already exists", new Object[]{release.getId()});
        }
        this.interceptCreate((ConfigurationItem)release);
        this.releasePersistence.insert(release);
        CollectionConverters$.MODULE$.ListHasAsScala(release.getAllTasks()).asScala().foreach((Function1 & Serializable)task -> {
            SqlReleaseRepository.$anonfun$create$1(this, release, task);
            return BoxedUnit.UNIT;
        });
        release.getExtensions().forEach(extension -> this.releaseExtensionsRepository().create(extension));
        this.updateConfigurationRefs((CiWithUid)release);
        this.facetRepositoryDispatcher.liveRepository().createFromTasks(CollectionConverters$.MODULE$.ListHasAsScala(release.getAllTasks()).asScala().toSeq(), this.facetRepositoryDispatcher.liveRepository().createFromTasks$default$2());
        return release;
    }

    @Timed
    public Release findById(String id) {
        return this.getRelease(id, new ResolveOptionsBuilder().withEverything().build());
    }

    @Timed
    public Release findById(String id, ResolveOptions resolveOptions) {
        return this.getRelease(id, resolveOptions);
    }

    @Timed
    @IsReadOnly
    public scala.collection.immutable.Seq<String> findIdsByStatus(scala.collection.immutable.Seq<ReleaseStatus> statuses) {
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseId().withOneOfStatuses(statuses).build();
        return this.releasePersistence.findReleaseIdsByQuery((Tuple2<String, scala.collection.immutable.Seq<Object>>)sqlWithParams).toSeq();
    }

    @Timed
    public Release findByCalendarToken(String calendarToken) {
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseData().withCalendarToken(calendarToken).build();
        scala.collection.immutable.Seq<ReleaseRow> releases = this.releasePersistence.findReleaseDatasByQuery((Tuple2<String, scala.collection.immutable.Seq<Object>>)sqlWithParams);
        return (Release)releases.headOption().map((Function1 & Serializable)x$1 -> this.deserializeRelease((ReleaseRow)x$1, new ResolveOptionsBuilder().withEverything().build())).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    @Timed
    @IsReadOnly
    public scala.collection.immutable.Seq<String> findArchivableReleaseIds(Date date, int pageSize) {
        ReleasesSqlBuilder qual$1 = (ReleasesSqlBuilder)new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseId().withOneOfStatuses((scala.collection.immutable.Seq<ReleaseStatus>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ReleaseStatus[]{ReleaseStatus.COMPLETED, ReleaseStatus.ABORTED})))).withEndDateBefore(date).withPage(new Page(0L, (long)pageSize, Predef$.MODULE$.int2Integer(0), Page$.MODULE$.apply$default$4()));
        boolean x$1 = qual$1.withPreArchived$default$1();
        Tuple2 sqlWithParams = qual$1.withPreArchived(x$1).build();
        return this.releasePersistence.findReleaseIdsByQuery((Tuple2<String, scala.collection.immutable.Seq<Object>>)sqlWithParams).toSeq();
    }

    @Timed
    public void setPreArchived(String releaseId, boolean preArchived) {
        this.releasePersistence.setPreArchived(releaseId, preArchived);
    }

    @Timed
    @IsReadOnly
    public scala.collection.immutable.Seq<Release> findPreArchivableReleases(int page, int pageSize) {
        scala.collection.immutable.Seq inactive = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ReleaseStatus[]{ReleaseStatus.COMPLETED, ReleaseStatus.ABORTED}));
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseData().withOneOfStatuses((scala.collection.immutable.Seq<ReleaseStatus>)inactive).withPreArchived(false).limitAndOffset(pageSize, page * pageSize).build();
        return (scala.collection.immutable.Seq)((IterableOps)((IterableOps)((IterableOps)this.releasePersistence.findReleaseDatasByQuery((Tuple2<String, scala.collection.immutable.Seq<Object>>)sqlWithParams).flatMap((Function1 & Serializable)x$2 -> this.tryDeserializeRelease((ReleaseRow)x$2, new ResolveOptionsBuilder().withEverything().build()))).filterNot((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isTutorial()))).map((Function1 & Serializable)release -> this.releaseExtensionsRepository().decorate(release))).map((Function1 & Serializable)release -> this.commentPersistence().decorate((Release)release));
    }

    @Timed
    public List<Release> search(ReleaseSearchByParams searchParams) {
        ReleaseSearchByParams releaseSearchByParams = searchParams;
        if (releaseSearchByParams == null) {
            throw new MatchError((Object)releaseSearchByParams);
        }
        Page page = releaseSearchByParams.page();
        Either folderId2 = releaseSearchByParams.folderId();
        ReleaseStatus[] statuses = releaseSearchByParams.statuses();
        String title = releaseSearchByParams.title();
        String rootReleaseId = releaseSearchByParams.rootReleaseId();
        boolean autoStart = releaseSearchByParams.autoStart();
        ReleasesSqlBuilder base = (ReleasesSqlBuilder)new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseData().withTitle(title).withRootReleaseId(rootReleaseId).withPage(page);
        ReleasesSqlBuilder sqlBuilder = folderId2 == null ? base : (ReleasesSqlBuilder)folderId2.fold((Function1 & Serializable)folderId -> base.withFolder((String)folderId), (Function1 & Serializable)ancestorId -> base.withAncestor((String)ancestorId));
        Object object = ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])statuses)) ? sqlBuilder.withOneOfStatuses((scala.collection.immutable.Seq<ReleaseStatus>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)statuses)) : BoxedUnit.UNIT;
        Object object2 = autoStart ? sqlBuilder.withAutoStart() : BoxedUnit.UNIT;
        List list = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOps)((IterableOps)this.releasePersistence.findReleaseDatasByQuery((Tuple2<String, scala.collection.immutable.Seq<Object>>)sqlBuilder.build()).flatMap((Function1 & Serializable)x$4 -> this.tryDeserializeRelease((ReleaseRow)x$4, new ResolveOptionsBuilder().withEverything().build()))).map((Function1 & Serializable)release -> this.releaseExtensionsRepository().decorate(release))).map((Function1 & Serializable)release -> this.commentPersistence().decorate((Release)release))).asJava();
        return list;
    }

    @Timed
    public void delete(String id) {
        this.checkIsNotReferencedByDependencies(id);
        this.releasePersistence.findUidByReleaseId(id).foreach((Function1 & Serializable)uid -> {
            this.deleteReleaseReferences(id, uid);
            return BoxedUnit.UNIT;
        });
        this.releasePersistence.deleteById(id);
    }

    private void deleteReleaseReferences(String id, int releaseUid) {
        this.dependencyPersistence().deleteByReleaseUid(Predef$.MODULE$.int2Integer(releaseUid));
        this.commentPersistence().deleteByRelease(Predef$.MODULE$.int2Integer(releaseUid));
        this.taskPersistence().deleteTasksByReleaseUid(releaseUid);
        this.teamRepository().deleteTeamsFromPlatform(new SecuredCi(id, releaseUid));
        this.releaseExtensionsRepository().deleteAll(id);
        this.deleteConfigurationRefs(Predef$.MODULE$.int2Integer(releaseUid));
        this.interceptDelete(id);
    }

    @Timed
    public void deleteWithUid(String id, int releaseUid) {
        this.deleteReleaseReferences(id, releaseUid);
        this.releasePersistence.deleteById(id);
    }

    @Timed
    public void move(String originalId, String newId) {
        this.releasePersistence.move(originalId, newId);
    }

    @Timed
    public ReleaseStatus getStatus(String id) {
        String status = (String)this.releasePersistence.findReleaseStatus(CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(id))).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return status == null ? null : ReleaseStatus.valueOf((String)status.toUpperCase());
    }

    @Timed
    public scala.collection.immutable.Seq<ReleaseStatus> getStatuses(scala.collection.immutable.Seq<String> ids) {
        return ids.isEmpty() ? (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$) : (scala.collection.immutable.Seq)this.releasePersistence.findReleaseStatuses(ids).map((Function1 & Serializable)status -> ReleaseStatus.valueOf((String)status.toUpperCase()));
    }

    @Timed
    @IsReadOnly
    public scala.collection.immutable.Seq<Object> getRiskScores(scala.collection.immutable.Seq<String> ids) {
        return this.releasePersistence.findReleaseRiskScores(ids);
    }

    @Timed
    public void setRiskScores(String releaseId, int score, int totalScore) {
        this.releasePersistence.updateReleaseRiskScores(releaseId, score, totalScore);
    }

    @Timed
    @IsReadOnly
    public boolean isTemplate(String releaseId) {
        return ReleaseStatus.TEMPLATE.equals(this.getStatus(releaseId));
    }

    @Timed
    @IsReadOnly
    public String getTitle(String id) {
        return (String)this.releasePersistence.findReleaseTitle(CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(id))).getOrElse((Function0 & Serializable)() -> {
            throw new LogFriendlyNotFoundException("Release [%s] not found", new Object[]{id});
        });
    }

    @Timed
    public Release update(Release release) {
        return this.update(null, release);
    }

    @Timed
    public Release update(Release original, Release updated) {
        Option originalReleaseOpt = Option$.MODULE$.apply((Object)original);
        this.releasePersistence.update((Option<Release>)Option$.MODULE$.apply((Object)original), updated);
        originalReleaseOpt.foreach((Function1 & Serializable)rel -> {
            SqlReleaseRepository.$anonfun$update$1(this, updated, rel);
            return BoxedUnit.UNIT;
        });
        this.updateConfigurationRefs((CiWithUid)updated);
        return updated;
    }

    @Timed
    public Release replace(Release original, Release updated) {
        if (Ids.isFolderId((String)original.getId())) {
            updated.setTeams(Collections.emptyList());
        }
        this.releasePersistence.update((Option<Release>)Option$.MODULE$.apply((Object)original), updated);
        if (original != null) {
            this.replaceTasks(original, updated);
            this.replaceReleaseExtensions(original, updated);
            this.replaceReleaseTeams(original, updated);
        }
        this.updateConfigurationRefs((CiWithUid)updated);
        return updated;
    }

    @Timed
    @IsReadOnly
    public Set<String> getAllTags(int limitNumber) {
        return CollectionConverters$.MODULE$.SetHasAsJava(this.releasePersistence.findAllTags(limitNumber)).asJava();
    }

    /*
     * WARNING - void declaration
     */
    private Release getRelease(String releaseId, ResolveOptions resolveOptions) {
        void var3_3;
        BoxedUnit boxedUnit;
        Release release = (Release)this.repositoryAdapter().read(releaseId, resolveOptions);
        if (release == null) {
            throw new LogFriendlyNotFoundException(new StringBuilder(30).append("Repository entity [").append(releaseId).append("] not found").toString(), new Object[0]);
        }
        if (resolveOptions.hasDecorators()) {
            this.releaseExtensionsRepository().decorate(release);
            boxedUnit = this.commentPersistence().decorate(release);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return var3_3;
    }

    private void checkIsNotReferencedByDependencies(String planItemIdOrItsChildren) {
        scala.collection.immutable.Seq externalIncomingDependencies = (scala.collection.immutable.Seq)((IterableOps)this.dependencyPersistence().findByPartialTargetIds((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{planItemIdOrItsChildren}))), (Option<scala.collection.immutable.Set<String>>)None$.MODULE$).map((Function1 & Serializable)x$6 -> DependencyRow$.MODULE$.DependencyRowOps((DependencyRow)x$6).fullDependencyId())).filterNot((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.startsWith(CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(planItemIdOrItsChildren)))));
        if (externalIncomingDependencies.nonEmpty()) {
            throw new ItemInUseException(new StringBuilder(0).append(new StringBuilder(68).append("Cannot delete [").append(planItemIdOrItsChildren).append("] because it or one of its children is referenced by ").toString()).append(new StringBuilder(28).append("one or more dependencies: [").append(externalIncomingDependencies.mkString(", ")).append("]").toString()).toString(), new Object[0]);
        }
    }

    @Timed
    @IsReadOnly
    public Option<Integer> findSCMDataById(String id) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(49).append("Finding scm data for template or release with id ").append(id).toString());
        return this.releasePersistence.findSCMDataById(id).map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1));
    }

    @Timed
    @IsReadOnly
    public scala.collection.immutable.Seq<String> findOverdueReleaseIds() {
        return this.releasePersistence.findOverdueReleaseIds();
    }

    @Timed
    @IsReadOnly
    public String getReleaseJson(String releaseId) {
        return (String)this.releasePersistence.findByReleaseId(releaseId).map((Function1 & Serializable)x$8 -> x$8.json()).getOrElse((Function0 & Serializable)() -> {
            throw new LogFriendlyNotFoundException(new StringBuilder(30).append("Repository entity [").append(releaseId).append("] not found").toString(), new Object[0]);
        });
    }

    public static final /* synthetic */ boolean $anonfun$create$2(SqlReleaseRepository $this, Integer taskUid$1, Comment comment) {
        return $this.commentPersistence().create(taskUid$1, CommentPersistence$CommentRow$.MODULE$.fromComment(comment));
    }

    public static final /* synthetic */ void $anonfun$create$1(SqlReleaseRepository $this, Release release$1, Task task) {
        Integer taskUid = $this.taskPersistence().insert(task, Predef$.MODULE$.Integer2int(release$1.getCiUid()));
        syntax.TaskOps$.MODULE$.comments$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable)comment -> BoxesRunTime.boxToBoolean((boolean)SqlReleaseRepository.$anonfun$create$2($this, taskUid, comment)));
        syntax.TaskOps$.MODULE$.dependencies$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable)dependency -> {
            $this.insertDependency(taskUid, dependency);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$update$3(SqlReleaseRepository $this, Integer taskUid$2, Comment c) {
        return $this.commentPersistence().create(taskUid$2, CommentPersistence$CommentRow$.MODULE$.fromComment(c));
    }

    public static final /* synthetic */ void $anonfun$update$2(SqlReleaseRepository $this, Release updated$1, Task task) {
        Integer taskUid = $this.taskPersistence().insert(task, Predef$.MODULE$.Integer2int(updated$1.getCiUid()));
        syntax.TaskOps$.MODULE$.comments$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)SqlReleaseRepository.$anonfun$update$3($this, taskUid, c)));
        ((IterableOnceOps)syntax.TaskOps$.MODULE$.dependencies$extension(syntax$.MODULE$.TaskOps(task)).filterNot((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isArchived()))).foreach((Function1 & Serializable)dependency -> {
            $this.insertDependency(taskUid, dependency);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$update$1(SqlReleaseRepository $this, Release updated$1, Release rel) {
        Diff$.MODULE$.apply((Iterable)CollectionConverters$.MODULE$.ListHasAsScala(rel.getAllTasks()).asScala(), (Iterable)CollectionConverters$.MODULE$.ListHasAsScala(updated$1.getAllTasks()).asScala()).newValues().foreach((Function1 & Serializable)task -> {
            SqlReleaseRepository.$anonfun$update$2($this, updated$1, task);
            return BoxedUnit.UNIT;
        });
    }

    public SqlReleaseRepository(ReleasePersistence releasePersistence, TaskPersistence taskPersistence, DependencyPersistence dependencyPersistence, CommentPersistence commentPersistence, TeamRepository teamRepository, ReleaseExtensionsRepository releaseExtensionsRepository, ConfigurationReferencePersistence configurationPersistence, SqlRepositoryAdapter repositoryAdapter, FacetRepositoryDispatcher facetRepositoryDispatcher, SqlBuilder.Dialect sqlDialect) {
        this.releasePersistence = releasePersistence;
        this.taskPersistence = taskPersistence;
        this.dependencyPersistence = dependencyPersistence;
        this.commentPersistence = commentPersistence;
        this.teamRepository = teamRepository;
        this.releaseExtensionsRepository = releaseExtensionsRepository;
        this.configurationPersistence = configurationPersistence;
        this.repositoryAdapter = repositoryAdapter;
        this.facetRepositoryDispatcher = facetRepositoryDispatcher;
        this.sqlDialect = sqlDialect;
        InterceptedRepository.$init$((InterceptedRepository)this);
        Logging.$init$((Logging)this);
        DeserializationSupport.$init$(this);
        ConfigurationReferencesSupport.$init$(this);
        SqlReleaseRepositoryHelper.$init$(this);
    }
}

