/*
 * Decompiled with CFR 0.152.
 */
package akka.http.impl.engine.http2.framing;

import akka.annotation.InternalApi;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.http.impl.engine.http2.FrameEvent;
import akka.http.impl.engine.http2.Http2Compliance$;
import akka.http.impl.engine.http2.Http2Protocol;
import akka.http.impl.engine.http2.Http2Protocol$SettingIdentifier$SETTINGS_MAX_FRAME_SIZE$;
import akka.http.impl.engine.http2.framing.FrameRenderer$;
import akka.http.impl.engine.http2.framing.Http2FrameRendering$;
import akka.stream.Attributes;
import akka.stream.Attributes$;
import akka.stream.FlowShape;
import akka.stream.Inlet;
import akka.stream.Inlet$;
import akka.stream.Outlet;
import akka.stream.Outlet$;
import akka.stream.stage.GraphStage;
import akka.stream.stage.GraphStageLogic;
import akka.stream.stage.InHandler;
import akka.stream.stage.OutHandler;
import akka.stream.stage.StageLogging;
import akka.util.ByteString;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Function1;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u00054QAC\u0006\u0001']AQA\f\u0001\u0005\u0002ABqa\r\u0001C\u0002\u0013\u0005A\u0007\u0003\u00049\u0001\u0001\u0006I!\u000e\u0005\bs\u0001\u0011\r\u0011\"\u0001;\u0011\u0019q\u0004\u0001)A\u0005w!)q\b\u0001C!\u0001\"9A\t\u0001b\u0001\n\u0003*\u0005B\u0002$\u0001A\u0003%\u0001\u0005C\u0003H\u0001\u0011\u0005\u0003JA\nIiR\u0004(G\u0012:b[\u0016\u0014VM\u001c3fe&twM\u0003\u0002\r\u001b\u00059aM]1nS:<'B\u0001\b\u0010\u0003\u0015AG\u000f\u001e93\u0015\t\u0001\u0012#\u0001\u0004f]\u001eLg.\u001a\u0006\u0003%M\tA![7qY*\u0011A#F\u0001\u0005QR$\bOC\u0001\u0017\u0003\u0011\t7n[1\u0014\u0005\u0001A\u0002cA\r\u001fA5\t!D\u0003\u0002\u001c9\u0005)1\u000f^1hK*\u0011Q$F\u0001\u0007gR\u0014X-Y7\n\u0005}Q\"AC$sCBD7\u000b^1hKB!\u0011E\t\u0013)\u001b\u0005a\u0012BA\u0012\u001d\u0005%1En\\<TQ\u0006\u0004X\r\u0005\u0002&M5\tQ\"\u0003\u0002(\u001b\tQaI]1nK\u00163XM\u001c;\u0011\u0005%bS\"\u0001\u0016\u000b\u0005-*\u0012\u0001B;uS2L!!\f\u0016\u0003\u0015\tKH/Z*ue&tw-\u0001\u0004=S:LGOP\u0002\u0001)\u0005\t\u0004C\u0001\u001a\u0001\u001b\u0005Y\u0011a\u00024sC6,\u0017J\\\u000b\u0002kA\u0019\u0011E\u000e\u0013\n\u0005]b\"!B%oY\u0016$\u0018\u0001\u00034sC6,\u0017J\u001c\u0011\u0002\r9,GoT;u+\u0005Y\u0004cA\u0011=Q%\u0011Q\b\b\u0002\u0007\u001fV$H.\u001a;\u0002\u000f9,GoT;uA\u0005\t\u0012N\\5uS\u0006d\u0017\t\u001e;sS\n,H/Z:\u0016\u0003\u0005\u0003\"!\t\"\n\u0005\rc\"AC!uiJL'-\u001e;fg\u0006)1\u000f[1qKV\t\u0001%\u0001\u0004tQ\u0006\u0004X\rI\u0001\fGJ,\u0017\r^3M_\u001eL7\r\u0006\u0002J1J)!\nT(S+\u001a!1*\u0003\u0001J\u00051a$/\u001a4j]\u0016lWM\u001c;?!\tIR*\u0003\u0002O5\tyqI]1qQN#\u0018mZ3M_\u001eL7\r\u0005\u0002\u001a!&\u0011\u0011K\u0007\u0002\n\u0013:D\u0015M\u001c3mKJ\u0004\"!G*\n\u0005QS\"AC(vi\"\u000bg\u000e\u001a7feB\u0011\u0011DV\u0005\u0003/j\u0011Ab\u0015;bO\u0016dunZ4j]\u001eDQ!W\u0005A\u0002\u0005\u000b1#\u001b8iKJLG/\u001a3BiR\u0014\u0018NY;uKND#\u0001A.\u0011\u0005q{V\"A/\u000b\u0005y+\u0012AC1o]>$\u0018\r^5p]&\u0011\u0001-\u0018\u0002\f\u0013:$XM\u001d8bY\u0006\u0003\u0018\u000e")
@InternalApi
public class Http2FrameRendering
extends GraphStage<FlowShape<FrameEvent, ByteString>> {
    private final Inlet<FrameEvent> frameIn = Inlet$.MODULE$.apply("Http2FrameRendering.frameIn");
    private final Outlet<ByteString> netOut = Outlet$.MODULE$.apply("Http2FrameRendering.netOut");
    private final FlowShape<FrameEvent, ByteString> shape = new FlowShape(this.frameIn(), this.netOut());

    public Inlet<FrameEvent> frameIn() {
        return this.frameIn;
    }

    public Outlet<ByteString> netOut() {
        return this.netOut;
    }

    public Attributes initialAttributes() {
        return Attributes$.MODULE$.name(Logging$.MODULE$.simpleName(this.getClass()));
    }

    public FlowShape<FrameEvent, ByteString> shape() {
        return this.shape;
    }

    public GraphStageLogic createLogic(Attributes inheritedAttributes) {
        return new InHandler(this){
            private int _outMaxFrameSize;
            private LoggingAdapter akka$stream$stage$StageLogging$$_log;
            private final /* synthetic */ Http2FrameRendering $outer;

            public Class<?> logSource() {
                return StageLogging.logSource$((StageLogging)this);
            }

            public LoggingAdapter log() {
                return StageLogging.log$((StageLogging)this);
            }

            public void onDownstreamFinish() throws Exception {
                OutHandler.onDownstreamFinish$((OutHandler)this);
            }

            public void onUpstreamFinish() throws Exception {
                InHandler.onUpstreamFinish$((InHandler)this);
            }

            public void onUpstreamFailure(Throwable ex) throws Exception {
                InHandler.onUpstreamFailure$((InHandler)this, (Throwable)ex);
            }

            public LoggingAdapter akka$stream$stage$StageLogging$$_log() {
                return this.akka$stream$stage$StageLogging$$_log;
            }

            public void akka$stream$stage$StageLogging$$_log_$eq(LoggingAdapter x$1) {
                this.akka$stream$stage$StageLogging$$_log = x$1;
            }

            private int _outMaxFrameSize() {
                return this._outMaxFrameSize;
            }

            private void _outMaxFrameSize_$eq(int x$1) {
                this._outMaxFrameSize = x$1;
            }

            private final int maxOutFrameSize() {
                return this._outMaxFrameSize();
            }

            private final void updateMaxOutFrameSize(int value) {
                Http2Compliance$.MODULE$.validateMaxFrameSize(value);
                this._outMaxFrameSize_$eq(value);
            }

            public void onPush() {
                FrameEvent.DataFrame dataFrame;
                ByteString payload;
                FrameEvent frame2 = (FrameEvent)this.grab(this.$outer.frameIn());
                FrameEvent frameEvent = frame2;
                if (frameEvent instanceof FrameEvent.DataFrame && (payload = (dataFrame = (FrameEvent.DataFrame)frameEvent).payload()).size() > this.maxOutFrameSize()) {
                    Iterator splitDataFrames = this.splitByPayloadSize(dataFrame, this.maxOutFrameSize()).iterator().map((Function1 & Serializable)frame -> FrameRenderer$.MODULE$.render((FrameEvent)frame));
                    this.emitMultiple(this.$outer.netOut(), splitDataFrames);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (frameEvent instanceof FrameEvent.SettingsAckFrame) {
                    FrameEvent.SettingsAckFrame settingsAckFrame = (FrameEvent.SettingsAckFrame)frameEvent;
                    Seq<FrameEvent.Setting> s2 = settingsAckFrame.acked();
                    this.applySettings(s2);
                    this.push(this.$outer.netOut(), FrameRenderer$.MODULE$.render(settingsAckFrame));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    ByteString rendered = FrameRenderer$.MODULE$.render(frame2);
                    this.push(this.$outer.netOut(), rendered);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }

            public void onPull() {
                this.pull(this.$outer.frameIn());
            }

            private Seq<FrameEvent.DataFrame> splitByPayloadSize(FrameEvent.DataFrame d, int size) {
                Vector vector;
                this.log().debug("Splitting up too large data-frame into smaller frames due to exceeding max frame size. Length: {}, max: {}", (Object)BoxesRunTime.boxToInteger((int)d.payload().length()), (Object)BoxesRunTime.boxToInteger((int)size));
                Iterator parts = d.payload().grouped(size);
                if (d.endStream()) {
                    if (d.payload().nonEmpty()) {
                        throw new IllegalStateException("DataFrame marked endStream should have empty payload!");
                    }
                    Vector all = parts.map((Function1 & Serializable)p -> {
                        boolean x$1 = false;
                        ByteString x$2 = p;
                        int x$3 = d.copy$default$1();
                        return d.copy(x$3, false, x$2);
                    }).toVector();
                    FrameEvent.DataFrame[] dataFrameArray = new FrameEvent.DataFrame[1];
                    FrameEvent.DataFrame qual$1 = (FrameEvent.DataFrame)all.last();
                    boolean bl = true;
                    int x$5 = qual$1.copy$default$1();
                    ByteString x$6 = qual$1.copy$default$3();
                    dataFrameArray[0] = qual$1.copy(x$5, true, x$6);
                    vector = (Seq)all.dropRight(1).$plus$plus((IterableOnce)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])dataFrameArray)));
                } else {
                    vector = parts.map((Function1 & Serializable)p -> {
                        ByteString x$7 = p;
                        int x$8 = d.copy$default$1();
                        boolean x$9 = d.copy$default$2();
                        return d.copy(x$8, x$9, x$7);
                    }).toVector();
                }
                return vector;
            }

            private void applySettings(Seq<FrameEvent.Setting> s2) {
                s2.foreach((Function1 & Serializable)x0$1 -> {
                    $anon$1.$anonfun$applySettings$1(this, x0$1);
                    return BoxedUnit.UNIT;
                });
            }

            /*
             * Enabled aggressive block sorting
             */
            public static final /* synthetic */ void $anonfun$applySettings$1($anon$1 $this, FrameEvent.Setting x0$1) {
                FrameEvent.Setting setting = x0$1;
                if (setting != null) {
                    Http2Protocol.SettingIdentifier settingIdentifier = setting.identifier();
                    int value = setting.value();
                    if (Http2Protocol$SettingIdentifier$SETTINGS_MAX_FRAME_SIZE$.MODULE$.equals(settingIdentifier)) {
                        $this.updateMaxOutFrameSize(value);
                        $this.log().debug("Set max outgoing frame size to: {}", (Object)BoxesRunTime.boxToInteger((int)value));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super($outer.shape());
                InHandler.$init$((InHandler)this);
                OutHandler.$init$((OutHandler)this);
                StageLogging.$init$((StageLogging)this);
                this.setHandlers($outer.frameIn(), $outer.netOut(), this);
                this._outMaxFrameSize = 16384;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applySettings$1$adapted(akka.http.impl.engine.http2.framing.Http2FrameRendering$$anon$1 akka.http.impl.engine.http2.FrameEvent$Setting ), $anonfun$onPush$1(akka.http.impl.engine.http2.FrameEvent ), $anonfun$splitByPayloadSize$1(akka.http.impl.engine.http2.FrameEvent$DataFrame akka.util.ByteString ), $anonfun$splitByPayloadSize$2(akka.http.impl.engine.http2.FrameEvent$DataFrame akka.util.ByteString )}, serializedLambda);
            }
        };
    }
}

