/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.util;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.qpid.jms.message.JmsInboundMessageDispatch;
import org.apache.qpid.jms.util.MessageQueue;

public final class FifoMessageQueue
implements MessageQueue {
    protected static final AtomicIntegerFieldUpdater<FifoMessageQueue> STATE_FIELD_UPDATER = AtomicIntegerFieldUpdater.newUpdater(FifoMessageQueue.class, "state");
    protected static final int CLOSED = 0;
    protected static final int STOPPED = 1;
    protected static final int RUNNING = 2;
    private volatile int state = 1;
    protected final ReentrantLock lock = new ReentrantLock();
    protected final Condition condition = this.lock.newCondition();
    protected final Deque<JmsInboundMessageDispatch> queue;

    public FifoMessageQueue(int prefetchSize) {
        this.queue = new ArrayDeque<JmsInboundMessageDispatch>(Math.max(1, prefetchSize));
    }

    @Override
    public void enqueueFirst(JmsInboundMessageDispatch envelope) {
        this.lock.lock();
        try {
            this.queue.addFirst(envelope);
            this.condition.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void enqueue(JmsInboundMessageDispatch envelope) {
        this.lock.lock();
        try {
            this.queue.addLast(envelope);
            this.condition.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JmsInboundMessageDispatch dequeue(long timeout) throws InterruptedException {
        this.lock.lock();
        try {
            while (timeout != 0L && this.isRunning() && this.queue.isEmpty()) {
                if (timeout == -1L) {
                    this.condition.await();
                    continue;
                }
                long start = System.currentTimeMillis();
                this.condition.await(timeout, TimeUnit.MILLISECONDS);
                timeout = Math.max(timeout + start - System.currentTimeMillis(), 0L);
            }
            if (!this.isRunning()) {
                JmsInboundMessageDispatch jmsInboundMessageDispatch = null;
                return jmsInboundMessageDispatch;
            }
            JmsInboundMessageDispatch jmsInboundMessageDispatch = this.queue.pollFirst();
            return jmsInboundMessageDispatch;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public final JmsInboundMessageDispatch dequeueNoWait() {
        this.lock.lock();
        try {
            if (!this.isRunning()) {
                JmsInboundMessageDispatch jmsInboundMessageDispatch = null;
                return jmsInboundMessageDispatch;
            }
            JmsInboundMessageDispatch jmsInboundMessageDispatch = this.queue.pollFirst();
            return jmsInboundMessageDispatch;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public final void start() {
        if (STATE_FIELD_UPDATER.compareAndSet(this, 1, 2)) {
            this.lock.lock();
            try {
                this.condition.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    @Override
    public final void stop() {
        if (STATE_FIELD_UPDATER.compareAndSet(this, 2, 1)) {
            this.lock.lock();
            try {
                this.condition.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    @Override
    public final void close() {
        if (STATE_FIELD_UPDATER.getAndSet(this, 0) > 0) {
            this.lock.lock();
            try {
                this.condition.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    @Override
    public final boolean isRunning() {
        return this.state == 2;
    }

    @Override
    public final boolean isClosed() {
        return this.state == 0;
    }

    @Override
    public boolean isEmpty() {
        this.lock.lock();
        try {
            boolean bl = this.queue.isEmpty();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int size() {
        this.lock.lock();
        try {
            int n = this.queue.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void clear() {
        this.lock.lock();
        try {
            this.queue.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        this.lock.lock();
        try {
            String string = this.queue.toString();
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }
}

