/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.scheduler;

import com.codahale.metrics.InstrumentedExecutorService;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.domain.CreateReleaseTask;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.NotificationTask;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ScriptTask;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.metrics.XlrMetricRegistry$;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.scheduler.CreateReleaseTaskJob;
import com.xebialabs.xlrelease.scheduler.CustomScriptTaskJob;
import com.xebialabs.xlrelease.scheduler.FacetCheckJob;
import com.xebialabs.xlrelease.scheduler.FailureHandlerJob;
import com.xebialabs.xlrelease.scheduler.Job;
import com.xebialabs.xlrelease.scheduler.JobQueue;
import com.xebialabs.xlrelease.scheduler.NotificationTaskJob;
import com.xebialabs.xlrelease.scheduler.PreconditionJob;
import com.xebialabs.xlrelease.scheduler.ScriptTaskJob;
import com.xebialabs.xlrelease.scheduler.StopWorkerThread;
import com.xebialabs.xlrelease.scheduler.TaskJob;
import com.xebialabs.xlrelease.scheduler.repository.JobRepository;
import com.xebialabs.xlrelease.scheduler.workers.CompositeWorker;
import com.xebialabs.xlrelease.script.TaskSoftReferenceFactory;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.utils.PrefixedThreadFactory$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Marker;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOps;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@Component
@ScalaSignature(bytes="\u0006\u0005\u0005]f\u0001\u0002\u000f\u001e\u0001\u0019B\u0001\"\u000e\u0001\u0003\u0006\u0004%\tA\u000e\u0005\t{\u0001\u0011\t\u0011)A\u0005o!Aa\b\u0001BC\u0002\u0013\u0005q\b\u0003\u0005E\u0001\t\u0005\t\u0015!\u0003A\u0011!)\u0005A!b\u0001\n\u00031\u0005\u0002C'\u0001\u0005\u0003\u0005\u000b\u0011B$\t\u00119\u0003!Q1A\u0005\u0002=C\u0001B\u0016\u0001\u0003\u0002\u0003\u0006I\u0001\u0015\u0005\t/\u0002\u0011)\u0019!C\u00011\"Aq\f\u0001B\u0001B\u0003%\u0011\fC\u0003a\u0001\u0011\u0005\u0011\r\u0003\u0005i\u0001!\u0015\r\u0011\"\u0003j\u0011%i\u0007\u00011AA\u0002\u0013%a\u000eC\u0005z\u0001\u0001\u0007\t\u0019!C\u0005u\"Q\u0011\u0011\u0001\u0001A\u0002\u0003\u0005\u000b\u0015B8\t\u0013\u0005\r\u0001\u00011A\u0005\n\u0005\u0015\u0001\"CA\n\u0001\u0001\u0007I\u0011BA\u000b\u0011!\tI\u0002\u0001Q!\n\u0005\u001d\u0001bBA\u0012\u0001\u0011\u0005\u0011Q\u0005\u0005\t\u0003s\u0001A\u0011A\u000f\u0002&!1\u00111\b\u0001\u0005\n9Dq!!\u0010\u0001\t\u0003\t)\u0003C\u0004\u0002H\u0001!\t!!\u0013\t\u000f\u0005]\u0004\u0001\"\u0001\u0002z!9\u0011Q\u0011\u0001\u0005\u0002\u0005\u001d\u0005bBAG\u0001\u0011\u0005\u0011q\u0012\u0005\b\u00037\u0003A\u0011AAO\u0005-9vN]6NC:\fw-\u001a:\u000b\u0005yy\u0012!C:dQ\u0016$W\u000f\\3s\u0015\t\u0001\u0013%A\u0005yYJ,G.Z1tK*\u0011!eI\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011\u0001J\u0001\u0004G>l7\u0001A\n\u0004\u0001\u001dj\u0003C\u0001\u0015,\u001b\u0005I#\"\u0001\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00051J#AB!osJ+g\r\u0005\u0002/g5\tqF\u0003\u00021c\u0005)1\u000f\u001c45U*\t!'\u0001\u0005he&T(\u0010\\3e\u0013\t!tFA\u0004M_\u001e<\u0017N\\4\u0002\u0013ad'oQ8oM&<W#A\u001c\u0011\u0005aZT\"A\u001d\u000b\u0005iz\u0012AB2p]\u001aLw-\u0003\u0002=s\tI\u0001\f\u001c:D_:4\u0017nZ\u0001\u000bq2\u00148i\u001c8gS\u001e\u0004\u0013\u0001\u00036pEF+X-^3\u0016\u0003\u0001\u0003\"!\u0011\"\u000e\u0003uI!aQ\u000f\u0003\u0011){'-U;fk\u0016\f\u0011B[8c#V,W/\u001a\u0011\u0002\u001b)|'MU3q_NLGo\u001c:z+\u00059\u0005C\u0001%L\u001b\u0005I%B\u0001&\u001e\u0003)\u0011X\r]8tSR|'/_\u0005\u0003\u0019&\u0013QBS8c%\u0016\u0004xn]5u_JL\u0018A\u00046pEJ+\u0007o\\:ji>\u0014\u0018\u0010I\u0001\u0010G>l\u0007o\\:ji\u0016<vN]6feV\t\u0001\u000b\u0005\u0002R)6\t!K\u0003\u0002T;\u00059qo\u001c:lKJ\u001c\u0018BA+S\u0005=\u0019u.\u001c9pg&$XmV8sW\u0016\u0014\u0018\u0001E2p[B|7/\u001b;f/>\u00148.\u001a:!\u00039\u0011X\r\\3bg\u0016\u001cVM\u001d<jG\u0016,\u0012!\u0017\t\u00035vk\u0011a\u0017\u0006\u00039~\tqa]3sm&\u001cW-\u0003\u0002_7\nq!+\u001a7fCN,7+\u001a:wS\u000e,\u0017a\u0004:fY\u0016\f7/Z*feZL7-\u001a\u0011\u0002\rqJg.\u001b;?)\u0019\u00117\rZ3gOB\u0011\u0011\t\u0001\u0005\u0006k-\u0001\ra\u000e\u0005\u0006}-\u0001\r\u0001\u0011\u0005\u0006\u000b.\u0001\ra\u0012\u0005\u0006\u001d.\u0001\r\u0001\u0015\u0005\u0006/.\u0001\r!W\u0001\u0010[\u0006DH\u000b\u001b:fC\u0012\u001c8i\\;oiV\t!\u000e\u0005\u0002)W&\u0011A.\u000b\u0002\u0004\u0013:$\u0018A\u0003;ie\u0016\fG\rU8pYV\tq\u000e\u0005\u0002qo6\t\u0011O\u0003\u0002sg\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005Q,\u0018\u0001B;uS2T\u0011A^\u0001\u0005U\u00064\u0018-\u0003\u0002yc\nyQ\t_3dkR|'oU3sm&\u001cW-\u0001\buQJ,\u0017\r\u001a)p_2|F%Z9\u0015\u0005mt\bC\u0001\u0015}\u0013\ti\u0018F\u0001\u0003V]&$\bbB@\u000f\u0003\u0003\u0005\ra\\\u0001\u0004q\u0012\n\u0014a\u0003;ie\u0016\fG\rU8pY\u0002\n!c\u001d5vi\u0012|wO\\%o!J|wM]3tgV\u0011\u0011q\u0001\t\u0005\u0003\u0013\ty!\u0004\u0002\u0002\f)\u0019\u0011QB9\u0002\r\u0005$x.\\5d\u0013\u0011\t\t\"a\u0003\u0003\u001b\u0005#x.\\5d\u0005>|G.Z1o\u0003Y\u0019\b.\u001e;e_^t\u0017J\u001c)s_\u001e\u0014Xm]:`I\u0015\fHcA>\u0002\u0018!Aq0EA\u0001\u0002\u0004\t9!A\ntQV$Hm\\<o\u0013:\u0004&o\\4sKN\u001c\b\u0005K\u0002\u0013\u0003;\u00012\u0001KA\u0010\u0013\r\t\t#\u000b\u0002\tm>d\u0017\r^5mK\u0006Q\u0011N\\5uS\u0006d\u0017N_3\u0015\u0003mD3aEA\u0015!\u0011\tY#!\u000e\u000e\u0005\u00055\"\u0002BA\u0018\u0003c\t!\"\u00198o_R\fG/[8o\u0015\t\t\u0019$A\u0003kCZ\f\u00070\u0003\u0003\u00028\u00055\"!\u0004)pgR\u001cuN\\:ueV\u001cG/\u0001\u0007ti\u0006\u0014H\u000f\u00165sK\u0006$7/A\u0007hKR$\u0006N]3bIB{w\u000e\\\u0001\tg\",H\u000fZ8x]\"\u001aa#!\u0011\u0011\t\u0005-\u00121I\u0005\u0005\u0003\u000b\niC\u0001\u0006Qe\u0016$Um\u001d;s_f\f\u0001cZ3u#V,W/\u001a3UCN\\\u0017\nZ:\u0015\t\u0005-\u0013q\r\t\u0007\u0003\u001b\nY&!\u0019\u000f\t\u0005=\u0013q\u000b\t\u0004\u0003#JSBAA*\u0015\r\t)&J\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005e\u0013&\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003;\nyFA\u0002TKRT1!!\u0017*!\u0011\ti%a\u0019\n\t\u0005\u0015\u0014q\f\u0002\u0007'R\u0014\u0018N\\4\t\u000f\u0005%t\u00031\u0001\u0002l\u00059!/\u001a7fCN,\u0007\u0003BA7\u0003gj!!a\u001c\u000b\u0007\u0005Et$\u0001\u0004e_6\f\u0017N\\\u0005\u0005\u0003k\nyGA\u0004SK2,\u0017m]3\u0002\u000fI,7m\u001c<feR\u001910a\u001f\t\u000f\u0005u\u0004\u00041\u0001\u0002\u0000\u0005!A/Y:l!\u0011\ti'!!\n\t\u0005\r\u0015q\u000e\u0002\u0005)\u0006\u001c8.A\tdC:\u001cW\r\u001c*fg\u0016\u0014h/\u001a3K_\n$2a_AE\u0011\u001d\tY)\u0007a\u0001\u0003C\na\u0001^1tW&#\u0017AB:vE6LG\u000fF\u0002|\u0003#Cq!a%\u001b\u0001\u0004\t)*A\u0002k_\n\u00042!QAL\u0013\r\tI*\b\u0002\u0004\u0015>\u0014\u0017\u0001E1c_J$(j\u001c2CsR\u000b7o[%e)\rY\u0018q\u0014\u0005\b\u0003\u0017[\u0002\u0019AA1Q\r\u0001\u00111\u0015\t\u0005\u0003K\u000b\u0019,\u0004\u0002\u0002(*!\u0011\u0011VAV\u0003)\u0019H/\u001a:f_RL\b/\u001a\u0006\u0005\u0003[\u000by+A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\t\t\t,A\u0002pe\u001eLA!!.\u0002(\nI1i\\7q_:,g\u000e\u001e")
public class WorkManager
implements Logging {
    private int maxThreadsCount;
    private final XlrConfig xlrConfig;
    private final JobQueue jobQueue;
    private final JobRepository jobRepository;
    private final CompositeWorker compositeWorker;
    private final ReleaseService releaseService;
    private ExecutorService threadPool;
    private volatile AtomicBoolean shutdownInProgress;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        WorkManager workManager = this;
        synchronized (workManager) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public XlrConfig xlrConfig() {
        return this.xlrConfig;
    }

    public JobQueue jobQueue() {
        return this.jobQueue;
    }

    public JobRepository jobRepository() {
        return this.jobRepository;
    }

    public CompositeWorker compositeWorker() {
        return this.compositeWorker;
    }

    public ReleaseService releaseService() {
        return this.releaseService;
    }

    private int maxThreadsCount$lzycompute() {
        WorkManager workManager = this;
        synchronized (workManager) {
            if (!this.bitmap$0) {
                this.maxThreadsCount = this.xlrConfig().executors().scheduler().maxThreadsCount();
                this.bitmap$0 = true;
            }
        }
        return this.maxThreadsCount;
    }

    private int maxThreadsCount() {
        return !this.bitmap$0 ? this.maxThreadsCount$lzycompute() : this.maxThreadsCount;
    }

    private ExecutorService threadPool() {
        return this.threadPool;
    }

    private void threadPool_$eq(ExecutorService x$1) {
        this.threadPool = x$1;
    }

    private AtomicBoolean shutdownInProgress() {
        return this.shutdownInProgress;
    }

    private void shutdownInProgress_$eq(AtomicBoolean x$1) {
        this.shutdownInProgress = x$1;
    }

    @PostConstruct
    public void initialize() {
        this.startThreads();
    }

    public void startThreads() {
        this.shutdownInProgress().set(false);
        this.threadPool_$eq(this.getThreadPool());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.maxThreadsCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.threadPool().execute(() -> {
            BooleanRef run = BooleanRef.create((boolean)true);
            while (run.elem && !this.shutdownInProgress().get()) {
                Some some;
                try {
                    some = new Some((Object)this.jobQueue().get());
                }
                catch (InterruptedException e) {
                    this.logger().info((Function0 & Serializable)() -> "Thread is being terminated by shutdown");
                    run.elem = false;
                    some = None$.MODULE$;
                }
                catch (Exception e) {
                    this.logger().error((Function0 & Serializable)() -> "Unhandled exception when getting task from the queue", (Function0 & Serializable)() -> e);
                    some = None$.MODULE$;
                }
                Some jobOption = some;
                jobOption.foreach((Function1 & Serializable)x0$1 -> {
                    WorkManager.$anonfun$startThreads$6(this, run, x0$1);
                    return BoxedUnit.UNIT;
                });
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private ExecutorService getThreadPool() {
        void var1_1;
        ExecutorService executors = Executors.newFixedThreadPool(this.maxThreadsCount(), PrefixedThreadFactory$.MODULE$.apply("task-execution", PrefixedThreadFactory$.MODULE$.apply$default$2()));
        return this.xlrConfig().metrics().enabled() ? new InstrumentedExecutorService(executors, XlrMetricRegistry$.MODULE$.metricRegistry(), "taskExecution") : var1_1;
    }

    @PreDestroy
    public void shutdown() {
        if (this.shutdownInProgress().compareAndSet(false, true)) {
            this.logger().info((Function0 & Serializable)() -> "starting shutdown");
            this.threadPool().shutdown();
            this.jobQueue().stopWorkerThreads(this.maxThreadsCount());
            if (!this.threadPool().awaitTermination(this.xlrConfig().taskSchedulerGraceShutdownPeriod(), TimeUnit.SECONDS)) {
                this.logger().warn((Function0 & Serializable)() -> "There are tasks, that did not complete within shutdown grace period, going to interrupt those tasks");
                this.threadPool().shutdownNow();
                if (!this.threadPool().awaitTermination(this.xlrConfig().taskSchedulerGraceShutdownPeriod(), TimeUnit.SECONDS)) {
                    this.logger().error((Function0 & Serializable)() -> "There are tasks, that could not be interrupted, giving up");
                }
            }
        } else {
            this.logger().info((Function0 & Serializable)() -> "skipping shutdown, because shutdown already happened or in progress");
        }
    }

    public scala.collection.immutable.Set<String> getQueuedTaskIds(Release release) {
        Buffer taskIdsInProgress = (Buffer)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(release.getAllTasks()).asScala().filter((Function1 & Serializable)task -> BoxesRunTime.boxToBoolean((boolean)WorkManager.$anonfun$getQueuedTaskIds$1(task)))).map((Function1 & Serializable)task -> Ids.getFolderlessId((String)task.getId()));
        return taskIdsInProgress.isEmpty() ? (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$) : (scala.collection.immutable.Set)this.jobRepository().findQueuedTaskIdsByReleaseUid(release.getCiUid()).toSet().intersect((Set)taskIdsInProgress.toSet());
    }

    /*
     * Enabled aggressive block sorting
     */
    public void recover(Task task) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(18).append("Recovering task '").append(task.getId()).append("'").toString());
        Task task2 = task;
        if (task.isPreconditionInProgress()) {
            this.jobQueue().submit(new PreconditionJob(TaskSoftReferenceFactory.taskRef(this.releaseService(), task)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (task.isFacetInProgress()) {
            this.jobQueue().submit(new FacetCheckJob(TaskSoftReferenceFactory.taskRef(this.releaseService(), task)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (task.isFailureHandlerInProgress()) {
            this.jobQueue().submit(new FailureHandlerJob(TaskSoftReferenceFactory.taskRef(this.releaseService(), task)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (task2 instanceof CustomScriptTask) {
            CustomScriptTask customScriptTask = (CustomScriptTask)task2;
            if (task.isAbortScriptInProgress() || task.isInProgress()) {
                this.jobQueue().submit(new CustomScriptTaskJob(TaskSoftReferenceFactory.taskRef(this.releaseService(), customScriptTask), (Duration)Duration$.MODULE$.Zero()));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (task2 instanceof ScriptTask) {
            ScriptTask scriptTask = (ScriptTask)task2;
            if (task.isInProgress()) {
                this.jobQueue().submit(new ScriptTaskJob(TaskSoftReferenceFactory.taskRef(this.releaseService(), scriptTask)));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (task2 instanceof CreateReleaseTask) {
            CreateReleaseTask createReleaseTask = (CreateReleaseTask)task2;
            if (task.isInProgress()) {
                this.jobQueue().submit(new CreateReleaseTaskJob(TaskSoftReferenceFactory.taskRef(this.releaseService(), createReleaseTask)));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (task2 instanceof NotificationTask) {
            NotificationTask notificationTask = (NotificationTask)task2;
            if (task.isInProgress()) {
                this.jobQueue().submit(new NotificationTaskJob(TaskSoftReferenceFactory.taskRef(this.releaseService(), notificationTask)));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(45).append("Task '").append(task.getId()).append("' does not meet any criteria to recover").toString());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public void cancelReservedJob(String taskId) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(24).append("Cancelling reserved job ").append(taskId).toString());
        this.jobRepository().deleteByTaskId(taskId);
    }

    public void submit(Job job) {
        this.jobQueue().submit(job);
    }

    public void abortJobByTaskId(String taskId) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(23).append("Aborting scheduled job ").append(taskId).toString());
        this.jobRepository().deleteByTaskId(taskId);
        this.jobQueue().cancelIf(x0$1 -> {
            boolean bl;
            Job job = x0$1;
            if (job instanceof TaskJob) {
                TaskJob taskJob = (TaskJob)job;
                bl = taskJob.taskId().equals(taskId);
            } else {
                bl = false;
            }
            return bl;
        });
    }

    public static final /* synthetic */ void $anonfun$startThreads$6(WorkManager $this, BooleanRef run$1, Job x0$1) {
        Job job = x0$1;
        if (job instanceof StopWorkerThread) {
            $this.logger().debug((Function0 & Serializable)() -> "Received StopWorkerThread, stopping");
            run$1.elem = false;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            try {
                try {
                    boxedUnit = (BoxedUnit)$this.compositeWorker().execute().apply((Object)job);
                }
                catch (Exception e) {
                    $this.logger().error((Function0 & Serializable)() -> new StringBuilder(40).append("Unhandled exception when executing task ").append(job).toString(), (Function0 & Serializable)() -> e);
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            finally {
                $this.jobQueue().finish(job);
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }
    }

    public static final /* synthetic */ boolean $anonfun$getQueuedTaskIds$1(Task task) {
        return task.isInProgress() || task.isFailureHandlerInProgress() || task.isAbortScriptInProgress() || task.isPreconditionInProgress() || task.isFacetInProgress();
    }

    public WorkManager(XlrConfig xlrConfig, JobQueue jobQueue, JobRepository jobRepository, CompositeWorker compositeWorker, ReleaseService releaseService) {
        this.xlrConfig = xlrConfig;
        this.jobQueue = jobQueue;
        this.jobRepository = jobRepository;
        this.compositeWorker = compositeWorker;
        this.releaseService = releaseService;
        Logging.$init$((Logging)this);
        this.shutdownInProgress = new AtomicBoolean(false);
    }
}

