/*
 * Decompiled with CFR 0.152.
 */
package akka.http.impl.engine.http2;

import akka.annotation.InternalApi;
import akka.http.impl.util.JavaVersion$;
import akka.stream.TLSProtocol;
import akka.stream.impl.io.TlsUtils$;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.StructuralCallSite;
import scala.sys.package$;
import scala.util.Try$;

@InternalApi
public final class Http2AlpnSupport$ {
    public static final Http2AlpnSupport$ MODULE$ = new Http2AlpnSupport$();
    private static final String H2 = "h2";
    private static final String HTTP11 = "http/1.1";

    public static Method reflMethod$Method1(Class x$1) {
        CallSite methodCache1 = StructuralCallSite.bootstrap("apply", (Ljava/util/function/BiFunction;)Ljava/lang/Object;);
        Method method1 = methodCache1.find(x$1);
        if (method1 != null) {
            return method1;
        }
        method1 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("setHandshakeApplicationProtocolSelector", methodCache1.parameterTypes()));
        methodCache1.add(x$1, method1);
        return method1;
    }

    public static Method reflMethod$Method2(Class x$1) {
        CallSite methodCache2 = StructuralCallSite.bootstrap("apply", ([Ljava/lang/String;)Ljava/lang/Object;);
        Method method2 = methodCache2.find(x$1);
        if (method2 != null) {
            return method2;
        }
        method2 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("setApplicationProtocols", methodCache2.parameterTypes()));
        methodCache2.add(x$1, method2);
        return method2;
    }

    public String H2() {
        return H2;
    }

    public String HTTP11() {
        return HTTP11;
    }

    public SSLEngine enableForServer(SSLEngine engine, Function1<String, BoxedUnit> setChosenProtocol) {
        if (!this.isAlpnSupportedByJDK()) {
            throw new RuntimeException(new StringBuilder(77).append("Need to run on a JVM >= 8u252 for ALPN support needed for HTTP/2. Running on ").append(package$.MODULE$.props().apply((Object)"java.version")).toString());
        }
        return this.jdkAlpnSupport(engine, setChosenProtocol);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAlpnSupportedByJDK() {
        if (JavaVersion$.MODULE$.majorVersion() >= 9) return true;
        if (!ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])SSLEngine.class.getMethods()), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Http2AlpnSupport$.$anonfun$isAlpnSupportedByJDK$1(x$1)))) return false;
        boolean jettyAlpnClassesAvailable = Try$.MODULE$.apply((Function0 & Serializable)() -> Class.forName("sun.security.ssl.ALPNExtension")).toOption().exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])x$2.getDeclaredMethods()), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)Http2AlpnSupport$.$anonfun$isAlpnSupportedByJDK$4(x$3)))));
        if (jettyAlpnClassesAvailable) {
            throw new RuntimeException("On JDK >= 8u252 you need to either remove jetty-alpn-agent or use version 2.0.10 (which is a noop)");
        }
        if (!true) return false;
        return true;
    }

    public SSLEngine jdkAlpnSupport(SSLEngine engine2, Function1<String, BoxedUnit> setChosenProtocol) {
        SSLEngine qual1 = engine2;
        try {
            Http2AlpnSupport$.reflMethod$Method1(qual1.getClass()).invoke((Object)qual1, (engine, protocols) -> {
                Option<String> chosen = MODULE$.chooseProtocol((List<String>)protocols);
                chosen.foreach(setChosenProtocol);
                return (String)chosen.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            });
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getCause();
        }
        return engine2;
    }

    private Option<String> chooseProtocol(List<String> protocols) {
        return protocols.contains(this.H2()) ? new Some((Object)this.H2()) : (protocols.contains(this.HTTP11()) ? new Some((Object)this.HTTP11()) : None$.MODULE$);
    }

    public void applySessionParameters(SSLEngine engine, TLSProtocol.NegotiateNewSession sessionParameters) {
        TlsUtils$.MODULE$.applySessionParameters(engine, sessionParameters);
    }

    public void clientSetApplicationProtocols(SSLEngine engine, String[] protocols) {
        SSLParameters params;
        SSLParameters qual2 = params = engine.getSSLParameters();
        try {
            Http2AlpnSupport$.reflMethod$Method2(qual2.getClass()).invoke((Object)qual2, new Object[]{new String[]{"h2"}});
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getCause();
        }
        engine.setSSLParameters(params);
    }

    public static final /* synthetic */ boolean $anonfun$isAlpnSupportedByJDK$1(Method x$1) {
        String string = x$1.getName();
        String string2 = "setHandshakeApplicationProtocolSelector";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$isAlpnSupportedByJDK$4(Method x$3) {
        String string = x$3.getName();
        String string2 = "init";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private Http2AlpnSupport$() {
    }
}

