/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.actors;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorLogging;
import akka.actor.ActorRef;
import akka.actor.Cancellable;
import akka.actor.Props;
import akka.actor.SupervisorStrategy;
import akka.actor.package$;
import akka.annotation.InternalApi;
import akka.event.LoggingAdapter;
import com.codahale.metrics.annotation.Timed;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.actors.StuckGateDetectorActor$;
import com.xebialabs.xlrelease.actors.StuckGateDetectorActor$GetWatchedGates$;
import com.xebialabs.xlrelease.actors.StuckGateDetectorActor$JobDone$;
import com.xebialabs.xlrelease.actors.StuckGateDetectorActor$Tick$;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.query.ResolveOptions;
import com.xebialabs.xlrelease.repository.query.ResolveOptionsBuilder;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.service.TaskService;
import com.xebialabs.xlrelease.user.User;
import java.io.Serializable;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.MapFactoryDefaults;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.FiniteDuration;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0011\rq\u0001CA\u0004\u0003\u0013A\t!a\u0007\u0007\u0011\u0005}\u0011\u0011\u0002E\u0001\u0003CAq!a\f\u0002\t\u0003\t\t\u0004C\u0004\u00024\u0005!\t!!\u000e\t\u000f\u0005U\u0015\u0001\"\u0001\u0002\u0018\"9\u0011\u0011V\u0001\u0005\u0002\u0005]\u0005bBAV\u0003\u0011\u0005\u0011q\u0013\u0004\n\u0003[\u000b\u0001\u0013aI\u0011\u0003_3\u0011\"a-\u0002!\u0003\r\n#!.\u0007\r\t5\u0012\u0001\u0011B\u0018\u0011)\u0011\t$\u0003BK\u0002\u0013\u0005!1\u0007\u0005\u000b\u0005\u0007J!\u0011#Q\u0001\n\tU\u0002B\u0003B#\u0013\tU\r\u0011\"\u0001\u0003H!Q!QL\u0005\u0003\u0012\u0003\u0006IA!\u0013\t\u000f\u0005=\u0012\u0002\"\u0001\u0003`!I!qM\u0005\u0002\u0002\u0013\u0005!\u0011\u000e\u0005\n\u0005_J\u0011\u0013!C\u0001\u0005cB\u0011Ba\"\n#\u0003%\tA!#\t\u0013\u0005\u0015\u0018\"!A\u0005B\u0005]\u0005\"CAt\u0013\u0005\u0005I\u0011AAu\u0011%\t\t0CA\u0001\n\u0003\u0011i\tC\u0005\u0002\u0000&\t\t\u0011\"\u0011\u0003\u0002!I!qB\u0005\u0002\u0002\u0013\u0005!\u0011\u0013\u0005\n\u0005+K\u0011\u0011!C!\u0005/C\u0011Ba\u0007\n\u0003\u0003%\tE!\b\t\u0013\t}\u0011\"!A\u0005B\t\u0005\u0002\"\u0003BN\u0013\u0005\u0005I\u0011\tBO\u000f%\u0019)\"AA\u0001\u0012\u0003\u00199BB\u0005\u0003.\u0005\t\t\u0011#\u0001\u0004\u001a!9\u0011q\u0006\u000f\u0005\u0002\rE\u0002\"\u0003B\u00109\u0005\u0005IQ\tB\u0011\u0011%\u0019\u0019\u0004HA\u0001\n\u0003\u001b)\u0004C\u0005\u0004<q\t\t\u0011\"!\u0004>!I!1\u0005\u000f\u0002\u0002\u0013%!Q\u0005\u0004\u0007\u0005C\u000b\u0001Ia)\t\u0015\tE\"E!f\u0001\n\u0003\u0011\u0019\u0004\u0003\u0006\u0003D\t\u0012\t\u0012)A\u0005\u0005kAq!a\f#\t\u0003\u0011)\u000bC\u0005\u0003h\t\n\t\u0011\"\u0001\u0003,\"I!q\u000e\u0012\u0012\u0002\u0013\u0005!\u0011\u000f\u0005\n\u0003K\u0014\u0013\u0011!C!\u0003/C\u0011\"a:#\u0003\u0003%\t!!;\t\u0013\u0005E(%!A\u0005\u0002\t=\u0006\"CA\u0000E\u0005\u0005I\u0011\tB\u0001\u0011%\u0011yAIA\u0001\n\u0003\u0011\u0019\fC\u0005\u0003\u0016\n\n\t\u0011\"\u0011\u00038\"I!1\u0004\u0012\u0002\u0002\u0013\u0005#Q\u0004\u0005\n\u0005?\u0011\u0013\u0011!C!\u0005CA\u0011Ba'#\u0003\u0003%\tEa/\b\u0013\r-\u0013!!A\t\u0002\r5c!\u0003BQ\u0003\u0005\u0005\t\u0012AB(\u0011\u001d\tyC\rC\u0001\u0007/B\u0011Ba\b3\u0003\u0003%)E!\t\t\u0013\rM\"'!A\u0005\u0002\u000ee\u0003\"CB\u001ee\u0005\u0005I\u0011QB/\u0011%\u0011\u0019CMA\u0001\n\u0013\u0011)cB\u0004\u0004d\u0005A\t)a9\u0007\u000f\u0005u\u0016\u0001#!\u0002@\"9\u0011qF\u001d\u0005\u0002\u0005\u0005\b\"CAss\u0005\u0005I\u0011IAL\u0011%\t9/OA\u0001\n\u0003\tI\u000fC\u0005\u0002rf\n\t\u0011\"\u0001\u0002t\"I\u0011q`\u001d\u0002\u0002\u0013\u0005#\u0011\u0001\u0005\n\u0005\u001fI\u0014\u0011!C\u0001\u0005#A\u0011Ba\u0007:\u0003\u0003%\tE!\b\t\u0013\t}\u0011(!A\u0005B\t\u0005\u0002\"\u0003B\u0012s\u0005\u0005I\u0011\u0002B\u0013\r\u0019\u0011y,\u0001!\u0003B\"Q!1Y\"\u0003\u0016\u0004%\tA!2\t\u0015\t57I!E!\u0002\u0013\u00119\rC\u0004\u00020\r#\tAa4\t\u0013\t\u001d4)!A\u0005\u0002\tU\u0007\"\u0003B8\u0007F\u0005I\u0011\u0001Bm\u0011%\t)oQA\u0001\n\u0003\n9\nC\u0005\u0002h\u000e\u000b\t\u0011\"\u0001\u0002j\"I\u0011\u0011_\"\u0002\u0002\u0013\u0005!Q\u001c\u0005\n\u0003\u007f\u001c\u0015\u0011!C!\u0005\u0003A\u0011Ba\u0004D\u0003\u0003%\tA!9\t\u0013\tU5)!A\u0005B\t\u0015\b\"\u0003B\u000e\u0007\u0006\u0005I\u0011\tB\u000f\u0011%\u0011ybQA\u0001\n\u0003\u0012\t\u0003C\u0005\u0003\u001c\u000e\u000b\t\u0011\"\u0011\u0003j\u001eI1QM\u0001\u0002\u0002#\u00051q\r\u0004\n\u0005\u007f\u000b\u0011\u0011!E\u0001\u0007SBq!a\fT\t\u0003\u0019i\u0007C\u0005\u0003 M\u000b\t\u0011\"\u0012\u0003\"!I11G*\u0002\u0002\u0013\u00055q\u000e\u0005\n\u0007w\u0019\u0016\u0011!CA\u0007gB\u0011Ba\tT\u0003\u0003%IA!\n\u0007\u0013\t5\u0018\u0001%A\u0012\"\t=xaBB=\u0003!\u000551\u0002\u0004\b\u0007\u000b\t\u0001\u0012QB\u0004\u0011\u001d\tyc\u0017C\u0001\u0007\u0013A\u0011\"!:\\\u0003\u0003%\t%a&\t\u0013\u0005\u001d8,!A\u0005\u0002\u0005%\b\"CAy7\u0006\u0005I\u0011AB\u0007\u0011%\typWA\u0001\n\u0003\u0012\t\u0001C\u0005\u0003\u0010m\u000b\t\u0011\"\u0001\u0004\u0012!I!1D.\u0002\u0002\u0013\u0005#Q\u0004\u0005\n\u0005?Y\u0016\u0011!C!\u0005CA\u0011Ba\t\\\u0003\u0003%IA!\n\b\u000f\rm\u0014\u0001#!\u0003|\u001a9!1_\u0001\t\u0002\nU\bbBA\u0018M\u0012\u0005!\u0011 \u0005\n\u0003K4\u0017\u0011!C!\u0003/C\u0011\"a:g\u0003\u0003%\t!!;\t\u0013\u0005Eh-!A\u0005\u0002\tu\b\"CA\u0000M\u0006\u0005I\u0011\tB\u0001\u0011%\u0011yAZA\u0001\n\u0003\u0019\t\u0001C\u0005\u0003\u001c\u0019\f\t\u0011\"\u0011\u0003\u001e!I!q\u00044\u0002\u0002\u0013\u0005#\u0011\u0005\u0005\n\u0005G1\u0017\u0011!C\u0005\u0005K1q!a\b\u0002\n\u0001\u0019i\b\u0003\u0006\u0002JA\u0014\t\u0011)A\u0005\u0003\u0017B!\"!\u0017q\u0005\u0003\u0005\u000b\u0011BA.\u0011)\t\u0019\u0007\u001dB\u0001B\u0003%\u0011Q\r\u0005\u000b\u0003[\u0002(\u0011!Q\u0001\n\u0005=\u0004BCAAa\n\u0005\t\u0015!\u0003\u0002\u0004\"Q\u00111\u00129\u0003\u0002\u0003\u0006I!!$\t\u000f\u0005=\u0002\u000f\"\u0001\u0004\f\"I11\u00149C\u0002\u0013-1Q\u0014\u0005\t\u0007K\u0003\b\u0015!\u0003\u0004 \"I1q\u00159A\u0002\u0013%1\u0011\u0016\u0005\n\u0007g\u0003\b\u0019!C\u0005\u0007kC\u0001ba0qA\u0003&11\u0016\u0005\b\u0007\u0003\u0004H\u0011IBb\u0011\u001d\u0019)\r\u001dC!\u0007\u0007Dqaa2q\t\u0003\u0019I\rC\u0004\u0004TB$Ia!6\t\u000f\ru\u0007\u000f\"\u0003\u0004`\"91\u0011\u001e9\u0005\n\r-\u0018AF*uk\u000e\\w)\u0019;f\t\u0016$Xm\u0019;pe\u0006\u001bGo\u001c:\u000b\t\u0005-\u0011QB\u0001\u0007C\u000e$xN]:\u000b\t\u0005=\u0011\u0011C\u0001\nq2\u0014X\r\\3bg\u0016TA!a\u0005\u0002\u0016\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0003\u0003/\t1aY8n\u0007\u0001\u00012!!\b\u0002\u001b\t\tIA\u0001\fTiV\u001c7nR1uK\u0012+G/Z2u_J\f5\r^8s'\r\t\u00111\u0005\t\u0005\u0003K\tY#\u0004\u0002\u0002()\u0011\u0011\u0011F\u0001\u0006g\u000e\fG.Y\u0005\u0005\u0003[\t9C\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u0005m\u0011!\u00029s_B\u001cHCDA\u001c\u0003\u000f\n9&!\u0019\u0002l\u0005}\u0014\u0011\u0012\t\u0005\u0003s\t\u0019%\u0004\u0002\u0002<)!\u0011QHA \u0003\u0015\t7\r^8s\u0015\t\t\t%\u0001\u0003bW.\f\u0017\u0002BA#\u0003w\u0011Q\u0001\u0015:paNDq!!\u0013\u0004\u0001\u0004\tY%\u0001\bsK2,\u0017m]3TKJ4\u0018nY3\u0011\t\u00055\u00131K\u0007\u0003\u0003\u001fRA!!\u0015\u0002\u000e\u000591/\u001a:wS\u000e,\u0017\u0002BA+\u0003\u001f\u0012aBU3mK\u0006\u001cXmU3sm&\u001cW\rC\u0004\u0002Z\r\u0001\r!a\u0017\u0002\u0017Q\f7o[*feZL7-\u001a\t\u0005\u0003\u001b\ni&\u0003\u0003\u0002`\u0005=#a\u0003+bg.\u001cVM\u001d<jG\u0016Dq!a\u0019\u0004\u0001\u0004\t)'A\nsK2,\u0017m]3BGR|'oU3sm&\u001cW\r\u0005\u0003\u0002\u001e\u0005\u001d\u0014\u0002BA5\u0003\u0013\u00111CU3mK\u0006\u001cX-Q2u_J\u001cVM\u001d<jG\u0016Dq!!\u001c\u0004\u0001\u0004\ty'A\u0007he\u0006\u001cW\rR;sCRLwN\u001c\t\u0005\u0003c\nY(\u0004\u0002\u0002t)!\u0011QOA<\u0003!!WO]1uS>t'\u0002BA=\u0003O\t!bY8oGV\u0014(/\u001a8u\u0013\u0011\ti(a\u001d\u0003\u001d\u0019Kg.\u001b;f\tV\u0014\u0018\r^5p]\"9\u0011\u0011Q\u0002A\u0002\u0005\r\u0015aD;ogR,8m[%oi\u0016\u0014h/\u00197\u0011\r\u0005\u0015\u0012QQA8\u0013\u0011\t9)a\n\u0003\r=\u0003H/[8o\u0011\u001d\tYi\u0001a\u0001\u0003\u001b\u000bq\u0003\u001d:pG\u0016\u001c8/\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0011\t\u0005=\u0015\u0011S\u0007\u0003\u0003oJA!a%\u0002x\t\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010^\u0001\u0005]\u0006lW-\u0006\u0002\u0002\u001aB!\u00111TAS\u001b\t\tiJ\u0003\u0003\u0002 \u0006\u0005\u0016\u0001\u00027b]\u001eT!!a)\u0002\t)\fg/Y\u0005\u0005\u0003O\u000biJ\u0001\u0004TiJLgnZ\u0001\rg\u000eDW\rZ;mK:\u000bW.Z\u0001\u0012G>l\u0007\u000f\\3uS>t7i\\7nK:$(\u0001G*uk\u000e\\w)\u0019;f\t\u0016$Xm\u0019;pe6+7o]1hKN\u0019q!a\t*\u0007\u001dA\u0011LA\rTiV\u001c7nR1uK\u0012+G/Z2u_J,\u0005\u0010^3s]\u0006d7#\u0002\u0005\u0002$\u0005]\u0006cAA]\u000f5\t\u0011!K\u0003\ts%\u00113IA\bHKR<\u0016\r^2iK\u0012<\u0015\r^3t'%I\u00141EAa\u0003\u0007\fI\rE\u0002\u0002:\"\u0001B!!\n\u0002F&!\u0011qYA\u0014\u0005\u001d\u0001&o\u001c3vGR\u0004B!a3\u0002\\:!\u0011QZAl\u001d\u0011\ty-!6\u000e\u0005\u0005E'\u0002BAj\u00033\ta\u0001\u0010:p_Rt\u0014BAA\u0015\u0013\u0011\tI.a\n\u0002\u000fA\f7m[1hK&!\u0011Q\\Ap\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\u0011\tI.a\n\u0015\u0005\u0005\r\bcAA]s\u0005i\u0001O]8ek\u000e$\bK]3gSb\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a;\u0011\t\u0005\u0015\u0012Q^\u0005\u0005\u0003_\f9CA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002v\u0006m\b\u0003BA\u0013\u0003oLA!!?\u0002(\t\u0019\u0011I\\=\t\u0013\u0005uX(!AA\u0002\u0005-\u0018a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003\u0004A1!Q\u0001B\u0006\u0003kl!Aa\u0002\u000b\t\t%\u0011qE\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B\u0007\u0005\u000f\u0011\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!!1\u0003B\r!\u0011\t)C!\u0006\n\t\t]\u0011q\u0005\u0002\b\u0005>|G.Z1o\u0011%\tipPA\u0001\u0002\u0004\t)0\u0001\u0005iCND7i\u001c3f)\t\tY/\u0001\u0005u_N#(/\u001b8h)\t\tI*\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0003(A!\u00111\u0014B\u0015\u0013\u0011\u0011Y#!(\u0003\r=\u0013'.Z2u\u00055\u0019F/\u0019:u/\u0006$8\r[5oONI\u0011\"a\t\u0002B\u0006\r\u0017\u0011Z\u0001\u0007O\u0006$X-\u00133\u0016\u0005\tU\u0002\u0003\u0002B\u001c\u0005\u007fqAA!\u000f\u0003<A!\u0011qZA\u0014\u0013\u0011\u0011i$a\n\u0002\rA\u0013X\rZ3g\u0013\u0011\t9K!\u0011\u000b\t\tu\u0012qE\u0001\bO\u0006$X-\u00133!\u0003%\u0019H/\u0019:u)&lW-\u0006\u0002\u0003JA!!1\nB-\u001b\t\u0011iE\u0003\u0003\u0003P\tE\u0013\u0001\u0002;j[\u0016TAAa\u0015\u0003V\u0005!!n\u001c3b\u0015\t\u00119&A\u0002pe\u001eLAAa\u0017\u0003N\tAA)\u0019;f)&lW-\u0001\u0006ti\u0006\u0014H\u000fV5nK\u0002\"bA!\u0019\u0003d\t\u0015\u0004cAA]\u0013!9!\u0011\u0007\bA\u0002\tU\u0002b\u0002B#\u001d\u0001\u0007!\u0011J\u0001\u0005G>\u0004\u0018\u0010\u0006\u0004\u0003b\t-$Q\u000e\u0005\n\u0005cy\u0001\u0013!a\u0001\u0005kA\u0011B!\u0012\u0010!\u0003\u0005\rA!\u0013\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!1\u000f\u0016\u0005\u0005k\u0011)h\u000b\u0002\u0003xA!!\u0011\u0010BB\u001b\t\u0011YH\u0003\u0003\u0003~\t}\u0014!C;oG\",7m[3e\u0015\u0011\u0011\t)a\n\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\u0006\nm$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TC\u0001BFU\u0011\u0011IE!\u001e\u0015\t\u0005U(q\u0012\u0005\n\u0003{$\u0012\u0011!a\u0001\u0003W$BAa\u0005\u0003\u0014\"I\u0011Q \f\u0002\u0002\u0003\u0007\u0011Q_\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002\u001a\ne\u0005\"CA\u007f/\u0005\u0005\t\u0019AAv\u0003\u0019)\u0017/^1mgR!!1\u0003BP\u0011%\tiPGA\u0001\u0002\u0004\t)P\u0001\u0007Ti>\u0004x+\u0019;dQ&twmE\u0005#\u0003G\t\t-a1\u0002JR!!q\u0015BU!\r\tIL\t\u0005\b\u0005c)\u0003\u0019\u0001B\u001b)\u0011\u00119K!,\t\u0013\tEb\u0005%AA\u0002\tUB\u0003BA{\u0005cC\u0011\"!@+\u0003\u0003\u0005\r!a;\u0015\t\tM!Q\u0017\u0005\n\u0003{d\u0013\u0011!a\u0001\u0003k$B!!'\u0003:\"I\u0011Q`\u0017\u0002\u0002\u0003\u0007\u00111\u001e\u000b\u0005\u0005'\u0011i\fC\u0005\u0002~B\n\t\u00111\u0001\u0002v\naq+\u0019;dQ\u0016$w)\u0019;fgNI1)a\t\u0002B\u0006\r\u0017\u0011Z\u0001\u0006O\u0006$Xm]\u000b\u0003\u0005\u000f\u0004\u0002Ba\u000e\u0003J\nU\"\u0011J\u0005\u0005\u0005\u0017\u0014\tEA\u0002NCB\faaZ1uKN\u0004C\u0003\u0002Bi\u0005'\u00042!!/D\u0011\u001d\u0011\u0019M\u0012a\u0001\u0005\u000f$BA!5\u0003X\"I!1Y$\u0011\u0002\u0003\u0007!qY\u000b\u0003\u00057TCAa2\u0003vQ!\u0011Q\u001fBp\u0011%\tipSA\u0001\u0002\u0004\tY\u000f\u0006\u0003\u0003\u0014\t\r\b\"CA\u007f\u001b\u0006\u0005\t\u0019AA{)\u0011\tIJa:\t\u0013\u0005uh*!AA\u0002\u0005-H\u0003\u0002B\n\u0005WD\u0011\"!@R\u0003\u0003\u0005\r!!>\u00033M#XoY6HCR,G)\u001a;fGR|'/\u00138uKJt\u0017\r\\\n\u00063\u0006\r\u0012qW\u0015\u00043\u001a\\&a\u0002&pE\u0012{g.Z\n\nM\u0006\r\"q_Ab\u0003\u0013\u00042!!/Z)\t\u0011Y\u0010E\u0002\u0002:\u001a$B!!>\u0003\u0000\"I\u0011Q 6\u0002\u0002\u0003\u0007\u00111\u001e\u000b\u0005\u0005'\u0019\u0019\u0001C\u0005\u0002~2\f\t\u00111\u0001\u0002v\n!A+[2l'%Y\u00161\u0005B|\u0003\u0007\fI\r\u0006\u0002\u0004\fA\u0019\u0011\u0011X.\u0015\t\u0005U8q\u0002\u0005\n\u0003{|\u0016\u0011!a\u0001\u0003W$BAa\u0005\u0004\u0014!I\u0011Q`1\u0002\u0002\u0003\u0007\u0011Q_\u0001\u000e'R\f'\u000f^,bi\u000eD\u0017N\\4\u0011\u0007\u0005eFdE\u0003\u001d\u00077\u00199\u0003\u0005\u0006\u0004\u001e\r\r\"Q\u0007B%\u0005Cj!aa\b\u000b\t\r\u0005\u0012qE\u0001\beVtG/[7f\u0013\u0011\u0019)ca\b\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0005\u0003\u0004*\r=RBAB\u0016\u0015\u0011\u0019i#!)\u0002\u0005%|\u0017\u0002BAo\u0007W!\"aa\u0006\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\r\t\u00054qGB\u001d\u0011\u001d\u0011\td\ba\u0001\u0005kAqA!\u0012 \u0001\u0004\u0011I%A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\r}2q\t\t\u0007\u0003K\t)i!\u0011\u0011\u0011\u0005\u001521\tB\u001b\u0005\u0013JAa!\u0012\u0002(\t1A+\u001e9mKJB\u0011b!\u0013!\u0003\u0003\u0005\rA!\u0019\u0002\u0007a$\u0003'\u0001\u0007Ti>\u0004x+\u0019;dQ&tw\rE\u0002\u0002:J\u001aRAMB)\u0007O\u0001\u0002b!\b\u0004T\tU\"qU\u0005\u0005\u0007+\u001ayBA\tBEN$(/Y2u\rVt7\r^5p]F\"\"a!\u0014\u0015\t\t\u001d61\f\u0005\b\u0005c)\u0004\u0019\u0001B\u001b)\u0011\u0019yf!\u0019\u0011\r\u0005\u0015\u0012Q\u0011B\u001b\u0011%\u0019IENA\u0001\u0002\u0004\u00119+A\bHKR<\u0016\r^2iK\u0012<\u0015\r^3t\u000319\u0016\r^2iK\u0012<\u0015\r^3t!\r\tIlU\n\u0006'\u000e-4q\u0005\t\t\u0007;\u0019\u0019Fa2\u0003RR\u00111q\r\u000b\u0005\u0005#\u001c\t\bC\u0004\u0003DZ\u0003\rAa2\u0015\t\rU4q\u000f\t\u0007\u0003K\t)Ia2\t\u0013\r%s+!AA\u0002\tE\u0017\u0001\u0002+jG.\fqAS8c\t>tWmE\u0004q\u0003G\u0019yh!\"\u0011\t\u0005e2\u0011Q\u0005\u0005\u0007\u0007\u000bYDA\u0003BGR|'\u000f\u0005\u0003\u0002:\r\u001d\u0015\u0002BBE\u0003w\u0011A\"Q2u_JdunZ4j]\u001e$bb!$\u0004\u0010\u000eE51SBK\u0007/\u001bI\nE\u0002\u0002\u001eADq!!\u0013x\u0001\u0004\tY\u0005C\u0004\u0002Z]\u0004\r!a\u0017\t\u000f\u0005\rt\u000f1\u0001\u0002f!9\u0011QN<A\u0002\u0005=\u0004bBAAo\u0002\u0007\u00111\u0011\u0005\b\u0003\u0017;\b\u0019AAG\u0003A)\u00070Z2vi&|gnQ8oi\u0016DH/\u0006\u0002\u0004 B!\u0011qRBQ\u0013\u0011\u0019\u0019+a\u001e\u00031\u0015CXmY;uS>t7i\u001c8uKb$X\t_3dkR|'/A\tfq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u0002\n1b]2iK\u0012,H.\u001a&pEV\u001111\u0016\t\u0007\u0003K\t)i!,\u0011\t\u0005e2qV\u0005\u0005\u0007c\u000bYDA\u0006DC:\u001cW\r\u001c7bE2,\u0017aD:dQ\u0016$W\u000f\\3K_\n|F%Z9\u0015\t\r]6Q\u0018\t\u0005\u0003K\u0019I,\u0003\u0003\u0004<\u0006\u001d\"\u0001B+oSRD\u0011\"!@|\u0003\u0003\u0005\raa+\u0002\u0019M\u001c\u0007.\u001a3vY\u0016TuN\u0019\u0011\u0002\u0011A\u0014Xm\u0015;beR$\"aa.\u0002\u0011A|7\u000f^*u_B\fqA]3dK&4X-\u0006\u0002\u0004LB!1QZBh\u001b\u0005\u0001\u0018\u0002BBi\u0007\u0003\u0013qAU3dK&4X-A\u0005p]6+7o]1hKR111ZBl\u00073D\u0001Ba1\u0002\u0002\u0001\u0007!q\u0019\u0005\t\u00077\f\t\u00011\u0001\u0003\u0014\u0005Q\u0001O]8dKN\u001c\u0018N\\4\u0002\u000fA\u0014xnY3tgR!1\u0011]Bt!\u0019\tyia9\u00048&!1Q]A<\u0005\u00191U\u000f^;sK\"A!1YA\u0002\u0001\u0004\u00119-\u0001\u0007v]N$XoY6HCR,7\u000f\u0006\u0003\u00048\u000e5\b\u0002\u0003Bb\u0003\u000b\u0001\rAa2)\t\u0005\u00151\u0011\u001f\t\u0005\u0007g\u001cy0\u0004\u0002\u0004v*!!\u0011QB|\u0015\u0011\u0019Ipa?\u0002\u000f5,GO]5dg*!1Q`A\u000b\u0003!\u0019w\u000eZ1iC2,\u0017\u0002\u0002C\u0001\u0007k\u0014Q\u0001V5nK\u0012\u0004")
public class StuckGateDetectorActor
implements Actor,
ActorLogging {
    private final ReleaseService releaseService;
    private final TaskService taskService;
    private final ReleaseActorService releaseActorService;
    private final FiniteDuration graceDuration;
    private final Option<FiniteDuration> unstuckInterval;
    private final ExecutionContext processExecutionContext;
    private final ExecutionContextExecutor executionContext;
    private Option<Cancellable> scheduleJob;
    private LoggingAdapter akka$actor$ActorLogging$$_log;
    private ActorContext context;
    private ActorRef self;

    public static String completionComment() {
        return StuckGateDetectorActor$.MODULE$.completionComment();
    }

    public static String scheduleName() {
        return StuckGateDetectorActor$.MODULE$.scheduleName();
    }

    public static String name() {
        return StuckGateDetectorActor$.MODULE$.name();
    }

    public static Props props(ReleaseService releaseService, TaskService taskService, ReleaseActorService releaseActorService, FiniteDuration finiteDuration, Option<FiniteDuration> option, ExecutionContext executionContext) {
        return StuckGateDetectorActor$.MODULE$.props(releaseService, taskService, releaseActorService, finiteDuration, option, executionContext);
    }

    public LoggingAdapter log() {
        return ActorLogging.log$((ActorLogging)this);
    }

    public final ActorRef sender() {
        return Actor.sender$((Actor)this);
    }

    @InternalApi
    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
        Actor.aroundReceive$((Actor)this, receive2, (Object)msg);
    }

    @InternalApi
    public void aroundPreStart() {
        Actor.aroundPreStart$((Actor)this);
    }

    @InternalApi
    public void aroundPostStop() {
        Actor.aroundPostStop$((Actor)this);
    }

    @InternalApi
    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        Actor.aroundPreRestart$((Actor)this, (Throwable)reason, message);
    }

    @InternalApi
    public void aroundPostRestart(Throwable reason) {
        Actor.aroundPostRestart$((Actor)this, (Throwable)reason);
    }

    public SupervisorStrategy supervisorStrategy() {
        return Actor.supervisorStrategy$((Actor)this);
    }

    public void preRestart(Throwable reason, Option<Object> message) throws Exception {
        Actor.preRestart$((Actor)this, (Throwable)reason, message);
    }

    public void postRestart(Throwable reason) throws Exception {
        Actor.postRestart$((Actor)this, (Throwable)reason);
    }

    public void unhandled(Object message) {
        Actor.unhandled$((Actor)this, (Object)message);
    }

    public LoggingAdapter akka$actor$ActorLogging$$_log() {
        return this.akka$actor$ActorLogging$$_log;
    }

    public void akka$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.akka$actor$ActorLogging$$_log = x$1;
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
        this.context = x$1;
    }

    public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
        this.self = x$1;
    }

    private ExecutionContextExecutor executionContext() {
        return this.executionContext;
    }

    private Option<Cancellable> scheduleJob() {
        return this.scheduleJob;
    }

    private void scheduleJob_$eq(Option<Cancellable> x$1) {
        this.scheduleJob = x$1;
    }

    public void preStart() {
        Actor.preStart$((Actor)this);
        this.scheduleJob_$eq((Option<Cancellable>)this.unstuckInterval.map((Function1 & Serializable)duration -> {
            this.log().info(new StringBuilder(35).append("Scheduling StuckGateDetector every ").append(duration.toString()).toString());
            return this.context().system().scheduler().schedule(duration, duration, this.self(), (Object)StuckGateDetectorActor$Tick$.MODULE$, (ExecutionContext)this.executionContext(), this.self());
        }));
    }

    public void postStop() {
        this.scheduleJob().foreach((Function1 & Serializable)job -> BoxesRunTime.boxToBoolean((boolean)StuckGateDetectorActor.$anonfun$postStop$1(this, job)));
        Actor.postStop$((Actor)this);
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return this.com$xebialabs$xlrelease$actors$StuckGateDetectorActor$$onMessage((scala.collection.immutable.Map<String, DateTime>)Predef$.MODULE$.Map().empty(), false);
    }

    public PartialFunction<Object, BoxedUnit> com$xebialabs$xlrelease$actors$StuckGateDetectorActor$$onMessage(scala.collection.immutable.Map<String, DateTime> gates, boolean processing) {
        return new Serializable(this, gates, processing){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ StuckGateDetectorActor $outer;
            private final scala.collection.immutable.Map gates$1;
            private final boolean processing$1;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (StuckGateDetectorActor$GetWatchedGates$.MODULE$.equals(A1)) {
                    package$.MODULE$.actorRef2Scala(this.$outer.sender()).$bang((Object)new WatchedGates((scala.collection.immutable.Map<String, DateTime>)this.gates$1), this.$outer.self());
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof StartWatching) {
                    StartWatching startWatching = (StartWatching)A1;
                    String gateId = startWatching.gateId();
                    DateTime startTime = startWatching.startTime();
                    this.$outer.log().debug("Start watching GateTask: {}", (Object)gateId);
                    this.$outer.context().become(this.$outer.com$xebialabs$xlrelease$actors$StuckGateDetectorActor$$onMessage((scala.collection.immutable.Map<String, DateTime>)((scala.collection.immutable.Map)this.gates$1.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)gateId), (Object)startTime))), this.processing$1));
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof StopWatching) {
                    StopWatching stopWatching = (StopWatching)A1;
                    String gateId = stopWatching.gateId();
                    this.$outer.log().debug("Stop watching GateTask: {}", (Object)gateId);
                    this.$outer.context().become(this.$outer.com$xebialabs$xlrelease$actors$StuckGateDetectorActor$$onMessage((scala.collection.immutable.Map<String, DateTime>)((scala.collection.immutable.Map)this.gates$1.$minus((Object)gateId)), this.processing$1));
                    object = BoxedUnit.UNIT;
                } else if (StuckGateDetectorActor$Tick$.MODULE$.equals(A1) && !this.processing$1) {
                    BoxedUnit boxedUnit;
                    this.$outer.log().debug("Processing {} potentially stuck GateTasks", (Object)BoxesRunTime.boxToInteger((int)this.gates$1.size()));
                    if (this.gates$1.nonEmpty()) {
                        this.$outer.context().become(this.$outer.com$xebialabs$xlrelease$actors$StuckGateDetectorActor$$onMessage((scala.collection.immutable.Map<String, DateTime>)this.gates$1, true));
                        this.$outer.com$xebialabs$xlrelease$actors$StuckGateDetectorActor$$process((scala.collection.immutable.Map<String, DateTime>)this.gates$1);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    object = boxedUnit;
                } else if (StuckGateDetectorActor$JobDone$.MODULE$.equals(A1) && this.processing$1) {
                    this.$outer.log().debug("Done processing stuck GateTasks. Now watching {} gates", (Object)BoxesRunTime.boxToInteger((int)this.gates$1.size()));
                    this.$outer.context().become(this.$outer.com$xebialabs$xlrelease$actors$StuckGateDetectorActor$$onMessage((scala.collection.immutable.Map<String, DateTime>)this.gates$1, false));
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = StuckGateDetectorActor$GetWatchedGates$.MODULE$.equals(object) ? true : (object instanceof StartWatching ? true : (object instanceof StopWatching ? true : (StuckGateDetectorActor$Tick$.MODULE$.equals(object) && !this.processing$1 ? true : StuckGateDetectorActor$JobDone$.MODULE$.equals(object) && this.processing$1)));
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.gates$1 = gates$1;
                this.processing$1 = processing$1;
            }
        };
    }

    public Future<BoxedUnit> com$xebialabs$xlrelease$actors$StuckGateDetectorActor$$process(scala.collection.immutable.Map<String, DateTime> gates) {
        ExecutionContext ec = this.processExecutionContext;
        return Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.unstuckGates(gates), (ExecutionContext)this.executionContext()).recover((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ StuckGateDetectorActor $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    A1 A12 = A1;
                    this.$outer.log().error(A12, "Exception while completing stuck GateTasks: {}", (Object)A12.getMessage());
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable != null;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (ExecutionContext)this.executionContext()).map((Function1 & Serializable)x$1 -> {
            StuckGateDetectorActor.$anonfun$process$2(this, x$1);
            return BoxedUnit.UNIT;
        }, (ExecutionContext)this.executionContext());
    }

    @Timed
    private void unstuckGates(scala.collection.immutable.Map<String, DateTime> gates) {
        this.log().debug("Monitoring {} gate tasks", (Object)BoxesRunTime.boxToInteger((int)gates.size()));
        DateTime graceTime = DateTime.now().minus(this.graceDuration.toMillis());
        ResolveOptions resolveOptions = new ResolveOptionsBuilder().withEverything().withoutDecorators().build();
        scala.collection.immutable.Iterable gatesToCheck = (scala.collection.immutable.Iterable)((MapFactoryDefaults)gates.map((Function1 & Serializable)gateAndTime -> {
            Tuple2 tuple2 = gateAndTime;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String gateId = (String)tuple2._1();
            DateTime timestamp = (DateTime)tuple2._2();
            Tuple3 tuple3 = new Tuple3((Object)tuple2, (Object)gateId, (Object)timestamp);
            Tuple3 tuple32 = tuple3;
            Tuple2 x$2 = (Tuple2)tuple32._1();
            String gateId2 = (String)tuple32._2();
            DateTime timestamp2 = (DateTime)tuple32._3();
            return new Tuple2(gateAndTime, (Object)x$2);
        })).withFilter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)StuckGateDetectorActor.$anonfun$unstuckGates$2(graceTime, x$4))).map((Function1 & Serializable)x$5 -> {
            String gateId;
            Tuple2 tuple2;
            Tuple2 tuple22 = x$5;
            if (tuple22 == null || (tuple2 = (Tuple2)tuple22._2()) == null) {
                throw new MatchError((Object)tuple22);
            }
            String string = gateId = (String)tuple2._1();
            return string;
        });
        this.log().debug("{} gate tasks are selected after checking grace period", (Object)BoxesRunTime.boxToInteger((int)gatesToCheck.size()));
        scala.collection.immutable.Map gateAndStatus = (scala.collection.immutable.Map)gatesToCheck.groupBy((Function1 & Serializable)x$1 -> Ids.releaseIdFrom((String)x$1)).flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String releaseId = (String)tuple2._1();
            scala.collection.immutable.Iterable gates = (scala.collection.immutable.Iterable)tuple2._2();
            Map<String, TaskStatus> taskStatuses = $this.taskService.getTaskStatuses(releaseId);
            IterableOnce iterableOnce = (IterableOnce)gates.map((Function1 & Serializable)gateId -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(gateId), taskStatuses.get(Ids.getFolderlessId((String)gateId))));
            return iterableOnce;
        });
        Tuple2 gateGroups = gateAndStatus.partition((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)StuckGateDetectorActor.$anonfun$unstuckGates$7(x0$2)));
        scala.collection.immutable.Map gatesToProcess = (scala.collection.immutable.Map)gateGroups._1();
        scala.collection.immutable.Map gatesToStopWatching = (scala.collection.immutable.Map)gateGroups._2();
        gatesToStopWatching.foreach((Function1 & Serializable)x0$3 -> {
            StuckGateDetectorActor.$anonfun$unstuckGates$8(this, x0$3);
            return BoxedUnit.UNIT;
        });
        scala.collection.immutable.Map gatesByRelease = gatesToProcess.keys().groupBy((Function1 & Serializable)gateId -> Ids.releaseIdFrom((String)gateId));
        this.log().debug("Processing {} releases with gate tasks", (Object)BoxesRunTime.boxToInteger((int)gatesByRelease.size()));
        gatesByRelease.foreach((Function1 & Serializable)x0$4 -> {
            StuckGateDetectorActor.$anonfun$unstuckGates$10(this, resolveOptions, x0$4);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$postStop$1(StuckGateDetectorActor $this, Cancellable job) {
        $this.log().info("Stopping StuckGateDetector job");
        return job.cancel();
    }

    public static final /* synthetic */ void $anonfun$process$2(StuckGateDetectorActor $this, BoxedUnit x$1) {
        package$.MODULE$.actorRef2Scala($this.self()).$bang((Object)StuckGateDetectorActor$JobDone$.MODULE$, $this.self());
    }

    public static final /* synthetic */ boolean $anonfun$unstuckGates$2(DateTime graceTime$1, Tuple2 x$4) {
        Tuple2 tuple2;
        Tuple2 tuple22 = x$4;
        if (tuple22 == null || (tuple2 = (Tuple2)tuple22._2()) == null) {
            throw new MatchError((Object)tuple22);
        }
        DateTime timestamp = (DateTime)tuple2._2();
        boolean bl = timestamp.isBefore((ReadableInstant)graceTime$1);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$unstuckGates$7(Tuple2 x0$2) {
        TaskStatus taskStatus;
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TaskStatus taskStatus2 = taskStatus = (TaskStatus)tuple2._2();
        TaskStatus taskStatus3 = TaskStatus.IN_PROGRESS;
        boolean bl = !(taskStatus2 != null ? !taskStatus2.equals(taskStatus3) : taskStatus3 != null);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$unstuckGates$8(StuckGateDetectorActor $this, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String gateId = (String)tuple2._1();
        TaskStatus status = (TaskStatus)tuple2._2();
        $this.log().debug("Stop watching {} (status: {})", (Object)gateId, (Object)status);
        package$.MODULE$.actorRef2Scala($this.self()).$bang((Object)new StopWatching(gateId), $this.self());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$unstuckGates$11(StuckGateDetectorActor $this, Release release$1, String gateId) {
        GateTask gateTask = (GateTask)release$1.getTask(gateId);
        $this.log().debug(new StringBuilder(15).append("       status: ").append(gateTask.getStatus()).toString());
        $this.log().debug(new StringBuilder(15).append("   conditions: ").append(CollectionConverters$.MODULE$.ListHasAsScala(gateTask.getConditions()).asScala().forall((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.isChecked()))).toString());
        $this.log().debug(new StringBuilder(15).append(" dependencies: ").append(CollectionConverters$.MODULE$.ListHasAsScala(gateTask.getDependencies()).asScala().forall((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.isDone()))).toString());
        if ((CollectionConverters$.MODULE$.ListHasAsScala(gateTask.getConditions()).asScala().nonEmpty() || CollectionConverters$.MODULE$.ListHasAsScala(gateTask.getDependencies()).asScala().nonEmpty()) && CollectionConverters$.MODULE$.ListHasAsScala(gateTask.getConditions()).asScala().forall((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.isChecked())) && CollectionConverters$.MODULE$.ListHasAsScala(gateTask.getDependencies()).asScala().forall((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.isDone()))) {
            $this.log().info("Completing stuck gate {}", (Object)gateId);
            $this.releaseActorService.markTaskAsDoneAsync(TaskStatus.COMPLETED, gateId, StuckGateDetectorActor$.MODULE$.completionComment(), User.SYSTEM);
            package$.MODULE$.actorRef2Scala($this.self()).$bang((Object)new StopWatching(gateId), $this.self());
        } else {
            $this.log().debug("Conditions not met for {} (in progress)", (Object)gateId);
        }
    }

    public static final /* synthetic */ void $anonfun$unstuckGates$10(StuckGateDetectorActor $this, ResolveOptions resolveOptions$1, Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String releaseId = (String)tuple2._1();
        Iterable gateTaskIds = (Iterable)tuple2._2();
        $this.log().debug("Loading {}", (Object)releaseId);
        Release release = $this.releaseService.findById(releaseId, resolveOptions$1);
        gateTaskIds.foreach((Function1 & Serializable)gateId -> {
            StuckGateDetectorActor.$anonfun$unstuckGates$11($this, release, gateId);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public StuckGateDetectorActor(ReleaseService releaseService, TaskService taskService, ReleaseActorService releaseActorService, FiniteDuration graceDuration, Option<FiniteDuration> unstuckInterval, ExecutionContext processExecutionContext) {
        this.releaseService = releaseService;
        this.taskService = taskService;
        this.releaseActorService = releaseActorService;
        this.graceDuration = graceDuration;
        this.unstuckInterval = unstuckInterval;
        this.processExecutionContext = processExecutionContext;
        Actor.$init$((Actor)this);
        ActorLogging.$init$((ActorLogging)this);
        this.executionContext = this.context().system().dispatcher();
        this.scheduleJob = None$.MODULE$;
        Statics.releaseFence();
    }

    public static class StartWatching
    implements StuckGateDetectorExternal,
    Product,
    Serializable {
        private final String gateId;
        private final DateTime startTime;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String gateId() {
            return this.gateId;
        }

        public DateTime startTime() {
            return this.startTime;
        }

        public StartWatching copy(String gateId, DateTime startTime) {
            return new StartWatching(gateId, startTime);
        }

        public String copy$default$1() {
            return this.gateId();
        }

        public DateTime copy$default$2() {
            return this.startTime();
        }

        public String productPrefix() {
            return "StartWatching";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.gateId();
                    break;
                }
                case 1: {
                    object = this.startTime();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof StartWatching;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "gateId";
                    break;
                }
                case 1: {
                    string = "startTime";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof StartWatching)) return false;
            boolean bl = true;
            if (!bl) return false;
            StartWatching startWatching = (StartWatching)x$1;
            String string = this.gateId();
            String string2 = startWatching.gateId();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            DateTime dateTime = this.startTime();
            DateTime dateTime2 = startWatching.startTime();
            if (dateTime == null) {
                if (dateTime2 != null) {
                    return false;
                }
            } else if (!dateTime.equals(dateTime2)) return false;
            if (!startWatching.canEqual(this)) return false;
            return true;
        }

        public StartWatching(String gateId, DateTime startTime) {
            this.gateId = gateId;
            this.startTime = startTime;
            Product.$init$((Product)this);
        }
    }

    public static class StopWatching
    implements StuckGateDetectorExternal,
    Product,
    Serializable {
        private final String gateId;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String gateId() {
            return this.gateId;
        }

        public StopWatching copy(String gateId) {
            return new StopWatching(gateId);
        }

        public String copy$default$1() {
            return this.gateId();
        }

        public String productPrefix() {
            return "StopWatching";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.gateId();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof StopWatching;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "gateId";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof StopWatching)) return false;
            boolean bl = true;
            if (!bl) return false;
            StopWatching stopWatching = (StopWatching)x$1;
            String string = this.gateId();
            String string2 = stopWatching.gateId();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!stopWatching.canEqual(this)) return false;
            return true;
        }

        public StopWatching(String gateId) {
            this.gateId = gateId;
            Product.$init$((Product)this);
        }
    }

    public static interface StuckGateDetectorExternal
    extends StuckGateDetectorMessage {
    }

    public static interface StuckGateDetectorInternal
    extends StuckGateDetectorMessage {
    }

    public static interface StuckGateDetectorMessage {
    }

    public static class WatchedGates
    implements StuckGateDetectorExternal,
    Product,
    Serializable {
        private final scala.collection.immutable.Map<String, DateTime> gates;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public scala.collection.immutable.Map<String, DateTime> gates() {
            return this.gates;
        }

        public WatchedGates copy(scala.collection.immutable.Map<String, DateTime> gates) {
            return new WatchedGates(gates);
        }

        public scala.collection.immutable.Map<String, DateTime> copy$default$1() {
            return this.gates();
        }

        public String productPrefix() {
            return "WatchedGates";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.gates();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof WatchedGates;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "gates";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof WatchedGates)) return false;
            boolean bl = true;
            if (!bl) return false;
            WatchedGates watchedGates = (WatchedGates)x$1;
            scala.collection.immutable.Map<String, DateTime> map = this.gates();
            scala.collection.immutable.Map<String, DateTime> map2 = watchedGates.gates();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            if (!watchedGates.canEqual(this)) return false;
            return true;
        }

        public WatchedGates(scala.collection.immutable.Map<String, DateTime> gates) {
            this.gates = gates;
            Product.$init$((Product)this);
        }
    }
}

