/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.views.converters;

import com.xebialabs.xlrelease.service.UserInfoResolver;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.variable.VariableHelper;
import com.xebialabs.xlrelease.views.UserView;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserViewConverter {
    private UserInfoResolver userInfoResolver;

    @Autowired
    public void setUserInfoResolver(UserInfoResolver userInfoResolver) {
        this.userInfoResolver = userInfoResolver;
    }

    public UserView toUserView(String username) {
        String fullName = null;
        if (username != null && !VariableHelper.containsVariables((String)username)) {
            fullName = this.userInfoResolver.getFullNameOf(username);
        }
        return new UserView(username, fullName);
    }

    public List<UserView> toUserView(List<String> principals, Map<String, UserView> cache) {
        return principals.stream().map(principal -> cache.computeIfAbsent((String)principal, this::toUserView)).collect(Collectors.toList());
    }

    public UserView toFullView(User user) {
        return this.toUserView(user.getName());
    }
}

