/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.script;

import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plumbing.CurrentVersion;
import com.xebialabs.xlrelease.api.XLReleaseServiceHolder;
import com.xebialabs.xlrelease.domain.Configuration;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.script.XlrScript;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.script.ScriptContext;
import javax.script.SimpleScriptContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XlrScriptContext
extends SimpleScriptContext
implements AutoCloseable {
    private static final Logger scriptLogger = LoggerFactory.getLogger((String)"xlrelease.script");
    public static final String CONTEXT_BINDINGS_TO_UNWRAP = "_contextBindingsToUnWrap";
    public static final String CONTEXT_BINDINGS_TO_WRAP = "_contextBindingsToWrap";
    public static final String ATTRIBUTE_RELEASE_VARIABLES = "_releaseVariables";
    public static final String ATTRIBUTE_GLOBAL_VARIABLES = "_globalVariables";
    public static final String ATTRIBUTE_FOLDER_VARIABLES = "_folderVariables";
    public static final String ATTR_VERSION = "_version";
    public static final String ATTR_RELEASE = "release";
    public static final String ATTR_PHASE = "phase";
    public static final String ATTR_TASK = "task";
    public static final String ATTR_VALUE_PROVIDER = "_valueProvider";
    public static final String ATTR_VALUE_PROVIDER_RESULT = "result";
    public static final String CONFIGURATION_ID_PROPERTY_NAME = "id";
    private final String executionId;
    private String scriptPathForLog;
    private final List<XlrScript> scripts = new ArrayList<XlrScript>();

    public XlrScriptContext() {
        this(UUID.randomUUID().toString());
    }

    public XlrScriptContext(String executionId) {
        this.executionId = executionId;
        this.setAttribute(ATTR_VERSION, CurrentVersion.get(), 100);
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public void addDomainObjects(Task task) {
        Release release = task.getRelease();
        this.setAttribute(ATTR_RELEASE, release, 100);
        this.setAttribute(ATTR_PHASE, task.getPhase(), 100);
        this.setAttribute(ATTR_TASK, task, 100);
    }

    public void addApi() {
        XLReleaseServiceHolder.getApiServices().stream().filter(apiService -> !"taskReportingApi".equals(apiService.serviceName())).forEach(apiService -> this.setAttribute("_" + apiService.serviceName(), apiService, 100));
    }

    public void addCustomScriptApi() {
        XLReleaseServiceHolder.getApiServices().forEach(apiService -> this.setAttribute("_" + apiService.serviceName(), apiService, 100));
    }

    public void addScriptLogger() {
        this.setAttribute("logger", scriptLogger, 100);
    }

    public void addProperties(ConfigurationItem configurationItem, Collection<PropertyDescriptor> properties) {
        for (PropertyDescriptor propertyDescriptor : properties) {
            String propertyName = propertyDescriptor.getName();
            if (this.ciIsSubTypeOfConfiguration(propertyDescriptor)) {
                this.setAttribute(propertyName, this.getPropertiesMap(configurationItem, propertyName), 100);
                continue;
            }
            this.setAttribute(propertyName, configurationItem.getProperty(propertyName), 100);
            this.addBindingToSugarify(propertyName, this, CONTEXT_BINDINGS_TO_WRAP);
        }
    }

    public void addPropertyBindings(Collection<PropertyDescriptor> properties) {
        properties.forEach(pd -> this.addBindingToSugarify(pd.getName(), this, CONTEXT_BINDINGS_TO_UNWRAP));
    }

    public void setScriptPathForLog(String scriptPathForLog) {
        this.scriptPathForLog = scriptPathForLog;
    }

    public String getScriptPathForLog() {
        return this.scriptPathForLog;
    }

    private Map<String, Object> getPropertiesMap(ConfigurationItem configurationItem, String propertyName) {
        Configuration ciProperty = (Configuration)configurationItem.getProperty(propertyName);
        HashMap<String, Object> ciProperties = null;
        if (null != ciProperty) {
            ciProperties = new HashMap<String, Object>();
            ciProperties.put(CONFIGURATION_ID_PROPERTY_NAME, ciProperty.getId());
            Descriptor descriptor = ciProperty.getType().getDescriptor();
            for (PropertyDescriptor ciPropertyDescriptor : descriptor.getPropertyDescriptors()) {
                ciProperties.put(ciPropertyDescriptor.getName(), ciProperty.getProperty(ciPropertyDescriptor.getName()));
            }
        }
        return ciProperties;
    }

    private boolean ciIsSubTypeOfConfiguration(PropertyDescriptor propertyDescriptor) {
        return propertyDescriptor.getKind() == PropertyKind.CI && propertyDescriptor.getReferencedType().isSubTypeOf(Type.valueOf(Configuration.class));
    }

    private void addBindingToSugarify(String bindingName, ScriptContext scriptContext, String sugarifyType) {
        ArrayList<String> sugarifiedNames = (ArrayList<String>)scriptContext.getAttribute(sugarifyType);
        if (sugarifiedNames == null) {
            sugarifiedNames = new ArrayList<String>();
            scriptContext.setAttribute(sugarifyType, sugarifiedNames, 100);
        }
        sugarifiedNames.add(bindingName);
    }

    public Collection<Object> getValueProviderResult() {
        return (Collection)this.getAttribute(ATTR_VALUE_PROVIDER_RESULT, 100);
    }

    @Override
    public void close() throws Exception {
    }

    public List<XlrScript> getScripts() {
        return this.scripts;
    }

    public void addScript(XlrScript script) {
        this.scripts.add(script);
    }

    public boolean shouldCheckPolicyPermissions() {
        return this.scripts.stream().anyMatch(XlrScript::checkPermissions);
    }

    public void merge(ScriptContext other, int scope) {
        this.getBindings(scope).putAll(other.getBindings(scope));
    }
}

