/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.impl.streamref;

import akka.actor.ActorRef;
import akka.actor.ExtendedActorSystem;
import akka.annotation.InternalApi;
import akka.stream.SinkRef;
import akka.stream.SourceRef;
import akka.stream.StreamRefResolver;
import akka.stream.impl.streamref.SinkRefImpl;
import akka.stream.impl.streamref.SourceRefImpl;
import scala.MatchError;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u00154Aa\u0002\u0005\u0003#!AA\u0004\u0001B\u0001B\u0003%Q\u0004C\u0003$\u0001\u0011\u0005A\u0005C\u0003)\u0001\u0011\u0005\u0011\u0006C\u0003)\u0001\u0011\u0005a\tC\u0003O\u0001\u0011\u0005q\nC\u0003W\u0001\u0011\u0005qKA\u000bTiJ,\u0017-\u001c*fMJ+7o\u001c7wKJLU\u000e\u001d7\u000b\u0005%Q\u0011!C:ue\u0016\fWN]3g\u0015\tYA\"\u0001\u0003j[Bd'BA\u0007\u000f\u0003\u0019\u0019HO]3b[*\tq\"\u0001\u0003bW.\f7\u0001A\n\u0004\u0001IA\u0002CA\n\u0017\u001b\u0005!\"\"A\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]!\"AB!osJ+g\r\u0005\u0002\u001a55\tA\"\u0003\u0002\u001c\u0019\t\t2\u000b\u001e:fC6\u0014VM\u001a*fg>dg/\u001a:\u0002\rML8\u000f^3n!\tq\u0012%D\u0001 \u0015\t\u0001c\"A\u0003bGR|'/\u0003\u0002#?\t\u0019R\t\u001f;f]\u0012,G-Q2u_J\u001c\u0016p\u001d;f[\u00061A(\u001b8jiz\"\"!J\u0014\u0011\u0005\u0019\u0002Q\"\u0001\u0005\t\u000bq\u0011\u0001\u0019A\u000f\u0002+Q|7+\u001a:jC2L'0\u0019;j_:4uN]7biV\u0011!&\u0010\u000b\u0003WY\u0002\"\u0001L\u001a\u000f\u00055\n\u0004C\u0001\u0018\u0015\u001b\u0005y#B\u0001\u0019\u0011\u0003\u0019a$o\\8u}%\u0011!\u0007F\u0001\u0007!J,G-\u001a4\n\u0005Q*$AB*ue&twM\u0003\u00023)!)qg\u0001a\u0001q\u0005\u0019!/\u001a4\u0011\u0007eI4(\u0003\u0002;\u0019\tI1k\\;sG\u0016\u0014VM\u001a\t\u0003yub\u0001\u0001B\u0003?\u0007\t\u0007qHA\u0001U#\t\u00015\t\u0005\u0002\u0014\u0003&\u0011!\t\u0006\u0002\b\u001d>$\b.\u001b8h!\t\u0019B)\u0003\u0002F)\t\u0019\u0011I\\=\u0016\u0005\u001dkECA\u0016I\u0011\u00159D\u00011\u0001J!\rI\"\nT\u0005\u0003\u00172\u0011qaU5oWJ+g\r\u0005\u0002=\u001b\u0012)a\b\u0002b\u0001\u007f\u0005\u0001\"/Z:pYZ,7k\\;sG\u0016\u0014VMZ\u000b\u0003!N#\"!\u0015+\u0011\u0007eI$\u000b\u0005\u0002='\u0012)a(\u0002b\u0001\u007f!)Q+\u0002a\u0001W\u0005\u00192/\u001a:jC2L'0\u001a3T_V\u00148-\u001a*fM\u0006q!/Z:pYZ,7+\u001b8l%\u00164WC\u0001-\\)\tIF\fE\u0002\u001a\u0015j\u0003\"\u0001P.\u0005\u000by2!\u0019A \t\u000bu3\u0001\u0019A\u0016\u0002#M,'/[1mSj,GmU5oWJ+g\r\u000b\u0002\u0001?B\u0011\u0001mY\u0007\u0002C*\u0011!MD\u0001\u000bC:tw\u000e^1uS>t\u0017B\u00013b\u0005-Ie\u000e^3s]\u0006d\u0017\t]5")
@InternalApi
public final class StreamRefResolverImpl
implements StreamRefResolver {
    private final ExtendedActorSystem system;

    @Override
    public <T> String toSerializationFormat(SourceRef<T> ref) {
        SourceRef<T> sourceRef = ref;
        if (!(sourceRef instanceof SourceRefImpl)) {
            throw new MatchError(sourceRef);
        }
        SourceRefImpl sourceRefImpl = (SourceRefImpl)sourceRef;
        ActorRef actorRef2 = sourceRefImpl.initialPartnerRef();
        String string = actorRef2.path().toSerializationFormatWithAddress(this.system.provider().getDefaultAddress());
        return string;
    }

    @Override
    public <T> String toSerializationFormat(SinkRef<T> ref) {
        SinkRef<T> sinkRef = ref;
        if (!(sinkRef instanceof SinkRefImpl)) {
            throw new MatchError(sinkRef);
        }
        SinkRefImpl sinkRefImpl = (SinkRefImpl)sinkRef;
        ActorRef actorRef2 = sinkRefImpl.initialPartnerRef();
        String string = actorRef2.path().toSerializationFormatWithAddress(this.system.provider().getDefaultAddress());
        return string;
    }

    @Override
    public <T> SourceRef<T> resolveSourceRef(String serializedSourceRef) {
        return new SourceRefImpl(this.system.provider().resolveActorRef(serializedSourceRef));
    }

    @Override
    public <T> SinkRef<T> resolveSinkRef(String serializedSinkRef) {
        return new SinkRefImpl(this.system.provider().resolveActorRef(serializedSinkRef));
    }

    public StreamRefResolverImpl(ExtendedActorSystem system) {
        this.system = system;
    }
}

