/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.plugin.manager.rest.api;

import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.plugin.manager.Plugin;
import com.xebialabs.plugin.manager.PluginId;
import com.xebialabs.plugin.manager.PluginId$;
import com.xebialabs.plugin.manager.PluginId$Artifact$;
import com.xebialabs.plugin.manager.PluginId$LocalFile$;
import com.xebialabs.plugin.manager.metadata.ArtifactId;
import com.xebialabs.plugin.manager.metadata.ExtendedMetadata;
import com.xebialabs.plugin.manager.metadata.PluginMetadata;
import com.xebialabs.plugin.manager.repository.PluginsRepository;
import com.xebialabs.plugin.manager.rest.dto.PluginDto;
import com.xebialabs.plugin.manager.rest.dto.RepositoryDto;
import com.xebialabs.plugin.manager.service.PluginService;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.io.IOUtils;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataInput;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.io.Codec$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.reflect.io.File$;
import scala.reflect.io.Path$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Path(value="/plugin-manager")
@Produces(value={"application/json"})
@Controller
@ScalaSignature(bytes="\u0006\u0005\t5g\u0001\u0002\u000b\u0016\u0001\tB\u0001B\f\u0001\u0003\u0006\u0004%\ta\f\u0005\tm\u0001\u0011\t\u0011)A\u0005a!)q\u0007\u0001C\u0001q!91\n\u0001b\u0001\n\u0007a\u0005BB+\u0001A\u0003%Q\nC\u0003W\u0001\u0011\u0005q\u000bC\u0003q\u0001\u0011\u0005\u0011\u000fC\u0004\u0002H\u0001!\t!!\u0013\t\u000f\u0005\u001d\u0003\u0001\"\u0001\u0002d!9\u0011\u0011\u0011\u0001\u0005\u0002\u0005\r\u0005BBAP\u0001\u0011\u0005q\u000bC\u0004\u0002.\u0002!\t!a,\t\u000f\u0005\u001d\u0007\u0001\"\u0001\u0002J\"9\u00111\u001c\u0001\u0005\u0002\u0005u\u0007bBAz\u0001\u0011\u0005\u0011Q\u001f\u0005\b\u0005?\u0001A\u0011\u0001B\u0011\u0011\u001d\u0011y\u0004\u0001C\u0005\u0005\u0003B\u0011B!#\u0001#\u0003%IAa#\t\u000f\t\r\u0006\u0001\"\u0003\u0003&\nq\u0001\u000b\\;hS:\u0014Vm]8ve\u000e,'B\u0001\f\u0018\u0003\r\t\u0007/\u001b\u0006\u00031e\tAA]3ti*\u0011!dG\u0001\b[\u0006t\u0017mZ3s\u0015\taR$\u0001\u0004qYV<\u0017N\u001c\u0006\u0003=}\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003\u0001\n1aY8n\u0007\u0001\u0019\"\u0001A\u0012\u0011\u0005\u0011bS\"A\u0013\u000b\u0005\u0019:\u0013aB:fGV\u0014X\r\u001a\u0006\u00031!R!!\u000b\u0016\u0002\t\r|'/\u001a\u0006\u0003Wu\t\u0001\u0002Z3qY>L\u0018\u000e^\u0005\u0003[\u0015\u0012q#\u00112tiJ\f7\r^*fGV\u0014X\r\u001a*fg>,(oY3\u0002\u001bAdWoZ5o'\u0016\u0014h/[2f+\u0005\u0001\u0004CA\u00195\u001b\u0005\u0011$BA\u001a\u001a\u0003\u001d\u0019XM\u001d<jG\u0016L!!\u000e\u001a\u0003\u001bAcWoZ5o'\u0016\u0014h/[2f\u00039\u0001H.^4j]N+'O^5dK\u0002\na\u0001P5oSRtDCA\u001d<!\tQ\u0004!D\u0001\u0016\u0011\u0015q3\u00011\u00011Q\t\u0019Q\b\u0005\u0002?\u00136\tqH\u0003\u0002A\u0003\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005\t\u001b\u0015a\u00024bGR|'/\u001f\u0006\u0003\t\u0016\u000bQAY3b]NT!AR$\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011\u0001S\u0001\u0004_J<\u0017B\u0001&@\u0005%\tU\u000f^8xSJ,G-\u0001\u0002fGV\tQ\n\u0005\u0002O'6\tqJ\u0003\u0002Q#\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0003I\u000bQa]2bY\u0006L!\u0001V(\u0003!\u0015CXmY;uS>t7i\u001c8uKb$\u0018aA3dA\u0005!A.[:u)\u0005A\u0006CA-b\u001b\u0005Q&BA\u0015\\\u0015\taV,\u0001\u0002sg*\u0011alX\u0001\u0003oNT\u0011\u0001Y\u0001\u0006U\u00064\u0018\r_\u0005\u0003Ej\u0013\u0001BU3ta>t7/\u001a\u0015\u0005\r\u0011D\u0017\u000e\u0005\u0002fM6\t1,\u0003\u0002h7\nA\u0001K]8ek\u000e,7/A\u0003wC2,X\rL\u0001kC\u0005Y\u0017\u0001E1qa2L7-\u0019;j_:|#n]8oQ\t1Q\u000e\u0005\u0002f]&\u0011qn\u0017\u0002\u0004\u000f\u0016#\u0016aB5ogR\fG\u000e\u001c\u000b\u0005eZ\fi\u0001\u0005\u0002ti6\t\u0011+\u0003\u0002v#\n!QK\\5u\u0011\u00159x\u00011\u0001y\u0003\u0015Ig\u000e];u!\rI\u0018\u0011B\u0007\u0002u*\u00111\u0010`\u0001\n[VdG/\u001b9beRT!! @\u0002\u0013A\u0014xN^5eKJ\u001c(bA@\u0002\u0002\u00059\u0001\u000f\\;hS:\u001c(\u0002BA\u0002\u0003\u000b\t\u0001B]3ti\u0016\f7/\u001f\u0006\u0004\u0003\u000f9\u0015!\u00026c_N\u001c\u0018bAA\u0006u\n1R*\u001e7uSB\f'\u000f\u001e$pe6$\u0015\r^1J]B,H\u000fC\u0004\u0002\u0010\u001d\u0001\r!!\u0005\u0002\u0011AdWoZ5o\u0013\u0012\u0004B!a\u0005\u0002\"9!\u0011QCA\u000f!\r\t9\"U\u0007\u0003\u00033Q1!a\u0007\"\u0003\u0019a$o\\8u}%\u0019\u0011qD)\u0002\rA\u0013X\rZ3g\u0013\u0011\t\u0019#!\n\u0003\rM#(/\u001b8h\u0015\r\ty\"\u0015\u0015\b\u0003\u001b\tI\u0003[A\u0018!\r)\u00171F\u0005\u0004\u0003[Y&AC)vKJL\b+\u0019:b[\u0006\u0012\u0011q\u0002\u0015\u0007\u000f\u0005M\u0002.!\u000f\u0011\u0007\u0015\f)$C\u0002\u00028m\u0013\u0001bQ8ogVlWm\u001d\u0017\u0003\u0003w\t#!!\u0010\u0002'5,H\u000e^5qCJ$xFZ8s[6\"\u0017\r^1)\u0007\u001d\t\t\u0005E\u0002f\u0003\u0007J1!!\u0012\\\u0005\u0011\u0001vj\u0015+\u0002\u0013Ut\u0017N\\:uC2dGc\u0001:\u0002L!9\u0011q\u0002\u0005A\u0002\u0005E\u0001fBA&\u0003SA\u0017q\u0006\u0015\u0007\u0011\u0005E\u0003.a\u0016\u0011\u0007\u0015\f\u0019&C\u0002\u0002Vm\u0013A\u0001U1uQ\u0006\u0012\u0011\u0011L\u0001\b_\u0011,G.\u001a;fQ\rA\u0011Q\f\t\u0004K\u0006}\u0013bAA17\n1A)\u0012'F)\u0016#2A]A3\u0011\u001d\t9'\u0003a\u0001\u0003S\n\u0011\u0002\u001d7vO&t\u0017\nZ:\u0011\r\u0005-\u0014QOA\t\u001b\t\tiG\u0003\u0003\u0002p\u0005E\u0014\u0001B;uS2T!!a\u001d\u0002\t)\fg/Y\u0005\u0005\u0003o\niG\u0001\u0003MSN$\bFB\u0005\u00024!\fY\bL\u0001kQ\u0019I\u0011\u0011\u000b5\u0002X!\u001a\u0011\"!\u0011\u0002\rM,\u0017M]2i)\rA\u0016Q\u0011\u0005\b\u0003\u000fS\u0001\u0019AA\t\u0003\u0015\tX/\u001a:zQ\u001d\t))a#i\u0003#\u00032!ZAG\u0013\r\tyi\u0017\u0002\n!\u0006$\b\u000eU1sC6\f#!a\")\u000b)!\u0007.!&-\u0003)DcACA)Q\u0006e\u0015EAAN\u00039\u0019X-\u0019:dQ>Z\u0018/^3ssvD#AC7\u0002!1L7\u000f\u001e*fa>\u001c\u0018\u000e^8sS\u0016\u001c\b&B\u0006eQ\u0006\rF&\u00016)\r-\t\t\u0006[ATC\t\tI+A\u0007sKB|7/\u001b;pe&,7o\f\u0015\u0003\u00175\f\u0001#\u001e9eCR,'+\u001a9pg&$xN]=\u0015\t\u0005E\u0016q\u0017\t\u0005\u0003W\n\u0019,\u0003\u0003\u00026\u00065$\u0001\u0002#bi\u0016Dq!!/\r\u0001\u0004\t\t\"\u0001\u0007sKB|7/\u001b;pefLE\rK\u0004\u00028\u0006-\u0005.!0\"\u0005\u0005e\u0006F\u0002\u0007\u0002R!\f\t-\t\u0002\u0002D\u0006\u0011#/\u001a9pg&$xN]5fg>Z(/\u001a9pg&$xN]=JIv|S\u000f\u001d3bi\u0016D3\u0001DA!\u00039a\u0017n\u001d;SKB|7/\u001b;pef$2\u0001WAf\u0011\u001d\tI,\u0004a\u0001\u0003#As!a3\u0002\f\"\fi\fK\u0003\u000eI\"\f\t\u000eL\u0001kQ\u0019i\u0011\u0011\u000b5\u0002V\u0006\u0012\u0011q[\u0001!e\u0016\u0004xn]5u_JLWm]\u0018|e\u0016\u0004xn]5u_JL\u0018\nZ?0Y&\u001cH\u000f\u000b\u0002\u000e[\u0006\u00012/Z1sG\"\u0014V\r]8tSR|'/\u001f\u000b\u00061\u0006}\u00171\u001d\u0005\b\u0003ss\u0001\u0019AA\tQ\u001d\ty.a#i\u0003{Cq!a\"\u000f\u0001\u0004\t\t\u0002K\u0004\u0002d\u0006-\u0005.!%)\u000b9!\u0007.!;-\u0003)DcADA)Q\u00065\u0018EAAx\u0003)\u0012X\r]8tSR|'/[3t_m\u0014X\r]8tSR|'/_%e{>\u001aX-\u0019:dQ>Z\u0018/^3ssvD#AD7\u0002+%t7\u000f^1mY\u001a\u0013x.\u001c*fa>\u001c\u0018\u000e^8ssRI\u0001,a>\u0002|\n\r!1\u0002\u0005\b\u0003s{\u0001\u0019AA\tQ\u001d\t90a#i\u0003{Cq!!@\u0010\u0001\u0004\t\t\"A\u0004he>,\b/\u00133)\u000f\u0005m\u00181\u00125\u0003\u0002\u0005\u0012\u0011Q \u0005\b\u0005\u000by\u0001\u0019AA\t\u0003)\t'\u000f^5gC\u000e$\u0018\n\u001a\u0015\b\u0005\u0007\tY\t\u001bB\u0005C\t\u0011)\u0001C\u0004\u0003\u000e=\u0001\r!!\u0005\u0002\u000fY,'o]5p]\":!1BAFQ\nE\u0011E\u0001B\u0007Q\u0015yA\r\u001bB\u000bY\u0005Q\u0007FB\b\u0002R!\u0014I\"\t\u0002\u0003\u001c\u0005!%/\u001a9pg&$xN]5fg>Z(/\u001a9pg&$xN]=JIv|\u0013N\\:uC2dwf_4s_V\u0004\u0018\nZ?0w\u0006\u0014H/\u001b4bGRLE-`\u0018|m\u0016\u00148/[8o{\"\u001aq\"!\u0011\u0002\u000f\u001d,G\u000fT8h_R9\u0001La\t\u0003(\t-\u0002bBA]!\u0001\u0007\u0011\u0011\u0003\u0015\b\u0005G\tY\t[A_\u0011\u001d\ti\u0010\u0005a\u0001\u0003#AsAa\n\u0002\f\"\u0014\t\u0001C\u0004\u0003\u0006A\u0001\r!!\u0005)\u000f\t-\u00121\u00125\u0003\n!*\u0001\u0003\u001a5\u000321\u0012!1G\u0011\u0003\u0005k\tq![7bO\u0016|#\u0006\u000b\u0004\u0011\u0003#B'\u0011H\u0011\u0003\u0005w\tqG]3q_NLGo\u001c:jKN|3P]3q_NLGo\u001c:z\u0013\u0012lx\u0006\\8h_>ZxM]8va&#WpL>beRLg-Y2u\u0013\u0012l\bF\u0001\tn\u0003!9\u0018\u000e\u001e5SKB|W\u0003\u0002B\"\u0005\u0017\"bA!\u0012\u0003z\tmD\u0003\u0002B$\u0005;\u0002BA!\u0013\u0003L1\u0001Aa\u0002B'#\t\u0007!q\n\u0002\u0002)F!!\u0011\u000bB,!\r\u0019(1K\u0005\u0004\u0005+\n&a\u0002(pi\"Lgn\u001a\t\u0004g\ne\u0013b\u0001B.#\n\u0019\u0011I\\=\t\u000f\t}\u0013\u00031\u0001\u0003b\u00051\u0011m\u0019;j_:\u0004ra\u001dB2\u0005O\u0012\u0019(C\u0002\u0003fE\u0013\u0011BR;oGRLwN\\\u0019\u0011\t\t%$qN\u0007\u0003\u0005WR1A!\u001c\u001a\u0003)\u0011X\r]8tSR|'/_\u0005\u0005\u0005c\u0012YGA\tQYV<\u0017N\\:SKB|7/\u001b;pef\u0004RA\u0014B;\u0005\u000fJ1Aa\u001eP\u0005\u00191U\u000f^;sK\"9\u0011\u0011X\tA\u0002\u0005E\u0001\"\u0003B?#A\u0005\t\u0019\u0001B@\u0003!!WO]1uS>t\u0007\u0003\u0002BA\u0005\u000bk!Aa!\u000b\u0007\tut*\u0003\u0003\u0003\b\n\r%\u0001\u0003#ve\u0006$\u0018n\u001c8\u0002%]LG\u000f\u001b*fa>$C-\u001a4bk2$HEM\u000b\u0005\u0005\u001b\u0013\t+\u0006\u0002\u0003\u0010*\"!q\u0010BIW\t\u0011\u0019\n\u0005\u0003\u0003\u0016\nuUB\u0001BL\u0015\u0011\u0011IJa'\u0002\u0013Ut7\r[3dW\u0016$'B\u0001!R\u0013\u0011\u0011yJa&\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rB\u0004\u0003NI\u0011\rAa\u0014\u0002\u0013]LG\u000f\u001b*fa>\u0004T\u0003\u0002BT\u0005[#BA!+\u00034R!!1\u0016BX!\u0011\u0011IE!,\u0005\u000f\t53C1\u0001\u0003P!9!qL\nA\u0002\tE\u0006cB:\u0003d\t\u001d$1\u0016\u0005\b\u0003s\u001b\u0002\u0019AA\tQ\r\u0001!q\u0017\t\u0005\u0005s\u0013y,\u0004\u0002\u0003<*\u0019!QX#\u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u0003B\nm&AC\"p]R\u0014x\u000e\u001c7fe\"*\u0001\u0001\u001a5\u0003F2\n!\u000e\u000b\u0004\u0001\u0003#B'\u0011Z\u0011\u0003\u0005\u0017\fqb\f9mk\u001eLg.L7b]\u0006<WM\u001d")
public class PluginResource
extends AbstractSecuredResource {
    private final PluginService pluginService;
    private final ExecutionContext ec;

    public PluginService pluginService() {
        return this.pluginService;
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    @GET
    @Produces(value={"application/json"})
    public Response list() {
        this.checkPermission(PlatformPermissions.ADMIN);
        return Response.ok((Object)new PluginDto(this.pluginService().extend(this.pluginService().listInstalled())), (String)"application/json").build();
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    public void install(MultipartFormDataInput input, @QueryParam(value="pluginId") String pluginId) {
        this.checkPermission(PlatformPermissions.ADMIN);
        Map uploadForm = input.getFormDataMap();
        List inputParts = (List)uploadForm.get("file");
        inputParts.forEach(part -> {
            InputStream is = (InputStream)part.getBody(InputStream.class, null);
            this.pluginService().install(new Plugin(PluginId$LocalFile$.MODULE$.apply(pluginId), (Option<ExtendedMetadata>)None$.MODULE$, is));
        });
    }

    @DELETE
    @Path(value="/delete")
    public void uninstall(@QueryParam(value="pluginId") String pluginId) {
        this.checkPermission(PlatformPermissions.ADMIN);
        Option<PluginId> option = PluginId$.MODULE$.fromIdString(pluginId);
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new NotFoundException(new StringBuilder(32).append("Plugin not currently installed: ").append(pluginId).toString());
            }
            throw new MatchError(option);
        }
        Some some = (Some)option;
        PluginId id = (PluginId)some.value();
        this.pluginService().uninstall(id);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    @POST
    @Path(value="/delete")
    @Consumes(value={"application/json"})
    public void uninstall(List<String> pluginIds) {
        this.checkPermission(PlatformPermissions.ADMIN);
        CollectionConverters$.MODULE$.ListHasAsScala(pluginIds).asScala().flatMap((Function1 & Serializable)id -> PluginId$.MODULE$.fromIdString((String)id).map((Function1 & Serializable)pluginId -> BoxesRunTime.boxToBoolean((boolean)PluginResource.$anonfun$uninstall$2(this, pluginId))));
    }

    @GET
    @Path(value="search/{query}")
    @Produces(value={"application/json"})
    public Response search(@PathParam(value="query") String query) {
        this.checkPermission(PlatformPermissions.ADMIN);
        return Response.ok((Object)new PluginDto(this.pluginService().search(query)), (String)"application/json").build();
    }

    @GET
    @Path(value="repositories/")
    @Produces(value={"application/json"})
    public Response listRepositories() {
        this.checkPermission(PlatformPermissions.ADMIN);
        return Response.ok((Object)new RepositoryDto((Seq<PluginsRepository>)this.pluginService().repositories().values().toSeq()), (String)"application/json").build();
    }

    @POST
    @Path(value="repositories/{repositoryId}/update")
    public Date updateRepository(@PathParam(value="repositoryId") String repositoryId) {
        this.checkPermission(PlatformPermissions.ADMIN);
        return (Date)this.withRepo(repositoryId, this.withRepo$default$2(), (Function1 & Serializable)x$1 -> x$1.update().map((Function1 & Serializable)x$2 -> x$2.toDate(), this.ec()));
    }

    @GET
    @Path(value="repositories/{repositoryId}/list")
    @Produces(value={"application/json"})
    public Response listRepository(@PathParam(value="repositoryId") String repositoryId) {
        this.checkPermission(PlatformPermissions.ADMIN);
        return Response.ok((Object)new PluginDto((scala.collection.immutable.Map<ArtifactId, Option<PluginMetadata>>)((scala.collection.immutable.Map)this.withRepo(repositoryId, this.withRepo$default$2(), (Function1 & Serializable)x$3 -> x$3.list()))), (String)"application/json").build();
    }

    @GET
    @Path(value="repositories/{repositoryId}/search/{query}")
    @Produces(value={"application/json"})
    public Response searchRepository(@PathParam(value="repositoryId") String repositoryId, @PathParam(value="query") String query) {
        this.checkPermission(PlatformPermissions.ADMIN);
        return Response.ok((Object)new PluginDto((scala.collection.immutable.Map<ArtifactId, Option<PluginMetadata>>)((scala.collection.immutable.Map)this.withRepo(repositoryId, this.withRepo$default$2(), (Function1 & Serializable)x$4 -> x$4.search(query)))), (String)"application/json").build();
    }

    @POST
    @Path(value="repositories/{repositoryId}/install/{groupId}/{artifactId}/{version}")
    @Produces(value={"application/json"})
    public Response installFromRepository(@PathParam(value="repositoryId") String repositoryId, @PathParam(value="groupId") String groupId, @PathParam(value="artifactId") String artifactId, @PathParam(value="version") String version) {
        this.checkPermission(PlatformPermissions.ADMIN);
        PluginId.Artifact artifact = PluginId$Artifact$.MODULE$.apply(repositoryId, groupId, artifactId, version, PluginId$Artifact$.MODULE$.apply$default$5());
        return (Response)this.pluginService().installFromRepository(artifact).map((Function1 & Serializable)x$5 -> Response.ok((Object)artifact, (String)"application/json").build()).fold((Function1 & Serializable)err -> {
            throw err;
        }, (Function1 & Serializable)ok -> ok);
    }

    @GET
    @Path(value="repositories/{repositoryId}/logo/{groupId}/{artifactId}")
    @Produces(value={"image/*"})
    public Response getLogo(@PathParam(value="repositoryId") String repositoryId, @PathParam(value="groupId") String groupId, @PathParam(value="artifactId") String artifactId) {
        this.checkPermission(PlatformPermissions.ADMIN);
        return (Response)this.pluginService().getLogo(repositoryId, artifactId).map((Function1 & Serializable)logoFile -> {
            FileInputStream input = File$.MODULE$.apply(Path$.MODULE$.jfile2path(logoFile), Codec$.MODULE$.fallbackSystemCodec()).inputStream();
            StreamingOutput stream = new StreamingOutput(null, input){
                private final FileInputStream input$1;

                public void write(OutputStream output) {
                    output.write(IOUtils.toByteArray((InputStream)this.input$1));
                    this.input$1.close();
                }
                {
                    this.input$1 = input$1;
                }
            };
            return Response.ok((Object)stream, (String)"application/octet-stream").build();
        }).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(43).append("Couldn't find logo for '").append(groupId).append(":").append(artifactId).append("' in repository '").append(repositoryId).append("'").toString());
        });
    }

    private <T> T withRepo(String repositoryId, Duration duration, Function1<PluginsRepository, Future<T>> action) {
        return this.withRepo0(repositoryId, (Function1 & Serializable)repository -> Await$.MODULE$.result((Awaitable)action.apply(repository), duration));
    }

    private <T> Duration withRepo$default$2() {
        return new package.DurationInt(package$.MODULE$.DurationInt(30)).seconds();
    }

    private <T> T withRepo0(String repositoryId, Function1<PluginsRepository, T> action) {
        Option option = this.pluginService().repositories().get((Object)repositoryId);
        if (None$.MODULE$.equals(option)) {
            throw new NotFoundException(new StringBuilder(28).append("Unknown plugin repository '").append(repositoryId).append("'").toString());
        }
        if (!(option instanceof Some)) {
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        PluginsRepository repository = (PluginsRepository)some.value();
        Object object = action.apply((Object)repository);
        return (T)object;
    }

    public static final /* synthetic */ boolean $anonfun$uninstall$2(PluginResource $this, PluginId pluginId) {
        return $this.pluginService().uninstall(pluginId);
    }

    @Autowired
    public PluginResource(PluginService pluginService) {
        this.pluginService = pluginService;
        this.ec = pluginService.pluginManager().ec();
    }
}

