/*
 * Decompiled with CFR 0.152.
 */
package liquibase.hub;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.logging.Level;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.Liquibase;
import liquibase.RuntimeEnvironment;
import liquibase.Scope;
import liquibase.changelog.ChangeLogIterator;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.visitor.ListVisitor;
import liquibase.changelog.visitor.RollbackListVisitor;
import liquibase.command.CommandExecutionException;
import liquibase.command.CommandFactory;
import liquibase.command.CommandResult;
import liquibase.command.core.RegisterChangeLogCommand;
import liquibase.command.core.SyncHubCommand;
import liquibase.configuration.ConfigurationProperty;
import liquibase.configuration.GlobalConfiguration;
import liquibase.configuration.HubConfiguration;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.exception.LockException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.executor.LoggingExecutor;
import liquibase.hub.HubService;
import liquibase.hub.HubServiceFactory;
import liquibase.hub.LiquibaseHubException;
import liquibase.hub.model.Connection;
import liquibase.hub.model.HubChangeLog;
import liquibase.hub.model.HubRegisterResponse;
import liquibase.hub.model.Operation;
import liquibase.hub.model.OperationChange;
import liquibase.hub.model.OperationEvent;
import liquibase.integration.IntegrationDetails;
import liquibase.lockservice.LockService;
import liquibase.lockservice.LockServiceFactory;
import liquibase.logging.core.BufferedLogService;
import liquibase.util.StringUtil;

public class HubUpdater {
    private final Date startTime;
    private final DatabaseChangeLog changeLog;
    private final Database database;
    private static final String SEPARATOR_LINE = "\n----------------------------------------------------------------------\n";

    public HubUpdater(Date startTime, DatabaseChangeLog changeLog, Database database) {
        this.startTime = startTime;
        this.changeLog = changeLog;
        this.database = database;
    }

    public Operation preUpdateHub(String operationType, Database database, Connection connection, String changeLogFile, Contexts contexts, LabelExpression labelExpression, ChangeLogIterator changeLogIterator) throws LiquibaseHubException, DatabaseException, LiquibaseException, SQLException {
        Executor executor = Scope.getCurrentScope().getSingleton(ExecutorService.class).getExecutor("jdbc", database);
        if (executor instanceof LoggingExecutor) {
            return null;
        }
        if (this.hubIsNotAvailable(this.changeLog.getChangeLogId())) {
            return null;
        }
        this.syncHub(changeLogFile, database, this.changeLog, connection.getId());
        this.loadDatabaseMetadata(database);
        HubService hubService = Scope.getCurrentScope().getSingleton(HubServiceFactory.class).getService();
        HubChangeLog hubChangeLog = hubService.getHubChangeLog(UUID.fromString(this.changeLog.getChangeLogId()));
        Operation updateOperation = hubService.createOperation(operationType, hubChangeLog, connection);
        try {
            hubService.sendOperationEvent(updateOperation, new OperationEvent().setEventType("START").setStartDate(this.startTime).setOperationEventStatus(new OperationEvent.OperationEventStatus().setOperationEventStatusType("PASS").setStatusMessage("Update operation started successfully")));
        }
        catch (LiquibaseException e2) {
            Scope.getCurrentScope().getLog(this.getClass()).warning(e2.getMessage(), e2);
        }
        ListVisitor listVisitor = operationType.equalsIgnoreCase("ROLLBACK") ? new RollbackListVisitor() : new ListVisitor();
        changeLogIterator.run(listVisitor, new RuntimeEnvironment(database, contexts, labelExpression));
        List<ChangeSet> operationChangeSets = listVisitor.getSeenChangeSets();
        OperationChange operationChange = new OperationChange();
        for (ChangeSet operationChangeSet : operationChangeSets) {
            operationChange.getChangeSets().add(operationChangeSet);
        }
        operationChange.setProject(hubChangeLog.getProject());
        operationChange.setOperation(updateOperation);
        try {
            hubService.sendOperationChanges(operationChange);
        }
        catch (LiquibaseException e3) {
            Scope.getCurrentScope().getLog(this.getClass()).warning(e3.getMessage(), e3);
        }
        return updateOperation;
    }

    public void postUpdateHub(Operation updateOperation, BufferedLogService bufferLog) {
        try {
            Executor executor = Scope.getCurrentScope().getSingleton(ExecutorService.class).getExecutor("jdbc", this.database);
            if (executor instanceof LoggingExecutor) {
                return;
            }
            if (updateOperation == null || this.hubIsNotAvailable(this.changeLog.getChangeLogId())) {
                return;
            }
            HubService hubService = Scope.getCurrentScope().getSingleton(HubServiceFactory.class).getService();
            hubService.sendOperationEvent(updateOperation, new OperationEvent().setEventType("COMPLETE").setStartDate(this.startTime).setEndDate(new Date()).setOperationEventStatus(new OperationEvent.OperationEventStatus().setOperationEventStatusType("PASS").setStatusMessage("Update operation completed successfully")).setOperationEventLog(new OperationEvent.OperationEventLog().setLogMessage(bufferLog.getLogAsString(Level.INFO)).setTimestampLog(this.startTime)));
            this.showOperationReportLink(updateOperation, hubService);
        }
        catch (LiquibaseException e2) {
            Scope.getCurrentScope().getLog(this.getClass()).warning(e2.getMessage(), e2);
        }
    }

    public void postUpdateHubExceptionHandling(Operation updateOperation, BufferedLogService bufferLog, String originalExceptionMessage) {
        try {
            Executor executor = Scope.getCurrentScope().getSingleton(ExecutorService.class).getExecutor("jdbc", this.database);
            if (executor instanceof LoggingExecutor) {
                return;
            }
            if (updateOperation == null || this.hubIsNotAvailable(this.changeLog.getChangeLogId())) {
                return;
            }
            HubService hubService = Scope.getCurrentScope().getSingleton(HubServiceFactory.class).getService();
            hubService.sendOperationEvent(updateOperation, new OperationEvent().setEventType("COMPLETE").setStartDate(this.startTime).setEndDate(new Date()).setOperationEventStatus(new OperationEvent.OperationEventStatus().setOperationEventStatusType("FAIL").setStatusMessage("Update operation completed with errors")).setOperationEventLog(new OperationEvent.OperationEventLog().setLogMessage(bufferLog.getLogAsString(Level.INFO))));
            this.showOperationReportLink(updateOperation, hubService);
        }
        catch (LiquibaseException serviceException) {
            Scope.getCurrentScope().getLog(this.getClass()).warning(originalExceptionMessage, serviceException);
        }
    }

    public boolean hubIsNotAvailable(String changeLogId) {
        HubService hubService = Scope.getCurrentScope().getSingleton(HubServiceFactory.class).getService();
        return !hubService.isOnline() || changeLogId == null;
    }

    public void syncHub(String changeLogFile, Database database, DatabaseChangeLog databaseChangeLog, UUID hubConnectionId) {
        SyncHubCommand syncHub = (SyncHubCommand)CommandFactory.getInstance().getCommand("syncHub");
        syncHub.setChangeLogFile(changeLogFile);
        syncHub.setUrl(database.getConnection().getURL());
        syncHub.setHubConnectionId(hubConnectionId != null ? Objects.toString(hubConnectionId) : null);
        syncHub.setDatabase(database);
        syncHub.setFailIfOnline(false);
        try {
            syncHub.configure(Collections.singletonMap("changeLog", databaseChangeLog));
            Object commandResult = syncHub.execute();
            if (!((CommandResult)commandResult).succeeded) {
                Scope.getCurrentScope().getLog(this.getClass()).warning("Liquibase Hub sync failed: " + ((CommandResult)commandResult).message);
            }
        }
        catch (Exception e2) {
            Scope.getCurrentScope().getLog(this.getClass()).warning("Liquibase Hub sync failed: " + e2.getMessage(), e2);
        }
    }

    public void register(String changeLogFile) throws LiquibaseException, CommandExecutionException {
        Executor executor = Scope.getCurrentScope().getSingleton(ExecutorService.class).getExecutor("jdbc", this.database);
        if (executor instanceof LoggingExecutor) {
            return;
        }
        HubConfiguration hubConfiguration = LiquibaseConfiguration.getInstance().getConfiguration(HubConfiguration.class);
        HubService hubService = Scope.getCurrentScope().getSingleton(HubServiceFactory.class).getService();
        if (!hubService.isOnline()) {
            return;
        }
        if (!StringUtil.isEmpty(hubConfiguration.getLiquibaseHubApiKey()) || this.changeLog.getChangeLogId() != null) {
            return;
        }
        try {
            LockService lockService = LockServiceFactory.getInstance().getLockService(this.database);
            lockService.releaseLock();
        }
        catch (LockException e2) {
            Scope.getCurrentScope().getLog(HubUpdater.class).warning(Liquibase.MSG_COULD_NOT_RELEASE_LOCK);
        }
        String promptString = "Do you want to see this operation's report in Liquibase Hub, which improves team collaboration? \nIf so, enter your email. If not, enter [N] to no longer be prompted, or [S] to skip for now, but ask again next time";
        String input = Scope.getCurrentScope().getUI().prompt(promptString, "S", (input1, returnType) -> {
            if (!((input1 = input1.trim().toLowerCase()).equals("s") || input1.equals("n") || input1.contains("@"))) {
                throw new IllegalArgumentException("Invalid input '" + input1 + "'");
            }
            return input1;
        }, String.class);
        LockService lockService = LockServiceFactory.getInstance().getLockService(this.database);
        lockService.waitForLock();
        String defaultsFilePath = (String)((Object)Scope.getCurrentScope().get("defaultsFile", String.class));
        File defaultsFile = null;
        if (defaultsFilePath != null) {
            defaultsFile = new File(defaultsFilePath);
        }
        if ((input = input.toLowerCase()).equals("n")) {
            try {
                String message = "No operations will be reported. Simply add a liquibase.hub.apiKey setting to generate free deployment reports. Learn more at https://hub.liquibase.com";
                Scope.getCurrentScope().getUI().sendMessage(message);
                Scope.getCurrentScope().getLog(this.getClass()).info(message);
                this.writeToPropertiesFile(defaultsFile, "\nliquibase.hub.mode=off\n");
                message = "* Updated properties file " + defaultsFile + " to set liquibase.hub.mode=off";
                Scope.getCurrentScope().getUI().sendMessage(message);
                Scope.getCurrentScope().getLog(this.getClass()).info(message);
            }
            catch (IOException ioe) {
                String message = "Unable to write hubMode to liquibase.properties: " + ioe.getMessage();
                Scope.getCurrentScope().getUI().sendMessage(message);
                Scope.getCurrentScope().getLog(this.getClass()).warning(message);
            }
        } else if (input.equals("s")) {
            String message = "Skipping auto-registration";
            Scope.getCurrentScope().getUI().sendMessage(message);
            Scope.getCurrentScope().getLog(this.getClass()).warning(message);
        } else {
            HubRegisterResponse registerResponse = null;
            try {
                registerResponse = hubService.register(input);
            }
            catch (LiquibaseException lhe) {
                String message = "Account creation failed for email address '" + input + "': " + lhe.getMessage() + ".\nNo operation report will be generated.";
                Scope.getCurrentScope().getUI().sendMessage(message);
                Scope.getCurrentScope().getLog(HubUpdater.class).warning(message);
                return;
            }
            if (registerResponse == null) {
                String message = "Account creation failed for email address '" + input + "'.\nNo operation report will be generated.";
                Scope.getCurrentScope().getUI().sendMessage(message);
                Scope.getCurrentScope().getLog(HubUpdater.class).warning(message);
                return;
            }
            String message = null;
            try {
                this.writeToPropertiesFile(defaultsFile, "\nliquibase.hub.apiKey=" + registerResponse.getApiKey() + "\n");
                ConfigurationProperty hubModeProperty = hubConfiguration.getProperty("mode");
                if (!hubModeProperty.getWasOverridden()) {
                    this.writeToPropertiesFile(defaultsFile, "\nliquibase.hub.mode=all\n");
                    message = "* Updated properties file " + defaultsFile + " to set liquibase.hub properties";
                    Scope.getCurrentScope().getUI().sendMessage(message);
                    Scope.getCurrentScope().getLog(this.getClass()).info(message);
                } else {
                    message = "* Updated the liquibase.hub.apiKey property.";
                    String message2 = "The liquibase.hub.mode is already set to " + hubConfiguration.getLiquibaseHubMode() + ". It will not be updated.";
                    Scope.getCurrentScope().getUI().sendMessage(message);
                    Scope.getCurrentScope().getUI().sendMessage(message2);
                    Scope.getCurrentScope().getLog(this.getClass()).warning(message);
                    Scope.getCurrentScope().getLog(this.getClass()).warning(message2);
                }
                message = "* Registering changelog file " + changeLogFile + " with Hub";
                Scope.getCurrentScope().getUI().sendMessage(message);
                Scope.getCurrentScope().getLog(this.getClass()).info(message);
                hubConfiguration.setLiquibaseHubApiKey(registerResponse.getApiKey());
                this.registerChangeLog(registerResponse.getProjectId(), this.changeLog, changeLogFile);
                message = "Great! Your free operation and deployment reports will be available to you after your local Liquibase commands complete.";
                Scope.getCurrentScope().getUI().sendMessage(message);
                Scope.getCurrentScope().getLog(this.getClass()).info(message);
            }
            catch (IOException ioe) {
                message = "Unable to write information to liquibase.properties: " + ioe.getMessage() + "\nPlease check your permissions.  No operations will be reported.";
                Scope.getCurrentScope().getUI().sendMessage(message);
                Scope.getCurrentScope().getLog(this.getClass()).warning(message);
            }
            catch (CommandExecutionException cee) {
                message = "Unable to register changelog: " + cee.getMessage() + "\nNo operations will be reported.";
                Scope.getCurrentScope().getUI().sendMessage(message);
                Scope.getCurrentScope().getLog(this.getClass()).warning(message);
                hubConfiguration.setLiquibaseHubApiKey(null);
            }
        }
    }

    private void writeToPropertiesFile(File defaultsFile, String stringToWrite) throws IOException {
        String encoding = LiquibaseConfiguration.getInstance().getConfiguration(GlobalConfiguration.class).getOutputEncoding();
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(defaultsFile, "rw");){
            randomAccessFile.seek(defaultsFile.length());
            randomAccessFile.write(stringToWrite.getBytes(encoding));
        }
    }

    private void registerChangeLog(UUID hubProjectId, DatabaseChangeLog changeLog, String changeLogFile) throws LiquibaseException, CommandExecutionException {
        RegisterChangeLogCommand registerChangeLogCommand;
        block4: {
            HashMap<String, Object> argsMap = new HashMap<String, Object>();
            argsMap.put("changeLog", changeLog);
            registerChangeLogCommand = new RegisterChangeLogCommand();
            registerChangeLogCommand.configure(argsMap);
            registerChangeLogCommand.setChangeLogFile(changeLogFile);
            try {
                if (hubProjectId == null) break block4;
                try {
                    registerChangeLogCommand.setHubProjectId(hubProjectId);
                }
                catch (IllegalArgumentException e2) {
                    throw new LiquibaseException("The command 'RegisterChangeLog'  failed because parameter 'hubProjectId' has invalid value '" + hubProjectId + "'. Learn more at https://hub.liquibase.com");
                }
            }
            catch (IllegalArgumentException e3) {
                throw new LiquibaseException("Unexpected hubProjectId format: " + hubProjectId, e3);
            }
        }
        Object result = registerChangeLogCommand.execute();
        Scope.getCurrentScope().getUI().sendMessage(((CommandResult)result).print());
    }

    private void showOperationReportLink(Operation updateOperation, HubService hubService) throws LiquibaseException {
        Connection connection = updateOperation.getConnection();
        String reportURL = "/organizations/" + hubService.getOrganization().getId().toString() + "/projects/" + connection.getProject().getId() + "/operations/" + updateOperation.getId().toString();
        String hubLink = hubService.shortenLink(reportURL);
        String message = SEPARATOR_LINE;
        message = message + "View a report of this operation at " + hubLink + "\n";
        message = message + "* IMPORTANT: New users of Hub first need to Sign In to your account\n";
        message = message + "with the one-time password sent to your email, which also serves as\n";
        message = message + "your username.";
        message = message + SEPARATOR_LINE;
        Scope.getCurrentScope().getUI().sendMessage(message);
        Scope.getCurrentScope().getLog(this.getClass()).info(message);
    }

    private void loadDatabaseMetadata(Database database) throws DatabaseException, SQLException {
        if (database.getConnection() == null) {
            return;
        }
        IntegrationDetails integrationDetails = (IntegrationDetails)((Object)Scope.getCurrentScope().get("integrationDetails", IntegrationDetails.class));
        if (integrationDetails == null) {
            return;
        }
        String databaseProductName = database.getDatabaseProductName();
        String databaseProductVersion = database.getDatabaseProductVersion();
        Scope.getCurrentScope().getLog(this.getClass()).fine("Database product name         " + databaseProductName);
        Scope.getCurrentScope().getLog(this.getClass()).fine("Database product version      " + databaseProductVersion);
        DatabaseConnection connection = database.getConnection();
        if (connection instanceof JdbcConnection) {
            JdbcConnection jdbcConnection = (JdbcConnection)connection;
            java.sql.Connection conn = jdbcConnection.getUnderlyingConnection();
            int driverMajorVersion = conn.getMetaData().getDriverMajorVersion();
            int driverMinorVersion = conn.getMetaData().getDriverMinorVersion();
            Scope.getCurrentScope().getLog(this.getClass()).fine("Database driver version       " + driverMajorVersion + "." + driverMinorVersion);
            integrationDetails.setParameter("db__driverVersion", driverMajorVersion + "." + driverMinorVersion);
        } else {
            integrationDetails.setParameter("db__driverVersion", "Unable to determine");
        }
        integrationDetails.setParameter("db__databaseProduct", databaseProductName);
        integrationDetails.setParameter("db__databaseVersion", databaseProductVersion);
    }
}

