/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.repository.DependencyRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.query.ResolveOptions;
import com.xebialabs.xlrelease.repository.sql.BaseReleaseItemRepository;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$RichCiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.DependencyPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.DependencyRow$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\u0005\rf\u0001B\n\u0015\u0001}A\u0001B\u000e\u0001\u0003\u0006\u0004%\ta\u000e\u0005\t}\u0001\u0011\t\u0011)A\u0005q!Aq\b\u0001BC\u0002\u0013\u0005\u0001\t\u0003\u0005E\u0001\t\u0005\t\u0015!\u0003B\u0011!)\u0005A!b\u0001\n\u00031\u0005\u0002\u0003&\u0001\u0005\u0003\u0005\u000b\u0011B$\t\u000b-\u0003A\u0011\u0001'\t\u000bE\u0003A\u0011\t*\t\u000bE\u0004A\u0011\t:\t\u000bm\u0004A\u0011\t?\t\rm\u0004A\u0011IA\u0001\u0011\u001d\t\u0019\u0003\u0001C!\u0003KAq!a\u000b\u0001\t\u0003\ni\u0003C\u0004\u00028\u0001!\t%!\u000f\t\u000f\u0005E\u0003\u0001\"\u0011\u0002T!9\u00111\u000e\u0001\u0005\n\u00055\u0004bBA9\u0001\u0011%\u00111\u000f\u0005\b\u0003\u000f\u0003A\u0011BAE\u0005]\u0019\u0016\u000f\u001c#fa\u0016tG-\u001a8dsJ+\u0007o\\:ji>\u0014\u0018P\u0003\u0002\u0016-\u0005\u00191/\u001d7\u000b\u0005]A\u0012A\u0003:fa>\u001c\u0018\u000e^8ss*\u0011\u0011DG\u0001\nq2\u0014X\r\\3bg\u0016T!a\u0007\u000f\u0002\u0013a,'-[1mC\n\u001c(\"A\u000f\u0002\u0007\r|Wn\u0001\u0001\u0014\u000b\u0001\u0001cE\u000b\u0018\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0003\r\nQa]2bY\u0006L!!\n\u0012\u0003\r\u0005s\u0017PU3g!\t9\u0003&D\u0001\u0017\u0013\tIcC\u0001\u000bEKB,g\u000eZ3oGf\u0014V\r]8tSR|'/\u001f\t\u0003W1j\u0011\u0001F\u0005\u0003[Q\u0011\u0011DQ1tKJ+G.Z1tK&#X-\u001c*fa>\u001c\u0018\u000e^8ssB\u0011q\u0006N\u0007\u0002a)\u0011\u0011GM\u0001\u0006g24GG\u001b\u0006\u0002g\u0005AqM]5{u2,G-\u0003\u00026a\t9Aj\\4hS:<\u0017A\u0005:fY\u0016\f7/\u001a)feNL7\u000f^3oG\u0016,\u0012\u0001\u000f\t\u0003sqj\u0011A\u000f\u0006\u0003wQ\t1\u0002]3sg&\u001cH/\u001a8dK&\u0011QH\u000f\u0002\u0013%\u0016dW-Y:f!\u0016\u00148/[:uK:\u001cW-A\nsK2,\u0017m]3QKJ\u001c\u0018n\u001d;f]\u000e,\u0007%A\u000beKB,g\u000eZ3oGf\u0004VM]:jgR,gnY3\u0016\u0003\u0005\u0003\"!\u000f\"\n\u0005\rS$!\u0006#fa\u0016tG-\u001a8dsB+'o]5ti\u0016t7-Z\u0001\u0017I\u0016\u0004XM\u001c3f]\u000eL\b+\u001a:tSN$XM\\2fA\u0005\t\"/\u001a9pg&$xN]=BI\u0006\u0004H/\u001a:\u0016\u0003\u001d\u0003\"a\u000b%\n\u0005%#\"\u0001F*rYJ+\u0007o\\:ji>\u0014\u00180\u00113baR,'/\u0001\nsKB|7/\u001b;pef\fE-\u00199uKJ\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0003N\u001d>\u0003\u0006CA\u0016\u0001\u0011\u00151t\u00011\u00019\u0011\u0015yt\u00011\u0001B\u0011\u0015)u\u00011\u0001H\u0003!1\u0017N\u001c3Cs&#GCA*Z!\t!v+D\u0001V\u0015\t1\u0006$\u0001\u0004e_6\f\u0017N\\\u0005\u00031V\u0013!\u0002R3qK:$WM\\2z\u0011\u0015Q\u0006\u00021\u0001\\\u0003\tIG\r\u0005\u0002]G:\u0011Q,\u0019\t\u0003=\nj\u0011a\u0018\u0006\u0003Az\ta\u0001\u0010:p_Rt\u0014B\u00012#\u0003\u0019\u0001&/\u001a3fM&\u0011A-\u001a\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\t\u0014\u0003F\u0001\u0005h!\tAw.D\u0001j\u0015\tQ7.\u0001\u0006b]:|G/\u0019;j_:T!\u0001\\7\u0002\u000f5,GO]5dg*\u0011a\u000eH\u0001\tG>$\u0017\r[1mK&\u0011\u0001/\u001b\u0002\u0006)&lW\rZ\u0001\u0007GJ,\u0017\r^3\u0015\u0007M\u001b\b\u0010C\u0003u\u0013\u0001\u0007Q/A\u0004sK2,\u0017m]3\u0011\u0005Q3\u0018BA<V\u0005\u001d\u0011V\r\\3bg\u0016DQ!_\u0005A\u0002M\u000b!\u0002Z3qK:$WM\\2zQ\tIq-\u0001\u0004va\u0012\fG/\u001a\u000b\u0004'vt\b\"\u0002;\u000b\u0001\u0004)\b\"B=\u000b\u0001\u0004\u0019\u0006F\u0001\u0006h)\u0019\t\u0019!!\u0003\u0002\fA\u0019\u0011%!\u0002\n\u0007\u0005\u001d!E\u0001\u0003V]&$\b\"\u0002;\f\u0001\u0004)\bbBA\u0007\u0017\u0001\u0007\u0011qB\u0001\rI\u0016\u0004XM\u001c3f]\u000eLWm\u001d\t\u0006\u0003#\tYb\u0015\b\u0005\u0003'\t9BD\u0002_\u0003+I\u0011aI\u0005\u0004\u00033\u0011\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003;\tyBA\u0002TKFT1!!\u0007#Q\tYq-\u0001\u0004eK2,G/\u001a\u000b\u0005\u0003\u0007\t9\u0003C\u0003z\u0019\u0001\u00071\u000b\u000b\u0002\rO\u00069\u0011M]2iSZ,GCBA\u0002\u0003_\t\t\u0004C\u0003u\u001b\u0001\u0007Q\u000fC\u0004\u000245\u0001\r!a\u0004\u0002)\u0005\u00148\r[5wK\u0012$U\r]3oI\u0016t7-[3tQ\tiq-A\bgS:$')\u001f*fY\u0016\f7/Z%e)\u0011\tY$a\u0013\u0011\u000b\u0005u\u0012qI*\u000e\u0005\u0005}\"\u0002BA!\u0003\u0007\nA!\u001e;jY*\u0011\u0011QI\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002J\u0005}\"\u0001\u0002'jgRDa!!\u0014\u000f\u0001\u0004Y\u0016!\u0003:fY\u0016\f7/Z%eQ\tqq-A\u000egS:$\u0017\t\u001c7J]\u000e|W.\u001b8h\t\u0016\u0004XM\u001c3f]\u000eLWm\u001d\u000b\t\u0003\u001f\t)&a\u0017\u0002`!9\u0011qK\bA\u0002\u0005e\u0013!\u0003;be\u001e,G/\u00133t!\u0015\t\t\"a\u0007\\\u0011\u001d\tif\u0004a\u0001\u00033\n\u0001b\u001d;biV\u001cXm\u001d\u0005\b\u0003Cz\u0001\u0019AA2\u0003M\u0011XMZ3sK:\u001c\u0017N\\4DQ&dGM]3o!\r\t\u0013QM\u0005\u0004\u0003O\u0012#a\u0002\"p_2,\u0017M\u001c\u0015\u0003\u001f\u001d\faB]3t_24X\rV1sO\u0016$8\u000f\u0006\u0003\u0002\u0010\u0005=\u0004bBA\u0007!\u0001\u0007\u0011qB\u0001\u001ce\u0016\u001cx\u000e\u001c<f)\u0006\u0014x-\u001a;Ge>l7)\u00198eS\u0012\fG/Z:\u0015\u000bM\u000b)(!\"\t\u000f\u0005]\u0014\u00031\u0001\u0002z\u00051B/\u0019:hKR\u0014V\r\\3bg\u0016\u0004F.\u00198Ji\u0016l7\u000fE\u0003]\u0003w\ny(C\u0002\u0002~\u0015\u00141aU3u!\r!\u0016\u0011Q\u0005\u0004\u0003\u0007+&\u0001\u0003)mC:LE/Z7\t\u000be\f\u0002\u0019A*\u0002)1|\u0017\r\u001a*fY\u0016\f7/\u001a)mC:LE/Z7t)\u0011\tI(a#\t\r\u00055%\u00031\u0001\\\u0003=!\u0018M]4fiJ+G.Z1tK&#\u0007f\u0001\u0001\u0002\u0012B!\u00111SAP\u001b\t\t)J\u0003\u0003\u0002\u0018\u0006e\u0015a\u0003;sC:\u001c\u0018m\u0019;j_:T1!FAN\u0015\r\ti\nG\u0001\u0003I\nLA!!)\u0002\u0016\ny\u0011j\u001d+sC:\u001c\u0018m\u0019;j_:\fG\u000e")
public class SqlDependencyRepository
implements DependencyRepository,
BaseReleaseItemRepository,
Logging {
    private final ReleasePersistence releasePersistence;
    private final DependencyPersistence dependencyPersistence;
    private final SqlRepositoryAdapter repositoryAdapter;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public Release getRelease(String releaseId, String entityId) {
        return BaseReleaseItemRepository.getRelease$(this, releaseId, entityId);
    }

    @Override
    public Release getRelease(String releaseId, String entityId, ResolveOptions resolveOptions) {
        return BaseReleaseItemRepository.getRelease$(this, releaseId, entityId, resolveOptions);
    }

    @Override
    public <T> T notNull(T ci, String ciId) {
        return (T)BaseReleaseItemRepository.notNull$(this, ci, ciId);
    }

    @Override
    public void insertDependencyWithGateTaskUid(Integer gateTaskUid, Dependency dependency) {
        BaseReleaseItemRepository.insertDependencyWithGateTaskUid$(this, gateTaskUid, dependency);
    }

    @Override
    public void insertDependency(Dependency dependency) {
        BaseReleaseItemRepository.insertDependency$(this, dependency);
    }

    @Override
    public void checkIsNotReferencedByDependencies(String planItemIdOrItsChildren) {
        BaseReleaseItemRepository.checkIsNotReferencedByDependencies$(this, planItemIdOrItsChildren);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlDependencyRepository sqlDependencyRepository = this;
        synchronized (sqlDependencyRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public ReleasePersistence releasePersistence() {
        return this.releasePersistence;
    }

    @Override
    public DependencyPersistence dependencyPersistence() {
        return this.dependencyPersistence;
    }

    @Override
    public SqlRepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    @Timed
    public Dependency findById(String id) {
        String releaseId = Ids.releaseIdFrom((String)id);
        Release release = this.getRelease(releaseId, id);
        Option maybeDependency = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(release.getAllGates()).asScala().flatMap((Function1 & Serializable)x$1 -> CollectionConverters$.MODULE$.ListHasAsScala(x$1.getDependencies()).asScala())).find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)SqlDependencyRepository.$anonfun$findById$2(id, x$2)));
        return (Dependency)maybeDependency.getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(30).append("Repository entity [").append(id).append("] not found").toString(), new Object[0]);
        });
    }

    @Timed
    public Dependency create(Release release, Dependency dependency) {
        this.insertDependency(dependency);
        this.releasePersistence().update(release);
        return dependency;
    }

    @Timed
    public Dependency update(Release release, Dependency dependency) {
        if (!dependency.isArchived()) {
            this.dependencyPersistence().updateDependency(dependency);
        } else {
            this.dependencyPersistence().deleteDependency(dependency);
        }
        this.releasePersistence().update(release);
        return dependency;
    }

    @Timed
    public void update(Release release, Seq<Dependency> dependencies) {
        dependencies.foreach((Function1 & Serializable)dependency -> {
            SqlDependencyRepository.$anonfun$update$1(this, dependency);
            return BoxedUnit.UNIT;
        });
        this.releasePersistence().update(release);
    }

    @Timed
    public void delete(Dependency dependency) {
        Release release = this.getRelease(Ids.releaseIdFrom((String)dependency.getId()), dependency.getId());
        Option maybeGateTask = CollectionConverters$.MODULE$.ListHasAsScala(release.getAllGates()).asScala().find((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)SqlDependencyRepository.$anonfun$delete$1(dependency, x$3)));
        maybeGateTask.map((Function1 & Serializable)gateTask -> {
            gateTask.setDependencies(CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala(gateTask.getDependencies()).asScala().filterNot((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)SqlDependencyRepository.$anonfun$delete$3(dependency, x$4)))).asJava());
            this.releasePersistence().update(release);
            this.dependencyPersistence().deleteDependency(dependency);
            return dependency;
        }).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(47).append("GateTask ").append(dependency.getGateTask().getId()).append(" not found while deleting dependency ").append(dependency.getId()).append(".").toString(), new Object[0]);
        });
    }

    @Timed
    public void archive(Release release, Seq<Dependency> archivedDependencies) {
        block0: {
            if (!archivedDependencies.nonEmpty()) break block0;
            archivedDependencies.foreach((Function1 & Serializable)dependency -> {
                SqlDependencyRepository.$anonfun$archive$1(this, dependency);
                return BoxedUnit.UNIT;
            });
            this.releasePersistence().update(release);
        }
    }

    @Timed
    public List<Dependency> findByReleaseId(String releaseId) {
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.resolveTargets(DependencyRow$.MODULE$.DependencyDataSeqOps(this.dependencyPersistence().findByGateReleaseId(CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(releaseId)))).asDependencies())).asJava();
    }

    @Timed
    public Seq<Dependency> findAllIncomingDependencies(Seq<String> targetIds, Seq<String> statuses, boolean referencingChildren) {
        return referencingChildren ? DependencyRow$.MODULE$.DependencyDataSeqOps(this.dependencyPersistence().findByPartialTargetIds((Set<String>)targetIds.toSet(), (Option<Set<String>>)SqlDependencyRepository.status$1(statuses))).asDependencies() : DependencyRow$.MODULE$.DependencyDataSeqOps(this.dependencyPersistence().findByTargetIds((Set<String>)targetIds.toSet(), (Option<Set<String>>)SqlDependencyRepository.status$1(statuses))).asDependencies();
    }

    private Seq<Dependency> resolveTargets(Seq<Dependency> dependencies) {
        ((IterableOps)((IterableOps)dependencies.filterNot((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.hasVariableTarget()))).filter((Function1 & Serializable)d -> BoxesRunTime.boxToBoolean((boolean)SqlDependencyRepository.$anonfun$resolveTargets$2(d)))).groupBy((Function1 & Serializable)d -> Ids.releaseIdFrom((String)d.getTargetId())).foreach((Function1 & Serializable)x0$1 -> {
            SqlDependencyRepository.$anonfun$resolveTargets$4(this, x0$1);
            return BoxedUnit.UNIT;
        });
        return dependencies;
    }

    private Dependency resolveTargetFromCandidates(Set<PlanItem> targetReleasePlanItems, Dependency dependency) {
        String targetId = dependency.getTargetId();
        if (!dependency.hasVariableTarget()) {
            Option option = targetReleasePlanItems.find((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)SqlDependencyRepository.$anonfun$resolveTargetFromCandidates$1(targetId, x$6)));
            if (option instanceof Some) {
                Some some = (Some)option;
                PlanItem target = (PlanItem)some.value();
                dependency.setTarget(target);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                this.logger().warn((Function0 & Serializable)() -> new StringBuilder(52).append("Target '").append(dependency.getTargetId()).append("' of the Dependency '").append(dependency.getId()).append("' could not be resolved").toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)option);
            }
        }
        return dependency;
    }

    private Set<PlanItem> loadReleasePlanItems(String targetReleaseId) {
        Set set;
        try {
            Release releaseOrNull = (Release)this.repositoryAdapter().read(targetReleaseId);
            set = (Set)Option$.MODULE$.apply((Object)releaseOrNull).map((Function1 & Serializable)x$7 -> CollectionConverters$.MODULE$.ListHasAsScala(x$7.getAllPlanItems()).asScala().toSet()).getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Set().empty());
        }
        catch (NotFoundException notFoundException) {
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(29).append("Could not find release by ID ").append(targetReleaseId).toString());
            set = Predef$.MODULE$.Set().empty();
        }
        return set;
    }

    public static final /* synthetic */ boolean $anonfun$findById$2(String id$1, Dependency x$2) {
        String string = x$2.getId();
        String string2 = CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(id$1));
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$update$1(SqlDependencyRepository $this, Dependency dependency) {
        if (!dependency.isArchived()) {
            $this.dependencyPersistence().updateDependency(dependency);
        } else {
            $this.dependencyPersistence().deleteDependency(dependency);
        }
    }

    public static final /* synthetic */ boolean $anonfun$delete$1(Dependency dependency$1, GateTask x$3) {
        String string = x$3.getId();
        String string2 = CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(dependency$1.getGateTask().getId()));
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$delete$3(Dependency dependency$1, Dependency x$4) {
        String string = x$4.getId();
        String string2 = CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(dependency$1.getId()));
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$archive$1(SqlDependencyRepository $this, Dependency dependency) {
        $this.dependencyPersistence().deleteDependency(dependency);
    }

    private static final Option status$1(Seq statuses$1) {
        return statuses$1.isEmpty() ? None$.MODULE$ : new Some((Object)statuses$1.toSet());
    }

    public static final /* synthetic */ boolean $anonfun$resolveTargets$2(Dependency d) {
        return Ids.isReleaseId((String)d.getTargetId()) || Ids.isInRelease((String)d.getTargetId());
    }

    public static final /* synthetic */ void $anonfun$resolveTargets$4(SqlDependencyRepository $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String targetReleaseId = (String)tuple2._1();
        Seq releaseDependencies = (Seq)tuple2._2();
        Set<PlanItem> targetReleasePlanItems = $this.loadReleasePlanItems(targetReleaseId);
        releaseDependencies.foreach((Function1 & Serializable)d -> $this.resolveTargetFromCandidates(targetReleasePlanItems, (Dependency)d));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$resolveTargetFromCandidates$1(String targetId$1, PlanItem x$6) {
        String string = x$6.getId();
        String string2 = targetId$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public SqlDependencyRepository(ReleasePersistence releasePersistence, DependencyPersistence dependencyPersistence, SqlRepositoryAdapter repositoryAdapter) {
        this.releasePersistence = releasePersistence;
        this.dependencyPersistence = dependencyPersistence;
        this.repositoryAdapter = repositoryAdapter;
        BaseReleaseItemRepository.$init$(this);
        Logging.$init$((Logging)this);
    }
}

