/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.simple;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.jcr.AccessDeniedException;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.security.auth.Subject;
import org.apache.jackrabbit.api.security.principal.PrincipalIterator;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.config.AccessManagerConfig;
import org.apache.jackrabbit.core.config.LoginModuleConfig;
import org.apache.jackrabbit.core.config.SecurityConfig;
import org.apache.jackrabbit.core.security.AMContext;
import org.apache.jackrabbit.core.security.AccessManager;
import org.apache.jackrabbit.core.security.AnonymousPrincipal;
import org.apache.jackrabbit.core.security.JackrabbitSecurityManager;
import org.apache.jackrabbit.core.security.UserPrincipal;
import org.apache.jackrabbit.core.security.authentication.AuthContext;
import org.apache.jackrabbit.core.security.authentication.AuthContextProvider;
import org.apache.jackrabbit.core.security.principal.AdminPrincipal;
import org.apache.jackrabbit.core.security.principal.EveryonePrincipal;
import org.apache.jackrabbit.core.security.principal.PrincipalIteratorAdapter;
import org.apache.jackrabbit.core.security.principal.PrincipalManagerImpl;
import org.apache.jackrabbit.core.security.principal.PrincipalProvider;
import org.apache.jackrabbit.core.security.principal.PrincipalProviderRegistry;
import org.apache.jackrabbit.core.security.principal.ProviderRegistryImpl;
import org.apache.jackrabbit.core.security.simple.SimpleAccessManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleSecurityManager
implements JackrabbitSecurityManager {
    private static Logger log = LoggerFactory.getLogger((Class)SimpleSecurityManager.class);
    private boolean initialized;
    private SecurityConfig config;
    private Session systemSession;
    private PrincipalProviderRegistry principalProviderRegistry;
    private AuthContextProvider authCtxProvider;
    private String adminID;
    private String anonymID;

    public void init(Repository repository, Session systemSession) throws RepositoryException {
        if (this.initialized) {
            throw new IllegalStateException("already initialized");
        }
        if (!(repository instanceof RepositoryImpl)) {
            throw new RepositoryException("RepositoryImpl expected");
        }
        this.systemSession = systemSession;
        this.config = ((RepositoryImpl)repository).getConfig().getSecurityConfig();
        LoginModuleConfig loginModConf = this.config.getLoginModuleConfig();
        this.authCtxProvider = new AuthContextProvider(this.config.getAppName(), loginModConf);
        if (this.authCtxProvider.isJAAS()) {
            log.info("init: using JAAS LoginModule configuration for " + this.config.getAppName());
        } else if (this.authCtxProvider.isLocal()) {
            log.info("init: using Repository LoginModule configuration for " + this.config.getAppName());
        } else {
            String msg = "No valid LoginModule configuriation for " + this.config.getAppName();
            log.error(msg);
            throw new RepositoryException(msg);
        }
        Properties[] moduleConfig = this.authCtxProvider.getModuleConfig();
        for (int i = 0; i < moduleConfig.length; ++i) {
            if (moduleConfig[i].containsKey("adminId")) {
                this.adminID = moduleConfig[i].getProperty("adminId");
            }
            if (!moduleConfig[i].containsKey("anonymousId")) continue;
            this.anonymID = moduleConfig[i].getProperty("anonymousId");
        }
        if (this.adminID == null) {
            log.debug("No adminID defined in LoginModule/JAAS config -> using default.");
            this.adminID = "admin";
        }
        if (this.anonymID == null) {
            log.debug("No anonymousID defined in LoginModule/JAAS config -> using default.");
            this.anonymID = "anonymous";
        }
        SimplePrincipalProvider principalProvider = new SimplePrincipalProvider();
        this.principalProviderRegistry = new ProviderRegistryImpl(principalProvider);
        for (int i = 0; i < moduleConfig.length; ++i) {
            this.principalProviderRegistry.registerProvider(moduleConfig[i]);
        }
        this.initialized = true;
    }

    public void dispose(String workspaceName) {
        this.checkInitialized();
    }

    public void close() {
        this.checkInitialized();
    }

    public AccessManager getAccessManager(Session session, AMContext amContext) throws RepositoryException {
        this.checkInitialized();
        try {
            AccessManagerConfig amc = this.config.getAccessManagerConfig();
            AccessManager accessMgr = amc == null ? new SimpleAccessManager() : (AccessManager)amc.newInstance();
            accessMgr.init(amContext);
            return accessMgr;
        }
        catch (AccessDeniedException ade) {
            throw ade;
        }
        catch (Exception e) {
            String msg = "failed to instantiate AccessManager implementation: " + SimpleAccessManager.class.getName();
            log.error(msg, (Throwable)e);
            throw new RepositoryException(msg, (Throwable)e);
        }
    }

    public synchronized PrincipalManager getPrincipalManager(Session session) throws RepositoryException {
        this.checkInitialized();
        if (session instanceof SessionImpl) {
            SessionImpl sImpl = (SessionImpl)session;
            return new PrincipalManagerImpl(sImpl, this.principalProviderRegistry.getProviders());
        }
        throw new RepositoryException("Internal error: SessionImpl expected.");
    }

    public UserManager getUserManager(Session session) throws RepositoryException {
        this.checkInitialized();
        throw new UnsupportedRepositoryOperationException("UserManager not supported.");
    }

    public String getUserID(Subject subject) throws RepositoryException {
        String uid = null;
        Iterator creds = subject.getPublicCredentials(SimpleCredentials.class).iterator();
        if (creds.hasNext()) {
            SimpleCredentials sc = (SimpleCredentials)creds.next();
            uid = sc.getUserID();
        } else if (this.anonymID != null && !subject.getPrincipals(AnonymousPrincipal.class).isEmpty()) {
            uid = this.anonymID;
        } else {
            Iterator<Principal> it = subject.getPrincipals().iterator();
            while (it.hasNext()) {
                Principal p = it.next();
                if (p instanceof Group) continue;
                uid = p.getName();
                break;
            }
        }
        return uid;
    }

    public AuthContext getAuthContext(Credentials creds, Subject subject) throws RepositoryException {
        this.checkInitialized();
        return this.authCtxProvider.getAuthContext(creds, subject, this.systemSession, this.principalProviderRegistry, this.adminID, this.anonymID);
    }

    private void checkInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("Not initialized");
        }
    }

    private class SimplePrincipalProvider
    implements PrincipalProvider {
        private final Map principals = new HashMap();

        private SimplePrincipalProvider() {
            if (SimpleSecurityManager.this.adminID != null) {
                this.principals.put(SimpleSecurityManager.this.adminID, new AdminPrincipal(SimpleSecurityManager.this.adminID));
            }
            if (SimpleSecurityManager.this.anonymID != null) {
                this.principals.put(SimpleSecurityManager.this.anonymID, new AnonymousPrincipal());
            }
            EveryonePrincipal everyone = EveryonePrincipal.getInstance();
            this.principals.put(everyone.getName(), everyone);
        }

        public Principal getPrincipal(String principalName) {
            if (this.principals.containsKey(principalName)) {
                return (Principal)this.principals.get(principalName);
            }
            return new UserPrincipal(principalName);
        }

        public PrincipalIterator findPrincipals(String simpleFilter) {
            return this.findPrincipals(simpleFilter, 3);
        }

        public PrincipalIterator findPrincipals(String simpleFilter, int searchType) {
            Principal p = this.getPrincipal(simpleFilter);
            if (p == null) {
                return PrincipalIteratorAdapter.EMPTY;
            }
            if (p instanceof Group && searchType == 1 || !(p instanceof Group) && searchType == 2) {
                return PrincipalIteratorAdapter.EMPTY;
            }
            return new PrincipalIteratorAdapter(Collections.singletonList(p));
        }

        public PrincipalIterator getPrincipals(int searchType) {
            PrincipalIteratorAdapter it;
            switch (searchType) {
                case 2: {
                    it = new PrincipalIteratorAdapter(Collections.singletonList(EveryonePrincipal.getInstance()));
                    break;
                }
                case 1: {
                    HashSet set = new HashSet(this.principals.values());
                    set.remove(EveryonePrincipal.getInstance());
                    it = new PrincipalIteratorAdapter(set);
                    break;
                }
                case 3: {
                    it = new PrincipalIteratorAdapter(this.principals.values());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown search type " + searchType);
                }
            }
            return it;
        }

        public PrincipalIterator getGroupMembership(Principal principal) {
            if (principal instanceof EveryonePrincipal) {
                return PrincipalIteratorAdapter.EMPTY;
            }
            return new PrincipalIteratorAdapter(Collections.singletonList(EveryonePrincipal.getInstance()));
        }

        public void init(Properties options) {
        }

        public void close() {
        }

        public boolean canReadPrincipal(Session session, Principal principal) {
            return true;
        }
    }
}

