/*
 * Decompiled with CFR 0.152.
 */
package liquibase.resource;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import liquibase.Scope;
import liquibase.resource.AbstractResourceAccessor;
import liquibase.resource.InputStreamList;
import liquibase.util.CollectionUtil;
import liquibase.util.StringUtil;

public class FileSystemResourceAccessor
extends AbstractResourceAccessor {
    private LinkedHashSet<Path> rootPaths = new LinkedHashSet();

    public FileSystemResourceAccessor(File ... baseDirsAndFiles) {
        for (File base : CollectionUtil.createIfNull(baseDirsAndFiles)) {
            if (!base.exists()) {
                Scope.getCurrentScope().getLog(this.getClass()).warning("Non-existent path: " + base.getAbsolutePath());
                continue;
            }
            if (base.isDirectory()) {
                this.addRootPath(base.toPath());
                continue;
            }
            if (base.getName().endsWith(".jar") || base.getName().toLowerCase().endsWith("zip")) {
                this.addRootPath(base.toPath());
                continue;
            }
            throw new IllegalArgumentException(base.getAbsolutePath() + " must be a directory, jar or zip");
        }
    }

    public FileSystemResourceAccessor(String file) {
        this(new File(file));
    }

    protected void addRootPath(Path path) {
        Scope.getCurrentScope().getLog(this.getClass()).fine("Adding path " + path + " to resourceAccessor " + this.getClass().getName());
        this.rootPaths.add(path);
    }

    protected LinkedHashSet<Path> getRootPaths() {
        return this.rootPaths;
    }

    protected File toFile(String path) {
        for (Path root : this.getRootPaths()) {
            File file = root.resolve(path).toFile();
            if (!file.exists()) continue;
            return file;
        }
        return new File(path);
    }

    @Override
    public InputStreamList openStreams(String relativeTo, String streamPath) throws IOException {
        streamPath = streamPath.replace("\\", "/");
        streamPath = streamPath.replaceFirst("^[\\\\/]([a-zA-Z]:)", "$1");
        InputStreamList streams = new InputStreamList();
        streamPath = streamPath.replaceFirst("^/", "");
        if (relativeTo != null) {
            relativeTo = relativeTo.replace("\\", "/");
            relativeTo = relativeTo.replaceFirst("^[\\\\/]([a-zA-Z]:)", "$1");
            relativeTo = relativeTo.replaceFirst("^/", "");
        }
        for (Path rootPath : this.rootPaths) {
            URI streamURI = null;
            if (rootPath == null) continue;
            FilterInputStream stream = null;
            if (this.isCompressedFile(rootPath)) {
                ZipEntry entry;
                String finalPath = streamPath;
                ZipFile zipFile = new ZipFile(rootPath.toFile());
                if (relativeTo != null) {
                    ZipEntry relativeEntry = zipFile.getEntry(relativeTo);
                    if (relativeEntry == null || relativeEntry.isDirectory()) {
                        finalPath = relativeTo + "/" + streamPath;
                    } else {
                        String actualRelativeTo = relativeTo;
                        actualRelativeTo = actualRelativeTo.contains("/") ? relativeTo.replaceFirst("/[^/]+?$", "") : "";
                        finalPath = actualRelativeTo + "/" + streamPath;
                    }
                }
                if ((entry = zipFile.getEntry(finalPath = Paths.get(finalPath.replaceFirst("^/", ""), new String[0]).normalize().toString().replace("\\", "/"))) != null) {
                    stream = new CloseChildWillCloseParentStream(zipFile.getInputStream(entry), zipFile);
                    streamURI = URI.create(rootPath.normalize().toUri() + "!" + entry.toString());
                } else {
                    zipFile.close();
                }
            } else {
                Path finalRootPath = rootPath;
                if (relativeTo != null) {
                    File rootPathFile = (finalRootPath = finalRootPath.resolve(relativeTo)).toFile();
                    if (rootPathFile.exists()) {
                        if (rootPathFile.isFile()) {
                            finalRootPath = rootPathFile.getParentFile().toPath();
                        }
                    } else {
                        Scope.getCurrentScope().getLog(this.getClass()).fine("No relative path " + relativeTo + " in " + rootPath);
                        continue;
                    }
                }
                try {
                    if (Paths.get(streamPath, new String[0]).startsWith(finalRootPath) || Paths.get(streamPath, new String[0]).startsWith("/" + finalRootPath)) {
                        streamPath = finalRootPath.relativize(Paths.get(streamPath, new String[0])).toString();
                    }
                }
                catch (InvalidPathException rootPathFile) {
                    // empty catch block
                }
                if (Paths.get(streamPath, new String[0]).isAbsolute()) continue;
                File resolvedFile = finalRootPath.resolve(streamPath).toFile();
                if (resolvedFile.exists()) {
                    streamURI = resolvedFile.getCanonicalFile().toURI();
                    stream = new BufferedInputStream(new FileInputStream(resolvedFile));
                }
            }
            if (stream == null) continue;
            if (streamPath.toLowerCase().endsWith(".gz")) {
                stream = new GZIPInputStream(stream);
            }
            streams.add(streamURI, stream);
        }
        return streams;
    }

    @Override
    public SortedSet<String> list(String relativeTo, String path, boolean recursive, final boolean includeFiles, final boolean includeDirectories) throws IOException {
        final TreeSet<String> returnList = new TreeSet<String>();
        int maxDepth = recursive ? Integer.MAX_VALUE : 1;
        for (final Path rootPath : this.getRootPaths()) {
            SimpleFileVisitor<Path> fileVisitor = new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (includeFiles && attrs.isRegularFile()) {
                        this.addToReturnList(file);
                    }
                    if (includeDirectories && attrs.isDirectory()) {
                        this.addToReturnList(file);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    if (includeDirectories) {
                        this.addToReturnList(dir);
                    }
                    return FileVisitResult.CONTINUE;
                }

                protected void addToReturnList(Path file) {
                    String pathToAdd = FileSystemResourceAccessor.this.isCompressedFile(rootPath) ? file.normalize().toString().substring(1) : rootPath.relativize(file).normalize().toString().replace("\\", "/");
                    pathToAdd = pathToAdd.replaceFirst("/$", "");
                    returnList.add(pathToAdd);
                }
            };
            if (this.isCompressedFile(rootPath)) {
                try {
                    FileSystem fs2 = FileSystems.newFileSystem(rootPath, (ClassLoader)null);
                    Throwable throwable = null;
                    try {
                        Path basePath = fs2.getRootDirectories().iterator().next();
                        if (relativeTo != null) {
                            if (!Files.exists(basePath = basePath.resolve(relativeTo), new LinkOption[0])) {
                                Scope.getCurrentScope().getLog(this.getClass()).info("Relative path " + relativeTo + " in " + rootPath + " does not exist");
                                continue;
                            }
                            if (Files.isRegularFile(basePath, new LinkOption[0])) {
                                basePath = basePath.getParent();
                            }
                        }
                        if (path != null) {
                            basePath = basePath.resolve(path);
                        }
                        Files.walkFileTree(basePath, Collections.singleton(FileVisitOption.FOLLOW_LINKS), maxDepth, (FileVisitor<? super Path>)fileVisitor);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (fs2 == null) continue;
                        if (throwable != null) {
                            try {
                                fs2.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        fs2.close();
                    }
                }
                catch (NoSuchFileException fs2) {}
                continue;
            }
            Path basePath = rootPath;
            if (relativeTo != null) {
                if (!Files.exists(basePath = basePath.resolve(relativeTo), new LinkOption[0])) {
                    Scope.getCurrentScope().getLog(this.getClass()).info("Relative path " + relativeTo + " in " + rootPath + " does not exist");
                    continue;
                }
                if (Files.isRegularFile(basePath, new LinkOption[0])) {
                    basePath = basePath.getParent();
                }
            }
            if (path != null) {
                if (path.startsWith("/") || path.startsWith("\\")) {
                    path = path.substring(1);
                }
                basePath = basePath.resolve(path);
            }
            if (!Files.exists(basePath, new LinkOption[0])) continue;
            Files.walkFileTree(basePath, Collections.singleton(FileVisitOption.FOLLOW_LINKS), maxDepth, (FileVisitor<? super Path>)fileVisitor);
        }
        returnList.remove(path);
        return returnList;
    }

    protected boolean isCompressedFile(Path path) {
        return path != null && path.toFile().exists() && (path.toString().startsWith("jar:") || path.toString().toLowerCase().endsWith(".jar") || path.toString().toLowerCase().endsWith(".zip"));
    }

    @Override
    public String toString() {
        return this.getClass().getName() + " (" + StringUtil.join(this.getRootPaths(), ", ", (StringUtil.StringUtilFormatter)new StringUtil.ToStringFormatter()) + ")";
    }

    @Override
    public SortedSet<String> describeLocations() {
        TreeSet<String> returnSet = new TreeSet<String>();
        for (Path path : this.getRootPaths()) {
            returnSet.add(path.toString());
        }
        return returnSet;
    }

    private static class CloseChildWillCloseParentStream
    extends FilterInputStream {
        private final Closeable parent;

        protected CloseChildWillCloseParentStream(InputStream in2, Closeable parent) {
            super(in2);
            this.parent = parent;
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.parent.close();
        }
    }
}

