/*
 * Decompiled with CFR 0.152.
 */
package liquibase;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.UUID;
import javax.xml.parsers.ParserConfigurationException;
import liquibase.CatalogAndSchema;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.RuntimeEnvironment;
import liquibase.Scope;
import liquibase.change.CheckSum;
import liquibase.change.core.RawSQLChange;
import liquibase.changelog.ChangeLogHistoryService;
import liquibase.changelog.ChangeLogHistoryServiceFactory;
import liquibase.changelog.ChangeLogIterator;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.ChangeSetStatus;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.RanChangeSet;
import liquibase.changelog.filter.AfterTagChangeSetFilter;
import liquibase.changelog.filter.AlreadyRanChangeSetFilter;
import liquibase.changelog.filter.ChangeSetFilter;
import liquibase.changelog.filter.ChangeSetFilterResult;
import liquibase.changelog.filter.ContextChangeSetFilter;
import liquibase.changelog.filter.CountChangeSetFilter;
import liquibase.changelog.filter.DbmsChangeSetFilter;
import liquibase.changelog.filter.ExecutedAfterChangeSetFilter;
import liquibase.changelog.filter.IgnoreChangeSetFilter;
import liquibase.changelog.filter.LabelChangeSetFilter;
import liquibase.changelog.filter.NotRanChangeSetFilter;
import liquibase.changelog.filter.ShouldRunChangeSetFilter;
import liquibase.changelog.filter.UpToTagChangeSetFilter;
import liquibase.changelog.visitor.ChangeExecListener;
import liquibase.changelog.visitor.ChangeLogSyncListener;
import liquibase.changelog.visitor.ChangeLogSyncVisitor;
import liquibase.changelog.visitor.ChangeSetVisitor;
import liquibase.changelog.visitor.DBDocVisitor;
import liquibase.changelog.visitor.ExpectedChangesVisitor;
import liquibase.changelog.visitor.ListVisitor;
import liquibase.changelog.visitor.RollbackVisitor;
import liquibase.changelog.visitor.StatusVisitor;
import liquibase.changelog.visitor.UpdateVisitor;
import liquibase.command.CommandExecutionException;
import liquibase.command.CommandFactory;
import liquibase.command.core.DropAllCommand;
import liquibase.configuration.HubConfiguration;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.ObjectQuotingStrategy;
import liquibase.database.core.MSSQLDatabase;
import liquibase.diff.DiffGeneratorFactory;
import liquibase.diff.DiffResult;
import liquibase.diff.compare.CompareControl;
import liquibase.diff.output.changelog.DiffToChangeLog;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.exception.LockException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.executor.LoggingExecutor;
import liquibase.hub.HubService;
import liquibase.hub.HubServiceFactory;
import liquibase.hub.HubUpdater;
import liquibase.hub.LiquibaseHubException;
import liquibase.hub.listener.HubChangeExecListener;
import liquibase.hub.model.Connection;
import liquibase.hub.model.HubChangeLog;
import liquibase.hub.model.Operation;
import liquibase.lockservice.DatabaseChangeLogLock;
import liquibase.lockservice.LockService;
import liquibase.lockservice.LockServiceFactory;
import liquibase.logging.Logger;
import liquibase.logging.core.BufferedLogService;
import liquibase.logging.core.CompositeLogService;
import liquibase.parser.ChangeLogParser;
import liquibase.parser.ChangeLogParserFactory;
import liquibase.resource.InputStreamList;
import liquibase.resource.ResourceAccessor;
import liquibase.serializer.ChangeLogSerializer;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.snapshot.SnapshotControl;
import liquibase.snapshot.SnapshotGeneratorFactory;
import liquibase.statement.core.RawSqlStatement;
import liquibase.statement.core.UpdateStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Catalog;
import liquibase.util.LiquibaseUtil;
import liquibase.util.StreamUtil;
import liquibase.util.StringUtil;

public class Liquibase
implements AutoCloseable {
    private static final Logger LOG = Scope.getCurrentScope().getLog(Liquibase.class);
    protected static final int CHANGESET_ID_NUM_PARTS = 3;
    protected static final int CHANGESET_ID_AUTHOR_PART = 2;
    protected static final int CHANGESET_ID_CHANGESET_PART = 1;
    protected static final int CHANGESET_ID_CHANGELOG_PART = 0;
    private static final ResourceBundle coreBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-core");
    public static final String MSG_COULD_NOT_RELEASE_LOCK = coreBundle.getString("could.not.release.lock");
    protected Database database;
    private DatabaseChangeLog databaseChangeLog;
    private String changeLogFile;
    private final ResourceAccessor resourceAccessor;
    private final ChangeLogParameters changeLogParameters;
    private ChangeExecListener changeExecListener;
    private ChangeLogSyncListener changeLogSyncListener;
    private UUID hubConnectionId;

    public Liquibase(String changeLogFile, ResourceAccessor resourceAccessor, DatabaseConnection conn) throws LiquibaseException {
        this(changeLogFile, resourceAccessor, DatabaseFactory.getInstance().findCorrectDatabaseImplementation(conn));
    }

    public Liquibase(String changeLogFile, ResourceAccessor resourceAccessor, Database database) {
        if (changeLogFile != null) {
            this.changeLogFile = changeLogFile.replace('\\', '/');
        }
        this.resourceAccessor = resourceAccessor;
        this.changeLogParameters = new ChangeLogParameters(database);
        this.database = database;
    }

    public Liquibase(DatabaseChangeLog changeLog, ResourceAccessor resourceAccessor, Database database) {
        this.databaseChangeLog = changeLog;
        if (changeLog != null) {
            this.changeLogFile = changeLog.getPhysicalFilePath();
        }
        if (this.changeLogFile != null) {
            this.changeLogFile = this.changeLogFile.replace('\\', '/');
        }
        this.resourceAccessor = resourceAccessor;
        this.database = database;
        this.changeLogParameters = new ChangeLogParameters(database);
    }

    public UUID getHubConnectionId() {
        return this.hubConnectionId;
    }

    public void setHubConnectionId(UUID hubConnectionId) {
        this.hubConnectionId = hubConnectionId;
    }

    public String getChangeLogFile() {
        return this.changeLogFile;
    }

    public Logger getLog() {
        return LOG;
    }

    public ChangeLogParameters getChangeLogParameters() {
        return this.changeLogParameters;
    }

    public Database getDatabase() {
        return this.database;
    }

    public ResourceAccessor getResourceAccessor() {
        return this.resourceAccessor;
    }

    public void update(String contexts) throws LiquibaseException {
        this.update(new Contexts(contexts));
    }

    public void update(Contexts contexts) throws LiquibaseException {
        this.update(contexts, new LabelExpression());
    }

    public void update(Contexts contexts, LabelExpression labelExpression) throws LiquibaseException {
        this.update(contexts, labelExpression, true);
    }

    public void update(Contexts contexts, LabelExpression labelExpression, boolean checkLiquibaseTables) throws LiquibaseException {
        this.runInScope(() -> {
            LockService lockService = LockServiceFactory.getInstance().getLockService(this.database);
            lockService.waitForLock();
            this.changeLogParameters.setContexts(contexts);
            this.changeLogParameters.setLabels(labelExpression);
            Operation updateOperation = null;
            BufferedLogService bufferLog = new BufferedLogService();
            DatabaseChangeLog changeLog = null;
            HubUpdater hubUpdater = null;
            try {
                changeLog = this.getDatabaseChangeLog();
                if (checkLiquibaseTables) {
                    this.checkLiquibaseTables(true, changeLog, contexts, labelExpression);
                }
                ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(this.database).generateDeploymentId();
                changeLog.validate(this.database, contexts, labelExpression);
                hubUpdater = new HubUpdater(new Date(), changeLog, this.database);
                hubUpdater.register(this.changeLogFile);
                ChangeLogIterator changeLogIterator = this.getStandardChangelogIterator(contexts, labelExpression, changeLog);
                Executor executor = Scope.getCurrentScope().getSingleton(ExecutorService.class).getExecutor("jdbc", this.database);
                Connection connection = this.getConnection(changeLog);
                if (connection != null) {
                    updateOperation = hubUpdater.preUpdateHub("UPDATE", this.database, connection, this.changeLogFile, contexts, labelExpression, changeLogIterator);
                }
                if (connection != null) {
                    this.changeExecListener = new HubChangeExecListener(updateOperation, this.changeExecListener);
                }
                ChangeLogIterator runChangeLogIterator = this.getStandardChangelogIterator(contexts, labelExpression, changeLog);
                CompositeLogService compositeLogService = new CompositeLogService(true, bufferLog);
                Scope.child(Scope.Attr.logService.name(), (Object)compositeLogService, () -> runChangeLogIterator.run(this.createUpdateVisitor(), new RuntimeEnvironment(this.database, contexts, labelExpression)));
                hubUpdater.postUpdateHub(updateOperation, bufferLog);
            }
            catch (Throwable e2) {
                if (hubUpdater != null) {
                    hubUpdater.postUpdateHubExceptionHandling(updateOperation, bufferLog, e2.getMessage());
                }
                throw e2;
            }
            finally {
                this.database.setObjectQuotingStrategy(ObjectQuotingStrategy.LEGACY);
                try {
                    lockService.releaseLock();
                }
                catch (LockException e3) {
                    LOG.severe(MSG_COULD_NOT_RELEASE_LOCK, e3);
                }
                this.resetServices();
                this.setChangeExecListener(null);
            }
        });
    }

    public Connection getConnection(DatabaseChangeLog changeLog) throws LiquibaseHubException {
        Connection connection;
        Executor executor = Scope.getCurrentScope().getSingleton(ExecutorService.class).getExecutor("jdbc", this.database);
        if (executor instanceof LoggingExecutor) {
            return null;
        }
        HubConfiguration hubConfiguration = LiquibaseConfiguration.getInstance().getConfiguration(HubConfiguration.class);
        HubUpdater hubUpdater = new HubUpdater(new Date(), changeLog, this.database);
        String changeLogId = changeLog.getChangeLogId();
        if (hubUpdater.hubIsNotAvailable(changeLogId)) {
            if (StringUtil.isNotEmpty(hubConfiguration.getLiquibaseHubApiKey()) && changeLogId == null) {
                String message = "The API key '" + hubConfiguration.getLiquibaseHubApiKey() + "' was found, but no changelog ID exists.\nNo operations will be reported. Register this changelog with Liquibase Hub to generate free deployment reports.\nLearn more at https://hub.liquibase.com.";
                Scope.getCurrentScope().getUI().sendMessage("WARNING: " + message);
                Scope.getCurrentScope().getLog(this.getClass()).warning(message);
            }
            return null;
        }
        if (StringUtil.isEmpty(hubConfiguration.getLiquibaseHubApiKey()) && changeLogId != null) {
            String message = "The changelog ID '" + changeLogId + "' was found, but no API Key exists.\nNo operations will be reported. Simply add a liquibase.hub.apiKey setting to generate free deployment reports.\nLearn more at https://hub.liquibase.com.";
            Scope.getCurrentScope().getUI().sendMessage("WARNING: " + message);
            Scope.getCurrentScope().getLog(this.getClass()).warning(message);
            return null;
        }
        HubService hubService = Scope.getCurrentScope().getSingleton(HubServiceFactory.class).getService();
        if (this.getHubConnectionId() == null) {
            HubChangeLog hubChangeLog = hubService.getHubChangeLog(UUID.fromString(changeLogId));
            if (hubChangeLog == null) {
                Scope.getCurrentScope().getLog(this.getClass()).warning("Retrieving Hub Change Log failed for Changelog ID: " + changeLogId);
                return null;
            }
            Connection exampleConnection = new Connection();
            exampleConnection.setProject(hubChangeLog.getProject());
            exampleConnection.setJdbcUrl(this.database.getConnection().getURL());
            connection = hubService.getConnection(exampleConnection, true);
            this.setHubConnectionId(connection.getId());
        } else {
            connection = hubService.getConnection(new Connection().setId(this.getHubConnectionId()), true);
        }
        return connection;
    }

    public DatabaseChangeLog getDatabaseChangeLog() throws LiquibaseException {
        if (this.databaseChangeLog == null && this.changeLogFile != null) {
            ChangeLogParser parser = ChangeLogParserFactory.getInstance().getParser(this.changeLogFile, this.resourceAccessor);
            this.databaseChangeLog = parser.parse(this.changeLogFile, this.changeLogParameters, this.resourceAccessor);
        }
        return this.databaseChangeLog;
    }

    protected UpdateVisitor createUpdateVisitor() {
        return new UpdateVisitor(this.database, this.changeExecListener);
    }

    protected RollbackVisitor createRollbackVisitor() {
        return new RollbackVisitor(this.database, this.changeExecListener);
    }

    protected ChangeLogIterator getStandardChangelogIterator(Contexts contexts, LabelExpression labelExpression, DatabaseChangeLog changeLog) throws DatabaseException {
        return new ChangeLogIterator(changeLog, new ShouldRunChangeSetFilter(this.database), new ContextChangeSetFilter(contexts), new LabelChangeSetFilter(labelExpression), new DbmsChangeSetFilter(this.database), new IgnoreChangeSetFilter());
    }

    public void update(String contexts, Writer output) throws LiquibaseException {
        this.update(new Contexts(contexts), output);
    }

    public void update(Contexts contexts, Writer output) throws LiquibaseException {
        this.update(contexts, new LabelExpression(), output);
    }

    public void update(Contexts contexts, LabelExpression labelExpression, Writer output) throws LiquibaseException {
        this.update(contexts, labelExpression, output, true);
    }

    public void update(final Contexts contexts, final LabelExpression labelExpression, final Writer output, final boolean checkLiquibaseTables) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        this.changeLogParameters.setLabels(labelExpression);
        this.runInScope(new Scope.ScopedRunner(){

            @Override
            public void run() throws Exception {
                Executor oldTemplate = Liquibase.this.getAndReplaceJdbcExecutor(output);
                Liquibase.this.outputHeader("Update Database Script");
                LockService lockService = LockServiceFactory.getInstance().getLockService(Liquibase.this.database);
                lockService.waitForLock();
                Liquibase.this.update(contexts, labelExpression, checkLiquibaseTables);
                Liquibase.this.flushOutputWriter(output);
                Scope.getCurrentScope().getSingleton(ExecutorService.class).setExecutor("jdbc", Liquibase.this.database, oldTemplate);
            }
        });
    }

    public void update(int changesToApply, String contexts) throws LiquibaseException {
        this.update(changesToApply, new Contexts(contexts), new LabelExpression());
    }

    public void update(final int changesToApply, final Contexts contexts, final LabelExpression labelExpression) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        this.changeLogParameters.setLabels(labelExpression);
        this.runInScope(new Scope.ScopedRunner(){

            @Override
            public void run() throws Exception {
                LockService lockService = LockServiceFactory.getInstance().getLockService(Liquibase.this.database);
                lockService.waitForLock();
                Operation updateOperation = null;
                BufferedLogService bufferLog = new BufferedLogService();
                DatabaseChangeLog changeLog = null;
                HubUpdater hubUpdater = null;
                try {
                    changeLog = Liquibase.this.getDatabaseChangeLog();
                    Liquibase.this.checkLiquibaseTables(true, changeLog, contexts, labelExpression);
                    ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(Liquibase.this.database).generateDeploymentId();
                    changeLog.validate(Liquibase.this.database, contexts, labelExpression);
                    hubUpdater = new HubUpdater(new Date(), changeLog, Liquibase.this.database);
                    hubUpdater.register(Liquibase.this.changeLogFile);
                    ChangeLogIterator listLogIterator = new ChangeLogIterator(changeLog, new ShouldRunChangeSetFilter(Liquibase.this.database), new ContextChangeSetFilter(contexts), new LabelChangeSetFilter(labelExpression), new DbmsChangeSetFilter(Liquibase.this.database), new IgnoreChangeSetFilter(), new CountChangeSetFilter(changesToApply));
                    Connection connection = Liquibase.this.getConnection(changeLog);
                    if (connection != null) {
                        updateOperation = hubUpdater.preUpdateHub("UPDATE", Liquibase.this.database, connection, Liquibase.this.changeLogFile, contexts, labelExpression, listLogIterator);
                    }
                    if (connection != null) {
                        Liquibase.this.changeExecListener = new HubChangeExecListener(updateOperation, Liquibase.this.changeExecListener);
                    }
                    ChangeLogIterator runChangeLogIterator = new ChangeLogIterator(changeLog, new ShouldRunChangeSetFilter(Liquibase.this.database), new ContextChangeSetFilter(contexts), new LabelChangeSetFilter(labelExpression), new DbmsChangeSetFilter(Liquibase.this.database), new IgnoreChangeSetFilter(), new CountChangeSetFilter(changesToApply));
                    CompositeLogService compositeLogService = new CompositeLogService(true, bufferLog);
                    Scope.child(Scope.Attr.logService.name(), (Object)compositeLogService, () -> runChangeLogIterator.run(Liquibase.this.createUpdateVisitor(), new RuntimeEnvironment(Liquibase.this.database, contexts, labelExpression)));
                    hubUpdater.postUpdateHub(updateOperation, bufferLog);
                }
                catch (Throwable e2) {
                    if (hubUpdater != null) {
                        hubUpdater.postUpdateHubExceptionHandling(updateOperation, bufferLog, e2.getMessage());
                    }
                    throw e2;
                }
                finally {
                    Liquibase.this.database.setObjectQuotingStrategy(ObjectQuotingStrategy.LEGACY);
                    try {
                        lockService.releaseLock();
                    }
                    catch (LockException e3) {
                        LOG.severe(MSG_COULD_NOT_RELEASE_LOCK, e3);
                    }
                    Liquibase.this.resetServices();
                    Liquibase.this.setChangeExecListener(null);
                }
            }
        });
    }

    public void update(String tag, String contexts) throws LiquibaseException {
        this.update(tag, new Contexts(contexts), new LabelExpression());
    }

    public void update(String tag, Contexts contexts) throws LiquibaseException {
        this.update(tag, contexts, new LabelExpression());
    }

    public void update(final String tag, final Contexts contexts, final LabelExpression labelExpression) throws LiquibaseException {
        if (tag == null) {
            this.update(contexts, labelExpression);
            return;
        }
        this.changeLogParameters.setContexts(contexts);
        this.changeLogParameters.setLabels(labelExpression);
        this.runInScope(new Scope.ScopedRunner(){

            @Override
            public void run() throws Exception {
                LockService lockService = LockServiceFactory.getInstance().getLockService(Liquibase.this.database);
                lockService.waitForLock();
                HubUpdater hubUpdater = null;
                Operation updateOperation = null;
                BufferedLogService bufferLog = new BufferedLogService();
                DatabaseChangeLog changeLog = null;
                try {
                    changeLog = Liquibase.this.getDatabaseChangeLog();
                    Liquibase.this.checkLiquibaseTables(true, changeLog, contexts, labelExpression);
                    ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(Liquibase.this.database).generateDeploymentId();
                    changeLog.validate(Liquibase.this.database, contexts, labelExpression);
                    hubUpdater = new HubUpdater(new Date(), changeLog, Liquibase.this.database);
                    hubUpdater.register(Liquibase.this.changeLogFile);
                    List<RanChangeSet> ranChangeSetList = Liquibase.this.database.getRanChangeSetList();
                    ChangeLogIterator listLogIterator = new ChangeLogIterator(changeLog, new ShouldRunChangeSetFilter(Liquibase.this.database), new ContextChangeSetFilter(contexts), new LabelChangeSetFilter(labelExpression), new DbmsChangeSetFilter(Liquibase.this.database), new IgnoreChangeSetFilter(), new UpToTagChangeSetFilter(tag, ranChangeSetList));
                    Connection connection = Liquibase.this.getConnection(changeLog);
                    if (connection != null) {
                        updateOperation = hubUpdater.preUpdateHub("UPDATE", Liquibase.this.database, connection, Liquibase.this.changeLogFile, contexts, labelExpression, listLogIterator);
                    }
                    if (connection != null) {
                        Liquibase.this.changeExecListener = new HubChangeExecListener(updateOperation, Liquibase.this.changeExecListener);
                    }
                    ChangeLogIterator runChangeLogIterator = new ChangeLogIterator(changeLog, new ShouldRunChangeSetFilter(Liquibase.this.database), new ContextChangeSetFilter(contexts), new LabelChangeSetFilter(labelExpression), new DbmsChangeSetFilter(Liquibase.this.database), new IgnoreChangeSetFilter(), new UpToTagChangeSetFilter(tag, ranChangeSetList));
                    CompositeLogService compositeLogService = new CompositeLogService(true, bufferLog);
                    Scope.child(Scope.Attr.logService.name(), (Object)compositeLogService, () -> runChangeLogIterator.run(Liquibase.this.createUpdateVisitor(), new RuntimeEnvironment(Liquibase.this.database, contexts, labelExpression)));
                    hubUpdater.postUpdateHub(updateOperation, bufferLog);
                }
                catch (Throwable e2) {
                    if (hubUpdater != null) {
                        hubUpdater.postUpdateHubExceptionHandling(updateOperation, bufferLog, e2.getMessage());
                    }
                    throw e2;
                }
                finally {
                    Liquibase.this.database.setObjectQuotingStrategy(ObjectQuotingStrategy.LEGACY);
                    try {
                        lockService.releaseLock();
                    }
                    catch (LockException e3) {
                        LOG.severe(MSG_COULD_NOT_RELEASE_LOCK, e3);
                    }
                    Liquibase.this.resetServices();
                    Liquibase.this.setChangeExecListener(null);
                }
            }
        });
    }

    public void update(int changesToApply, String contexts, Writer output) throws LiquibaseException {
        this.update(changesToApply, new Contexts(contexts), new LabelExpression(), output);
    }

    public void update(final int changesToApply, final Contexts contexts, final LabelExpression labelExpression, final Writer output) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        this.changeLogParameters.setLabels(labelExpression);
        this.runInScope(new Scope.ScopedRunner(){

            @Override
            public void run() throws Exception {
                Executor oldTemplate = Liquibase.this.getAndReplaceJdbcExecutor(output);
                Liquibase.this.outputHeader("Update " + changesToApply + " Change Sets Database Script");
                Liquibase.this.update(changesToApply, contexts, labelExpression);
                Liquibase.this.flushOutputWriter(output);
                Liquibase.this.resetServices();
                Scope.getCurrentScope().getSingleton(ExecutorService.class).setExecutor("jdbc", Liquibase.this.database, oldTemplate);
            }
        });
    }

    public void update(String tag, String contexts, Writer output) throws LiquibaseException {
        this.update(tag, new Contexts(contexts), new LabelExpression(), output);
    }

    public void update(String tag, Contexts contexts, Writer output) throws LiquibaseException {
        this.update(tag, contexts, new LabelExpression(), output);
    }

    public void update(final String tag, final Contexts contexts, final LabelExpression labelExpression, final Writer output) throws LiquibaseException {
        if (tag == null) {
            this.update(contexts, labelExpression, output);
            return;
        }
        this.changeLogParameters.setContexts(contexts);
        this.changeLogParameters.setLabels(labelExpression);
        this.runInScope(new Scope.ScopedRunner(){

            @Override
            public void run() throws Exception {
                Executor oldTemplate = Liquibase.this.getAndReplaceJdbcExecutor(output);
                Liquibase.this.outputHeader("Update to '" + tag + "' Database Script");
                Liquibase.this.update(tag, contexts, labelExpression);
                Liquibase.this.flushOutputWriter(output);
                Liquibase.this.resetServices();
                Scope.getCurrentScope().getSingleton(ExecutorService.class).setExecutor("jdbc", Liquibase.this.database, oldTemplate);
            }
        });
    }

    public void outputHeader(String message) throws DatabaseException {
        Executor executor = Scope.getCurrentScope().getSingleton(ExecutorService.class).getExecutor("logging", this.database);
        executor.comment("*********************************************************************");
        executor.comment(message);
        executor.comment("*********************************************************************");
        executor.comment("Change Log: " + this.changeLogFile);
        executor.comment("Ran at: " + DateFormat.getDateTimeInstance(3, 3).format(new Date()));
        DatabaseConnection connection = this.getDatabase().getConnection();
        if (connection != null) {
            executor.comment("Against: " + connection.getConnectionUserName() + "@" + connection.getURL());
        }
        executor.comment("Liquibase version: " + LiquibaseUtil.getBuildVersion());
        executor.comment("*********************************************************************" + StreamUtil.getLineSeparator());
        if (this.database instanceof MSSQLDatabase && this.database.getDefaultCatalogName() != null) {
            executor.execute(new RawSqlStatement("USE " + this.database.escapeObjectName(this.database.getDefaultCatalogName(), Catalog.class) + ";"));
        }
    }

    public void rollback(int changesToRollback, String contexts, Writer output) throws LiquibaseException {
        this.rollback(changesToRollback, null, contexts, output);
    }

    public void rollback(int changesToRollback, Contexts contexts, Writer output) throws LiquibaseException {
        this.rollback(changesToRollback, null, contexts, output);
    }

    public void rollback(int changesToRollback, Contexts contexts, LabelExpression labelExpression, Writer output) throws LiquibaseException {
        this.rollback(changesToRollback, null, contexts, labelExpression, output);
    }

    public void rollback(int changesToRollback, String rollbackScript, String contexts, Writer output) throws LiquibaseException {
        this.rollback(changesToRollback, rollbackScript, new Contexts(contexts), output);
    }

    public void rollback(int changesToRollback, String rollbackScript, Contexts contexts, Writer output) throws LiquibaseException {
        this.rollback(changesToRollback, rollbackScript, contexts, new LabelExpression(), output);
    }

    public void rollback(final int changesToRollback, final String rollbackScript, final Contexts contexts, final LabelExpression labelExpression, final Writer output) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        this.changeLogParameters.setLabels(labelExpression);
        this.runInScope(new Scope.ScopedRunner(){

            @Override
            public void run() throws Exception {
                Executor oldTemplate = Liquibase.this.getAndReplaceJdbcExecutor(output);
                Liquibase.this.outputHeader("Rollback " + changesToRollback + " Change(s) Script");
                Liquibase.this.rollback(changesToRollback, rollbackScript, contexts, labelExpression);
                Liquibase.this.flushOutputWriter(output);
                Scope.getCurrentScope().getSingleton(ExecutorService.class).setExecutor("jdbc", Liquibase.this.database, oldTemplate);
                Liquibase.this.resetServices();
            }
        });
    }

    public void rollback(int changesToRollback, String contexts) throws LiquibaseException {
        this.rollback(changesToRollback, null, contexts);
    }

    public void rollback(int changesToRollback, Contexts contexts, LabelExpression labelExpression) throws LiquibaseException {
        this.rollback(changesToRollback, null, contexts, labelExpression);
    }

    public void rollback(int changesToRollback, String rollbackScript, String contexts) throws LiquibaseException {
        this.rollback(changesToRollback, rollbackScript, new Contexts(contexts), new LabelExpression());
    }

    public void rollback(final int changesToRollback, final String rollbackScript, final Contexts contexts, final LabelExpression labelExpression) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        this.changeLogParameters.setLabels(labelExpression);
        this.runInScope(new Scope.ScopedRunner(){

            @Override
            public void run() throws Exception {
                LockService lockService = LockServiceFactory.getInstance().getLockService(Liquibase.this.database);
                lockService.waitForLock();
                Operation rollbackOperation = null;
                BufferedLogService bufferLog = new BufferedLogService();
                DatabaseChangeLog changeLog = null;
                Date startTime = new Date();
                HubUpdater hubUpdater = null;
                try {
                    changeLog = Liquibase.this.getDatabaseChangeLog();
                    Liquibase.this.checkLiquibaseTables(false, changeLog, contexts, labelExpression);
                    changeLog.validate(Liquibase.this.database, contexts, labelExpression);
                    hubUpdater = new HubUpdater(startTime, changeLog, Liquibase.this.database);
                    hubUpdater.register(Liquibase.this.changeLogFile);
                    ChangeLogIterator listLogIterator = new ChangeLogIterator(Liquibase.this.database.getRanChangeSetList(), changeLog, new AlreadyRanChangeSetFilter(Liquibase.this.database.getRanChangeSetList()), new ContextChangeSetFilter(contexts), new LabelChangeSetFilter(labelExpression), new DbmsChangeSetFilter(Liquibase.this.database), new IgnoreChangeSetFilter(), new CountChangeSetFilter(changesToRollback));
                    Connection connection = Liquibase.this.getConnection(changeLog);
                    if (connection != null) {
                        rollbackOperation = hubUpdater.preUpdateHub("ROLLBACK", Liquibase.this.database, connection, Liquibase.this.changeLogFile, contexts, labelExpression, listLogIterator);
                    }
                    if (connection != null) {
                        Liquibase.this.changeExecListener = new HubChangeExecListener(rollbackOperation, Liquibase.this.changeExecListener);
                    }
                    ChangeLogIterator logIterator = new ChangeLogIterator(Liquibase.this.database.getRanChangeSetList(), changeLog, new AlreadyRanChangeSetFilter(Liquibase.this.database.getRanChangeSetList()), new ContextChangeSetFilter(contexts), new LabelChangeSetFilter(labelExpression), new DbmsChangeSetFilter(Liquibase.this.database), new IgnoreChangeSetFilter(), new CountChangeSetFilter(changesToRollback));
                    CompositeLogService compositeLogService = new CompositeLogService(true, bufferLog);
                    if (rollbackScript == null) {
                        Scope.child(Scope.Attr.logService.name(), (Object)compositeLogService, () -> logIterator.run(Liquibase.this.createRollbackVisitor(), new RuntimeEnvironment(Liquibase.this.database, contexts, labelExpression)));
                    } else {
                        List changeSets = Liquibase.this.determineRollbacks(logIterator, contexts, labelExpression);
                        HashMap<String, Object> values = new HashMap<String, Object>();
                        values.put(Scope.Attr.logService.name(), compositeLogService);
                        values.put(BufferedLogService.class.getName(), bufferLog);
                        Scope.child(values, () -> Liquibase.this.executeRollbackScript(rollbackScript, changeSets, contexts, labelExpression));
                        Liquibase.this.removeRunStatus(changeSets, contexts, labelExpression);
                    }
                    hubUpdater.postUpdateHub(rollbackOperation, bufferLog);
                }
                catch (Throwable t2) {
                    if (hubUpdater != null) {
                        hubUpdater.postUpdateHubExceptionHandling(rollbackOperation, bufferLog, t2.getMessage());
                    }
                    throw t2;
                }
                finally {
                    try {
                        lockService.releaseLock();
                    }
                    catch (LockException e2) {
                        LOG.severe("Error releasing lock", e2);
                    }
                    Liquibase.this.resetServices();
                    Liquibase.this.setChangeExecListener(null);
                }
            }
        });
    }

    private List<ChangeSet> determineRollbacks(ChangeLogIterator logIterator, Contexts contexts, LabelExpression labelExpression) throws LiquibaseException {
        final ArrayList<ChangeSet> changeSetsToRollback = new ArrayList<ChangeSet>();
        logIterator.run(new ChangeSetVisitor(){

            @Override
            public ChangeSetVisitor.Direction getDirection() {
                return ChangeSetVisitor.Direction.REVERSE;
            }

            @Override
            public void visit(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database, Set<ChangeSetFilterResult> filterResults) throws LiquibaseException {
                changeSetsToRollback.add(changeSet);
            }
        }, new RuntimeEnvironment(this.database, contexts, labelExpression));
        return changeSetsToRollback;
    }

    protected void removeRunStatus(List<ChangeSet> changeSets, Contexts contexts, LabelExpression labelExpression) throws LiquibaseException {
        for (ChangeSet changeSet : changeSets) {
            this.database.removeRanStatus(changeSet);
            this.database.commit();
        }
    }

    protected void executeRollbackScript(String rollbackScript, List<ChangeSet> changeSets, Contexts contexts, LabelExpression labelExpression) throws LiquibaseException {
        String rollbackScriptContents;
        Executor executor = Scope.getCurrentScope().getSingleton(ExecutorService.class).getExecutor("jdbc", this.database);
        try (InputStreamList streams = this.resourceAccessor.openStreams(null, rollbackScript);){
            if (streams == null || streams.isEmpty()) {
                throw new LiquibaseException("WARNING: The rollback script '" + rollbackScript + "' was not located.  Please check your parameters. No rollback was performed");
            }
            if (streams.size() > 1) {
                throw new LiquibaseException("Found multiple rollbackScripts named " + rollbackScript);
            }
            rollbackScriptContents = StreamUtil.readStreamAsString(streams.iterator().next());
        }
        catch (IOException e2) {
            throw new LiquibaseException("Error reading rollbackScript " + executor + ": " + e2.getMessage());
        }
        this.changeLogParameters.setContexts(contexts);
        this.changeLogParameters.setLabels(labelExpression);
        DatabaseChangeLog changelog = this.getDatabaseChangeLog();
        rollbackScriptContents = this.changeLogParameters.expandExpressions(rollbackScriptContents, changelog);
        RawSQLChange rollbackChange = this.buildRawSQLChange(rollbackScriptContents);
        try {
            ((HubChangeExecListener)this.changeExecListener).setRollbackScriptContents(rollbackScriptContents);
            this.sendRollbackMessages(changeSets, changelog, RollbackMessageType.WILL_ROLLBACK, contexts, labelExpression, null);
            executor.execute(rollbackChange);
            this.sendRollbackMessages(changeSets, changelog, RollbackMessageType.ROLLED_BACK, contexts, labelExpression, null);
        }
        catch (DatabaseException e3) {
            Scope.getCurrentScope().getLog(this.getClass()).warning(e3.getMessage());
            LOG.severe("Error executing rollback script: " + e3.getMessage());
            if (this.changeExecListener != null) {
                this.sendRollbackMessages(changeSets, changelog, RollbackMessageType.ROLLBACK_FAILED, contexts, labelExpression, e3);
            }
            throw new DatabaseException("Error executing rollback script", e3);
        }
        this.database.commit();
    }

    private void sendRollbackMessages(List<ChangeSet> changeSets, DatabaseChangeLog changelog, RollbackMessageType messageType, Contexts contexts, LabelExpression labelExpression, Exception exception) throws LiquibaseException {
        for (ChangeSet changeSet : changeSets) {
            String message;
            if (messageType == RollbackMessageType.WILL_ROLLBACK) {
                this.changeExecListener.willRollback(changeSet, this.databaseChangeLog, this.database);
                continue;
            }
            if (messageType == RollbackMessageType.ROLLED_BACK) {
                message = "Rolled Back Changeset:" + changeSet.toString(false);
                Scope.getCurrentScope().getUI().sendMessage(message);
                LOG.info(message);
                this.changeExecListener.rolledBack(changeSet, this.databaseChangeLog, this.database);
                continue;
            }
            if (messageType != RollbackMessageType.ROLLBACK_FAILED) continue;
            message = "Failed rolling back Changeset:" + changeSet.toString(false);
            Scope.getCurrentScope().getUI().sendMessage(message);
            this.changeExecListener.rollbackFailed(changeSet, this.databaseChangeLog, this.database, exception);
        }
    }

    protected RawSQLChange buildRawSQLChange(String rollbackScriptContents) {
        RawSQLChange rollbackChange = new RawSQLChange(rollbackScriptContents);
        rollbackChange.setSplitStatements(true);
        rollbackChange.setStripComments(true);
        return rollbackChange;
    }

    public void rollback(String tagToRollBackTo, String contexts, Writer output) throws LiquibaseException {
        this.rollback(tagToRollBackTo, null, contexts, output);
    }

    public void rollback(String tagToRollBackTo, Contexts contexts, Writer output) throws LiquibaseException {
        this.rollback(tagToRollBackTo, null, contexts, output);
    }

    public void rollback(String tagToRollBackTo, Contexts contexts, LabelExpression labelExpression, Writer output) throws LiquibaseException {
        this.rollback(tagToRollBackTo, null, contexts, labelExpression, output);
    }

    public void rollback(String tagToRollBackTo, String rollbackScript, String contexts, Writer output) throws LiquibaseException {
        this.rollback(tagToRollBackTo, rollbackScript, new Contexts(contexts), output);
    }

    public void rollback(String tagToRollBackTo, String rollbackScript, Contexts contexts, Writer output) throws LiquibaseException {
        this.rollback(tagToRollBackTo, rollbackScript, contexts, new LabelExpression(), output);
    }

    public void rollback(String tagToRollBackTo, String rollbackScript, Contexts contexts, LabelExpression labelExpression, Writer output) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        this.changeLogParameters.setLabels(labelExpression);
        Executor oldTemplate = this.getAndReplaceJdbcExecutor(output);
        this.outputHeader("Rollback to '" + tagToRollBackTo + "' Script");
        this.rollback(tagToRollBackTo, contexts, labelExpression);
        this.flushOutputWriter(output);
        Scope.getCurrentScope().getSingleton(ExecutorService.class).setExecutor("jdbc", this.database, oldTemplate);
        this.resetServices();
    }

    public void rollback(String tagToRollBackTo, String contexts) throws LiquibaseException {
        this.rollback(tagToRollBackTo, null, contexts);
    }

    public void rollback(String tagToRollBackTo, Contexts contexts) throws LiquibaseException {
        this.rollback(tagToRollBackTo, null, contexts);
    }

    public void rollback(String tagToRollBackTo, Contexts contexts, LabelExpression labelExpression) throws LiquibaseException {
        this.rollback(tagToRollBackTo, null, contexts, labelExpression);
    }

    public void rollback(String tagToRollBackTo, String rollbackScript, String contexts) throws LiquibaseException {
        this.rollback(tagToRollBackTo, rollbackScript, new Contexts(contexts));
    }

    public void rollback(String tagToRollBackTo, String rollbackScript, Contexts contexts) throws LiquibaseException {
        this.rollback(tagToRollBackTo, rollbackScript, contexts, new LabelExpression());
    }

    public void rollback(final String tagToRollBackTo, final String rollbackScript, final Contexts contexts, final LabelExpression labelExpression) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        this.changeLogParameters.setLabels(labelExpression);
        this.runInScope(new Scope.ScopedRunner(){

            @Override
            public void run() throws Exception {
                LockService lockService = LockServiceFactory.getInstance().getLockService(Liquibase.this.database);
                lockService.waitForLock();
                Operation rollbackOperation = null;
                BufferedLogService bufferLog = new BufferedLogService();
                DatabaseChangeLog changeLog = null;
                Date startTime = new Date();
                HubUpdater hubUpdater = null;
                try {
                    changeLog = Liquibase.this.getDatabaseChangeLog();
                    Liquibase.this.checkLiquibaseTables(false, changeLog, contexts, labelExpression);
                    changeLog.validate(Liquibase.this.database, contexts, labelExpression);
                    hubUpdater = new HubUpdater(startTime, changeLog, Liquibase.this.database);
                    hubUpdater.register(Liquibase.this.changeLogFile);
                    List<RanChangeSet> ranChangeSetList = Liquibase.this.database.getRanChangeSetList();
                    ChangeLogIterator listLogIterator = new ChangeLogIterator(ranChangeSetList, changeLog, new AfterTagChangeSetFilter(tagToRollBackTo, ranChangeSetList), new AlreadyRanChangeSetFilter(ranChangeSetList), new ContextChangeSetFilter(contexts), new LabelChangeSetFilter(labelExpression), new IgnoreChangeSetFilter(), new DbmsChangeSetFilter(Liquibase.this.database));
                    Connection connection = Liquibase.this.getConnection(changeLog);
                    if (connection != null) {
                        rollbackOperation = hubUpdater.preUpdateHub("ROLLBACK", Liquibase.this.database, connection, Liquibase.this.changeLogFile, contexts, labelExpression, listLogIterator);
                    }
                    if (connection != null) {
                        Liquibase.this.changeExecListener = new HubChangeExecListener(rollbackOperation, Liquibase.this.changeExecListener);
                    }
                    ChangeLogIterator logIterator = new ChangeLogIterator(ranChangeSetList, changeLog, new AfterTagChangeSetFilter(tagToRollBackTo, ranChangeSetList), new AlreadyRanChangeSetFilter(ranChangeSetList), new ContextChangeSetFilter(contexts), new LabelChangeSetFilter(labelExpression), new IgnoreChangeSetFilter(), new DbmsChangeSetFilter(Liquibase.this.database));
                    CompositeLogService compositeLogService = new CompositeLogService(true, bufferLog);
                    if (rollbackScript == null) {
                        Scope.child(Scope.Attr.logService.name(), (Object)compositeLogService, () -> logIterator.run(Liquibase.this.createRollbackVisitor(), new RuntimeEnvironment(Liquibase.this.database, contexts, labelExpression)));
                    } else {
                        List changeSets = Liquibase.this.determineRollbacks(logIterator, contexts, labelExpression);
                        HashMap<String, Object> values = new HashMap<String, Object>();
                        values.put(Scope.Attr.logService.name(), compositeLogService);
                        values.put(BufferedLogService.class.getName(), bufferLog);
                        Scope.child(values, () -> Liquibase.this.executeRollbackScript(rollbackScript, changeSets, contexts, labelExpression));
                        Liquibase.this.removeRunStatus(changeSets, contexts, labelExpression);
                    }
                    hubUpdater.postUpdateHub(rollbackOperation, bufferLog);
                }
                catch (Throwable t2) {
                    if (hubUpdater != null) {
                        hubUpdater.postUpdateHubExceptionHandling(rollbackOperation, bufferLog, t2.getMessage());
                    }
                    throw t2;
                }
                finally {
                    try {
                        lockService.releaseLock();
                    }
                    catch (LockException e2) {
                        LOG.severe(MSG_COULD_NOT_RELEASE_LOCK, e2);
                    }
                }
                Liquibase.this.resetServices();
                Liquibase.this.setChangeExecListener(null);
            }
        });
    }

    public void rollback(Date dateToRollBackTo, String contexts, Writer output) throws LiquibaseException {
        this.rollback(dateToRollBackTo, null, contexts, output);
    }

    public void rollback(Date dateToRollBackTo, String rollbackScript, String contexts, Writer output) throws LiquibaseException {
        this.rollback(dateToRollBackTo, new Contexts(contexts), new LabelExpression(), output);
    }

    public void rollback(Date dateToRollBackTo, Contexts contexts, LabelExpression labelExpression, Writer output) throws LiquibaseException {
        this.rollback(dateToRollBackTo, null, contexts, labelExpression, output);
    }

    public void rollback(Date dateToRollBackTo, String rollbackScript, Contexts contexts, LabelExpression labelExpression, Writer output) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        this.changeLogParameters.setLabels(labelExpression);
        Executor oldTemplate = this.getAndReplaceJdbcExecutor(output);
        this.outputHeader("Rollback to " + dateToRollBackTo + " Script");
        this.rollback(dateToRollBackTo, contexts, labelExpression);
        this.flushOutputWriter(output);
        Scope.getCurrentScope().getSingleton(ExecutorService.class).setExecutor("jdbc", this.database, oldTemplate);
        this.resetServices();
    }

    private Executor getAndReplaceJdbcExecutor(Writer output) {
        Executor oldTemplate = Scope.getCurrentScope().getSingleton(ExecutorService.class).getExecutor("jdbc", this.database);
        LoggingExecutor loggingExecutor = new LoggingExecutor(oldTemplate, output, this.database);
        Scope.getCurrentScope().getSingleton(ExecutorService.class).setExecutor("logging", this.database, loggingExecutor);
        Scope.getCurrentScope().getSingleton(ExecutorService.class).setExecutor("jdbc", this.database, loggingExecutor);
        return oldTemplate;
    }

    public void rollback(Date dateToRollBackTo, String contexts) throws LiquibaseException {
        this.rollback(dateToRollBackTo, null, contexts);
    }

    public void rollback(Date dateToRollBackTo, Contexts contexts, LabelExpression labelExpression) throws LiquibaseException {
        this.rollback(dateToRollBackTo, null, contexts, labelExpression);
    }

    public void rollback(Date dateToRollBackTo, String rollbackScript, String contexts) throws LiquibaseException {
        this.rollback(dateToRollBackTo, new Contexts(contexts), new LabelExpression());
    }

    public void rollback(final Date dateToRollBackTo, final String rollbackScript, final Contexts contexts, final LabelExpression labelExpression) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        this.changeLogParameters.setLabels(labelExpression);
        this.runInScope(new Scope.ScopedRunner(){

            @Override
            public void run() throws Exception {
                LockService lockService = LockServiceFactory.getInstance().getLockService(Liquibase.this.database);
                lockService.waitForLock();
                Operation rollbackOperation = null;
                BufferedLogService bufferLog = new BufferedLogService();
                DatabaseChangeLog changeLog = null;
                Date startTime = new Date();
                HubUpdater hubUpdater = null;
                try {
                    changeLog = Liquibase.this.getDatabaseChangeLog();
                    Liquibase.this.checkLiquibaseTables(false, changeLog, contexts, labelExpression);
                    changeLog.validate(Liquibase.this.database, contexts, labelExpression);
                    hubUpdater = new HubUpdater(startTime, changeLog, Liquibase.this.database);
                    hubUpdater.register(Liquibase.this.changeLogFile);
                    List<RanChangeSet> ranChangeSetList = Liquibase.this.database.getRanChangeSetList();
                    ChangeLogIterator listLogIterator = new ChangeLogIterator(ranChangeSetList, changeLog, new ExecutedAfterChangeSetFilter(dateToRollBackTo, ranChangeSetList), new AlreadyRanChangeSetFilter(ranChangeSetList), new ContextChangeSetFilter(contexts), new LabelChangeSetFilter(labelExpression), new IgnoreChangeSetFilter(), new DbmsChangeSetFilter(Liquibase.this.database));
                    Connection connection = Liquibase.this.getConnection(changeLog);
                    if (connection != null) {
                        rollbackOperation = hubUpdater.preUpdateHub("ROLLBACK", Liquibase.this.database, connection, Liquibase.this.changeLogFile, contexts, labelExpression, listLogIterator);
                    }
                    if (connection != null) {
                        Liquibase.this.changeExecListener = new HubChangeExecListener(rollbackOperation, Liquibase.this.changeExecListener);
                    }
                    ChangeLogIterator logIterator = new ChangeLogIterator(ranChangeSetList, changeLog, new ExecutedAfterChangeSetFilter(dateToRollBackTo, ranChangeSetList), new AlreadyRanChangeSetFilter(ranChangeSetList), new ContextChangeSetFilter(contexts), new LabelChangeSetFilter(labelExpression), new IgnoreChangeSetFilter(), new DbmsChangeSetFilter(Liquibase.this.database));
                    CompositeLogService compositeLogService = new CompositeLogService(true, bufferLog);
                    if (rollbackScript == null) {
                        Scope.child(Scope.Attr.logService.name(), (Object)compositeLogService, () -> logIterator.run(Liquibase.this.createRollbackVisitor(), new RuntimeEnvironment(Liquibase.this.database, contexts, labelExpression)));
                    } else {
                        List changeSets = Liquibase.this.determineRollbacks(logIterator, contexts, labelExpression);
                        HashMap<String, Object> values = new HashMap<String, Object>();
                        values.put(Scope.Attr.logService.name(), compositeLogService);
                        values.put(BufferedLogService.class.getName(), bufferLog);
                        Scope.child(values, () -> Liquibase.this.executeRollbackScript(rollbackScript, changeSets, contexts, labelExpression));
                        Liquibase.this.removeRunStatus(changeSets, contexts, labelExpression);
                    }
                    hubUpdater.postUpdateHub(rollbackOperation, bufferLog);
                }
                catch (Throwable t2) {
                    if (hubUpdater != null) {
                        hubUpdater.postUpdateHubExceptionHandling(rollbackOperation, bufferLog, t2.getMessage());
                    }
                    throw t2;
                }
                finally {
                    try {
                        lockService.releaseLock();
                    }
                    catch (LockException e2) {
                        LOG.severe(MSG_COULD_NOT_RELEASE_LOCK, e2);
                    }
                    Liquibase.this.resetServices();
                    Liquibase.this.setChangeExecListener(null);
                }
            }
        });
    }

    public void changeLogSync(String contexts, Writer output) throws LiquibaseException {
        this.changeLogSync(new Contexts(contexts), new LabelExpression(), output);
    }

    public void changeLogSync(final Contexts contexts, final LabelExpression labelExpression, final Writer output) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        this.changeLogParameters.setLabels(labelExpression);
        this.runInScope(new Scope.ScopedRunner(){

            @Override
            public void run() throws Exception {
                LoggingExecutor outputTemplate = new LoggingExecutor(Scope.getCurrentScope().getSingleton(ExecutorService.class).getExecutor(Liquibase.this.database), output, Liquibase.this.database);
                Executor oldTemplate = Liquibase.this.getAndReplaceJdbcExecutor(output);
                Liquibase.this.outputHeader("SQL to add all changesets to database history table");
                Liquibase.this.changeLogSync(contexts, labelExpression);
                Liquibase.this.flushOutputWriter(output);
                Scope.getCurrentScope().getSingleton(ExecutorService.class).setExecutor("jdbc", Liquibase.this.database, oldTemplate);
                Liquibase.this.resetServices();
            }
        });
    }

    private void flushOutputWriter(Writer output) throws LiquibaseException {
        if (output == null) {
            return;
        }
        try {
            output.flush();
        }
        catch (IOException e2) {
            throw new LiquibaseException(e2);
        }
    }

    public void changeLogSync(String contexts) throws LiquibaseException {
        this.changeLogSync(new Contexts(contexts), new LabelExpression());
    }

    @Deprecated
    public void changeLogSync(Contexts contexts) throws LiquibaseException {
        this.changeLogSync(contexts, new LabelExpression());
    }

    public void changeLogSync(final Contexts contexts, final LabelExpression labelExpression) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        this.changeLogParameters.setLabels(labelExpression);
        this.runInScope(new Scope.ScopedRunner(){

            @Override
            public void run() throws Exception {
                LockService lockService = LockServiceFactory.getInstance().getLockService(Liquibase.this.database);
                lockService.waitForLock();
                Operation changeLogSyncOperation = null;
                BufferedLogService bufferLog = new BufferedLogService();
                DatabaseChangeLog changeLog = null;
                HubUpdater hubUpdater = null;
                try {
                    changeLog = Liquibase.this.getDatabaseChangeLog();
                    Liquibase.this.checkLiquibaseTables(true, changeLog, contexts, labelExpression);
                    ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(Liquibase.this.database).generateDeploymentId();
                    changeLog.validate(Liquibase.this.database, contexts, labelExpression);
                    hubUpdater = new HubUpdater(new Date(), changeLog, Liquibase.this.database);
                    hubUpdater.register(Liquibase.this.changeLogFile);
                    ChangeLogIterator listLogIterator = new ChangeLogIterator(changeLog, new NotRanChangeSetFilter(Liquibase.this.database.getRanChangeSetList()), new ContextChangeSetFilter(contexts), new LabelChangeSetFilter(labelExpression), new IgnoreChangeSetFilter(), new DbmsChangeSetFilter(Liquibase.this.database));
                    Connection connection = Liquibase.this.getConnection(changeLog);
                    if (connection != null) {
                        changeLogSyncOperation = hubUpdater.preUpdateHub("CHANGELOGSYNC", Liquibase.this.database, connection, Liquibase.this.changeLogFile, contexts, labelExpression, listLogIterator);
                    }
                    if (connection != null) {
                        Liquibase.this.changeLogSyncListener = new HubChangeExecListener(changeLogSyncOperation, Liquibase.this.changeExecListener);
                    }
                    ChangeLogIterator runChangeLogSyncIterator = new ChangeLogIterator(changeLog, new NotRanChangeSetFilter(Liquibase.this.database.getRanChangeSetList()), new ContextChangeSetFilter(contexts), new LabelChangeSetFilter(labelExpression), new IgnoreChangeSetFilter(), new DbmsChangeSetFilter(Liquibase.this.database));
                    CompositeLogService compositeLogService = new CompositeLogService(true, bufferLog);
                    Scope.child(Scope.Attr.logService.name(), (Object)compositeLogService, () -> runChangeLogSyncIterator.run(new ChangeLogSyncVisitor(Liquibase.this.database, Liquibase.this.changeLogSyncListener), new RuntimeEnvironment(Liquibase.this.database, contexts, labelExpression)));
                    hubUpdater.postUpdateHub(changeLogSyncOperation, bufferLog);
                }
                catch (Exception e2) {
                    if (changeLogSyncOperation != null) {
                        hubUpdater.postUpdateHubExceptionHandling(changeLogSyncOperation, bufferLog, e2.getMessage());
                    }
                    throw e2;
                }
                finally {
                    try {
                        lockService.releaseLock();
                    }
                    catch (LockException e3) {
                        LOG.severe(MSG_COULD_NOT_RELEASE_LOCK, e3);
                    }
                    Liquibase.this.resetServices();
                    Liquibase.this.setChangeExecListener(null);
                }
            }
        });
    }

    public void markNextChangeSetRan(String contexts, Writer output) throws LiquibaseException {
        this.markNextChangeSetRan(new Contexts(contexts), new LabelExpression(), output);
    }

    public void markNextChangeSetRan(final Contexts contexts, final LabelExpression labelExpression, final Writer output) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        this.changeLogParameters.setLabels(labelExpression);
        this.runInScope(new Scope.ScopedRunner(){

            @Override
            public void run() throws Exception {
                Executor oldTemplate = Liquibase.this.getAndReplaceJdbcExecutor(output);
                Liquibase.this.outputHeader("SQL to add all changesets to database history table");
                Liquibase.this.markNextChangeSetRan(contexts, labelExpression);
                Liquibase.this.flushOutputWriter(output);
                Scope.getCurrentScope().getSingleton(ExecutorService.class).setExecutor("jdbc", Liquibase.this.database, oldTemplate);
                Liquibase.this.resetServices();
            }
        });
    }

    public void markNextChangeSetRan(String contexts) throws LiquibaseException {
        this.markNextChangeSetRan(new Contexts(contexts), new LabelExpression());
    }

    public void markNextChangeSetRan(final Contexts contexts, final LabelExpression labelExpression) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        this.changeLogParameters.setLabels(labelExpression);
        this.runInScope(new Scope.ScopedRunner(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() throws Exception {
                LockService lockService = LockServiceFactory.getInstance().getLockService(Liquibase.this.database);
                lockService.waitForLock();
                try {
                    DatabaseChangeLog changeLog = Liquibase.this.getDatabaseChangeLog();
                    ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(Liquibase.this.database).generateDeploymentId();
                    Liquibase.this.checkLiquibaseTables(false, changeLog, contexts, labelExpression);
                    changeLog.validate(Liquibase.this.database, contexts, labelExpression);
                    ChangeLogIterator logIterator = new ChangeLogIterator(changeLog, new NotRanChangeSetFilter(Liquibase.this.database.getRanChangeSetList()), new ContextChangeSetFilter(contexts), new LabelChangeSetFilter(labelExpression), new DbmsChangeSetFilter(Liquibase.this.database), new IgnoreChangeSetFilter(), new CountChangeSetFilter(1));
                    logIterator.run(new ChangeLogSyncVisitor(Liquibase.this.database), new RuntimeEnvironment(Liquibase.this.database, contexts, labelExpression));
                }
                finally {
                    try {
                        lockService.releaseLock();
                    }
                    catch (LockException e2) {
                        LOG.severe(MSG_COULD_NOT_RELEASE_LOCK, e2);
                    }
                    Liquibase.this.resetServices();
                }
            }
        });
    }

    public void futureRollbackSQL(String contexts, Writer output) throws LiquibaseException {
        this.futureRollbackSQL(null, contexts, output, true);
    }

    public void futureRollbackSQL(Writer output) throws LiquibaseException {
        this.futureRollbackSQL(null, null, new Contexts(), new LabelExpression(), output);
    }

    public void futureRollbackSQL(String contexts, Writer output, boolean checkLiquibaseTables) throws LiquibaseException {
        this.futureRollbackSQL(null, contexts, output, checkLiquibaseTables);
    }

    public void futureRollbackSQL(Integer count, String contexts, Writer output) throws LiquibaseException {
        this.futureRollbackSQL(count, new Contexts(contexts), new LabelExpression(), output, true);
    }

    public void futureRollbackSQL(Contexts contexts, LabelExpression labelExpression, Writer output) throws LiquibaseException {
        this.futureRollbackSQL(null, null, contexts, labelExpression, output);
    }

    public void futureRollbackSQL(Integer count, String contexts, Writer output, boolean checkLiquibaseTables) throws LiquibaseException {
        this.futureRollbackSQL(count, new Contexts(contexts), new LabelExpression(), output, checkLiquibaseTables);
    }

    public void futureRollbackSQL(Integer count, Contexts contexts, LabelExpression labelExpression, Writer output) throws LiquibaseException {
        this.futureRollbackSQL(count, contexts, labelExpression, output, true);
    }

    public void futureRollbackSQL(Integer count, Contexts contexts, LabelExpression labelExpression, Writer output, boolean checkLiquibaseTables) throws LiquibaseException {
        this.futureRollbackSQL(count, null, contexts, labelExpression, output);
    }

    public void futureRollbackSQL(String tag, Contexts contexts, LabelExpression labelExpression, Writer output) throws LiquibaseException {
        this.futureRollbackSQL(null, tag, contexts, labelExpression, output);
    }

    protected void futureRollbackSQL(Integer count, String tag, Contexts contexts, LabelExpression labelExpression, Writer output) throws LiquibaseException {
        this.futureRollbackSQL(count, tag, contexts, labelExpression, output, true);
    }

    protected void futureRollbackSQL(final Integer count, final String tag, final Contexts contexts, final LabelExpression labelExpression, final Writer output, final boolean checkLiquibaseTables) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        this.changeLogParameters.setLabels(labelExpression);
        this.runInScope(new Scope.ScopedRunner(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() throws Exception {
                LoggingExecutor outputTemplate = new LoggingExecutor(Scope.getCurrentScope().getSingleton(ExecutorService.class).getExecutor(Liquibase.this.database), output, Liquibase.this.database);
                Executor oldTemplate = Liquibase.this.getAndReplaceJdbcExecutor(output);
                Scope.getCurrentScope().getSingleton(ExecutorService.class).setExecutor(Liquibase.this.database, outputTemplate);
                Liquibase.this.outputHeader("SQL to roll back currently unexecuted changes");
                LockService lockService = LockServiceFactory.getInstance().getLockService(Liquibase.this.database);
                lockService.waitForLock();
                try {
                    ChangeLogIterator logIterator;
                    DatabaseChangeLog changeLog = Liquibase.this.getDatabaseChangeLog();
                    if (checkLiquibaseTables) {
                        Liquibase.this.checkLiquibaseTables(false, changeLog, contexts, labelExpression);
                    }
                    ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(Liquibase.this.database).generateDeploymentId();
                    changeLog.validate(Liquibase.this.database, contexts, labelExpression);
                    if (count == null && tag == null) {
                        logIterator = new ChangeLogIterator(changeLog, new NotRanChangeSetFilter(Liquibase.this.database.getRanChangeSetList()), new ContextChangeSetFilter(contexts), new LabelChangeSetFilter(labelExpression), new IgnoreChangeSetFilter(), new DbmsChangeSetFilter(Liquibase.this.database));
                    } else if (count != null) {
                        ChangeLogIterator forwardIterator = new ChangeLogIterator(changeLog, new NotRanChangeSetFilter(Liquibase.this.database.getRanChangeSetList()), new ContextChangeSetFilter(contexts), new LabelChangeSetFilter(labelExpression), new DbmsChangeSetFilter(Liquibase.this.database), new IgnoreChangeSetFilter(), new CountChangeSetFilter(count));
                        final ListVisitor listVisitor = new ListVisitor();
                        forwardIterator.run(listVisitor, new RuntimeEnvironment(Liquibase.this.database, contexts, labelExpression));
                        logIterator = new ChangeLogIterator(changeLog, new NotRanChangeSetFilter(Liquibase.this.database.getRanChangeSetList()), new ContextChangeSetFilter(contexts), new LabelChangeSetFilter(labelExpression), new DbmsChangeSetFilter(Liquibase.this.database), new IgnoreChangeSetFilter(), new ChangeSetFilter(){

                            @Override
                            public ChangeSetFilterResult accepts(ChangeSet changeSet) {
                                return new ChangeSetFilterResult(listVisitor.getSeenChangeSets().contains(changeSet), null, null);
                            }
                        });
                    } else {
                        List<RanChangeSet> ranChangeSetList = Liquibase.this.database.getRanChangeSetList();
                        ChangeLogIterator forwardIterator = new ChangeLogIterator(changeLog, new NotRanChangeSetFilter(ranChangeSetList), new ContextChangeSetFilter(contexts), new LabelChangeSetFilter(labelExpression), new DbmsChangeSetFilter(Liquibase.this.database), new IgnoreChangeSetFilter(), new UpToTagChangeSetFilter(tag, ranChangeSetList));
                        final ListVisitor listVisitor = new ListVisitor();
                        forwardIterator.run(listVisitor, new RuntimeEnvironment(Liquibase.this.database, contexts, labelExpression));
                        logIterator = new ChangeLogIterator(changeLog, new NotRanChangeSetFilter(ranChangeSetList), new ContextChangeSetFilter(contexts), new LabelChangeSetFilter(labelExpression), new DbmsChangeSetFilter(Liquibase.this.database), new IgnoreChangeSetFilter(), new ChangeSetFilter(){

                            @Override
                            public ChangeSetFilterResult accepts(ChangeSet changeSet) {
                                return new ChangeSetFilterResult(listVisitor.getSeenChangeSets().contains(changeSet), null, null);
                            }
                        });
                    }
                    logIterator.run(Liquibase.this.createRollbackVisitor(), new RuntimeEnvironment(Liquibase.this.database, contexts, labelExpression));
                }
                finally {
                    try {
                        lockService.releaseLock();
                    }
                    catch (LockException e2) {
                        LOG.severe(MSG_COULD_NOT_RELEASE_LOCK, e2);
                    }
                    Scope.getCurrentScope().getSingleton(ExecutorService.class).setExecutor("jdbc", Liquibase.this.database, oldTemplate);
                    Liquibase.this.resetServices();
                }
                Liquibase.this.flushOutputWriter(output);
            }
        });
    }

    protected void resetServices() {
        LockServiceFactory.getInstance().resetAll();
        ChangeLogHistoryServiceFactory.getInstance().resetAll();
        Scope.getCurrentScope().getSingleton(ExecutorService.class).reset();
    }

    public final void dropAll() throws DatabaseException {
        this.dropAll(new CatalogAndSchema(this.getDatabase().getDefaultCatalogName(), this.getDatabase().getDefaultSchemaName()));
    }

    public final void dropAll(CatalogAndSchema ... schemas) throws DatabaseException {
        if (schemas == null || schemas.length == 0) {
            schemas = new CatalogAndSchema[]{new CatalogAndSchema(this.getDatabase().getDefaultCatalogName(), this.getDatabase().getDefaultSchemaName())};
        }
        final CatalogAndSchema[] finalSchemas = schemas;
        try {
            this.runInScope(new Scope.ScopedRunner(){

                @Override
                public void run() throws Exception {
                    DropAllCommand dropAll = (DropAllCommand)CommandFactory.getInstance().getCommand("dropAll");
                    dropAll.setDatabase(Liquibase.this.getDatabase());
                    dropAll.setSchemas(finalSchemas);
                    dropAll.setLiquibase(Liquibase.this);
                    dropAll.setChangeLogFile(Liquibase.this.changeLogFile);
                    try {
                        dropAll.execute();
                    }
                    catch (CommandExecutionException e2) {
                        throw new DatabaseException(e2);
                    }
                }
            });
        }
        catch (LiquibaseException e2) {
            if (e2 instanceof DatabaseException) {
                throw (DatabaseException)e2;
            }
            throw new DatabaseException(e2);
        }
    }

    public void tag(final String tagString) throws LiquibaseException {
        this.runInScope(new Scope.ScopedRunner(){

            @Override
            public void run() throws Exception {
                LockService lockService = LockServiceFactory.getInstance().getLockService(Liquibase.this.database);
                lockService.waitForLock();
                try {
                    ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(Liquibase.this.database).generateDeploymentId();
                    Liquibase.this.checkLiquibaseTables(false, null, new Contexts(), new LabelExpression());
                    Liquibase.this.getDatabase().tag(tagString);
                }
                finally {
                    try {
                        lockService.releaseLock();
                    }
                    catch (LockException e2) {
                        LOG.severe(MSG_COULD_NOT_RELEASE_LOCK, e2);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tagExists(String tagString) throws LiquibaseException {
        LockService lockService = LockServiceFactory.getInstance().getLockService(this.database);
        lockService.waitForLock();
        try {
            this.checkLiquibaseTables(false, null, new Contexts(), new LabelExpression());
            boolean bl2 = this.getDatabase().doesTagExist(tagString);
            return bl2;
        }
        finally {
            try {
                lockService.releaseLock();
            }
            catch (LockException e2) {
                LOG.severe(MSG_COULD_NOT_RELEASE_LOCK, e2);
            }
        }
    }

    public void updateTestingRollback(String contexts) throws LiquibaseException {
        this.updateTestingRollback(new Contexts(contexts), new LabelExpression());
    }

    public void updateTestingRollback(Contexts contexts, LabelExpression labelExpression) throws LiquibaseException {
        this.updateTestingRollback(null, contexts, labelExpression);
    }

    public void updateTestingRollback(String tag, Contexts contexts, LabelExpression labelExpression) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        this.changeLogParameters.setLabels(labelExpression);
        Date baseDate = new Date();
        this.update(tag, contexts, labelExpression);
        this.rollback(baseDate, null, contexts, labelExpression);
        this.update(tag, contexts, labelExpression);
    }

    public void checkLiquibaseTables(boolean updateExistingNullChecksums, DatabaseChangeLog databaseChangeLog, Contexts contexts, LabelExpression labelExpression) throws LiquibaseException {
        ChangeLogHistoryService changeLogHistoryService = ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(this.getDatabase());
        changeLogHistoryService.init();
        if (updateExistingNullChecksums) {
            changeLogHistoryService.upgradeChecksums(databaseChangeLog, contexts, labelExpression);
        }
        LockServiceFactory.getInstance().getLockService(this.getDatabase()).init();
    }

    public boolean isSafeToRunUpdate() throws DatabaseException {
        return this.getDatabase().isSafeToRunUpdate();
    }

    public DatabaseChangeLogLock[] listLocks() throws LiquibaseException {
        this.checkLiquibaseTables(false, null, new Contexts(), new LabelExpression());
        return LockServiceFactory.getInstance().getLockService(this.database).listLocks();
    }

    public void reportLocks(PrintStream out) throws LiquibaseException {
        DatabaseChangeLogLock[] locks = this.listLocks();
        out.println("Database change log locks for " + this.getDatabase().getConnection().getConnectionUserName() + "@" + this.getDatabase().getConnection().getURL());
        if (locks.length == 0) {
            out.println(" - No locks");
        }
        for (DatabaseChangeLogLock lock : locks) {
            out.println(" - " + lock.getLockedBy() + " at " + DateFormat.getDateTimeInstance().format(lock.getLockGranted()));
        }
    }

    public void forceReleaseLocks() throws LiquibaseException {
        this.checkLiquibaseTables(false, null, new Contexts(), new LabelExpression());
        LockServiceFactory.getInstance().getLockService(this.database).forceReleaseLock();
    }

    @Deprecated
    public List<ChangeSet> listUnrunChangeSets(Contexts contexts) throws LiquibaseException {
        return this.listUnrunChangeSets(contexts, new LabelExpression());
    }

    public List<ChangeSet> listUnrunChangeSets(Contexts contexts, LabelExpression labels) throws LiquibaseException {
        return this.listUnrunChangeSets(contexts, labels, true);
    }

    public List<ChangeSet> listUnrunChangeSets(final Contexts contexts, final LabelExpression labels, final boolean checkLiquibaseTables) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        this.changeLogParameters.setLabels(labels);
        final ListVisitor visitor = new ListVisitor();
        this.runInScope(new Scope.ScopedRunner(){

            @Override
            public void run() throws Exception {
                DatabaseChangeLog changeLog = Liquibase.this.getDatabaseChangeLog();
                if (checkLiquibaseTables) {
                    Liquibase.this.checkLiquibaseTables(true, changeLog, contexts, labels);
                }
                changeLog.validate(Liquibase.this.database, contexts, labels);
                ChangeLogIterator logIterator = Liquibase.this.getStandardChangelogIterator(contexts, labels, changeLog);
                logIterator.run(visitor, new RuntimeEnvironment(Liquibase.this.database, contexts, labels));
            }
        });
        return visitor.getSeenChangeSets();
    }

    @Deprecated
    public List<ChangeSetStatus> getChangeSetStatuses(Contexts contexts) throws LiquibaseException {
        return this.getChangeSetStatuses(contexts, new LabelExpression());
    }

    public List<ChangeSetStatus> getChangeSetStatuses(Contexts contexts, LabelExpression labelExpression) throws LiquibaseException {
        return this.getChangeSetStatuses(contexts, labelExpression, true);
    }

    public List<ChangeSetStatus> getChangeSetStatuses(final Contexts contexts, final LabelExpression labelExpression, final boolean checkLiquibaseTables) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        this.changeLogParameters.setLabels(labelExpression);
        final StatusVisitor visitor = new StatusVisitor(this.database);
        this.runInScope(new Scope.ScopedRunner(){

            @Override
            public void run() throws Exception {
                DatabaseChangeLog changeLog = Liquibase.this.getDatabaseChangeLog();
                if (checkLiquibaseTables) {
                    Liquibase.this.checkLiquibaseTables(true, changeLog, contexts, labelExpression);
                }
                changeLog.validate(Liquibase.this.database, contexts, labelExpression);
                ChangeLogIterator logIterator = Liquibase.this.getStandardChangelogIterator(contexts, labelExpression, changeLog);
                logIterator.run(visitor, new RuntimeEnvironment(Liquibase.this.database, contexts, labelExpression));
            }
        });
        return visitor.getStatuses();
    }

    public void reportStatus(boolean verbose, String contexts, Writer out) throws LiquibaseException {
        this.reportStatus(verbose, new Contexts(contexts), new LabelExpression(), out);
    }

    public void reportStatus(boolean verbose, Contexts contexts, Writer out) throws LiquibaseException {
        this.reportStatus(verbose, contexts, new LabelExpression(), out);
    }

    public void reportStatus(boolean verbose, Contexts contexts, LabelExpression labels, Writer out) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        this.changeLogParameters.setLabels(labels);
        try {
            List<ChangeSet> unrunChangeSets = this.listUnrunChangeSets(contexts, labels, false);
            if (unrunChangeSets.isEmpty()) {
                out.append(this.getDatabase().getConnection().getConnectionUserName());
                out.append("@");
                out.append(this.getDatabase().getConnection().getURL());
                out.append(" is up to date");
                out.append(StreamUtil.getLineSeparator());
            } else {
                out.append(String.valueOf(unrunChangeSets.size()));
                out.append(" change sets have not been applied to ");
                out.append(this.getDatabase().getConnection().getConnectionUserName());
                out.append("@");
                out.append(this.getDatabase().getConnection().getURL());
                out.append(StreamUtil.getLineSeparator());
                if (verbose) {
                    for (ChangeSet changeSet : unrunChangeSets) {
                        out.append("     ").append(changeSet.toString(false)).append(StreamUtil.getLineSeparator());
                    }
                }
            }
            out.flush();
        }
        catch (IOException e2) {
            throw new LiquibaseException(e2);
        }
    }

    public Collection<RanChangeSet> listUnexpectedChangeSets(String contexts) throws LiquibaseException {
        return this.listUnexpectedChangeSets(new Contexts(contexts), new LabelExpression());
    }

    public Collection<RanChangeSet> listUnexpectedChangeSets(final Contexts contexts, final LabelExpression labelExpression) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        this.changeLogParameters.setLabels(labelExpression);
        final ExpectedChangesVisitor visitor = new ExpectedChangesVisitor(this.database.getRanChangeSetList());
        this.runInScope(new Scope.ScopedRunner(){

            @Override
            public void run() throws Exception {
                DatabaseChangeLog changeLog = Liquibase.this.getDatabaseChangeLog();
                changeLog.validate(Liquibase.this.database, contexts, labelExpression);
                ChangeLogIterator logIterator = new ChangeLogIterator(changeLog, new ContextChangeSetFilter(contexts), new LabelChangeSetFilter(labelExpression), new DbmsChangeSetFilter(Liquibase.this.database), new IgnoreChangeSetFilter());
                logIterator.run(visitor, new RuntimeEnvironment(Liquibase.this.database, contexts, labelExpression));
            }
        });
        return visitor.getUnexpectedChangeSets();
    }

    public void reportUnexpectedChangeSets(boolean verbose, String contexts, Writer out) throws LiquibaseException {
        this.reportUnexpectedChangeSets(verbose, new Contexts(contexts), new LabelExpression(), out);
    }

    public void reportUnexpectedChangeSets(boolean verbose, Contexts contexts, LabelExpression labelExpression, Writer out) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        this.changeLogParameters.setLabels(labelExpression);
        try {
            Collection<RanChangeSet> unexpectedChangeSets = this.listUnexpectedChangeSets(contexts, labelExpression);
            if (unexpectedChangeSets.isEmpty()) {
                out.append(this.getDatabase().getConnection().getConnectionUserName());
                out.append("@");
                out.append(this.getDatabase().getConnection().getURL());
                out.append(" contains no unexpected changes!");
                out.append(StreamUtil.getLineSeparator());
            } else {
                out.append(String.valueOf(unexpectedChangeSets.size()));
                out.append(" unexpected changes were found in ");
                out.append(this.getDatabase().getConnection().getConnectionUserName());
                out.append("@");
                out.append(this.getDatabase().getConnection().getURL());
                out.append(StreamUtil.getLineSeparator());
                if (verbose) {
                    for (RanChangeSet ranChangeSet : unexpectedChangeSets) {
                        out.append("     ").append(ranChangeSet.toString()).append(StreamUtil.getLineSeparator());
                    }
                }
            }
            out.flush();
        }
        catch (IOException e2) {
            throw new LiquibaseException(e2);
        }
    }

    public void clearCheckSums() throws LiquibaseException {
        LOG.info("Clearing database change log checksums");
        this.runInScope(new Scope.ScopedRunner(){

            @Override
            public void run() throws Exception {
                LockService lockService = LockServiceFactory.getInstance().getLockService(Liquibase.this.database);
                lockService.waitForLock();
                try {
                    Liquibase.this.checkLiquibaseTables(false, null, new Contexts(), new LabelExpression());
                    UpdateStatement updateStatement = new UpdateStatement(Liquibase.this.getDatabase().getLiquibaseCatalogName(), Liquibase.this.getDatabase().getLiquibaseSchemaName(), Liquibase.this.getDatabase().getDatabaseChangeLogTableName());
                    updateStatement.addNewColumnValue("MD5SUM", null);
                    Scope.getCurrentScope().getSingleton(ExecutorService.class).getExecutor("jdbc", Liquibase.this.database).execute(updateStatement);
                    Liquibase.this.getDatabase().commit();
                }
                finally {
                    try {
                        lockService.releaseLock();
                    }
                    catch (LockException e2) {
                        LOG.severe(MSG_COULD_NOT_RELEASE_LOCK, e2);
                    }
                }
                Liquibase.this.resetServices();
            }
        });
    }

    public final CheckSum calculateCheckSum(String changeSetIdentifier) throws LiquibaseException {
        if (changeSetIdentifier == null) {
            throw new LiquibaseException(new IllegalArgumentException("changeSetIdentifier"));
        }
        List<String> parts = StringUtil.splitAndTrim(changeSetIdentifier, "::");
        if (parts == null || parts.size() < 3) {
            throw new LiquibaseException(new IllegalArgumentException("Invalid changeSet identifier: " + changeSetIdentifier));
        }
        return this.calculateCheckSum(parts.get(0), parts.get(1), parts.get(2));
    }

    public CheckSum calculateCheckSum(String filename, String id2, String author) throws LiquibaseException {
        LOG.info(String.format("Calculating checksum for changeset %s::%s::%s", filename, id2, author));
        ChangeLogParameters clParameters = this.getChangeLogParameters();
        ResourceAccessor resourceAccessor = this.getResourceAccessor();
        DatabaseChangeLog changeLog = ChangeLogParserFactory.getInstance().getParser(this.changeLogFile, resourceAccessor).parse(this.changeLogFile, clParameters, resourceAccessor);
        ChangeSet changeSet = changeLog.getChangeSet(filename, author, id2);
        if (changeSet == null) {
            throw new LiquibaseException(new IllegalArgumentException("No such changeSet: " + filename + "::" + id2 + "::" + author));
        }
        return changeSet.generateCheckSum();
    }

    public void generateDocumentation(String outputDirectory) throws LiquibaseException {
        this.generateDocumentation(outputDirectory, new Contexts(), new LabelExpression());
    }

    public void generateDocumentation(String outputDirectory, String contexts) throws LiquibaseException {
        this.generateDocumentation(outputDirectory, new Contexts(contexts), new LabelExpression());
    }

    public void generateDocumentation(final String outputDirectory, final Contexts contexts, final LabelExpression labelExpression) throws LiquibaseException {
        this.runInScope(new Scope.ScopedRunner(){

            @Override
            public void run() throws Exception {
                LOG.info("Generating Database Documentation");
                Liquibase.this.changeLogParameters.setContexts(contexts);
                Liquibase.this.changeLogParameters.setLabels(labelExpression);
                LockService lockService = LockServiceFactory.getInstance().getLockService(Liquibase.this.database);
                lockService.waitForLock();
                try {
                    DatabaseChangeLog changeLog = Liquibase.this.getDatabaseChangeLog();
                    Liquibase.this.checkLiquibaseTables(false, changeLog, new Contexts(), new LabelExpression());
                    changeLog.validate(Liquibase.this.database, contexts, labelExpression);
                    ChangeLogIterator logIterator = new ChangeLogIterator(changeLog, new DbmsChangeSetFilter(Liquibase.this.database));
                    DBDocVisitor visitor = new DBDocVisitor(Liquibase.this.database);
                    logIterator.run(visitor, new RuntimeEnvironment(Liquibase.this.database, contexts, labelExpression));
                    visitor.writeHTML(new File(outputDirectory), Liquibase.this.resourceAccessor);
                }
                catch (IOException e2) {
                    throw new LiquibaseException(e2);
                }
                finally {
                    try {
                        lockService.releaseLock();
                    }
                    catch (LockException e3) {
                        LOG.severe(MSG_COULD_NOT_RELEASE_LOCK, e3);
                    }
                }
            }
        });
    }

    public DiffResult diff(Database referenceDatabase, Database targetDatabase, CompareControl compareControl) throws LiquibaseException {
        return DiffGeneratorFactory.getInstance().compare(referenceDatabase, targetDatabase, compareControl);
    }

    public void validate() throws LiquibaseException {
        DatabaseChangeLog changeLog = this.getDatabaseChangeLog();
        changeLog.validate(this.database, new String[0]);
    }

    public void setChangeLogParameter(String key, Object value) {
        this.changeLogParameters.set(key, value);
    }

    private void setDatabasePropertiesAsChangelogParameters(Database database) throws DatabaseException {
        this.setChangeLogParameter("database.autoIncrementClause", database.getAutoIncrementClause(null, null, null, null));
        this.setChangeLogParameter("database.currentDateTimeFunction", database.getCurrentDateTimeFunction());
        this.setChangeLogParameter("database.databaseChangeLogLockTableName", database.getDatabaseChangeLogLockTableName());
        this.setChangeLogParameter("database.databaseChangeLogTableName", database.getDatabaseChangeLogTableName());
        this.setChangeLogParameter("database.databaseMajorVersion", database.getDatabaseMajorVersion());
        this.setChangeLogParameter("database.databaseMinorVersion", database.getDatabaseMinorVersion());
        this.setChangeLogParameter("database.databaseProductName", database.getDatabaseProductName());
        this.setChangeLogParameter("database.databaseProductVersion", database.getDatabaseProductVersion());
        this.setChangeLogParameter("database.defaultCatalogName", database.getDefaultCatalogName());
        this.setChangeLogParameter("database.defaultSchemaName", database.getDefaultSchemaName());
        this.setChangeLogParameter("database.defaultSchemaNamePrefix", StringUtil.trimToNull(database.getDefaultSchemaName()) == null ? "" : "." + database.getDefaultSchemaName());
        this.setChangeLogParameter("database.lineComment", database.getLineComment());
        this.setChangeLogParameter("database.liquibaseSchemaName", database.getLiquibaseSchemaName());
        this.setChangeLogParameter("database.liquibaseTablespaceName", database.getLiquibaseTablespaceName());
        this.setChangeLogParameter("database.typeName", database.getShortName());
        this.setChangeLogParameter("database.isSafeToRunUpdate", database.isSafeToRunUpdate());
        this.setChangeLogParameter("database.requiresPassword", database.requiresPassword());
        this.setChangeLogParameter("database.requiresUsername", database.requiresUsername());
        this.setChangeLogParameter("database.supportsForeignKeyDisable", database.supportsForeignKeyDisable());
        this.setChangeLogParameter("database.supportsInitiallyDeferrableColumns", database.supportsInitiallyDeferrableColumns());
        this.setChangeLogParameter("database.supportsRestrictForeignKeys", database.supportsRestrictForeignKeys());
        this.setChangeLogParameter("database.supportsSchemas", database.supportsSchemas());
        this.setChangeLogParameter("database.supportsSequences", database.supportsSequences());
        this.setChangeLogParameter("database.supportsTablespaces", database.supportsTablespaces());
    }

    private LockService getLockService() {
        return LockServiceFactory.getInstance().getLockService(this.database);
    }

    public void setChangeExecListener(ChangeExecListener listener) {
        this.changeExecListener = listener;
    }

    public void setChangeLogSyncListener(ChangeLogSyncListener changeLogSyncListener) {
        this.changeLogSyncListener = changeLogSyncListener;
    }

    @SafeVarargs
    public final void generateChangeLog(CatalogAndSchema catalogAndSchema, DiffToChangeLog changeLogWriter, PrintStream outputStream, Class<? extends DatabaseObject> ... snapshotTypes) throws DatabaseException, IOException, ParserConfigurationException {
        this.generateChangeLog(catalogAndSchema, changeLogWriter, outputStream, (ChangeLogSerializer)null, snapshotTypes);
    }

    @SafeVarargs
    public final void generateChangeLog(final CatalogAndSchema catalogAndSchema, final DiffToChangeLog changeLogWriter, final PrintStream outputStream, final ChangeLogSerializer changeLogSerializer, final Class<? extends DatabaseObject> ... snapshotTypes) throws DatabaseException, IOException, ParserConfigurationException {
        try {
            this.runInScope(new Scope.ScopedRunner(){

                @Override
                public void run() throws Exception {
                    HashSet<Class<? extends DatabaseObject>> finalCompareTypes = null;
                    if (snapshotTypes != null && snapshotTypes.length > 0) {
                        finalCompareTypes = new HashSet<Class<? extends DatabaseObject>>(Arrays.asList(snapshotTypes));
                    }
                    SnapshotControl snapshotControl = new SnapshotControl(Liquibase.this.getDatabase(), snapshotTypes);
                    CompareControl compareControl = new CompareControl(new CompareControl.SchemaComparison[]{new CompareControl.SchemaComparison(catalogAndSchema, catalogAndSchema)}, finalCompareTypes);
                    DatabaseSnapshot originalDatabaseSnapshot = null;
                    try {
                        originalDatabaseSnapshot = SnapshotGeneratorFactory.getInstance().createSnapshot(compareControl.getSchemas(CompareControl.DatabaseRole.REFERENCE), Liquibase.this.getDatabase(), snapshotControl);
                        DiffResult diffResult = DiffGeneratorFactory.getInstance().compare(originalDatabaseSnapshot, SnapshotGeneratorFactory.getInstance().createSnapshot(compareControl.getSchemas(CompareControl.DatabaseRole.REFERENCE), null, snapshotControl), compareControl);
                        changeLogWriter.setDiffResult(diffResult);
                        if (changeLogSerializer != null) {
                            changeLogWriter.print(outputStream, changeLogSerializer);
                        } else {
                            changeLogWriter.print(outputStream);
                        }
                    }
                    catch (InvalidExampleException e2) {
                        throw new UnexpectedLiquibaseException(e2);
                    }
                }
            });
        }
        catch (LiquibaseException e2) {
            throw new DatabaseException(e2);
        }
    }

    private void runInScope(Scope.ScopedRunner scopedRunner) throws LiquibaseException {
        HashMap<String, Object> scopeObjects = new HashMap<String, Object>();
        scopeObjects.put(Scope.Attr.database.name(), this.getDatabase());
        scopeObjects.put(Scope.Attr.resourceAccessor.name(), this.getResourceAccessor());
        try {
            Scope.child(scopeObjects, scopedRunner);
        }
        catch (Exception e2) {
            if (e2 instanceof LiquibaseException) {
                throw (LiquibaseException)e2;
            }
            throw new LiquibaseException(e2);
        }
    }

    @Override
    public void close() throws LiquibaseException {
        if (this.database != null) {
            this.database.close();
        }
    }

    private static enum RollbackMessageType {
        WILL_ROLLBACK,
        ROLLED_BACK,
        ROLLBACK_FAILED;

    }
}

