/*
 * Decompiled with CFR 0.152.
 */
package com.ryantenney.metrics.spring.reporter;

import com.ryantenney.metrics.spring.reporter.AbstractReporterElementParser;
import com.ryantenney.metrics.spring.reporter.ConsoleReporterFactoryBean;

public class ConsoleReporterElementParser
extends AbstractReporterElementParser {
    private static final String LOCALE_STRING_REGEX = "^[a-z]{2}(_[A-Z]{2})?$";

    @Override
    public String getType() {
        return "console";
    }

    @Override
    protected Class<?> getBeanClass() {
        return ConsoleReporterFactoryBean.class;
    }

    @Override
    protected void validate(AbstractReporterElementParser.ValidationContext c) {
        c.require("period", "^(\\d+)\\s?(ns|us|ms|s|m|h|d)?$", "Period is required and must be in the form '\\d+(ns|us|ms|s|m|h|d)'");
        c.optional("clock-ref");
        c.optional("output-ref");
        c.optional("locale", LOCALE_STRING_REGEX, "Locale must be in the proper format");
        c.optional("timezone");
        c.optional("rate-unit", "^(?:DAY|HOUR|MINUTE|(?:MICRO|MILLI|NANO)?SECOND)S$", "Rate unit must be one of the enum constants from java.util.concurrent.TimeUnit");
        c.optional("duration-unit", "^(?:DAY|HOUR|MINUTE|(?:MICRO|MILLI|NANO)?SECOND)S$", "Duration unit must be one of the enum constants from java.util.concurrent.TimeUnit");
        c.optional("filter");
        c.optional("filter-ref");
        if (c.has("filter") && c.has("filter-ref")) {
            c.reject("filter-ref", "Reporter element must not specify both the 'filter' and 'filter-ref' attributes");
        }
        c.rejectUnmatchedProperties();
    }
}

