/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.spring.configuration;

import com.xebialabs.deployit.spring.HoconPropertySourceFactory;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.xlrelease.config.XlrConfig;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.DefaultPropertySourceFactory;
import org.springframework.core.io.support.EncodedResource;

public class XlrWebApplicationInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(XlrWebApplicationInitializer.class);

    public void initialize(ConfigurableApplicationContext applicationContext) {
        ConfigurableEnvironment environment = applicationContext.getEnvironment();
        this.addProfiles(environment);
        this.addConverters(environment);
        this.addPropertySources(environment);
    }

    private void addPropertySources(ConfigurableEnvironment environment) {
        try {
            HoconPropertySourceFactory hoconPropertySourceFactory = new HoconPropertySourceFactory();
            PropertySource propertySource = hoconPropertySourceFactory.createPropertySource(XlrConfig.defaultConfigName(), new EncodedResource((Resource)new ClassPathResource(XlrConfig.defaultConfigName())));
            environment.getPropertySources().addLast(propertySource);
            DefaultPropertySourceFactory defaultPropertySourceFactory = new DefaultPropertySourceFactory();
            PropertySource defaultPS = defaultPropertySourceFactory.createPropertySource("xl-release-server.conf", new EncodedResource((Resource)new ClassPathResource("xl-release-server.conf")));
            environment.getPropertySources().addLast(defaultPS);
        }
        catch (IOException e) {
            LOGGER.error("Some properties might not be loaded correctly, see following stacktrace", (Throwable)e);
        }
    }

    private void addProfiles(ConfigurableEnvironment environment) {
        XlrConfig bootConfig = XlrConfig.getInstance();
        if (bootConfig.isClusterEnabled()) {
            LOGGER.info(String.format("Running in cluster mode: %s", bootConfig.clusterMode().configOption()));
            environment.addActiveProfile("cluster");
            environment.addActiveProfile(bootConfig.clusterMode().configOption());
        } else {
            LOGGER.info("Running in standalone mode");
            environment.addActiveProfile("default");
        }
        if (bootConfig.isOidcEnabled()) {
            LOGGER.info("OIDC authentication is enabled");
            environment.addActiveProfile("oidcAuth");
        } else {
            LOGGER.info("Default authentication is enabled");
            environment.addActiveProfile("defaultAuth");
        }
    }

    private void addConverters(ConfigurableEnvironment environment) {
        DefaultConversionService conversionService = new DefaultConversionService();
        conversionService.addConverter((GenericConverter)new PasswordConverter());
        environment.setConversionService((ConfigurableConversionService)conversionService);
    }

    private class PasswordConverter
    implements ConditionalGenericConverter {
        private Set<GenericConverter.ConvertiblePair> convertiblePairs = new HashSet<GenericConverter.ConvertiblePair>();

        PasswordConverter() {
        }

        public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
            TypeDescriptor stringDescriptor = TypeDescriptor.valueOf(String.class);
            return sourceType == stringDescriptor && targetType == stringDescriptor;
        }

        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            this.convertiblePairs.add(new GenericConverter.ConvertiblePair(String.class, String.class));
            return this.convertiblePairs;
        }

        public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            if (source == null) {
                return null;
            }
            if (PasswordEncrypter.getInstance().isEncodedAndDecryptable(source.toString())) {
                return PasswordEncrypter.getInstance().decrypt(source.toString());
            }
            return source;
        }
    }
}

