/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.script;

import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.script.DefaultScriptService;
import com.xebialabs.xlrelease.script.ScriptServiceHelper;
import com.xebialabs.xlrelease.script.XlrScriptContext;
import java.util.Map;
import java.util.function.Function;

public class VariablesHolderForScriptContext {
    private XlrScriptContext scriptContext;
    private final Release release;
    private final String folderId;
    private Map<String, Variable> previousReleaseVariables;
    private Map<String, Variable> previousFolderVariables;
    private Map<String, Variable> previousGlobalVariables;
    private Function<DefaultScriptService.VariablesUpdateHolder, DefaultScriptService.ScriptTaskResults> synchronizeCallback;

    public VariablesHolderForScriptContext(Release release, String folderId, Map<String, Variable> previousReleaseVariables, Map<String, Variable> previousFolderVariables, Map<String, Variable> previousGlobalVariables, Function<DefaultScriptService.VariablesUpdateHolder, DefaultScriptService.ScriptTaskResults> synchronizeCallback) {
        this.release = release;
        this.folderId = folderId;
        this.previousReleaseVariables = previousReleaseVariables;
        this.previousFolderVariables = previousFolderVariables;
        this.previousGlobalVariables = previousGlobalVariables;
        this.synchronizeCallback = synchronizeCallback;
    }

    public Map<String, Variable> getPreviousReleaseVariables() {
        return this.previousReleaseVariables;
    }

    public Map<String, Variable> getPreviousFolderVariables() {
        return this.previousFolderVariables;
    }

    public Map<String, Variable> getPreviousGlobalVariables() {
        return this.previousGlobalVariables;
    }

    public VariablesHolderForScriptContext setPreviousReleaseVariables(Map<String, Variable> previousReleaseVariables) {
        this.previousReleaseVariables = previousReleaseVariables;
        return this;
    }

    public VariablesHolderForScriptContext setPreviousFolderVariables(Map<String, Variable> previousFolderVariables) {
        this.previousFolderVariables = previousFolderVariables;
        return this;
    }

    public VariablesHolderForScriptContext setPreviousGlobalVariables(Map<String, Variable> previousGlobalVariables) {
        this.previousGlobalVariables = previousGlobalVariables;
        return this;
    }

    public XlrScriptContext getScriptContext() {
        return this.scriptContext;
    }

    public VariablesHolderForScriptContext setScriptContext(XlrScriptContext scriptContext) {
        this.scriptContext = scriptContext;
        return this;
    }

    public DefaultScriptService.ScriptTaskResults createScriptTaskResults() {
        DefaultScriptService.VariablesUpdateHolder variablesUpdateHolder = new DefaultScriptService.VariablesUpdateHolder(ScriptServiceHelper.extractReleaseVariables(this.getScriptContext()), ScriptServiceHelper.extractGlobalVariables(this.getScriptContext()), ScriptServiceHelper.extractFolderVariables(this.getScriptContext()), this.getPreviousReleaseVariables(), this.getPreviousGlobalVariables(), this.getPreviousFolderVariables());
        return this.synchronizeCallback.apply(variablesUpdateHolder);
    }

    public Release getRelease() {
        return this.release;
    }

    public String getFolderId() {
        return this.folderId;
    }
}

