/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.kohsuke.github.AbuseLimitHandler;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubRateLimitChecker;
import org.kohsuke.github.HttpConnector;
import org.kohsuke.github.RateLimitChecker;
import org.kohsuke.github.RateLimitHandler;
import org.kohsuke.github.RateLimitTarget;
import org.kohsuke.github.extras.ImpatientHttpConnector;

public class GitHubBuilder
implements Cloneable {
    String endpoint = "https://api.github.com";
    String user;
    String password;
    String oauthToken;
    String jwtToken;
    private HttpConnector connector;
    private RateLimitHandler rateLimitHandler = RateLimitHandler.WAIT;
    private AbuseLimitHandler abuseLimitHandler = AbuseLimitHandler.WAIT;
    private GitHubRateLimitChecker rateLimitChecker = new GitHubRateLimitChecker();

    static GitHubBuilder fromCredentials() throws IOException {
        FileNotFoundException cause = null;
        GitHubBuilder builder = null;
        builder = GitHubBuilder.fromEnvironment();
        if (builder.oauthToken != null || builder.user != null || builder.jwtToken != null) {
            return builder;
        }
        try {
            builder = GitHubBuilder.fromPropertyFile();
            if (builder.oauthToken != null || builder.user != null || builder.jwtToken != null) {
                return builder;
            }
        }
        catch (FileNotFoundException e) {
            cause = e;
        }
        throw (IOException)new IOException("Failed to resolve credentials from ~/.github or the environment.").initCause(cause);
    }

    @Deprecated
    public static GitHubBuilder fromEnvironment(String loginVariableName, String passwordVariableName, String oauthVariableName) throws IOException {
        return GitHubBuilder.fromEnvironment(loginVariableName, passwordVariableName, oauthVariableName, "");
    }

    private static void loadIfSet(String envName, Properties p, String propName) {
        String v = System.getenv(envName);
        if (v != null) {
            p.put(propName, v);
        }
    }

    @Deprecated
    public static GitHubBuilder fromEnvironment(String loginVariableName, String passwordVariableName, String oauthVariableName, String endpointVariableName) throws IOException {
        Properties env = new Properties();
        GitHubBuilder.loadIfSet(loginVariableName, env, "login");
        GitHubBuilder.loadIfSet(passwordVariableName, env, "password");
        GitHubBuilder.loadIfSet(oauthVariableName, env, "oauth");
        GitHubBuilder.loadIfSet(endpointVariableName, env, "endpoint");
        return GitHubBuilder.fromProperties(env);
    }

    public static GitHubBuilder fromEnvironment() throws IOException {
        Properties props = new Properties();
        for (Map.Entry<String, String> e : System.getenv().entrySet()) {
            String name = e.getKey().toLowerCase(Locale.ENGLISH);
            if (name.startsWith("github_")) {
                name = name.substring(7);
            }
            props.put(name, e.getValue());
        }
        return GitHubBuilder.fromProperties(props);
    }

    public static GitHubBuilder fromPropertyFile() throws IOException {
        File homeDir = new File(System.getProperty("user.home"));
        File propertyFile = new File(homeDir, ".github");
        return GitHubBuilder.fromPropertyFile(propertyFile.getPath());
    }

    public static GitHubBuilder fromPropertyFile(String propertyFileName) throws IOException {
        Properties props = new Properties();
        FileInputStream in = null;
        try {
            in = new FileInputStream(propertyFileName);
            props.load(in);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        return GitHubBuilder.fromProperties(props);
    }

    public static GitHubBuilder fromProperties(Properties props) {
        GitHubBuilder self = new GitHubBuilder();
        self.withOAuthToken(props.getProperty("oauth"), props.getProperty("login"));
        self.withJwtToken(props.getProperty("jwt"));
        self.withPassword(props.getProperty("login"), props.getProperty("password"));
        self.withEndpoint(props.getProperty("endpoint", "https://api.github.com"));
        return self;
    }

    public GitHubBuilder withEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public GitHubBuilder withPassword(String user, String password) {
        this.user = user;
        this.password = password;
        return this;
    }

    public GitHubBuilder withOAuthToken(String oauthToken) {
        return this.withOAuthToken(oauthToken, null);
    }

    public GitHubBuilder withOAuthToken(String oauthToken, String user) {
        this.oauthToken = oauthToken;
        this.user = user;
        return this;
    }

    public GitHubBuilder withAppInstallationToken(String appInstallationToken) {
        return this.withOAuthToken(appInstallationToken, "");
    }

    public GitHubBuilder withJwtToken(String jwtToken) {
        this.jwtToken = jwtToken;
        return this;
    }

    public GitHubBuilder withConnector(HttpConnector connector) {
        this.connector = connector;
        return this;
    }

    public GitHubBuilder withRateLimitHandler(RateLimitHandler handler) {
        this.rateLimitHandler = handler;
        return this;
    }

    public GitHubBuilder withAbuseLimitHandler(AbuseLimitHandler handler) {
        this.abuseLimitHandler = handler;
        return this;
    }

    public GitHubBuilder withRateLimitChecker(@Nonnull RateLimitChecker coreRateLimitChecker) {
        return this.withRateLimitChecker(coreRateLimitChecker, RateLimitTarget.CORE);
    }

    public GitHubBuilder withRateLimitChecker(@Nonnull RateLimitChecker rateLimitChecker, @Nonnull RateLimitTarget rateLimitTarget) {
        this.rateLimitChecker = this.rateLimitChecker.with(rateLimitChecker, rateLimitTarget);
        return this;
    }

    public GitHubBuilder withProxy(Proxy p) {
        return this.withConnector(new ImpatientHttpConnector(url -> (HttpURLConnection)url.openConnection(p)));
    }

    public GitHub build() throws IOException {
        return new GitHub(this.endpoint, this.user, this.oauthToken, this.jwtToken, this.password, this.connector, this.rateLimitHandler, this.abuseLimitHandler, this.rateLimitChecker);
    }

    public GitHubBuilder clone() {
        try {
            return (GitHubBuilder)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Clone should be supported", e);
        }
    }
}

