/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.agrona.BitUtil;
import org.agrona.collections.CollectionUtil;
import org.agrona.collections.Hashing;

public class IntHashSet
extends AbstractSet<Integer>
implements Serializable {
    public static final int DEFAULT_INITIAL_CAPACITY = 8;
    static final int MISSING_VALUE = -1;
    private final boolean shouldAvoidAllocation;
    private boolean containsMissingValue;
    private final float loadFactor;
    private int resizeThreshold;
    private int sizeOfArrayValues;
    private int[] values;
    private IntIterator iterator;

    public IntHashSet() {
        this(8);
    }

    public IntHashSet(int proposedCapacity) {
        this(proposedCapacity, 0.55f, true);
    }

    public IntHashSet(int proposedCapacity, float loadFactor) {
        this(proposedCapacity, loadFactor, true);
    }

    public IntHashSet(int proposedCapacity, float loadFactor, boolean shouldAvoidAllocation) {
        CollectionUtil.validateLoadFactor(loadFactor);
        this.shouldAvoidAllocation = shouldAvoidAllocation;
        this.loadFactor = loadFactor;
        this.sizeOfArrayValues = 0;
        int capacity = BitUtil.findNextPositivePowerOfTwo(Math.max(8, proposedCapacity));
        this.resizeThreshold = (int)((float)capacity * loadFactor);
        this.values = new int[capacity];
        Arrays.fill(this.values, -1);
    }

    public float loadFactor() {
        return this.loadFactor;
    }

    public int capacity() {
        return this.values.length;
    }

    public int resizeThreshold() {
        return this.resizeThreshold;
    }

    @Override
    public boolean add(Integer value) {
        return this.add((int)value);
    }

    @Override
    public boolean add(int value) {
        if (value == -1) {
            boolean previousContainsMissingValue = this.containsMissingValue;
            this.containsMissingValue = true;
            return !previousContainsMissingValue;
        }
        int[] values = this.values;
        int mask = values.length - 1;
        int index = Hashing.hash(value, mask);
        while (values[index] != -1) {
            if (values[index] == value) {
                return false;
            }
            index = IntHashSet.next(index, mask);
        }
        values[index] = value;
        ++this.sizeOfArrayValues;
        if (this.sizeOfArrayValues > this.resizeThreshold) {
            this.increaseCapacity();
        }
        return true;
    }

    private void increaseCapacity() {
        int newCapacity = this.values.length * 2;
        if (newCapacity < 0) {
            throw new IllegalStateException("max capacity reached at size=" + this.size());
        }
        this.rehash(newCapacity);
    }

    private void rehash(int newCapacity) {
        int capacity = newCapacity;
        int mask = newCapacity - 1;
        this.resizeThreshold = (int)((float)newCapacity * this.loadFactor);
        int[] tempValues = new int[capacity];
        Arrays.fill(tempValues, -1);
        for (int value : this.values) {
            if (value == -1) continue;
            int newHash = Hashing.hash(value, mask);
            while (tempValues[newHash] != -1) {
                ++newHash;
                newHash &= mask;
            }
            tempValues[newHash] = value;
        }
        this.values = tempValues;
    }

    @Override
    public boolean remove(Object value) {
        return value instanceof Integer && this.remove((Integer)value);
    }

    public boolean remove(int value) {
        if (value == -1) {
            boolean previousContainsMissingValue = this.containsMissingValue;
            this.containsMissingValue = false;
            return previousContainsMissingValue;
        }
        int[] values = this.values;
        int mask = values.length - 1;
        int index = Hashing.hash(value, mask);
        while (values[index] != -1) {
            if (values[index] == value) {
                values[index] = -1;
                this.compactChain(index);
                --this.sizeOfArrayValues;
                return true;
            }
            index = IntHashSet.next(index, mask);
        }
        return false;
    }

    private static int next(int index, int mask) {
        return index + 1 & mask;
    }

    void compactChain(int deleteIndex) {
        int[] values = this.values;
        int mask = values.length - 1;
        int index = deleteIndex;
        while (values[index = IntHashSet.next(index, mask)] != -1) {
            int hash = Hashing.hash(values[index], mask);
            if ((index >= hash || hash > deleteIndex && deleteIndex > index) && (hash > deleteIndex || deleteIndex > index)) continue;
            values[deleteIndex] = values[index];
            values[index] = -1;
            deleteIndex = index;
        }
        return;
    }

    public void compact() {
        int idealCapacity = (int)Math.round((double)this.size() * (1.0 / (double)this.loadFactor));
        this.rehash(BitUtil.findNextPositivePowerOfTwo(Math.max(8, idealCapacity)));
    }

    @Override
    public boolean contains(Object value) {
        return value instanceof Integer && this.contains((Integer)value);
    }

    public boolean contains(int value) {
        if (value == -1) {
            return this.containsMissingValue;
        }
        int[] values = this.values;
        int mask = values.length - 1;
        int index = Hashing.hash(value, mask);
        while (values[index] != -1) {
            if (values[index] == value) {
                return true;
            }
            index = IntHashSet.next(index, mask);
        }
        return false;
    }

    @Override
    public int size() {
        return this.sizeOfArrayValues + (this.containsMissingValue ? 1 : 0);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void clear() {
        if (this.size() > 0) {
            Arrays.fill(this.values, -1);
            this.sizeOfArrayValues = 0;
            this.containsMissingValue = false;
        }
    }

    @Override
    public boolean addAll(Collection<? extends Integer> coll) {
        boolean added = false;
        for (Integer n : coll) {
            added |= this.add(n);
        }
        return added;
    }

    public boolean addAll(IntHashSet coll) {
        boolean acc = false;
        for (int value : coll.values) {
            if (value == -1) continue;
            acc |= this.add(value);
        }
        if (coll.containsMissingValue) {
            acc |= this.add(-1);
        }
        return acc;
    }

    public boolean containsAll(IntHashSet other) {
        for (int value : other.values) {
            if (value == -1 || this.contains(value)) continue;
            return false;
        }
        return !other.containsMissingValue || this.containsMissingValue;
    }

    public IntHashSet difference(IntHashSet other) {
        IntHashSet difference = null;
        for (int value : this.values) {
            if (value == -1 || other.contains(value)) continue;
            if (difference == null) {
                difference = new IntHashSet();
            }
            difference.add(value);
        }
        if (other.containsMissingValue && !this.containsMissingValue) {
            if (difference == null) {
                difference = new IntHashSet();
            }
            difference.add(-1);
        }
        return difference;
    }

    @Override
    public boolean removeAll(Collection<?> coll) {
        boolean removed = false;
        for (Object value : coll) {
            removed |= this.remove(value);
        }
        return removed;
    }

    public boolean removeAll(IntHashSet coll) {
        boolean acc = false;
        for (int value : coll.values) {
            if (value == -1) continue;
            acc |= this.remove(value);
        }
        if (coll.containsMissingValue) {
            acc |= this.remove(-1);
        }
        return acc;
    }

    public IntIterator iterator() {
        IntIterator iterator = this.iterator;
        if (null == iterator) {
            iterator = new IntIterator();
            if (this.shouldAvoidAllocation) {
                this.iterator = iterator;
            }
        }
        return iterator.reset();
    }

    public void copy(IntHashSet that) {
        if (this.values.length != that.values.length) {
            throw new IllegalArgumentException("cannot copy object: masks not equal");
        }
        System.arraycopy(that.values, 0, this.values, 0, this.values.length);
        this.sizeOfArrayValues = that.sizeOfArrayValues;
        this.containsMissingValue = that.containsMissingValue;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        for (int value : this.values) {
            if (value == -1) continue;
            sb.append(value).append(", ");
        }
        if (this.containsMissingValue) {
            sb.append(-1).append(", ");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 2);
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        Class<Integer> componentType = a.getClass().getComponentType();
        if (!componentType.isAssignableFrom(Integer.class)) {
            throw new ArrayStoreException("cannot store Integers in array of type " + componentType);
        }
        int size = this.size();
        Object[] arrayCopy = a.length >= size ? a : (Object[])Array.newInstance(componentType, size);
        this.copyValues(arrayCopy);
        return arrayCopy;
    }

    @Override
    public Object[] toArray() {
        Object[] arrayCopy = new Object[this.size()];
        this.copyValues(arrayCopy);
        return arrayCopy;
    }

    private void copyValues(Object[] arrayCopy) {
        int[] values;
        int i = 0;
        for (int value : values = this.values) {
            if (-1 == value) continue;
            arrayCopy[i++] = value;
        }
        if (this.containsMissingValue) {
            arrayCopy[this.sizeOfArrayValues] = -1;
        }
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof IntHashSet) {
            IntHashSet otherSet = (IntHashSet)other;
            return otherSet.containsMissingValue == this.containsMissingValue && otherSet.sizeOfArrayValues == this.sizeOfArrayValues && this.containsAll(otherSet);
        }
        if (!(other instanceof Set)) {
            return false;
        }
        Set c = (Set)other;
        if (c.size() != this.size()) {
            return false;
        }
        try {
            return this.containsAll(c);
        }
        catch (ClassCastException | NullPointerException ignore) {
            return false;
        }
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        for (int value : this.values) {
            if (value == -1) continue;
            hashCode += Integer.hashCode(value);
        }
        if (this.containsMissingValue) {
            hashCode += Integer.hashCode(-1);
        }
        return hashCode;
    }

    public final class IntIterator
    implements Iterator<Integer>,
    Serializable {
        private int remaining;
        private int positionCounter;
        private int stopCounter;
        private boolean isPositionValid = false;

        IntIterator reset() {
            int length;
            this.remaining = IntHashSet.this.size();
            int[] values = IntHashSet.this.values;
            int i = length = values.length;
            if (values[length - 1] != -1) {
                for (i = 0; i < length && values[i] != -1; ++i) {
                }
            }
            this.stopCounter = i;
            this.positionCounter = i + length;
            this.isPositionValid = false;
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.remaining > 0;
        }

        public int remaining() {
            return this.remaining;
        }

        @Override
        public Integer next() {
            return this.nextValue();
        }

        public int nextValue() {
            if (this.remaining == 1 && IntHashSet.this.containsMissingValue) {
                this.remaining = 0;
                this.isPositionValid = true;
                return -1;
            }
            this.findNext();
            int[] values = IntHashSet.this.values;
            return values[this.position(values)];
        }

        @Override
        public void remove() {
            if (this.isPositionValid) {
                if (0 == this.remaining && IntHashSet.this.containsMissingValue) {
                    IntHashSet.this.containsMissingValue = false;
                } else {
                    int[] values = IntHashSet.this.values;
                    int position = this.position(values);
                    values[position] = -1;
                    --IntHashSet.this.sizeOfArrayValues;
                    IntHashSet.this.compactChain(position);
                }
            } else {
                throw new IllegalStateException();
            }
            this.isPositionValid = false;
        }

        private void findNext() {
            int[] values = IntHashSet.this.values;
            int mask = values.length - 1;
            this.isPositionValid = true;
            for (int i = this.positionCounter - 1; i >= this.stopCounter; --i) {
                int index = i & mask;
                if (values[index] == -1) continue;
                this.positionCounter = i;
                --this.remaining;
                return;
            }
            this.isPositionValid = false;
            throw new NoSuchElementException();
        }

        private int position(int[] values) {
            return this.positionCounter & values.length - 1;
        }
    }
}

