/*
 * Decompiled with CFR 0.152.
 */
package liquibase.command.core;

import java.util.ArrayList;
import java.util.Date;
import java.util.UUID;
import liquibase.CatalogAndSchema;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.Liquibase;
import liquibase.Scope;
import liquibase.changelog.ChangeLogHistoryService;
import liquibase.changelog.ChangeLogHistoryServiceFactory;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.command.AbstractCommand;
import liquibase.command.CommandResult;
import liquibase.command.CommandValidationErrors;
import liquibase.configuration.HubConfiguration;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.executor.ExecutorService;
import liquibase.hub.HubService;
import liquibase.hub.HubServiceFactory;
import liquibase.hub.HubUpdater;
import liquibase.hub.LiquibaseHubException;
import liquibase.hub.model.HubChangeLog;
import liquibase.lockservice.LockService;
import liquibase.lockservice.LockServiceFactory;
import liquibase.logging.Logger;
import liquibase.util.StringUtil;

public class DropAllCommand
extends AbstractCommand<CommandResult> {
    private Database database;
    private CatalogAndSchema[] schemas;
    private String changeLogFile;
    private UUID hubConnectionId;
    private Liquibase liquibase;

    @Override
    public String getName() {
        return "dropAll";
    }

    @Override
    public CommandValidationErrors validate() {
        return new CommandValidationErrors(this);
    }

    public void setLiquibase(Liquibase liquibase) {
        this.liquibase = liquibase;
    }

    public Database getDatabase() {
        return this.database;
    }

    public void setDatabase(Database database) {
        this.database = database;
    }

    public CatalogAndSchema[] getSchemas() {
        return this.schemas;
    }

    public void setSchemas(CatalogAndSchema[] schemas) {
        this.schemas = schemas;
    }

    public DropAllCommand setSchemas(String ... schemas) {
        if (schemas == null || schemas.length == 0 || schemas[0] == null) {
            this.schemas = null;
            return this;
        }
        schemas = StringUtil.join(schemas, ",").split("\\s*,\\s*");
        ArrayList<CatalogAndSchema> finalList = new ArrayList<CatalogAndSchema>();
        for (String schema : schemas) {
            finalList.add(new CatalogAndSchema(null, schema).customize(this.database));
        }
        this.schemas = finalList.toArray(new CatalogAndSchema[finalList.size()]);
        return this;
    }

    public String getChangeLogFile() {
        return this.changeLogFile;
    }

    public void setChangeLogFile(String changeLogFile) {
        this.changeLogFile = changeLogFile;
    }

    public void setHubConnectionId(String hubConnectionIdString) {
        if (hubConnectionIdString == null) {
            return;
        }
        this.hubConnectionId = UUID.fromString(hubConnectionIdString);
    }

    @Override
    protected CommandResult run() throws Exception {
        LockService lockService = LockServiceFactory.getInstance().getLockService(this.database);
        Logger log = Scope.getCurrentScope().getLog(this.getClass());
        HubUpdater hubUpdater = null;
        try {
            lockService.waitForLock();
            boolean doSyncHub = true;
            DatabaseChangeLog changeLog = null;
            if (StringUtil.isNotEmpty(this.changeLogFile)) {
                changeLog = this.liquibase.getDatabaseChangeLog();
                hubUpdater = new HubUpdater(new Date(), changeLog, this.database);
                hubUpdater.register(this.changeLogFile);
                doSyncHub = this.checkForRegisteredChangeLog(changeLog);
            }
            for (CatalogAndSchema schema : this.schemas) {
                log.info("Dropping Database Objects in schema: " + schema);
                this.checkLiquibaseTables(false, null, new Contexts(), new LabelExpression());
                this.database.dropDatabaseObjects(schema);
            }
            if (hubUpdater != null && (doSyncHub || this.hubConnectionId != null)) {
                hubUpdater.syncHub(this.changeLogFile, this.database, changeLog, this.hubConnectionId);
            }
        }
        catch (DatabaseException e2) {
            throw e2;
        }
        catch (Exception e3) {
            throw new DatabaseException(e3);
        }
        finally {
            lockService.releaseLock();
            lockService.destroy();
            this.resetServices();
        }
        return new CommandResult("All objects dropped from " + this.database.getConnection().getConnectionUserName() + "@" + this.database.getConnection().getURL());
    }

    private boolean checkForRegisteredChangeLog(DatabaseChangeLog changeLog) throws LiquibaseHubException {
        HubChangeLog hubChangeLog;
        Logger log = Scope.getCurrentScope().getLog(this.getClass());
        HubConfiguration hubConfiguration = LiquibaseConfiguration.getInstance().getConfiguration(HubConfiguration.class);
        String apiKey = StringUtil.trimToNull(hubConfiguration.getLiquibaseHubApiKey());
        String hubMode = StringUtil.trimToNull(hubConfiguration.getLiquibaseHubMode());
        String changeLogId = changeLog.getChangeLogId();
        HubServiceFactory hubServiceFactory = Scope.getCurrentScope().getSingleton(HubServiceFactory.class);
        if (apiKey == null || hubMode.equals("off") || !hubServiceFactory.isOnline()) {
            return false;
        }
        HubService service = Scope.getCurrentScope().getSingleton(HubServiceFactory.class).getService();
        HubChangeLog hubChangeLog2 = hubChangeLog = changeLogId != null ? service.getHubChangeLog(UUID.fromString(changeLogId)) : null;
        if (changeLogId != null && hubChangeLog != null) {
            return true;
        }
        String message = "The changelog file specified is not registered with any Liquibase Hub project,\nso the results will not be recorded in Liquibase Hub.\nTo register the changelog with your Hub Project run 'liquibase registerchangelog'.\nLearn more at https://hub.liquibase.com.";
        Scope.getCurrentScope().getUI().sendMessage("WARNING: " + message);
        log.warning(message);
        return false;
    }

    protected void checkLiquibaseTables(boolean updateExistingNullChecksums, DatabaseChangeLog databaseChangeLog, Contexts contexts, LabelExpression labelExpression) throws LiquibaseException {
        ChangeLogHistoryService changeLogHistoryService = ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(this.database);
        changeLogHistoryService.init();
        if (updateExistingNullChecksums) {
            changeLogHistoryService.upgradeChecksums(databaseChangeLog, contexts, labelExpression);
        }
        LockServiceFactory.getInstance().getLockService(this.database).init();
    }

    protected void resetServices() {
        LockServiceFactory.getInstance().resetAll();
        ChangeLogHistoryServiceFactory.getInstance().resetAll();
        Scope.getCurrentScope().getSingleton(ExecutorService.class).reset();
    }
}

