/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plumbing;

import com.xebialabs.deployit.engine.spi.services.RepositoryFactory;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plumbing.AbstractConfigurationItemReaderWriter;
import com.xebialabs.deployit.plumbing.XlrFormatFactory;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xltype.serialization.CiReader;
import com.xebialabs.xltype.serialization.CiWriter;
import com.xebialabs.xltype.serialization.ConfigurationItemConverter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Provider
@Produces(value={"application/json", "application/xml"})
@Consumes(value={"application/json", "application/xml"})
public class ConfigurationItemReaderWriter
extends AbstractConfigurationItemReaderWriter
implements MessageBodyReader<ConfigurationItem>,
MessageBodyWriter<ConfigurationItem> {
    @Autowired
    public ConfigurationItemReaderWriter(RepositoryFactory repositoryFactory, XlrFormatFactory formats, ConfigurationRepository configurationRepository) {
        super(repositoryFactory, formats, configurationRepository);
    }

    public void writeTo(ConfigurationItem configurationItem, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        ConfigurationItemConverter converter = this.createConverter();
        PrintWriter outputWriter = new PrintWriter(entityStream);
        CiWriter writer = this.formats.createCiWriter(mediaType, outputWriter);
        converter.writeCi(configurationItem, writer, Integer.MAX_VALUE);
        outputWriter.flush();
    }

    public ConfigurationItem readFrom(Class<ConfigurationItem> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        ConfigurationItemConverter converter = this.createConverter();
        CiReader reader = this.formats.createCiReader(entityStream, mediaType);
        ConfigurationItem result = converter.readCi(reader);
        converter.resolveReferences(this.repository);
        return result;
    }

    public long getSize(ConfigurationItem configurationItem, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }
}

