/*
 * Decompiled with CFR 0.152.
 */
package akka.pattern;

import akka.actor.OneForOneStrategy;
import akka.actor.Props;
import akka.actor.Props$;
import akka.actor.SupervisorStrategy;
import akka.actor.SupervisorStrategy$;
import akka.pattern.AutoReset;
import akka.pattern.BackoffOnFailureOptions;
import akka.pattern.BackoffOnStopOptions;
import akka.pattern.BackoffOptions;
import akka.pattern.BackoffSupervisor$GetCurrentChild$;
import akka.pattern.BackoffSupervisor$GetRestartCount$;
import akka.pattern.BackoffSupervisor$Reset$;
import akka.pattern.internal.BackoffOnStopSupervisor;
import akka.util.JavaDurationConverters$;
import akka.util.JavaDurationConverters$JavaDurationOps$;
import java.io.Serializable;
import java.util.concurrent.ThreadLocalRandom;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.util.Try$;

public final class BackoffSupervisor$ {
    public static final BackoffSupervisor$ MODULE$ = new BackoffSupervisor$();

    public Props props(Props childProps, String childName, FiniteDuration minBackoff, FiniteDuration maxBackoff, double randomFactor) {
        return this.propsWithSupervisorStrategy(childProps, childName, minBackoff, maxBackoff, randomFactor, SupervisorStrategy$.MODULE$.defaultStrategy());
    }

    public Props props(Props childProps, String childName, FiniteDuration minBackoff, FiniteDuration maxBackoff, double randomFactor, int maxNrOfRetries) {
        SupervisorStrategy supervisorStrategy;
        SupervisorStrategy supervisorStrategy2 = SupervisorStrategy$.MODULE$.defaultStrategy();
        if (supervisorStrategy2 instanceof OneForOneStrategy) {
            OneForOneStrategy oneForOneStrategy = (OneForOneStrategy)supervisorStrategy2;
            supervisorStrategy = oneForOneStrategy.withMaxNrOfRetries(maxNrOfRetries);
        } else {
            supervisorStrategy = supervisorStrategy2;
        }
        SupervisorStrategy supervisionStrategy = supervisorStrategy;
        return this.propsWithSupervisorStrategy(childProps, childName, minBackoff, maxBackoff, randomFactor, supervisionStrategy);
    }

    public Props props(Props childProps, String childName, java.time.Duration minBackoff, java.time.Duration maxBackoff, double randomFactor) {
        return this.props(childProps, childName, JavaDurationConverters$JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(minBackoff)), JavaDurationConverters$JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(maxBackoff)), randomFactor);
    }

    public Props props(Props childProps, String childName, java.time.Duration minBackoff, java.time.Duration maxBackoff, double randomFactor, int maxNrOfRetries) {
        return this.props(childProps, childName, JavaDurationConverters$JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(minBackoff)), JavaDurationConverters$JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(maxBackoff)), randomFactor, maxNrOfRetries);
    }

    public Props propsWithSupervisorStrategy(Props childProps, String childName, FiniteDuration minBackoff, FiniteDuration maxBackoff, double randomFactor, SupervisorStrategy strategy) {
        Predef$.MODULE$.require(minBackoff.$greater((Object)Duration$.MODULE$.Zero()), (Function0 & Serializable)() -> "minBackoff must be > 0");
        Predef$.MODULE$.require(maxBackoff.$greater$eq((Object)minBackoff), (Function0 & Serializable)() -> "maxBackoff must be >= minBackoff");
        Predef$.MODULE$.require(0.0 <= randomFactor && randomFactor <= 1.0, (Function0 & Serializable)() -> "randomFactor must be between 0.0 and 1.0");
        return Props$.MODULE$.apply((Function0 & Serializable)() -> new BackoffOnStopSupervisor(childProps, childName, minBackoff, maxBackoff, new AutoReset(minBackoff), randomFactor, strategy, (Option<Object>)None$.MODULE$, (Option<Function1<Object, Object>>)None$.MODULE$), ClassTag$.MODULE$.apply(BackoffOnStopSupervisor.class));
    }

    public Props propsWithSupervisorStrategy(Props childProps, String childName, java.time.Duration minBackoff, java.time.Duration maxBackoff, double randomFactor, SupervisorStrategy strategy) {
        return this.propsWithSupervisorStrategy(childProps, childName, JavaDurationConverters$JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(minBackoff)), JavaDurationConverters$JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(maxBackoff)), randomFactor, strategy);
    }

    public Props props(BackoffOptions options) {
        return options.props();
    }

    public Props props(BackoffOnStopOptions options) {
        return options.props();
    }

    public Props props(BackoffOnFailureOptions options) {
        return options.props();
    }

    public BackoffSupervisor$GetCurrentChild$ getCurrentChild() {
        return BackoffSupervisor$GetCurrentChild$.MODULE$;
    }

    public BackoffSupervisor$Reset$ reset() {
        return BackoffSupervisor$Reset$.MODULE$;
    }

    public BackoffSupervisor$GetRestartCount$ getRestartCount() {
        return BackoffSupervisor$GetRestartCount$.MODULE$;
    }

    public FiniteDuration calculateDelay(int restartCount, FiniteDuration minBackoff, FiniteDuration maxBackoff, double randomFactor) {
        FiniteDuration finiteDuration;
        double rnd = 1.0 + ThreadLocalRandom.current().nextDouble() * randomFactor;
        Duration calculatedDuration = (Duration)Try$.MODULE$.apply((Function0 & Serializable)() -> maxBackoff.min(minBackoff.$times(package$.MODULE$.pow(2.0, (double)restartCount))).$times(rnd)).getOrElse((Function0 & Serializable)() -> maxBackoff);
        Duration duration = calculatedDuration;
        FiniteDuration finiteDuration2 = duration instanceof FiniteDuration ? (finiteDuration = (FiniteDuration)duration) : maxBackoff;
        return finiteDuration2;
    }

    private BackoffSupervisor$() {
    }
}

