/*
 * Decompiled with CFR 0.152.
 */
package org.prevayler.implementation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.util.Date;
import org.prevayler.foundation.Chunk;
import org.prevayler.foundation.serialization.Serializer;
import org.prevayler.implementation.TransactionCapsule;
import org.prevayler.implementation.TransactionWithQueryCapsule;

public abstract class Capsule
implements Serializable {
    private final byte[] _serialized;
    private transient Object _directTransaction = null;

    protected Capsule(Object transaction, Serializer journalSerializer, boolean transactionDeepCopyMode) {
        if (!transactionDeepCopyMode) {
            this._directTransaction = transaction;
        }
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            journalSerializer.writeObject(bytes, transaction);
            this._serialized = bytes.toByteArray();
        }
        catch (Exception exception) {
            throw new Error("Unable to serialize transaction", exception);
        }
    }

    protected Capsule(byte[] serialized) {
        this._serialized = serialized;
    }

    public byte[] serialized() {
        return this._serialized;
    }

    public Object deserialize(Serializer journalSerializer) {
        try {
            return journalSerializer.readObject(new ByteArrayInputStream(this._serialized));
        }
        catch (Exception exception) {
            throw new Error("Unable to deserialize transaction", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeOn(Object prevalentSystem, Date executionTime, Serializer journalSerializer) {
        Object transaction = this._directTransaction != null ? this._directTransaction : this.deserialize(journalSerializer);
        Object object = prevalentSystem;
        synchronized (object) {
            this.justExecute(transaction, prevalentSystem, executionTime);
        }
    }

    protected abstract void justExecute(Object var1, Object var2, Date var3);

    public abstract Capsule cleanCopy();

    Chunk toChunk() {
        Chunk chunk = new Chunk(this._serialized);
        chunk.setParameter("withQuery", String.valueOf(this instanceof TransactionWithQueryCapsule));
        return chunk;
    }

    static Capsule fromChunk(Chunk chunk) {
        boolean withQuery = Boolean.valueOf(chunk.getParameter("withQuery"));
        if (withQuery) {
            return new TransactionWithQueryCapsule(chunk.getBytes());
        }
        return new TransactionCapsule(chunk.getBytes());
    }
}

