/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SingleChildResultSetNode;

class ScrollInsensitiveResultSetNode
extends SingleChildResultSetNode {
    ScrollInsensitiveResultSetNode(ResultSetNode resultSetNode, ResultColumnList resultColumnList, Properties properties, ContextManager contextManager) {
        super(resultSetNode, properties, contextManager);
        this.setResultColumns(resultColumnList);
    }

    @Override
    void generate(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        this.assignResultSetNumber();
        this.setCostEstimate(this.childResult.getFinalCostEstimate());
        int n = activationClassBuilder.addItem(this.makeResultDescription());
        activationClassBuilder.pushGetResultSetFactoryExpression(methodBuilder);
        this.childResult.generate(activationClassBuilder, methodBuilder);
        activationClassBuilder.pushThisAsActivation(methodBuilder);
        methodBuilder.push(this.getResultSetNumber());
        methodBuilder.push(this.getResultColumns().size());
        methodBuilder.pushThis();
        methodBuilder.callMethod((short)182, "org.apache.derby.impl.sql.execute.BaseActivation", "getScrollable", "boolean", 0);
        methodBuilder.push(this.getCostEstimate().rowCount());
        methodBuilder.push(this.getCostEstimate().getEstimatedCost());
        methodBuilder.callMethod((short)185, null, "getScrollInsensitiveResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", 7);
    }
}

