/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.jwt;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.RemoteKeySourceException;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.jwk.source.RemoteJWKSet;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.JWSVerificationKeySelector;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jose.util.Resource;
import com.nimbusds.jose.util.ResourceRetriever;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.jwt.proc.DefaultJWTProcessor;
import com.nimbusds.jwt.proc.JWTProcessor;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.crypto.SecretKey;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.security.oauth2.core.AbstractOAuth2Token;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidatorResult;
import org.springframework.security.oauth2.jose.jws.MacAlgorithm;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.security.oauth2.jwt.BadJwtException;
import org.springframework.security.oauth2.jwt.JWSAlgorithmMapJWSKeySelector;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtException;
import org.springframework.security.oauth2.jwt.JwtValidationException;
import org.springframework.security.oauth2.jwt.JwtValidators;
import org.springframework.security.oauth2.jwt.MappedJwtClaimSetConverter;
import org.springframework.security.oauth2.jwt.SingleKeyJWSKeySelector;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

public final class NimbusJwtDecoder
implements JwtDecoder {
    private static final String DECODING_ERROR_MESSAGE_TEMPLATE = "An error occurred while attempting to decode the Jwt: %s";
    private final JWTProcessor<SecurityContext> jwtProcessor;
    private Converter<Map<String, Object>, Map<String, Object>> claimSetConverter = MappedJwtClaimSetConverter.withDefaults(Collections.emptyMap());
    private OAuth2TokenValidator<Jwt> jwtValidator = JwtValidators.createDefault();

    public NimbusJwtDecoder(JWTProcessor<SecurityContext> jwtProcessor) {
        Assert.notNull(jwtProcessor, (String)"jwtProcessor cannot be null");
        this.jwtProcessor = jwtProcessor;
    }

    public void setJwtValidator(OAuth2TokenValidator<Jwt> jwtValidator) {
        Assert.notNull(jwtValidator, (String)"jwtValidator cannot be null");
        this.jwtValidator = jwtValidator;
    }

    public void setClaimSetConverter(Converter<Map<String, Object>, Map<String, Object>> claimSetConverter) {
        Assert.notNull(claimSetConverter, (String)"claimSetConverter cannot be null");
        this.claimSetConverter = claimSetConverter;
    }

    @Override
    public Jwt decode(String token) throws JwtException {
        JWT jwt = this.parse(token);
        if (jwt instanceof PlainJWT) {
            throw new BadJwtException("Unsupported algorithm of " + jwt.getHeader().getAlgorithm());
        }
        Jwt createdJwt = this.createJwt(token, jwt);
        return this.validateJwt(createdJwt);
    }

    private JWT parse(String token) {
        try {
            return JWTParser.parse((String)token);
        }
        catch (Exception ex) {
            throw new BadJwtException(String.format(DECODING_ERROR_MESSAGE_TEMPLATE, ex.getMessage()), ex);
        }
    }

    private Jwt createJwt(String token, JWT parsedJwt) {
        try {
            JWTClaimsSet jwtClaimsSet = this.jwtProcessor.process(parsedJwt, null);
            LinkedHashMap headers = new LinkedHashMap(parsedJwt.getHeader().toJSONObject());
            Map claims = (Map)this.claimSetConverter.convert((Object)jwtClaimsSet.getClaims());
            return Jwt.withTokenValue(token).headers(h -> h.putAll(headers)).claims(c -> c.putAll(claims)).build();
        }
        catch (RemoteKeySourceException ex) {
            if (ex.getCause() instanceof ParseException) {
                throw new JwtException(String.format(DECODING_ERROR_MESSAGE_TEMPLATE, "Malformed Jwk set"));
            }
            throw new JwtException(String.format(DECODING_ERROR_MESSAGE_TEMPLATE, ex.getMessage()), ex);
        }
        catch (JOSEException ex) {
            throw new JwtException(String.format(DECODING_ERROR_MESSAGE_TEMPLATE, ex.getMessage()), ex);
        }
        catch (Exception ex) {
            if (ex.getCause() instanceof ParseException) {
                throw new BadJwtException(String.format(DECODING_ERROR_MESSAGE_TEMPLATE, "Malformed payload"));
            }
            throw new BadJwtException(String.format(DECODING_ERROR_MESSAGE_TEMPLATE, ex.getMessage()), ex);
        }
    }

    private Jwt validateJwt(Jwt jwt) {
        OAuth2TokenValidatorResult result = this.jwtValidator.validate((AbstractOAuth2Token)jwt);
        if (result.hasErrors()) {
            Collection errors = result.getErrors();
            String validationErrorString = "Unable to validate Jwt";
            for (OAuth2Error oAuth2Error : errors) {
                if (StringUtils.isEmpty((Object)oAuth2Error.getDescription())) continue;
                validationErrorString = String.format(DECODING_ERROR_MESSAGE_TEMPLATE, oAuth2Error.getDescription());
                break;
            }
            throw new JwtValidationException(validationErrorString, result.getErrors());
        }
        return jwt;
    }

    public static JwkSetUriJwtDecoderBuilder withJwkSetUri(String jwkSetUri) {
        return new JwkSetUriJwtDecoderBuilder(jwkSetUri);
    }

    public static PublicKeyJwtDecoderBuilder withPublicKey(RSAPublicKey key) {
        return new PublicKeyJwtDecoderBuilder(key);
    }

    public static SecretKeyJwtDecoderBuilder withSecretKey(SecretKey secretKey) {
        return new SecretKeyJwtDecoderBuilder(secretKey);
    }

    public static final class SecretKeyJwtDecoderBuilder {
        private final SecretKey secretKey;
        private JWSAlgorithm jwsAlgorithm = JWSAlgorithm.HS256;

        private SecretKeyJwtDecoderBuilder(SecretKey secretKey) {
            Assert.notNull((Object)secretKey, (String)"secretKey cannot be null");
            this.secretKey = secretKey;
        }

        public SecretKeyJwtDecoderBuilder macAlgorithm(MacAlgorithm macAlgorithm) {
            Assert.notNull((Object)macAlgorithm, (String)"macAlgorithm cannot be null");
            this.jwsAlgorithm = JWSAlgorithm.parse((String)macAlgorithm.getName());
            return this;
        }

        public NimbusJwtDecoder build() {
            return new NimbusJwtDecoder(this.processor());
        }

        JWTProcessor<SecurityContext> processor() {
            SingleKeyJWSKeySelector jwsKeySelector = new SingleKeyJWSKeySelector(this.jwsAlgorithm, this.secretKey);
            DefaultJWTProcessor jwtProcessor = new DefaultJWTProcessor();
            jwtProcessor.setJWSKeySelector(jwsKeySelector);
            jwtProcessor.setJWTClaimsSetVerifier((claims, context) -> {});
            return jwtProcessor;
        }
    }

    public static final class PublicKeyJwtDecoderBuilder {
        private JWSAlgorithm jwsAlgorithm;
        private RSAPublicKey key;

        private PublicKeyJwtDecoderBuilder(RSAPublicKey key) {
            Assert.notNull((Object)key, (String)"key cannot be null");
            this.jwsAlgorithm = JWSAlgorithm.RS256;
            this.key = key;
        }

        public PublicKeyJwtDecoderBuilder signatureAlgorithm(SignatureAlgorithm signatureAlgorithm) {
            Assert.notNull((Object)signatureAlgorithm, (String)"signatureAlgorithm cannot be null");
            this.jwsAlgorithm = JWSAlgorithm.parse((String)signatureAlgorithm.getName());
            return this;
        }

        JWTProcessor<SecurityContext> processor() {
            if (!JWSAlgorithm.Family.RSA.contains((Object)this.jwsAlgorithm)) {
                throw new IllegalStateException("The provided key is of type RSA; however the signature algorithm is of some other type: " + this.jwsAlgorithm + ". Please indicate one of RS256, RS384, or RS512.");
            }
            SingleKeyJWSKeySelector jwsKeySelector = new SingleKeyJWSKeySelector(this.jwsAlgorithm, this.key);
            DefaultJWTProcessor jwtProcessor = new DefaultJWTProcessor();
            jwtProcessor.setJWSKeySelector(jwsKeySelector);
            jwtProcessor.setJWTClaimsSetVerifier((claims, context) -> {});
            return jwtProcessor;
        }

        public NimbusJwtDecoder build() {
            return new NimbusJwtDecoder(this.processor());
        }
    }

    public static final class JwkSetUriJwtDecoderBuilder {
        private String jwkSetUri;
        private Set<SignatureAlgorithm> signatureAlgorithms = new HashSet<SignatureAlgorithm>();
        private RestOperations restOperations = new RestTemplate();

        private JwkSetUriJwtDecoderBuilder(String jwkSetUri) {
            Assert.hasText((String)jwkSetUri, (String)"jwkSetUri cannot be empty");
            this.jwkSetUri = jwkSetUri;
        }

        public JwkSetUriJwtDecoderBuilder jwsAlgorithm(SignatureAlgorithm signatureAlgorithm) {
            Assert.notNull((Object)signatureAlgorithm, (String)"signatureAlgorithm cannot be null");
            this.signatureAlgorithms.add(signatureAlgorithm);
            return this;
        }

        public JwkSetUriJwtDecoderBuilder jwsAlgorithms(Consumer<Set<SignatureAlgorithm>> signatureAlgorithmsConsumer) {
            Assert.notNull(signatureAlgorithmsConsumer, (String)"signatureAlgorithmsConsumer cannot be null");
            signatureAlgorithmsConsumer.accept(this.signatureAlgorithms);
            return this;
        }

        public JwkSetUriJwtDecoderBuilder restOperations(RestOperations restOperations) {
            Assert.notNull((Object)restOperations, (String)"restOperations cannot be null");
            this.restOperations = restOperations;
            return this;
        }

        JWSKeySelector<SecurityContext> jwsKeySelector(JWKSource<SecurityContext> jwkSource) {
            if (this.signatureAlgorithms.isEmpty()) {
                return new JWSVerificationKeySelector(JWSAlgorithm.RS256, jwkSource);
            }
            if (this.signatureAlgorithms.size() == 1) {
                JWSAlgorithm jwsAlgorithm = JWSAlgorithm.parse((String)this.signatureAlgorithms.iterator().next().getName());
                return new JWSVerificationKeySelector(jwsAlgorithm, jwkSource);
            }
            HashMap jwsKeySelectors = new HashMap();
            for (SignatureAlgorithm signatureAlgorithm : this.signatureAlgorithms) {
                JWSAlgorithm jwsAlg = JWSAlgorithm.parse((String)signatureAlgorithm.getName());
                jwsKeySelectors.put(jwsAlg, new JWSVerificationKeySelector(jwsAlg, jwkSource));
            }
            return new JWSAlgorithmMapJWSKeySelector<SecurityContext>(jwsKeySelectors);
        }

        JWTProcessor<SecurityContext> processor() {
            RestOperationsResourceRetriever jwkSetRetriever = new RestOperationsResourceRetriever(this.restOperations);
            RemoteJWKSet jwkSource = new RemoteJWKSet(JwkSetUriJwtDecoderBuilder.toURL(this.jwkSetUri), (ResourceRetriever)jwkSetRetriever);
            DefaultJWTProcessor jwtProcessor = new DefaultJWTProcessor();
            jwtProcessor.setJWSKeySelector(this.jwsKeySelector((JWKSource<SecurityContext>)jwkSource));
            jwtProcessor.setJWTClaimsSetVerifier((claims, context) -> {});
            return jwtProcessor;
        }

        public NimbusJwtDecoder build() {
            return new NimbusJwtDecoder(this.processor());
        }

        private static URL toURL(String url) {
            try {
                return new URL(url);
            }
            catch (MalformedURLException ex) {
                throw new IllegalArgumentException("Invalid JWK Set URL \"" + url + "\" : " + ex.getMessage(), ex);
            }
        }

        private static class RestOperationsResourceRetriever
        implements ResourceRetriever {
            private static final MediaType APPLICATION_JWK_SET_JSON = new MediaType("application", "jwk-set+json");
            private final RestOperations restOperations;

            RestOperationsResourceRetriever(RestOperations restOperations) {
                Assert.notNull((Object)restOperations, (String)"restOperations cannot be null");
                this.restOperations = restOperations;
            }

            public Resource retrieveResource(URL url) throws IOException {
                ResponseEntity response;
                HttpHeaders headers = new HttpHeaders();
                headers.setAccept(Arrays.asList(MediaType.APPLICATION_JSON, APPLICATION_JWK_SET_JSON));
                try {
                    RequestEntity request = new RequestEntity((MultiValueMap)headers, HttpMethod.GET, url.toURI());
                    response = this.restOperations.exchange(request, String.class);
                }
                catch (Exception ex) {
                    throw new IOException(ex);
                }
                if (response.getStatusCodeValue() != 200) {
                    throw new IOException(response.toString());
                }
                return new Resource((String)response.getBody(), "UTF-8");
            }
        }
    }
}

