/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Preconditions;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.io.StreamWrappingOverthereFile;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.events.AttachmentCreatedEvent;
import com.xebialabs.xlrelease.domain.events.AttachmentDeletedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.AttachmentRepository;
import com.xebialabs.xlrelease.repository.AttachmentSizeLimiter;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.LockedTaskOperationChecks;
import java.io.InputStream;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AttachmentService {
    private static final Logger logger = LoggerFactory.getLogger(AttachmentService.class);
    private AttachmentRepository attachmentRepository;
    private ReleaseRepository releaseRepository;
    private ArchivingService archivingService;
    private CiIdService ciIdService;
    private XLReleaseEventBus eventBus;

    @Autowired
    public AttachmentService(AttachmentRepository attachmentRepository, ReleaseRepository releaseRepository, ArchivingService archivingService, CiIdService ciIdService, XLReleaseEventBus eventBus) {
        this.attachmentRepository = attachmentRepository;
        this.releaseRepository = releaseRepository;
        this.archivingService = archivingService;
        this.ciIdService = ciIdService;
        this.eventBus = eventBus;
    }

    @Timed
    public Attachment findById(String attachmentId) {
        return this.attachmentRepository.findById(attachmentId);
    }

    @Timed
    public Attachment findByIdIncludingArchived(String attachmentId) {
        try {
            return this.findById(attachmentId);
        }
        catch (NotFoundException e) {
            if (this.archivingService.attachmentExists(attachmentId)) {
                return this.archivingService.getAttachment(attachmentId);
            }
            throw new LogFriendlyNotFoundException(String.format("Attachment [%s] does not exist in the repository or archive", attachmentId), new Object[]{e});
        }
    }

    public void createAttachmentOnReleaseFromActor(Release release, Attachment attachment) {
        this.attachmentRepository.create(release, attachment);
        this.eventBus.publish((XLReleaseEvent)new AttachmentCreatedEvent(release.getId(), attachment));
    }

    public void createAttachmentOnTaskFromActor(Release release, String taskId, Attachment attachment) {
        this.attachmentRepository.create(release, taskId, attachment);
        this.eventBus.publish((XLReleaseEvent)new AttachmentCreatedEvent(taskId, attachment));
    }

    public Attachment attachToRelease(Release release, String filename, String contentType, InputStream bytes) {
        AttachmentSizeLimiter limiter = new AttachmentSizeLimiter(XlrConfig.getInstance().server().upload().maxSize(), bytes);
        StreamWrappingOverthereFile file = new StreamWrappingOverthereFile(filename, (InputStream)((Object)limiter));
        Attachment attachment = new Attachment(file, contentType);
        String attachmentId = this.ciIdService.getUniqueId(Type.valueOf(Attachment.class), release.getId());
        attachment.setId(attachmentId);
        attachment.getExportFilename();
        release.getAttachments().add(attachment);
        return attachment;
    }

    @Timed
    public void deleteAttachment(String releaseId, String attachmentId) {
        Release release = this.findReleaseById(releaseId);
        Set tasksUsingAttachment = release.getTasksUsingAttachment(attachmentId);
        Preconditions.checkState((boolean)tasksUsingAttachment.isEmpty(), (String)"Attachment '%s' is used by tasks : %s", (Object)attachmentId, (Object)tasksUsingAttachment);
        Attachment attachment = this.findById(attachmentId);
        this.attachmentRepository.delete(release, attachment);
        this.eventBus.publish((XLReleaseEvent)new AttachmentDeletedEvent(releaseId, attachment));
    }

    @Timed
    public void deleteAttachmentFromTask(String releaseId, String taskId, String attachmentId) {
        Release release = this.findReleaseById(releaseId);
        Task task = release.getTask(taskId);
        LockedTaskOperationChecks.checkDeleteAttachment(task);
        Preconditions.checkState((!task.isInProgress() ? 1 : 0) != 0, (Object)"Can't delete an attachment from a running task.");
        Set tasksUsingAttachment = release.getTasksUsingAttachment(attachmentId);
        Preconditions.checkState((boolean)tasksUsingAttachment.contains(task), (String)"Attachment '%s' found on release, but not found on task '%s'", (Object)attachmentId, (Object)taskId);
        Attachment attachment = task.getAttachments().stream().filter(at -> attachmentId.equals(at.getId())).findFirst().orElseThrow(() -> new LogFriendlyNotFoundException("Attachment [%s] not found", new Object[]{attachmentId}));
        this.attachmentRepository.delete(task, attachment);
        this.eventBus.publish((XLReleaseEvent)new AttachmentDeletedEvent(taskId, attachment));
    }

    private Release findReleaseById(String releaseId) {
        return this.releaseRepository.findById(releaseId);
    }

    public String insertArtifact(Release release, String artifactName, InputStream content) {
        String artifactId = this.ciIdService.getUniqueId(Type.valueOf(Attachment.class), release.getId());
        AttachmentSizeLimiter limitedContent = new AttachmentSizeLimiter(XlrConfig.getInstance().server().upload().maxSize(), content);
        this.attachmentRepository.insert(release.getCiUid(), artifactId, artifactName, (InputStream)((Object)limitedContent));
        return artifactId;
    }
}

