/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.resource.introspection;

import com.nimbusds.oauth2.sdk.TokenIntrospectionResponse;
import com.nimbusds.oauth2.sdk.TokenIntrospectionSuccessResponse;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.Audience;
import java.net.URI;
import java.net.URL;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minidev.json.JSONObject;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.MediaType;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.core.DefaultOAuth2AuthenticatedPrincipal;
import org.springframework.security.oauth2.core.OAuth2AuthenticatedPrincipal;
import org.springframework.security.oauth2.server.resource.introspection.BadOpaqueTokenException;
import org.springframework.security.oauth2.server.resource.introspection.OAuth2IntrospectionException;
import org.springframework.security.oauth2.server.resource.introspection.ReactiveOpaqueTokenIntrospector;
import org.springframework.util.Assert;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

public class NimbusReactiveOpaqueTokenIntrospector
implements ReactiveOpaqueTokenIntrospector {
    private URI introspectionUri;
    private WebClient webClient;
    private String authorityPrefix = "SCOPE_";

    public NimbusReactiveOpaqueTokenIntrospector(String introspectionUri, String clientId, String clientSecret) {
        Assert.hasText((String)introspectionUri, (String)"introspectionUri cannot be empty");
        Assert.hasText((String)clientId, (String)"clientId cannot be empty");
        Assert.notNull((Object)clientSecret, (String)"clientSecret cannot be null");
        this.introspectionUri = URI.create(introspectionUri);
        this.webClient = WebClient.builder().defaultHeaders(h -> h.setBasicAuth(clientId, clientSecret)).build();
    }

    public NimbusReactiveOpaqueTokenIntrospector(String introspectionUri, WebClient webClient) {
        Assert.hasText((String)introspectionUri, (String)"introspectionUri cannot be null");
        Assert.notNull((Object)webClient, (String)"webClient cannot be null");
        this.introspectionUri = URI.create(introspectionUri);
        this.webClient = webClient;
    }

    @Override
    public Mono<OAuth2AuthenticatedPrincipal> introspect(String token) {
        return Mono.just((Object)token).flatMap(this::makeRequest).flatMap(this::adaptToNimbusResponse).map(this::parseNimbusResponse).map(this::castToNimbusSuccess).doOnNext(response -> this.validate(token, (TokenIntrospectionSuccessResponse)response)).map(this::convertClaimsSet).onErrorMap(e -> !(e instanceof OAuth2IntrospectionException), this::onError);
    }

    private Mono<ClientResponse> makeRequest(String token) {
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri(this.introspectionUri)).header("Accept", new String[]{"application/json;charset=UTF-8"})).body((BodyInserter)BodyInserters.fromFormData((String)"token", (String)token)).exchange();
    }

    private Mono<HTTPResponse> adaptToNimbusResponse(ClientResponse responseEntity) {
        HTTPResponse response = new HTTPResponse(responseEntity.rawStatusCode());
        response.setHeader("Content-Type", new String[]{((MediaType)responseEntity.headers().contentType().get()).toString()});
        if (response.getStatusCode() != 200) {
            return responseEntity.bodyToFlux(DataBuffer.class).map(DataBufferUtils::release).then(Mono.error((Throwable)new OAuth2IntrospectionException("Introspection endpoint responded with " + response.getStatusCode())));
        }
        return responseEntity.bodyToMono(String.class).doOnNext(arg_0 -> ((HTTPResponse)response).setContent(arg_0)).map(body -> response);
    }

    private TokenIntrospectionResponse parseNimbusResponse(HTTPResponse response) {
        try {
            return TokenIntrospectionResponse.parse((HTTPResponse)response);
        }
        catch (Exception ex) {
            throw new OAuth2IntrospectionException(ex.getMessage(), ex);
        }
    }

    private TokenIntrospectionSuccessResponse castToNimbusSuccess(TokenIntrospectionResponse introspectionResponse) {
        if (!introspectionResponse.indicatesSuccess()) {
            throw new OAuth2IntrospectionException("Token introspection failed");
        }
        return (TokenIntrospectionSuccessResponse)introspectionResponse;
    }

    private void validate(String token, TokenIntrospectionSuccessResponse response) {
        if (!response.isActive()) {
            throw new BadOpaqueTokenException("Provided token isn't active");
        }
    }

    private OAuth2AuthenticatedPrincipal convertClaimsSet(TokenIntrospectionSuccessResponse response) {
        JSONObject claims = response.toJSONObject();
        ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
        if (response.getAudience() != null) {
            ArrayList<String> audiences = new ArrayList<String>();
            for (Audience audience : response.getAudience()) {
                audiences.add(audience.getValue());
            }
            claims.put("aud", Collections.unmodifiableList(audiences));
        }
        if (response.getClientID() != null) {
            claims.put("client_id", response.getClientID().getValue());
        }
        if (response.getExpirationTime() != null) {
            Instant exp = response.getExpirationTime().toInstant();
            claims.put("exp", exp);
        }
        if (response.getIssueTime() != null) {
            Instant iat = response.getIssueTime().toInstant();
            claims.put("iat", iat);
        }
        if (response.getIssuer() != null) {
            claims.put("iss", this.issuer(response.getIssuer().getValue()));
        }
        if (response.getNotBeforeTime() != null) {
            claims.put("nbf", response.getNotBeforeTime().toInstant());
        }
        if (response.getScope() != null) {
            List<String> scopes = Collections.unmodifiableList(response.getScope().toStringList());
            claims.put("scope", scopes);
            for (String scope : scopes) {
                authorities.add(new SimpleGrantedAuthority(this.authorityPrefix + scope));
            }
        }
        return new DefaultOAuth2AuthenticatedPrincipal((Map)claims, authorities);
    }

    private URL issuer(String uri) {
        try {
            return new URL(uri);
        }
        catch (Exception ex) {
            throw new OAuth2IntrospectionException("Invalid iss value: " + uri);
        }
    }

    private OAuth2IntrospectionException onError(Throwable e) {
        return new OAuth2IntrospectionException(e.getMessage(), e);
    }
}

