/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonpatch;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonpatch.JsonPatchOperation;
import java.io.IOException;

public abstract class PathValueOperation
extends JsonPatchOperation {
    @JsonSerialize
    protected final JsonNode value;

    protected PathValueOperation(String op, JsonPointer path, JsonNode value) {
        super(op, path);
        this.value = value.deepCopy();
    }

    public final void serialize(JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        jgen.writeStartObject();
        jgen.writeStringField("op", this.op);
        jgen.writeStringField("path", this.path.toString());
        jgen.writeFieldName("value");
        jgen.writeTree((TreeNode)this.value);
        jgen.writeEndObject();
    }

    public final void serializeWithType(JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonProcessingException {
        this.serialize(jgen, provider);
    }

    @Override
    public final String toString() {
        return "op: " + this.op + "; path: \"" + this.path + "\"; value: " + this.value;
    }
}

