/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.lang.Nullable;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public final class OAuth2AuthorizationContext {
    public static final String REQUEST_SCOPE_ATTRIBUTE_NAME = OAuth2AuthorizationContext.class.getName().concat(".REQUEST_SCOPE");
    public static final String USERNAME_ATTRIBUTE_NAME = OAuth2AuthorizationContext.class.getName().concat(".USERNAME");
    public static final String PASSWORD_ATTRIBUTE_NAME = OAuth2AuthorizationContext.class.getName().concat(".PASSWORD");
    private ClientRegistration clientRegistration;
    private OAuth2AuthorizedClient authorizedClient;
    private Authentication principal;
    private Map<String, Object> attributes;

    private OAuth2AuthorizationContext() {
    }

    public ClientRegistration getClientRegistration() {
        return this.clientRegistration;
    }

    @Nullable
    public OAuth2AuthorizedClient getAuthorizedClient() {
        return this.authorizedClient;
    }

    public Authentication getPrincipal() {
        return this.principal;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Nullable
    public <T> T getAttribute(String name) {
        return (T)this.getAttributes().get(name);
    }

    public static Builder withClientRegistration(ClientRegistration clientRegistration) {
        return new Builder(clientRegistration);
    }

    public static Builder withAuthorizedClient(OAuth2AuthorizedClient authorizedClient) {
        return new Builder(authorizedClient);
    }

    public static class Builder {
        private ClientRegistration clientRegistration;
        private OAuth2AuthorizedClient authorizedClient;
        private Authentication principal;
        private Map<String, Object> attributes;

        private Builder(ClientRegistration clientRegistration) {
            Assert.notNull((Object)clientRegistration, (String)"clientRegistration cannot be null");
            this.clientRegistration = clientRegistration;
        }

        private Builder(OAuth2AuthorizedClient authorizedClient) {
            Assert.notNull((Object)authorizedClient, (String)"authorizedClient cannot be null");
            this.authorizedClient = authorizedClient;
        }

        public Builder principal(Authentication principal) {
            this.principal = principal;
            return this;
        }

        public Builder attributes(Consumer<Map<String, Object>> attributesConsumer) {
            if (this.attributes == null) {
                this.attributes = new HashMap<String, Object>();
            }
            attributesConsumer.accept(this.attributes);
            return this;
        }

        public Builder attribute(String name, Object value) {
            if (this.attributes == null) {
                this.attributes = new HashMap<String, Object>();
            }
            this.attributes.put(name, value);
            return this;
        }

        public OAuth2AuthorizationContext build() {
            Assert.notNull((Object)this.principal, (String)"principal cannot be null");
            OAuth2AuthorizationContext context = new OAuth2AuthorizationContext();
            if (this.authorizedClient != null) {
                context.clientRegistration = this.authorizedClient.getClientRegistration();
                context.authorizedClient = this.authorizedClient;
            } else {
                context.clientRegistration = this.clientRegistration;
            }
            context.principal = this.principal;
            context.attributes = Collections.unmodifiableMap(CollectionUtils.isEmpty(this.attributes) ? Collections.emptyMap() : new LinkedHashMap<String, Object>(this.attributes));
            return context;
        }
    }
}

