/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.platform.sso.oidc.user;

import com.xebialabs.platform.sso.oidc.user.CustomOAuth2User;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.core.oidc.OidcIdToken;
import org.springframework.security.oauth2.core.oidc.OidcUserInfo;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.util.Assert;

public class CustomOidcUser
extends CustomOAuth2User
implements OidcUser {
    private final OidcIdToken idToken;
    private final OidcUserInfo userInfo;

    public CustomOidcUser(Collection<? extends GrantedAuthority> authorities, OidcIdToken idToken) {
        this(authorities, idToken, "sub");
    }

    public CustomOidcUser(Collection<? extends GrantedAuthority> authorities, OidcIdToken idToken, String nameAttributeKey) {
        this(authorities, idToken, null, nameAttributeKey);
    }

    public CustomOidcUser(Collection<? extends GrantedAuthority> authorities, OidcIdToken idToken, OidcUserInfo userInfo) {
        this(authorities, idToken, userInfo, "sub");
    }

    public CustomOidcUser(Collection<? extends GrantedAuthority> authorities, OidcIdToken idToken, OidcUserInfo userInfo, String nameAttributeKey) {
        super(authorities, CustomOidcUser.collectClaims(idToken, userInfo), nameAttributeKey);
        this.idToken = idToken;
        this.userInfo = userInfo;
    }

    private static Map<String, Object> collectClaims(OidcIdToken idToken, OidcUserInfo userInfo) {
        Assert.notNull((Object)idToken, (String)"idToken cannot be null");
        HashMap<String, Object> claims = new HashMap<String, Object>();
        if (userInfo != null) {
            claims.putAll(userInfo.getClaims());
        }
        claims.putAll(idToken.getClaims());
        return claims;
    }

    public Map<String, Object> getClaims() {
        return this.getAttributes();
    }

    public OidcIdToken getIdToken() {
        return this.idToken;
    }

    public OidcUserInfo getUserInfo() {
        return this.userInfo;
    }
}

