/*
 * Decompiled with CFR 0.152.
 */
package akka.remote.artery.compress;

import akka.actor.Address;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.remote.artery.ArterySettings;
import akka.remote.artery.InboundContext;
import akka.remote.artery.OutboundContext;
import akka.remote.artery.compress.CompressionTable;
import akka.remote.artery.compress.CountMinSketch;
import akka.remote.artery.compress.DecompressionTable;
import akka.remote.artery.compress.DecompressionTable$;
import akka.remote.artery.compress.InboundCompression$;
import akka.remote.artery.compress.InboundCompression$Tables$;
import akka.remote.artery.compress.TopHeavyHitters;
import akka.remote.artery.compress.UnknownCompressedIdException;
import akka.util.OptionVal;
import akka.util.OptionVal$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Builder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\rMtAB!C\u0011\u00031%J\u0002\u0004M\u0005\"\u0005a)\u0014\u0005\u0006)\u0006!\tA\u0016\u0005\b/\u0006\u0011\r\u0011\"\u0002Y\u0011\u0019Y\u0016\u0001)A\u00073\u001e)A,\u0001E\u0001;\u001a)q,\u0001E\u0001A\")AK\u0002C\u0001I\")QM\u0002C\u0001M\"I!q\u0002\u0004\u0002\u0002\u0013\u0005%\u0011\u0003\u0005\n\u0005[1\u0011\u0011!CA\u0005_A\u0011B!\u0014\u0007\u0003\u0003%IAa\u0014\u0007\t}\u000b!)\u001b\u0005\t]2\u0011)\u001a!C\u0001_\"I\u0011Q\u0003\u0007\u0003\u0012\u0003\u0006I\u0001\u001d\u0005\u000b\u0003/a!Q3A\u0005\u0002\u0005e\u0001\"CA\u000e\u0019\tE\t\u0015!\u0003}\u0011)\ti\u0002\u0004BK\u0002\u0013\u0005\u0011\u0011\u0004\u0005\n\u0003?a!\u0011#Q\u0001\nqD!\"!\t\r\u0005+\u0007I\u0011AA\u0012\u0011)\t\t\u0004\u0004B\tB\u0003%\u0011Q\u0005\u0005\u000b\u0003ga!Q3A\u0005\u0002\u0005U\u0002BCA\u001f\u0019\tE\t\u0015!\u0003\u00028!1A\u000b\u0004C\u0001\u0003\u007fAq!!\u0014\r\t\u0003\ty\u0005C\u0004\u0002b1!\t!a\u0019\t\u0013\u0005\u0015D\"!A\u0005\u0002\u0005\u001d\u0004\"CAB\u0019E\u0005I\u0011AAC\u0011%\ty\nDI\u0001\n\u0003\t\t\u000bC\u0005\u0002*2\t\n\u0011\"\u0001\u0002,\"I\u0011q\u0016\u0007\u0012\u0002\u0013\u0005\u0011\u0011\u0017\u0005\n\u0003sc\u0011\u0013!C\u0001\u0003wC\u0011\"a1\r\u0003\u0003%\t%!2\t\u0013\u0005]G\"!A\u0005\u0002\u0005U\u0002\"CAm\u0019\u0005\u0005I\u0011AAn\u0011%\t\t\u000fDA\u0001\n\u0003\n\u0019\u000fC\u0005\u0002r2\t\t\u0011\"\u0001\u0002t\"I\u0011Q \u0007\u0002\u0002\u0013\u0005\u0013q \u0005\n\u0005\u0003a\u0011\u0011!C!\u0005\u0007A\u0011B!\u0002\r\u0003\u0003%\tEa\u0002\u0007\u000f1\u0013\u0015\u0011\u0001$\u0003X!Q!1\f\u0015\u0003\u0006\u0004%\tA!\u0018\t\u0015\t-\u0004F!A!\u0002\u0013\u0011y\u0006\u0003\u0006\u0003n!\u0012)\u0019!C\u0001\u0005_B!B!!)\u0005\u0003\u0005\u000b\u0011\u0002B9\u0011)\u0011\u0019\t\u000bBC\u0002\u0013\u0005!Q\u0011\u0005\u000b\u0005\u001bC#\u0011!Q\u0001\n\t\u001d\u0005B\u0003BHQ\t\u0005\t\u0015!\u0003\u0003\u0012\"Q!q\u0013\u0015\u0003\u0006\u0004%\tA!'\t\u0015\t5\u0006F!A!\u0002\u0013\u0011Y\n\u0003\u0004UQ\u0011\u0005!q\u0016\u0005\t\u0005{C\u0003\u0015)\u0003\u0003@\"A!1\u0019\u0015!B\u0013\t)\u0010\u0003\u0005\u0003N\"\u0002\u000b\u0015BA\u001c\u0011!\u0011y\r\u000bQ\u0001\n\u0005]\u0002\u0002\u0003BiQ\u0001\u0006IAa5\t\u000f\te\u0007F\"\u0001\u0003\\\"9!Q\u001e\u0015\u0005\u0006\t=\bbBB\u0002Q\u0011\u00151Q\u0001\u0005\b\u0007+AC\u0011AB\f\u0011\u001d\u0019I\u0004\u000bC\u0005\u0007wA\u0001ba\u0011)\t\u000315Q\t\u0005\b\u0007\u000fBc\u0011CB%\u0011\u001d\u0019Y\u0006\u000bC\u0005\u0007;BqA!\u0001)\t\u0003\u001a\u0019'\u0001\nJ]\n|WO\u001c3D_6\u0004(/Z:tS>t'BA\"E\u0003!\u0019w.\u001c9sKN\u001c(BA#G\u0003\u0019\t'\u000f^3ss*\u0011q\tS\u0001\u0007e\u0016lw\u000e^3\u000b\u0003%\u000bA!Y6lCB\u00111*A\u0007\u0002\u0005\n\u0011\u0012J\u001c2pk:$7i\\7qe\u0016\u001c8/[8o'\t\ta\n\u0005\u0002P%6\t\u0001KC\u0001R\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0006K\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\t!*A\nLK\u0016\u0004x\n\u001c3UC\ndWm\u001d(v[\n,'/F\u0001Z\u001f\u0005QV$A\u0002\u0002)-+W\r](mIR\u000b'\r\\3t\u001dVl'-\u001a:!\u0003\u0019!\u0016M\u00197fgB\u0011aLB\u0007\u0002\u0003\t1A+\u00192mKN\u001c2A\u0002(b!\ty%-\u0003\u0002d!\na1+\u001a:jC2L'0\u00192mKR\tQ,A\u0003f[B$\u00180F\u0002h\u0005\u001b)\u0012\u0001\u001b\t\u0005=2\u0011Y!F\u0002k\u0003\u0007\u0019B\u0001\u0004(lCB\u0011q\n\\\u0005\u0003[B\u0013q\u0001\u0015:pIV\u001cG/A\u0005pY\u0012$\u0016M\u00197fgV\t\u0001\u000fE\u0002rsrt!A]<\u000f\u0005M4X\"\u0001;\u000b\u0005U,\u0016A\u0002\u001fs_>$h(C\u0001R\u0013\tA\b+A\u0004qC\u000e\\\u0017mZ3\n\u0005i\\(\u0001\u0002'jgRT!\u0001\u001f)\u0011\u0007-kx0\u0003\u0002\u007f\u0005\n\u0011B)Z2p[B\u0014Xm]:j_:$\u0016M\u00197f!\u0011\t\t!a\u0001\r\u0001\u00119\u0011Q\u0001\u0007C\u0002\u0005\u001d!!\u0001+\u0012\t\u0005%\u0011q\u0002\t\u0004\u001f\u0006-\u0011bAA\u0007!\n9aj\u001c;iS:<\u0007cA(\u0002\u0012%\u0019\u00111\u0003)\u0003\u0007\u0005s\u00170\u0001\u0006pY\u0012$\u0016M\u00197fg\u0002\n1\"Y2uSZ,G+\u00192mKV\tA0\u0001\u0007bGRLg/\u001a+bE2,\u0007%A\u0005oKb$H+\u00192mK\u0006Qa.\u001a=u)\u0006\u0014G.\u001a\u0011\u0002/\u0005$g/\u001a:uSN,W.\u001a8u\u0013:\u0004&o\\4sKN\u001cXCAA\u0013!\u0015y\u0015qEA\u0016\u0013\r\tI\u0003\u0015\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t-\u000bic`\u0005\u0004\u0003_\u0011%\u0001E\"p[B\u0014Xm]:j_:$\u0016M\u00197f\u0003a\tGM^3si&\u001cX-\\3oi&s\u0007K]8he\u0016\u001c8\u000fI\u0001\u000eW\u0016,\u0007o\u00147e)\u0006\u0014G.Z:\u0016\u0005\u0005]\u0002cA(\u0002:%\u0019\u00111\b)\u0003\u0007%sG/\u0001\blK\u0016\u0004x\n\u001c3UC\ndWm\u001d\u0011\u0015\u0019\u0005\u0005\u00131IA#\u0003\u000f\nI%a\u0013\u0011\u0007ycq\u0010C\u0003o/\u0001\u0007\u0001\u000f\u0003\u0004\u0002\u0018]\u0001\r\u0001 \u0005\u0007\u0003;9\u0002\u0019\u0001?\t\u000f\u0005\u0005r\u00031\u0001\u0002&!9\u00111G\fA\u0002\u0005]\u0012aC:fY\u0016\u001cG\u000fV1cY\u0016$B!!\u0015\u0002^A)\u00111KA-y6\u0011\u0011Q\u000b\u0006\u0004\u0003/B\u0015\u0001B;uS2LA!a\u0017\u0002V\tIq\n\u001d;j_:4\u0016\r\u001c\u0005\b\u0003?B\u0002\u0019AA\u001c\u0003\u001d1XM]:j_:\f1c\u001d;beR,6/\u001b8h\u001d\u0016DH\u000fV1cY\u0016$\"!!\u0011\u0002\t\r|\u0007/_\u000b\u0005\u0003S\ny\u0007\u0006\u0007\u0002l\u0005E\u0014qOA=\u0003w\n\t\t\u0005\u0003_\u0019\u00055\u0004\u0003BA\u0001\u0003_\"q!!\u0002\u001b\u0005\u0004\t9\u0001\u0003\u0005o5A\u0005\t\u0019AA:!\u0011\t\u00180!\u001e\u0011\t-k\u0018Q\u000e\u0005\n\u0003/Q\u0002\u0013!a\u0001\u0003kB\u0011\"!\b\u001b!\u0003\u0005\r!!\u001e\t\u0013\u0005\u0005\"\u0004%AA\u0002\u0005u\u0004#B(\u0002(\u0005}\u0004#B&\u0002.\u00055\u0004\"CA\u001a5A\u0005\t\u0019AA\u001c\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*B!a\"\u0002\u001eV\u0011\u0011\u0011\u0012\u0016\u0004a\u0006-5FAAG!\u0011\ty)!'\u000e\u0005\u0005E%\u0002BAJ\u0003+\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005]\u0005+\u0001\u0006b]:|G/\u0019;j_:LA!a'\u0002\u0012\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0005\u000f\u0005\u00151D1\u0001\u0002\b\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012T\u0003BAR\u0003O+\"!!*+\u0007q\fY\tB\u0004\u0002\u0006q\u0011\r!a\u0002\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU!\u00111UAW\t\u001d\t)!\bb\u0001\u0003\u000f\tabY8qs\u0012\"WMZ1vYR$C'\u0006\u0003\u00024\u0006]VCAA[U\u0011\t)#a#\u0005\u000f\u0005\u0015aD1\u0001\u0002\b\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012*T\u0003BA_\u0003\u0003,\"!a0+\t\u0005]\u00121\u0012\u0003\b\u0003\u000by\"\u0019AA\u0004\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011q\u0019\t\u0005\u0003\u0013\f\u0019.\u0004\u0002\u0002L*!\u0011QZAh\u0003\u0011a\u0017M\\4\u000b\u0005\u0005E\u0017\u0001\u00026bm\u0006LA!!6\u0002L\n11\u000b\u001e:j]\u001e\fA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\u0010\u0005u\u0007\"CApE\u0005\u0005\t\u0019AA\u001c\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011Q\u001d\t\u0007\u0003O\fi/a\u0004\u000e\u0005\u0005%(bAAv!\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005=\u0018\u0011\u001e\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002v\u0006m\bcA(\u0002x&\u0019\u0011\u0011 )\u0003\u000f\t{w\u000e\\3b]\"I\u0011q\u001c\u0013\u0002\u0002\u0003\u0007\u0011qB\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011qG\u0001\ti>\u001cFO]5oOR\u0011\u0011qY\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005U(\u0011\u0002\u0005\n\u0003?<\u0013\u0011!a\u0001\u0003\u001f\u0001B!!\u0001\u0003\u000e\u00119\u0011Q\u0001\u0005C\u0002\u0005\u001d\u0011!B1qa2LX\u0003\u0002B\n\u00053!BB!\u0006\u0003\u001c\t\u0005\"1\u0005B\u0013\u0005W\u0001BA\u0018\u0007\u0003\u0018A!\u0011\u0011\u0001B\r\t\u001d\t)!\u0003b\u0001\u0003\u000fAaA\\\u0005A\u0002\tu\u0001\u0003B9z\u0005?\u0001BaS?\u0003\u0018!9\u0011qC\u0005A\u0002\t}\u0001bBA\u000f\u0013\u0001\u0007!q\u0004\u0005\b\u0003CI\u0001\u0019\u0001B\u0014!\u0015y\u0015q\u0005B\u0015!\u0015Y\u0015Q\u0006B\f\u0011\u001d\t\u0019$\u0003a\u0001\u0003o\tq!\u001e8baBd\u00170\u0006\u0003\u00032\t\u0005C\u0003\u0002B\u001a\u0005\u000f\u0002RaTA\u0014\u0005k\u0001Rb\u0014B\u001c\u0005w\u0011iD!\u0010\u0003D\u0005]\u0012b\u0001B\u001d!\n1A+\u001e9mKV\u0002B!]=\u0003>A!1* B !\u0011\t\tA!\u0011\u0005\u000f\u0005\u0015!B1\u0001\u0002\bA)q*a\n\u0003FA)1*!\f\u0003@!I!\u0011\n\u0006\u0002\u0002\u0003\u0007!1J\u0001\u0004q\u0012\u0002\u0004\u0003\u00020\r\u0005\u007f\t1B]3bIJ+7o\u001c7wKR\u0011!\u0011\u000b\t\u0005\u0003\u0013\u0014\u0019&\u0003\u0003\u0003V\u0005-'AB(cU\u0016\u001cG/\u0006\u0003\u0003Z\t\r6C\u0001\u0015O\u0003\rawnZ\u000b\u0003\u0005?\u0002BA!\u0019\u0003h5\u0011!1\r\u0006\u0004\u0005KB\u0015!B3wK:$\u0018\u0002\u0002B5\u0005G\u0012a\u0002T8hO&tw-\u00113baR,'/\u0001\u0003m_\u001e\u0004\u0013\u0001C:fiRLgnZ:\u0016\u0005\tE\u0004\u0003\u0002B:\u0005wrAA!\u001e\u0003x5\tA)C\u0002\u0003z\u0011\u000ba\"\u0011:uKJL8+\u001a;uS:<7/\u0003\u0003\u0003~\t}$aC\"p[B\u0014Xm]:j_:T1A!\u001fE\u0003%\u0019X\r\u001e;j]\u001e\u001c\b%A\u0005pe&<\u0017N\\+jIV\u0011!q\u0011\t\u0004\u001f\n%\u0015b\u0001BF!\n!Aj\u001c8h\u0003)y'/[4j]VKG\rI\u0001\u000fS:\u0014w.\u001e8e\u0007>tG/\u001a=u!\u0011\u0011)Ha%\n\u0007\tUEI\u0001\bJ]\n|WO\u001c3D_:$X\r\u001f;\u0002\u0019!,\u0017M^=ISR$XM]:\u0016\u0005\tm\u0005#B&\u0003\u001e\n\u0005\u0016b\u0001BP\u0005\nyAk\u001c9IK\u00064\u0018\u0010S5ui\u0016\u00148\u000f\u0005\u0003\u0002\u0002\t\rFaBA\u0003Q\t\u0007!QU\t\u0005\u0005O\u000by\u0001E\u0002P\u0005SK1Aa+Q\u0005\u0011qU\u000f\u001c7\u0002\u001b!,\u0017M^=ISR$XM]:!)1\u0011\tLa-\u00036\n]&\u0011\u0018B^!\u0011Y\u0005F!)\t\u000f\tm#\u00071\u0001\u0003`!9!Q\u000e\u001aA\u0002\tE\u0004b\u0002BBe\u0001\u0007!q\u0011\u0005\b\u0005\u001f\u0013\u0004\u0019\u0001BI\u0011\u001d\u00119J\ra\u0001\u00057\u000ba\u0001^1cY\u0016\u001c\b#\u0002Ba\u0019\t\u0005fBA&\u0001\u0003\u0015\tG.\u001b<fQ\r!$q\u0019\t\u0004\u001f\n%\u0017b\u0001Bf!\nAao\u001c7bi&dW-A\u0006sKN,g\u000eZ\"pk:$\u0018AD7bqJ+7/\u001a8e\u0007>,h\u000e^\u0001\u0004G6\u001c\bcA&\u0003V&\u0019!q\u001b\"\u0003\u001d\r{WO\u001c;NS:\u001c6.\u001a;dQ\u0006QA-Z2p[B\u0014Xm]:\u0015\r\tu'q\u001cBu!\u0019\t\u0019&!\u0017\u0003\"\"9!\u0011\u001d\u001dA\u0002\t\r\u0018\u0001F5oG>l\u0017N\\4UC\ndWMV3sg&|g\u000eE\u0002P\u0005KL1Aa:Q\u0005\u0011\u0011\u0015\u0010^3\t\u000f\t-\b\b1\u0001\u00028\u0005\u0019\u0011\u000e\u001a=\u0002%\u0011,7m\\7qe\u0016\u001c8/\u00138uKJt\u0017\r\u001c\u000b\t\u0005;\u0014\tPa=\u0003v\"9!\u0011]\u001dA\u0002\t\r\bb\u0002Bvs\u0001\u0007\u0011q\u0007\u0005\b\u0005oL\u0004\u0019AA\u001c\u00039\tG\u000f^3naR\u001cu.\u001e8uKJD3!\u000fB~!\u0011\u0011iPa@\u000e\u0005\u0005U\u0015\u0002BB\u0001\u0003+\u0013q\u0001^1jYJ,7-\u0001\u000bd_:4\u0017N]7BIZ,'\u000f^5tK6,g\u000e\u001e\u000b\u0007\u0007\u000f\u0019ia!\u0005\u0011\u0007=\u001bI!C\u0002\u0004\fA\u0013A!\u00168ji\"91q\u0002\u001eA\u0002\t\r\u0018\u0001\u0004;bE2,g+\u001a:tS>t\u0007bBB\nu\u0001\u0007\u0011Q_\u0001\u0007O\u00064X-\u00169\u0002\u0013%t7M]3nK:$H\u0003CB\u0004\u00073\u0019\td!\u000e\t\u000f\rm1\b1\u0001\u0004\u001e\u0005i!/Z7pi\u0016\fE\r\u001a:fgN\u0004Baa\b\u0004&5\u00111\u0011\u0005\u0006\u0004\u0007GA\u0015!B1di>\u0014\u0018\u0002BB\u0014\u0007C\u0011q!\u00113ee\u0016\u001c8\u000f\u000b\u0003\u0004\u001a\r-\u0002\u0003BA*\u0007[IAaa\f\u0002V\t1QO\\;tK\u0012Dqaa\r<\u0001\u0004\u0011\t+A\u0003wC2,X\rC\u0004\u00048m\u0002\rAa\"\u0002\u00039\f\u0001%\u00193e\u0003:$7\t[3dW&3\u0007.Z1ws\"KG\u000f^3s\t\u0016$Xm\u0019;fIR1\u0011Q_B\u001f\u0007\u007fAqaa\r=\u0001\u0004\u0011\t\u000bC\u0004\u0004Bq\u0002\rAa\"\u0002\u000b\r|WO\u001c;\u00023I,hNT3yiR\u000b'\r\\3BIZ,'\u000f^5tK6,g\u000e\u001e\u000b\u0003\u0007\u000f\t\u0011$\u00193wKJ$\u0018n]3D_6\u0004(/Z:tS>tG+\u00192mKR11qAB&\u0007+Bqa!\u0014?\u0001\u0004\u0019y%A\u0006bgN|7-[1uS>t\u0007\u0003\u0002B;\u0007#J1aa\u0015E\u0005=yU\u000f\u001e2pk:$7i\u001c8uKb$\bbBB,}\u0001\u00071\u0011L\u0001\u0006i\u0006\u0014G.\u001a\t\u0006\u0017\u00065\"\u0011U\u0001 aJ,\u0007/\u0019:f\u0007>l\u0007O]3tg&|g.\u00113wKJ$\u0018n]3nK:$H\u0003BB-\u0007?Bqa!\u0019@\u0001\u0004\u0011\u0019/\u0001\toKb$H+\u00192mKZ+'o]5p]R\u00111Q\r\t\u0005\u0007O\u001ayG\u0004\u0003\u0004j\r-\u0004CA:Q\u0013\r\u0019i\u0007U\u0001\u0007!J,G-\u001a4\n\t\u0005U7\u0011\u000f\u0006\u0004\u0007[\u0002\u0006")
public abstract class InboundCompression<T> {
    private final LoggingAdapter log;
    private final ArterySettings.Compression settings;
    private final long originUid;
    private final InboundContext inboundContext;
    private final TopHeavyHitters<T> heavyHitters;
    private Tables<T> tables;
    private volatile boolean alive;
    private int resendCount;
    private final int maxResendCount;
    private final CountMinSketch cms;

    public static int KeepOldTablesNumber() {
        return InboundCompression$.MODULE$.KeepOldTablesNumber();
    }

    public LoggingAdapter log() {
        return this.log;
    }

    public ArterySettings.Compression settings() {
        return this.settings;
    }

    public long originUid() {
        return this.originUid;
    }

    public TopHeavyHitters<T> heavyHitters() {
        return this.heavyHitters;
    }

    public abstract T decompress(byte var1, int var2);

    public final T decompressInternal(byte incomingTableVersion, int idx, int attemptCounter) {
        Object object;
        block5: {
            Object object2;
            block6: {
                byte activeVersion;
                Tables<T> current;
                while (true) {
                    if (attemptCounter > 2) {
                        throw new IllegalStateException(new StringBuilder(52).append("Unable to decompress ").append(idx).append(" from table ").append(incomingTableVersion).append(". Internal tables: ").append(this.tables).toString());
                    }
                    current = this.tables;
                    activeVersion = current.activeTable().version();
                    if (incomingTableVersion == DecompressionTable$.MODULE$.DisabledVersion()) {
                        OptionVal$.MODULE$.None();
                        object = null;
                        break block5;
                    }
                    DecompressionTable<T> decompressionTable = current.selectTable(incomingTableVersion);
                    DecompressionTable decompressionTable2 = (DecompressionTable)OptionVal.Some$.MODULE$.unapply(decompressionTable);
                    if (!OptionVal$.MODULE$.isEmpty$extension((Object)decompressionTable2)) {
                        DecompressionTable selectedTable = (DecompressionTable)OptionVal$.MODULE$.get$extension((Object)decompressionTable2);
                        Object value = selectedTable.get(idx);
                        if (value == null) {
                            throw new UnknownCompressedIdException(idx);
                        }
                        object2 = OptionVal.Some$.MODULE$.apply(value);
                        break block6;
                    }
                    if (!InboundCompression.incomingVersionIsAdvertisementInProgress$1(incomingTableVersion, current)) break;
                    this.log().debug("Received first value from originUid [{}] compressed using the advertised compression table, flipping to it (version: {})", (Object)BoxesRunTime.boxToLong((long)this.originUid()), (Object)BoxesRunTime.boxToByte((byte)current.nextTable().version()));
                    this.confirmAdvertisement(incomingTableVersion, false);
                    ++attemptCounter;
                }
                this.log().warning("Inbound message from originUid [{}] is using unknown compression table version. It may have been sent with compression table built for previous incarnation of this system. Versions activeTable: {}, nextTable: {}, incomingTable: {}", (Object)BoxesRunTime.boxToLong((long)this.originUid()), (Object)BoxesRunTime.boxToByte((byte)activeVersion), (Object)BoxesRunTime.boxToByte((byte)current.nextTable().version()), (Object)BoxesRunTime.boxToByte((byte)incomingTableVersion));
                OptionVal$.MODULE$.None();
                object2 = null;
            }
            object = object2;
        }
        return (T)object;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void confirmAdvertisement(byte tableVersion, boolean gaveUp) {
        CompressionTable inProgress;
        boolean bl = false;
        Some some = null;
        Option<CompressionTable<T>> option = this.tables.advertisementInProgress();
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            CompressionTable inProgress2 = (CompressionTable)some.value();
            if (tableVersion == inProgress2.version()) {
                this.tables = this.tables.startUsingNextTable();
                this.log().debug("{} compression table version [{}] for originUid [{}]", (Object)(gaveUp ? "Gave up" : "Confirmed"), (Object)BoxesRunTime.boxToByte((byte)tableVersion), (Object)BoxesRunTime.boxToLong((long)this.originUid()));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (bl && tableVersion != (inProgress = (CompressionTable)some.value()).version()) {
            this.log().debug("{} compression table version [{}] for originUid [{}] but other version in progress [{}]", (Object)(gaveUp ? "Gave up" : "Confirmed"), (Object)BoxesRunTime.boxToByte((byte)tableVersion), (Object)BoxesRunTime.boxToLong((long)this.originUid()), (Object)BoxesRunTime.boxToByte((byte)inProgress.version()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public void increment(Address remoteAddress, T value, long n) {
        long count = this.cms.addObjectAndEstimateCount(value, n);
        this.addAndCheckIfheavyHitterDetected(value, count);
        this.alive = true;
    }

    private boolean addAndCheckIfheavyHitterDetected(T value, long count) {
        return this.heavyHitters().update(value, count);
    }

    public void runNextTableAdvertisement() {
        Option<CompressionTable<T>> option = this.tables.advertisementInProgress();
        if (None$.MODULE$.equals(option)) {
            OutboundContext outboundContext = this.inboundContext.association(this.originUid());
            OutboundContext outboundContext2 = (OutboundContext)OptionVal.Some$.MODULE$.unapply((Object)outboundContext);
            if (!OptionVal$.MODULE$.isEmpty$extension((Object)outboundContext2)) {
                BoxedUnit boxedUnit;
                OutboundContext association = (OutboundContext)OptionVal$.MODULE$.get$extension((Object)outboundContext2);
                if (this.alive && association.isOrdinaryMessageStreamActive()) {
                    CompressionTable<T> table = this.prepareCompressionAdvertisement(this.tables.nextTable().version());
                    Tables<T> qual$1 = this.tables;
                    DecompressionTable<T> x$1 = table.invert();
                    Some x$2 = new Some(table);
                    List<DecompressionTable<T>> x$3 = qual$1.copy$default$1();
                    DecompressionTable<T> x$4 = qual$1.copy$default$2();
                    int x$5 = qual$1.copy$default$5();
                    Tables<T> nextState = qual$1.copy(x$3, x$4, x$1, (Option<CompressionTable<T>>)x$2, x$5);
                    this.tables = nextState;
                    this.alive = false;
                    this.resendCount = 0;
                    this.advertiseCompressionTable(association, table);
                    boxedUnit = BoxedUnit.UNIT;
                } else if (association.isOrdinaryMessageStreamActive()) {
                    this.log().debug("{} for originUid [{}] not changed, no need to advertise same.", (Object)Logging$.MODULE$.simpleName(this.tables.activeTable()), (Object)BoxesRunTime.boxToLong((long)this.originUid()));
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else {
                OptionVal$.MODULE$.None();
                OutboundContext outboundContext3 = outboundContext;
                if (!(null != null ? !((Object)null).equals(outboundContext3) : outboundContext3 != null)) {
                    this.log().debug("No Association for originUid [{}] yet, unable to advertise compression table.", (Object)BoxesRunTime.boxToLong((long)this.originUid()));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)new OptionVal((Object)outboundContext));
                }
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            CompressionTable inProgress = (CompressionTable)some.value();
            ++this.resendCount;
            if (this.resendCount <= this.maxResendCount) {
                OutboundContext outboundContext = this.inboundContext.association(this.originUid());
                OutboundContext outboundContext4 = (OutboundContext)OptionVal.Some$.MODULE$.unapply((Object)outboundContext);
                if (!OptionVal$.MODULE$.isEmpty$extension((Object)outboundContext4)) {
                    OutboundContext association = (OutboundContext)OptionVal$.MODULE$.get$extension((Object)outboundContext4);
                    this.log().debug("Advertisement in progress for originUid [{}] version [{}], resending [{}:{}]", (Object)BoxesRunTime.boxToLong((long)this.originUid()), (Object)BoxesRunTime.boxToByte((byte)inProgress.version()), (Object)BoxesRunTime.boxToInteger((int)this.resendCount), (Object)BoxesRunTime.boxToInteger((int)this.maxResendCount));
                    this.advertiseCompressionTable(association, inProgress);
                    BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                } else {
                    OptionVal$.MODULE$.None();
                    OutboundContext outboundContext5 = outboundContext;
                    if (!(null != null ? !((Object)null).equals(outboundContext5) : outboundContext5 != null)) {
                        BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
                    } else {
                        throw new MatchError((Object)new OptionVal((Object)outboundContext));
                    }
                }
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.log().debug("Advertisement in progress for originUid [{}] version [{}] but no confirmation after retries.", (Object)BoxesRunTime.boxToLong((long)this.originUid()), (Object)BoxesRunTime.boxToByte((byte)inProgress.version()));
                this.confirmAdvertisement(inProgress.version(), true);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit5 = boxedUnit;
        } else {
            throw new MatchError(option);
        }
    }

    public abstract void advertiseCompressionTable(OutboundContext var1, CompressionTable<T> var2);

    private CompressionTable<T> prepareCompressionAdvertisement(byte nextTableVersion) {
        Builder mb = Predef$.MODULE$.Map().newBuilder();
        mb.$plus$plus$eq((TraversableOnce)this.heavyHitters().iterator().zipWithIndex());
        Map mappings = (Map)mb.result();
        return new CompressionTable(this.originUid(), nextTableVersion, mappings);
    }

    public String toString() {
        return new StringBuilder(34).append(Logging$.MODULE$.simpleName(this.getClass())).append("(countMinSketch: ").append(this.cms).append(", heavyHitters: ").append(this.heavyHitters()).append(")").toString();
    }

    private static final boolean incomingVersionIsAdvertisementInProgress$1(byte incomingTableVersion, Tables current$1) {
        return current$1.advertisementInProgress().isDefined() && incomingTableVersion == ((CompressionTable)current$1.advertisementInProgress().get()).version();
    }

    public InboundCompression(LoggingAdapter log, ArterySettings.Compression settings, long originUid, InboundContext inboundContext, TopHeavyHitters<T> heavyHitters) {
        this.log = log;
        this.settings = settings;
        this.originUid = originUid;
        this.inboundContext = inboundContext;
        this.heavyHitters = heavyHitters;
        this.tables = InboundCompression$Tables$.MODULE$.empty();
        this.alive = true;
        this.resendCount = 0;
        this.maxResendCount = 3;
        this.cms = new CountMinSketch(16, 1024, (int)System.currentTimeMillis());
        log.debug("Initializing {} for originUid [{}]", (Object)Logging$.MODULE$.simpleName(this.getClass()), (Object)BoxesRunTime.boxToLong((long)originUid));
    }

    public static final class Tables<T>
    implements Product,
    Serializable {
        private final List<DecompressionTable<T>> oldTables;
        private final DecompressionTable<T> activeTable;
        private final DecompressionTable<T> nextTable;
        private final Option<CompressionTable<T>> advertisementInProgress;
        private final int keepOldTables;

        public List<DecompressionTable<T>> oldTables() {
            return this.oldTables;
        }

        public DecompressionTable<T> activeTable() {
            return this.activeTable;
        }

        public DecompressionTable<T> nextTable() {
            return this.nextTable;
        }

        public Option<CompressionTable<T>> advertisementInProgress() {
            return this.advertisementInProgress;
        }

        public int keepOldTables() {
            return this.keepOldTables;
        }

        /*
         * WARNING - void declaration
         */
        public DecompressionTable<T> selectTable(int version) {
            DecompressionTable decompressionTable;
            if (this.activeTable().version() == version) {
                decompressionTable = (DecompressionTable)OptionVal.Some$.MODULE$.apply(this.activeTable());
            } else {
                void var2_2;
                DecompressionTable found = this.find$1(this.oldTables(), version);
                decompressionTable = var2_2;
            }
            return decompressionTable;
        }

        public Tables<T> startUsingNextTable() {
            DecompressionTable<T> decompressionTable = this.activeTable();
            DecompressionTable qual$1 = DecompressionTable$.MODULE$.empty();
            byte x$1 = Tables.incrementTableVersion$1(this.nextTable().version());
            long x$2 = qual$1.copy$default$1();
            Object x$3 = qual$1.copy$default$3();
            return new Tables<T>(this.oldTables().$colon$colon(decompressionTable).take(this.keepOldTables()), this.nextTable(), qual$1.copy(x$2, x$1, x$3), None$.MODULE$, this.keepOldTables());
        }

        public <T> Tables<T> copy(List<DecompressionTable<T>> oldTables, DecompressionTable<T> activeTable, DecompressionTable<T> nextTable, Option<CompressionTable<T>> advertisementInProgress, int keepOldTables) {
            return new Tables<T>(oldTables, activeTable, nextTable, advertisementInProgress, keepOldTables);
        }

        public <T> List<DecompressionTable<T>> copy$default$1() {
            return this.oldTables();
        }

        public <T> DecompressionTable<T> copy$default$2() {
            return this.activeTable();
        }

        public <T> DecompressionTable<T> copy$default$3() {
            return this.nextTable();
        }

        public <T> Option<CompressionTable<T>> copy$default$4() {
            return this.advertisementInProgress();
        }

        public <T> int copy$default$5() {
            return this.keepOldTables();
        }

        public String productPrefix() {
            return "Tables";
        }

        public int productArity() {
            return 5;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.oldTables();
                    break;
                }
                case 1: {
                    object = this.activeTable();
                    break;
                }
                case 2: {
                    object = this.nextTable();
                    break;
                }
                case 3: {
                    object = this.advertisementInProgress();
                    break;
                }
                case 4: {
                    object = BoxesRunTime.boxToInteger((int)this.keepOldTables());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Tables;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash(this.oldTables()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.activeTable()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.nextTable()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.advertisementInProgress()));
            n = Statics.mix((int)n, (int)this.keepOldTables());
            return Statics.finalizeHash((int)n, (int)5);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Tables)) return false;
            boolean bl = true;
            if (!bl) return false;
            Tables tables = (Tables)x$1;
            List<DecompressionTable<T>> list = this.oldTables();
            List<DecompressionTable<T>> list2 = tables.oldTables();
            if (list == null) {
                if (list2 != null) {
                    return false;
                }
            } else if (!list.equals(list2)) return false;
            DecompressionTable<T> decompressionTable = this.activeTable();
            DecompressionTable<T> decompressionTable2 = tables.activeTable();
            if (decompressionTable == null) {
                if (decompressionTable2 != null) {
                    return false;
                }
            } else if (!((Object)decompressionTable).equals(decompressionTable2)) return false;
            DecompressionTable<T> decompressionTable3 = this.nextTable();
            DecompressionTable<T> decompressionTable4 = tables.nextTable();
            if (decompressionTable3 == null) {
                if (decompressionTable4 != null) {
                    return false;
                }
            } else if (!((Object)decompressionTable3).equals(decompressionTable4)) return false;
            Option<CompressionTable<T>> option = this.advertisementInProgress();
            Option<CompressionTable<T>> option2 = tables.advertisementInProgress();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (this.keepOldTables() != tables.keepOldTables()) return false;
            return true;
        }

        private final DecompressionTable find$1(List tables, int version$1) {
            DecompressionTable decompressionTable;
            block2: {
                List list;
                block3: {
                    DecompressionTable t;
                    while (true) {
                        if (Nil$.MODULE$.equals(list = tables)) {
                            OptionVal$.MODULE$.None();
                            decompressionTable = null;
                            break block2;
                        }
                        if (!(list instanceof .colon.colon)) break block3;
                        .colon.colon colon2 = (.colon.colon)list;
                        t = (DecompressionTable)colon2.head();
                        List tail = colon2.tl$access$1();
                        if (t.version() == version$1) break;
                        tables = tail;
                    }
                    decompressionTable = (DecompressionTable)OptionVal.Some$.MODULE$.apply((Object)t);
                    break block2;
                }
                throw new MatchError((Object)list);
            }
            return decompressionTable;
        }

        private static final byte incrementTableVersion$1(byte version) {
            return version == 127 ? (byte)0 : (byte)(version + 1);
        }

        public Tables(List<DecompressionTable<T>> oldTables, DecompressionTable<T> activeTable, DecompressionTable<T> nextTable, Option<CompressionTable<T>> advertisementInProgress, int keepOldTables) {
            this.oldTables = oldTables;
            this.activeTable = activeTable;
            this.nextTable = nextTable;
            this.advertisementInProgress = advertisementInProgress;
            this.keepOldTables = keepOldTables;
            Product.$init$((Product)this);
        }
    }
}

