/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.util;

import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class VariableExpansion {
    private static final Pattern VARIABLE_OR_ESCAPE_PATTERN = Pattern.compile("(?:\\$\\{([^\\}]*):-([^\\}]*)\\})|(?:\\$\\{([^\\}]*)\\})|(?:\\$(\\$))");
    private static final String ESCAPE = "$";
    public static final Resolver ENV_VAR_RESOLVER = prop -> System.getenv(prop);
    public static final Resolver SYS_PROP_RESOLVER = prop -> System.getProperty(prop);

    private VariableExpansion() {
    }

    public static final String expand(String input, Resolver resolver) throws UnresolvedVariableException, IllegalArgumentException, NullPointerException {
        if (resolver == null) {
            throw new NullPointerException("Resolver must be supplied");
        }
        if (input == null) {
            return null;
        }
        return VariableExpansion.expand0(input, resolver, new Stack<String>());
    }

    private static final String expand0(String input, Resolver resolver, Stack<String> stack) {
        Matcher matcher = VARIABLE_OR_ESCAPE_PATTERN.matcher(input);
        StringBuffer result = null;
        while (matcher.find()) {
            if (result == null) {
                result = new StringBuffer();
            }
            VariableExpansion.processMatch(resolver, stack, matcher, result);
        }
        if (result == null) {
            return input;
        }
        matcher.appendTail(result);
        return result.toString();
    }

    private static void processMatch(Resolver resolver, Stack<String> stack, Matcher matcher, StringBuffer result) {
        String var = matcher.group(1);
        if (var != null) {
            String resolved = null;
            try {
                resolved = VariableExpansion.resolve(var, resolver, stack);
            }
            catch (UnresolvedVariableException uve) {
                resolved = matcher.group(2);
            }
            matcher.appendReplacement(result, Matcher.quoteReplacement(resolved));
        } else {
            var = matcher.group(3);
            if (var != null) {
                matcher.appendReplacement(result, Matcher.quoteReplacement(VariableExpansion.resolve(var, resolver, stack)));
            } else {
                String esc = matcher.group(4);
                if (ESCAPE.equals(esc)) {
                    matcher.appendReplacement(result, Matcher.quoteReplacement(ESCAPE));
                } else {
                    throw new IllegalArgumentException(esc);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String resolve(String var, Resolver resolver, Stack<String> stack) {
        if (stack.contains(var)) {
            throw new IllegalArgumentException(String.format("Recursively defined variable '%s', stack=%s", var, stack));
        }
        String result = resolver.resolve(var);
        if (result == null) {
            throw new UnresolvedVariableException("Unable to resolve variable: " + var);
        }
        stack.push(var);
        try {
            String string = VariableExpansion.expand0(result, resolver, stack);
            return string;
        }
        finally {
            stack.pop();
        }
    }

    public static final class UnresolvedVariableException
    extends IllegalArgumentException {
        private static final long serialVersionUID = -4256718043645749788L;

        public UnresolvedVariableException() {
        }

        public UnresolvedVariableException(String s) {
            super(s);
        }
    }

    public static final class MapResolver
    implements Resolver {
        private final Map<String, String> map;

        public MapResolver(Map<String, String> map) {
            this.map = map;
        }

        @Override
        public String resolve(String name) {
            return this.map.get(name);
        }
    }

    @FunctionalInterface
    public static interface Resolver {
        public String resolve(String var1);
    }
}

